/* DUPLICATOR-PRO (PHP MULTI-THREADED BUILD MODE) MYSQL SCRIPT CREATED ON : 2026-01-15 03:40:11 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;

CREATE TABLE IF NOT EXISTS `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(255) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT 0,
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=29 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_duplicator_activity_logs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(100) NOT NULL,
  `sub_type` varchar(100) NOT NULL,
  `severity` int(8) NOT NULL,
  `title` text NOT NULL,
  `data` longtext NOT NULL,
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `version` varchar(30) NOT NULL DEFAULT '',
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `type_idx` (`type`),
  KEY `sub_type_idx` (`sub_type`),
  KEY `severity_idx` (`severity`),
  KEY `created_at` (`created_at`),
  KEY `updated_at` (`updated_at`),
  KEY `version` (`version`)
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_duplicator_backups` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(100) NOT NULL,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `archive_name` varchar(350) NOT NULL DEFAULT '',
  `status` int(11) NOT NULL,
  `flags` set('MANUAL','SCHEDULE','SCHEDULE_RUN_NOW','DB_ONLY','MEDIA_ONLY','HAVE_LOCAL','HAVE_REMOTE','DISASTER_AVAIABLE','DISASTER_SET','CREATED_AFTER_RESTORE','ACTIVE','TEMPLATE','ZIP_ARCHIVE','DUP_ARCHIVE','TEMPORARY') NOT NULL DEFAULT '',
  `package` longtext NOT NULL,
  `version` varchar(30) NOT NULL DEFAULT '',
  `created` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `type_idx` (`type`),
  KEY `hash` (`hash`),
  KEY `flags` (`flags`),
  KEY `version` (`version`),
  KEY `created` (`created`),
  KEY `updated_at` (`updated_at`),
  KEY `status` (`status`),
  KEY `name` (`name`(191)),
  KEY `archive_name` (`archive_name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_duplicator_entities` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(100) NOT NULL,
  `value_1` varchar(255) NOT NULL DEFAULT '',
  `value_2` varchar(255) NOT NULL DEFAULT '',
  `value_3` varchar(255) NOT NULL DEFAULT '',
  `value_4` varchar(255) NOT NULL DEFAULT '',
  `value_5` varchar(255) NOT NULL DEFAULT '',
  `data` longtext NOT NULL,
  `version` varchar(30) NOT NULL DEFAULT '',
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `type_idx` (`type`),
  KEY `created_at` (`created_at`),
  KEY `updated_at` (`updated_at`),
  KEY `version` (`version`),
  KEY `value_1` (`value_1`(191)),
  KEY `value_2` (`value_2`(191)),
  KEY `value_3` (`value_3`(191)),
  KEY `value_4` (`value_4`(191)),
  KEY `value_5` (`value_5`(191))
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_e_events` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `event_data` text DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_at_index` (`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_e_submissions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(60) DEFAULT NULL,
  `hash_id` varchar(60) NOT NULL,
  `main_meta_id` bigint(20) unsigned NOT NULL COMMENT 'Id of main field. to represent the main meta field',
  `post_id` bigint(20) unsigned NOT NULL,
  `referer` varchar(500) NOT NULL,
  `referer_title` varchar(300) DEFAULT NULL,
  `element_id` varchar(20) NOT NULL,
  `form_name` varchar(60) NOT NULL,
  `campaign_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip` varchar(46) NOT NULL,
  `user_agent` text NOT NULL,
  `actions_count` int(11) DEFAULT 0,
  `actions_succeeded_count` int(11) DEFAULT 0,
  `status` varchar(20) NOT NULL,
  `is_read` tinyint(1) NOT NULL DEFAULT 0,
  `meta` text DEFAULT NULL,
  `created_at_gmt` datetime NOT NULL,
  `updated_at_gmt` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `hash_id_unique_index` (`hash_id`),
  KEY `main_meta_id_index` (`main_meta_id`),
  KEY `hash_id_index` (`hash_id`),
  KEY `type_index` (`type`),
  KEY `post_id_index` (`post_id`),
  KEY `element_id_index` (`element_id`),
  KEY `campaign_id_index` (`campaign_id`),
  KEY `user_id_index` (`user_id`),
  KEY `user_ip_index` (`user_ip`),
  KEY `status_index` (`status`),
  KEY `is_read_index` (`is_read`),
  KEY `created_at_gmt_index` (`created_at_gmt`),
  KEY `updated_at_gmt_index` (`updated_at_gmt`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`),
  KEY `referer_index` (`referer`(191)),
  KEY `referer_title_index` (`referer_title`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_e_submissions_actions_log` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) unsigned NOT NULL,
  `action_name` varchar(60) NOT NULL,
  `action_label` varchar(60) DEFAULT NULL,
  `status` varchar(20) NOT NULL,
  `log` text DEFAULT NULL,
  `created_at_gmt` datetime NOT NULL,
  `updated_at_gmt` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `submission_id_index` (`submission_id`),
  KEY `action_name_index` (`action_name`),
  KEY `status_index` (`status`),
  KEY `created_at_gmt_index` (`created_at_gmt`),
  KEY `updated_at_gmt_index` (`updated_at_gmt`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_e_submissions_values` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `key` varchar(60) DEFAULT NULL,
  `value` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `submission_id_index` (`submission_id`),
  KEY `key_index` (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=2821 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=5631 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT 0,
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(255) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT 0,
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`),
  KEY `type_status_author` (`post_type`,`post_status`,`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=725 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

/***** TABLE CREATION END *****/
INSERT IGNORE INTO `wp_users` VALUES 
("1","cb_admin_plus_dental","$wp$2y$10$h9f1P2bO2dGtO7.giQEehu5kE8kg0RCyHC7c8CQVcq7SWzdXNGQW2","cb_admin_plus_dental","clickbizdigital@gmail.com","https://cbpro.com.au/preview/uplusdental","2025-07-25 00:11:53","","0","cb_admin_plus_dental");

INSERT IGNORE INTO `wp_usermeta` VALUES 
("1","1","nickname","cb_admin_plus_dental"),
("2","1","first_name",""),
("3","1","last_name",""),
("4","1","description",""),
("5","1","rich_editing","true"),
("6","1","syntax_highlighting","true"),
("7","1","comment_shortcuts","false"),
("8","1","admin_color","fresh"),
("9","1","use_ssl","0"),
("10","1","show_admin_bar_front","true"),
("11","1","locale",""),
("12","1","wp_capabilities","a:1:{s:13:\"administrator\";b:1;}"),
("13","1","wp_user_level","10"),
("14","1","dismissed_wp_pointers",""),
("15","1","show_welcome_panel","0"),
("17","1","wp_dashboard_quick_press_last_post_id","724"),
("18","1","elementor_introduction","a:3:{s:27:\"ai-get-started-announcement\";b:1;s:59:\"ai_get_started_introduction_site_logo_with_ai_site-settings\";b:1;s:20:\"globals_introduction\";b:1;}"),
("19","1","wp_persisted_preferences","a:3:{s:4:\"core\";a:6:{s:26:\"isComplementaryAreaVisible\";b:1;s:9:\"focusMode\";b:0;s:12:\"fixedToolbar\";b:0;s:15:\"distractionFree\";b:0;s:10:\"editorMode\";s:6:\"visual\";s:10:\"openPanels\";a:4:{i:0;s:11:\"post-status\";i:1;s:36:\"taxonomy-panel-cmsms_doctor_services\";i:2;s:30:\"taxonomy-panel-doctor_services\";i:3;s:21:\"taxonomy-panel-doctor\";}}s:14:\"core/edit-post\";a:2:{s:12:\"welcomeGuide\";b:0;s:14:\"fullscreenMode\";b:0;}s:9:\"_modified\";s:24:\"2025-07-25T06:29:49.269Z\";}"),
("20","1","wp_user-settings","libraryContent=browse&editor=tinymce"),
("21","1","wp_user-settings-time","1766359928"),
("22","1","managenav-menuscolumnshidden","a:5:{i:0;s:11:\"link-target\";i:1;s:11:\"css-classes\";i:2;s:3:\"xfn\";i:3;s:11:\"description\";i:4;s:15:\"title-attribute\";}"),
("23","1","metaboxhidden_nav-menus","a:1:{i:0;s:12:\"add-post_tag\";}"),
("24","1","elementor_dismissed_editor_notices","a:2:{i:0;s:20:\"image_optimizer_hint\";i:1;s:19:\"ally_heading_notice\";}"),
("25","1","nav_menu_recently_edited","10"),
("26","1","community-events-location","a:1:{s:2:\"ip\";s:12:\"37.120.234.0\";}"),
("27","1","session_tokens","a:1:{s:64:\"913c59ee5eeca5809aee99086235c1d7333dc145de137f1cc7c8f40eb846783f\";a:4:{s:10:\"expiration\";i:1768621143;s:2:\"ip\";s:14:\"37.120.234.156\";s:2:\"ua\";s:117:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36\";s:5:\"login\";i:1768448343;}}"),
("28","1","_elementor_structure_popup_dismissed","1");

INSERT IGNORE INTO `wp_comments` VALUES 
("1","1","A WordPress Commenter","wapuu@wordpress.example","https://wordpress.org/","","2025-07-25 00:11:53","2025-07-25 00:11:53","Hi, this is a comment.\nTo get started with moderating, editing, and deleting comments, please visit the Comments screen in the dashboard.\nCommenter avatars come from <a href=\"https://gravatar.com/\">Gravatar</a>.","0","1","","comment","0","0");

INSERT IGNORE INTO `wp_duplicator_activity_logs` VALUES 
("5","websites_scan","scan_start","10","Scan","{\n    \"packageId\": 3,\n    \"packageName\": \"20251117_uplusdental\",\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 0,\n    \"dirCount\": 0,\n    \"size\": 0,\n    \"dbExcluded\": false,\n    \"dbTableCount\": 0,\n    \"dbSize\": 0,\n    \"dbRowCount\": 0\n}","0","4.5.24","2025-11-17 06:53:10","2025-11-17 06:53:10"),
("6","websites_scan","scan_end","10","Scan Completed","{\n    \"packageId\": 3,\n    \"packageName\": \"20251117_uplusdental\",\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 11007,\n    \"dirCount\": 2074,\n    \"size\": 256096011,\n    \"dbExcluded\": false,\n    \"dbTableCount\": 19,\n    \"dbSize\": 53542912,\n    \"dbRowCount\": 4194\n}","5","4.5.24","2025-11-17 06:53:12","2025-11-17 06:53:12"),
("7","backup_create","start","10","Backup creation: 20251117_uplusdental","{\n    \"packageId\": 4,\n    \"packageName\": \"20251117_uplusdental\",\n    \"packageStatus\": 10,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"nameHash\": \"20251117_uplusdental_2c19d878f16872468611_20251117065308\",\n    \"logFileName\": \"20251117_uplusdental_2c19d878f16872468611_20251117065308_log.txt\",\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 11007,\n    \"dirCount\": 2074,\n    \"size\": 256096011,\n    \"dbFilterOn\": false,\n    \"dbFilterTables\": [],\n    \"dbPrefixFilter\": false,\n    \"archiveEngine\": \"Shell Exec\",\n    \"databaseEngine\": \"PHPCHUNKING\",\n    \"execType\": \"Manual\",\n    \"scheduleName\": \"\",\n    \"storageNames\": [\n        \"Default\"\n    ],\n    \"archiveSizeDisplay\": \"103.38MB\",\n    \"uploadSummaries\": {\n        \"completed\": 1,\n        \"total\": 1\n    },\n    \"dbExcluded\": false,\n    \"dbTableCount\": 19,\n    \"dbSizeDisplay\": \"51.06MB\",\n    \"execution_start_time\": 1763362404.3387100696563720703125\n}","0","4.5.24","2025-11-17 06:53:24","2025-11-17 06:53:42"),
("8","backup_create","db_dump","10","Backup creation: 20251117_uplusdental - Database Dump","{\n    \"packageId\": 4,\n    \"packageName\": \"20251117_uplusdental\",\n    \"packageStatus\": 20,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"nameHash\": \"20251117_uplusdental_2c19d878f16872468611_20251117065308\",\n    \"logFileName\": \"20251117_uplusdental_2c19d878f16872468611_20251117065308_log.txt\",\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 11007,\n    \"dirCount\": 2074,\n    \"size\": 256096011,\n    \"dbFilterOn\": false,\n    \"dbFilterTables\": [],\n    \"dbPrefixFilter\": false,\n    \"archiveEngine\": \"Shell Exec\",\n    \"databaseEngine\": \"PHPCHUNKING\",\n    \"execType\": \"Manual\",\n    \"scheduleName\": \"\",\n    \"storageNames\": [\n        \"Default\"\n    ],\n    \"archiveSizeDisplay\": \"\",\n    \"uploadSummaries\": [],\n    \"dbExcluded\": false,\n    \"dbTableCount\": 19,\n    \"dbSizeDisplay\": \"51.06MB\",\n    \"execution_start_time\": 1763362404.3387100696563720703125\n}","7","4.5.24","2025-11-17 06:53:24","2025-11-17 06:53:24"),
("9","backup_create","file_dump","10","Backup creation: 20251117_uplusdental - File Archive","{\n    \"packageId\": 4,\n    \"packageName\": \"20251117_uplusdental\",\n    \"packageStatus\": 40,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"nameHash\": \"20251117_uplusdental_2c19d878f16872468611_20251117065308\",\n    \"logFileName\": \"20251117_uplusdental_2c19d878f16872468611_20251117065308_log.txt\",\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 11007,\n    \"dirCount\": 2074,\n    \"size\": 256096011,\n    \"dbFilterOn\": false,\n    \"dbFilterTables\": [],\n    \"dbPrefixFilter\": false,\n    \"archiveEngine\": \"Shell Exec\",\n    \"databaseEngine\": \"PHPCHUNKING\",\n    \"execType\": \"Manual\",\n    \"scheduleName\": \"\",\n    \"storageNames\": [\n        \"Default\"\n    ],\n    \"archiveSizeDisplay\": \"\",\n    \"uploadSummaries\": [],\n    \"dbExcluded\": false,\n    \"dbTableCount\": 19,\n    \"dbSizeDisplay\": \"51.06MB\",\n    \"execution_start_time\": 1763362404.3387100696563720703125\n}","7","4.5.24","2025-11-17 06:53:28","2025-11-17 06:53:28"),
("10","backup_create","transfer","10","Backup creation: 20251117_uplusdental - Transfer","{\n    \"packageId\": 4,\n    \"packageName\": \"20251117_uplusdental\",\n    \"packageStatus\": 75,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"nameHash\": \"20251117_uplusdental_2c19d878f16872468611_20251117065308\",\n    \"logFileName\": \"20251117_uplusdental_2c19d878f16872468611_20251117065308_log.txt\",\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 11007,\n    \"dirCount\": 2074,\n    \"size\": 108402544,\n    \"dbFilterOn\": false,\n    \"dbFilterTables\": [],\n    \"dbPrefixFilter\": false,\n    \"archiveEngine\": \"Shell Exec\",\n    \"databaseEngine\": \"PHPCHUNKING\",\n    \"execType\": \"Manual\",\n    \"scheduleName\": \"\",\n    \"storageNames\": [\n        \"Default\"\n    ],\n    \"archiveSizeDisplay\": \"\",\n    \"uploadSummaries\": [],\n    \"dbExcluded\": false,\n    \"dbTableCount\": 19,\n    \"dbSizeDisplay\": \"51.06MB\",\n    \"execution_start_time\": 1763362404.3387100696563720703125\n}","7","4.5.24","2025-11-17 06:53:42","2025-11-17 06:53:42"),
("11","backup_create","end","10","Backup creation: 20251117_uplusdental - Completed","{\n    \"packageId\": 4,\n    \"packageName\": \"20251117_uplusdental\",\n    \"packageStatus\": 100,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"nameHash\": \"20251117_uplusdental_2c19d878f16872468611_20251117065308\",\n    \"logFileName\": \"20251117_uplusdental_2c19d878f16872468611_20251117065308_log.txt\",\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 11007,\n    \"dirCount\": 2074,\n    \"size\": 108402544,\n    \"dbFilterOn\": false,\n    \"dbFilterTables\": [],\n    \"dbPrefixFilter\": false,\n    \"archiveEngine\": \"Shell Exec\",\n    \"databaseEngine\": \"PHPCHUNKING\",\n    \"execType\": \"Manual\",\n    \"scheduleName\": \"\",\n    \"storageNames\": [\n        \"Default\"\n    ],\n    \"archiveSizeDisplay\": \"\",\n    \"uploadSummaries\": [],\n    \"dbExcluded\": false,\n    \"dbTableCount\": 19,\n    \"dbSizeDisplay\": \"51.06MB\",\n    \"execution_start_time\": 1763362404.3387100696563720703125,\n    \"total_runtime\": \"17.335 sec.\"\n}","7","4.5.24","2025-11-17 06:53:42","2025-11-17 06:53:42"),
("12","websites_scan","scan_start","10","Scan","{\n    \"packageId\": 5,\n    \"packageName\": \"20251222_uplusdental\",\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 0,\n    \"dirCount\": 0,\n    \"size\": 0,\n    \"dbExcluded\": false,\n    \"dbTableCount\": 0,\n    \"dbSize\": 0,\n    \"dbRowCount\": 0\n}","0","4.5.24","2025-12-22 01:12:48","2025-12-22 01:12:48"),
("13","websites_scan","scan_end","10","Scan Completed","{\n    \"packageId\": 5,\n    \"packageName\": \"20251222_uplusdental\",\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 10655,\n    \"dirCount\": 2060,\n    \"size\": 253818600,\n    \"dbExcluded\": false,\n    \"dbTableCount\": 19,\n    \"dbSize\": 60866560,\n    \"dbRowCount\": 4318\n}","12","4.5.24","2025-12-22 01:12:49","2025-12-22 01:12:49"),
("14","backup_create","start","10","Backup creation: 20251222_uplusdental","{\n    \"packageId\": 6,\n    \"packageName\": \"20251222_uplusdental\",\n    \"packageStatus\": 10,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"nameHash\": \"20251222_uplusdental_b5d7008474a4a4ae7700_20251222011247\",\n    \"logFileName\": \"20251222_uplusdental_b5d7008474a4a4ae7700_20251222011247_log.txt\",\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 10655,\n    \"dirCount\": 2060,\n    \"size\": 253818600,\n    \"dbFilterOn\": false,\n    \"dbFilterTables\": [],\n    \"dbPrefixFilter\": false,\n    \"archiveEngine\": \"Shell Exec\",\n    \"databaseEngine\": \"PHPCHUNKING\",\n    \"execType\": \"Manual\",\n    \"scheduleName\": \"\",\n    \"storageNames\": [\n        \"Default\"\n    ],\n    \"archiveSizeDisplay\": \"108.59MB\",\n    \"uploadSummaries\": {\n        \"completed\": 1,\n        \"total\": 1\n    },\n    \"dbExcluded\": false,\n    \"dbTableCount\": 19,\n    \"dbSizeDisplay\": \"58.05MB\",\n    \"execution_start_time\": 1766365980.3533070087432861328125\n}","0","4.5.24","2025-12-22 01:13:00","2025-12-22 01:13:19"),
("15","backup_create","db_dump","10","Backup creation: 20251222_uplusdental - Database Dump","{\n    \"packageId\": 6,\n    \"packageName\": \"20251222_uplusdental\",\n    \"packageStatus\": 20,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"nameHash\": \"20251222_uplusdental_b5d7008474a4a4ae7700_20251222011247\",\n    \"logFileName\": \"20251222_uplusdental_b5d7008474a4a4ae7700_20251222011247_log.txt\",\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 10655,\n    \"dirCount\": 2060,\n    \"size\": 253818600,\n    \"dbFilterOn\": false,\n    \"dbFilterTables\": [],\n    \"dbPrefixFilter\": false,\n    \"archiveEngine\": \"Shell Exec\",\n    \"databaseEngine\": \"PHPCHUNKING\",\n    \"execType\": \"Manual\",\n    \"scheduleName\": \"\",\n    \"storageNames\": [\n        \"Default\"\n    ],\n    \"archiveSizeDisplay\": \"\",\n    \"uploadSummaries\": [],\n    \"dbExcluded\": false,\n    \"dbTableCount\": 19,\n    \"dbSizeDisplay\": \"58.05MB\",\n    \"execution_start_time\": 1766365980.3533070087432861328125\n}","14","4.5.24","2025-12-22 01:13:00","2025-12-22 01:13:00"),
("16","backup_create","file_dump","10","Backup creation: 20251222_uplusdental - File Archive","{\n    \"packageId\": 6,\n    \"packageName\": \"20251222_uplusdental\",\n    \"packageStatus\": 40,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"nameHash\": \"20251222_uplusdental_b5d7008474a4a4ae7700_20251222011247\",\n    \"logFileName\": \"20251222_uplusdental_b5d7008474a4a4ae7700_20251222011247_log.txt\",\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 10655,\n    \"dirCount\": 2060,\n    \"size\": 253818600,\n    \"dbFilterOn\": false,\n    \"dbFilterTables\": [],\n    \"dbPrefixFilter\": false,\n    \"archiveEngine\": \"Shell Exec\",\n    \"databaseEngine\": \"PHPCHUNKING\",\n    \"execType\": \"Manual\",\n    \"scheduleName\": \"\",\n    \"storageNames\": [\n        \"Default\"\n    ],\n    \"archiveSizeDisplay\": \"\",\n    \"uploadSummaries\": [],\n    \"dbExcluded\": false,\n    \"dbTableCount\": 19,\n    \"dbSizeDisplay\": \"58.05MB\",\n    \"execution_start_time\": 1766365980.3533070087432861328125\n}","14","4.5.24","2025-12-22 01:13:05","2025-12-22 01:13:05"),
("17","backup_create","transfer","10","Backup creation: 20251222_uplusdental - Transfer","{\n    \"packageId\": 6,\n    \"packageName\": \"20251222_uplusdental\",\n    \"packageStatus\": 75,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"nameHash\": \"20251222_uplusdental_b5d7008474a4a4ae7700_20251222011247\",\n    \"logFileName\": \"20251222_uplusdental_b5d7008474a4a4ae7700_20251222011247_log.txt\",\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 10655,\n    \"dirCount\": 2060,\n    \"size\": 113866866,\n    \"dbFilterOn\": false,\n    \"dbFilterTables\": [],\n    \"dbPrefixFilter\": false,\n    \"archiveEngine\": \"Shell Exec\",\n    \"databaseEngine\": \"PHPCHUNKING\",\n    \"execType\": \"Manual\",\n    \"scheduleName\": \"\",\n    \"storageNames\": [\n        \"Default\"\n    ],\n    \"archiveSizeDisplay\": \"\",\n    \"uploadSummaries\": [],\n    \"dbExcluded\": false,\n    \"dbTableCount\": 19,\n    \"dbSizeDisplay\": \"58.05MB\",\n    \"execution_start_time\": 1766365980.3533070087432861328125\n}","14","4.5.24","2025-12-22 01:13:19","2025-12-22 01:13:19"),
("18","backup_create","end","10","Backup creation: 20251222_uplusdental - Completed","{\n    \"packageId\": 6,\n    \"packageName\": \"20251222_uplusdental\",\n    \"packageStatus\": 100,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"nameHash\": \"20251222_uplusdental_b5d7008474a4a4ae7700_20251222011247\",\n    \"logFileName\": \"20251222_uplusdental_b5d7008474a4a4ae7700_20251222011247_log.txt\",\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 10655,\n    \"dirCount\": 2060,\n    \"size\": 113866866,\n    \"dbFilterOn\": false,\n    \"dbFilterTables\": [],\n    \"dbPrefixFilter\": false,\n    \"archiveEngine\": \"Shell Exec\",\n    \"databaseEngine\": \"PHPCHUNKING\",\n    \"execType\": \"Manual\",\n    \"scheduleName\": \"\",\n    \"storageNames\": [\n        \"Default\"\n    ],\n    \"archiveSizeDisplay\": \"\",\n    \"uploadSummaries\": [],\n    \"dbExcluded\": false,\n    \"dbTableCount\": 19,\n    \"dbSizeDisplay\": \"58.05MB\",\n    \"execution_start_time\": 1766365980.3533070087432861328125,\n    \"total_runtime\": \"18.113 sec.\"\n}","14","4.5.24","2025-12-22 01:13:19","2025-12-22 01:13:19"),
("19","websites_scan","scan_start","10","Scan","{\n    \"packageId\": 7,\n    \"packageName\": \"20260115_uplusdental\",\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 0,\n    \"dirCount\": 0,\n    \"size\": 0,\n    \"dbExcluded\": false,\n    \"dbTableCount\": 0,\n    \"dbSize\": 0,\n    \"dbRowCount\": 0\n}","0","4.5.24","2026-01-15 03:39:55","2026-01-15 03:39:55"),
("20","websites_scan","scan_end","10","Scan Completed","{\n    \"packageId\": 7,\n    \"packageName\": \"20260115_uplusdental\",\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 10515,\n    \"dirCount\": 2037,\n    \"size\": 248477294,\n    \"dbExcluded\": false,\n    \"dbTableCount\": 19,\n    \"dbSize\": 60915712,\n    \"dbRowCount\": 4293\n}","19","4.5.24","2026-01-15 03:39:57","2026-01-15 03:39:57"),
("21","backup_create","start","10","Backup creation: 20260115_uplusdental","{\n    \"packageId\": 8,\n    \"packageName\": \"20260115_uplusdental\",\n    \"packageStatus\": 10,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"nameHash\": \"20260115_uplusdental_fb76f89a7c3f34ae8845_20260115033952\",\n    \"logFileName\": \"20260115_uplusdental_fb76f89a7c3f34ae8845_20260115033952_log.txt\",\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 10515,\n    \"dirCount\": 2037,\n    \"size\": 248477294,\n    \"dbFilterOn\": false,\n    \"dbFilterTables\": [],\n    \"dbPrefixFilter\": false,\n    \"archiveEngine\": \"Shell Exec\",\n    \"databaseEngine\": \"PHPCHUNKING\",\n    \"execType\": \"Manual\",\n    \"scheduleName\": \"\",\n    \"storageNames\": [\n        \"Default\"\n    ],\n    \"archiveSizeDisplay\": \"\",\n    \"uploadSummaries\": [],\n    \"dbExcluded\": false,\n    \"dbTableCount\": 19,\n    \"dbSizeDisplay\": \"58.09MB\",\n    \"execution_start_time\": 1768448410.6264569759368896484375\n}","0","4.5.24","2026-01-15 03:40:10","2026-01-15 03:40:10"),
("22","backup_create","db_dump","10","Backup creation: 20260115_uplusdental - Database Dump","{\n    \"packageId\": 8,\n    \"packageName\": \"20260115_uplusdental\",\n    \"packageStatus\": 20,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"nameHash\": \"20260115_uplusdental_fb76f89a7c3f34ae8845_20260115033952\",\n    \"logFileName\": \"20260115_uplusdental_fb76f89a7c3f34ae8845_20260115033952_log.txt\",\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 10515,\n    \"dirCount\": 2037,\n    \"size\": 248477294,\n    \"dbFilterOn\": false,\n    \"dbFilterTables\": [],\n    \"dbPrefixFilter\": false,\n    \"archiveEngine\": \"Shell Exec\",\n    \"databaseEngine\": \"PHPCHUNKING\",\n    \"execType\": \"Manual\",\n    \"scheduleName\": \"\",\n    \"storageNames\": [\n        \"Default\"\n    ],\n    \"archiveSizeDisplay\": \"\",\n    \"uploadSummaries\": [],\n    \"dbExcluded\": false,\n    \"dbTableCount\": 19,\n    \"dbSizeDisplay\": \"58.09MB\",\n    \"execution_start_time\": 1768448410.6264569759368896484375\n}","21","4.5.24","2026-01-15 03:40:10","2026-01-15 03:40:10");

INSERT IGNORE INTO `wp_duplicator_backups` VALUES 
("7","Standard","20260115_uplusdental","fb76f89a7c3f34ae8845_20260115033952","20260115_uplusdental_fb76f89a7c3f34ae8845_20260115033952_archive.zip","5","MANUAL,ZIP_ARCHIVE,TEMPORARY","{\n    \"ID\": 7,\n    \"VersionWP\": \"6.9\",\n    \"VersionDB\": \"10.11.15\",\n    \"VersionPHP\": \"8.1.34\",\n    \"VersionOS\": \"Linux\",\n    \"name\": \"20260115_uplusdental\",\n    \"hash\": \"fb76f89a7c3f34ae8845_20260115033952\",\n    \"execType\": 0,\n    \"notes\": \"\",\n    \"StorePath\": \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/cbpro.com.au\\/preview\\/uplusdental\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20260115_uplusdental_fb76f89a7c3f34ae8845_20260115033952_scan.json\",\n    \"timer_start\": -1,\n    \"Runtime\": \"\",\n    \"ExeSize\": \"0\",\n    \"ZipSize\": \"0\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/.opcache\",\n            \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/.tmb\",\n            \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/bps-backup\",\n            \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/cache\",\n            \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/old-cache\",\n            \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/updraft\",\n            \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/wfcache\",\n            \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/.htaccess\",\n            \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/.user.ini\",\n            \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/php.ini\",\n            \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/web.config\",\n            \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-config.php\",\n            \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20260115_uplusdental_fb76f89a7c3f34ae8845_20260115033952_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/\",\n        \"Size\": 248477294,\n        \"Dirs\": [],\n        \"DirCount\": 2037,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 10515,\n        \"file_count\": -1,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [\n                    {\n                        \"ubytes\": 147291020,\n                        \"bytes\": \"140.47MB\",\n                        \"nodes\": 8599,\n                        \"name\": \"plugins\",\n                        \"dir\": \"wp-content\",\n                        \"path\": \"wp-content\\/plugins\"\n                    },\n                    {\n                        \"ubytes\": 187012804,\n                        \"bytes\": \"178.35MB\",\n                        \"nodes\": 9333,\n                        \"name\": \"wp-content\",\n                        \"dir\": \".\",\n                        \"path\": \"wp-content\"\n                    }\n                ],\n                \"Core\": [],\n                \"Global\": [\n                    \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-snapshots\",\n                    \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/.opcache\",\n                    \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/.tmb\",\n                    \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/backups-dup-lite\",\n                    \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/backups-dup-pro\",\n                    \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/ai1wm-backups\",\n                    \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/backupwordpress\",\n                    \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/content\\/cache\",\n                    \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/contents\\/cache\",\n                    \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/infinitewp\\/backups\",\n                    \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/managewp\\/backups\",\n                    \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/old-cache\",\n                    \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/updraft\",\n                    \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/wpvividbackups\",\n                    \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/wishlist-backup\",\n                    \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/wfcache\",\n                    \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/bps-backup\",\n                    \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/cache\",\n                    \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/uploads\\/aiowps_backups\",\n                    \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/uploads\\/backupbuddy_temp\",\n                    \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/uploads\\/backupbuddy_backups\",\n                    \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n                    \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/uploads\\/mainwp\\/backup\",\n                    \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/uploads\\/pb_backupbuddy\",\n                    \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/uploads\\/snapshots\",\n                    \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/uploads\\/sucuri\",\n                    \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/uploads\\/wp-clone\",\n                    \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/uploads\\/wp_all_backup\",\n                    \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/uploads\\/wpbackitup_backups\",\n                    \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/uploads\\/backup-guard\",\n                    \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n                    \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n                    \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/plugins\\/wordfence\\/tmp\"\n                ],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Files\": {\n                \"Size\": [\n                    {\n                        \"ubytes\": 5366415,\n                        \"bytes\": \"5.12MB\",\n                        \"nodes\": 1,\n                        \"name\": \"ui.js\",\n                        \"dir\": \"wp-content\\/plugins\\/elementor-pro\\/assets\\/js\\/packages\\/ui\",\n                        \"path\": \"wp-content\\/plugins\\/elementor-pro\\/assets\\/js\\/packages\\/ui\\/ui.js\"\n                    }\n                ],\n                \"Core\": [],\n                \"Global\": [\n                    \"error_log\",\n                    \"debug_log\",\n                    \"ws_ftp.log\",\n                    \"dbcache\",\n                    \"pgcache\",\n                    \"objectcache\",\n                    \".DS_Store\",\n                    \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/.htaccess\",\n                    \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/.user.ini\",\n                    \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/php.ini\",\n                    \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/web.config\",\n                    \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/debug.log\",\n                    \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-config.php\"\n                ],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"TreeSize\": {\n                \"text\": \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental <span class=\\\"size\\\" >236.97MB<\\/span> <span class=\\\"nodes\\\" >12552<\\/span>\",\n                \"fullPath\": \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\",\n                \"type\": \"folder\",\n                \"state\": {\n                    \"opened\": true,\n                    \"disabled\": false,\n                    \"selected\": false,\n                    \"checked\": false,\n                    \"checkbox_disabled\": true\n                },\n                \"children\": [\n                    {\n                        \"text\": \"wp-content <span class=\\\"size\\\" >178.35MB<\\/span> <span class=\\\"nodes\\\" >9333<\\/span>\",\n                        \"fullPath\": \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\",\n                        \"type\": \"folder\",\n                        \"state\": {\n                            \"opened\": true,\n                            \"disabled\": false,\n                            \"selected\": false,\n                            \"checked\": false,\n                            \"checkbox_disabled\": false\n                        },\n                        \"children\": [\n                            {\n                                \"text\": \"plugins <span class=\\\"size\\\" >140.47MB<\\/span> <span class=\\\"nodes\\\" >8599<\\/span>\",\n                                \"fullPath\": \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/plugins\",\n                                \"type\": \"folder\",\n                                \"state\": {\n                                    \"opened\": true,\n                                    \"disabled\": false,\n                                    \"selected\": false,\n                                    \"checked\": false,\n                                    \"checkbox_disabled\": false\n                                },\n                                \"children\": [\n                                    {\n                                        \"text\": \"elementor-pro <span class=\\\"size\\\" >19.52MB<\\/span> <span class=\\\"nodes\\\" >1563<\\/span>\",\n                                        \"fullPath\": \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/plugins\\/elementor-pro\",\n                                        \"type\": \"folder\",\n                                        \"state\": {\n                                            \"opened\": true,\n                                            \"disabled\": false,\n                                            \"selected\": false,\n                                            \"checked\": false,\n                                            \"checkbox_disabled\": false\n                                        },\n                                        \"children\": [\n                                            {\n                                                \"text\": \"assets <span class=\\\"size\\\" >14.78MB<\\/span> <span class=\\\"nodes\\\" >391<\\/span>\",\n                                                \"fullPath\": \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/plugins\\/elementor-pro\\/assets\",\n                                                \"type\": \"folder\",\n                                                \"state\": {\n                                                    \"opened\": true,\n                                                    \"disabled\": false,\n                                                    \"selected\": false,\n                                                    \"checked\": false,\n                                                    \"checkbox_disabled\": false\n                                                },\n                                                \"children\": [\n                                                    {\n                                                        \"text\": \"js <span class=\\\"size\\\" >11.36MB<\\/span> <span class=\\\"nodes\\\" >167<\\/span>\",\n                                                        \"fullPath\": \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/plugins\\/elementor-pro\\/assets\\/js\",\n                                                        \"type\": \"folder\",\n                                                        \"state\": {\n                                                            \"opened\": true,\n                                                            \"disabled\": false,\n                                                            \"selected\": false,\n                                                            \"checked\": false,\n                                                            \"checkbox_disabled\": false\n                                                        },\n                                                        \"children\": [\n                                                            {\n                                                                \"text\": \"packages <span class=\\\"size\\\" >6.01MB<\\/span> <span class=\\\"nodes\\\" >22<\\/span>\",\n                                                                \"fullPath\": \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/plugins\\/elementor-pro\\/assets\\/js\\/packages\",\n                                                                \"type\": \"folder\",\n                                                                \"state\": {\n                                                                    \"opened\": true,\n                                                                    \"disabled\": false,\n                                                                    \"selected\": false,\n                                                                    \"checked\": false,\n                                                                    \"checkbox_disabled\": false\n                                                                },\n                                                                \"children\": [\n                                                                    {\n                                                                        \"text\": \"ui <span class=\\\"size\\\" >5.98MB<\\/span> <span class=\\\"nodes\\\" >6<\\/span>\",\n                                                                        \"fullPath\": \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/plugins\\/elementor-pro\\/assets\\/js\\/packages\\/ui\",\n                                                                        \"type\": \"folder\",\n                                                                        \"state\": {\n                                                                            \"opened\": true,\n                                                                            \"disabled\": false,\n                                                                            \"selected\": false,\n                                                                            \"checked\": false,\n                                                                            \"checkbox_disabled\": false\n                                                                        },\n                                                                        \"children\": [\n                                                                            {\n                                                                                \"text\": \"ui.js <span class=\\\"size\\\" >5.12MB<\\/span> <span class=\\\"nodes\\\" >&nbsp;<\\/span>\",\n                                                                                \"fullPath\": \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/plugins\\/elementor-pro\\/assets\\/js\\/packages\\/ui\\/ui.js\",\n                                                                                \"type\": \"file\",\n                                                                                \"state\": {\n                                                                                    \"opened\": false,\n                                                                                    \"disabled\": false,\n                                                                                    \"selected\": false,\n                                                                                    \"checked\": false,\n                                                                                    \"checkbox_disabled\": false\n                                                                                },\n                                                                                \"children\": null,\n                                                                                \"li_attr\": {\n                                                                                    \"class\": \" warning-node\"\n                                                                                },\n                                                                                \"a_attr\": []\n                                                                            }\n                                                                        ],\n                                                                        \"li_attr\": {\n                                                                            \"data-full-loaded\": false,\n                                                                            \"class\": \" warning-childs\"\n                                                                        },\n                                                                        \"a_attr\": []\n                                                                    }\n                                                                ],\n                                                                \"li_attr\": {\n                                                                    \"data-full-loaded\": false,\n                                                                    \"class\": \" warning-childs\"\n                                                                },\n                                                                \"a_attr\": []\n                                                            }\n                                                        ],\n                                                        \"li_attr\": {\n                                                            \"data-full-loaded\": false,\n                                                            \"class\": \" warning-childs\"\n                                                        },\n                                                        \"a_attr\": []\n                                                    }\n                                                ],\n                                                \"li_attr\": {\n                                                    \"data-full-loaded\": false,\n                                                    \"class\": \" warning-childs\"\n                                                },\n                                                \"a_attr\": []\n                                            }\n                                        ],\n                                        \"li_attr\": {\n                                            \"data-full-loaded\": false,\n                                            \"class\": \" warning-childs\"\n                                        },\n                                        \"a_attr\": []\n                                    }\n                                ],\n                                \"li_attr\": {\n                                    \"data-full-loaded\": false,\n                                    \"class\": \" warning-node\"\n                                },\n                                \"a_attr\": []\n                            }\n                        ],\n                        \"li_attr\": {\n                            \"data-full-loaded\": false,\n                            \"class\": \" warning-node\"\n                        },\n                        \"a_attr\": []\n                    }\n                ],\n                \"li_attr\": {\n                    \"data-full-loaded\": false,\n                    \"class\": \" root-node core-node warning-childs\"\n                },\n                \"a_attr\": {\n                    \"title\": \"Core WordPress directories should not be filtered. Use caution when excluding files.\"\n                }\n            }\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20260115_uplusdental_fb76f89a7c3f34ae8845_20260115033952_installer.php\",\n        \"Size\": 0,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"Ct07XbF4ydbqKzyW9ihx27KXdguNoU64vfk+dfh1619KsKgcLnj0YvvxYgWwpZAKyuPRTf36i4ZR8RuDtftNGhGc25LBi8Cg8hYXGYSzbLd5Tlpm2i0PCA==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": false,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"cbprocom_uplusdental\",\n            \"tablesBaseCount\": 19,\n            \"tablesFinalCount\": 19,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 4293,\n            \"tablesSizeOnDisk\": 60915712,\n            \"tablesList\": {\n                \"wp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wp_duplicator_activity_logs\": {\n                    \"inaccurateRows\": \"15\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"wp_duplicator_backups\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 212992\n                },\n                \"wp_duplicator_entities\": {\n                    \"inaccurateRows\": \"8\",\n                    \"insertedRows\": 0,\n                    \"size\": 163840\n                },\n                \"wp_e_events\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_e_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 294912\n                },\n                \"wp_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"wp_e_submissions_values\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_options\": {\n                    \"inaccurateRows\": \"240\",\n                    \"insertedRows\": 0,\n                    \"size\": 2244608\n                },\n                \"wp_postmeta\": {\n                    \"inaccurateRows\": \"3561\",\n                    \"insertedRows\": 0,\n                    \"size\": 44957696\n                },\n                \"wp_posts\": {\n                    \"inaccurateRows\": \"386\",\n                    \"insertedRows\": 0,\n                    \"size\": 12238848\n                },\n                \"wp_termmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_terms\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_term_relationships\": {\n                    \"inaccurateRows\": \"34\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_term_taxonomy\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_usermeta\": {\n                    \"inaccurateRows\": \"26\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_users\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                }\n            },\n            \"dbEngine\": \"MariaDB\",\n            \"version\": \"10.11.15\",\n            \"versionComment\": \"MariaDB Server\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 0,\n        \"File\": \"20260115_uplusdental_fb76f89a7c3f34ae8845_20260115033952_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MariaDB Server\",\n        \"dbStorePathPublic\": \"\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"status\": 5,\n    \"progressPercent\": 5,\n    \"schedule_id\": -1,\n    \"descriptorsMng\": null,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 3,\n            \"storageClass\": \"Duplicator\\\\Models\\\\Storages\\\\AbstractStorageEntity\",\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"packageExists\": true,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": [],\n            \"generalExtraData\": []\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"buildEmailSent\": false,\n    \"version\": \"4.5.24\",\n    \"created\": \"2026-01-15 03:39:52\",\n    \"updated\": \"2026-01-15 03:39:57\",\n    \"flags\": [\n        \"MANUAL\",\n        \"ZIP_ARCHIVE\",\n        \"TEMPORARY\"\n    ],\n    \"flagUpdatedAfterLoad\": false,\n    \"mainScanLogId\": 19,\n    \"mainActivityLogId\": 0\n}","4.5.24","2026-01-15 03:39:52","2026-01-15 03:39:57"),
("8","Standard","20260115_uplusdental","fb76f89a7c3f34ae8845_20260115033952","20260115_uplusdental_fb76f89a7c3f34ae8845_20260115033952_archive.zip","20","MANUAL,ZIP_ARCHIVE","{\n    \"ID\": 8,\n    \"VersionWP\": \"6.9\",\n    \"VersionDB\": \"10.11.15\",\n    \"VersionPHP\": \"8.1.34\",\n    \"VersionOS\": \"Linux\",\n    \"name\": \"20260115_uplusdental\",\n    \"hash\": \"fb76f89a7c3f34ae8845_20260115033952\",\n    \"execType\": 0,\n    \"notes\": \"\",\n    \"StorePath\": \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/cbpro.com.au\\/preview\\/uplusdental\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20260115_uplusdental_fb76f89a7c3f34ae8845_20260115033952_scan.json\",\n    \"timer_start\": 1768448410.6264569759368896484375,\n    \"Runtime\": \"\",\n    \"ExeSize\": \"0\",\n    \"ZipSize\": \"0\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/.opcache\",\n            \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/.tmb\",\n            \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/bps-backup\",\n            \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/cache\",\n            \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/old-cache\",\n            \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/updraft\",\n            \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/wfcache\",\n            \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/.htaccess\",\n            \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/.user.ini\",\n            \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/php.ini\",\n            \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/web.config\",\n            \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-config.php\",\n            \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20260115_uplusdental_fb76f89a7c3f34ae8845_20260115033952_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/\",\n        \"Size\": 248477294,\n        \"Dirs\": [],\n        \"DirCount\": 2037,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 10515,\n        \"file_count\": -1,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [\n                    {\n                        \"ubytes\": 147291020,\n                        \"bytes\": \"140.47MB\",\n                        \"nodes\": 8599,\n                        \"name\": \"plugins\",\n                        \"dir\": \"wp-content\",\n                        \"path\": \"wp-content\\/plugins\"\n                    },\n                    {\n                        \"ubytes\": 187012804,\n                        \"bytes\": \"178.35MB\",\n                        \"nodes\": 9333,\n                        \"name\": \"wp-content\",\n                        \"dir\": \".\",\n                        \"path\": \"wp-content\"\n                    }\n                ],\n                \"Core\": [],\n                \"Global\": [\n                    \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-snapshots\",\n                    \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/.opcache\",\n                    \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/.tmb\",\n                    \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/backups-dup-lite\",\n                    \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/backups-dup-pro\",\n                    \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/ai1wm-backups\",\n                    \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/backupwordpress\",\n                    \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/content\\/cache\",\n                    \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/contents\\/cache\",\n                    \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/infinitewp\\/backups\",\n                    \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/managewp\\/backups\",\n                    \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/old-cache\",\n                    \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/updraft\",\n                    \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/wpvividbackups\",\n                    \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/wishlist-backup\",\n                    \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/wfcache\",\n                    \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/bps-backup\",\n                    \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/cache\",\n                    \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/uploads\\/aiowps_backups\",\n                    \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/uploads\\/backupbuddy_temp\",\n                    \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/uploads\\/backupbuddy_backups\",\n                    \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n                    \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/uploads\\/mainwp\\/backup\",\n                    \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/uploads\\/pb_backupbuddy\",\n                    \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/uploads\\/snapshots\",\n                    \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/uploads\\/sucuri\",\n                    \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/uploads\\/wp-clone\",\n                    \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/uploads\\/wp_all_backup\",\n                    \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/uploads\\/wpbackitup_backups\",\n                    \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/uploads\\/backup-guard\",\n                    \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n                    \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n                    \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/plugins\\/wordfence\\/tmp\"\n                ],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Files\": {\n                \"Size\": [\n                    {\n                        \"ubytes\": 5366415,\n                        \"bytes\": \"5.12MB\",\n                        \"nodes\": 1,\n                        \"name\": \"ui.js\",\n                        \"dir\": \"wp-content\\/plugins\\/elementor-pro\\/assets\\/js\\/packages\\/ui\",\n                        \"path\": \"wp-content\\/plugins\\/elementor-pro\\/assets\\/js\\/packages\\/ui\\/ui.js\"\n                    }\n                ],\n                \"Core\": [],\n                \"Global\": [\n                    \"error_log\",\n                    \"debug_log\",\n                    \"ws_ftp.log\",\n                    \"dbcache\",\n                    \"pgcache\",\n                    \"objectcache\",\n                    \".DS_Store\",\n                    \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/.htaccess\",\n                    \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/.user.ini\",\n                    \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/php.ini\",\n                    \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/web.config\",\n                    \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/debug.log\",\n                    \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-config.php\"\n                ],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"TreeSize\": {\n                \"treeList\": []\n            }\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20260115_uplusdental_fb76f89a7c3f34ae8845_20260115033952_installer.php\",\n        \"Size\": 0,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"8tgd8qxmV223Q3CfbK5dfru50kEVsx317flFsQeqtxpKsKgcLnj0YvvxYgWwpZAKD8MtTIsa+YD0hvwIkNeNuGUY8ya5XbsTsxnEElHkOCUVDK3Mj2Euyg==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": false,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"cbprocom_uplusdental\",\n            \"tablesBaseCount\": 19,\n            \"tablesFinalCount\": 19,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 4293,\n            \"tablesSizeOnDisk\": 60915712,\n            \"tablesList\": {\n                \"wp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wp_duplicator_activity_logs\": {\n                    \"inaccurateRows\": \"15\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"wp_duplicator_backups\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 212992\n                },\n                \"wp_duplicator_entities\": {\n                    \"inaccurateRows\": \"8\",\n                    \"insertedRows\": 0,\n                    \"size\": 163840\n                },\n                \"wp_e_events\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_e_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 294912\n                },\n                \"wp_e_submissions_actions_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"wp_e_submissions_values\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_options\": {\n                    \"inaccurateRows\": \"240\",\n                    \"insertedRows\": 0,\n                    \"size\": 2244608\n                },\n                \"wp_postmeta\": {\n                    \"inaccurateRows\": \"3561\",\n                    \"insertedRows\": 0,\n                    \"size\": 44957696\n                },\n                \"wp_posts\": {\n                    \"inaccurateRows\": \"386\",\n                    \"insertedRows\": 0,\n                    \"size\": 12238848\n                },\n                \"wp_termmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_terms\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_term_relationships\": {\n                    \"inaccurateRows\": \"34\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_term_taxonomy\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_usermeta\": {\n                    \"inaccurateRows\": \"26\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_users\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                }\n            },\n            \"dbEngine\": \"MariaDB\",\n            \"version\": \"10.11.15\",\n            \"versionComment\": \"MariaDB Server\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 0,\n        \"File\": \"20260115_uplusdental_fb76f89a7c3f34ae8845_20260115033952_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MariaDB Server\",\n        \"dbStorePathPublic\": \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/wp-content\\/backups-dup-pro\\/tmp\\/20260115_uplusdental_fb76f89a7c3f34ae8845_20260115033952_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"status\": 20,\n    \"progressPercent\": 20,\n    \"schedule_id\": -1,\n    \"descriptorsMng\": null,\n    \"build_progress\": {\n        \"thread_start_time\": 1768448412,\n        \"initialized\": true,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [\n            \"wp_users\",\n            \"wp_usermeta\",\n            \"wp_commentmeta\",\n            \"wp_comments\",\n            \"wp_duplicator_activity_logs\",\n            \"wp_duplicator_backups\",\n            \"wp_duplicator_entities\",\n            \"wp_e_events\",\n            \"wp_e_submissions\",\n            \"wp_e_submissions_actions_log\",\n            \"wp_e_submissions_values\",\n            \"wp_links\",\n            \"wp_options\",\n            \"wp_postmeta\",\n            \"wp_posts\",\n            \"wp_termmeta\",\n            \"wp_terms\",\n            \"wp_term_relationships\",\n            \"wp_term_taxonomy\"\n        ],\n        \"validationStage1\": false,\n        \"doneInit\": true,\n        \"doneFiltering\": true,\n        \"doneCreates\": true,\n        \"completed\": false,\n        \"startTime\": 1768448410.65126800537109375,\n        \"wasInterrupted\": true,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"countTotal\": 0,\n            \"impreciseTotalRows\": 4297,\n            \"tables\": {\n                \"wp_users\": {\n                    \"start\": \"1\",\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_usermeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_commentmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_comments\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_duplicator_activity_logs\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_duplicator_backups\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_duplicator_entities\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_e_events\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_e_submissions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_e_submissions_actions_log\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_e_submissions_values\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_links\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_options\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_postmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_posts\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_termmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_terms\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_term_relationships\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_term_taxonomy\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                }\n            }\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 3,\n            \"storageClass\": \"Duplicator\\\\Models\\\\Storages\\\\AbstractStorageEntity\",\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"packageExists\": true,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": [],\n            \"generalExtraData\": []\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"buildEmailSent\": false,\n    \"version\": \"4.5.24\",\n    \"created\": \"2026-01-15 03:39:52\",\n    \"updated\": \"2026-01-15 03:40:12\",\n    \"flags\": [\n        \"MANUAL\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false,\n    \"mainScanLogId\": 19,\n    \"mainActivityLogId\": 21\n}","4.5.24","2026-01-15 03:39:52","2026-01-15 03:40:12");

INSERT IGNORE INTO `wp_duplicator_entities` VALUES 
("1","DUP_PRO_Global_Entity","","","","","","{\n    \"email_summary_frequency\": \"weekly\",\n    \"email_summary_recipients\": [\n        \"clickbizdigital@gmail.com\"\n    ],\n    \"usageTracking\": true,\n    \"amNotices\": true,\n    \"package_mysqldump\": false,\n    \"package_mysqldump_path\": \"\",\n    \"package_phpdump_mode\": 0,\n    \"package_mysqldump_qrylimit\": 131072,\n    \"packageMysqldumpOptions\": [\n        {\n            \"option\": \"quick\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"extended-insert\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"routines\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": true,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"disable-keys\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"compact\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        }\n    ],\n    \"archive_build_mode\": 1,\n    \"archive_compression\": true,\n    \"ziparchive_validation\": false,\n    \"ziparchive_mode\": 0,\n    \"ziparchive_chunk_size_in_mb\": 32,\n    \"homepath_as_abspath\": false,\n    \"server_load_reduction\": 0,\n    \"max_package_runtime_in_min\": 90,\n    \"max_package_transfer_time_in_min\": 90,\n    \"php_max_worker_time_in_sec\": 20,\n    \"cleanup_mode\": 0,\n    \"cleanup_email\": \"clickbizdigital@gmail.com\",\n    \"auto_cleanup_hours\": 24,\n    \"lock_mode\": 1,\n    \"ajax_protocol\": \"admin\",\n    \"custom_ajax_url\": \"https:\\/\\/cbpro.com.au\\/preview\\/uplusdental\\/wp-admin\\/admin-ajax.php\",\n    \"clientside_kickoff\": false,\n    \"basic_auth_enabled\": false,\n    \"basic_auth_user\": \"\",\n    \"installer_name_mode\": \"simple\",\n    \"installer_base_name\": \"installer.php\",\n    \"skip_archive_scan\": false,\n    \"send_email_on_build_mode\": 1,\n    \"notification_email_address\": \"\",\n    \"storage_htaccess_off\": false,\n    \"max_storage_retries\": 10,\n    \"purgeBackupRecords\": 0,\n    \"manual_mode_storage_ids\": [\n        3\n    ],\n    \"license_key_visible\": 1,\n    \"last_system_check_timestamp\": 0,\n    \"initial_activation_timestamp\": 1762736774,\n    \"ssl_useservercerts\": true,\n    \"ssl_disableverify\": true,\n    \"import_chunk_size\": 1024,\n    \"import_custom_path\": \"\",\n    \"ipv4_only\": false,\n    \"unhook_third_party_js\": false,\n    \"unhook_third_party_css\": false,\n    \"recoveryCustomPath\": \"\",\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 1,\n    \"version\": \"4.5.24\",\n    \"created\": \"2025-11-10 01:06:14\",\n    \"updated\": \"2026-01-15 03:39:52\"\n}","4.5.24","2025-11-10 01:06:14","2026-01-15 03:39:52"),
("2","Dynamic_Entity","","","","","","{\n    \"data\": \"PlyF7t5g+2EHXZwsA5ZqdvDs\\/2es5bk4PyMuOqkeGcyAQmnevtPmvxUqSUy4fPc\\/4FjGmqS91iJ6VfF10p\\/Rq6S0gO74VCH8\",\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 2,\n    \"version\": \"4.5.24\",\n    \"created\": \"2025-11-10 01:06:14\",\n    \"updated\": \"2025-11-10 05:47:43\",\n    \"dataIsEncrypted\": true\n}","4.5.24","2025-11-10 01:06:14","2025-11-10 05:47:43"),
("3","DUP_PRO_Storage_Entity","","","","","","{\n    \"name\": \"Default\",\n    \"notes\": \"The default location for storage on this server.\",\n    \"storage_type\": -2,\n    \"config\": \"\\/sSn3irWpzp0MXetkY0gSHDUTejXXLVh1uoTF8UYSzo\\/JEzjzx17LRH7yTER6FxYpMyrEeq0QT5zqBHq0WVh8D\\/npBCCqySqB\\/U7JcYvh5J\\/6jzJwWVkjhJ+cFsJNDJYxcN8mpyL4y+1HYeu55cE\\/SEbgqQC9oqEiM8E2\\/2UEiQn0xc8y7CiOzJbxFFwn9tLDSqu\\/YxfrQgy3MB627FwdNZOwyCLjug\\/3Sq3pBrUf3XRxITG\\/R9fpOXjvQP9WDxt5ei3hLerSJqkjp1GsWD+Ug==\",\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 3,\n    \"version\": \"4.5.24\",\n    \"created\": \"2025-11-10 01:06:14\",\n    \"updated\": \"2025-11-10 05:47:43\"\n}","4.5.24","2025-11-10 01:06:14","2025-11-10 05:47:43"),
("4","EmailSummary","","","","","","{\n    \"manualPackageIds\": [],\n    \"scheduledPackageIds\": [],\n    \"failedPackageIds\": [],\n    \"failedUploads\": [],\n    \"cancelledUploads\": [],\n    \"successfulUploads\": [],\n    \"scheduleIds\": [],\n    \"storageIds\": [],\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 4,\n    \"version\": \"4.5.24\",\n    \"created\": \"\",\n    \"updated\": \"2026-01-12 15:04:50\"\n}","4.5.24","2025-11-10 01:06:14","2026-01-12 15:04:50"),
("5","DUP_PRO_Package_Template_Entity","","","","","","{\n    \"name\": \"Default\",\n    \"package_name_format\": \"%year%%month%%day%_%sitetitle%\",\n    \"notes\": \"The default template.\",\n    \"filter_sites\": [],\n    \"archive_export_onlydb\": false,\n    \"archive_filter_on\": false,\n    \"archive_filter_dirs\": \"\",\n    \"archive_filter_exts\": \"\",\n    \"archive_filter_files\": \"\",\n    \"archive_filter_names\": false,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"database_filter_on\": false,\n    \"databasePrefixFilter\": false,\n    \"databasePrefixSubFilter\": false,\n    \"database_filter_tables\": \"\",\n    \"database_compatibility_modes\": \"\",\n    \"installer_opts_secure_on\": 0,\n    \"installerPassowrd\": \"c5KPi1YguvpPbAlfeTX5o0+nkjQIuy3tlAxFWMmHPjqeIXQP7WzqCE6Jgg4ht+kXdm3G\\/52lQvSqx\\/Zf0jdgtg==\",\n    \"installer_opts_skip_scan\": false,\n    \"installer_opts_db_host\": \"\",\n    \"installer_opts_db_name\": \"\",\n    \"installer_opts_db_user\": \"\",\n    \"installer_opts_cpnl_enable\": false,\n    \"installer_opts_cpnl_host\": \"\",\n    \"installer_opts_cpnl_user\": \"\",\n    \"installer_opts_cpnl_pass\": \"\",\n    \"installer_opts_cpnl_db_action\": \"create\",\n    \"installer_opts_cpnl_db_host\": \"\",\n    \"installer_opts_cpnl_db_name\": \"\",\n    \"installer_opts_cpnl_db_user\": \"\",\n    \"installer_opts_brand\": -2,\n    \"is_default\": true,\n    \"is_manual\": false,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 5,\n    \"version\": \"4.5.24\",\n    \"created\": \"2025-11-10 01:06:14\",\n    \"updated\": \"2025-11-10 01:06:14\"\n}","4.5.24","2025-11-10 01:06:14","2025-11-10 01:06:14"),
("6","DUP_PRO_Package_Template_Entity","","","","","","{\n    \"name\": \"[Manual Mode]\",\n    \"package_name_format\": \"%year%%month%%day%_%sitetitle%\",\n    \"notes\": \"\",\n    \"filter_sites\": \"\",\n    \"archive_export_onlydb\": false,\n    \"archive_filter_on\": false,\n    \"archive_filter_dirs\": \"\",\n    \"archive_filter_exts\": \"\",\n    \"archive_filter_files\": \"\",\n    \"archive_filter_names\": false,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"database_filter_on\": false,\n    \"databasePrefixFilter\": false,\n    \"databasePrefixSubFilter\": false,\n    \"database_filter_tables\": \"\",\n    \"database_compatibility_modes\": \"\",\n    \"installer_opts_secure_on\": 0,\n    \"installerPassowrd\": \"rJVoj5UnuAYwKXp\\/LLhlXg\\/BA4ouZum8A797A17zyylKsKgcLnj0YvvxYgWwpZAKIkrA7Sf9OJ05id7dskC5Sh4UYn2pLZ2SFaDLNXQGCBMJf7g8pSWUZg==\",\n    \"installer_opts_skip_scan\": false,\n    \"installer_opts_db_host\": \"\",\n    \"installer_opts_db_name\": \"\",\n    \"installer_opts_db_user\": \"\",\n    \"installer_opts_cpnl_enable\": false,\n    \"installer_opts_cpnl_host\": \"\",\n    \"installer_opts_cpnl_user\": \"\",\n    \"installer_opts_cpnl_pass\": \"\",\n    \"installer_opts_cpnl_db_action\": \"create\",\n    \"installer_opts_cpnl_db_host\": \"\",\n    \"installer_opts_cpnl_db_name\": \"\",\n    \"installer_opts_cpnl_db_user\": \"\",\n    \"installer_opts_brand\": -1,\n    \"is_default\": false,\n    \"is_manual\": true,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 6,\n    \"version\": \"4.5.24\",\n    \"created\": \"2025-11-10 01:06:14\",\n    \"updated\": \"2026-01-15 03:39:52\"\n}","4.5.24","2025-11-10 01:06:14","2026-01-15 03:39:52"),
("7","LicenseDataEntity","","","","","","{\n    \"licenseKey\": \"+e3w7\\/flKhegJ0gI3+6WQ2i4Bh1bpspA4lzP26CyBX5VKSlhsw+w+sb0LY9VUVNCQ4sxor8R3l7wlo8vTiUOjQ==\",\n    \"status\": \"EePojJqC0cM\\/I1ImiGhqbrbnAvR33FdoKmFixWck4tAzsI4R+8uo5+HFaNbtp382iRg3Z\\/+i\\/0oWOQTHhyjjR1yIwhmDu\\/D+\",\n    \"type\": \"80kp3YKQFBGHrYFRe7S6nN6FnpZrlyX1yXKU6d\\/NY1rePyPmA5LfvR0gwoSaxMfz7KK\\/NzBzbswh\\/ySiSixjQkEQ5cjbavcg\",\n    \"data\": \"cZKeQatKjF2Dpc0zM720mOUNWeBs7z0mrQltTVkJZZKV1uwikYkFzHSGdnjvfapvWOri3QKKdQCSVTst8pYnIlnpJghZ8d6Hr1PuvnTdluIX0uYXT65X6p6GES0KEEvIBOjh2Tq1YSFkUKOFUyHDhzE8hz6FBFA3Tn7tL5UrtdI3N\\/CfqkqpJcG19oc0jzqNh4cKfF\\/5nAMl1d\\/Qs+8m8y7AVFHwB6iVb8LFSR73iZMMS\\/R1phrbs1jq4t0CinUAgGKIheZYWp6Go0L1oy0ZW26ukfzZ9t33fWelARYNr4Tj1KQIlzP4tQiJ3g1JHCCD8fnqh33mkNiVhihaFcToL5yTwQRAYr5\\/ujVidqcYz6I+BKhzoOyzOfChcnko7jELuwJQzWnSri6A1YqM2i82EnDafoceVIORbKXKzM8tb8c=\",\n    \"lastRemoteUpdate\": \"\",\n    \"lastFailureTime\": \"\",\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 7,\n    \"version\": \"4.5.24\",\n    \"created\": \"2025-11-10 01:06:14\",\n    \"updated\": \"2026-01-15 03:40:12\"\n}","4.5.24","2025-11-10 01:06:14","2026-01-15 03:40:12"),
("8","DUP_PRO_System_Global_Entity","","","","","","{\n    \"recommended_fixes\": [],\n    \"schedule_failed\": false,\n    \"package_check_ts\": 1768448410,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 8,\n    \"version\": \"4.5.24\",\n    \"created\": \"2025-11-10 01:06:15\",\n    \"updated\": \"2026-01-15 03:40:10\"\n}","4.5.24","2025-11-10 01:06:15","2026-01-15 03:40:10");

INSERT IGNORE INTO `wp_e_events` VALUES 
("1","{\"event\":\"modal load\",\"version\":\"\",\"details\":\"{\\\"placement\\\":\\\"Onboarding wizard\\\",\\\"step\\\":\\\"account\\\",\\\"user_state\\\":\\\"anon\\\"}\",\"ts\":\"2025-07-25T10:27:04.055-06:30\"}","2025-07-25 22:27:04"),
("2","{\"event\":\"close modal\",\"version\":\"\",\"details\":\"{\\\"placement\\\":\\\"Onboarding wizard\\\",\\\"step\\\":\\\"account\\\"}\",\"ts\":\"2025-07-25T10:27:21.003-06:30\"}","2025-07-25 22:27:21");

INSERT IGNORE INTO `wp_options` VALUES 
("1","cron","a:17:{i:1762740582;a:0:{}i:1768449074;a:1:{s:32:\"duplicator_backup_storages_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:41:\"duplicator_backup_storages_check_interval\";s:4:\"args\";a:0:{}s:8:\"interval\";i:900;}}}i:1768450314;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1768453019;a:1:{s:28:\"elementor/tracker/send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1768479131;a:1:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1768482712;a:1:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1768484512;a:1:{s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1768486312;a:1:{s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1768522314;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1768522331;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1768522341;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1768522438;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1768525574;a:1:{s:31:\"duplicator_activity_log_cleanup\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:21:\"duplicator_daily_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1768528461;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1768608714;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1768831200;a:1:{s:33:\"duplicator_pro_email_summary_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}","on"),
("2","siteurl","https://cbpro.com.au/preview/uplusdental","yes"),
("3","home","https://cbpro.com.au/preview/uplusdental","yes"),
("4","blogname","U Plus Dental","on"),
("5","blogdescription","Trusted Local Dentist | Strathfield, Sydney","on"),
("6","users_can_register","0","on"),
("7","admin_email","clickbizdigital@gmail.com","on"),
("8","start_of_week","1","on"),
("9","use_balanceTags","0","on"),
("10","use_smilies","1","on"),
("11","require_name_email","1","on"),
("12","comments_notify","1","on"),
("13","posts_per_rss","10","on"),
("14","rss_use_excerpt","0","on"),
("15","mailserver_url","mail.example.com","on"),
("16","mailserver_login","login@example.com","on"),
("17","mailserver_pass","","on"),
("18","mailserver_port","110","on"),
("19","default_category","1","on"),
("20","default_comment_status","open","on"),
("21","default_ping_status","open","on"),
("22","default_pingback_flag","1","on"),
("23","posts_per_page","10","on"),
("24","date_format","F j, Y","on"),
("25","time_format","g:i a","on"),
("26","links_updated_date_format","F j, Y g:i a","on"),
("27","comment_moderation","0","on"),
("28","moderation_notify","1","on"),
("29","permalink_structure","/%postname%/","on"),
("30","rewrite_rules","a:120:{s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:46:\"e-floating-buttons/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:56:\"e-floating-buttons/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:76:\"e-floating-buttons/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:71:\"e-floating-buttons/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:71:\"e-floating-buttons/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:52:\"e-floating-buttons/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:35:\"e-floating-buttons/([^/]+)/embed/?$\";s:51:\"index.php?e-floating-buttons=$matches[1]&embed=true\";s:39:\"e-floating-buttons/([^/]+)/trackback/?$\";s:45:\"index.php?e-floating-buttons=$matches[1]&tb=1\";s:47:\"e-floating-buttons/([^/]+)/page/?([0-9]{1,})/?$\";s:58:\"index.php?e-floating-buttons=$matches[1]&paged=$matches[2]\";s:54:\"e-floating-buttons/([^/]+)/comment-page-([0-9]{1,})/?$\";s:58:\"index.php?e-floating-buttons=$matches[1]&cpage=$matches[2]\";s:43:\"e-floating-buttons/([^/]+)(?:/([0-9]+))?/?$\";s:57:\"index.php?e-floating-buttons=$matches[1]&page=$matches[2]\";s:35:\"e-floating-buttons/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"e-floating-buttons/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"e-floating-buttons/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"e-floating-buttons/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"e-floating-buttons/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"e-floating-buttons/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:45:\"elementskit-content/.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:55:\"elementskit-content/.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:75:\"elementskit-content/.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:70:\"elementskit-content/.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:70:\"elementskit-content/.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:51:\"elementskit-content/.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:34:\"elementskit-content/(.+?)/embed/?$\";s:52:\"index.php?elementskit_content=$matches[1]&embed=true\";s:38:\"elementskit-content/(.+?)/trackback/?$\";s:46:\"index.php?elementskit_content=$matches[1]&tb=1\";s:46:\"elementskit-content/(.+?)/page/?([0-9]{1,})/?$\";s:59:\"index.php?elementskit_content=$matches[1]&paged=$matches[2]\";s:53:\"elementskit-content/(.+?)/comment-page-([0-9]{1,})/?$\";s:59:\"index.php?elementskit_content=$matches[1]&cpage=$matches[2]\";s:42:\"elementskit-content/(.+?)(?:/([0-9]+))?/?$\";s:58:\"index.php?elementskit_content=$matches[1]&page=$matches[2]\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:39:\"index.php?&page_id=86&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}","on"),
("31","hack_file","0","on"),
("32","blog_charset","UTF-8","on"),
("33","moderation_keys","","off"),
("34","active_plugins","a:8:{i:0;s:33:\"duplicator-pro/duplicator-pro.php\";i:1;s:33:\"duplicator-pro/duplicator-pro.php\";i:2;s:31:\"elementor-pro/elementor-pro.php\";i:3;s:23:\"elementor/elementor.php\";i:4;s:37:\"elementskit-lite/elementskit-lite.php\";i:5;s:35:\"envato-elements/envato-elements.php\";i:7;s:75:\"material-design-icons-for-elementor/material-design-icons-for-elementor.php\";i:8;s:73:\"skyboot-custom-icons-for-elementor/skyboot-custom-icons-for-elementor.php\";}","on"),
("35","category_base","","on"),
("36","ping_sites","https://rpc.pingomatic.com/","on"),
("37","comment_max_links","2","on"),
("38","gmt_offset","0","on"),
("39","default_email_category","1","on"),
("40","recently_edited","","off"),
("41","template","hello-elementor","on"),
("42","stylesheet","hello-elementor","on"),
("43","comment_registration","0","on"),
("44","html_type","text/html","on"),
("45","use_trackback","0","on"),
("46","default_role","subscriber","on"),
("47","db_version","60717","on"),
("48","uploads_use_yearmonth_folders","1","on"),
("49","upload_path","","on"),
("50","blog_public","1","on"),
("51","default_link_category","2","on"),
("52","show_on_front","page","on"),
("53","tag_base","","on"),
("54","show_avatars","1","on"),
("55","avatar_rating","G","on"),
("56","upload_url_path","","on"),
("57","thumbnail_size_w","150","on"),
("58","thumbnail_size_h","150","on"),
("59","thumbnail_crop","1","on"),
("60","medium_size_w","300","on"),
("61","medium_size_h","300","on"),
("62","avatar_default","mystery","on"),
("63","large_size_w","1024","on"),
("64","large_size_h","1024","on"),
("65","image_default_link_type","none","on"),
("66","image_default_size","","on"),
("67","image_default_align","","on"),
("68","close_comments_for_old_posts","0","on"),
("69","close_comments_days_old","14","on"),
("70","thread_comments","1","on"),
("71","thread_comments_depth","5","on"),
("72","page_comments","0","on"),
("73","comments_per_page","50","on"),
("74","default_comments_page","newest","on"),
("75","comment_order","asc","on"),
("76","sticky_posts","a:0:{}","on"),
("77","widget_categories","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","auto"),
("78","widget_text","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","auto"),
("79","widget_rss","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","auto"),
("80","uninstall_plugins","a:1:{s:23:\"elementor/elementor.php\";a:2:{i:0;s:21:\"Elementor\\Maintenance\";i:1;s:9:\"uninstall\";}}","off"),
("81","timezone_string","","on"),
("82","page_for_posts","0","on"),
("83","page_on_front","86","on"),
("84","default_post_format","0","on"),
("85","link_manager_enabled","0","on"),
("86","finished_splitting_shared_terms","1","on"),
("87","site_icon","546","on"),
("88","medium_large_size_w","768","on"),
("89","medium_large_size_h","0","on"),
("90","wp_page_for_privacy_policy","3","on"),
("91","show_comments_cookies_opt_in","1","on"),
("92","admin_email_lifespan","1768954312","on"),
("93","disallowed_keys","","off"),
("94","comment_previously_approved","1","on"),
("95","auto_plugin_theme_update_emails","a:0:{}","off"),
("96","auto_update_core_dev","enabled","on"),
("97","auto_update_core_minor","enabled","on"),
("98","auto_update_core_major","enabled","on"),
("99","wp_force_deactivated_plugins","a:0:{}","on"),
("100","wp_attachment_pages_enabled","0","on"),
("101","initial_db_version","58975","on"),
("102","wp_user_roles","a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:71:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:20:\"skyboot_custom_icons\";b:1;s:20:\"duplicator_pro_basic\";b:1;s:21:\"duplicator_pro_create\";b:1;s:23:\"duplicator_pro_schedule\";b:1;s:22:\"duplicator_pro_storage\";b:1;s:29:\"duplicator_pro_backup_restore\";b:1;s:21:\"duplicator_pro_import\";b:1;s:21:\"duplicator_pro_export\";b:1;s:23:\"duplicator_pro_settings\";b:1;s:22:\"duplicator_pro_license\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}","on"),
("103","fresh_site","0","off"),
("104","user_count","1","off"),
("105","widget_block","a:6:{i:2;a:1:{s:7:\"content\";s:19:\"<!-- wp:search /-->\";}i:3;a:1:{s:7:\"content\";s:154:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Posts</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:227:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Comments</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:146:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Archives</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:150:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Categories</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;}","auto"),
("106","sidebars_widgets","a:2:{s:19:\"wp_inactive_widgets\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}s:13:\"array_version\";i:3;}","auto"),
("107","widget_pages","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("108","widget_calendar","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("109","widget_archives","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("110","widget_media_audio","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("111","widget_media_image","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("112","widget_media_gallery","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("113","widget_media_video","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("114","widget_meta","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("115","widget_search","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("116","widget_recent-posts","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("117","widget_recent-comments","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("118","widget_tag_cloud","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("119","widget_nav_menu","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("120","widget_custom_html","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("125","recovery_keys","a:0:{}","off"),
("126","theme_mods_twentytwentyfive","a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1753419229;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}}}}","off"),
("155","finished_updating_comment_type","1","auto"),
("157","db_upgraded","","on"),
("198","current_theme","Hello Elementor","auto"),
("199","theme_mods_hello-elementor","a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:0:{}s:18:\"custom_css_post_id\";i:-1;s:11:\"custom_logo\";i:230;}","on"),
("200","theme_switched","","auto"),
("201","hello_theme_version","3.4.5","auto"),
("204","elementor_connect_site_key","eccafc7f8c87852d615b9f471f1fd86a","auto"),
("205","_hello-elementor_notifications","a:2:{s:7:\"timeout\";i:1768491546;s:5:\"value\";s:7987:\"[{\"id\":\"hello-theme-3.4.5\",\"title\":\"3.4.5 - 2025-10-27\",\"description\":\"\\n            <ul>\\n\\t\\t\\t\\t<li>New: Add theme home to Finder<\\/li>\\n\\t\\t\\t\\t<li>Tweak: Improve banner behavior after clicking on action button<\\/li>\\n\\t\\t\\t\\t<li>Fix: Load styles correctly in Gutenberg pages<\\/li>\\n\\t\\t\\t\\t<li>Fix: Do not change menu name after Elementor activation<\\/li>\\n\\t\\t\\t\\t<li>Fix: Ensure quicklinks works correctly from home page<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.4.4\",\"title\":\"3.4.4 - 2025-06-08\",\"description\":\"\\n            <ul>\\n\\t\\t\\t\\t<li>Tweak: Improve Header\\/Footer edit access from theme Home<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.4.3\",\"title\":\"3.4.3 - 2025-05-26\",\"description\":\"\\n            <ul>\\n\\t\\t\\t\\t<li>Fix: Settings page empty after 3.4.0 in translated sites<\\/li>\\n\\t\\t\\t\\t<li>Fix: PHP 8.4 deprecation notice<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.4.2\",\"title\":\"3.4.2 - 2025-05-19\",\"description\":\"\\n            <ul>\\n\\t\\t\\t\\t<li>Tweak: Set Home links font weight to regular<\\/li>\\n  \\t\\t        <li>Tweak: Dart SASS 3.0.0 - resolve scss deprecated warnings<\\/li>\\n    \\t\\t    <li>Fix: Settings page empty after 3.4.0<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.4.0\",\"title\":\"3.4.0 - 2025-05-05\",\"description\":\"\\n            <ul>\\n                <li>New: Added Theme Home<\\/li>\\n\\t\\t\\t\\t<li>Tweak: Update theme settings page style<\\/li>\\n\\t\\t\\t\\t<li>Tweak: Update tested up to version 6.8<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.3.0\",\"title\":\"3.3.0 - 2025-01-21\",\"description\":\"\\n            <ul>\\n                <li>Tweak: Added changelog link in theme settings<\\/li>\\n\\t\\t\\t\\t<li>Tweak: Updated minimum required Safari version to 15.5<\\/li>\\n  \\t\\t        <li>Tweak: Update autoprefixer to latest versions<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.2.1\",\"title\":\"3.2.1 - 2024-12-16\",\"description\":\"\\n            <ul>\\n                <li>\\n                    Fix: Gutenberg editor expanded disproportionately after adding support for <code>theme.json<\\/code>\\n                    (<a href=\\\"https:\\/\\/github.com\\/elementor\\/hello-theme\\/issues\\/430\\\" target=\\\"_blank\\\">#430<\\/a>)\\n                <\\/li>\\n                <li>Fix: Use CSS logical properties in the theme<\\/li>\\n                <li>Fix: Add ARIA attributes to header nav menu<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.2.0\",\"title\":\"3.2.0 - 2024-12-15\",\"description\":\"\\n            <ul>\\n                <li>Tweak: Convert classic to hybrid theme with block-editor support<\\/li>\\n                <li>Tweak: Added new design options to header\\/footer<\\/li>\\n                <li>Tweak: Update <code>Tested up to 6.7<\\/code><\\/li>\\n                <li>\\n                    Fix: Minify JS files\\n                    (<a href=\\\"https:\\/\\/github.com\\/elementor\\/hello-theme\\/issues\\/419\\\" target=\\\"_blank\\\">#419<\\/a>)\\n                <\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.1.1\",\"title\":\"3.1.1 - 2024-07-30\",\"description\":\"\\n            <ul>\\n                <li>Fix: Use consistent <code>&lt;h2&gt;<\\/code> for comments title and comment form<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.1.0\",\"title\":\"3.1.0 - 2024-06-19\",\"description\":\"\\n            <ul>\\n                <li>Tweak: Update <code>Requires PHP 7.4<\\/code><\\/li>\\n                <li>Tweak: Update <code>Tested up to 6.5<\\/code><\\/li>\\n                <li>Tweak: Add the ability to style the brand layout<\\/li>\\n                <li>Tweak: Remove deprecated Elementor code<\\/li>\\n                <li>Tweak: Restore default focus styling inside the theme<\\/li>\\n                <li>Tweak: Add <code>aria-label<\\/code> attribute to various <code>&lt;nav&gt;<\\/code> elements<\\/li>\\n                <li>Tweak: Improve mobile menu keyboard accessibility<\\/li>\\n                <li>Tweak: Semantic mobile menu toggle button<\\/li>\\n                <li>Fix: The header renders redundant <code>&lt;p&gt;<\\/code> when tagline is empty<\\/li>\\n                <li>Fix: Single post renders redundant wrapping <code>&lt;div&gt;<\\/code> when it has no tags<\\/li>\\n                <li>Fix: Remove redundant wrapping <code>&lt;div&gt;<\\/code> from <code>wp_nav_menu()<\\/code> output<\\/li>\\n                <li>Fix: Wrap page <code>&lt;h1&gt;<\\/code> with <code>&lt;div&gt;<\\/code>, not <code>&lt;header&gt;<\\/code><\\/li>\\n                <li>Fix: Use consistent <code>&lt;h3&gt;<\\/code> for comments title and comment form<\\/li>\\n                <li>Fix: Remove heading tags from dynamic header\\/footer<\\/li>\\n                <li>\\n                    Fix: Mobile Menu hamburger is not visible for logged-out users in some cases\\n                    (<a href=\\\"https:\\/\\/github.com\\/elementor\\/hello-theme\\/issues\\/369\\\" target=\\\"_blank\\\">#369<\\/a>)\\n                <\\/li>\\n                <li>Fix: Remove duplicate ID attributes in the header mobile menu<\\/li>\\n                <li>\\n                    Fix: Remove redundant table styles\\n                    (<a href=\\\"https:\\/\\/github.com\\/elementor\\/hello-theme\\/issues\\/311\\\" target=\\\"_blank\\\">#311<\\/a>)\\n                <\\/li>\\n                <li>Fix: Remove redundant space below Site Logo in the header\\/footer<\\/li>\\n                <li>Fix: Remove redundant CSS from dynamic header\\/footer layout<\\/li>\\n                <li>\\n                    Fix: Separate post tags in single post\\n                    (<a href=\\\"https:\\/\\/github.com\\/elementor\\/hello-theme\\/issues\\/304\\\" target=\\\"_blank\\\">#304<\\/a>)\\n                <\\/li>\\n                <li>Fix: Display <code>the_tags()<\\/code> after <code>wp_link_pages()<\\/code><\\/li>\\n                <li>Fix: Remove page break navigation from archives when using <code>&lt;!--nextpage--&gt;<\\/code><\\/li>\\n                <li>Fix: Style posts pagination component layout<\\/li>\\n                <li>Fix: Add RTL support to pagination arrows in archive pages<\\/li>\\n                <li>\\n                    Fix: Update pagination prev\\/next labels and positions\\n                    (<a href=\\\"https:\\/\\/github.com\\/elementor\\/hello-theme\\/issues\\/404\\\" target=\\\"_blank\\\">#404<\\/a>)\\n                <\\/li>\\n                <li>Fix: Check if Elementor is loaded when using dynamic header & footer<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.0.2\",\"title\":\"3.0.2 - 2024-05-28\",\"description\":\"\\n            <ul>\\n                <li>Internal: Version bump release to refresh WordPress repository<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.0.1\",\"title\":\"3.0.1 - 2024-01-24\",\"description\":\"\\n            <ul>\\n                <li>Fix: Harden security for admin notice dismiss button<\\/li>\\n                <li>Fix: Add <code>alt<\\/code> attribute to all the images in the dashboard<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.0.0\",\"title\":\"3.0.0 - 2023-12-26\",\"description\":\"\\n            <ul>\\n                <li>New: Option to disable cross-site header & footer<\\/li>\\n                <li>Tweak: Update <code>Requires PHP 7.3<\\/code><\\/li>\\n                <li>Tweak: Update <code>Tested up to 6.4<\\/code><\\/li>\\n                <li>Tweak: Move cross-site header & footer styles to a separate CSS file<\\/li>\\n                <li>Tweak: Don\'t load <code>header-footer.min.css<\\/code> when disabling header & footer<\\/li>\\n                <li>Tweak: Don\'t load <code>hello-frontend.min.js<\\/code> when disabling header & footer<\\/li>\\n                <li>Tweak: Replace jQuery code with vanilla JS in the frontend<\\/li>\\n                <li>Tweak: Replace jQuery code with vanilla JS in WordPress admin<\\/li>\\n                <li>Tweak: Remove unused JS code from the frontend<\\/li>\\n                <li>Tweak: Remove unused CSS code from the editor<\\/li>\\n                <li>Tweak: Remove unnecessary <code>role<\\/code> attributes from HTML landmark elements<\\/li>\\n                <li>Tweak: Link from Elementor Site Settings to Hello Theme Settings<\\/li>\\n                <li>Fix: Dynamic script version for better caching<\\/li>\\n            <\\/ul>\"}]\";}","off"),
("207","recently_activated","a:0:{}","off"),
("210","elementor_active_kit","18","auto"),
("211","elementor_font_display","swap","auto"),
("214","elementor_landing_pages_activation","0","auto"),
("215","elementor_checklist","{\"last_opened_timestamp\":1753422369,\"first_closed_checklist_in_editor\":false,\"is_popup_minimized\":false,\"steps\":{\"add_logo\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"set_fonts_and_colors\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"create_pages\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"setup_header\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"assign_homepage\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"setup_header_pro\":{\"is_marked_completed\":false,\"is_immutable_completed\":false}},\"should_open_in_editor\":true}","auto"),
("216","elementor_version","3.33.6","auto"),
("217","elementor_install_history","a:7:{s:6:\"3.30.3\";i:1753419421;s:6:\"3.30.4\";i:1754006145;s:6:\"3.32.4\";i:1759816679;s:6:\"3.32.5\";i:1762736521;s:6:\"3.33.0\";i:1763362311;s:6:\"3.33.2\";i:1764212042;s:6:\"3.33.6\";i:1766360010;}","auto"),
("218","elementor_events_db_version","1.0.0","off"),
("220","elementor_onboarded","1","auto"),
("221","_elementor_installed_time","1753419442","auto"),
("222","elementor_remote_info_library","a:3:{s:10:\"types_data\";a:4:{s:5:\"block\";a:2:{s:10:\"categories\";a:30:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:8:\"Benefits\";i:4;s:14:\"call to action\";i:5;s:7:\"clients\";i:6;s:7:\"contact\";i:7;s:4:\"Data\";i:8;s:10:\"ehp-footer\";i:9;s:10:\"ehp-header\";i:10;s:3:\"faq\";i:11;s:8:\"features\";i:12;s:6:\"footer\";i:13;s:7:\"Gallery\";i:14;s:6:\"header\";i:15;s:4:\"hero\";i:16;s:11:\"Link in Bio\";i:17;s:9:\"portfolio\";i:18;s:7:\"pricing\";i:19;s:15:\"product archive\";i:20;s:5:\"Quote\";i:21;s:15:\"Service Details\";i:22;s:8:\"services\";i:23;s:11:\"single page\";i:24;s:11:\"single post\";i:25;s:14:\"single product\";i:26;s:5:\"stats\";i:27;s:9:\"subscribe\";i:28;s:4:\"team\";i:29;s:12:\"testimonials\";}s:4:\"sets\";a:5:{i:0;s:11:\"Boxing Club\";i:1;s:19:\"Business Consultant\";i:2;s:16:\"Marketing Agency\";i:3;s:9:\"Wireframe\";i:4;s:15:\"Workshop Center\";}}s:5:\"popup\";a:1:{s:10:\"categories\";a:6:{i:0;s:10:\"bottom bar\";i:1;s:7:\"classic\";i:2;s:6:\"fly-in\";i:3;s:11:\"full screen\";i:4;s:9:\"hello bar\";i:5;s:8:\"slide-in\";}}s:2:\"lp\";a:1:{s:10:\"categories\";a:15:{i:0;s:8:\"Business\";i:1;s:16:\"Coming Soon Page\";i:2;s:9:\"eCommerce\";i:3;s:9:\"Education\";i:4;s:6:\"Events\";i:5;s:18:\"Health and Fitness\";i:6;s:3:\"NFT\";i:7;s:14:\"Online Service\";i:8;s:7:\"Product\";i:9;s:11:\"Real Estate\";i:10;s:18:\"Social Involvement\";i:11;s:14:\"Thank You Page\";i:12;s:6:\"Travel\";i:13;s:18:\"Under Construction\";i:14;s:9:\"Wireframe\";}}s:2:\"lb\";a:1:{s:10:\"categories\";a:2:{i:0;s:4:\"post\";i:1;s:7:\"product\";}}}s:10:\"categories\";a:30:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:8:\"Benefits\";i:4;s:14:\"call to action\";i:5;s:7:\"clients\";i:6;s:7:\"contact\";i:7;s:4:\"Data\";i:8;s:10:\"ehp-footer\";i:9;s:10:\"ehp-header\";i:10;s:3:\"faq\";i:11;s:8:\"features\";i:12;s:6:\"footer\";i:13;s:7:\"Gallery\";i:14;s:6:\"header\";i:15;s:4:\"hero\";i:16;s:11:\"Link in Bio\";i:17;s:9:\"portfolio\";i:18;s:7:\"pricing\";i:19;s:15:\"product archive\";i:20;s:5:\"Quote\";i:21;s:15:\"Service Details\";i:22;s:8:\"services\";i:23;s:11:\"single page\";i:24;s:11:\"single post\";i:25;s:14:\"single product\";i:26;s:5:\"stats\";i:27;s:9:\"subscribe\";i:28;s:4:\"team\";i:29;s:12:\"testimonials\";}s:9:\"templates\";a:4:{i:0;a:20:{s:4:\"tmpl\";i:1254;s:2:\"id\";i:20472;s:5:\"title\";s:10:\"test ido f\";s:9:\"thumbnail\";s:153:\"https://library.stg.elementor.red/wp-content/uploads/2025/01/png-clipart-logo-harry-potter-literary-series-lord-voldemort-film-harry-potter-thumbnail.png\";s:12:\"tmpl_created\";i:1751356263;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.stg.elementor.red/blocks/test-ido-f/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:1;a:20:{s:4:\"tmpl\";i:1227;s:2:\"id\";i:19968;s:5:\"title\";s:12:\"Zeyad Test 1\";s:9:\"thumbnail\";s:83:\"https://library.stg.elementor.red/wp-content/uploads/2022/09/boxking_hero_img_2.jpg\";s:12:\"tmpl_created\";i:1670765723;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.stg.elementor.red/blocks/zeyad-test-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:2;a:20:{s:4:\"tmpl\";i:1231;s:2:\"id\";i:19494;s:5:\"title\";s:5:\"test2\";s:9:\"thumbnail\";s:83:\"https://library.stg.elementor.red/wp-content/uploads/2022/09/boxking_hero_img_4.jpg\";s:12:\"tmpl_created\";i:1672308146;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.stg.elementor.red/blocks/test2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:2;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:3;a:20:{s:4:\"tmpl\";i:1209;s:2:\"id\";i:9631;s:5:\"title\";s:38:\"Slide-in | Sale | Register | Subscribe\";s:9:\"thumbnail\";s:87:\"https://library.stg.elementor.red/wp-content/uploads/2019/01/Slide-in_Sale_small_01.png\";s:12:\"tmpl_created\";i:1660034300;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.stg.elementor.red/popups/slide-in-sale-01/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:142;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}}}","off"),
("223","elementor_remote_info_feed_data","a:3:{i:0;a:5:{s:5:\"title\";s:79:\"Introducing Elementor 3.33: Variables Manager, Custom CSS, Blend Modes, & more!\";s:7:\"excerpt\";s:340:\"Elementor 3.33 builds on the foundation of Editor V4, continuing our mission to create a faster, more scalable, and more intuitive design experience for Web Creators. With the addition of the Variables Manager, element-level Custom CSS, Background Clipping, and Blend Modes, designers have more creative precision and consistency than ever.\";s:7:\"created\";i:1762944115;s:5:\"badge\";s:3:\"NEW\";s:3:\"url\";s:145:\"https://elementor.com/blog/elementor-333-v4-variables-manager-custom-css/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:1;a:5:{s:5:\"title\";s:76:\"Introducing Elementor 3.32: Transitions, Transform, Size Variables, and More\";s:7:\"excerpt\";s:250:\"Elementor 3.32 is here, accelerating Editor V4 Alpha with transform controls and layered transitions, system-wide Size Variables and streamlined class management. This release empowers you to build more consistent, dynamic, and professional websites.\";s:7:\"created\";i:1759243152;s:5:\"badge\";s:3:\"NEW\";s:3:\"url\";s:138:\"https://elementor.com/blog/elementor-332-v4-transform-transitions/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:2;a:5:{s:5:\"title\";s:70:\"Introducing Elementor 3.31: New Editor V4 Variables, Filters, and More\";s:7:\"excerpt\";s:294:\"Elementor 3.31 is here, pushing Editor V4 forward with powerful design system enhancements and modern visual styling tools. From Variables and Filters to smarter editing workflows and semantic markup, this version makes it easier than ever to design beautiful, performant, and accessible sites.\";s:7:\"created\";i:1755094220;s:5:\"badge\";s:3:\"NEW\";s:3:\"url\";s:140:\"https://elementor.com/blog/elementor-331-v4-alpha-variables-filters/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}}","off"),
("226","_elementor_notifications_data","a:2:{s:7:\"timeout\";i:1766369901;s:5:\"value\";s:10799:\"[{\"id\":\"variables-manager-3.33\",\"title\":\"Variables Manager\",\"description\":\"Centralize and control all your color, typography, and size tokens for consistent, scalable design systems.\",\"topic\":\"Editor V4\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.33-variables-manager.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.33-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"custom-css-3.33\",\"title\":\"Custom CSS\",\"description\":\"Write isolated, responsive, and state-based CSS directly inside atomic elements for pixel-perfect control.\",\"topic\":\"Elementor Pro 3.33\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.33-custom-css.png\",\"chipPlan\":\"Pro\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.33-blog\\/\",\"readMoreText\":\"Learn More\",\"conditions\":[[{\"type\":\"plugin\",\"plugin\":\"elementor-pro\\/elementor-pro.php\"}]]},{\"id\":\"custom-css-3.33\",\"title\":\"Custom CSS\",\"description\":\"Write isolated, responsive, and state-based CSS directly inside atomic elements for pixel-perfect control.\",\"topic\":\"Elementor Pro 3.33\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.33-custom-css.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Upgrade now\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.33-custom-css\\/\"},{\"id\":\"blend-mode-3.33\",\"title\":\"Blend Mode\",\"description\":\"Layer and blend visuals to create depth, contrast, and cinematic design effects.\",\"topic\":\"Editor V4\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.33-blend.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.33-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"transform-3.32\",\"title\":\"Design with depth using Transform\",\"description\":\"Move, scale, rotate, and skew any element with ease. Transform controls add depth, stacked effects, and seamless States for hover, focus, and active micro-interactions.\",\"topic\":\"Editor V4\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.32-transform.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.32-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"size-variable-3.32\",\"title\":\"Consistency with Size Variables\",\"description\":\"Define reusable values for properties like spacing or typography, then update them once to scale changes instantly across your site.\",\"topic\":\"Elementor Pro 3.32\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.32-size-variables.png\",\"chipPlan\":\"Pro\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.32-blog\\/\",\"readMoreText\":\"Learn More\",\"conditions\":[[{\"type\":\"plugin\",\"plugin\":\"elementor-pro\\/elementor-pro.php\"}]]},{\"id\":\"size-variable-3.32\",\"title\":\"Consistency with Size Variables\",\"description\":\"Define reusable values for properties like spacing or typography, then update them once to scale changes instantly across your site.\",\"topic\":\"Elementor Pro 3.32\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.32-size-variables.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Upgrade now\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.32-size-variable\\/\"},{\"id\":\"transitions-3.32\",\"title\":\"Smooth interactions with Transitions\",\"description\":\"Bring polish to every interaction. Transitions let you animate style changes smoothly between states. In Pro, layer multiple transitions by property for refined, modern micro-animations.\",\"topic\":\"Editor V4\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.32-transition.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.32-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"variables-3.31\",\"title\":\"Scalable design with Variables\",\"description\":\"Define once, reuse everywhere. Color & Font Variables help you build consistent, scalable design systems that update globally and are perfect for large sites or teams.\",\"topic\":\"Editor V4\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.31-variables.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.31-v4-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"filters-3.31\",\"title\":\"Visual effects with Filters and Backdrop Filters\",\"description\":\"Apply multiple Filters like blur, brightness, and contrast. Stack, reorder, and preview in real time without writing a line of code.\",\"topic\":\"Editor V4\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.31-filters.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.31-v4-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"ally-assistant\",\"title\":\"New! Fix accessibility issues with Ally Assistant\",\"description\":\"Scan any page for accessibility issues and fix them in one click. From color contrast to missing alt text, Ally Assistant provides guided steps or AI-powered fixes to make your site more inclusive.\",\"topic\":\"Ally by Elementor\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/ally-assistant.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Scan for free\",\"ctaLink\":\"http:\\/\\/go.elementor.com\\/acc-assistant-launch-whats-new\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"pojo-accessibility\\/pojo-accessibility.php\"}]]},{\"id\":\"classes-3.31\",\"title\":\"Smarter Class Manager tools\",\"description\":\"Quickly locate and manage Global Classes with usage counts, a new locator panel, and full class search. Perfect for scaling and refactoring complex design systems.\",\"topic\":\"Editor V4\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.31-classes.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.31-v4-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"attributes-3.31\",\"title\":\"Add semantic HTML with Attributes\",\"description\":\"Add custom HTML attributes like aria-*, data-*, and role to any element. Structure your markup for better accessibility, performance, and compliance.\",\"topic\":\"Elementor Pro 3.31\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.31-attributes.png\",\"chipPlan\":\"Pro\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.31-v4-blog\\/\",\"readMoreText\":\"Learn More\",\"conditions\":[[{\"type\":\"plugin\",\"plugin\":\"elementor-pro\\/elementor-pro.php\"}]]},{\"id\":\"attributes-3.31\",\"title\":\"Add semantic HTML with Attributes\",\"description\":\"Add custom HTML attributes like aria-*, data-*, and role to any element. Structure your markup for better accessibility, performance, and compliance.\",\"topic\":\"Elementor Pro 3.31\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.31-attributes.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Upgrade now\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.31-attributes\\/\"},{\"id\":\"cloud-websites-3.30\",\"title\":\"Full Website Templates in the cloud\",\"description\":\"Save and apply entire websites, including multiple pages, styles, site settings, media, and layout configurations - directly from the cloud.\",\"topic\":\"Elementor Pro 3.30\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/cloud-3.30.png\",\"chipPlan\":\"Pro\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.39-v4-blog\\/\",\"readMoreText\":\"Learn More\",\"conditions\":[[{\"type\":\"plugin\",\"plugin\":\"elementor-pro\\/elementor-pro.php\"}]]},{\"id\":\"cloud-websites-3.30\",\"title\":\"Full Website Templates in the cloud\",\"description\":\"Save and apply entire websites, including multiple pages, styles, site settings, media, and layout configurations - directly from the cloud.\",\"topic\":\"Elementor Pro 3.30\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/cloud-3.30.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Upgrade now\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.30-cloud-websites\\/\"},{\"id\":\"ally-notification\",\"title\":\"Just released! Ally - a new plugin for web accessibility & usability\",\"description\":\"Ally simplifies the complexities of making your website more accessible. With new regulations here and coming, making your website more usable and inclusive is no longer just an option, but a must.\",\"topic\":\"Ally by Elementor\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/ally-notification.png\",\"chipTags\":[\"New plugin\"],\"cta\":\"Get it free\",\"ctaLink\":\"https:\\/\\/wordpress.org\\/plugins\\/pojo-accessibility\\/\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"pojo-accessibility\\/pojo-accessibility.php\"}]]},{\"id\":\"ai-site-planner\",\"title\":\"Instant Sitemaps & Wireframes\",\"description\":\"Get your website plan in minutes with AI Site Planner. Describe your desired site and AI will generate a sitemap, brief and wireframe populated with initial content, ready for you to customize.\",\"topic\":\"Elementor AI\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/aI-site-planner.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/ai-notification-site-planner\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"image-optimizer-3.19\",\"title\":\"Effortlessly optimize images for a stunning, high-speed website with the Image Optimizer plugin.\",\"description\":\"Image Optimizer perfectly balances between image quality and performance to boost your website.  Resize, compress, and convert images to WebP, for faster loading times and and better user experience.\",\"topic\":\"Image Optimizer Plugin by Elementor\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/image-optimizer-3.19.png\",\"chipTags\":[\"New plugin\"],\"cta\":\"Get the Image Optimizer\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/io-notification-wp-dash-learn-more\\/\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"image-optimization\\/image-optimization.php\"}]]},{\"id\":\"5-star-rating-prompt\",\"title\":\"Love the New Features? Let Us Know with 5 Stars!\",\"description\":\"Help spread the word by telling the world what you love about Elementor.\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/5-star-rating-prompt.png\",\"cta\":\"Leave a Review\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/wp-dash-notification-five-stars\\/\"},{\"id\":\"site-mailer-introducing\",\"title\":\"Introducing Site Mailer\",\"description\":\"Keep your WordPress emails out of the spam folder with improved deliverability and an easy setup\\u2014no need for an SMTP plugin or complicated configurations.\",\"topic\":\"Site Mailer Plugin by Elementor\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/Site-mailer.png\",\"chipTags\":[\"New plugin\"],\"cta\":\"Start Free Trial\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/sm-wp-dash-whatsnew\\/\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"site-mailer\\/site-mailer.php\"}]]}]\";}","off"),
("233","envato_elements_version","2.0.16","auto"),
("234","envato_elements_install_time","1753419626","auto"),
("237","skb_cife_version","1.1.0","auto"),
("239","elementor_disable_color_schemes","yes","auto"),
("240","elementor_disable_typography_schemes","yes","auto"),
("242","skb_cife_general","","auto"),
("243","skb_cife_manage_icon","","auto"),
("244","skb_cife_update_info","","auto"),
("245","elementskit-lite__banner_last_check","1768448349","auto"),
("246","elementskit-lite__banner_data","O:8:\"stdClass\":10:{s:8:\"10022095\";O:8:\"stdClass\":7:{s:2:\"id\";i:10022095;s:5:\"title\";s:31:\"Wpmet Holiday Sale Ownpage 2025\";s:4:\"type\";s:6:\"notice\";s:6:\"screen\";s:11:\"plugin_page\";s:5:\"start\";i:1766361600;s:3:\"end\";i:1768608000;s:4:\"data\";O:8:\"stdClass\":9:{s:4:\"type\";s:6:\"notice\";s:11:\"button_link\";s:22:\"https://wpmet.com/4mb9\";s:11:\"button_text\";s:16:\"Save $3,397 Now!\";s:11:\"notice_body\";s:441:\"<strong style=\"font-size: 24px; padding: 8px 0 5px; color: #; display: block;\"><span style=\"color: #ff0000;\">Wpmet’s Holiday Sale is live</span><em data-start=\"1852\" data-end=\"1881\"><span style=\"color: #ff0000;\">!</span></em></strong>\r\n\r\n<strong style=\"font-size: 24px; padding: 8px 0 5px; color: #; display: block;\"><strong style=\"font-size: 16px;\">Save up to $3,397 on the All-in-One WordPress Plugin Bundle (80% OFF) </strong></strong>\";s:12:\"notice_image\";s:60:\"https://api.wpmet.com/auth/wp-content/uploads/2024/11/80.png\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";s:10:\"unique_key\";s:0:\"\";}}s:8:\"10022094\";O:8:\"stdClass\":7:{s:2:\"id\";i:10022094;s:5:\"title\";s:28:\"Wpmet Holiday Sale Dashboard\";s:4:\"type\";s:6:\"notice\";s:6:\"screen\";s:9:\"dashboard\";s:5:\"start\";b:0;s:3:\"end\";i:1768608000;s:4:\"data\";O:8:\"stdClass\":9:{s:4:\"type\";s:6:\"notice\";s:11:\"button_link\";s:22:\"https://wpmet.com/4mb9\";s:11:\"button_text\";s:16:\"Save $3,397 Now!\";s:11:\"notice_body\";s:441:\"<strong style=\"font-size: 24px; padding: 8px 0 5px; color: #; display: block;\"><span style=\"color: #ff0000;\">Wpmet’s Holiday Sale is live</span><em data-start=\"1852\" data-end=\"1881\"><span style=\"color: #ff0000;\">!</span></em></strong>\r\n\r\n<strong style=\"font-size: 24px; padding: 8px 0 5px; color: #; display: block;\"><strong style=\"font-size: 16px;\">Save up to $3,397 on the All-in-One WordPress Plugin Bundle (80% OFF) </strong></strong>\";s:12:\"notice_image\";s:60:\"https://api.wpmet.com/auth/wp-content/uploads/2024/11/80.png\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";s:10:\"unique_key\";s:0:\"\";}}s:8:\"10021821\";O:8:\"stdClass\":7:{s:2:\"id\";i:10021821;s:5:\"title\";s:32:\"Wpmet Notice BFCM Dashboard 2025\";s:4:\"type\";s:6:\"notice\";s:6:\"screen\";s:9:\"dashboard\";s:5:\"start\";i:1762819200;s:3:\"end\";i:1765843200;s:4:\"data\";O:8:\"stdClass\":9:{s:4:\"type\";s:6:\"notice\";s:11:\"button_link\";s:29:\"https://wpmet.com/wpnoticeh80\";s:11:\"button_text\";s:16:\"Save $3,397 Now!\";s:11:\"notice_body\";s:259:\"<strong style=\"font-size: 24px; padding: 8px 0 5px; color: #; display: block;\">Wpmet’s Black Friday Sale is live<em data-start=\"1852\" data-end=\"1881\">!\r\n</em></strong><strong>\r\nSave up to $3,397 on the All-in-One WordPress Plugin Bundle (80% OFF) </strong>\";s:12:\"notice_image\";s:60:\"https://api.wpmet.com/auth/wp-content/uploads/2024/11/80.png\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";s:10:\"unique_key\";s:0:\"\";}}s:8:\"10021820\";O:8:\"stdClass\":7:{s:2:\"id\";i:10021820;s:5:\"title\";s:24:\"Wpmet BFCM Own page 2025\";s:4:\"type\";s:6:\"notice\";s:6:\"screen\";s:11:\"plugin_page\";s:5:\"start\";i:1762819200;s:3:\"end\";i:1765843200;s:4:\"data\";O:8:\"stdClass\":9:{s:4:\"type\";s:6:\"notice\";s:11:\"button_link\";s:29:\"https://wpmet.com/wpnoticeh80\";s:11:\"button_text\";s:16:\"Save $3,397 Now!\";s:11:\"notice_body\";s:257:\"<strong style=\"font-size: 24px; padding: 8px 0 5px; color: #; display: block;\">Wpmet’s Black Friday Sale is live<em data-start=\"1852\" data-end=\"1881\">!</em></strong><strong>\r\nSave up to $3,397 on the All-in-One WordPress Plugin Bundle (80% OFF) </strong>\";s:12:\"notice_image\";s:60:\"https://api.wpmet.com/auth/wp-content/uploads/2024/11/80.png\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";s:10:\"unique_key\";s:0:\"\";}}s:8:\"10020931\";O:8:\"stdClass\":7:{s:2:\"id\";i:10020931;s:5:\"title\";s:29:\"Wpmet Halloween Own page 2025\";s:4:\"type\";s:6:\"notice\";s:6:\"screen\";s:11:\"plugin_page\";s:5:\"start\";i:1760486400;s:3:\"end\";i:1762128000;s:4:\"data\";O:8:\"stdClass\":9:{s:4:\"type\";s:6:\"notice\";s:11:\"button_link\";s:29:\"https://wpmet.com/wpnoticeh78\";s:11:\"button_text\";s:16:\"Save $2,936 Now!\";s:11:\"notice_body\";s:475:\"<h3><strong style=\"font-size: 24px; padding: 8px 0 5px; color: #; display: block;\">Wpmet’s Halloween Sale is live<em data-start=\"1852\" data-end=\"1881\">!</em></strong></h3>\r\n<p style=\"font-size: 16px; margin-left: -2px;\"><strong>Save up to $2,936 on the All-in-One WordPress Plugin Bundle (78% OFF) </strong>Or <strong>enjoy up to 35% OFF</strong> on your favorite single plugins — <em data-start=\"794\" data-end=\"830\">ElementsKit, GutenKit, ShopEngine,</em> and more!!</p>\";s:12:\"notice_image\";s:64:\"https://api.wpmet.com/auth/wp-content/uploads/2025/10/78-Off.jpg\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";s:10:\"unique_key\";s:0:\"\";}}s:8:\"10020929\";O:8:\"stdClass\":7:{s:2:\"id\";i:10020929;s:5:\"title\";s:30:\"Wpmet Halloween Dashboard 2025\";s:4:\"type\";s:6:\"notice\";s:6:\"screen\";s:9:\"dashboard\";s:5:\"start\";i:1760486400;s:3:\"end\";i:1762128000;s:4:\"data\";O:8:\"stdClass\":9:{s:4:\"type\";s:6:\"notice\";s:11:\"button_link\";s:29:\"https://wpmet.com/wpnoticeh78\";s:11:\"button_text\";s:16:\"Save $2,936 Now!\";s:11:\"notice_body\";s:432:\"<h3><strong style=\"font-size: 24px; padding: 8px 0 5px; color: #; display: block;\">Wpmet’s Halloween Sale is live!</strong></h3>\r\n<p style=\"font-size: 16px; margin-left: -2px;\"><strong>Save up to $2,936 on the All-in-One WordPress Plugin Bundle (78% OFF) </strong>Or <strong>enjoy up to 35% OFF</strong> on your favorite single plugins — <em data-start=\"794\" data-end=\"830\">ElementsKit, GutenKit, ShopEngine,</em> and more!!</p>\";s:12:\"notice_image\";s:64:\"https://api.wpmet.com/auth/wp-content/uploads/2025/10/78-Off.jpg\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";s:10:\"unique_key\";s:0:\"\";}}s:8:\"10019444\";O:8:\"stdClass\":7:{s:2:\"id\";i:10019444;s:5:\"title\";s:27:\"Wpmet Birthday 2025 ownpage\";s:4:\"type\";s:6:\"notice\";s:6:\"screen\";s:11:\"plugin_page\";s:5:\"start\";i:1753920000;s:3:\"end\";i:1755561600;s:4:\"data\";O:8:\"stdClass\":9:{s:4:\"type\";s:6:\"notice\";s:11:\"button_link\";s:26:\"https://wpmet.com/notice51\";s:11:\"button_text\";s:20:\"Claim Your Discount!\";s:11:\"notice_body\";s:589:\"<h3><strong style=\"color: #; text-transform: sentencecase; font-size: 14px;\"><span style=\"color: #e60073;\">Wpmet Birthday Sale!!</span></strong></h3>\r\n<h3><strong style=\"font-size: 24px; padding: 8px 0 5px; color: #; display: block;\">Save up to $2,986 on Premium WordPress Bundle Plugin!</strong></h3>\r\n<p style=\"font-size: 16px; margin-left: -2px;\"><b>Get up to 30% discounts</b> on each of our PRO Single plugins — ElementsKit, GutenKit, ShopEngine, MetForm, EmailKit, WP Social, PopupKit, WP Ultimate Review — or get them <b>all in super-saver bundles to save 80% instantly!</b></p>\";s:12:\"notice_image\";s:60:\"https://api.wpmet.com/auth/wp-content/uploads/2024/11/80.png\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";s:10:\"unique_key\";s:0:\"\";}}s:8:\"10018928\";O:8:\"stdClass\":7:{s:2:\"id\";i:10018928;s:5:\"title\";s:29:\"Wpmet Birthday 2025 dashboard\";s:4:\"type\";s:6:\"notice\";s:6:\"screen\";s:9:\"dashboard\";s:5:\"start\";i:1753920000;s:3:\"end\";i:1755561600;s:4:\"data\";O:8:\"stdClass\":9:{s:4:\"type\";s:6:\"notice\";s:11:\"button_link\";s:26:\"https://wpmet.com/notice50\";s:11:\"button_text\";s:20:\"Claim Your Discount!\";s:11:\"notice_body\";s:589:\"<h3><strong style=\"color: #; text-transform: sentencecase; font-size: 14px;\"><span style=\"color: #e60073;\">Wpmet Birthday Sale!!</span></strong></h3>\r\n<h3><strong style=\"font-size: 24px; padding: 8px 0 5px; color: #; display: block;\">Save up to $2,986 on Premium WordPress Bundle Plugin!</strong></h3>\r\n<p style=\"font-size: 16px; margin-left: -2px;\"><b>Get up to 30% discounts</b> on each of our PRO Single plugins — ElementsKit, GutenKit, ShopEngine, MetForm, EmailKit, WP Social, PopupKit, WP Ultimate Review — or get them <b>all in super-saver bundles to save 80% instantly!</b></p>\";s:12:\"notice_image\";s:60:\"https://api.wpmet.com/auth/wp-content/uploads/2024/11/80.png\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";s:10:\"unique_key\";s:0:\"\";}}s:8:\"10018688\";O:8:\"stdClass\":7:{s:2:\"id\";i:10018688;s:5:\"title\";s:42:\"Wpmet 4th of July Flash Sale 2025 Ownpages\";s:4:\"type\";s:6:\"notice\";s:6:\"screen\";s:11:\"plugin_page\";s:5:\"start\";i:1751328000;s:3:\"end\";i:1752019200;s:4:\"data\";O:8:\"stdClass\":9:{s:4:\"type\";s:6:\"notice\";s:11:\"button_link\";s:26:\"https://wpmet.com/notice35\";s:11:\"button_text\";s:20:\"Claim Your Discount!\";s:11:\"notice_body\";s:585:\"<h3><strong style=\"color: #; text-transform: uppercase; font-size: 14px;\"><span style=\"color: #e60073;\">Happy 4th of July super Sale!!</span></strong></h3>\r\n<h3><strong style=\"font-size: 24px; padding: 8px 0 5px; color: #; display: block;\">Save up to $2,986 on Premium WordPress Bundle Plugin!</strong></h3>\r\n<p style=\"font-size: 16px; margin-left: -2px;\"><b>Get up to 30% discounts</b> on each of our PRO Single plugins — ElementsKit, GutenKit, ShopEngine, MetForm, EmailKit, WP Social, WP Ultimate Review — or get them <b>all in super-saver bundles to save 80% instantly!</b></p>\";s:12:\"notice_image\";s:60:\"https://api.wpmet.com/auth/wp-content/uploads/2024/11/80.png\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";s:10:\"unique_key\";s:0:\"\";}}s:8:\"10018687\";O:8:\"stdClass\":7:{s:2:\"id\";i:10018687;s:5:\"title\";s:43:\"Wpmet 4th of July Flash Sale 2025 Dashboard\";s:4:\"type\";s:6:\"notice\";s:6:\"screen\";s:9:\"dashboard\";s:5:\"start\";i:1751328000;s:3:\"end\";i:1752019200;s:4:\"data\";O:8:\"stdClass\":9:{s:4:\"type\";s:6:\"notice\";s:11:\"button_link\";s:26:\"https://wpmet.com/notice35\";s:11:\"button_text\";s:20:\"Claim Your Discount!\";s:11:\"notice_body\";s:585:\"<h3><strong style=\"color: #; text-transform: uppercase; font-size: 14px;\"><span style=\"color: #e60073;\">Happy 4th of July super Sale!!</span></strong></h3>\r\n<h3><strong style=\"font-size: 24px; padding: 8px 0 5px; color: #; display: block;\">Save up to $2,986 on Premium WordPress Bundle Plugin!</strong></h3>\r\n<p style=\"font-size: 16px; margin-left: -2px;\"><b>Get up to 30% discounts</b> on each of our PRO Single plugins — ElementsKit, GutenKit, ShopEngine, MetForm, EmailKit, WP Social, WP Ultimate Review — or get them <b>all in super-saver bundles to save 80% instantly!</b></p>\";s:12:\"notice_image\";s:60:\"https://api.wpmet.com/auth/wp-content/uploads/2024/11/80.png\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";s:10:\"unique_key\";s:0:\"\";}}}","auto"),
("252","elementor_pro_license_key","*********","auto"),
("253","_elementor_pro_license_v2_data","a:2:{s:7:\"timeout\";i:1768491612;s:5:\"value\";s:71:\"{\"success\":true,\"license\":\"valid\",\"expires\":\"01.01.2030\",\"features\":[]}\";}","auto"),
("254","elementor_pro_version","3.30.1","auto"),
("255","elementor_pro_install_history","a:1:{s:6:\"3.30.1\";i:1753420742;}","auto"),
("256","widget_elementor-library","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("257","_elementor_pro_installed_time","1753420743","auto"),
("258","elementor_submissions_db_version","5","auto"),
("259","elementskit-lite_install_date","2025-07-25 05:19:03","auto"),
("264","elementor_fonts_manager_font_types","a:0:{}","auto"),
("265","elementor_fonts_manager_fonts","a:0:{}","auto"),
("266","elementor_custom_icon_sets_config","a:0:{}","auto"),
("270","e_editor_counter","105","auto"),
("271","elementor_log","a:38:{s:32:\"62a008db21ceb2eae4447678b545942b\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0date\";s:19:\"2025-07-25 05:38:43\";s:7:\"\0*\0type\";s:6:\"notice\";s:10:\"\0*\0message\";s:81:\"hexdec(): Passing null to parameter #1 ($hex_string) of type string is deprecated\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:96;s:14:\"\0*\0times_dates\";a:42:{i:0;s:19:\"2025-08-04 01:03:11\";i:1;s:19:\"2025-08-04 01:04:08\";i:2;s:19:\"2025-08-04 01:08:10\";i:3;s:19:\"2025-08-04 01:29:43\";i:4;s:19:\"2025-08-04 01:34:42\";i:5;s:19:\"2025-08-04 01:58:52\";i:6;s:19:\"2025-08-04 02:01:12\";i:7;s:19:\"2025-08-04 02:44:24\";i:8;s:19:\"2025-08-04 02:45:41\";i:9;s:19:\"2025-08-04 04:42:05\";i:10;s:19:\"2025-09-24 05:31:41\";i:11;s:19:\"2025-09-24 05:41:17\";i:12;s:19:\"2025-09-24 06:01:57\";i:13;s:19:\"2025-09-24 06:33:11\";i:14;s:19:\"2025-09-24 07:05:35\";i:15;s:19:\"2025-09-24 07:29:47\";i:16;s:19:\"2025-09-24 07:31:43\";i:17;s:19:\"2025-09-24 07:37:52\";i:18;s:19:\"2025-10-07 06:02:42\";i:19;s:19:\"2025-10-07 06:27:29\";i:20;s:19:\"2025-10-07 06:58:02\";i:21;s:19:\"2025-10-07 23:08:42\";i:22;s:19:\"2025-10-07 23:25:50\";i:23;s:19:\"2025-10-07 23:31:16\";i:24;s:19:\"2025-10-08 02:15:19\";i:25;s:19:\"2025-10-08 02:45:28\";i:26;s:19:\"2025-10-08 03:46:31\";i:27;s:19:\"2025-10-08 04:01:41\";i:28;s:19:\"2025-10-08 04:43:59\";i:29;s:19:\"2025-10-08 04:50:27\";i:30;s:19:\"2025-10-08 04:57:29\";i:31;s:19:\"2025-10-08 04:59:24\";i:32;s:19:\"2025-11-27 02:56:56\";i:33;s:19:\"2025-11-27 03:01:45\";i:34;s:19:\"2025-11-27 03:03:04\";i:35;s:19:\"2025-11-27 03:04:33\";i:36;s:19:\"2025-11-27 03:07:30\";i:37;s:19:\"2025-11-27 03:10:56\";i:38;s:19:\"2025-11-27 03:11:34\";i:39;s:19:\"2025-11-27 03:12:19\";i:40;s:19:\"2025-11-27 03:15:10\";i:41;s:19:\"2025-12-21 23:46:46\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:6:\"notice\";s:7:\"message\";s:81:\"hexdec(): Passing null to parameter #1 ($hex_string) of type string is deprecated\";s:4:\"file\";s:108:\"/home/cbprocom/public_html/preview/uplusdental/wp-content/plugins/elementor/includes/base/controls-stack.php\";s:4:\"line\";i:230;s:5:\"trace\";b:1;}s:7:\"\0*\0file\";s:108:\"/home/cbprocom/public_html/preview/uplusdental/wp-content/plugins/elementor/includes/base/controls-stack.php\";s:7:\"\0*\0line\";i:230;}s:32:\"aff770fe403d47651bc3bdb35a6ff2dc\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0date\";s:19:\"2025-07-25 05:38:46\";s:7:\"\0*\0type\";s:7:\"warning\";s:10:\"\0*\0message\";s:60:\"Undefined array key &quot;body_background_image_tablet&quot;\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:48;s:14:\"\0*\0times_dates\";a:42:{i:0;s:19:\"2025-07-25 06:00:46\";i:1;s:19:\"2025-07-25 06:30:00\";i:2;s:19:\"2025-07-25 06:32:16\";i:3;s:19:\"2025-07-25 06:32:32\";i:4;s:19:\"2025-07-25 08:27:02\";i:5;s:19:\"2025-07-25 08:39:31\";i:6;s:19:\"2025-07-25 08:43:11\";i:7;s:19:\"2025-07-28 06:26:21\";i:8;s:19:\"2025-07-30 00:14:41\";i:9;s:19:\"2025-07-30 00:15:30\";i:10;s:19:\"2025-07-30 00:15:31\";i:11;s:19:\"2025-07-30 00:16:26\";i:12;s:19:\"2025-07-30 00:34:51\";i:13;s:19:\"2025-07-30 00:35:42\";i:14;s:19:\"2025-07-30 00:43:18\";i:15;s:19:\"2025-07-30 00:43:19\";i:16;s:19:\"2025-07-30 00:44:17\";i:17;s:19:\"2025-07-30 00:44:29\";i:18;s:19:\"2025-07-30 00:44:31\";i:19;s:19:\"2025-07-30 00:45:26\";i:20;s:19:\"2025-07-30 01:03:49\";i:21;s:19:\"2025-07-30 01:27:53\";i:22;s:19:\"2025-08-01 00:46:20\";i:23;s:19:\"2025-08-04 02:44:05\";i:24;s:19:\"2025-10-06 15:10:28\";i:25;s:19:\"2025-10-07 06:02:05\";i:26;s:19:\"2025-10-07 23:06:33\";i:27;s:19:\"2025-10-08 04:57:05\";i:28;s:19:\"2025-10-08 04:59:56\";i:29;s:19:\"2025-10-08 04:59:57\";i:30;s:19:\"2025-11-10 05:47:15\";i:31;s:19:\"2025-11-10 05:48:06\";i:32;s:19:\"2025-11-11 06:35:30\";i:33;s:19:\"2025-11-13 21:30:08\";i:34;s:19:\"2025-11-19 03:54:01\";i:35;s:19:\"2025-11-27 02:51:42\";i:36;s:19:\"2025-11-27 02:56:47\";i:37;s:19:\"2025-11-30 21:28:34\";i:38;s:19:\"2025-12-06 14:50:24\";i:39;s:19:\"2025-12-21 23:37:27\";i:40;s:19:\"2025-12-22 01:18:31\";i:41;s:19:\"2025-12-22 01:19:57\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:7:\"warning\";s:7:\"message\";s:50:\"Undefined array key \"body_background_image_tablet\"\";s:4:\"file\";s:108:\"/home/cbprocom/public_html/preview/uplusdental/wp-content/plugins/elementor/includes/base/controls-stack.php\";s:4:\"line\";i:1492;s:5:\"trace\";b:1;}s:7:\"\0*\0file\";s:108:\"/home/cbprocom/public_html/preview/uplusdental/wp-content/plugins/elementor/includes/base/controls-stack.php\";s:7:\"\0*\0line\";i:1492;}s:32:\"8b940f8cfd06ce2af827f77dc96fed30\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0date\";s:19:\"2025-07-25 05:47:27\";s:7:\"\0*\0type\";s:7:\"warning\";s:10:\"\0*\0message\";s:46:\"Undefined array key &quot;editor_post_id&quot;\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-07-25 05:47:27\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:7:\"warning\";s:7:\"message\";s:36:\"Undefined array key \"editor_post_id\"\";s:4:\"file\";s:113:\"/home/cbprocom/public_html/preview/uplusdental/wp-content/plugins/elementor/modules/history/revisions-manager.php\";s:4:\"line\";i:363;s:5:\"trace\";b:1;}s:7:\"\0*\0file\";s:113:\"/home/cbprocom/public_html/preview/uplusdental/wp-content/plugins/elementor/modules/history/revisions-manager.php\";s:7:\"\0*\0line\";i:363;}s:32:\"2f8b22503014336f8315fad251903af4\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:7:\"\0*\0date\";s:19:\"2025-07-25 05:55:03\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:32:\"elementorFrontend is not defined\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:2;s:14:\"\0*\0times_dates\";a:2:{i:0;s:19:\"2025-07-25 05:55:03\";i:1;s:19:\"2025-07-25 06:16:41\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1753422903\";s:7:\"message\";s:32:\"elementorFrontend is not defined\";s:3:\"url\";s:104:\"https://cbpro.com.au/preview/uplusdental/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.30.3\";s:4:\"line\";s:1:\"3\";s:6:\"column\";s:6:\"999263\";}s:7:\"\0*\0file\";s:104:\"https://cbpro.com.au/preview/uplusdental/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.30.3\";s:7:\"\0*\0line\";s:1:\"3\";s:9:\"\0*\0column\";s:6:\"999263\";}s:32:\"f99eb5ed417492ef28b6b3000203a316\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:7:\"\0*\0date\";s:19:\"2025-07-25 08:48:15\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:61:\"Cannot read properties of undefined (reading &#039;get&#039;)\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-07-25 08:48:15\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1753433295\";s:7:\"message\";s:51:\"Cannot read properties of undefined (reading \'get\')\";s:3:\"url\";s:104:\"https://cbpro.com.au/preview/uplusdental/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.30.3\";s:4:\"line\";s:1:\"3\";s:6:\"column\";s:6:\"864127\";}s:7:\"\0*\0file\";s:104:\"https://cbpro.com.au/preview/uplusdental/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.30.3\";s:7:\"\0*\0line\";s:1:\"3\";s:9:\"\0*\0column\";s:6:\"864127\";}s:32:\"8c714fac5f337ed34edbecea3ee69a2d\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:7:\"\0*\0date\";s:19:\"2025-07-25 08:53:37\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:107:\"Failed to execute &#039;querySelector&#039; on &#039;Document&#039;: &#039;#&#039; is not a valid selector.\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:202;s:14:\"\0*\0times_dates\";a:42:{i:0;s:19:\"2025-11-27 03:05:35\";i:1;s:19:\"2025-11-27 03:05:35\";i:2;s:19:\"2025-11-27 03:15:25\";i:3;s:19:\"2025-11-27 03:15:25\";i:4;s:19:\"2025-11-27 03:15:25\";i:5;s:19:\"2025-11-27 03:15:25\";i:6;s:19:\"2025-11-27 03:16:11\";i:7;s:19:\"2025-11-27 03:16:11\";i:8;s:19:\"2025-11-27 03:16:11\";i:9;s:19:\"2025-11-27 03:16:11\";i:10;s:19:\"2025-11-27 03:17:53\";i:11;s:19:\"2025-11-27 03:17:53\";i:12;s:19:\"2025-11-27 03:17:53\";i:13;s:19:\"2025-11-27 03:17:53\";i:14;s:19:\"2025-11-27 03:20:05\";i:15;s:19:\"2025-11-27 03:20:05\";i:16;s:19:\"2025-11-27 03:20:05\";i:17;s:19:\"2025-11-27 03:20:05\";i:18;s:19:\"2025-11-27 03:21:24\";i:19;s:19:\"2025-11-27 03:21:24\";i:20;s:19:\"2025-11-27 03:22:01\";i:21;s:19:\"2025-11-27 03:22:01\";i:22;s:19:\"2025-11-27 03:22:01\";i:23;s:19:\"2025-11-27 03:22:01\";i:24;s:19:\"2025-11-27 03:22:11\";i:25;s:19:\"2025-11-27 03:22:11\";i:26;s:19:\"2025-11-27 03:22:11\";i:27;s:19:\"2025-11-27 03:22:11\";i:28;s:19:\"2025-11-27 03:22:18\";i:29;s:19:\"2025-11-27 03:22:18\";i:30;s:19:\"2025-11-27 03:22:18\";i:31;s:19:\"2025-11-27 03:22:18\";i:32;s:19:\"2025-11-27 03:22:25\";i:33;s:19:\"2025-11-27 03:22:25\";i:34;s:19:\"2025-11-27 03:22:25\";i:35;s:19:\"2025-11-27 03:22:25\";i:36;s:19:\"2025-11-27 03:22:34\";i:37;s:19:\"2025-11-27 03:22:34\";i:38;s:19:\"2025-11-27 03:22:34\";i:39;s:19:\"2025-11-27 03:22:34\";i:40;s:19:\"2025-11-27 03:24:45\";i:41;s:19:\"2025-11-27 03:24:45\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1753433617\";s:7:\"message\";s:77:\"Failed to execute \'querySelector\' on \'Document\': \'#\' is not a valid selector.\";s:3:\"url\";s:104:\"https://cbpro.com.au/preview/uplusdental/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.30.3\";s:4:\"line\";s:1:\"3\";s:6:\"column\";s:6:\"690276\";}s:7:\"\0*\0file\";s:104:\"https://cbpro.com.au/preview/uplusdental/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.30.3\";s:7:\"\0*\0line\";s:1:\"3\";s:9:\"\0*\0column\";s:6:\"690276\";}s:32:\"e6e076c9d7c1040e07469a28b2906569\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:7:\"\0*\0date\";s:19:\"2025-07-30 02:05:21\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:55:\"Cannot read properties of null (reading &#039;id&#039;)\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:6;s:14:\"\0*\0times_dates\";a:6:{i:0;s:19:\"2025-07-30 02:05:21\";i:1;s:19:\"2025-11-27 03:21:55\";i:2;s:19:\"2025-11-27 03:23:46\";i:3;s:19:\"2025-12-22 00:43:15\";i:4;s:19:\"2025-12-22 00:47:31\";i:5;s:19:\"2025-12-22 01:01:09\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1753841121\";s:7:\"message\";s:45:\"Cannot read properties of null (reading \'id\')\";s:3:\"url\";s:104:\"https://cbpro.com.au/preview/uplusdental/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.30.3\";s:4:\"line\";s:1:\"3\";s:6:\"column\";s:6:\"668025\";}s:7:\"\0*\0file\";s:104:\"https://cbpro.com.au/preview/uplusdental/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.30.3\";s:7:\"\0*\0line\";s:1:\"3\";s:9:\"\0*\0column\";s:6:\"668025\";}s:32:\"e9e8b20517eb94750245e9cf8e5d0274\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-07-31 23:55:45\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.30.3\";s:2:\"to\";s:6:\"3.30.4\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-07-31 23:55:45\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.30.3\";s:2:\"to\";s:6:\"3.30.4\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"a875bd732ffd1159e1a061e8a074f207\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-07-31 23:55:45\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-07-31 23:55:45\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"8a5037fb4e29f3d379a15bac5ea20ffc\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-07-31 23:55:45\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-07-31 23:55:45\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"ad4c60c799fa84ca26363abb19eab5b9\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-07-31 23:55:45\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-07-31 23:55:45\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"5dd8cd9b5a8f2ce595e82450196f1ee7\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-07-31 23:55:45\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.30.3\";s:2:\"to\";s:6:\"3.30.4\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-07-31 23:55:45\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.30.3\";s:2:\"to\";s:6:\"3.30.4\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"0d3ca2951d4fc7111788582238f85108\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-10-07 05:57:59\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-10-07 05:57:59\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"54abca7f85c9dc54f4286c5ce1e702a1\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-10-07 05:57:59\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-10-07 05:57:59\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"98c5433ac26720284c66a6978e3d3899\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-10-07 05:57:59\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-10-07 05:57:59\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"5a9f60dc41fbfa81957e7dc50c58a2fa\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-10-07 05:57:59\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.30.4\";s:2:\"to\";s:6:\"3.32.4\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-10-07 05:57:59\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.30.4\";s:2:\"to\";s:6:\"3.32.4\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"9696f0aa194c9ec5eaa22a3e77016ddf\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-10-07 05:57:59\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.30.4\";s:2:\"to\";s:6:\"3.32.4\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-10-07 05:57:59\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.30.4\";s:2:\"to\";s:6:\"3.32.4\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"76314b2a39a9012001eabf78c1a215fa\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-11-10 01:02:01\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-11-10 01:02:01\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"6417a60508155d61d29e8a5522c82b3d\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-11-10 01:02:01\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-11-10 01:02:01\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"6ee681ec3fedb1aa6a004d238e36e091\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-11-10 01:02:01\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-11-10 01:02:01\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"340be1c2a78de2e36085491eea4430b2\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-11-10 01:02:01\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.32.4\";s:2:\"to\";s:6:\"3.32.5\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-11-10 01:02:01\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.32.4\";s:2:\"to\";s:6:\"3.32.5\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"55a502acba8135416bf1fb226648ef7a\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-11-10 01:02:01\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.32.4\";s:2:\"to\";s:6:\"3.32.5\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-11-10 01:02:01\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.32.4\";s:2:\"to\";s:6:\"3.32.5\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"cb374dd5345e3cad48a48c4a92add999\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-11-17 06:51:51\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-11-17 06:51:51\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"d3dbd9037bbef19af29f876d9b2901f0\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-11-17 06:51:51\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-11-17 06:51:51\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"b5782ff56424bfb6185bdd11bd8fd3a8\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-11-17 06:51:51\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-11-17 06:51:51\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"e478bac79f463a87bc16ed41a9130b22\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-11-17 06:51:51\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.32.5\";s:2:\"to\";s:6:\"3.33.0\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-11-17 06:51:51\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.32.5\";s:2:\"to\";s:6:\"3.33.0\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"a5381dbda4dd9b249cc1fcd7000b322e\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-11-17 06:51:51\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.32.5\";s:2:\"to\";s:6:\"3.33.0\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-11-17 06:51:51\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.32.5\";s:2:\"to\";s:6:\"3.33.0\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"196aed8f8337c164cf62a54d9235184f\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-11-27 02:54:02\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-11-27 02:54:02\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"c223c7c08bc8b11be4614196c914f557\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-11-27 02:54:02\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-11-27 02:54:02\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"83a931d3c667dc670c9cfa4273d34a9e\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-11-27 02:54:02\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-11-27 02:54:02\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"0f44e7f6970140b94d3191aab8dc8255\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-11-27 02:54:02\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.33.0\";s:2:\"to\";s:6:\"3.33.2\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-11-27 02:54:02\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.33.0\";s:2:\"to\";s:6:\"3.33.2\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"5c1289546cd98d8a0d2b5ba8313d98a7\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-11-27 02:54:03\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.33.0\";s:2:\"to\";s:6:\"3.33.2\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-11-27 02:54:03\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.33.0\";s:2:\"to\";s:6:\"3.33.2\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"63272d93c575095e3f07201bf91ee489\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:7:\"\0*\0date\";s:19:\"2025-11-27 03:27:20\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:58:\"elementorFrontend.elements.window.jQuery is not a function\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:6;s:14:\"\0*\0times_dates\";a:6:{i:0;s:19:\"2025-11-27 03:27:20\";i:1;s:19:\"2025-11-27 03:27:20\";i:2;s:19:\"2025-11-27 03:27:20\";i:3;s:19:\"2025-11-27 03:27:20\";i:4;s:19:\"2025-11-27 03:27:20\";i:5;s:19:\"2025-11-27 03:27:20\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1764214040\";s:7:\"message\";s:58:\"elementorFrontend.elements.window.jQuery is not a function\";s:3:\"url\";s:104:\"https://cbpro.com.au/preview/uplusdental/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.33.2\";s:4:\"line\";s:1:\"2\";s:6:\"column\";s:6:\"547399\";}s:7:\"\0*\0file\";s:104:\"https://cbpro.com.au/preview/uplusdental/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.33.2\";s:7:\"\0*\0line\";s:1:\"2\";s:9:\"\0*\0column\";s:6:\"547399\";}s:32:\"6fe47ee857e600a75b3bfc51bdda1441\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-12-21 23:33:30\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-12-21 23:33:30\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"accb77c46a78e73e8d6342ffb6f33ffd\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-12-21 23:33:30\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-12-21 23:33:30\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"b490296f0303ca14996f89a4b41969c8\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-12-21 23:33:30\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-12-21 23:33:30\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"c9070443ddc82ec273f544fbf4d0f7b3\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-12-21 23:33:30\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.33.2\";s:2:\"to\";s:6:\"3.33.6\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-12-21 23:33:30\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.33.2\";s:2:\"to\";s:6:\"3.33.6\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"1bfd3f1e1b4c80e5fca9a74e7009f8d7\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-12-21 23:33:30\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.33.2\";s:2:\"to\";s:6:\"3.33.6\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-12-21 23:33:30\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.33.2\";s:2:\"to\";s:6:\"3.33.6\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}}","off"),
("272","_elementor_local_google_fonts","a:1:{s:5:\"inter\";a:2:{s:3:\"url\";s:96:\"https://cbpro.com.au/preview/uplusdental/wp-content/uploads/elementor/google-fonts/css/inter.css\";s:7:\"version\";i:1753421952;}}","auto"),
("275","elementskit-lite__stories_last_check","1768448348","auto"),
("276","elementskit-lite__stories_data","O:8:\"stdClass\":10:{s:8:\"10022097\";O:8:\"stdClass\":9:{s:2:\"id\";i:10022097;s:5:\"title\";s:26:\"GetGenie Holiday Sale 2025\";s:11:\"description\";s:0:\"\";s:7:\"plugins\";a:2:{i:0;s:8:\"getgenie\";i:1;s:12:\"getgenie-pro\";}s:4:\"type\";s:6:\"banner\";s:8:\"priority\";s:4:\"high\";s:5:\"start\";i:1766361600;s:3:\"end\";i:1768608000;s:4:\"data\";O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"banner\";s:10:\"story_link\";s:31:\"https://getgenie.ai/holidaysale\";s:11:\"story_image\";s:79:\"https://api.wpmet.com/auth/wp-content/uploads/2025/12/Getgenie-Holiday-Sale.gif\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";}}s:8:\"10022091\";O:8:\"stdClass\":9:{s:2:\"id\";i:10022091;s:5:\"title\";s:23:\"Wpmet Holiday Sale 2025\";s:11:\"description\";s:0:\"\";s:7:\"plugins\";a:8:{i:0;s:16:\"elementskit-lite\";i:1;s:8:\"emailkit\";i:2;s:21:\"gutenkit-blocks-addon\";i:3;s:7:\"metform\";i:4;s:19:\"popup-builder-block\";i:5;s:10:\"shopengine\";i:6;s:9:\"wp-social\";i:7;s:18:\"wp-ultimate-review\";}s:4:\"type\";s:6:\"banner\";s:8:\"priority\";s:4:\"high\";s:5:\"start\";i:1766361600;s:3:\"end\";i:1768608000;s:4:\"data\";O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"banner\";s:10:\"story_link\";s:22:\"https://wpmet.com/4mb9\";s:11:\"story_image\";s:76:\"https://api.wpmet.com/auth/wp-content/uploads/2025/12/Wpmet-Holiday-Sale.gif\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";}}s:8:\"10021822\";O:8:\"stdClass\":9:{s:2:\"id\";i:10021822;s:5:\"title\";s:18:\"BFCM GetGenie 2025\";s:11:\"description\";s:0:\"\";s:7:\"plugins\";a:2:{i:0;s:8:\"getgenie\";i:1;s:12:\"getgenie-pro\";}s:4:\"type\";s:6:\"banner\";s:8:\"priority\";s:4:\"high\";s:5:\"start\";i:1762819200;s:3:\"end\";i:1765843200;s:4:\"data\";O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"banner\";s:10:\"story_link\";s:33:\"https://getgenie.ai/geniestoryh50\";s:11:\"story_image\";s:68:\"https://api.wpmet.com/auth/wp-content/uploads/2025/11/GetGenie-1.gif\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";}}s:8:\"10021818\";O:8:\"stdClass\":9:{s:2:\"id\";i:10021818;s:5:\"title\";s:15:\"Wpmet BFCM 2025\";s:11:\"description\";s:0:\"\";s:7:\"plugins\";a:7:{i:0;s:16:\"elementskit-lite\";i:1;s:8:\"emailkit\";i:2;s:21:\"gutenkit-blocks-addon\";i:3;s:7:\"metform\";i:4;s:10:\"shopengine\";i:5;s:9:\"wp-social\";i:6;s:18:\"wp-ultimate-review\";}s:4:\"type\";s:6:\"banner\";s:8:\"priority\";s:4:\"high\";s:5:\"start\";i:1762819200;s:3:\"end\";i:1765843200;s:4:\"data\";O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"banner\";s:10:\"story_link\";s:28:\"https://wpmet.com/wpstoryh80\";s:11:\"story_image\";s:65:\"https://api.wpmet.com/auth/wp-content/uploads/2025/11/Wpmet-2.gif\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";}}s:8:\"10020924\";O:8:\"stdClass\":9:{s:2:\"id\";i:10020924;s:5:\"title\";s:23:\"Halloween GetGenie 2025\";s:11:\"description\";s:0:\"\";s:7:\"plugins\";a:2:{i:0;s:8:\"getgenie\";i:1;s:12:\"getgenie-pro\";}s:4:\"type\";s:6:\"banner\";s:8:\"priority\";s:4:\"high\";s:5:\"start\";i:1760486400;s:3:\"end\";i:1762128000;s:4:\"data\";O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"banner\";s:10:\"story_link\";s:33:\"https://getgenie.ai/geniestoryh45\";s:11:\"story_image\";s:66:\"https://api.wpmet.com/auth/wp-content/uploads/2025/10/GetGenie.gif\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";}}s:8:\"10020922\";O:8:\"stdClass\":9:{s:2:\"id\";i:10020922;s:5:\"title\";s:20:\"Hallowwen Wpmet 2025\";s:11:\"description\";s:0:\"\";s:7:\"plugins\";a:7:{i:0;s:16:\"elementskit-lite\";i:1;s:8:\"emailkit\";i:2;s:21:\"gutenkit-blocks-addon\";i:3;s:7:\"metform\";i:4;s:10:\"shopengine\";i:5;s:9:\"wp-social\";i:6;s:18:\"wp-ultimate-review\";}s:4:\"type\";s:6:\"banner\";s:8:\"priority\";s:4:\"high\";s:5:\"start\";i:1760486400;s:3:\"end\";i:1762128000;s:4:\"data\";O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"banner\";s:10:\"story_link\";s:28:\"https://wpmet.com/wpstoryh78\";s:11:\"story_image\";s:65:\"https://api.wpmet.com/auth/wp-content/uploads/2025/10/Wpmet-1.gif\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";}}s:8:\"10020276\";O:8:\"stdClass\":9:{s:2:\"id\";i:10020276;s:5:\"title\";s:17:\"GetGenie 30K Deal\";s:11:\"description\";s:0:\"\";s:7:\"plugins\";a:2:{i:0;s:8:\"getgenie\";i:1;s:12:\"getgenie-pro\";}s:4:\"type\";s:6:\"banner\";s:8:\"priority\";s:4:\"high\";s:5:\"start\";i:1757203200;s:3:\"end\";i:1758499200;s:4:\"data\";O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"banner\";s:10:\"story_link\";s:28:\"https://getgenie.ai/30kstory\";s:11:\"story_image\";s:71:\"https://api.wpmet.com/auth/wp-content/uploads/2025/09/Genie-30K-GIF.gif\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";}}s:8:\"10019442\";O:8:\"stdClass\":9:{s:2:\"id\";i:10019442;s:5:\"title\";s:23:\"Wpmet Birthday 25 Genie\";s:11:\"description\";s:0:\"\";s:7:\"plugins\";a:1:{i:0;s:8:\"getgenie\";}s:4:\"type\";s:6:\"banner\";s:8:\"priority\";s:4:\"high\";s:5:\"start\";i:1753920000;s:3:\"end\";i:1755561600;s:4:\"data\";O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"banner\";s:10:\"story_link\";s:32:\"https://wpmet.com/gbday-story-25\";s:11:\"story_image\";s:63:\"https://api.wpmet.com/auth/wp-content/uploads/2025/07/Genie.gif\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";}}s:8:\"10019440\";O:8:\"stdClass\":9:{s:2:\"id\";i:10019440;s:5:\"title\";s:19:\"Wpmet Birthday 2025\";s:11:\"description\";s:0:\"\";s:7:\"plugins\";a:6:{i:0;s:8:\"emailkit\";i:1;s:21:\"gutenkit-blocks-addon\";i:2;s:7:\"metform\";i:3;s:10:\"shopengine\";i:4;s:9:\"wp-social\";i:5;s:18:\"wp-ultimate-review\";}s:4:\"type\";s:6:\"banner\";s:8:\"priority\";s:4:\"high\";s:5:\"start\";i:1753920000;s:3:\"end\";i:1755561600;s:4:\"data\";O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"banner\";s:10:\"story_link\";s:31:\"https://wpmet.com/bday-story-25\";s:11:\"story_image\";s:60:\"https://api.wpmet.com/auth/wp-content/uploads/2025/07/WP.gif\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";}}s:8:\"10018690\";O:8:\"stdClass\":9:{s:2:\"id\";i:10018690;s:5:\"title\";s:36:\"GetGenie 4th of July Flash Sale 2025\";s:11:\"description\";s:0:\"\";s:7:\"plugins\";a:2:{i:0;s:8:\"getgenie\";i:1;s:12:\"getgenie-pro\";}s:4:\"type\";s:6:\"banner\";s:8:\"priority\";s:4:\"high\";s:5:\"start\";i:1751328000;s:3:\"end\";i:1752019200;s:4:\"data\";O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"banner\";s:10:\"story_link\";s:27:\"https://getgenie.ai/story45\";s:11:\"story_image\";s:71:\"https://api.wpmet.com/auth/wp-content/uploads/2025/07/GetGenie__Gif.gif\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";}}}","auto"),
("281","_elementor_element_cache_unique_id","ceeb2fa378943b9ac83749a5068be06a","auto"),
("282","_elementor_home_screen_data","a:2:{s:7:\"timeout\";i:1759820524;s:5:\"value\";s:11286:\"{\"top_with_licences\":[{\"license\":[\"free\"],\"title_small\":\"Hi!\",\"title\":\"Unleash your imagination with Elementor\",\"description\":\"Start building your website with Elementor\'s no code drag & drop editor.\",\"button_create_page_title\":\"Create a Page\",\"button_watch_title\":\"Watch a guide\",\"button_watch_url\":\"https:\\/\\/www.youtube.com\\/watch?v=le72grP_Q6k&t=1s\",\"youtube_embed_id\":\"le72grP_Q6k?si=g2akyWNODL6usu6u\"},{\"license\":[\"pro\"],\"title_small\":\"Hi!\",\"title\":\"Unleash your imagination with Elementor\",\"description\":\"Now you\'ve got all the tools to start creating professional, high-performing websites - and that journey begins by creating your first page.\",\"button_create_page_title\":\"Create a Page\",\"button_watch_title\":\"Watch a guide\",\"button_watch_url\":\"https:\\/\\/www.youtube.com\\/watch?v=QdkDGrS8ZZs\",\"youtube_embed_id\":\"QdkDGrS8ZZs?si=s_VjZCQR6Fh1jgB5\"}],\"get_started\":[{\"license\":[\"free\"],\"header\":{\"title\":\"Jumpstart your web-creation\",\"description\":\"These quick actions will get your site airborne with a customized design.\"},\"repeater\":[{\"title\":\"Site Settings\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"title_small_color\":\"text.tertiary\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/site-settings.svg\"},{\"title\":\"Site Logo\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"title_small_color\":\"text.tertiary\",\"tab_id\":\"settings-site-identity\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/site-logo.svg\"},{\"title\":\"Global Colors\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"title_small_color\":\"text.tertiary\",\"tab_id\":\"global-colors\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/global-colors.svg\"},{\"title\":\"Global Fonts\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"title_small_color\":\"text.tertiary\",\"tab_id\":\"global-typography\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/global-fonts.svg\"},{\"title\":\"Theme Builder\",\"title_small\":\"Customize\",\"url\":\"admin.php?page=elementor-app\",\"is_relative_url\":false,\"title_small_color\":\"text.tertiary\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/theme-builder.svg\"},{\"title\":\"Popups\",\"title_small\":\"Customize\",\"url\":\"edit.php?post_type=elementor_library&page=popup_templates\",\"is_relative_url\":true,\"title_small_color\":\"text.tertiary\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/popups.svg\"},{\"title\":\"Custom Icons\",\"title_small\":\"Customize\",\"url\":\"admin.php?page=elementor_custom_icons\",\"is_relative_url\":false,\"title_small_color\":\"text.tertiary\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/custom-icons.svg\"},{\"title\":\"Custom Fonts\",\"title_small\":\"Customize\",\"url\":\"admin.php?page=elementor_custom_fonts\",\"is_relative_url\":true,\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/custom-fonts.svg\",\"title_small_color\":\"text.tertiary\"}]},{\"license\":[\"pro\"],\"header\":{\"title\":\"Jumpstart your web-creation\",\"description\":\"These quick actions will get your site airborne with a customized design.\"},\"repeater\":[{\"title\":\"Site Settings\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/site-settings.svg\"},{\"title\":\"Site Logo\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"tab_id\":\"settings-site-identity\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/site-logo.svg\"},{\"title\":\"Global Colors\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"tab_id\":\"global-colors\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/global-colors.svg\"},{\"title\":\"Global Fonts\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"tab_id\":\"global-typography\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/global-fonts.svg\"},{\"title\":\"Theme Builder\",\"title_small\":\"Customize\",\"url\":\"admin.php?page=elementor-app\",\"is_relative_url\":false,\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/theme-builder.svg\"},{\"title\":\"Popups\",\"title_small\":\"Customize\",\"url\":\"edit.php?post_type=elementor_library&tabs_group=popup&elementor_library_type=popup\",\"is_relative_url\":true,\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/popups.svg\"},{\"title\":\"Custom Icons\",\"title_small\":\"Customize\",\"url\":\"admin.php?page=elementor_custom_icons\",\"is_relative_url\":false,\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/custom-icons.svg\"},{\"title\":\"Custom Fonts\",\"title_small\":\"Customize\",\"url\":\"admin.php?page=elementor_custom_fonts\",\"is_relative_url\":true,\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/custom-fonts.svg\"}]}],\"add_ons\":{\"header\":{\"title\":\"Expand your design toolkit\",\"description\":\"These plugins, add-ons, and tools, have been selected to streamline your workflow and maximize your creativity.\"},\"repeater\":[{\"file_path\":\"pojo-accessibility\\/pojo-accessibility.php\",\"title\":\"Ally - Web Accessibility. Simplified.\",\"url\":\"\",\"description\":\"Make your website more accessible with powerful tools to detect and fix issues, enhance usability, and create a better experience for all visitors.\",\"button_label\":\"Install\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/ally_logo.svg\",\"type\":\"wporg\"},{\"file_path\":\"send-app\\/send-app.php\",\"title\":\"Send \\u2013 Marketing Automation\",\"url\":\"\",\"description\":\"Supercharge your WooCommerce store with Send\\u2014an all-in-one toolkit for emails, popups & more. Built for WordPress. No plugins, no hassle.\",\"button_label\":\"Install\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/send-logo.svg\",\"type\":\"wporg\"},{\"file_path\":\"site-mailer\\/site-mailer.php\",\"title\":\"Site Mailer\",\"url\":\"\",\"description\":\"Keep your WordPress emails out of the spam folder with improved deliverability and an easy setup\\u2014no need for an SMTP plugin or complicated configurations.\",\"button_label\":\"Install\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/site-mailer.svg\",\"type\":\"wporg\"},{\"file_path\":\"image-optimization\\/image-optimization.php\",\"title\":\"Image Optimizer\",\"url\":\"https:\\/\\/go.elementor.com\\/wp-dash-apps-author-uri-elementor-io\\/\",\"description\":\"Check out this incredibly useful plugin that will compress and optimize your images, giving you leaner, faster websites.\",\"button_label\":\"Install\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/image-optimizer.svg\",\"type\":\"wporg\"},{\"title\":\"Elementor AI\",\"url\":\"https:\\/\\/go.elementor.com\\/wp-dash-apps-author-uri-elementor-ai\\/\",\"description\":\"Boost creativity with Elementor AI. Craft & enhance copy, create custom CSS & Code, and generate images to elevate your website.\",\"button_label\":\"Let\'s go\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/elementor.svg\",\"type\":\"link\",\"condition\":{\"key\":\"introduction_meta\",\"value\":\"ai_get_started\"}}],\"footer\":{\"label\":\"Explore more add-ons\",\"file_path\":\"wp-admin\\/admin.php?page=elementor-apps\"}},\"sidebar_upgrade\":[{\"license\":[\"free\"],\"show\":\"true\",\"header\":{\"title\":\"Bring your vision to life\",\"description\":\"Get complete design flexibility for your website with Elementor Pro\\u2019s advanced tools and premium features.\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-crown.svg\"},\"cta\":{\"label\":\"Upgrade Now\",\"url\":\"https:\\/\\/go.elementor.com\\/go-pro-home-sidebar-upgrade\\/\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-crown.svg\"},\"repeater\":[{\"title\":\"Popup Builder\"},{\"title\":\"Custom Code & CSS\"},{\"title\":\"E-commerce Features\"},{\"title\":\"Collaborative Notes\"},{\"title\":\"Form Submission\"},{\"title\":\"Form Integrations\"},{\"title\":\"Custom Attributes\"},{\"title\":\"Role Manager\"}]},{\"license\":[\"pro\"],\"show\":\"false\",\"header\":{\"title\":\"Bring your vision to life\",\"description\":\"Get complete design flexibility for your website with Elementor Pro\\u2019s advanced tools and premium features.\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-crown.svg\"},\"cta\":{\"label\":\"Upgrade Now\",\"url\":\"https:\\/\\/go.elementor.com\\/go-pro-home-sidebar-upgrade\\/\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-crown.svg\"},\"repeater\":[{\"title\":\"Popup Builder\"},{\"title\":\"Custom Code & CSS\"},{\"title\":\"E-commerce Features\"},{\"title\":\"Collaborative Notes\"},{\"title\":\"Form Submission\"},{\"title\":\"Form Integrations\"},{\"title\":\"Custom Attributes\"},{\"title\":\"Role Manager\"}]}],\"sidebar_promotion_variants\":[{\"license\":[\"essential\"],\"is_enabled\":\"true\",\"type\":\"banner\",\"data\":{\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/essential-upgrade.svg\",\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-advanced-home-sidebar-upgrade\\/\"}},{\"license\":[\"free\"],\"is_enabled\":\"true\",\"type\":\"banner\",\"data\":{\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/upgrade-free.svg\",\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-home-sidebar-upgrade\\/\"}},{\"license\":[\"expired\"],\"is_enabled\":\"true\",\"type\":\"banner\",\"data\":{\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/upgrade-free.svg\",\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-home-sidebar-expired\\/\"}},{\"license\":[\"free\"],\"is_enabled\":\"false\",\"type\":\"default\",\"data\":{\"header\":{\"title\":\"Bring your vision to life\",\"description\":\"Get complete design flexibility for your website with Elementor Pro\\u2019s advanced tools and premium features.\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/update-sidebar.svg\"},\"cta\":{\"label\":\"Upgrade Now\",\"url\":\"https:\\/\\/go.elementor.com\\/go-pro-home-sidebar-upgrade\\/\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-crown.svg\"},\"repeater\":[{\"title\":\"Popup Builder\"},{\"title\":\"Custom Code & CSS\"},{\"title\":\"E-commerce Features\"},{\"title\":\"Collaborative Notes\"},{\"title\":\"Form Submission\"},{\"title\":\"Form Integrations\"},{\"title\":\"Custom Attributes\"},{\"title\":\"Role Manager\"}]}},{\"license\":[\"pro\"],\"is_enabled\":\"false\",\"type\":\"default\",\"data\":{\"header\":{\"title\":\"Bring your vision to life\",\"description\":\"Get complete design flexibility for your website with Elementor Pro\\u2019s advanced tools and premium features.\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/update-sidebar.svg\"},\"cta\":{\"label\":\"Upgrade Now\",\"url\":\"https:\\/\\/go.elementor.com\\/go-pro-home-sidebar-upgrade\\/\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-crown.svg\"},\"repeater\":[{\"title\":\"Popup Builder\"},{\"title\":\"Custom Code & CSS\"},{\"title\":\"E-commerce Features\"},{\"title\":\"Collaborative Notes\"},{\"title\":\"Form Submission\"},{\"title\":\"Form Integrations\"},{\"title\":\"Custom Attributes\"},{\"title\":\"Role Manager\"}]}}],\"external_links\":[{\"label\":\"Help Center\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-question-mark.svg\",\"url\":\"https:\\/\\/elementor.com\\/help\\/\"},{\"label\":\"Youtube\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-youtube.svg\",\"url\":\"https:\\/\\/www.youtube.com\\/@Elementor\"},{\"label\":\"Facebook Community\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-community.svg\",\"url\":\"https:\\/\\/www.facebook.com\\/groups\\/Elementors\"},{\"label\":\"Blog\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-academic-hat.svg\",\"url\":\"https:\\/\\/elementor.com\\/blog\\/\"}]}\";}","off"),
("303","elementor_pro_theme_builder_conditions","a:4:{s:7:\"archive\";a:1:{i:81;a:1:{i:0;s:15:\"include/archive\";}}s:6:\"single\";a:2:{i:79;a:1:{i:0;s:21:\"include/singular/post\";}i:76;a:1:{i:0;s:29:\"include/singular/not_found404\";}}s:6:\"footer\";a:1:{i:16;a:1:{i:0;s:15:\"include/general\";}}s:6:\"header\";a:1:{i:12;a:1:{i:0;s:15:\"include/general\";}}}","auto"),
("305","elementskit_options","a:4:{s:11:\"widget_list\";a:43:{s:15:\"image-accordion\";a:5:{s:4:\"slug\";s:15:\"image-accordion\";s:5:\"title\";s:15:\"Image Accordion\";s:7:\"package\";s:4:\"free\";s:15:\"widget-category\";s:7:\"general\";s:6:\"status\";s:8:\"inactive\";}s:9:\"accordion\";a:5:{s:4:\"slug\";s:9:\"accordion\";s:5:\"title\";s:9:\"Accordion\";s:7:\"package\";s:4:\"free\";s:15:\"widget-category\";s:7:\"general\";s:6:\"status\";s:6:\"active\";}s:6:\"button\";a:5:{s:4:\"slug\";s:6:\"button\";s:5:\"title\";s:6:\"Button\";s:7:\"package\";s:4:\"free\";s:15:\"widget-category\";s:7:\"general\";s:6:\"status\";s:6:\"active\";}s:7:\"heading\";a:5:{s:4:\"slug\";s:7:\"heading\";s:5:\"title\";s:7:\"Heading\";s:7:\"package\";s:4:\"free\";s:15:\"widget-category\";s:7:\"general\";s:6:\"status\";s:6:\"active\";}s:10:\"blog-posts\";a:5:{s:4:\"slug\";s:10:\"blog-posts\";s:5:\"title\";s:10:\"Blog Posts\";s:7:\"package\";s:4:\"free\";s:15:\"widget-category\";s:8:\"wp-posts\";s:6:\"status\";s:6:\"active\";}s:8:\"icon-box\";a:5:{s:4:\"slug\";s:8:\"icon-box\";s:5:\"title\";s:8:\"Icon Box\";s:7:\"package\";s:4:\"free\";s:15:\"widget-category\";s:7:\"general\";s:6:\"status\";s:6:\"active\";}s:9:\"image-box\";a:5:{s:4:\"slug\";s:9:\"image-box\";s:5:\"title\";s:9:\"Image Box\";s:7:\"package\";s:4:\"free\";s:15:\"widget-category\";s:7:\"general\";s:6:\"status\";s:6:\"active\";}s:15:\"countdown-timer\";a:5:{s:4:\"slug\";s:15:\"countdown-timer\";s:5:\"title\";s:15:\"Countdown Timer\";s:7:\"package\";s:4:\"free\";s:15:\"widget-category\";s:7:\"general\";s:6:\"status\";s:8:\"inactive\";}s:11:\"client-logo\";a:5:{s:4:\"slug\";s:11:\"client-logo\";s:5:\"title\";s:11:\"Client Logo\";s:7:\"package\";s:4:\"free\";s:15:\"widget-category\";s:7:\"general\";s:6:\"status\";s:6:\"active\";}s:3:\"faq\";a:5:{s:4:\"slug\";s:3:\"faq\";s:5:\"title\";s:3:\"FAQ\";s:7:\"package\";s:4:\"free\";s:15:\"widget-category\";s:7:\"general\";s:6:\"status\";s:6:\"active\";}s:7:\"funfact\";a:5:{s:4:\"slug\";s:7:\"funfact\";s:5:\"title\";s:7:\"Funfact\";s:7:\"package\";s:4:\"free\";s:15:\"widget-category\";s:7:\"general\";s:6:\"status\";s:6:\"active\";}s:16:\"image-comparison\";a:5:{s:4:\"slug\";s:16:\"image-comparison\";s:5:\"title\";s:16:\"Image Comparison\";s:7:\"package\";s:4:\"free\";s:15:\"widget-category\";s:7:\"general\";s:6:\"status\";s:8:\"inactive\";}s:6:\"lottie\";a:5:{s:4:\"slug\";s:6:\"lottie\";s:5:\"title\";s:6:\"Lottie\";s:7:\"package\";s:4:\"free\";s:15:\"widget-category\";s:7:\"general\";s:6:\"status\";s:8:\"inactive\";}s:11:\"testimonial\";a:5:{s:4:\"slug\";s:11:\"testimonial\";s:5:\"title\";s:11:\"Testimonial\";s:7:\"package\";s:4:\"free\";s:15:\"widget-category\";s:7:\"general\";s:6:\"status\";s:6:\"active\";}s:7:\"pricing\";a:5:{s:4:\"slug\";s:7:\"pricing\";s:5:\"title\";s:13:\"Pricing Table\";s:7:\"package\";s:4:\"free\";s:15:\"widget-category\";s:7:\"general\";s:6:\"status\";s:6:\"active\";}s:4:\"team\";a:5:{s:4:\"slug\";s:4:\"team\";s:5:\"title\";s:4:\"Team\";s:7:\"package\";s:4:\"free\";s:15:\"widget-category\";s:7:\"general\";s:6:\"status\";s:6:\"active\";}s:6:\"social\";a:5:{s:4:\"slug\";s:6:\"social\";s:5:\"title\";s:12:\"Social Icons\";s:7:\"package\";s:4:\"free\";s:15:\"widget-category\";s:7:\"general\";s:6:\"status\";s:6:\"active\";}s:11:\"progressbar\";a:5:{s:4:\"slug\";s:11:\"progressbar\";s:5:\"title\";s:12:\"Progress Bar\";s:7:\"package\";s:4:\"free\";s:15:\"widget-category\";s:7:\"general\";s:6:\"status\";s:8:\"inactive\";}s:13:\"category-list\";a:5:{s:4:\"slug\";s:13:\"category-list\";s:5:\"title\";s:13:\"Category List\";s:7:\"package\";s:4:\"free\";s:15:\"widget-category\";s:8:\"wp-posts\";s:6:\"status\";s:6:\"active\";}s:9:\"page-list\";a:5:{s:4:\"slug\";s:9:\"page-list\";s:5:\"title\";s:9:\"Page List\";s:7:\"package\";s:4:\"free\";s:15:\"widget-category\";s:13:\"header-footer\";s:6:\"status\";s:6:\"active\";}s:9:\"post-grid\";a:5:{s:4:\"slug\";s:9:\"post-grid\";s:5:\"title\";s:9:\"Post Grid\";s:7:\"package\";s:4:\"free\";s:15:\"widget-category\";s:8:\"wp-posts\";s:6:\"status\";s:8:\"inactive\";}s:9:\"post-list\";a:5:{s:4:\"slug\";s:9:\"post-list\";s:5:\"title\";s:9:\"Post List\";s:7:\"package\";s:4:\"free\";s:15:\"widget-category\";s:8:\"wp-posts\";s:6:\"status\";s:6:\"active\";}s:8:\"post-tab\";a:5:{s:4:\"slug\";s:8:\"post-tab\";s:5:\"title\";s:8:\"Post Tab\";s:7:\"package\";s:4:\"free\";s:15:\"widget-category\";s:8:\"wp-posts\";s:6:\"status\";s:8:\"inactive\";}s:8:\"nav-menu\";a:5:{s:4:\"slug\";s:8:\"nav-menu\";s:5:\"title\";s:20:\"ElementsKit Nav Menu\";s:7:\"package\";s:4:\"free\";s:15:\"widget-category\";s:13:\"header-footer\";s:6:\"status\";s:6:\"active\";}s:10:\"mail-chimp\";a:5:{s:4:\"slug\";s:10:\"mail-chimp\";s:5:\"title\";s:9:\"MailChimp\";s:7:\"package\";s:4:\"free\";s:15:\"widget-category\";s:12:\"form-widgets\";s:6:\"status\";s:8:\"inactive\";}s:11:\"header-info\";a:5:{s:4:\"slug\";s:11:\"header-info\";s:5:\"title\";s:11:\"Header Info\";s:7:\"package\";s:4:\"free\";s:15:\"widget-category\";s:13:\"header-footer\";s:6:\"status\";s:6:\"active\";}s:8:\"piechart\";a:5:{s:4:\"slug\";s:8:\"piechart\";s:5:\"title\";s:9:\"Pie Chart\";s:7:\"package\";s:4:\"free\";s:15:\"widget-category\";s:7:\"general\";s:6:\"status\";s:8:\"inactive\";}s:13:\"header-search\";a:5:{s:4:\"slug\";s:13:\"header-search\";s:5:\"title\";s:13:\"Header Search\";s:7:\"package\";s:4:\"free\";s:15:\"widget-category\";s:13:\"header-footer\";s:6:\"status\";s:6:\"active\";}s:16:\"header-offcanvas\";a:5:{s:4:\"slug\";s:16:\"header-offcanvas\";s:5:\"title\";s:16:\"Header Offcanvas\";s:7:\"package\";s:4:\"free\";s:15:\"widget-category\";s:13:\"header-footer\";s:6:\"status\";s:6:\"active\";}s:3:\"tab\";a:5:{s:4:\"slug\";s:3:\"tab\";s:5:\"title\";s:3:\"Tab\";s:7:\"package\";s:4:\"free\";s:15:\"widget-category\";s:7:\"general\";s:6:\"status\";s:6:\"active\";}s:13:\"contact-form7\";a:5:{s:4:\"slug\";s:13:\"contact-form7\";s:5:\"title\";s:13:\"Contact Form7\";s:7:\"package\";s:4:\"free\";s:15:\"widget-category\";s:12:\"form-widgets\";s:6:\"status\";s:8:\"inactive\";}s:5:\"video\";a:5:{s:4:\"slug\";s:5:\"video\";s:5:\"title\";s:5:\"Video\";s:7:\"package\";s:4:\"free\";s:15:\"widget-category\";s:7:\"general\";s:6:\"status\";s:6:\"active\";}s:14:\"business-hours\";a:5:{s:4:\"slug\";s:14:\"business-hours\";s:5:\"title\";s:14:\"Business Hours\";s:7:\"package\";s:4:\"free\";s:15:\"widget-category\";s:7:\"general\";s:6:\"status\";s:8:\"inactive\";}s:9:\"drop-caps\";a:5:{s:4:\"slug\";s:9:\"drop-caps\";s:5:\"title\";s:9:\"Drop Caps\";s:7:\"package\";s:4:\"free\";s:15:\"widget-category\";s:7:\"general\";s:6:\"status\";s:8:\"inactive\";}s:12:\"social-share\";a:5:{s:4:\"slug\";s:12:\"social-share\";s:5:\"title\";s:12:\"Social Share\";s:7:\"package\";s:4:\"free\";s:15:\"widget-category\";s:7:\"general\";s:6:\"status\";s:8:\"inactive\";}s:11:\"dual-button\";a:5:{s:4:\"slug\";s:11:\"dual-button\";s:5:\"title\";s:11:\"Dual Button\";s:7:\"package\";s:4:\"free\";s:15:\"widget-category\";s:7:\"general\";s:6:\"status\";s:8:\"inactive\";}s:13:\"caldera-forms\";a:5:{s:4:\"slug\";s:13:\"caldera-forms\";s:5:\"title\";s:13:\"Caldera Forms\";s:7:\"package\";s:4:\"free\";s:15:\"widget-category\";s:12:\"form-widgets\";s:6:\"status\";s:8:\"inactive\";}s:8:\"we-forms\";a:5:{s:4:\"slug\";s:8:\"we-forms\";s:5:\"title\";s:7:\"weForms\";s:7:\"package\";s:4:\"free\";s:15:\"widget-category\";s:12:\"form-widgets\";s:6:\"status\";s:8:\"inactive\";}s:8:\"wp-forms\";a:5:{s:4:\"slug\";s:8:\"wp-forms\";s:5:\"title\";s:7:\"WPForms\";s:7:\"package\";s:4:\"free\";s:15:\"widget-category\";s:12:\"form-widgets\";s:6:\"status\";s:8:\"inactive\";}s:11:\"ninja-forms\";a:5:{s:4:\"slug\";s:11:\"ninja-forms\";s:5:\"title\";s:11:\"Ninja Forms\";s:7:\"package\";s:4:\"free\";s:15:\"widget-category\";s:12:\"form-widgets\";s:6:\"status\";s:8:\"inactive\";}s:10:\"tablepress\";a:5:{s:4:\"slug\";s:10:\"tablepress\";s:5:\"title\";s:10:\"TablePress\";s:7:\"package\";s:4:\"free\";s:15:\"widget-category\";s:7:\"general\";s:6:\"status\";s:8:\"inactive\";}s:12:\"fluent-forms\";a:5:{s:4:\"slug\";s:12:\"fluent-forms\";s:5:\"title\";s:12:\"Fluent Forms\";s:7:\"package\";s:4:\"free\";s:15:\"widget-category\";s:12:\"form-widgets\";s:6:\"status\";s:8:\"inactive\";}s:11:\"back-to-top\";a:5:{s:4:\"slug\";s:11:\"back-to-top\";s:5:\"title\";s:11:\"Back To Top\";s:7:\"package\";s:4:\"free\";s:15:\"widget-category\";s:7:\"general\";s:6:\"status\";s:8:\"inactive\";}}s:11:\"module_list\";a:5:{s:21:\"elementskit-icon-pack\";a:5:{s:4:\"slug\";s:21:\"elementskit-icon-pack\";s:5:\"title\";s:21:\"ElementsKit Icon Pack\";s:7:\"package\";s:4:\"free\";s:10:\"attributes\";a:1:{i:0;s:3:\"new\";}s:6:\"status\";s:6:\"active\";}s:13:\"header-footer\";a:4:{s:4:\"slug\";s:13:\"header-footer\";s:5:\"title\";s:13:\"Header Footer\";s:7:\"package\";s:4:\"free\";s:6:\"status\";s:6:\"active\";}s:8:\"megamenu\";a:4:{s:4:\"slug\";s:8:\"megamenu\";s:7:\"package\";s:4:\"free\";s:5:\"title\";s:9:\"Mega Menu\";s:6:\"status\";s:6:\"active\";}s:14:\"onepage-scroll\";a:4:{s:4:\"slug\";s:14:\"onepage-scroll\";s:7:\"package\";s:4:\"free\";s:5:\"title\";s:14:\"Onepage Scroll\";s:6:\"status\";s:8:\"inactive\";}s:14:\"widget-builder\";a:4:{s:4:\"slug\";s:14:\"widget-builder\";s:7:\"package\";s:4:\"free\";s:5:\"title\";s:14:\"Widget Builder\";s:6:\"status\";s:8:\"inactive\";}}s:8:\"settings\";a:2:{s:20:\"filter_widget_module\";s:5:\"basic\";s:16:\"newsletter_email\";s:0:\"\";}s:17:\"megamenu_settings\";a:1:{s:16:\"menu_location_10\";a:1:{s:10:\"is_enabled\";i:0;}}}","auto"),
("306","elements_kit_onboard_status","onboarded","auto"),
("307","envato_elements_options","a:1:{i:1;a:1:{s:17:\"dismissed_banners\";a:1:{s:17:\"templateKitBanner\";b:1;}}}","off"),
("325","nav_menu_options","a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}","off"),
("336","_elementor_pro_api_requests_lock","a:1:{s:11:\"get_version\";i:1766424480;}","auto"),
("442","elementor_library_category_children","a:0:{}","auto"),
("543","category_children","a:0:{}","auto"),
("560","elementor_pro_tracker_notice","1","auto"),
("561","elementor_allow_tracking","no","auto"),
("562","elementor_tracker_notice","1","auto"),
("616","elementskit-lite_never_show","yes","auto"),
("738","swift_performance_plugin_organizer","a:0:{}","auto"),
("739","jetpack_active_modules","a:0:{}","auto"),
("768","site_logo","230","auto"),
("791","WPLANG","","auto"),
("792","new_admin_email","clickbizdigital@gmail.com","auto"),
("1133","auto_core_update_notified","a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:25:\"clickbizdigital@gmail.com\";s:7:\"version\";s:3:\"6.9\";s:9:\"timestamp\";i:1764903404;}","off"),
("1368","elementor_disabled_elements","a:21:{i:0;s:27:\"elementskit-image-accordion\";i:1;s:27:\"elementskit-countdown-timer\";i:2;s:28:\"elementskit-image-comparison\";i:3;s:18:\"elementskit-lottie\";i:4;s:23:\"elementskit-progressbar\";i:5;s:21:\"elementskit-post-grid\";i:6;s:20:\"elementskit-post-tab\";i:7;s:22:\"elementskit-mail-chimp\";i:8;s:20:\"elementskit-piechart\";i:9;s:25:\"elementskit-contact-form7\";i:10;s:26:\"elementskit-business-hours\";i:11;s:21:\"elementskit-drop-caps\";i:12;s:24:\"elementskit-social-share\";i:13;s:23:\"elementskit-dual-button\";i:14;s:25:\"elementskit-caldera-forms\";i:15;s:20:\"elementskit-we-forms\";i:16;s:20:\"elementskit-wp-forms\";i:17;s:23:\"elementskit-ninja-forms\";i:18;s:22:\"elementskit-tablepress\";i:19;s:24:\"elementskit-fluent-forms\";i:20;s:23:\"elementskit-back-to-top\";}","auto"),
("1376","duplicator_pro_license_key","activated","auto"),
("1377","duplicator_pro_capabilities","a:9:{s:20:\"duplicator_pro_basic\";a:2:{s:5:\"roles\";a:1:{i:0;s:13:\"administrator\";}s:5:\"users\";a:0:{}}s:21:\"duplicator_pro_create\";a:2:{s:5:\"roles\";a:1:{i:0;s:13:\"administrator\";}s:5:\"users\";a:0:{}}s:23:\"duplicator_pro_schedule\";a:2:{s:5:\"roles\";a:1:{i:0;s:13:\"administrator\";}s:5:\"users\";a:0:{}}s:22:\"duplicator_pro_storage\";a:2:{s:5:\"roles\";a:1:{i:0;s:13:\"administrator\";}s:5:\"users\";a:0:{}}s:29:\"duplicator_pro_backup_restore\";a:2:{s:5:\"roles\";a:1:{i:0;s:13:\"administrator\";}s:5:\"users\";a:0:{}}s:21:\"duplicator_pro_import\";a:2:{s:5:\"roles\";a:1:{i:0;s:13:\"administrator\";}s:5:\"users\";a:0:{}}s:21:\"duplicator_pro_export\";a:2:{s:5:\"roles\";a:1:{i:0;s:13:\"administrator\";}s:5:\"users\";a:0:{}}s:23:\"duplicator_pro_settings\";a:2:{s:5:\"roles\";a:1:{i:0;s:13:\"administrator\";}s:5:\"users\";a:0:{}}s:22:\"duplicator_pro_license\";a:2:{s:5:\"roles\";a:1:{i:0;s:13:\"administrator\";}s:5:\"users\";a:0:{}}}","auto"),
("1379","duplicator_pro_plugin_version","4.5.24","on"),
("1381","edd_sl_d4cddcbfacec1cb84c2108addd3c8f99","a:2:{s:7:\"timeout\";i:1766370757;s:5:\"value\";s:478:\"{\"new_version\":\"\",\"stable_version\":\"\",\"name\":\"Duplicator Pro\",\"slug\":\"duplicator-pro\",\"url\":\"https:\\/\\/duplicator.com\",\"last_updated\":\"2025-12-21T23:32:37.934Z\",\"homepage\":\"https:\\/\\/duplicator.com\",\"package\":\"\",\"download_link\":\"\",\"sections\":{\"description\":\"Professional WordPress Migration Plugin\",\"changelog\":\"\"},\"description\":[\"Professional WordPress Migration Plugin\"],\"changelog\":[\"\"],\"plugin\":\"duplicator-pro\\/duplicator-pro.php\",\"id\":\"duplicator-pro\\/duplicator-pro.php\"}\";}","off");

INSERT IGNORE INTO `wp_options` VALUES 
("1382","duplicator_pro_notifications","a:4:{s:6:\"update\";i:1768448345;s:4:\"feed\";a:0:{}s:6:\"events\";a:0:{}s:9:\"dismissed\";a:0:{}}","auto"),
("1383","duplicator_expire_tmp_cleanup_check","{\"expire\":1768517789,\"value\":true}","on"),
("1384","duplicator_expire_daily_bootstrap_actions","{\"expire\":1768517789,\"value\":true}","on"),
("1385","duplicator_expire_rename_delay","{\"expire\":1768474589,\"value\":true}","on"),
("1388","duplicator_expire_license_check","{\"expire\":1768448370,\"value\":true}","on"),
("1389","duplicator_expire_duplicator_pro_frotend_delay","{\"expire\":1768448369,\"value\":true}","on"),
("1394","duplicator_pro_exe_safe_mode","0","yes"),
("1395","duplicator_pro_activate_plugins_after_installation","a:0:{}","yes"),
("1397","duplicator_pro_migration_data","{\n    \"plugin\": \"dup-pro\",\n    \"installerVersion\": \"4.5.24\",\n    \"installType\": -1,\n    \"installTime\": \"2025-11-10 05:47:09\",\n    \"logicModes\": [\n        \"CLASSIC\"\n    ],\n    \"template\": \"base\",\n    \"restoreBackupMode\": false,\n    \"recoveryMode\": false,\n    \"archivePath\": \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/20251110_uplusdental_c1d953df4b6e23a54455_20251110010659_archive.zip\",\n    \"packageId\": 2,\n    \"packageHash\": \"c1d953d-10010659\",\n    \"installerPath\": \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/installer (6).php\",\n    \"installerBootLog\": \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/dup-installer-bootlog__12737aa-10010659.txt\",\n    \"installerLog\": \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/dup-installer\\/dup-installer-log__12737aa-10010659.txt\",\n    \"dupInstallerPath\": \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/dup-installer\",\n    \"origFileFolderPath\": \"\\/home\\/cbprocom\\/public_html\\/preview\\/uplusdental\\/dup-installer\\/dup_descriptors_c1d953d-10010659\\/orig_files\",\n    \"safeMode\": 0,\n    \"cleanInstallerFiles\": true,\n    \"licenseType\": 11,\n    \"phpVersion\": \"8.3.26\",\n    \"archiveType\": \"zip\",\n    \"siteSize\": 96315596,\n    \"siteNumFiles\": 12501,\n    \"siteDbSize\": 55443456,\n    \"siteDBNumTables\": 19,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"ustatIdentifier\": \"\"\n}","no"),
("1403","_transient_wp_styles_for_blocks","a:2:{s:4:\"hash\";s:32:\"dc1b8f8e8ae79f2cb16614078265e3f4\";s:6:\"blocks\";a:6:{s:11:\"core/button\";s:0:\"\";s:14:\"core/site-logo\";s:0:\"\";s:18:\"core/post-template\";s:0:\"\";s:18:\"core/term-template\";s:0:\"\";s:12:\"core/columns\";s:0:\"\";s:14:\"core/pullquote\";s:69:\":root :where(.wp-block-pullquote){font-size: 1.5em;line-height: 1.6;}\";}}","on"),
("1415","duplicator_unique_id","f-zU0iqT9xWS4C+PnfHgqodhLYWp6beMH9YPQXaD-xgV","on"),
("1416","duplicator_pro_install_info","a:3:{s:7:\"version\";s:6:\"4.5.24\";s:4:\"time\";i:1762753663;s:10:\"updateTime\";i:1762753663;}","off"),
("1417","duplicator_pro_plugin_data_stats","{\n    \"CL_-=_-=\": \"Duplicator\\\\Utils\\\\UsageStatistics\\\\PluginData\",\n    \"lastSendTime\": 1767933341,\n    \"plugin\": \"dup-pro\",\n    \"pluginStatus\": \"active\",\n    \"anonymous\": false,\n    \"buildCount\": 2,\n    \"buildLastDate\": 1766365999,\n    \"buildFailedCount\": 0,\n    \"buildFailedLastDate\": 0,\n    \"packagesBuildCompFullCount\": 2,\n    \"packagesBuildCompDbOnlyCount\": 0,\n    \"packagesBuildCompMdOnlyCount\": 0,\n    \"packagesBuildCompCustomCount\": 0,\n    \"packagesBuildCompCustomOnlyActiveCount\": 0,\n    \"schedulesBuildCount\": 0,\n    \"schedulesBuildLastDate\": 0,\n    \"schedulesBuildFailedCount\": 0,\n    \"schedulesBuildFailedLastDate\": 0,\n    \"schedulesBuildCompFullCount\": 0,\n    \"schedulesBuildCompDbOnlyCount\": 0,\n    \"schedulesBuildCompMdOnlyCount\": 0,\n    \"schedulesBuildCompCustomCount\": 0,\n    \"schedulesBuildCompCustomOnlyActiveCount\": 0,\n    \"usedRecoveryCount\": 0,\n    \"siteSizeMB\": 236.969999999999998863131622783839702606201171875,\n    \"siteNumFiles\": 12552,\n    \"siteDbSizeMB\": 58.090000000000003410605131648480892181396484375,\n    \"siteDbNumTables\": 19\n}","auto"),
("1420","_transient_timeout__elementor_ab_test_plg_site_mailer_submission","1770529684","off"),
("1421","_transient__elementor_ab_test_plg_site_mailer_submission","2","off"),
("1433","_transient_ekit_element_manager_compatibity","1","on"),
("1555","_transient_health-check-site-status-result","{\"good\":19,\"recommended\":3,\"critical\":2}","on"),
("1575","_transient_timeout_elementskit-lite-go-pro-noti2ce","1789282285","off"),
("1576","_transient_elementskit-lite-go-pro-noti2ce","1","off"),
("1580","_site_transient_wp_plugin_dependencies_plugin_data","a:1:{s:9:\"elementor\";a:35:{s:4:\"name\";s:63:\"Elementor Website Builder &#8211; More Than Just a Page Builder\";s:4:\"slug\";s:9:\"elementor\";s:7:\"version\";s:6:\"3.33.6\";s:6:\"author\";s:64:\"<a href=\"https://profiles.wordpress.org/elemntor/\">Elementor</a>\";s:14:\"author_profile\";s:40:\"https://profiles.wordpress.org/elemntor/\";s:12:\"contributors\";a:1:{s:8:\"elemntor\";a:3:{s:7:\"profile\";s:40:\"https://profiles.wordpress.org/elemntor/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/7d70f15d78757f876d1847a8f87dd93e1d9c168264b4aeeaf72058656690d05b?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:9:\"Elementor\";}}s:8:\"requires\";s:3:\"6.6\";s:6:\"tested\";s:5:\"6.8.3\";s:12:\"requires_php\";s:3:\"7.4\";s:16:\"requires_plugins\";a:0:{}s:6:\"rating\";i:90;s:7:\"ratings\";a:5:{i:5;i:6087;i:4;i:218;i:3;i:110;i:2;i:106;i:1;i:636;}s:11:\"num_ratings\";i:7157;s:11:\"support_url\";s:47:\"https://wordpress.org/support/plugin/elementor/\";s:15:\"support_threads\";i:106;s:24:\"support_threads_resolved\";i:88;s:15:\"active_installs\";i:10000000;s:12:\"last_updated\";s:21:\"2025-12-18 3:42pm GMT\";s:5:\"added\";s:10:\"2016-05-30\";s:8:\"homepage\";s:87:\"https://elementor.com/?utm_source=wp-plugins&utm_campaign=plugin-uri&utm_medium=wp-dash\";s:8:\"sections\";a:6:{s:11:\"description\";s:25581:\"<p><iframe loading=\"lazy\" title=\"Elementor - The Leading Platform for Web Creators\" width=\"750\" height=\"422\" src=\"https://www.youtube.com/embed/le72grP_Q6k?feature=oembed\" frameborder=\"0\" allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share\" referrerpolicy=\"strict-origin-when-cross-origin\" allowfullscreen></iframe></p>\n<h4>THE #1 NO CODE DRAG &amp; DROP WORDPRESS WEBSITE BUILDER POWERING OVER 18M WEBSITES WORLDWIDE, NOW WITH AI.</h4>\n<p>Elementor, the leading WordPress website creation platform, empowers you to build professional, pixel-perfect websites seamlessly.</p>\n<p>Unlock all features with <a href=\"https://go.elementor.com/wp-repo-description-tab-elementor-pro-pro-features/\" rel=\"nofollow ugc\">Elementor Pro</a>.</p>\n<p>Need fast and secure cloud hosting for your Elementor site? Try out <strong><a href=\"https://elemn.to/repo-hosting\" rel=\"nofollow ugc\">Elementor Hosting</a></strong> Powered by Google Cloud &amp; Cloudflare. 4.9/5 TrustPilot score.</p>\n<h3>🌟 Create Professional Stunning Websites</h3>\n<ul>\n<li><strong><a href=\"https://go.elementor.com/feature-page-editor/\" rel=\"nofollow ugc\">Intuitive Drag &amp; Drop Builder</a></strong>: Build any website with our no-code, drag-and-drop Editor. Achieve design precision with full control over layout and style.</li>\n<li><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-pro-features-feature-page/\" rel=\"nofollow ugc\">Pixel-Perfect Design Tools</a></strong>: Upload SVGs, apply masks, gradients, box shadows, headline effects, shape dividers, and use built-in CSS controls for advanced customization.</li>\n<li><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-library-full-website-kit/\" rel=\"nofollow ugc\">Template Library</a></strong>: Apply complete website kits for instant setups, or choose from a vast library of single pages, blocks, and pop-up templates.</li>\n<li><strong><a href=\"https://go.elementor.com/feature-page-editor/\" rel=\"nofollow ugc\">Advanced Widgets</a></strong>: Access over 40 FREE widgets, including heading, image, text editor, video, button, gallery, carousels, and more.</li>\n<li><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-elementor-ai/\" rel=\"nofollow ugc\">AI Capabilities</a></strong>: Revolutionize your design and content creation process with native AI integration. Instantly create sections, text, code, and images.</li>\n</ul>\n<h4>🗝️ Key features:</h4>\n<ul>\n<li><strong><a href=\"https://go.elementor.com/feature-page-global-settings/\" rel=\"nofollow ugc\">Design System</a></strong>: Use Elementor&#8217;s Design System for consistent colors, typography, and design elements, ensuring a cohesive, professional look.</li>\n<li><strong><a href=\"https://go.elementor.com/feature-page-responsive-design/\" rel=\"nofollow ugc\">Responsive Design</a></strong>: Optimize your design for every device with custom breakpoints, ensuring a seamless desktop, tablet, and mobile experience.</li>\n<li><strong>Mask Shapes</strong>: Turning any element, like an image or video, into whatever shape you desire to create standout designs.</li>\n<li><strong>CSS Transform</strong>: Use CSS Transform to rotate, scale, and skew elements, adding dynamic styling to your site.</li>\n<li><strong>Entrance Animations</strong>: Add entrance animations to elements to create engaging and interactive user experiences.</li>\n<li><strong><a href=\"https://elementor.com/features/#SaveBackup\" rel=\"nofollow ugc\">Revision History</a></strong>: Elementor&#8217;s Revision History feature enables users to track and revert to previous versions of their designs, providing peace of mind and flexibility during the creative process.</li>\n<li><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-developers-developers-website/\" rel=\"nofollow ugc\">Developer-Friendly</a></strong>: Equipped with extensive documentation, API, developer tools, and custom code areas, Elementor offers a conducive environment for developers to extend its capabilities and create custom solutions.</li>\n<li><strong>Floating Buttons</strong>: Enhance user interaction with customizable, floating action buttons that stay in view as users scroll.</li>\n<li><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-pro-features-industry-leading-theme-builder/\" rel=\"nofollow ugc\">Theme Builder</a> [Pro]</strong>: Design every part of your site—headers, footers, posts, and archives—for complete control over appearance.</li>\n<li><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-pro-features-popup-builder/\" rel=\"nofollow ugc\">Popup Builder</a> [Pro]</strong>: Create eye-catching popups with Elementor&#8217;s Popup Builder, equipped with advanced targeting and triggering options to optimize user engagement and conversions.</li>\n<li><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-pro-features-professional-form-builder-and-submission-log/\" rel=\"nofollow ugc\">Forms</a> [Pro]</strong>: Design and integrate custom forms, utilizing advanced features and integrations to capture and manage submissions effectively.</li>\n<li><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-pro-features-woocommerce-builder/\" rel=\"nofollow ugc\">WooCommerce Builder</a> [Pro]</strong>: Integrate Elementor with WooCommerce to design custom product pages, shop layouts, archives, carts, checkout pages, my account, and more, enhancing your store&#8217;s visual appeal and functionality.</li>\n<li><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-pro-features-dynamic-content/\" rel=\"nofollow ugc\">Dynamic Content</a> [Pro]</strong>: Leverage dynamic content capabilities to create personalized and interactive web experiences by connecting your designs to various data sources.</li>\n<li><strong><a href=\"https://go.elementor.com/features-page-notes/\" rel=\"nofollow ugc\">Notes</a> [Pro]</strong>: Enhance team collaboration by using Elementor&#8217;s Notes feature to leave feedback and comments directly on the design interface.</li>\n<li><strong>Custom Code [Pro]</strong>: Insert custom code to extend the functionality of your site, offering flexibility for advanced customizations.</li>\n<li><strong>Custom CSS [Pro]</strong>: Apply Custom CSS to fine-tune the styling of elements, ensuring precise control over the design aspects.</li>\n<li><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-pro-features-motion-effects/\" rel=\"nofollow ugc\">Motion Effects</a> [Pro]</strong>: Add advanced motion effects to elements for a more dynamic and engaging user experience.</li>\n<li><strong>Custom Fonts &amp; Icons [Pro]</strong>: Upload and use custom fonts and icons to match your brand&#8217;s identity.</li>\n</ul>\n<h4>😍 Elementor FREE widgets</h4>\n<p>Unlock the potential of Elementor with our comprehensive suite of free widgets and tools, designed to empower your website creation process and elevate your design capabilities:</p>\n<ul>\n<li><strong>Heading</strong>. Add eye-catching headlines.</li>\n<li><strong>Image</strong>. Control the size, opacity and more.</li>\n<li><strong>Text Editor</strong>. Just like the WordPress editor.</li>\n<li><strong>Video</strong>. Add YouTube, Vimeo, Dailymotion or self-hosted videos.</li>\n<li><strong>Button</strong>. Create interactive buttons.</li>\n<li><strong>Link in Bio</strong>. Build link in bio components to promote your business / services.</li>\n<li><strong>Image Box</strong>. A box with image, headline and text.</li>\n<li><strong>Testimonials</strong>. Customer testimonials.</li>\n<li><strong>Icon</strong>. Place one or more of 600+ icons available.</li>\n<li><strong>Icon Box</strong>. An icon, headline, and text with one widget.</li>\n<li><strong>Social Icons</strong>. Link to your social pages with the Facebook/X (formerly Twitter) icons.</li>\n<li><strong>Image Gallery</strong>. Display your images in a grid.</li>\n<li><strong>Image Carousel</strong>. Create rotating carousels or sliders for chosen images.</li>\n<li><strong>Icon List</strong>. Use any icon to create a bullet list.</li>\n<li><strong>Counter</strong>. Show numbers in an escalating manner.</li>\n<li><strong>Progress Bar</strong>. Include an escalating progress bar.</li>\n<li><strong>Nested Tabs</strong>. Display content in vertical or horizontal tabs.</li>\n<li><strong>Nested Accordion</strong>. Display any type of content in collapsible sections.</li>\n<li><strong>Toggle</strong>. Use the Toggle to hide or display content, like FAQ.</li>\n<li><strong>Rating</strong>. Display how many stars (or another icon) other visitors gave.</li>\n<li><strong>Alert</strong>. Include a colored alert box to draw visitor’s attention.</li>\n<li><strong>HTML</strong>. Insert code into the page.</li>\n<li><strong>Shortcode</strong>. Insert shortcodes from any plugin into the page.</li>\n<li><strong>Menu Anchor</strong>. Link any menu to this anchor.</li>\n<li><strong>Read More</strong>. Set the Read More cut-off for the excerpt in archive pages.</li>\n<li><strong>Sidebar</strong>. Add sidebars onto the page.</li>\n<li><strong>Google Maps</strong>. Embed maps into the page.</li>\n<li><strong>SoundCloud</strong>. Add SoundCloud audio bits.</li>\n<li><strong>Divider</strong>. Separate content with a designed divider.</li>\n<li><strong>Spacer</strong>. Add space between elements.</li>\n<li><strong>Text Path</strong>. Attach your text to a path.</li>\n<li><strong>And counting&#8230;</strong></li>\n</ul>\n<h3>🚀 Enhance Your Website</h3>\n<p><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-performance-performance-page/\" rel=\"nofollow ugc\">High-Performing Websites</a></strong>: Website performance impacts your visitor’s experience and search result ranking. Elementor, in partnership with Google Chrome, continuously enhances performance without compromising design.</p>\n<p><strong>Key features include:</strong></p>\n<ul>\n<li><strong>Reduced DOM Output</strong>: Streamlined HTML structure for faster rendering.</li>\n<li><strong>Improved Media File Loading</strong>: Optimized loading of images, videos, and other media assets.</li>\n<li><strong>Reduced CSS and JS Files</strong>: Minimized and concatenated stylesheets and scripts for quicker loading times.</li>\n<li><strong>Lazy Loading</strong>: Deferred loading of non-critical resources to improve initial page load speed.</li>\n<li><strong>Faster Font Loading</strong>: Efficient delivery of web fonts to enhance text rendering speed.</li>\n<li><strong>Optimized Front-End Asset Loading</strong>: Efficient loading of assets like JavaScript and CSS to minimize render-blocking.</li>\n<li><strong>Element Caching</strong>: Cache frequently accessed design elements to reduce server response time and enhance overall performance.</li>\n</ul>\n<h3>🔥 Elementor Pro Features</h3>\n<p>Create unparalleled websites while saving time, money and resources with <a href=\"https://go.elementor.com/wp-repo-description-tab-elementor-pro-elementor-pro/\" rel=\"nofollow ugc\">Elementor Pro</a>’s full website builder. Get access to 100+ professional widgets, features, and tools.</p>\n<p><strong>Pro Design Widgets:</strong></p>\n<ol>\n<li><strong>Posts</strong>: Display your blog posts with customizable layouts and styles.</li>\n<li><strong>Share Buttons</strong>: Allow visitors to easily share your content on various social media platforms.</li>\n<li><strong>Portfolio</strong>: Showcase your work or projects with stunning portfolio layouts.</li>\n<li><strong>Slides</strong>: Create dynamic slideshows with custom animations and transitions.</li>\n<li><strong>Form</strong>: Design and customize advanced forms for user interaction and data collection.</li>\n<li><strong>Login</strong>: Add a login form or user registration module to your website.</li>\n<li><strong>Nav Menu</strong>: Customize and style your website&#8217;s navigation menu for better user experience.</li>\n<li><strong>Animated Headline</strong>: Create attention-grabbing headlines with animated effects.</li>\n<li><strong>Price Table</strong>: Display pricing plans or packages in a structured and visually appealing format.</li>\n<li><strong>Price List</strong>: Showcase a list of prices or services with customizable styling options.</li>\n<li><strong>Gallery</strong>: Create beautiful image galleries with various layout options and lightbox support.</li>\n<li><strong>Flip Box</strong>: Add interactive flip animations to highlight content or features.</li>\n<li><strong>Call to Action</strong>: Encourage user interaction and conversions with compelling call-to-action sections.</li>\n<li><strong>Media Carousel</strong>: Showcase a carousel of media files such as images or videos.</li>\n<li><strong>Testimonial Carousel</strong>: Display client testimonials in a carousel format for social proof.</li>\n<li><strong>Nested Carousel</strong>: Create nested carousels for more complex content organization.</li>\n<li><strong>Loop Carousel</strong>: Display content in a looped carousel for continuous viewing.</li>\n<li><strong>Table Of Content</strong>: Generate a table of contents for longer articles or guides to improve navigation.</li>\n<li><strong>Countdown</strong>: Add countdown timers to create urgency for promotions or events.</li>\n<li><strong>Facebook Page</strong>: Embed your Facebook page feed or content onto your website.</li>\n<li><strong>Blockquote</strong>: Highlight quotes or testimonials with stylish formatting options.</li>\n<li><strong>Template</strong>: Save and reuse design templates for consistent branding and layout.</li>\n<li><strong>Reviews</strong>: Showcase customer reviews and ratings to build trust and credibility.</li>\n<li><strong>Facebook Button</strong>: Add buttons to promote interactions with your Facebook page or content.</li>\n<li><strong>Facebook Embed</strong>: Embed Facebook posts or content onto your website.</li>\n<li><strong>Facebook Comments</strong>: Enable Facebook comments on your website&#8217;s pages or posts.</li>\n<li><strong>PayPal Button</strong>: Integrate PayPal buttons for easy online payments.</li>\n<li><strong>Stripe Button</strong>: Integrate Stripe payment buttons to facilitate secure online transactions.</li>\n<li><strong>Lottie Widget</strong>: Add Lottie animations to enhance visual appeal and engagement.</li>\n<li><strong>Code Highlight</strong>: Display code snippets with syntax highlighting for better readability.</li>\n<li><strong>Video Playlist</strong>: Create and customize playlists for video content on your website.</li>\n<li><strong>Mega Menu</strong>: Customize advanced menus for better navigation and displaying complex content.</li>\n<li><strong>Off Canvas</strong>: Create off-canvas areas that slide in to show extra info or menus without cluttering the main layout.</li>\n</ol>\n<p><strong>Pro Theme Widgets:</strong></p>\n<p>Build and customize all the key parts of your website including headers, footers, 404 page, global archives, and more</p>\n<ol>\n<li><strong>Post Title</strong>: Customize the title of individual blog posts or pages.</li>\n<li><strong>Post Excerpt</strong>: Display a brief summary or teaser of your blog posts.</li>\n<li><strong>Post Content</strong>: Customize the main content area of your blog posts or pages.</li>\n<li><strong>Featured Image</strong>: Set and customize featured images for blog posts or pages.</li>\n<li><strong>Author Box</strong>: Display author information and bios on blog posts.</li>\n<li><strong>Post Comments</strong>: Customize the appearance and functionality of comments sections on your website.</li>\n<li><strong>Post Navigation</strong>: Add navigation links to adjacent posts for easy browsing.</li>\n<li><strong>Post Info</strong>: Display additional information about blog posts, such as author and date.</li>\n<li><strong>Site Logo</strong>: Upload and customize your website&#8217;s logo for branding purposes.</li>\n<li><strong>Site Title</strong>: Customize the title of your website.</li>\n<li><strong>Page Title</strong>: Customize the title of individual pages.</li>\n<li><strong>Search Bar</strong>: Add a search bar to allow users to search your website&#8217;s content.</li>\n<li><strong>Breadcrumbs</strong>: Display hierarchical navigation paths for better user navigation.</li>\n<li><strong>Sitemap</strong>: Generate a sitemap for better search engine indexing and user navigation.</li>\n<li><strong>Loop Grid</strong>: Design and customize grid layouts for blog post archives or product listings.</li>\n</ol>\n<p><strong>Pro WooCommerce Widgets:</strong></p>\n<p>Design and customize a complete online shopping experience across your entire website.</p>\n<ol>\n<li><strong>Product</strong>: Display individual products with customizable layouts and styles.</li>\n<li><strong>Breadcrumbs</strong>: Display hierarchical navigation paths for better user navigation within your store.</li>\n<li><strong>Product Title</strong>: Customize the title of individual products.</li>\n<li><strong>Product Images</strong>: Set and customize images for product listings.</li>\n<li><strong>Product Price</strong>: Display the price of individual products.</li>\n<li><strong>Add To Cart</strong>: Add customizable add to cart buttons for easy purchasing.</li>\n<li><strong>Product Rating</strong>: Display ratings and reviews for products.</li>\n<li><strong>Product Stock</strong>: Display stock availability for products.</li>\n<li><strong>Product Meta</strong>: Display additional information about products, such as SKU and categories.</li>\n<li><strong>Product Content</strong>: Customize the main content area of product descriptions.</li>\n<li><strong>Short Description</strong>: Display brief summaries or teasers of products.</li>\n<li><strong>Product Data Tabs</strong>: Organize product information into tabbed sections for better organization.</li>\n<li><strong>Additional Information</strong>: Display additional details about products, such as dimensions and weight.</li>\n<li><strong>Product Related</strong>: Showcase related products to encourage additional purchases.</li>\n<li><strong>Upsells</strong>: Promote upsell products to increase average order value.</li>\n<li><strong>Products</strong>: Display a grid or list of products with customizable settings.</li>\n<li><strong>Custom Add To Cart</strong>: Customize the add to cart button for specific products.</li>\n<li><strong>WooCommerce Pages</strong>: Design and customize WooCommerce-specific pages, such as the cart and checkout pages.</li>\n<li><strong>Product Categories</strong>: Display product categories for easy navigation within your store.</li>\n<li><strong>Menu Cart</strong>: Display a cart icon in your navigation menu for easy access to the shopping cart.</li>\n<li><strong>Cart</strong>: Customize the appearance and functionality of the shopping cart page.</li>\n<li><strong>Checkout</strong>: Customize the appearance and functionality of the checkout page.</li>\n<li><strong>My Account</strong>: Customize the appearance and functionality of the customer account area.</li>\n<li><strong>Purchase Summary</strong>: Display a summary of purchases during the checkout process.</li>\n<li><strong>WooCommerce Notices</strong>: Customize the appearance and functionality of WooCommerce notices, such as order confirmation messages.</li>\n</ol>\n<p>Build professional websites with <strong><a href=\"https://go.elementor.com/wp-repo-description-tab-elementor-pro-elementor-pro/\" rel=\"nofollow ugc\">Elementor Pro</a></strong>!</p>\n<h4>🔒 SECURITY AND COMPLIANCE</h4>\n<p>Elementor places a paramount focus on security, evident through our acquisition of industry certifications such as ISO/IEC 27001, ISO/IEC 27017, ISO/IEC 27018, ISO/IEC 27701, and SOC 2 Type II. These certifications underscore our commitment to implementing robust security measures, and highlight our dedication to adhering to recognized industry standards.</p>\n<p>We encourage ethical security research through our <a href=\"https://go.elementor.com/wp-repo-description-tab-bug-crowd-bug-bounty-program/\" rel=\"nofollow ugc\">Bug Bounty program</a>. We collaborate with leading bug bounty services to provide opportunities for researchers to report vulnerabilities in our services. Our bounty programs include a triage team available 24/7/365.</p>\n<p>For more information: <a href=\"https://go.elementor.com/trust-center/\" rel=\"nofollow ugc\">Trust Center</a>.</p>\n<h4>♿ Accessibility Best Practices</h4>\n<p>Elementor offers accessibility tools and enhancements to help you provide a better experience for all users. Including HTML 5 semantic, full keyboard navigation menu, ongoing improvement of features, widget, and more.</p>\n<h4>🌐 Translated to 63+ languages, includes RTL support</h4>\n<p>Elementor supports multiple languages, typographies, and RTL, with editor translations in <a href=\"https://go.elementor.com/wp-repo-description-tab-wordpress-plugin-translate/\" rel=\"nofollow ugc\">over 63 languages</a>.</p>\n<p>It’s also compatible with WPML, Polylang, TranslatePress, Weglot, and more. To contribute, add a new language via translate.wordpress.org. See our guide on <a href=\"https://go.elementor.com/wp-repo-description-tab-help-center-translate/\" rel=\"nofollow ugc\">how to translate and localize the plugin</a>.</p>\n<h4>⏩ Use of 3rd Party Services</h4>\n<p>To improve the user experience, Elementor may use the following 3rd party services if the required feature is enabled:</p>\n<ul>\n<li>Google Fonts – are loaded to add additional fonts to your website. Google’s <a href=\"https://policies.google.com/terms\" rel=\"nofollow ugc\">TOS</a> and <a href=\"https://policies.google.com/privacy\" rel=\"nofollow ugc\">Privacy Policy</a></li>\n<li>Some Elementor features require loading assets from Elementor.com. These assets are not used for tracking unless explicitly mentioned, requiring your approval and manual opt-in. Learn more in our <a href=\"https://go.elementor.com/wp-repo-description-tab-elementor-plugin-terms/\" rel=\"nofollow ugc\">TOS</a> and <a href=\"https://go.elementor.com/wp-repo-description-tab-elementor-plugin-privacy/\" rel=\"nofollow ugc\">Privacy Policy</a>.</li>\n</ul>\n<h4>📧 Related Products by Elementor</h4>\n<p><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-elementor-io/\" rel=\"nofollow ugc\">Image Optimizer</a></strong>: Superior image compression for faster, high-quality website performance.</p>\n<p><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-elementor-sm/\" rel=\"nofollow ugc\">Site Mailer</a></strong>: Reliable email management without SMTP plugins, keeping your communications streamlined and efficient.</p>\n<h4>📣 See What Our Users Have to Say</h4>\n<blockquote>\n<p>“Elementor is hands down the best page builder out there” – ★★★★★ <em><a href=\"https://wordpress.org/support/topic/elementor-is-hands-down-the-best-page-builder-out-there/\" rel=\"ugc\">Graphicvision1</a></em></p>\n<p>“An incredibly user-friendly plugin” – ★★★★★ <em><a href=\"https://wordpress.org/support/topic/a-wonderful-experience/\" rel=\"ugc\">Hyeyoga</a></em></p>\n<p>“Easily, my most used WP plugin” – ★★★★★ <em><a href=\"https://wordpress.org/support/topic/easily-my-most-used-wp-plugin/\" rel=\"ugc\">Xander Venske</a></em></p>\n<p>“I upgraded to the Pro version and just love this plugin!” – ★★★★★ <em><a href=\"https://wordpress.org/support/topic/love-elementor-17/\" rel=\"ugc\">Andybarn56</a></em></p>\n<p>“Excellent product with great tech support” – ★★★★★ <em><a href=\"https://wordpress.org/support/topic/excellent-product-with-great-tech-support/\" rel=\"ugc\">Martywilsonnj</a></em></p>\n</blockquote>\n<p><em><a href=\"https://wordpress.org/support/plugin/elementor/reviews/?filter=5\" rel=\"ugc\">More testimonials</a></em></p>\n<h4>🌍 Join a Global Community</h4>\n<p>Join a global community that helps each other achieve their goals.</p>\n<ul>\n<li><a href=\"https://elemn.to/discord\" rel=\"nofollow ugc\">Discord Community</a> – Topic and language-specific channels, plus Ella, an amazing AI helper, ready to assist you.</li>\n<li><a href=\"https://go.elementor.com/wp-repo-description-tab-facebook-group/\" rel=\"nofollow ugc\">Facebook Community</a> &#8211; Over 150K+ members, offering support, advice, feedback, and tutorials.</li>\n<li><a href=\"https://go.elementor.com/wp-repo-description-tab-github-repo/\" rel=\"nofollow ugc\">GitHub Community</a> &#8211; Get information about releases, request features, or report a bug.</li>\n<li><a href=\"https://go.elementor.com/wp-repo-description-tab-addons-dozens-of-elementor-addons/\" rel=\"nofollow ugc\">Elementor Addons, Themes, and Kits</a> Themes and Kits – created specifically for Elementor.</li>\n<li>Learn valuable insights and techniques from our <a href=\"https://go.elementor.com/wp-repo-description-tab-youtube-channel/\" rel=\"nofollow ugc\">YouTube Channel</a>.</li>\n<li>Access our <a href=\"https://go.elementor.com/wp-repo-description-tab-academy-elementor-academy/\" rel=\"nofollow ugc\">Academy</a> and <a href=\"https://go.elementor.com/wp-repo-description-tab-help-center-help-center/\" rel=\"nofollow ugc\">Help Center</a> &#8211; Find guides, tutorials, and resources to answer your questions and boost creativity.</li>\n<li>Show your support by <a href=\"https://go.elementor.com/wp-repo-description-tab-wordpress-plugin-review/\" rel=\"nofollow ugc\">rating us on WordPress</a>. Your feedback fuels our growth! 🤗</li>\n<li>If you have questions or need support, visit the <a href=\"https://go.elementor.com/wp-repo-description-tab-wordpress-plugin-forum/\" rel=\"nofollow ugc\">Plugin&#8217;s Forum</a>. Elementor Pro users can get 24/7 premium support,  &hellip;</li>\n</ul>\n\";s:12:\"installation\";s:1461:\"<h4>Minimum Requirements</h4>\n<ul>\n<li>WordPress 6.5 or greater</li>\n<li>PHP version 7.4 or greater</li>\n<li>MySQL version 5.0 or greater</li>\n</ul>\n<h4>Recommended Requirements</h4>\n<ul>\n<li>PHP version 8.1 or greater</li>\n<li>MySQL version 5.6 or greater</li>\n<li>WordPress Memory limit of 64 MB or greater (128 MB or higher is preferred)</li>\n</ul>\n<p><iframe loading=\"lazy\" title=\"Installing Elementor on WordPress\" width=\"750\" height=\"422\" src=\"https://www.youtube.com/embed/9EZ159ryFNs?feature=oembed\" frameborder=\"0\" allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share\" referrerpolicy=\"strict-origin-when-cross-origin\" allowfullscreen></iframe></p>\n<h4>Installation</h4>\n<ol>\n<li>Install using the WordPress built-in Plugin installer, or Extract the zip file and drop the contents in the <code>wp-content/plugins/</code> directory of your WordPress installation.</li>\n<li>Activate the plugin through the &#8216;Plugins&#8217; menu in WordPress.</li>\n<li>Go to Pages &gt; Add New</li>\n<li>Press the &#8216;Edit with Elementor&#8217; button.</li>\n<li>Now you can drag and drop widgets from the left panel onto the content area, as well as add new sections and columns that make up the page structure.</li>\n</ol>\n<p>For documentation and tutorials visit our <a href=\"https://elementor.com/help/?utm_source=wp-repo&amp;utm_medium=link&amp;utm_campaign=readme\" rel=\"nofollow ugc\">Knowledge Base</a>.</p>\n\";s:3:\"faq\";s:4862:\"\n<dt id=\'how%20do%20i%20install%20elementor%3F\'>\nHow do I install Elementor?\n</h4>\n<p>\n<p>To install the free version of Elementor, follow the steps below:<br />\nFrom your WordPress dashboard -&gt; Go to Plugins -&gt; Click on &#8216;Add new&#8217;-&gt; In the Search field, enter Elementor and choose Elementor website builder.<br />\nPress install -&gt; After installation, click Activate.</p>\n</p>\n<dt id=\'does%20elementor%20work%20with%20all%20the%20themes%3F\'>\nDoes Elementor work with all the themes?\n</h4>\n<p>\n<p>Elementor works all the themes that respect the coding standards of WordPress set by its Codex. It is recommended to use Elementor&#8217;s <a href=\"https://go.elementor.com/wp-repo-description-tab-hello-theme-hello-theme/\" rel=\"nofollow ugc\">Hello Theme</a>, a lightweight blank canvas, to enjoy full flexibility when using Elementor, and optimize your experience.</p>\n</p>\n<dt id=\'is%20elementor%20compatible%20with%20gutenberg%3F\'>\nIs Elementor compatible with Gutenberg?\n</h4>\n<p>\n<p>Elementor and Gutenberg work seamlessly together. As a user, you can easily decide which editor to use at every point while editing your site.</p>\n</p>\n<dt id=\'can%20i%20create%20an%20online%20store%3F\'>\nCan I create an online store?\n</h4>\n<p>\n<p>Yes, with the Elementor Pro WooCommerce Builder you can customize every page of your store to create an amazing customer experience that drives sales.</p>\n</p>\n<dt id=\'does%20it%20work%20with%20other%20wordpress%20plugins%3F\'>\nDoes it work with other WordPress plugins?\n</h4>\n<p>\n<p>It works with almost all the plugins. If you experience an incompatibility issue, please report it to us and to the plugin that conflicts with Elementor.</p>\n</p>\n<dt id=\'do%20i%20need%20to%20know%20how%20to%20code%3F\'>\nDo I need to know how to code?\n</h4>\n<p>\n<p>No! Elementor provides you with all the widgets and features that you need to build a professional website without using code.</p>\n</p>\n<dt id=\'do%20i%20need%20to%20know%20how%20to%20design%3F\'>\nDo I need to know how to design?\n</h4>\n<p>\n<p>No, you can choose between professionally designed kits and templates that fit toevery industry and have all you need to create your own professional website.</p>\n</p>\n<dt id=\'will%20elementor%20slow%20down%20my%20website%3F\'>\nWill Elementor slow down my website?\n</h4>\n<p>\n<p>As Elementor prioritizes speed and performance, you enjoy better and faster performance with each new version of Elementor. When testing the same page layout on older versions you can see a significant performance improvement, from a score of 82 in Google PageSpeed Insight in version 3.1, to a score of 95 i in version 3.5.</p>\n</p>\n<dt id=\'is%20my%20site%20secure%20with%20elementor%3F\'>\nIs my site secure with Elementor?\n</h4>\n<p>\n<p>The security of your website is extremely important to us and we take proactive measures to assure that your websites are secure. Elementor is ISO 27001 certified, and has a dedicated team of security professionals that implements industry best-practices for maximum security and compliance, 24/7.</p>\n<p>There is also a managed security Bug Bounty program, utilizing the community power by enabling 24/7/365 crowdsourced vulnerability detection.</p>\n</p>\n<dt id=\'can%20i%20buy%20templates%20separately%3F\'>\nCan I buy templates separately?\n</h4>\n<p>\n<p>Of course, you can use any template that supports Elementor.</p>\n</p>\n<dt id=\'is%20elementor%20compatible%20with%20post%20and%20custom%20post%20types%3F\'>\nIs Elementor compatible with Post and Custom Post Types?\n</h4>\n<p>\n<p>Of course! You can set which post types will enable Elementor in the settings page.</p>\n</p>\n<dt id=\'what%20is%20the%20difference%20between%20elementor%27s%20free%20plugin%20and%20elementor%20pro\'>\nWhat is the difference between Elementor&#8217;s free Plugin and Elementor Pro\n</h4>\n<p>\n<p>Elementor’s Free version allows you to explore our revolutionary drag &amp; drop live editor, basic widgets and templates. Elementor Pro (Essential, Advanced, Expert, Studio, and Agency) empowers you with more professional tools that speed up your workflow, give you access to human-powered support, help you build more advanced content, and convert visitors. See full comparison here.</p>\n</p>\n<dt id=\'how%20can%20i%20become%20a%20contributor\'>\nHow can I become a Contributor\n</h4>\n<p>\n<p>If you want to contribute, go to our <a href=\"https://github.com/elementor/elementor\" rel=\"nofollow ugc\">Elementor GitHub Repository</a> and see where you can help.<br />\nYou can also add a new language via <a href=\"https://go.elementor.com/wp-repo-description-tab-wordpress-plugin-translate/\" rel=\"nofollow ugc\">translate.wordpress.org</a>. We’ve built a short guide explaining <a href=\"https://go.elementor.com/wp-repo-description-tab-wordpress-plugin-translate-faq/\" rel=\"nofollow ugc\">how to translate and localize the plugin</a>.</p>\n</p>\n\n\";s:9:\"changelog\";s:2581:\"<h4>3.33.6 &#8211; 2025-12-18</h4>\n<ul>\n<li>Fix: Issues with rendering in Text Editor widget</li>\n<li>Fix: Context menu fails to open after using &#8216;Copy&#8217; action on a widget – Editor V4</li>\n</ul>\n<h4>v3.33.5 &#8211; 2025-12-17</h4>\n<ul>\n<li>Security Fix: Improved code security enforcement in site navigation module</li>\n<li>Security Fix: Improved code security enforcement in text editor</li>\n</ul>\n<h4>3.33.4 &#8211; 2025-12-08</h4>\n<ul>\n<li>Security Fix: Improved code security enforcement in Text Path widget</li>\n</ul>\n<h4>3.33.3 &#8211; 2025-12-04</h4>\n<ul>\n<li>Fix: Improved compatibility with WordPress 6.9</li>\n<li>Fix: Keyboard navigation does not work as expected when setting a CSS ID in Tabs widget</li>\n</ul>\n<h4>3.33.2 &#8211; 2025-11-23</h4>\n<ul>\n<li>Security Fix: Improved code security enforcement in repeater widgets</li>\n<li>Security Fix: Improved code security enforcement in Star Rating widget</li>\n<li>Fix: Editor not loading with errors in the console in certain scenarios – Editor V4</li>\n</ul>\n<h4>3.33.1 &#8211; 2025-11-17</h4>\n<ul>\n<li>Security Fix: Improved code security enforcement in Floating Elements</li>\n</ul>\n<h4>3.33.0 &#8211; 2025-11-10</h4>\n<ul>\n<li>New: Introducing Variables Manager to manage design variables like colors, fonts, and sizes from a centralized panel &#8211; Editor V4</li>\n<li>New: Introducing Blend Mode control to create layered visual effects by defining how elements blend with backgrounds &#8211; Editor V4</li>\n<li>New: Introducing Background Clipping control to define where an element&#8217;s background is rendered across the element&#8217;s layout &#8211; Editor V4</li>\n<li>Tweak: Updated Editor Top Bar layout and button placement for improved navigation</li>\n<li>Tweak: Adjusted default cache behavior to inactive and updated FAQ Schema notice in Accordion widget</li>\n<li>Tweak: Improved error handling in Import and Export customization flow</li>\n<li>Tweak: Applied CSS logical properties support in Star Rating widget</li>\n<li>Tweak: Enhanced accessibility in Star Rating widget</li>\n<li>Tweak: Updated minimum supported versions for Chrome, Firefox, and Safari</li>\n<li>Fix: Child pages and menu items not importing correctly in Website Templates</li>\n<li>Fix: Deprecated <code>utf8_encode()</code> and <code>utf8_decode()</code> functions replaced for PHP 8.2 compatibility (<a href=\"https://github.com/elementor/elementor/issues/27499\" rel=\"nofollow ugc\">#27499</a>)</li>\n</ul>\n<p><a href=\"https://go.elementor.com/full-changelog/\" rel=\"nofollow ugc\">See changelog for all versions.</a></p>\n\";s:11:\"screenshots\";s:3148:\"<ol><li><a href=\"https://ps.w.org/elementor/assets/screenshot-1.gif?rev=3005087\"><img src=\"https://ps.w.org/elementor/assets/screenshot-1.gif?rev=3005087\" alt=\"&lt;strong&gt;Visual Drag and Drop Editor&lt;/strong&gt; - Design your website layouts and place any element anywhere on the page for pixel-perfect designs.\"></a><p><strong>Visual Drag and Drop Editor</strong> - Design your website layouts and place any element anywhere on the page for pixel-perfect designs.</p></li><li><a href=\"https://ps.w.org/elementor/assets/screenshot-2.gif?rev=3005087\"><img src=\"https://ps.w.org/elementor/assets/screenshot-2.gif?rev=3005087\" alt=\"&lt;strong&gt;Full Design System&lt;/strong&gt; - Enjoy a professional workflow and ensure consistency across your site. Define your settings, use them globally, and instantly adjust them any time.\"></a><p><strong>Full Design System</strong> - Enjoy a professional workflow and ensure consistency across your site. Define your settings, use them globally, and instantly adjust them any time.</p></li><li><a href=\"https://ps.w.org/elementor/assets/screenshot-3.gif?rev=3005087\"><img src=\"https://ps.w.org/elementor/assets/screenshot-3.gif?rev=3005087\" alt=\"&lt;strong&gt;Responsive Design&lt;/strong&gt; Fully edit your website and customize the behavior on desktop, tablet, &amp; mobile to optimize the visitor experience on every device.\"></a><p><strong>Responsive Design</strong> Fully edit your website and customize the behavior on desktop, tablet, &amp; mobile to optimize the visitor experience on every device.</p></li><li><a href=\"https://ps.w.org/elementor/assets/screenshot-4.gif?rev=3005087\"><img src=\"https://ps.w.org/elementor/assets/screenshot-4.gif?rev=3005087\" alt=\"&lt;strong&gt;Kits and Templates&lt;/strong&gt; - Jumpstart your web creation process or get inspired with professionally-designed templates or full website kits available for your immediate customization.\"></a><p><strong>Kits and Templates</strong> - Jumpstart your web creation process or get inspired with professionally-designed templates or full website kits available for your immediate customization.</p></li><li><a href=\"https://ps.w.org/elementor/assets/screenshot-5.gif?rev=3005087\"><img src=\"https://ps.w.org/elementor/assets/screenshot-5.gif?rev=3005087\" alt=\"&lt;strong&gt;Nested Elements&lt;/strong&gt; Leverage Elementor&#039;s Nested widgets to place any widget inside the content area of another widget - like Tabs, and Accordion for complete design flexibility.\"></a><p><strong>Nested Elements</strong> Leverage Elementor\'s Nested widgets to place any widget inside the content area of another widget - like Tabs, and Accordion for complete design flexibility.</p></li><li><a href=\"https://ps.w.org/elementor/assets/screenshot-6.gif?rev=3005087\"><img src=\"https://ps.w.org/elementor/assets/screenshot-6.gif?rev=3005087\" alt=\"&lt;strong&gt;Motion Effects&lt;/strong&gt; - Add entrance animations and transitions to any element in your website to captivate visitors.\"></a><p><strong>Motion Effects</strong> - Add entrance animations and transitions to any element in your website to captivate visitors.</p></li></ol>\";s:7:\"reviews\";s:17842:\"<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">One of the best page bulder.</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 out of 5 stars\" data-title-template=\"%s out of 5 stars\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/rakibhossainraju/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/e0c45ffd18f23598c4792c9db6841064ec4a5d2f7a4970486547799b5b6574eb?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/e0c45ffd18f23598c4792c9db6841064ec4a5d2f7a4970486547799b5b6574eb?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/rakibhossainraju/\" class=\"reviewer-name\">Rakib Hossain Raju <small>(rakibhossainraju)</small></a> on <span class=\"review-date\">December 21, 2025</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>I have been using this page builder for quite some time. Before that I have used other Page Builders but this one is so far the best for me. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>The ecosystem is huge and the community is realy nice.</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Easy to Use and Powerful Page Builder</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 out of 5 stars\" data-title-template=\"%s out of 5 stars\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/deepanshigarg/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/801efa1ef614c59ea2187e22bb4cdfd9b52fc9a2041d843f6a4e673577e1489f?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/801efa1ef614c59ea2187e22bb4cdfd9b52fc9a2041d843f6a4e673577e1489f?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/deepanshigarg/\" class=\"reviewer-name\">deepanshigarg</a> on <span class=\"review-date\">December 19, 2025</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>Elementor Website Builder makes designing pages very easy, even for beginners. The drag-and-drop editor is smooth and intuitive, and there are many useful widgets and design options. It helped me create professional-looking pages without coding. A great choice for building and customizing WordPress websites.</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Elementor 3.33.5 Update several critical front-end widgets stopped working</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"1 out of 5 stars\" data-title-template=\"%s out of 5 stars\" data-rating=\"1\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/ulgo/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/dcb4ad0a1b1e2c37cb45d9f1ecca5f6e8de1885755241633afc4c6efe1a7fe8c?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/dcb4ad0a1b1e2c37cb45d9f1ecca5f6e8de1885755241633afc4c6efe1a7fe8c?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/ulgo/\" class=\"reviewer-name\">ulgo</a> on <span class=\"review-date\">December 18, 2025</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>After updating from <strong>Elementor 3.33.4 to 3.33.5</strong>, several critical front-end widgets stopped working:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>The <strong>Google Reviews / Rating widget</strong> no longer renders and disappears completely.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li><strong>Custom HTML/JS widgets</strong> (e.g., small interactive tools) only display as static text blocks, and embedded JavaScript does not execute.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Rolling back to <strong>3.33.4</strong> immediately restores full functionality.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p><strong>Environment:</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Hosting: <strong>IONOS Managed WordPress</strong></li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Elementor Pro active</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>No other changes to theme or plugins except the Elementor update.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p><strong>Impact:</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li>Essential front-end functionality is broken.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Custom tools and third-party widgets cannot be used.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>A rollback is currently the only way to keep the site operational.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p><strong>Expectation:</strong><br />Please release a <strong>hotfix or patch (3.33.6 or 3.34.x)</strong> to restore compatibility for Google Reviews and allow custom HTML/JS widgets to function as before.</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Love it!</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 out of 5 stars\" data-title-template=\"%s out of 5 stars\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/rbmueller/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/90fad29eadd72699174c29d23fa3b372f785599c71eeb418b535a1616057f10c?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/90fad29eadd72699174c29d23fa3b372f785599c71eeb418b535a1616057f10c?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/rbmueller/\" class=\"reviewer-name\">Robin <small>(rbmueller)</small></a> on <span class=\"review-date\">December 18, 2025</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>Very easy to understand and powerfull. Best pagebuilder we have used so far.</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">The last update broke the whole site, I had to rollback</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"1 out of 5 stars\" data-title-template=\"%s out of 5 stars\" data-rating=\"1\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/kris006/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/9bbd3657eef146c49965f460ad4161f6f28f8788ce80dd8dde44d372fac089c2?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/9bbd3657eef146c49965f460ad4161f6f28f8788ce80dd8dde44d372fac089c2?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/kris006/\" class=\"reviewer-name\">kris006</a> on <span class=\"review-date\">December 18, 2025</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>The last update broke the whole site, I had to rollback</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Update Broke many websites</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"1 out of 5 stars\" data-title-template=\"%s out of 5 stars\" data-rating=\"1\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/atx/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/a2b1fdc2a78927a03ebecbb1c0b8136620422b25f65d65d18223c2f17bff034e?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/a2b1fdc2a78927a03ebecbb1c0b8136620422b25f65d65d18223c2f17bff034e?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/atx/\" class=\"reviewer-name\">Testing Things <small>(AtX)</small></a> on <span class=\"review-date\">December 18, 2025</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>I\'m sorry but a popular plugin like this one should never break websites. This happened to many people during the last update which doesn\'t make us feel comfortable using it... </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>And that is not the first time by the way... My website broke at least three times during the past years, and not because of a misconfiguration or another plugin, but because of an automated Elementor update overnight.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>This time the woocommerce login and account pages were impacted</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">VERSION 3.33.5 BROKE THE TEXT EDITOR - THANKS FOR NOTHING!!!</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"1 out of 5 stars\" data-title-template=\"%s out of 5 stars\" data-rating=\"1\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/wordoppressed345345/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/a601541e053b00a111d360da6c9836f6838d8b3b2c70160614cceb867a54af1c?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/a601541e053b00a111d360da6c9836f6838d8b3b2c70160614cceb867a54af1c?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/wordoppressed345345/\" class=\"reviewer-name\">wordoppressed345345</a> on <span class=\"review-date\">December 18, 2025</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>WE USED TO BE ABLE TO DROP SHORTCODES INTO THE TEXT EDITOR WHICH MADE CHANGING ATTRIBUTES (EX. TEXT SIZE, ORIENTATION, ETC.) QUICK AND EASY. OF COURSE THEY KILLED THAT FUNCTIONALITY.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>EVER NOTICE THAT THESE UPDATES ONLY BREAK THINGS?</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Works ok but feel trapped in it</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"3 out of 5 stars\" data-title-template=\"%s out of 5 stars\" data-rating=\"3\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/petersonrk/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/895f0db4bf7c487580c456caf9e2fcd2bdb5b3d4fb9966e2417cbf371a2e53f1?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/895f0db4bf7c487580c456caf9e2fcd2bdb5b3d4fb9966e2417cbf371a2e53f1?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/petersonrk/\" class=\"reviewer-name\">petersonrk</a> on <span class=\"review-date\">December 17, 2025</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>Elementor feels like it gets worse as they add features that I don\'t use. It now takes too long to load and sometimes won\'t let me edit a page. </p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Great product!</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 out of 5 stars\" data-title-template=\"%s out of 5 stars\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/detlefm/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/9ce69c7a0382cc7f2170b844a9e2e7e46fe411ef923d6737229c858b9ef71b3f?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/9ce69c7a0382cc7f2170b844a9e2e7e46fe411ef923d6737229c858b9ef71b3f?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/detlefm/\" class=\"reviewer-name\">Detlef <small>(detlefm)</small></a> on <span class=\"review-date\">December 16, 2025</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>My experience with Elementor has been largely positive. When something didn\'t work, upon reflection, the mistake was mine. Ultimately, I can only recommend Elementor. Thanks to the creator(s).</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Still works great in the era of AI</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 out of 5 stars\" data-title-template=\"%s out of 5 stars\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/eramnindersinghcheema/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/954411355c9dc8c4373d96de9ab004a9d3590f03d904ae6ed3f978e7b02b57d6?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/954411355c9dc8c4373d96de9ab004a9d3590f03d904ae6ed3f978e7b02b57d6?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/eramnindersinghcheema/\" class=\"reviewer-name\">eramnindersinghcheema</a> on <span class=\"review-date\">December 14, 2025</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>Still works great in the era of AI</p>\n<!-- /wp:paragraph --></div>\n</div>\n\";}s:17:\"short_description\";s:145:\"The Elementor Website Builder has it all: drag and drop page builder, pixel perfect design, mobile responsive editing, and more. Get started now!\";s:13:\"download_link\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.33.6.zip\";s:14:\"upgrade_notice\";a:0:{}s:11:\"screenshots\";a:6:{i:1;a:2:{s:3:\"src\";s:62:\"https://ps.w.org/elementor/assets/screenshot-1.gif?rev=3005087\";s:7:\"caption\";s:144:\"<strong>Visual Drag and Drop Editor</strong> - Design your website layouts and place any element anywhere on the page for pixel-perfect designs.\";}i:2;a:2:{s:3:\"src\";s:62:\"https://ps.w.org/elementor/assets/screenshot-2.gif?rev=3005087\";s:7:\"caption\";s:185:\"<strong>Full Design System</strong> - Enjoy a professional workflow and ensure consistency across your site. Define your settings, use them globally, and instantly adjust them any time.\";}i:3;a:2:{s:3:\"src\";s:62:\"https://ps.w.org/elementor/assets/screenshot-3.gif?rev=3005087\";s:7:\"caption\";s:170:\"<strong>Responsive Design</strong> Fully edit your website and customize the behavior on desktop, tablet, &amp; mobile to optimize the visitor experience on every device.\";}i:4;a:2:{s:3:\"src\";s:62:\"https://ps.w.org/elementor/assets/screenshot-4.gif?rev=3005087\";s:7:\"caption\";s:193:\"<strong>Kits and Templates</strong> - Jumpstart your web creation process or get inspired with professionally-designed templates or full website kits available for your immediate customization.\";}i:5;a:2:{s:3:\"src\";s:62:\"https://ps.w.org/elementor/assets/screenshot-5.gif?rev=3005087\";s:7:\"caption\";s:190:\"<strong>Nested Elements</strong> Leverage Elementor\'s Nested widgets to place any widget inside the content area of another widget - like Tabs, and Accordion for complete design flexibility.\";}i:6;a:2:{s:3:\"src\";s:62:\"https://ps.w.org/elementor/assets/screenshot-6.gif?rev=3005087\";s:7:\"caption\";s:127:\"<strong>Motion Effects</strong> - Add entrance animations and transitions to any element in your website to captivate visitors.\";}}s:4:\"tags\";a:5:{s:13:\"drag-and-drop\";s:13:\"drag-and-drop\";s:6:\"editor\";s:6:\"editor\";s:9:\"elementor\";s:9:\"elementor\";s:12:\"landing-page\";s:12:\"landing page\";s:12:\"page-builder\";s:12:\"page builder\";}s:8:\"versions\";a:386:{s:5:\"3.0.0\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.0.0.zip\";s:5:\"3.0.1\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.0.1.zip\";s:6:\"3.0.10\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.0.10.zip\";s:6:\"3.0.11\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.0.11.zip\";s:6:\"3.0.12\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.0.12.zip\";s:6:\"3.0.13\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.0.13.zip\";s:6:\"3.0.14\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.0.14.zip\";s:6:\"3.0.15\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.0.15.zip\";s:6:\"3.0.16\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.0.16.zip\";s:5:\"3.0.2\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.0.2.zip\";s:5:\"3.0.3\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.0.3.zip\";s:5:\"3.0.4\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.0.4.zip\";s:5:\"3.0.5\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.0.5.zip\";s:5:\"3.0.6\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.0.6.zip\";s:5:\"3.0.7\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.0.7.zip\";s:5:\"3.0.8\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.0.8.zip\";s:7:\"3.0.8.1\";s:60:\"https://downloads.wordpress.org/plugin/elementor.3.0.8.1.zip\";s:5:\"3.0.9\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.0.9.zip\";s:5:\"3.1.0\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.1.0.zip\";s:11:\"3.1.0-beta1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.1.0-beta1.zip\";s:11:\"3.1.0-beta2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.1.0-beta2.zip\";s:11:\"3.1.0-beta3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.1.0-beta3.zip\";s:11:\"3.1.0-beta4\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.1.0-beta4.zip\";s:10:\"3.1.0-dev1\";s:63:\"https://downloads.wordpress.org/plugin/elementor.3.1.0-dev1.zip\";s:10:\"3.1.0-dev2\";s:63:\"https://downloads.wordpress.org/plugin/elementor.3.1.0-dev2.zip\";s:10:\"3.1.0-dev3\";s:63:\"https://downloads.wordpress.org/plugin/elementor.3.1.0-dev3.zip\";s:5:\"3.1.1\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.1.1.zip\";s:5:\"3.1.2\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.1.2.zip\";s:5:\"3.1.3\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.1.3.zip\";s:5:\"3.1.4\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.1.4.zip\";s:6:\"3.10.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.10.0.zip\";s:11:\"3.10.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.10.0-dev1.zip\";s:6:\"3.10.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.10.1.zip\";s:6:\"3.10.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.10.2.zip\";s:6:\"3.11.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.11.0.zip\";s:12:\"3.11.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.11.0-beta1.zip\";s:12:\"3.11.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.11.0-beta2.zip\";s:12:\"3.11.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.11.0-beta3.zip\";s:11:\"3.11.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.11.0-dev1.zip\";s:11:\"3.11.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.11.0-dev2.zip\";s:11:\"3.11.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.11.0-dev3.zip\";s:6:\"3.11.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.11.1.zip\";s:6:\"3.11.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.11.2.zip\";s:6:\"3.11.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.11.3.zip\";s:6:\"3.11.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.11.4.zip\";s:6:\"3.11.5\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.11.5.zip\";s:6:\"3.12.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.12.0.zip\";s:6:\"3.12.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.12.1.zip\";s:6:\"3.12.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.12.2.zip\";s:6:\"3.13.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.13.0.zip\";s:12:\"3.13.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.13.0-beta1.zip\";s:12:\"3.13.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.13.0-beta2.zip\";s:12:\"3.13.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.13.0-beta3.zip\";s:11:\"3.13.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.13.0-dev3.zip\";s:11:\"3.13.0-dev4\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.13.0-dev4.zip\";s:6:\"3.13.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.13.1.zip\";s:6:\"3.13.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.13.2.zip\";s:6:\"3.13.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.13.3.zip\";s:6:\"3.13.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.13.4.zip\";s:6:\"3.14.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.14.0.zip\";s:12:\"3.14.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.14.0-beta1.zip\";s:12:\"3.14.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.14.0-beta2.zip\";s:12:\"3.14.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.14.0-beta3.zip\";s:12:\"3.14.0-beta4\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.14.0-beta4.zip\";s:12:\"3.14.0-beta5\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.14.0-beta5.zip\";s:6:\"3.14.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.14.1.zip\";s:6:\"3.15.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.15.0.zip\";s:6:\"3.15.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.15.1.zip\";s:6:\"3.15.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.15.2.zip\";s:6:\"3.15.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.15.3.zip\";s:6:\"3.16.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.16.0.zip\";s:12:\"3.16.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.16.0-beta3.zip\";s:12:\"3.16.0-beta4\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.16.0-beta4.zip\";s:11:\"3.16.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.16.0-dev1.zip\";s:11:\"3.16.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.16.0-dev2.zip\";s:6:\"3.16.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.16.1.zip\";s:6:\"3.16.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.16.2.zip\";s:6:\"3.16.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.16.3.zip\";s:6:\"3.16.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.16.4.zip\";s:6:\"3.16.5\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.16.5.zip\";s:6:\"3.16.6\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.16.6.zip\";s:6:\"3.17.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.17.0.zip\";s:11:\"3.17.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.17.0-dev2.zip\";s:11:\"3.17.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.17.0-dev3.zip\";s:11:\"3.17.0-dev4\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.17.0-dev4.zip\";s:6:\"3.17.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.17.1.zip\";s:6:\"3.17.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.17.2.zip\";s:6:\"3.17.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.17.3.zip\";s:6:\"3.18.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.18.0.zip\";s:12:\"3.18.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.18.0-beta1.zip\";s:12:\"3.18.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.18.0-beta2.zip\";s:12:\"3.18.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.18.0-beta3.zip\";s:12:\"3.18.0-beta4\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.18.0-beta4.zip\";s:11:\"3.18.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.18.0-dev1.zip\";s:6:\"3.18.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.18.1.zip\";s:6:\"3.18.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.18.2.zip\";s:6:\"3.18.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.18.3.zip\";s:6:\"3.19.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.19.0.zip\";s:12:\"3.19.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.19.0-beta1.zip\";s:12:\"3.19.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.19.0-beta2.zip\";s:12:\"3.19.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.19.0-beta3.zip\";s:12:\"3.19.0-beta4\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.19.0-beta4.zip\";s:12:\"3.19.0-beta5\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.19.0-beta5.zip\";s:12:\"3.19.0-beta6\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.19.0-beta6.zip\";s:11:\"3.19.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.19.0-dev1.zip\";s:11:\"3.19.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.19.0-dev2.zip\";s:11:\"3.19.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.19.0-dev3.zip\";s:11:\"3.19.0-dev4\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.19.0-dev4.zip\";s:11:\"3.19.0-dev5\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.19.0-dev5.zip\";s:11:\"3.19.0-dev6\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.19.0-dev6.zip\";s:6:\"3.19.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.19.1.zip\";s:6:\"3.19.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.19.2.zip\";s:6:\"3.19.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.19.3.zip\";s:6:\"3.19.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.19.4.zip\";s:5:\"3.2.0\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.2.0.zip\";s:5:\"3.2.1\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.2.1.zip\";s:5:\"3.2.2\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.2.2.zip\";s:5:\"3.2.3\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.2.3.zip\";s:5:\"3.2.4\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.2.4.zip\";s:5:\"3.2.5\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.2.5.zip\";s:6:\"3.20.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.20.0.zip\";s:12:\"3.20.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.20.0-beta1.zip\";s:12:\"3.20.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.20.0-beta2.zip\";s:12:\"3.20.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.20.0-beta3.zip\";s:12:\"3.20.0-beta4\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.20.0-beta4.zip\";s:11:\"3.20.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.20.0-dev1.zip\";s:11:\"3.20.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.20.0-dev2.zip\";s:11:\"3.20.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.20.0-dev3.zip\";s:11:\"3.20.0-dev4\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.20.0-dev4.zip\";s:6:\"3.20.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.20.1.zip\";s:6:\"3.20.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.20.2.zip\";s:6:\"3.20.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.20.3.zip\";s:6:\"3.20.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.20.4.zip\";s:6:\"3.21.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.21.0.zip\";s:12:\"3.21.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.21.0-beta1.zip\";s:12:\"3.21.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.21.0-beta2.zip\";s:12:\"3.21.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.21.0-beta3.zip\";s:11:\"3.21.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.21.0-dev1.zip\";s:11:\"3.21.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.21.0-dev2.zip\";s:11:\"3.21.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.21.0-dev3.zip\";s:6:\"3.21.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.21.1.zip\";s:6:\"3.21.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.21.2.zip\";s:6:\"3.21.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.21.3.zip\";s:6:\"3.21.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.21.4.zip\";s:6:\"3.21.5\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.21.5.zip\";s:6:\"3.21.6\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.21.6.zip\";s:6:\"3.21.7\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.21.7.zip\";s:6:\"3.21.8\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.21.8.zip\";s:6:\"3.22.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.22.0.zip\";s:12:\"3.22.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.22.0-beta1.zip\";s:12:\"3.22.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.22.0-beta2.zip\";s:12:\"3.22.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.22.0-beta3.zip\";s:12:\"3.22.0-beta4\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.22.0-beta4.zip\";s:12:\"3.22.0-beta5\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.22.0-beta5.zip\";s:12:\"3.22.0-beta6\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.22.0-beta6.zip\";s:11:\"3.22.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.22.0-dev1.zip\";s:11:\"3.22.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.22.0-dev2.zip\";s:11:\"3.22.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.22.0-dev3.zip\";s:11:\"3.22.0-dev4\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.22.0-dev4.zip\";s:11:\"3.22.0-dev5\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.22.0-dev5.zip\";s:11:\"3.22.0-dev6\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.22.0-dev6.zip\";s:6:\"3.22.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.22.1.zip\";s:6:\"3.22.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.22.2.zip\";s:6:\"3.22.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.22.3.zip\";s:6:\"3.23.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.23.0.zip\";s:12:\"3.23.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.23.0-beta1.zip\";s:12:\"3.23.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.23.0-beta2.zip\";s:12:\"3.23.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.23.0-beta3.zip\";s:12:\"3.23.0-beta4\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.23.0-beta4.zip\";s:12:\"3.23.0-beta5\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.23.0-beta5.zip\";s:12:\"3.23.0-beta6\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.23.0-beta6.zip\";s:11:\"3.23.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.23.0-dev1.zip\";s:11:\"3.23.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.23.0-dev2.zip\";s:11:\"3.23.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.23.0-dev3.zip\";s:11:\"3.23.0-dev4\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.23.0-dev4.zip\";s:11:\"3.23.0-dev5\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.23.0-dev5.zip\";s:11:\"3.23.0-dev6\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.23.0-dev6.zip\";s:6:\"3.23.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.23.1.zip\";s:6:\"3.23.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.23.2.zip\";s:6:\"3.23.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.23.3.zip\";s:6:\"3.23.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.23.4.zip\";s:6:\"3.24.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.24.0.zip\";s:12:\"3.24.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.24.0-beta1.zip\";s:12:\"3.24.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.24.0-beta2.zip\";s:12:\"3.24.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.24.0-beta3.zip\";s:11:\"3.24.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.24.0-dev1.zip\";s:11:\"3.24.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.24.0-dev2.zip\";s:11:\"3.24.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.24.0-dev3.zip\";s:6:\"3.24.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.24.1.zip\";s:6:\"3.24.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.24.2.zip\";s:6:\"3.24.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.24.3.zip\";s:6:\"3.24.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.24.4.zip\";s:6:\"3.24.5\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.24.5.zip\";s:6:\"3.24.6\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.24.6.zip\";s:6:\"3.24.7\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.24.7.zip\";s:6:\"3.24.8\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.24.8.zip\";s:6:\"3.25.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.25.0.zip\";s:12:\"3.25.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.25.0-beta1.zip\";s:12:\"3.25.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.25.0-beta2.zip\";s:12:\"3.25.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.25.0-beta3.zip\";s:11:\"3.25.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.25.0-dev1.zip\";s:11:\"3.25.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.25.0-dev2.zip\";s:11:\"3.25.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.25.0-dev3.zip\";s:6:\"3.25.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.25.1.zip\";s:7:\"3.25.10\";s:60:\"https://downloads.wordpress.org/plugin/elementor.3.25.10.zip\";s:7:\"3.25.11\";s:60:\"https://downloads.wordpress.org/plugin/elementor.3.25.11.zip\";s:6:\"3.25.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.25.2.zip\";s:6:\"3.25.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.25.3.zip\";s:6:\"3.25.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.25.4.zip\";s:6:\"3.25.5\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.25.5.zip\";s:6:\"3.25.6\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.25.6.zip\";s:6:\"3.25.7\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.25.7.zip\";s:6:\"3.25.8\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.25.8.zip\";s:6:\"3.25.9\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.25.9.zip\";s:6:\"3.26.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.26.0.zip\";s:12:\"3.26.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.26.0-beta1.zip\";s:12:\"3.26.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.26.0-beta2.zip\";s:12:\"3.26.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.26.0-beta3.zip\";s:12:\"3.26.0-beta4\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.26.0-beta4.zip\";s:12:\"3.26.0-beta5\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.26.0-beta5.zip\";s:11:\"3.26.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.26.0-dev1.zip\";s:11:\"3.26.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.26.0-dev2.zip\";s:11:\"3.26.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.26.0-dev3.zip\";s:11:\"3.26.0-dev4\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.26.0-dev4.zip\";s:11:\"3.26.0-dev5\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.26.0-dev5.zip\";s:6:\"3.26.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.26.1.zip\";s:6:\"3.26.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.26.2.zip\";s:6:\"3.26.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.26.3.zip\";s:6:\"3.26.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.26.4.zip\";s:6:\"3.26.5\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.26.5.zip\";s:6:\"3.27.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.27.0.zip\";s:12:\"3.27.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.27.0-beta1.zip\";s:12:\"3.27.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.27.0-beta2.zip\";s:11:\"3.27.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.27.0-dev1.zip\";s:11:\"3.27.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.27.0-dev2.zip\";s:6:\"3.27.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.27.1.zip\";s:6:\"3.27.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.27.2.zip\";s:6:\"3.27.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.27.3.zip\";s:6:\"3.27.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.27.4.zip\";s:6:\"3.27.5\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.27.5.zip\";s:6:\"3.27.6\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.27.6.zip\";s:6:\"3.27.7\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.27.7.zip\";s:6:\"3.28.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.28.0.zip\";s:12:\"3.28.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.28.0-beta1.zip\";s:12:\"3.28.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.28.0-beta2.zip\";s:12:\"3.28.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.28.0-beta3.zip\";s:11:\"3.28.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.28.0-dev1.zip\";s:11:\"3.28.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.28.0-dev2.zip\";s:11:\"3.28.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.28.0-dev3.zip\";s:6:\"3.28.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.28.1.zip\";s:6:\"3.28.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.28.2.zip\";s:6:\"3.28.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.28.3.zip\";s:6:\"3.28.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.28.4.zip\";s:6:\"3.29.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.29.0.zip\";s:12:\"3.29.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.29.0-beta1.zip\";s:12:\"3.29.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.29.0-beta2.zip\";s:12:\"3.29.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.29.0-beta3.zip\";s:12:\"3.29.0-beta4\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.29.0-beta4.zip\";s:11:\"3.29.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.29.0-dev1.zip\";s:11:\"3.29.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.29.0-dev2.zip\";s:11:\"3.29.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.29.0-dev3.zip\";s:11:\"3.29.0-dev4\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.29.0-dev4.zip\";s:6:\"3.29.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.29.1.zip\";s:6:\"3.29.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.29.2.zip\";s:5:\"3.3.0\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.3.0.zip\";s:5:\"3.3.1\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.3.1.zip\";s:6:\"3.30.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.30.0.zip\";s:12:\"3.30.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.30.0-beta1.zip\";s:12:\"3.30.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.30.0-beta2.zip\";s:12:\"3.30.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.30.0-beta3.zip\";s:11:\"3.30.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.30.0-dev1.zip\";s:11:\"3.30.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.30.0-dev2.zip\";s:11:\"3.30.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.30.0-dev3.zip\";s:6:\"3.30.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.30.1.zip\";s:6:\"3.30.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.30.2.zip\";s:6:\"3.30.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.30.3.zip\";s:6:\"3.30.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.30.4.zip\";s:6:\"3.31.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.31.0.zip\";s:12:\"3.31.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.31.0-beta1.zip\";s:12:\"3.31.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.31.0-beta2.zip\";s:11:\"3.31.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.31.0-dev1.zip\";s:11:\"3.31.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.31.0-dev2.zip\";s:6:\"3.31.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.31.1.zip\";s:6:\"3.31.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.31.2.zip\";s:6:\"3.31.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.31.3.zip\";s:6:\"3.31.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.31.4.zip\";s:6:\"3.31.5\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.31.5.zip\";s:6:\"3.32.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.32.0.zip\";s:12:\"3.32.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.32.0-beta1.zip\";s:12:\"3.32.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.32.0-beta2.zip\";s:12:\"3.32.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.32.0-beta3.zip\";s:11:\"3.32.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.32.0-dev1.zip\";s:11:\"3.32.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.32.0-dev2.zip\";s:11:\"3.32.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.32.0-dev3.zip\";s:6:\"3.32.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.32.1.zip\";s:6:\"3.32.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.32.2.zip\";s:6:\"3.32.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.32.3.zip\";s:6:\"3.32.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.32.4.zip\";s:6:\"3.32.5\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.32.5.zip\";s:6:\"3.33.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.33.0.zip\";s:12:\"3.33.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.33.0-beta1.zip\";s:12:\"3.33.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.33.0-beta2.zip\";s:12:\"3.33.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.33.0-beta3.zip\";s:12:\"3.33.0-beta4\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.33.0-beta4.zip\";s:11:\"3.33.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.33.0-dev1.zip\";s:11:\"3.33.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.33.0-dev2.zip\";s:11:\"3.33.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.33.0-dev3.zip\";s:11:\"3.33.0-dev4\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.33.0-dev4.zip\";s:6:\"3.33.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.33.1.zip\";s:6:\"3.33.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.33.2.zip\";s:6:\"3.33.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.33.3.zip\";s:6:\"3.33.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.33.4.zip\";s:6:\"3.33.5\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.33.5.zip\";s:6:\"3.33.6\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.33.6.zip\";s:12:\"3.34.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.34.0-beta1.zip\";s:12:\"3.34.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.34.0-beta2.zip\";s:12:\"3.34.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.34.0-beta3.zip\";s:11:\"3.34.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.34.0-dev1.zip\";s:11:\"3.34.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.34.0-dev2.zip\";s:5:\"3.4.0\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.4.0.zip\";s:10:\"3.4.0-dev7\";s:63:\"https://downloads.wordpress.org/plugin/elementor.3.4.0-dev7.zip\";s:10:\"3.4.0-dev8\";s:63:\"https://downloads.wordpress.org/plugin/elementor.3.4.0-dev8.zip\";s:10:\"3.4.0-dev9\";s:63:\"https://downloads.wordpress.org/plugin/elementor.3.4.0-dev9.zip\";s:5:\"3.4.1\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.4.1.zip\";s:5:\"3.4.2\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.4.2.zip\";s:5:\"3.4.3\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.4.3.zip\";s:5:\"3.4.4\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.4.4.zip\";s:5:\"3.4.5\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.4.5.zip\";s:5:\"3.4.6\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.4.6.zip\";s:5:\"3.4.7\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.4.7.zip\";s:5:\"3.4.8\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.4.8.zip\";s:5:\"3.5.0\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.5.0.zip\";s:11:\"3.5.0-beta1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.5.0-beta1.zip\";s:11:\"3.5.0-beta2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.5.0-beta2.zip\";s:11:\"3.5.0-beta3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.5.0-beta3.zip\";s:11:\"3.5.0-beta4\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.5.0-beta4.zip\";s:11:\"3.5.0-beta5\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.5.0-beta5.zip\";s:11:\"3.5.0-beta7\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.5.0-beta7.zip\";s:11:\"3.5.0-beta8\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.5.0-beta8.zip\";s:10:\"3.5.0-dev8\";s:63:\"https://downloads.wordpress.org/plugin/elementor.3.5.0-dev8.zip\";s:10:\"3.5.0-dev9\";s:63:\"https://downloads.wordpress.org/plugin/elementor.3.5.0-dev9.zip\";s:5:\"3.5.1\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.5.1.zip\";s:5:\"3.5.2\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.5.2.zip\";s:5:\"3.5.3\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.5.3.zip\";s:5:\"3.5.4\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.5.4.zip\";s:5:\"3.5.5\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.5.5.zip\";s:5:\"3.5.6\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.5.6.zip\";s:5:\"3.6.0\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.6.0.zip\";s:11:\"3.6.0-beta1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.6.0-beta1.zip\";s:11:\"3.6.0-beta2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.6.0-beta2.zip\";s:11:\"3.6.0-beta3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.6.0-beta3.zip\";s:11:\"3.6.0-beta4\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.6.0-beta4.zip\";s:11:\"3.6.0-beta5\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.6.0-beta5.zip\";s:10:\"3.6.0-dev1\";s:63:\"https://downloads.wordpress.org/plugin/elementor.3.6.0-dev1.zip\";s:11:\"3.6.0-dev10\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.6.0-dev10.zip\";s:5:\"3.6.1\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.6.1.zip\";s:5:\"3.6.2\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.6.2.zip\";s:5:\"3.6.3\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.6.3.zip\";s:5:\"3.6.4\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.6.4.zip\";s:5:\"3.6.5\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.6.5.zip\";s:5:\"3.6.6\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.6.6.zip\";s:5:\"3.6.7\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.6.7.zip\";s:5:\"3.6.8\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.6.8.zip\";s:5:\"3.7.0\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.7.0.zip\";s:11:\"3.7.0-beta1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.7.0-beta1.zip\";s:11:\"3.7.0-beta2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.7.0-beta2.zip\";s:11:\"3.7.0-beta3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.7.0-beta3.zip\";s:11:\"3.7.0-beta4\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.7.0-beta4.zip\";s:10:\"3.7.0-dev1\";s:63:\"https://downloads.wordpress.org/plugin/elementor.3.7.0-dev1.zip\";s:5:\"3.7.1\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.7.1.zip\";s:5:\"3.7.2\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.7.2.zip\";s:5:\"3.7.3\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.7.3.zip\";s:5:\"3.7.4\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.7.4.zip\";s:5:\"3.7.5\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.7.5.zip\";s:5:\"3.7.6\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.7.6.zip\";s:5:\"3.7.7\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.7.7.zip\";s:5:\"3.7.8\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.7.8.zip\";s:5:\"3.8.0\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.8.0.zip\";s:11:\"3.8.0-beta1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.8.0-beta1.zip\";s:11:\"3.8.0-beta2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.8.0-beta2.zip\";s:11:\"3.8.0-beta3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.8.0-beta3.zip\";s:5:\"3.8.1\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.8.1.zip\";s:5:\"3.9.0\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.9.0.zip\";s:5:\"3.9.1\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.9.1.zip\";s:5:\"3.9.2\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.9.2.zip\";s:5:\"trunk\";s:52:\"https://downloads.wordpress.org/plugin/elementor.zip\";}s:14:\"business_model\";s:10:\"commercial\";s:14:\"repository_url\";s:0:\"\";s:22:\"commercial_support_url\";s:94:\"https://elementor.com/support/?utm_source=wp-repo&utm_medium=link&utm_campaign=premium-support\";s:11:\"donate_link\";s:0:\"\";s:7:\"banners\";a:2:{s:3:\"low\";s:64:\"https://ps.w.org/elementor/assets/banner-772x250.png?rev=3164133\";s:4:\"high\";s:65:\"https://ps.w.org/elementor/assets/banner-1544x500.png?rev=3164133\";}s:5:\"icons\";a:2:{s:2:\"1x\";s:62:\"https://ps.w.org/elementor/assets/icon-128x128.gif?rev=3111597\";s:2:\"2x\";s:62:\"https://ps.w.org/elementor/assets/icon-256x256.gif?rev=3111597\";}s:12:\"preview_link\";s:0:\"\";s:4:\"Name\";s:63:\"Elementor Website Builder &#8211; More Than Just a Page Builder\";}}","off"),
("1881","wp_notes_notify","1","on"),
("1882","_transient_wp_core_block_css_files","a:2:{s:7:\"version\";s:3:\"6.9\";s:5:\"files\";a:584:{i:0;s:31:\"accordion-heading/style-rtl.css\";i:1;s:35:\"accordion-heading/style-rtl.min.css\";i:2;s:27:\"accordion-heading/style.css\";i:3;s:31:\"accordion-heading/style.min.css\";i:4;s:28:\"accordion-item/style-rtl.css\";i:5;s:32:\"accordion-item/style-rtl.min.css\";i:6;s:24:\"accordion-item/style.css\";i:7;s:28:\"accordion-item/style.min.css\";i:8;s:29:\"accordion-panel/style-rtl.css\";i:9;s:33:\"accordion-panel/style-rtl.min.css\";i:10;s:25:\"accordion-panel/style.css\";i:11;s:29:\"accordion-panel/style.min.css\";i:12;s:23:\"accordion/style-rtl.css\";i:13;s:27:\"accordion/style-rtl.min.css\";i:14;s:19:\"accordion/style.css\";i:15;s:23:\"accordion/style.min.css\";i:16;s:23:\"archives/editor-rtl.css\";i:17;s:27:\"archives/editor-rtl.min.css\";i:18;s:19:\"archives/editor.css\";i:19;s:23:\"archives/editor.min.css\";i:20;s:22:\"archives/style-rtl.css\";i:21;s:26:\"archives/style-rtl.min.css\";i:22;s:18:\"archives/style.css\";i:23;s:22:\"archives/style.min.css\";i:24;s:20:\"audio/editor-rtl.css\";i:25;s:24:\"audio/editor-rtl.min.css\";i:26;s:16:\"audio/editor.css\";i:27;s:20:\"audio/editor.min.css\";i:28;s:19:\"audio/style-rtl.css\";i:29;s:23:\"audio/style-rtl.min.css\";i:30;s:15:\"audio/style.css\";i:31;s:19:\"audio/style.min.css\";i:32;s:19:\"audio/theme-rtl.css\";i:33;s:23:\"audio/theme-rtl.min.css\";i:34;s:15:\"audio/theme.css\";i:35;s:19:\"audio/theme.min.css\";i:36;s:21:\"avatar/editor-rtl.css\";i:37;s:25:\"avatar/editor-rtl.min.css\";i:38;s:17:\"avatar/editor.css\";i:39;s:21:\"avatar/editor.min.css\";i:40;s:20:\"avatar/style-rtl.css\";i:41;s:24:\"avatar/style-rtl.min.css\";i:42;s:16:\"avatar/style.css\";i:43;s:20:\"avatar/style.min.css\";i:44;s:21:\"button/editor-rtl.css\";i:45;s:25:\"button/editor-rtl.min.css\";i:46;s:17:\"button/editor.css\";i:47;s:21:\"button/editor.min.css\";i:48;s:20:\"button/style-rtl.css\";i:49;s:24:\"button/style-rtl.min.css\";i:50;s:16:\"button/style.css\";i:51;s:20:\"button/style.min.css\";i:52;s:22:\"buttons/editor-rtl.css\";i:53;s:26:\"buttons/editor-rtl.min.css\";i:54;s:18:\"buttons/editor.css\";i:55;s:22:\"buttons/editor.min.css\";i:56;s:21:\"buttons/style-rtl.css\";i:57;s:25:\"buttons/style-rtl.min.css\";i:58;s:17:\"buttons/style.css\";i:59;s:21:\"buttons/style.min.css\";i:60;s:22:\"calendar/style-rtl.css\";i:61;s:26:\"calendar/style-rtl.min.css\";i:62;s:18:\"calendar/style.css\";i:63;s:22:\"calendar/style.min.css\";i:64;s:25:\"categories/editor-rtl.css\";i:65;s:29:\"categories/editor-rtl.min.css\";i:66;s:21:\"categories/editor.css\";i:67;s:25:\"categories/editor.min.css\";i:68;s:24:\"categories/style-rtl.css\";i:69;s:28:\"categories/style-rtl.min.css\";i:70;s:20:\"categories/style.css\";i:71;s:24:\"categories/style.min.css\";i:72;s:19:\"code/editor-rtl.css\";i:73;s:23:\"code/editor-rtl.min.css\";i:74;s:15:\"code/editor.css\";i:75;s:19:\"code/editor.min.css\";i:76;s:18:\"code/style-rtl.css\";i:77;s:22:\"code/style-rtl.min.css\";i:78;s:14:\"code/style.css\";i:79;s:18:\"code/style.min.css\";i:80;s:18:\"code/theme-rtl.css\";i:81;s:22:\"code/theme-rtl.min.css\";i:82;s:14:\"code/theme.css\";i:83;s:18:\"code/theme.min.css\";i:84;s:22:\"columns/editor-rtl.css\";i:85;s:26:\"columns/editor-rtl.min.css\";i:86;s:18:\"columns/editor.css\";i:87;s:22:\"columns/editor.min.css\";i:88;s:21:\"columns/style-rtl.css\";i:89;s:25:\"columns/style-rtl.min.css\";i:90;s:17:\"columns/style.css\";i:91;s:21:\"columns/style.min.css\";i:92;s:33:\"comment-author-name/style-rtl.css\";i:93;s:37:\"comment-author-name/style-rtl.min.css\";i:94;s:29:\"comment-author-name/style.css\";i:95;s:33:\"comment-author-name/style.min.css\";i:96;s:29:\"comment-content/style-rtl.css\";i:97;s:33:\"comment-content/style-rtl.min.css\";i:98;s:25:\"comment-content/style.css\";i:99;s:29:\"comment-content/style.min.css\";i:100;s:26:\"comment-date/style-rtl.css\";i:101;s:30:\"comment-date/style-rtl.min.css\";i:102;s:22:\"comment-date/style.css\";i:103;s:26:\"comment-date/style.min.css\";i:104;s:31:\"comment-edit-link/style-rtl.css\";i:105;s:35:\"comment-edit-link/style-rtl.min.css\";i:106;s:27:\"comment-edit-link/style.css\";i:107;s:31:\"comment-edit-link/style.min.css\";i:108;s:32:\"comment-reply-link/style-rtl.css\";i:109;s:36:\"comment-reply-link/style-rtl.min.css\";i:110;s:28:\"comment-reply-link/style.css\";i:111;s:32:\"comment-reply-link/style.min.css\";i:112;s:30:\"comment-template/style-rtl.css\";i:113;s:34:\"comment-template/style-rtl.min.css\";i:114;s:26:\"comment-template/style.css\";i:115;s:30:\"comment-template/style.min.css\";i:116;s:42:\"comments-pagination-numbers/editor-rtl.css\";i:117;s:46:\"comments-pagination-numbers/editor-rtl.min.css\";i:118;s:38:\"comments-pagination-numbers/editor.css\";i:119;s:42:\"comments-pagination-numbers/editor.min.css\";i:120;s:34:\"comments-pagination/editor-rtl.css\";i:121;s:38:\"comments-pagination/editor-rtl.min.css\";i:122;s:30:\"comments-pagination/editor.css\";i:123;s:34:\"comments-pagination/editor.min.css\";i:124;s:33:\"comments-pagination/style-rtl.css\";i:125;s:37:\"comments-pagination/style-rtl.min.css\";i:126;s:29:\"comments-pagination/style.css\";i:127;s:33:\"comments-pagination/style.min.css\";i:128;s:29:\"comments-title/editor-rtl.css\";i:129;s:33:\"comments-title/editor-rtl.min.css\";i:130;s:25:\"comments-title/editor.css\";i:131;s:29:\"comments-title/editor.min.css\";i:132;s:23:\"comments/editor-rtl.css\";i:133;s:27:\"comments/editor-rtl.min.css\";i:134;s:19:\"comments/editor.css\";i:135;s:23:\"comments/editor.min.css\";i:136;s:22:\"comments/style-rtl.css\";i:137;s:26:\"comments/style-rtl.min.css\";i:138;s:18:\"comments/style.css\";i:139;s:22:\"comments/style.min.css\";i:140;s:20:\"cover/editor-rtl.css\";i:141;s:24:\"cover/editor-rtl.min.css\";i:142;s:16:\"cover/editor.css\";i:143;s:20:\"cover/editor.min.css\";i:144;s:19:\"cover/style-rtl.css\";i:145;s:23:\"cover/style-rtl.min.css\";i:146;s:15:\"cover/style.css\";i:147;s:19:\"cover/style.min.css\";i:148;s:22:\"details/editor-rtl.css\";i:149;s:26:\"details/editor-rtl.min.css\";i:150;s:18:\"details/editor.css\";i:151;s:22:\"details/editor.min.css\";i:152;s:21:\"details/style-rtl.css\";i:153;s:25:\"details/style-rtl.min.css\";i:154;s:17:\"details/style.css\";i:155;s:21:\"details/style.min.css\";i:156;s:20:\"embed/editor-rtl.css\";i:157;s:24:\"embed/editor-rtl.min.css\";i:158;s:16:\"embed/editor.css\";i:159;s:20:\"embed/editor.min.css\";i:160;s:19:\"embed/style-rtl.css\";i:161;s:23:\"embed/style-rtl.min.css\";i:162;s:15:\"embed/style.css\";i:163;s:19:\"embed/style.min.css\";i:164;s:19:\"embed/theme-rtl.css\";i:165;s:23:\"embed/theme-rtl.min.css\";i:166;s:15:\"embed/theme.css\";i:167;s:19:\"embed/theme.min.css\";i:168;s:19:\"file/editor-rtl.css\";i:169;s:23:\"file/editor-rtl.min.css\";i:170;s:15:\"file/editor.css\";i:171;s:19:\"file/editor.min.css\";i:172;s:18:\"file/style-rtl.css\";i:173;s:22:\"file/style-rtl.min.css\";i:174;s:14:\"file/style.css\";i:175;s:18:\"file/style.min.css\";i:176;s:23:\"footnotes/style-rtl.css\";i:177;s:27:\"footnotes/style-rtl.min.css\";i:178;s:19:\"footnotes/style.css\";i:179;s:23:\"footnotes/style.min.css\";i:180;s:23:\"freeform/editor-rtl.css\";i:181;s:27:\"freeform/editor-rtl.min.css\";i:182;s:19:\"freeform/editor.css\";i:183;s:23:\"freeform/editor.min.css\";i:184;s:22:\"gallery/editor-rtl.css\";i:185;s:26:\"gallery/editor-rtl.min.css\";i:186;s:18:\"gallery/editor.css\";i:187;s:22:\"gallery/editor.min.css\";i:188;s:21:\"gallery/style-rtl.css\";i:189;s:25:\"gallery/style-rtl.min.css\";i:190;s:17:\"gallery/style.css\";i:191;s:21:\"gallery/style.min.css\";i:192;s:21:\"gallery/theme-rtl.css\";i:193;s:25:\"gallery/theme-rtl.min.css\";i:194;s:17:\"gallery/theme.css\";i:195;s:21:\"gallery/theme.min.css\";i:196;s:20:\"group/editor-rtl.css\";i:197;s:24:\"group/editor-rtl.min.css\";i:198;s:16:\"group/editor.css\";i:199;s:20:\"group/editor.min.css\";i:200;s:19:\"group/style-rtl.css\";i:201;s:23:\"group/style-rtl.min.css\";i:202;s:15:\"group/style.css\";i:203;s:19:\"group/style.min.css\";i:204;s:19:\"group/theme-rtl.css\";i:205;s:23:\"group/theme-rtl.min.css\";i:206;s:15:\"group/theme.css\";i:207;s:19:\"group/theme.min.css\";i:208;s:21:\"heading/style-rtl.css\";i:209;s:25:\"heading/style-rtl.min.css\";i:210;s:17:\"heading/style.css\";i:211;s:21:\"heading/style.min.css\";i:212;s:19:\"html/editor-rtl.css\";i:213;s:23:\"html/editor-rtl.min.css\";i:214;s:15:\"html/editor.css\";i:215;s:19:\"html/editor.min.css\";i:216;s:20:\"image/editor-rtl.css\";i:217;s:24:\"image/editor-rtl.min.css\";i:218;s:16:\"image/editor.css\";i:219;s:20:\"image/editor.min.css\";i:220;s:19:\"image/style-rtl.css\";i:221;s:23:\"image/style-rtl.min.css\";i:222;s:15:\"image/style.css\";i:223;s:19:\"image/style.min.css\";i:224;s:19:\"image/theme-rtl.css\";i:225;s:23:\"image/theme-rtl.min.css\";i:226;s:15:\"image/theme.css\";i:227;s:19:\"image/theme.min.css\";i:228;s:29:\"latest-comments/style-rtl.css\";i:229;s:33:\"latest-comments/style-rtl.min.css\";i:230;s:25:\"latest-comments/style.css\";i:231;s:29:\"latest-comments/style.min.css\";i:232;s:27:\"latest-posts/editor-rtl.css\";i:233;s:31:\"latest-posts/editor-rtl.min.css\";i:234;s:23:\"latest-posts/editor.css\";i:235;s:27:\"latest-posts/editor.min.css\";i:236;s:26:\"latest-posts/style-rtl.css\";i:237;s:30:\"latest-posts/style-rtl.min.css\";i:238;s:22:\"latest-posts/style.css\";i:239;s:26:\"latest-posts/style.min.css\";i:240;s:18:\"list/style-rtl.css\";i:241;s:22:\"list/style-rtl.min.css\";i:242;s:14:\"list/style.css\";i:243;s:18:\"list/style.min.css\";i:244;s:22:\"loginout/style-rtl.css\";i:245;s:26:\"loginout/style-rtl.min.css\";i:246;s:18:\"loginout/style.css\";i:247;s:22:\"loginout/style.min.css\";i:248;s:19:\"math/editor-rtl.css\";i:249;s:23:\"math/editor-rtl.min.css\";i:250;s:15:\"math/editor.css\";i:251;s:19:\"math/editor.min.css\";i:252;s:18:\"math/style-rtl.css\";i:253;s:22:\"math/style-rtl.min.css\";i:254;s:14:\"math/style.css\";i:255;s:18:\"math/style.min.css\";i:256;s:25:\"media-text/editor-rtl.css\";i:257;s:29:\"media-text/editor-rtl.min.css\";i:258;s:21:\"media-text/editor.css\";i:259;s:25:\"media-text/editor.min.css\";i:260;s:24:\"media-text/style-rtl.css\";i:261;s:28:\"media-text/style-rtl.min.css\";i:262;s:20:\"media-text/style.css\";i:263;s:24:\"media-text/style.min.css\";i:264;s:19:\"more/editor-rtl.css\";i:265;s:23:\"more/editor-rtl.min.css\";i:266;s:15:\"more/editor.css\";i:267;s:19:\"more/editor.min.css\";i:268;s:30:\"navigation-link/editor-rtl.css\";i:269;s:34:\"navigation-link/editor-rtl.min.css\";i:270;s:26:\"navigation-link/editor.css\";i:271;s:30:\"navigation-link/editor.min.css\";i:272;s:29:\"navigation-link/style-rtl.css\";i:273;s:33:\"navigation-link/style-rtl.min.css\";i:274;s:25:\"navigation-link/style.css\";i:275;s:29:\"navigation-link/style.min.css\";i:276;s:33:\"navigation-submenu/editor-rtl.css\";i:277;s:37:\"navigation-submenu/editor-rtl.min.css\";i:278;s:29:\"navigation-submenu/editor.css\";i:279;s:33:\"navigation-submenu/editor.min.css\";i:280;s:25:\"navigation/editor-rtl.css\";i:281;s:29:\"navigation/editor-rtl.min.css\";i:282;s:21:\"navigation/editor.css\";i:283;s:25:\"navigation/editor.min.css\";i:284;s:24:\"navigation/style-rtl.css\";i:285;s:28:\"navigation/style-rtl.min.css\";i:286;s:20:\"navigation/style.css\";i:287;s:24:\"navigation/style.min.css\";i:288;s:23:\"nextpage/editor-rtl.css\";i:289;s:27:\"nextpage/editor-rtl.min.css\";i:290;s:19:\"nextpage/editor.css\";i:291;s:23:\"nextpage/editor.min.css\";i:292;s:24:\"page-list/editor-rtl.css\";i:293;s:28:\"page-list/editor-rtl.min.css\";i:294;s:20:\"page-list/editor.css\";i:295;s:24:\"page-list/editor.min.css\";i:296;s:23:\"page-list/style-rtl.css\";i:297;s:27:\"page-list/style-rtl.min.css\";i:298;s:19:\"page-list/style.css\";i:299;s:23:\"page-list/style.min.css\";i:300;s:24:\"paragraph/editor-rtl.css\";i:301;s:28:\"paragraph/editor-rtl.min.css\";i:302;s:20:\"paragraph/editor.css\";i:303;s:24:\"paragraph/editor.min.css\";i:304;s:23:\"paragraph/style-rtl.css\";i:305;s:27:\"paragraph/style-rtl.min.css\";i:306;s:19:\"paragraph/style.css\";i:307;s:23:\"paragraph/style.min.css\";i:308;s:35:\"post-author-biography/style-rtl.css\";i:309;s:39:\"post-author-biography/style-rtl.min.css\";i:310;s:31:\"post-author-biography/style.css\";i:311;s:35:\"post-author-biography/style.min.css\";i:312;s:30:\"post-author-name/style-rtl.css\";i:313;s:34:\"post-author-name/style-rtl.min.css\";i:314;s:26:\"post-author-name/style.css\";i:315;s:30:\"post-author-name/style.min.css\";i:316;s:25:\"post-author/style-rtl.css\";i:317;s:29:\"post-author/style-rtl.min.css\";i:318;s:21:\"post-author/style.css\";i:319;s:25:\"post-author/style.min.css\";i:320;s:33:\"post-comments-count/style-rtl.css\";i:321;s:37:\"post-comments-count/style-rtl.min.css\";i:322;s:29:\"post-comments-count/style.css\";i:323;s:33:\"post-comments-count/style.min.css\";i:324;s:33:\"post-comments-form/editor-rtl.css\";i:325;s:37:\"post-comments-form/editor-rtl.min.css\";i:326;s:29:\"post-comments-form/editor.css\";i:327;s:33:\"post-comments-form/editor.min.css\";i:328;s:32:\"post-comments-form/style-rtl.css\";i:329;s:36:\"post-comments-form/style-rtl.min.css\";i:330;s:28:\"post-comments-form/style.css\";i:331;s:32:\"post-comments-form/style.min.css\";i:332;s:32:\"post-comments-link/style-rtl.css\";i:333;s:36:\"post-comments-link/style-rtl.min.css\";i:334;s:28:\"post-comments-link/style.css\";i:335;s:32:\"post-comments-link/style.min.css\";i:336;s:26:\"post-content/style-rtl.css\";i:337;s:30:\"post-content/style-rtl.min.css\";i:338;s:22:\"post-content/style.css\";i:339;s:26:\"post-content/style.min.css\";i:340;s:23:\"post-date/style-rtl.css\";i:341;s:27:\"post-date/style-rtl.min.css\";i:342;s:19:\"post-date/style.css\";i:343;s:23:\"post-date/style.min.css\";i:344;s:27:\"post-excerpt/editor-rtl.css\";i:345;s:31:\"post-excerpt/editor-rtl.min.css\";i:346;s:23:\"post-excerpt/editor.css\";i:347;s:27:\"post-excerpt/editor.min.css\";i:348;s:26:\"post-excerpt/style-rtl.css\";i:349;s:30:\"post-excerpt/style-rtl.min.css\";i:350;s:22:\"post-excerpt/style.css\";i:351;s:26:\"post-excerpt/style.min.css\";i:352;s:34:\"post-featured-image/editor-rtl.css\";i:353;s:38:\"post-featured-image/editor-rtl.min.css\";i:354;s:30:\"post-featured-image/editor.css\";i:355;s:34:\"post-featured-image/editor.min.css\";i:356;s:33:\"post-featured-image/style-rtl.css\";i:357;s:37:\"post-featured-image/style-rtl.min.css\";i:358;s:29:\"post-featured-image/style.css\";i:359;s:33:\"post-featured-image/style.min.css\";i:360;s:34:\"post-navigation-link/style-rtl.css\";i:361;s:38:\"post-navigation-link/style-rtl.min.css\";i:362;s:30:\"post-navigation-link/style.css\";i:363;s:34:\"post-navigation-link/style.min.css\";i:364;s:27:\"post-template/style-rtl.css\";i:365;s:31:\"post-template/style-rtl.min.css\";i:366;s:23:\"post-template/style.css\";i:367;s:27:\"post-template/style.min.css\";i:368;s:24:\"post-terms/style-rtl.css\";i:369;s:28:\"post-terms/style-rtl.min.css\";i:370;s:20:\"post-terms/style.css\";i:371;s:24:\"post-terms/style.min.css\";i:372;s:31:\"post-time-to-read/style-rtl.css\";i:373;s:35:\"post-time-to-read/style-rtl.min.css\";i:374;s:27:\"post-time-to-read/style.css\";i:375;s:31:\"post-time-to-read/style.min.css\";i:376;s:24:\"post-title/style-rtl.css\";i:377;s:28:\"post-title/style-rtl.min.css\";i:378;s:20:\"post-title/style.css\";i:379;s:24:\"post-title/style.min.css\";i:380;s:26:\"preformatted/style-rtl.css\";i:381;s:30:\"preformatted/style-rtl.min.css\";i:382;s:22:\"preformatted/style.css\";i:383;s:26:\"preformatted/style.min.css\";i:384;s:24:\"pullquote/editor-rtl.css\";i:385;s:28:\"pullquote/editor-rtl.min.css\";i:386;s:20:\"pullquote/editor.css\";i:387;s:24:\"pullquote/editor.min.css\";i:388;s:23:\"pullquote/style-rtl.css\";i:389;s:27:\"pullquote/style-rtl.min.css\";i:390;s:19:\"pullquote/style.css\";i:391;s:23:\"pullquote/style.min.css\";i:392;s:23:\"pullquote/theme-rtl.css\";i:393;s:27:\"pullquote/theme-rtl.min.css\";i:394;s:19:\"pullquote/theme.css\";i:395;s:23:\"pullquote/theme.min.css\";i:396;s:39:\"query-pagination-numbers/editor-rtl.css\";i:397;s:43:\"query-pagination-numbers/editor-rtl.min.css\";i:398;s:35:\"query-pagination-numbers/editor.css\";i:399;s:39:\"query-pagination-numbers/editor.min.css\";i:400;s:31:\"query-pagination/editor-rtl.css\";i:401;s:35:\"query-pagination/editor-rtl.min.css\";i:402;s:27:\"query-pagination/editor.css\";i:403;s:31:\"query-pagination/editor.min.css\";i:404;s:30:\"query-pagination/style-rtl.css\";i:405;s:34:\"query-pagination/style-rtl.min.css\";i:406;s:26:\"query-pagination/style.css\";i:407;s:30:\"query-pagination/style.min.css\";i:408;s:25:\"query-title/style-rtl.css\";i:409;s:29:\"query-title/style-rtl.min.css\";i:410;s:21:\"query-title/style.css\";i:411;s:25:\"query-title/style.min.css\";i:412;s:25:\"query-total/style-rtl.css\";i:413;s:29:\"query-total/style-rtl.min.css\";i:414;s:21:\"query-total/style.css\";i:415;s:25:\"query-total/style.min.css\";i:416;s:20:\"query/editor-rtl.css\";i:417;s:24:\"query/editor-rtl.min.css\";i:418;s:16:\"query/editor.css\";i:419;s:20:\"query/editor.min.css\";i:420;s:19:\"quote/style-rtl.css\";i:421;s:23:\"quote/style-rtl.min.css\";i:422;s:15:\"quote/style.css\";i:423;s:19:\"quote/style.min.css\";i:424;s:19:\"quote/theme-rtl.css\";i:425;s:23:\"quote/theme-rtl.min.css\";i:426;s:15:\"quote/theme.css\";i:427;s:19:\"quote/theme.min.css\";i:428;s:23:\"read-more/style-rtl.css\";i:429;s:27:\"read-more/style-rtl.min.css\";i:430;s:19:\"read-more/style.css\";i:431;s:23:\"read-more/style.min.css\";i:432;s:18:\"rss/editor-rtl.css\";i:433;s:22:\"rss/editor-rtl.min.css\";i:434;s:14:\"rss/editor.css\";i:435;s:18:\"rss/editor.min.css\";i:436;s:17:\"rss/style-rtl.css\";i:437;s:21:\"rss/style-rtl.min.css\";i:438;s:13:\"rss/style.css\";i:439;s:17:\"rss/style.min.css\";i:440;s:21:\"search/editor-rtl.css\";i:441;s:25:\"search/editor-rtl.min.css\";i:442;s:17:\"search/editor.css\";i:443;s:21:\"search/editor.min.css\";i:444;s:20:\"search/style-rtl.css\";i:445;s:24:\"search/style-rtl.min.css\";i:446;s:16:\"search/style.css\";i:447;s:20:\"search/style.min.css\";i:448;s:20:\"search/theme-rtl.css\";i:449;s:24:\"search/theme-rtl.min.css\";i:450;s:16:\"search/theme.css\";i:451;s:20:\"search/theme.min.css\";i:452;s:24:\"separator/editor-rtl.css\";i:453;s:28:\"separator/editor-rtl.min.css\";i:454;s:20:\"separator/editor.css\";i:455;s:24:\"separator/editor.min.css\";i:456;s:23:\"separator/style-rtl.css\";i:457;s:27:\"separator/style-rtl.min.css\";i:458;s:19:\"separator/style.css\";i:459;s:23:\"separator/style.min.css\";i:460;s:23:\"separator/theme-rtl.css\";i:461;s:27:\"separator/theme-rtl.min.css\";i:462;s:19:\"separator/theme.css\";i:463;s:23:\"separator/theme.min.css\";i:464;s:24:\"shortcode/editor-rtl.css\";i:465;s:28:\"shortcode/editor-rtl.min.css\";i:466;s:20:\"shortcode/editor.css\";i:467;s:24:\"shortcode/editor.min.css\";i:468;s:24:\"site-logo/editor-rtl.css\";i:469;s:28:\"site-logo/editor-rtl.min.css\";i:470;s:20:\"site-logo/editor.css\";i:471;s:24:\"site-logo/editor.min.css\";i:472;s:23:\"site-logo/style-rtl.css\";i:473;s:27:\"site-logo/style-rtl.min.css\";i:474;s:19:\"site-logo/style.css\";i:475;s:23:\"site-logo/style.min.css\";i:476;s:27:\"site-tagline/editor-rtl.css\";i:477;s:31:\"site-tagline/editor-rtl.min.css\";i:478;s:23:\"site-tagline/editor.css\";i:479;s:27:\"site-tagline/editor.min.css\";i:480;s:26:\"site-tagline/style-rtl.css\";i:481;s:30:\"site-tagline/style-rtl.min.css\";i:482;s:22:\"site-tagline/style.css\";i:483;s:26:\"site-tagline/style.min.css\";i:484;s:25:\"site-title/editor-rtl.css\";i:485;s:29:\"site-title/editor-rtl.min.css\";i:486;s:21:\"site-title/editor.css\";i:487;s:25:\"site-title/editor.min.css\";i:488;s:24:\"site-title/style-rtl.css\";i:489;s:28:\"site-title/style-rtl.min.css\";i:490;s:20:\"site-title/style.css\";i:491;s:24:\"site-title/style.min.css\";i:492;s:26:\"social-link/editor-rtl.css\";i:493;s:30:\"social-link/editor-rtl.min.css\";i:494;s:22:\"social-link/editor.css\";i:495;s:26:\"social-link/editor.min.css\";i:496;s:27:\"social-links/editor-rtl.css\";i:497;s:31:\"social-links/editor-rtl.min.css\";i:498;s:23:\"social-links/editor.css\";i:499;s:27:\"social-links/editor.min.css\";i:500;s:26:\"social-links/style-rtl.css\";i:501;s:30:\"social-links/style-rtl.min.css\";i:502;s:22:\"social-links/style.css\";i:503;s:26:\"social-links/style.min.css\";i:504;s:21:\"spacer/editor-rtl.css\";i:505;s:25:\"spacer/editor-rtl.min.css\";i:506;s:17:\"spacer/editor.css\";i:507;s:21:\"spacer/editor.min.css\";i:508;s:20:\"spacer/style-rtl.css\";i:509;s:24:\"spacer/style-rtl.min.css\";i:510;s:16:\"spacer/style.css\";i:511;s:20:\"spacer/style.min.css\";i:512;s:20:\"table/editor-rtl.css\";i:513;s:24:\"table/editor-rtl.min.css\";i:514;s:16:\"table/editor.css\";i:515;s:20:\"table/editor.min.css\";i:516;s:19:\"table/style-rtl.css\";i:517;s:23:\"table/style-rtl.min.css\";i:518;s:15:\"table/style.css\";i:519;s:19:\"table/style.min.css\";i:520;s:19:\"table/theme-rtl.css\";i:521;s:23:\"table/theme-rtl.min.css\";i:522;s:15:\"table/theme.css\";i:523;s:19:\"table/theme.min.css\";i:524;s:24:\"tag-cloud/editor-rtl.css\";i:525;s:28:\"tag-cloud/editor-rtl.min.css\";i:526;s:20:\"tag-cloud/editor.css\";i:527;s:24:\"tag-cloud/editor.min.css\";i:528;s:23:\"tag-cloud/style-rtl.css\";i:529;s:27:\"tag-cloud/style-rtl.min.css\";i:530;s:19:\"tag-cloud/style.css\";i:531;s:23:\"tag-cloud/style.min.css\";i:532;s:28:\"template-part/editor-rtl.css\";i:533;s:32:\"template-part/editor-rtl.min.css\";i:534;s:24:\"template-part/editor.css\";i:535;s:28:\"template-part/editor.min.css\";i:536;s:27:\"template-part/theme-rtl.css\";i:537;s:31:\"template-part/theme-rtl.min.css\";i:538;s:23:\"template-part/theme.css\";i:539;s:27:\"template-part/theme.min.css\";i:540;s:24:\"term-count/style-rtl.css\";i:541;s:28:\"term-count/style-rtl.min.css\";i:542;s:20:\"term-count/style.css\";i:543;s:24:\"term-count/style.min.css\";i:544;s:30:\"term-description/style-rtl.css\";i:545;s:34:\"term-description/style-rtl.min.css\";i:546;s:26:\"term-description/style.css\";i:547;s:30:\"term-description/style.min.css\";i:548;s:23:\"term-name/style-rtl.css\";i:549;s:27:\"term-name/style-rtl.min.css\";i:550;s:19:\"term-name/style.css\";i:551;s:23:\"term-name/style.min.css\";i:552;s:28:\"term-template/editor-rtl.css\";i:553;s:32:\"term-template/editor-rtl.min.css\";i:554;s:24:\"term-template/editor.css\";i:555;s:28:\"term-template/editor.min.css\";i:556;s:27:\"term-template/style-rtl.css\";i:557;s:31:\"term-template/style-rtl.min.css\";i:558;s:23:\"term-template/style.css\";i:559;s:27:\"term-template/style.min.css\";i:560;s:27:\"text-columns/editor-rtl.css\";i:561;s:31:\"text-columns/editor-rtl.min.css\";i:562;s:23:\"text-columns/editor.css\";i:563;s:27:\"text-columns/editor.min.css\";i:564;s:26:\"text-columns/style-rtl.css\";i:565;s:30:\"text-columns/style-rtl.min.css\";i:566;s:22:\"text-columns/style.css\";i:567;s:26:\"text-columns/style.min.css\";i:568;s:19:\"verse/style-rtl.css\";i:569;s:23:\"verse/style-rtl.min.css\";i:570;s:15:\"verse/style.css\";i:571;s:19:\"verse/style.min.css\";i:572;s:20:\"video/editor-rtl.css\";i:573;s:24:\"video/editor-rtl.min.css\";i:574;s:16:\"video/editor.css\";i:575;s:20:\"video/editor.min.css\";i:576;s:19:\"video/style-rtl.css\";i:577;s:23:\"video/style-rtl.min.css\";i:578;s:15:\"video/style.css\";i:579;s:19:\"video/style.min.css\";i:580;s:19:\"video/theme-rtl.css\";i:581;s:23:\"video/theme-rtl.min.css\";i:582;s:15:\"video/theme.css\";i:583;s:19:\"video/theme.min.css\";}}","on"),
("1885","_site_transient_update_core","O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:57:\"https://downloads.wordpress.org/release/wordpress-6.9.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:57:\"https://downloads.wordpress.org/release/wordpress-6.9.zip\";s:10:\"no_content\";s:68:\"https://downloads.wordpress.org/release/wordpress-6.9-no-content.zip\";s:11:\"new_bundled\";s:69:\"https://downloads.wordpress.org/release/wordpress-6.9-new-bundled.zip\";s:7:\"partial\";s:0:\"\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:3:\"6.9\";s:7:\"version\";s:3:\"6.9\";s:11:\"php_version\";s:6:\"7.2.24\";s:13:\"mysql_version\";s:5:\"5.5.5\";s:11:\"new_bundled\";s:3:\"6.7\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1768448311;s:15:\"version_checked\";s:3:\"6.9\";s:12:\"translations\";a:0:{}}","off"),
("2242","can_compress_scripts","1","on"),
("2279","_elementor_ab_testing_data","a:2:{s:7:\"timeout\";i:1766364405;s:5:\"value\";s:274:\"[{\"coreOnboarding\":{\"emphasizeConnectBenefits101\":false,\"embedConnectInOnboarding102\":false,\"onboardingStartsWithLogin103\":false,\"offerThemeChoicesHelloBiz201\":false,\"emphasizeThemeValueAudience202\":false,\"updateCopyVisuals401\":false,\"reduceHierarchyBlankOption402\":false}}]\";}","off"),
("2327","_site_transient_duplicator_translations_duplicator-pro_plugin","O:8:\"stdClass\":2:{s:14:\"duplicator-pro\";a:1:{s:12:\"translations\";a:10:{i:0;a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:3:\"1.0\";s:7:\"updated\";s:25:\"2025-03-18T13:27:14+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:84:\"https://translations.duplicator.com/packages/duplicator-pro/duplicator-pro-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}i:1;a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:3:\"1.0\";s:7:\"updated\";s:25:\"2025-03-18T13:27:14+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:84:\"https://translations.duplicator.com/packages/duplicator-pro/duplicator-pro-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}i:2;a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:3:\"1.0\";s:7:\"updated\";s:25:\"2025-03-18T13:27:14+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:84:\"https://translations.duplicator.com/packages/duplicator-pro/duplicator-pro-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}i:3;a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:3:\"1.0\";s:7:\"updated\";s:25:\"2025-03-18T13:27:14+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:84:\"https://translations.duplicator.com/packages/duplicator-pro/duplicator-pro-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}i:4;a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:3:\"1.0\";s:7:\"updated\";s:25:\"2025-03-18T13:27:14+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:81:\"https://translations.duplicator.com/packages/duplicator-pro/duplicator-pro-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}i:5;a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:3:\"1.0\";s:7:\"updated\";s:25:\"2025-03-18T13:27:14+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:84:\"https://translations.duplicator.com/packages/duplicator-pro/duplicator-pro-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}i:6;a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:3:\"1.0\";s:7:\"updated\";s:25:\"2025-03-18T13:27:14+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:84:\"https://translations.duplicator.com/packages/duplicator-pro/duplicator-pro-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}i:7;a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:3:\"1.0\";s:7:\"updated\";s:25:\"2025-03-18T13:27:14+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:84:\"https://translations.duplicator.com/packages/duplicator-pro/duplicator-pro-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}i:8;a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:3:\"1.0\";s:7:\"updated\";s:25:\"2025-03-18T13:27:14+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:84:\"https://translations.duplicator.com/packages/duplicator-pro/duplicator-pro-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}i:9;a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:3:\"1.0\";s:7:\"updated\";s:25:\"2025-03-18T13:27:14+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:84:\"https://translations.duplicator.com/packages/duplicator-pro/duplicator-pro-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}}}s:13:\"_last_checked\";i:1766366337;}","off"),
("2333","_elementor_assets_data","a:1:{s:3:\"svg\";a:1:{s:9:\"font-icon\";a:28:{s:12:\"far-envelope\";a:2:{s:7:\"content\";a:4:{s:5:\"width\";i:512;s:6:\"height\";i:512;s:4:\"path\";s:494:\"M464 64H48C21.49 64 0 85.49 0 112v288c0 26.51 21.49 48 48 48h416c26.51 0 48-21.49 48-48V112c0-26.51-21.49-48-48-48zm0 48v40.805c-22.422 18.259-58.168 46.651-134.587 106.49-16.841 13.247-50.201 45.072-73.413 44.701-23.208.375-56.579-31.459-73.413-44.701C106.18 199.465 70.425 171.067 48 152.805V112h416zM48 400V214.398c22.914 18.251 55.409 43.862 104.938 82.646 21.857 17.205 60.134 55.186 103.062 54.955 42.717.231 80.509-37.199 103.053-54.947 49.528-38.783 82.032-64.401 104.947-82.653V400H48z\";s:3:\"key\";s:12:\"far-envelope\";}s:7:\"version\";s:6:\"5.15.3\";}s:14:\"fas-mobile-alt\";a:2:{s:7:\"content\";a:4:{s:5:\"width\";i:320;s:6:\"height\";i:512;s:4:\"path\";s:276:\"M272 0H48C21.5 0 0 21.5 0 48v416c0 26.5 21.5 48 48 48h224c26.5 0 48-21.5 48-48V48c0-26.5-21.5-48-48-48zM160 480c-17.7 0-32-14.3-32-32s14.3-32 32-32 32 14.3 32 32-14.3 32-32 32zm112-108c0 6.6-5.4 12-12 12H60c-6.6 0-12-5.4-12-12V60c0-6.6 5.4-12 12-12h200c6.6 0 12 5.4 12 12v312z\";s:3:\"key\";s:14:\"fas-mobile-alt\";}s:7:\"version\";s:6:\"5.15.3\";}s:8:\"fas-bars\";a:2:{s:7:\"content\";a:4:{s:5:\"width\";i:448;s:6:\"height\";i:512;s:4:\"path\";s:341:\"M16 132h416c8.837 0 16-7.163 16-16V76c0-8.837-7.163-16-16-16H16C7.163 60 0 67.163 0 76v40c0 8.837 7.163 16 16 16zm0 160h416c8.837 0 16-7.163 16-16v-40c0-8.837-7.163-16-16-16H16c-8.837 0-16 7.163-16 16v40c0 8.837 7.163 16 16 16zm0 160h416c8.837 0 16-7.163 16-16v-40c0-8.837-7.163-16-16-16H16c-8.837 0-16 7.163-16 16v40c0 8.837 7.163 16 16 16z\";s:3:\"key\";s:8:\"fas-bars\";}s:7:\"version\";s:6:\"5.15.3\";}s:9:\"fas-times\";a:2:{s:7:\"content\";a:4:{s:5:\"width\";i:352;s:6:\"height\";i:512;s:4:\"path\";s:415:\"M242.72 256l100.07-100.07c12.28-12.28 12.28-32.19 0-44.48l-22.24-22.24c-12.28-12.28-32.19-12.28-44.48 0L176 189.28 75.93 89.21c-12.28-12.28-32.19-12.28-44.48 0L9.21 111.45c-12.28 12.28-12.28 32.19 0 44.48L109.28 256 9.21 356.07c-12.28 12.28-12.28 32.19 0 44.48l22.24 22.24c12.28 12.28 32.2 12.28 44.48 0L176 322.72l100.07 100.07c12.28 12.28 32.2 12.28 44.48 0l22.24-22.24c12.28-12.28 12.28-32.19 0-44.48L242.72 256z\";s:3:\"key\";s:9:\"fas-times\";}s:7:\"version\";s:6:\"5.15.3\";}s:14:\"fas-angle-down\";a:2:{s:7:\"content\";a:4:{s:5:\"width\";i:320;s:6:\"height\";i:512;s:4:\"path\";s:190:\"M143 352.3L7 216.3c-9.4-9.4-9.4-24.6 0-33.9l22.6-22.6c9.4-9.4 24.6-9.4 33.9 0l96.4 96.4 96.4-96.4c9.4-9.4 24.6-9.4 33.9 0l22.6 22.6c9.4 9.4 9.4 24.6 0 33.9l-136 136c-9.2 9.4-24.4 9.4-33.8 0z\";s:3:\"key\";s:14:\"fas-angle-down\";}s:7:\"version\";s:6:\"5.15.3\";}s:9:\"fas-tooth\";a:2:{s:7:\"content\";a:4:{s:5:\"width\";i:448;s:6:\"height\";i:512;s:4:\"path\";s:711:\"M443.98 96.25c-11.01-45.22-47.11-82.06-92.01-93.72-32.19-8.36-63 5.1-89.14 24.33-3.25 2.39-6.96 3.73-10.5 5.48l28.32 18.21c7.42 4.77 9.58 14.67 4.8 22.11-4.46 6.95-14.27 9.86-22.11 4.8L162.83 12.84c-20.7-10.85-43.38-16.4-66.81-10.31-44.9 11.67-81 48.5-92.01 93.72-10.13 41.62-.42 80.81 21.5 110.43 23.36 31.57 32.68 68.66 36.29 107.35 4.4 47.16 10.33 94.16 20.94 140.32l7.8 33.95c3.19 13.87 15.49 23.7 29.67 23.7 13.97 0 26.15-9.55 29.54-23.16l34.47-138.42c4.56-18.32 20.96-31.16 39.76-31.16s35.2 12.85 39.76 31.16l34.47 138.42c3.39 13.61 15.57 23.16 29.54 23.16 14.18 0 26.48-9.83 29.67-23.7l7.8-33.95c10.61-46.15 16.53-93.16 20.94-140.32 3.61-38.7 12.93-75.78 36.29-107.35 21.95-29.61 31.66-68.8 21.53-110.43z\";s:3:\"key\";s:9:\"fas-tooth\";}s:7:\"version\";s:6:\"5.15.3\";}s:16:\"eicon-caret-down\";a:2:{s:7:\"content\";a:4:{s:5:\"width\";d:571.3999999999999772626324556767940521240234375;s:6:\"height\";d:571.3999999999999772626324556767940521240234375;s:4:\"path\";s:118:\"M571 393Q571 407 561 418L311 668Q300 679 286 679T261 668L11 418Q0 407 0 393T11 368 36 357H536Q550 357 561 368T571 393Z\";s:3:\"key\";s:16:\"eicon-caret-down\";}s:7:\"version\";s:6:\"5.13.0\";}s:16:\"fas-check-circle\";a:2:{s:7:\"content\";a:4:{s:5:\"width\";i:512;s:6:\"height\";i:512;s:4:\"path\";s:356:\"M504 256c0 136.967-111.033 248-248 248S8 392.967 8 256 119.033 8 256 8s248 111.033 248 248zM227.314 387.314l184-184c6.248-6.248 6.248-16.379 0-22.627l-22.627-22.627c-6.248-6.249-16.379-6.249-22.628 0L216 308.118l-70.059-70.059c-6.248-6.248-16.379-6.248-22.628 0l-22.627 22.627c-6.248 6.248-6.248 16.379 0 22.627l104 104c6.249 6.249 16.379 6.249 22.628.001z\";s:3:\"key\";s:16:\"fas-check-circle\";}s:7:\"version\";s:6:\"5.15.3\";}s:13:\"far-thumbs-up\";a:2:{s:7:\"content\";a:4:{s:5:\"width\";i:512;s:6:\"height\";i:512;s:4:\"path\";s:964:\"M466.27 286.69C475.04 271.84 480 256 480 236.85c0-44.015-37.218-85.58-85.82-85.58H357.7c4.92-12.81 8.85-28.13 8.85-46.54C366.55 31.936 328.86 0 271.28 0c-61.607 0-58.093 94.933-71.76 108.6-22.747 22.747-49.615 66.447-68.76 83.4H32c-17.673 0-32 14.327-32 32v240c0 17.673 14.327 32 32 32h64c14.893 0 27.408-10.174 30.978-23.95 44.509 1.001 75.06 39.94 177.802 39.94 7.22 0 15.22.01 22.22.01 77.117 0 111.986-39.423 112.94-95.33 13.319-18.425 20.299-43.122 17.34-66.99 9.854-18.452 13.664-40.343 8.99-62.99zm-61.75 53.83c12.56 21.13 1.26 49.41-13.94 57.57 7.7 48.78-17.608 65.9-53.12 65.9h-37.82c-71.639 0-118.029-37.82-171.64-37.82V240h10.92c28.36 0 67.98-70.89 94.54-97.46 28.36-28.36 18.91-75.63 37.82-94.54 47.27 0 47.27 32.98 47.27 56.73 0 39.17-28.36 56.72-28.36 94.54h103.99c21.11 0 37.73 18.91 37.82 37.82.09 18.9-12.82 37.81-22.27 37.81 13.489 14.555 16.371 45.236-5.21 65.62zM88 432c0 13.255-10.745 24-24 24s-24-10.745-24-24 10.745-24 24-24 24 10.745 24 24z\";s:3:\"key\";s:13:\"far-thumbs-up\";}s:7:\"version\";s:6:\"5.15.3\";}s:9:\"far-smile\";a:2:{s:7:\"content\";a:4:{s:5:\"width\";i:496;s:6:\"height\";i:512;s:4:\"path\";s:509:\"M248 8C111 8 0 119 0 256s111 248 248 248 248-111 248-248S385 8 248 8zm0 448c-110.3 0-200-89.7-200-200S137.7 56 248 56s200 89.7 200 200-89.7 200-200 200zm-80-216c17.7 0 32-14.3 32-32s-14.3-32-32-32-32 14.3-32 32 14.3 32 32 32zm160 0c17.7 0 32-14.3 32-32s-14.3-32-32-32-32 14.3-32 32 14.3 32 32 32zm4 72.6c-20.8 25-51.5 39.4-84 39.4s-63.2-14.3-84-39.4c-8.5-10.2-23.7-11.5-33.8-3.1-10.2 8.5-11.5 23.6-3.1 33.8 30 36 74.1 56.6 120.9 56.6s90.9-20.6 120.9-56.6c8.5-10.2 7.1-25.3-3.1-33.8-10.1-8.4-25.3-7.1-33.8 3.1z\";s:3:\"key\";s:9:\"far-smile\";}s:7:\"version\";s:6:\"5.15.3\";}s:17:\"fas-chevron-right\";a:2:{s:7:\"content\";a:4:{s:5:\"width\";i:320;s:6:\"height\";i:512;s:4:\"path\";s:281:\"M285.476 272.971L91.132 467.314c-9.373 9.373-24.569 9.373-33.941 0l-22.667-22.667c-9.357-9.357-9.375-24.522-.04-33.901L188.505 256 34.484 101.255c-9.335-9.379-9.317-24.544.04-33.901l22.667-22.667c9.373-9.373 24.569-9.373 33.941 0L285.475 239.03c9.373 9.372 9.373 24.568.001 33.941z\";s:3:\"key\";s:17:\"fas-chevron-right\";}s:7:\"version\";s:6:\"5.15.3\";}s:12:\"far-file-alt\";a:2:{s:7:\"content\";a:4:{s:5:\"width\";i:384;s:6:\"height\";i:512;s:4:\"path\";s:430:\"M288 248v28c0 6.6-5.4 12-12 12H108c-6.6 0-12-5.4-12-12v-28c0-6.6 5.4-12 12-12h168c6.6 0 12 5.4 12 12zm-12 72H108c-6.6 0-12 5.4-12 12v28c0 6.6 5.4 12 12 12h168c6.6 0 12-5.4 12-12v-28c0-6.6-5.4-12-12-12zm108-188.1V464c0 26.5-21.5 48-48 48H48c-26.5 0-48-21.5-48-48V48C0 21.5 21.5 0 48 0h204.1C264.8 0 277 5.1 286 14.1L369.9 98c9 8.9 14.1 21.2 14.1 33.9zm-128-80V128h76.1L256 51.9zM336 464V176H232c-13.3 0-24-10.7-24-24V48H48v416h288z\";s:3:\"key\";s:12:\"far-file-alt\";}s:7:\"version\";s:6:\"5.15.3\";}s:17:\"far-envelope-open\";a:2:{s:7:\"content\";a:4:{s:5:\"width\";i:512;s:6:\"height\";i:512;s:4:\"path\";s:1063:\"M494.586 164.516c-4.697-3.883-111.723-89.95-135.251-108.657C337.231 38.191 299.437 0 256 0c-43.205 0-80.636 37.717-103.335 55.859-24.463 19.45-131.07 105.195-135.15 108.549A48.004 48.004 0 0 0 0 201.485V464c0 26.51 21.49 48 48 48h416c26.51 0 48-21.49 48-48V201.509a48 48 0 0 0-17.414-36.993zM464 458a6 6 0 0 1-6 6H54a6 6 0 0 1-6-6V204.347c0-1.813.816-3.526 2.226-4.665 15.87-12.814 108.793-87.554 132.364-106.293C200.755 78.88 232.398 48 256 48c23.693 0 55.857 31.369 73.41 45.389 23.573 18.741 116.503 93.493 132.366 106.316a5.99 5.99 0 0 1 2.224 4.663V458zm-31.991-187.704c4.249 5.159 3.465 12.795-1.745 16.981-28.975 23.283-59.274 47.597-70.929 56.863C336.636 362.283 299.205 400 256 400c-43.452 0-81.287-38.237-103.335-55.86-11.279-8.967-41.744-33.413-70.927-56.865-5.21-4.187-5.993-11.822-1.745-16.981l15.258-18.528c4.178-5.073 11.657-5.843 16.779-1.726 28.618 23.001 58.566 47.035 70.56 56.571C200.143 320.631 232.307 352 256 352c23.602 0 55.246-30.88 73.41-45.389 11.994-9.535 41.944-33.57 70.563-56.568 5.122-4.116 12.601-3.346 16.778 1.727l15.258 18.526z\";s:3:\"key\";s:17:\"far-envelope-open\";}s:7:\"version\";s:6:\"5.15.3\";}s:13:\"fas-phone-alt\";a:2:{s:7:\"content\";a:4:{s:5:\"width\";i:512;s:6:\"height\";i:512;s:4:\"path\";s:264:\"M497.39 361.8l-112-48a24 24 0 0 0-28 6.9l-49.6 60.6A370.66 370.66 0 0 1 130.6 204.11l60.6-49.6a23.94 23.94 0 0 0 6.9-28l-48-112A24.16 24.16 0 0 0 122.6.61l-104 24A24 24 0 0 0 0 48c0 256.5 207.9 464 464 464a24 24 0 0 0 23.4-18.6l24-104a24.29 24.29 0 0 0-14.01-27.6z\";s:3:\"key\";s:13:\"fas-phone-alt\";}s:7:\"version\";s:6:\"5.15.3\";}s:14:\"fab-facebook-f\";a:2:{s:7:\"content\";a:4:{s:5:\"width\";i:320;s:6:\"height\";i:512;s:4:\"path\";s:172:\"M279.14 288l14.22-92.66h-88.91v-60.13c0-25.35 12.42-50.06 52.24-50.06h40.42V6.26S260.43 0 225.36 0c-73.22 0-121.08 44.38-121.08 124.72v70.62H22.89V288h81.39v224h100.17V288z\";s:3:\"key\";s:14:\"fab-facebook-f\";}s:7:\"version\";s:6:\"5.15.3\";}s:13:\"fab-instagram\";a:2:{s:7:\"content\";a:4:{s:5:\"width\";i:448;s:6:\"height\";i:512;s:4:\"path\";s:922:\"M224.1 141c-63.6 0-114.9 51.3-114.9 114.9s51.3 114.9 114.9 114.9S339 319.5 339 255.9 287.7 141 224.1 141zm0 189.6c-41.1 0-74.7-33.5-74.7-74.7s33.5-74.7 74.7-74.7 74.7 33.5 74.7 74.7-33.6 74.7-74.7 74.7zm146.4-194.3c0 14.9-12 26.8-26.8 26.8-14.9 0-26.8-12-26.8-26.8s12-26.8 26.8-26.8 26.8 12 26.8 26.8zm76.1 27.2c-1.7-35.9-9.9-67.7-36.2-93.9-26.2-26.2-58-34.4-93.9-36.2-37-2.1-147.9-2.1-184.9 0-35.8 1.7-67.6 9.9-93.9 36.1s-34.4 58-36.2 93.9c-2.1 37-2.1 147.9 0 184.9 1.7 35.9 9.9 67.7 36.2 93.9s58 34.4 93.9 36.2c37 2.1 147.9 2.1 184.9 0 35.9-1.7 67.7-9.9 93.9-36.2 26.2-26.2 34.4-58 36.2-93.9 2.1-37 2.1-147.8 0-184.8zM398.8 388c-7.8 19.6-22.9 34.7-42.6 42.6-29.5 11.7-99.5 9-132.1 9s-102.7 2.6-132.1-9c-19.6-7.8-34.7-22.9-42.6-42.6-11.7-29.5-9-99.5-9-132.1s-2.6-102.7 9-132.1c7.8-19.6 22.9-34.7 42.6-42.6 29.5-11.7 99.5-9 132.1-9s102.7-2.6 132.1 9c19.6 7.8 34.7 22.9 42.6 42.6 11.7 29.5 9 99.5 9 132.1s2.7 102.7-9 132.1z\";s:3:\"key\";s:13:\"fab-instagram\";}s:7:\"version\";s:6:\"5.15.3\";}s:11:\"fab-twitter\";a:2:{s:7:\"content\";a:4:{s:5:\"width\";i:512;s:6:\"height\";i:512;s:4:\"path\";s:791:\"M459.37 151.716c.325 4.548.325 9.097.325 13.645 0 138.72-105.583 298.558-298.558 298.558-59.452 0-114.68-17.219-161.137-47.106 8.447.974 16.568 1.299 25.34 1.299 49.055 0 94.213-16.568 130.274-44.832-46.132-.975-84.792-31.188-98.112-72.772 6.498.974 12.995 1.624 19.818 1.624 9.421 0 18.843-1.3 27.614-3.573-48.081-9.747-84.143-51.98-84.143-102.985v-1.299c13.969 7.797 30.214 12.67 47.431 13.319-28.264-18.843-46.781-51.005-46.781-87.391 0-19.492 5.197-37.36 14.294-52.954 51.655 63.675 129.3 105.258 216.365 109.807-1.624-7.797-2.599-15.918-2.599-24.04 0-57.828 46.782-104.934 104.934-104.934 30.213 0 57.502 12.67 76.67 33.137 23.715-4.548 46.456-13.32 66.599-25.34-7.798 24.366-24.366 44.833-46.132 57.827 21.117-2.273 41.584-8.122 60.426-16.243-14.292 20.791-32.161 39.308-52.628 54.253z\";s:3:\"key\";s:11:\"fab-twitter\";}s:7:\"version\";s:6:\"5.15.3\";}s:11:\"fab-youtube\";a:2:{s:7:\"content\";a:4:{s:5:\"width\";i:576;s:6:\"height\";i:512;s:4:\"path\";s:470:\"M549.655 124.083c-6.281-23.65-24.787-42.276-48.284-48.597C458.781 64 288 64 288 64S117.22 64 74.629 75.486c-23.497 6.322-42.003 24.947-48.284 48.597-11.412 42.867-11.412 132.305-11.412 132.305s0 89.438 11.412 132.305c6.281 23.65 24.787 41.5 48.284 47.821C117.22 448 288 448 288 448s170.78 0 213.371-11.486c23.497-6.321 42.003-24.171 48.284-47.821 11.412-42.867 11.412-132.305 11.412-132.305s0-89.438-11.412-132.305zm-317.51 213.508V175.185l142.739 81.205-142.739 81.201z\";s:3:\"key\";s:11:\"fab-youtube\";}s:7:\"version\";s:6:\"5.15.3\";}s:10:\"fas-search\";a:2:{s:7:\"content\";a:4:{s:5:\"width\";i:512;s:6:\"height\";i:512;s:4:\"path\";s:345:\"M505 442.7L405.3 343c-4.5-4.5-10.6-7-17-7H372c27.6-35.3 44-79.7 44-128C416 93.1 322.9 0 208 0S0 93.1 0 208s93.1 208 208 208c48.3 0 92.7-16.4 128-44v16.3c0 6.4 2.5 12.5 7 17l99.7 99.7c9.4 9.4 24.6 9.4 33.9 0l28.3-28.3c9.4-9.4 9.4-24.6.1-34zM208 336c-70.7 0-128-57.2-128-128 0-70.7 57.2-128 128-128 70.7 0 128 57.2 128 128 0 70.7-57.2 128-128 128z\";s:3:\"key\";s:10:\"fas-search\";}s:7:\"version\";s:6:\"5.15.3\";}s:16:\"far-check-circle\";a:2:{s:7:\"content\";a:4:{s:5:\"width\";i:512;s:6:\"height\";i:512;s:4:\"path\";s:501:\"M256 8C119.033 8 8 119.033 8 256s111.033 248 248 248 248-111.033 248-248S392.967 8 256 8zm0 48c110.532 0 200 89.451 200 200 0 110.532-89.451 200-200 200-110.532 0-200-89.451-200-200 0-110.532 89.451-200 200-200m140.204 130.267l-22.536-22.718c-4.667-4.705-12.265-4.736-16.97-.068L215.346 303.697l-59.792-60.277c-4.667-4.705-12.265-4.736-16.97-.069l-22.719 22.536c-4.705 4.667-4.736 12.265-.068 16.971l90.781 91.516c4.667 4.705 12.265 4.736 16.97.068l172.589-171.204c4.704-4.668 4.734-12.266.067-16.971z\";s:3:\"key\";s:16:\"far-check-circle\";}s:7:\"version\";s:6:\"5.15.3\";}s:15:\"fab-linkedin-in\";a:2:{s:7:\"content\";a:4:{s:5:\"width\";i:448;s:6:\"height\";i:512;s:4:\"path\";s:300:\"M100.28 448H7.4V148.9h92.88zM53.79 108.1C24.09 108.1 0 83.5 0 53.8a53.79 53.79 0 0 1 107.58 0c0 29.7-24.1 54.3-53.79 54.3zM447.9 448h-92.68V302.4c0-34.7-.7-79.2-48.29-79.2-48.29 0-55.69 37.7-55.69 76.7V448h-92.78V148.9h89.08v40.8h1.3c12.4-23.5 42.69-48.3 87.88-48.3 94 0 111.28 61.9 111.28 142.3V448z\";s:3:\"key\";s:15:\"fab-linkedin-in\";}s:7:\"version\";s:6:\"5.15.3\";}s:12:\"fas-envelope\";a:2:{s:7:\"content\";a:4:{s:5:\"width\";i:512;s:6:\"height\";i:512;s:4:\"path\";s:464:\"M502.3 190.8c3.9-3.1 9.7-.2 9.7 4.7V400c0 26.5-21.5 48-48 48H48c-26.5 0-48-21.5-48-48V195.6c0-5 5.7-7.8 9.7-4.7 22.4 17.4 52.1 39.5 154.1 113.6 21.1 15.4 56.7 47.8 92.2 47.6 35.7.3 72-32.8 92.3-47.6 102-74.1 131.6-96.3 154-113.7zM256 320c23.2.4 56.6-29.2 73.4-41.4 132.7-96.3 142.8-104.7 173.4-128.7 5.8-4.5 9.2-11.5 9.2-18.9v-19c0-26.5-21.5-48-48-48H48C21.5 64 0 85.5 0 112v19c0 7.4 3.4 14.3 9.2 18.9 30.6 23.9 40.7 32.4 173.4 128.7 16.8 12.2 50.2 41.8 73.4 41.4z\";s:3:\"key\";s:12:\"fas-envelope\";}s:7:\"version\";s:6:\"5.15.3\";}s:12:\"fab-facebook\";a:2:{s:7:\"content\";a:4:{s:5:\"width\";i:512;s:6:\"height\";i:512;s:4:\"path\";s:264:\"M504 256C504 119 393 8 256 8S8 119 8 256c0 123.78 90.69 226.38 209.25 245V327.69h-63V256h63v-54.64c0-62.15 37-96.48 93.67-96.48 27.14 0 55.52 4.84 55.52 4.84v61h-31.28c-30.8 0-40.41 19.12-40.41 38.73V256h68.78l-11 71.69h-57.78V501C413.31 482.38 504 379.78 504 256z\";s:3:\"key\";s:12:\"fab-facebook\";}s:7:\"version\";s:6:\"5.15.3\";}s:13:\"fab-pinterest\";a:2:{s:7:\"content\";a:4:{s:5:\"width\";i:496;s:6:\"height\";i:512;s:4:\"path\";s:666:\"M496 256c0 137-111 248-248 248-25.6 0-50.2-3.9-73.4-11.1 10.1-16.5 25.2-43.5 30.8-65 3-11.6 15.4-59 15.4-59 8.1 15.4 31.7 28.5 56.8 28.5 74.8 0 128.7-68.8 128.7-154.3 0-81.9-66.9-143.2-152.9-143.2-107 0-163.9 71.8-163.9 150.1 0 36.4 19.4 81.7 50.3 96.1 4.7 2.2 7.2 1.2 8.3-3.3.8-3.4 5-20.3 6.9-28.1.6-2.5.3-4.7-1.7-7.1-10.1-12.5-18.3-35.3-18.3-56.6 0-54.7 41.4-107.6 112-107.6 60.9 0 103.6 41.5 103.6 100.9 0 67.1-33.9 113.6-78 113.6-24.3 0-42.6-20.1-36.7-44.8 7-29.5 20.5-61.3 20.5-82.6 0-19-10.2-34.9-31.4-34.9-24.9 0-44.9 25.7-44.9 60.2 0 22 7.4 36.8 7.4 36.8s-24.5 103.8-29 123.2c-5 21.4-3 51.6-.9 71.2C65.4 450.9 0 361.1 0 256 0 119 111 8 248 8s248 111 248 248z\";s:3:\"key\";s:13:\"fab-pinterest\";}s:7:\"version\";s:6:\"5.15.3\";}s:12:\"fab-linkedin\";a:2:{s:7:\"content\";a:4:{s:5:\"width\";i:448;s:6:\"height\";i:512;s:4:\"path\";s:424:\"M416 32H31.9C14.3 32 0 46.5 0 64.3v383.4C0 465.5 14.3 480 31.9 480H416c17.6 0 32-14.5 32-32.3V64.3c0-17.8-14.4-32.3-32-32.3zM135.4 416H69V202.2h66.5V416zm-33.2-243c-21.3 0-38.5-17.3-38.5-38.5S80.9 96 102.2 96c21.2 0 38.5 17.3 38.5 38.5 0 21.3-17.2 38.5-38.5 38.5zm282.1 243h-66.4V312c0-24.8-.5-56.7-34.5-56.7-34.6 0-39.9 27-39.9 54.9V416h-66.4V202.2h63.7v29.2h.9c8.9-16.8 30.6-34.5 62.9-34.5 67.2 0 79.7 44.3 79.7 101.9V416z\";s:3:\"key\";s:12:\"fab-linkedin\";}s:7:\"version\";s:6:\"5.15.3\";}s:15:\"far-user-circle\";a:2:{s:7:\"content\";a:4:{s:5:\"width\";i:496;s:6:\"height\";i:512;s:4:\"path\";s:585:\"M248 104c-53 0-96 43-96 96s43 96 96 96 96-43 96-96-43-96-96-96zm0 144c-26.5 0-48-21.5-48-48s21.5-48 48-48 48 21.5 48 48-21.5 48-48 48zm0-240C111 8 0 119 0 256s111 248 248 248 248-111 248-248S385 8 248 8zm0 448c-49.7 0-95.1-18.3-130.1-48.4 14.9-23 40.4-38.6 69.6-39.5 20.8 6.4 40.6 9.6 60.5 9.6s39.7-3.1 60.5-9.6c29.2 1 54.7 16.5 69.6 39.5-35 30.1-80.4 48.4-130.1 48.4zm162.7-84.1c-24.4-31.4-62.1-51.9-105.1-51.9-10.2 0-26 9.6-57.6 9.6-31.5 0-47.4-9.6-57.6-9.6-42.9 0-80.6 20.5-105.1 51.9C61.9 339.2 48 299.2 48 256c0-110.3 89.7-200 200-200s200 89.7 200 200c0 43.2-13.9 83.2-37.3 115.9z\";s:3:\"key\";s:15:\"far-user-circle\";}s:7:\"version\";s:6:\"5.15.3\";}s:12:\"fas-calendar\";a:2:{s:7:\"content\";a:4:{s:5:\"width\";i:448;s:6:\"height\";i:512;s:4:\"path\";s:312:\"M12 192h424c6.6 0 12 5.4 12 12v260c0 26.5-21.5 48-48 48H48c-26.5 0-48-21.5-48-48V204c0-6.6 5.4-12 12-12zm436-44v-36c0-26.5-21.5-48-48-48h-48V12c0-6.6-5.4-12-12-12h-40c-6.6 0-12 5.4-12 12v52H160V12c0-6.6-5.4-12-12-12h-40c-6.6 0-12 5.4-12 12v52H48C21.5 64 0 85.5 0 112v36c0 6.6 5.4 12 12 12h424c6.6 0 12-5.4 12-12z\";s:3:\"key\";s:12:\"fas-calendar\";}s:7:\"version\";s:6:\"5.15.3\";}s:11:\"fas-hashtag\";a:2:{s:7:\"content\";a:4:{s:5:\"width\";i:448;s:6:\"height\";i:512;s:4:\"path\";s:831:\"M440.667 182.109l7.143-40c1.313-7.355-4.342-14.109-11.813-14.109h-74.81l14.623-81.891C377.123 38.754 371.468 32 363.997 32h-40.632a12 12 0 0 0-11.813 9.891L296.175 128H197.54l14.623-81.891C213.477 38.754 207.822 32 200.35 32h-40.632a12 12 0 0 0-11.813 9.891L132.528 128H53.432a12 12 0 0 0-11.813 9.891l-7.143 40C33.163 185.246 38.818 192 46.289 192h74.81L98.242 320H19.146a12 12 0 0 0-11.813 9.891l-7.143 40C-1.123 377.246 4.532 384 12.003 384h74.81L72.19 465.891C70.877 473.246 76.532 480 84.003 480h40.632a12 12 0 0 0 11.813-9.891L151.826 384h98.634l-14.623 81.891C234.523 473.246 240.178 480 247.65 480h40.632a12 12 0 0 0 11.813-9.891L315.472 384h79.096a12 12 0 0 0 11.813-9.891l7.143-40c1.313-7.355-4.342-14.109-11.813-14.109h-74.81l22.857-128h79.096a12 12 0 0 0 11.813-9.891zM261.889 320h-98.634l22.857-128h98.634l-22.857 128z\";s:3:\"key\";s:11:\"fas-hashtag\";}s:7:\"version\";s:6:\"5.15.3\";}}}}","auto");

INSERT IGNORE INTO `wp_options` VALUES 
("2345","_site_transient_update_themes","O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1768448312;s:7:\"checked\";a:2:{s:15:\"hello-elementor\";s:5:\"3.4.5\";s:16:\"twentytwentyfive\";s:3:\"1.4\";}s:8:\"response\";a:0:{}s:9:\"no_update\";a:2:{s:15:\"hello-elementor\";a:6:{s:5:\"theme\";s:15:\"hello-elementor\";s:11:\"new_version\";s:5:\"3.4.5\";s:3:\"url\";s:45:\"https://wordpress.org/themes/hello-elementor/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/theme/hello-elementor.3.4.5.zip\";s:8:\"requires\";s:3:\"6.0\";s:12:\"requires_php\";s:3:\"7.4\";}s:16:\"twentytwentyfive\";a:6:{s:5:\"theme\";s:16:\"twentytwentyfive\";s:11:\"new_version\";s:3:\"1.4\";s:3:\"url\";s:46:\"https://wordpress.org/themes/twentytwentyfive/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/theme/twentytwentyfive.1.4.zip\";s:8:\"requires\";s:3:\"6.7\";s:12:\"requires_php\";s:3:\"7.2\";}}s:12:\"translations\";a:0:{}}","off"),
("2347","elementor_pro_remote_info_api_data_3.30.1","a:2:{s:7:\"timeout\";i:1766467682;s:5:\"value\";s:250680:\"{\"stable_version\":\"3.34.0\",\"last_updated\":\"2025-12-22 12:50:17\",\"sections\":\"a:2:{s:11:\\\"description\\\";s:161:\\\"Elementor Pro adds new features to the Elementor Page Builder plugin. Control your conversions, your user engagement, your entire website, from one page builder.\\\";s:9:\\\"changelog\\\";s:234725:\\\"<h2>Elementor Pro - by Elementor.com<\\/h2>\\n<h4>3.34.0 - 2025-12-22<\\/h4>\\n<ul>\\n<li>New: Added support for Display Conditions for Atomic Elements - Editor V4<\\/li>\\n<li>Tweak: Enabled media queries for the Desktop breakpoint only in Custom CSS - Editor V4<\\/li>\\n<li>Tweak: Added support for ACF field in Dynamic Tags - Editor V4<\\/li>\\n<li>Tweak: Added support for Google Calendar in Contact URL Dynamic Tag - Editor V4<\\/li>\\n<li>Tweak: Added support for Tel link in Contact URL Dynamic Tag - Editor V4<\\/li>\\n<li>Tweak: Added support for ACF Image field in Dynamic Tags - Editor V4<\\/li>\\n<li>Tweak: Removed icon from the accessibility tree in Flip Box widget<\\/li>\\n<li>Tweak: Applied CSS logical properties in text-align controls and improved RTL rendering in the Editor<\\/li>\\n<li>Fix: Website Template library displayed in English instead of the translated language<\\/li>\\n<li>Fix: Custom CSS field breaks when using certain characters - Editor V4<\\/li>\\n<\\/ul>\\n<h4>3.33.2 - 2025-12-03<\\/h4>\\n<ul>\\n<li>Fix: Incorrect status shown for Custom Code, Fonts, and Icons after importing a Website Template<\\/li>\\n<li>Fix: Display Conditions window appears empty in the editor<\\/li>\\n<\\/ul>\\n<h4>3.33.1 - 2025-11-11<\\/h4>\\n<ul>\\n<li>Fix: Styles not loading correctly in Custom Fonts and Custom Icons admin screens (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/33396\\\">#33396<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.33.0 - 2025-11-10<\\/h4>\\n<ul>\\n<li>New: Introducing Custom CSS for element-level styling with full isolation and responsive control - Editor V4<\\/li>\\n<li>New: Introducing media save to cloud in Website Templates, enabling users to store media assets directly in the cloud for easier access and management.<\\/li>\\n<li>Tweak: Added support for Post Excerpt dynamic tag - Editor V4<\\/li>\\n<li>Tweak: Added support for Internal URL dynamic tag - Editor V4<\\/li>\\n<li>Tweak: Added support for Post Terms dynamic tag - Editor V4<\\/li>\\n<li>Tweak: Added support for Shortcode dynamic tag - Editor V4<\\/li>\\n<li>Tweak: Added support for Popup dynamic tag - Editor V4<\\/li>\\n<li>Tweak: Added support for Off-Canvas dynamic tag - Editor V4<\\/li>\\n<li>Tweak: Added support for Lightbox dynamic tag - Editor V4<\\/li>\\n<li>Tweak: Added support for Add To Cart dynamic tag - Editor V4<\\/li>\\n<li>Tweak: Added support for ACF URL dynamic tag - Editor V4<\\/li>\\n<li>Tweak: Added support for Archive Title dynamic tag - Editor V4<\\/li>\\n<li>Tweak: Added support for the Email Contact URL dynamic tag - Editor V4<\\/li>\\n<li>Tweak: Added support for reduced-motion preferences in Flip Box widget<\\/li>\\n<li>Tweak: Updated minimum supported versions for Chrome, Firefox, and Safari<\\/li>\\n<li>Tweak: Updated Notes button location in the Editor Top Bar<\\/li>\\n<\\/ul>\\n<h4>3.32.3 - 2025-10-21<\\/h4>\\n<ul>\\n<li>Fix: Website Template fails to apply when Custom Code or Custom Icons are included<\\/li>\\n<\\/ul>\\n<h4>3.32.2 - 2025-09-29<\\/h4>\\n<ul>\\n<li>Fix: Exported taxonomies are not displayed correctly on the summary page in Website Templates export<\\/li>\\n<li>Fix: Certain taxonomies are not exported as expected in Website Templates export<\\/li>\\n<\\/ul>\\n<h4>3.32.1 - 2025-09-16<\\/h4>\\n<ul>\\n<li>Fix: Theme Builder fails to load when containers are disabled<\\/li>\\n<li>Fix: Popup and single product templates not imported or exported as expected<\\/li>\\n<\\/ul>\\n<h4>3.32.0 - 2025-09-15<\\/h4>\\n<ul>\\n<li>New: Introducing Size Variables to store and reuse numeric values across spacing, typography, layout, and borders - Editor V4<\\/li>\\n<li>New: Introducing granular Transitions with property-level control for advanced micro-animations - Editor V4<\\/li>\\n<li>New: Added granular content selection for Website Templates import and export, including pages, menus, post types, and taxonomies<\\/li>\\n<li>Tweak: Enhanced accessibility of background images in Slides widget with proper aria attributes (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23543\\\">#23543<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/31063\\\">#31063<\\/a>)<\\/li>\\n<li>Tweak: Added REST API support for the Custom Code feature<\\/li>\\n<li>Tweak: Moved Background control from Content tab to Style tab in Flip Box widget<\\/li>\\n<li>Tweak: Removed SVG icons from the accessibility tree in Share Buttons widget<\\/li>\\n<li>Tweak: Removed dropdown indicator icons from the accessibility tree in WordPress Menu widget<\\/li>\\n<li>Fix: PHP 8.4 deprecation notices when running with <code>WP_DEBUG<\\/code> enabled<\\/li>\\n<li>Fix: Reduced-motion preferences are not applied to Animated Headline widget<\\/li>\\n<li>Fix: Reduced-motion preferences are not applied in Motion Effects<\\/li>\\n<li>Fix: Added required PHP and WordPress versions to the plugin header<\\/li>\\n<\\/ul>\\n<h4>3.31.3 - 2025-09-08<\\/h4>\\n<ul>\\n<li>Security Fix: Improved code security enforcement in WordPress Menu widget<\\/li>\\n<\\/ul>\\n<h4>3.31.2 - 2025-08-10<\\/h4>\\n<ul>\\n<li>Tweak: Improved release version functionality<\\/li>\\n<\\/ul>\\n<h4>3.31.1 - 2025-08-06<\\/h4>\\n<ul>\\n<li>Tweak: Updated <code>form-data<\\/code> package version<\\/li>\\n<\\/ul>\\n<h4>3.31.0 - 2025-08-05<\\/h4>\\n<ul>\\n<li>New: Introducing Attributes - add custom HTML attributes to elements for advanced control - Editor V4<\\/li>\\n<li>Tweak: Optimized Custom Code styles by removing redundant RTL file<\\/li>\\n<li>Tweak: Improved performance by loading ribbon styles only when used in Call to Action and Price Table widgets<\\/li>\\n<li>Tweak: Improved semantic markup structure for header and footer documents<\\/li>\\n<li>Tweak: Reorganized design controls in Animated Headline widget<\\/li>\\n<li>Tweak: Reorganized design controls in Blockquote widget<\\/li>\\n<li>Tweak: Reorganized design controls in Countdown widget<\\/li>\\n<li>Tweak: Replaced SASS mixins and functions with native CSS logical properties<\\/li>\\n<li>Fix: Empty headers are rendered in Table of Contents widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/28167\\\">#28167<\\/a>)<\\/li>\\n<li>Fix: <code>TypeError<\\/code> bug in Menu widget<\\/li>\\n<\\/ul>\\n<h4>3.30.1 - 2025-07-22<\\/h4>\\n<ul>\\n<li>Security Fix: Improved content sanitization in multiple widgets<\\/li>\\n<li>Fix: UI issue in Hotspot widget when Optimized Markup experiment is enabled<\\/li>\\n<li>Fix: Taxonomy filter not working in the Editor when Optimized Markup experiment is enabled<\\/li>\\n<\\/ul>\\n<h4>3.30.0 - 2025-07-01<\\/h4>\\n<ul>\\n<li>New: Introduced Full Website Templates in the Cloud - export, manage, and reuse full site kits across all your websites from one place<\\/li>\\n<li>Tweak: Activated &quot;Optimized Markup&quot; feature on new sites<\\/li>\\n<li>Tweak: Activated &quot;Menu&quot; feature on new sites<\\/li>\\n<li>Tweak: Improved error handling for Theme Builder display conditions<\\/li>\\n<li>Tweak: Added styling controls to Post Excerpt widget<\\/li>\\n<li>Tweak: Improved accessibility with <code>role<\\/code> and <code>aria-label<\\/code> attributes Post Navigation widget<\\/li>\\n<li>Tweak: Added <code>aria-label<\\/code> in Form widget<\\/li>\\n<li>Tweak: Added <code>aria-label<\\/code> in Login widget<\\/li>\\n<li>Tweak: Arranged content as lists in Portfolio and Posts widgets<\\/li>\\n<li>Tweak: Added Box Shadow and Text Shadow controls in Countdown widget<\\/li>\\n<li>Tweak: Moved image resolution control to content tab in Price List widget<\\/li>\\n<li>Tweak: Renamed and reorganized style sections in Price List widget<\\/li>\\n<li>Tweak: Added conditional logic to controls in Price Table widget<\\/li>\\n<li>Tweak: Grouped layout controls under list section in Price List widget<\\/li>\\n<li>Tweak: Updated minimum required WordPress version to 6.6<\\/li>\\n<li>Fix: Inline font icons support doesn\'t work in Post Navigation widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/24367\\\">#24367<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18343\\\">#18343<\\/a>)<\\/li>\\n<li>Fix: Page Title condition doesn\'t work on child pages in Widget Display Conditions<\\/li>\\n<li>Fix: Editor users with &quot;Access to edit content only&quot; are able to delete elements<\\/li>\\n<li>Fix: Links are not crawlable in Video Playlist widget<\\/li>\\n<li>Fix: Uses hardcoded admin fonts in Video Playlist widget<\\/li>\\n<li>Fix: Editor freezes when the Form widget is used with a high PHP upload size limit<\\/li>\\n<li>Fix: Errors occur when Debug mode is enabled in Slides widget<\\/li>\\n<li>Fix: Plugin dependency not enforced in Elementor Pro<\\/li>\\n<li>Fix: Console shows deprecation warning in Global Widgets<\\/li>\\n<\\/ul>\\n<h4>3.29.2 - 2025-06-04<\\/h4>\\n<ul>\\n<li>Tweak: Added selectors to Menu widget for compatibility with Optimized Markup experiment<\\/li>\\n<\\/ul>\\n<h4>3.29.1 - 2025-05-28<\\/h4>\\n<ul>\\n<li>Security Fix: Improved code security enforcement in Animated Headline widget<\\/li>\\n<li>Security Fix: Improved code security enforcement in Price Table widget<\\/li>\\n<\\/ul>\\n<h4>3.29.0 - 2025-05-19<\\/h4>\\n<ul>\\n<li>New: Introduced Cloud Templates - save, manage, and reuse your templates across all your sites from a single cloud library<\\/li>\\n<li>Tweak: Improved accessibility with <code>role<\\/code> attributes in Share Buttons widget<\\/li>\\n<li>Tweak: Improved accessibility by grouping content with <code>role=region<\\/code> in the Video Playlist widget<\\/li>\\n<li>Fix: Focus color is not applied correctly for accessibility in WordPress Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/24239\\\">#24239<\\/a>)<\\/li>\\n<li>Fix: Common scripts loaded late when using the Theme Builder<\\/li>\\n<\\/ul>\\n<h4>3.28.4 - 2025-05-05<\\/h4>\\n<ul>\\n<li>Fix: Empty results appeared on the frontend when using the Taxonomy Filter with the \'Avoid Duplicates\' option in Loop Grid widget<\\/li>\\n<li>Fix: Errors occur when Debug mode is enabled and the Optimized Markup experiment is active<\\/li>\\n<\\/ul>\\n<h4>3.28.3 - 2025-04-16<\\/h4>\\n<ul>\\n<li>Tweak: Improved sidebar navigation flow on the Elementor Home screen<\\/li>\\n<\\/ul>\\n<h4>3.28.2 - 2025-03-30<\\/h4>\\n<ul>\\n<li>Fix: Default Elementor animation shown for logged-out users when using an &quot;External URL&quot; source in Lottie widget<\\/li>\\n<\\/ul>\\n<h4>3.28.1 - 2025-03-23<\\/h4>\\n<ul>\\n<li>Security Fix: Improved code security enforcement in Animated Headline and Form widgets<\\/li>\\n<\\/ul>\\n<h4>3.28.0 - 2025-03-17<\\/h4>\\n<ul>\\n<li>Tweak: Ensured File Upload field styles are overridden by global styles in Form widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11651\\\">#11651<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17223\\\">#17223<\\/a>)<\\/li>\\n<li>Tweak: Updated Scroll Snap description to clarify incompatibility with animations and motion effects<\\/li>\\n<li>Tweak: Prevented special characters from being encoded in the email subject field in Form widget<\\/li>\\n<li>Tweak: Loaded module styles within the module instead of registering them in <code>plugin.php<\\/code><\\/li>\\n<li>Tweak: Updated minimum required WordPress version to 6.5<\\/li>\\n<li>Tweak: Improved keyboard accessibility for menus in Editor Top Bar<\\/li>\\n<li>Tweak: Made the edit button accessible in the Template widget<\\/li>\\n<li>Tweak: Optimized Form widget performance by caching field assets <code>using get_style_depends()<\\/code> and <code>get_script_depends()<\\/code> methods<\\/li>\\n<li>Tweak: Added Text Shadow control in Testimonial Carousel, Call to Action and Animated Headline widgets<\\/li>\\n<li>Fix: Button icon alignment breaks when Inline Font Icons feature is activated (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16077\\\">#16077<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16511\\\">#16511<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17692\\\">#17692<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17922\\\">#17922<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19253\\\">#19253<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19370\\\">#19370<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21236\\\">#21236<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21844\\\">#21844<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/28080\\\">#28080<\\/a>)<\\/li>\\n<li>Fix: Dropdown caret color did not follow menu item color when Inline Font Icons feature is activated (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17500\\\">#17500<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18466\\\">#18466<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21664\\\">#21664<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/24929\\\">#24929<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/28064\\\">#28064<\\/a>)<\\/li>\\n<li>Fix: Page doesn\'t scroll up when a coupon error notice appears in Checkout widget<\\/li>\\n<\\/ul>\\n<h4>3.27.7 - 2025-03-13<\\/h4>\\n<ul>\\n<li>Security Fix: Improved code security enforcement in Lottie widget<\\/li>\\n<\\/ul>\\n<h4>3.27.6 - 2025-03-10<\\/h4>\\n<ul>\\n<li>Security Fix: Improved code security enforcement in Template Condition<\\/li>\\n<\\/ul>\\n<h4>3.27.5 - 2025-03-03<\\/h4>\\n<ul>\\n<li>Fix: The <code>wp_trigger_error<\\/code> function causes the site to crash instead of triggering a warning when used with ACF text<\\/li>\\n<\\/ul>\\n<h4>3.27.4 - 2025-02-16<\\/h4>\\n<ul>\\n<li>Security Fix: Improved code security enforcement in Screenshots module<\\/li>\\n<li>Security Fix: Improved code security enforcement in Query control<\\/li>\\n<li>Fix: ACF <code>true_false<\\/code> field causing a fatal error when used as a dynamic tag with third-party plugins (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/30170\\\">#30170<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.27.3 - 2025-02-06<\\/h4>\\n<ul>\\n<li>Security Fix: Improved code security enforcement in Stripe Button widget<\\/li>\\n<\\/ul>\\n<h4>3.27.2 - 2025-02-03<\\/h4>\\n<ul>\\n<li>Fix: Value type configuration issue causing errors when using ACF<\\/li>\\n<li>Fix: Hide content on responsive breakpoint option is not working on WordPress Menu widget when Optimized Markup experiment is activated<\\/li>\\n<\\/ul>\\n<h4>3.27.1 - 2025-01-27<\\/h4>\\n<ul>\\n<li>Tweak: Increased the number of items allowed in Dynamic Tags options in Display Conditions for Elements<\\/li>\\n<li>Security Fix: Improved code security enforcement in Global widget<\\/li>\\n<li>Security Fix: Improved code security enforcement in Lottie widget<\\/li>\\n<li>Security Fix: Improved code security enforcement in Admin settings<\\/li>\\n<li>Fix: Accessible navigation in popups caused unintended scrolling of the page when triggered (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/29175\\\">#29175<\\/a>)<\\/li>\\n<li>Fix: Empty custom fields are missing in the Dynamic Tags options in Display Conditions for Elements<\\/li>\\n<\\/ul>\\n<h4>3.27.0 - 2025-01-20<\\/h4>\\n<ul>\\n<li>Tweak: Removed the <code>elementor-widget-container<\\/code> div from the Menu, Loop, Table of Contents, Form, and Hotspot widgets as part of the Optimized Markup experiment to improve HTML structure<\\/li>\\n<li>Tweak: Reduced DOM size by optimizing the submit button markup in Search widget<\\/li>\\n<li>Tweak: Moved style loading to the head instead of the footer to improve CLS<\\/li>\\n<li>Tweak: Enabled conditional loading of Swiper.js based on widget dependencies to reduce unnecessary assets and improve page load times<\\/li>\\n<li>Tweak: Standardized navigation elements like arrows and bullets across all carousel and slider widgets for improved accessibility<\\/li>\\n<li>Tweak: Improved accessibility when the submit button has only an icon and no text in Search widget<\\/li>\\n<li>Tweak: Removed <code>load_plugin_textdomain()<\\/code> function from Elementor Pro<\\/li>\\n<\\/ul>\\n<h4>3.26.3 - 2025-01-07<\\/h4>\\n<ul>\\n<li>Security Fix: Improved code security enforcement in Search widget<\\/li>\\n<li>Fix: Height issues cause slideshow thumbnails to display incorrectly in Media Carousel (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/29663\\\">#29663<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.26.2 - 2024-12-22<\\/h4>\\n<ul>\\n<li>Fix: Menu items are not clickable in various scenarios in Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/29191\\\">#29191<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.26.1 - 2024-12-17<\\/h4>\\n<ul>\\n<li>Fix: Restore deprecated <code>Plugin::enqueue_styles()<\\/code> function to avoid errors with 3rd party plugins<\\/li>\\n<\\/ul>\\n<h4>3.26.0 - 2024-12-16<\\/h4>\\n<ul>\\n<li>New: Introducing dynamic content support for Off-canvas in Loop Grid widget templates - enabling seamless display of additional content dynamically (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/29049\\\">#29049<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/28935\\\">#28935<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7106\\\">#7106<\\/a>)<\\/li>\\n<li>New: AdBlock Detection trigger for Popups - display targeted popups for visitors using ad blockers<\\/li>\\n<li>New: Added Reload Page link action for Dynamic Tags<\\/li>\\n<li>Tweak: Added &quot;Space Between Dots&quot; control to Carousel widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2526\\\">#2526<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3277\\\">#3277<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21697\\\">#21697<\\/a>)<\\/li>\\n<li>Tweak: Replaced hidden <code>elementor-screen-only<\\/code> div with <code>aria-label<\\/code> attributes<\\/li>\\n<li>Tweak: Removed <code>elementor-widget-container<\\/code> div from Elementor widgets as part of the Optimized Markup experiment<\\/li>\\n<li>Tweak: Optimize popup styling by loading it only when necessary<\\/li>\\n<li>Tweak: Updated Gap between slides control to support only PX units in Carousel widget<\\/li>\\n<li>Tweak: Removed the dependency between the Tabs handler and the Menu handler<\\/li>\\n<li>Tweak: Added the ability to set <code>aria-label<\\/code> in Carousel widgets<\\/li>\\n<li>Tweak: Added <code>aria-roledescription=carousel<\\/code> to carousel wrapper<\\/li>\\n<li>Tweak: Added <code>aria-roledescription=slide<\\/code> to slide wrapper<\\/li>\\n<li>Tweak: Optimized carousel widgets markup as part of the Optimized Markup experiment<\\/li>\\n<li>Tweak: Updated minimum required Safari version to 15.5<\\/li>\\n<li>Tweak: Facebook widgets are no longer supported on mobile due to Facebook functionality changes<\\/li>\\n<li>Fix: Motion Effects sticky feature is not working when Scroll Snap is enabled<\\/li>\\n<li>Fix: Custom Image Resolution option is not working in Gallery widget<\\/li>\\n<li>Fix: \'Reading Settings\' unexpectedly reduces the number of posts displayed when using the Archive with Pagination setting<\\/li>\\n<li>Fix: Step Form does not scroll to the top when the first field is not an input field in Form widget<\\/li>\\n<li>Fix: Display Condition feature is available without an active Elementor license in Floating Elements<\\/li>\\n<li>Fix: Background options of Flip Box in Loop Grid widget are not working when images are added using ACF Dynamic Tags<\\/li>\\n<li>Fix: Dropdown icon in the Select field of the Form widget is cut off when the Inline Font Icons feature is activated<\\/li>\\n<li>Fix: Incompatibility between Form widget and WPML when using Nested Elements<\\/li>\\n<li>Fix: Performance issues when changing the title name in the Menu widget<\\/li>\\n<li>Fix: Warnings appear when Element Caching is set to Inactive in Carousel widgets<\\/li>\\n<li>Fix: Swiper styling missing from Lightbox inside Gallery widgets<\\/li>\\n<\\/ul>\\n<h4>3.25.5 - 2024-12-10<\\/h4>\\n<ul>\\n<li>Security Fix: Improved code security enforcement in Form widget<\\/li>\\n<li>Fix: Accessible navigation in popups caused unintended scrolling of the page when triggered (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/29175\\\">#29175<\\/a>)<\\/li>\\n<li>Fix: Popup overlay shown for non-logged users even when disabled<\\/li>\\n<\\/ul>\\n<h4>3.25.4 - 2024-11-20<\\/h4>\\n<ul>\\n<li>Tweak: Improved Global Widget loading method to enhance performance<\\/li>\\n<\\/ul>\\n<h4>3.25.3 - 2024-11-13<\\/h4>\\n<ul>\\n<li>Fix: Nested Elements are activated even when the Container experiment is inactive<\\/li>\\n<\\/ul>\\n<h4>3.25.2 - 2024-11-03<\\/h4>\\n<ul>\\n<li>Fix: Styling issues affecting popup layout when using a Dynamic Tag to open the popup<\\/li>\\n<li>Fix: Image captions are not displaying for non-logged-in users in Media Carousel widget<\\/li>\\n<li>Fix: Custom Add to Cart widget with Quantity enabled causes critical error (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/29159\\\">#29159<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.25.1 - 2024-10-31<\\/h4>\\n<ul>\\n<li>Fix: Multiple Custom Add to Cart widgets on the same page are adding the same product<\\/li>\\n<\\/ul>\\n<h4>3.25.0 - 2024-10-28<\\/h4>\\n<ul>\\n<li>Tweak: Added pagination functionality to the Live Results in Search widget<\\/li>\\n<li>Tweak: Added Anchor Offset control to allow precise positioning when scrolling to anchor links on the page<\\/li>\\n<li>Tweak: Load motion effects styles only when they are in use<\\/li>\\n<li>Tweak: Load sticky styles only when they are in use<\\/li>\\n<li>Tweak: Load popup styles only when they are in use<\\/li>\\n<li>Tweak: Load theme builder styles only when they are in use<\\/li>\\n<li>Tweak: Load transition styles for Call to Action and Gallery widgets only when they are in use<\\/li>\\n<li>Tweak: Load styles for Form widgets separately to enhance performance<\\/li>\\n<li>Tweak: Load styles for WooCommerce widgets separately to enhance performance<\\/li>\\n<li>Tweak: Load styles for Theme Elements widgets separately to enhance performance<\\/li>\\n<li>Tweak: Load styles for Carousel widgets separately to enhance performance<\\/li>\\n<li>Tweak: Load styles for Pricing widgets separately to enhance performance<\\/li>\\n<li>Tweak: Load styles for Floating Elements separately to enhance performance<\\/li>\\n<li>Tweak: Load styles for Link in Bio widgets separately to enhance performance<\\/li>\\n<li>Tweak: Load minified CSS in the Loop Builder\'s Call to Action button in the Editor<\\/li>\\n<li>Tweak: Removed &quot;Payments&quot; module styles<\\/li>\\n<li>Tweak: Removed <code>elementor-button-wrapper<\\/code> div from Payapl widget as part of the Optimized Markup experiment<\\/li>\\n<li>Tweak: Removed <code>elementor-button-wrapper<\\/code> div from Stripe widget as part of the Optimized Markup experiment<\\/li>\\n<li>Tweak: Merged &quot;Form Submissions&quot; feature into the version and moved it to the Advanced tab<\\/li>\\n<li>Tweak: Merged &quot;Display Conditions&quot; into the version<\\/li>\\n<li>Fix: Missing translation string for the empty message in the Table of Contents widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/27580\\\">#27580<\\/a>)<\\/li>\\n<li>Fix: Local Storage and Session Storage were being used even when popups were not in use (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7151\\\">#7151<\\/a>)<\\/li>\\n<li>Fix: Masonry layout is not working when pagination is set to &quot;Load More&quot; or &quot;Infinite Scroll&quot; in Loop Grid widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23684\\\">#23684<\\/a>)<\\/li>\\n<li>Fix: Extra gap between widgets on the frontend when using Off-canvas widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/27706\\\">#27706<\\/a>)<\\/li>\\n<li>Fix: Pagination and custom queries did not work when the Posts Widget was saved as a Global Widget or used via shortcode<\\/li>\\n<li>Fix: Lightbox videos are missing controls and displayed at the wrong size in Media Carousel widget<\\/li>\\n<li>Fix: Pagination options with Individual Pagination not working as expected in Posts and Loop Grid widgets<\\/li>\\n<li>Fix: Justified or Masonry layouts for the Pro Gallery would not display images on the frontend when inserted via nested tabs<\\/li>\\n<li>Fix: Error issue in the Loop Grid widget when used in theme parts with the Taxonomy Filter<\\/li>\\n<li>Fix: Removed the focus ring after clicking to open the Off Canvas inside the Editor<\\/li>\\n<li>Fix: Background gradient colors from the dynamic color tag values are not rendering on the frontend<\\/li>\\n<li>Fix: Excessive database requests generated by the Loop Grid widget<\\/li>\\n<li>Fix: Colors from Dynamic Tags were not rendered on the frontend<\\/li>\\n<li>Fix: Display issue in the Menu widget caused by the \'Native Intersection Observer API<\\/li>\\n<li>Fix: Dropdown area not working in certain scenarios in Menu widget<\\/li>\\n<li>Fix: Content Width control inside the Mega Menu is displaying an empty value<\\/li>\\n<\\/ul>\\n<h4>3.24.4 - 2024-10-09<\\/h4>\\n<ul>\\n<li>Security Fix: Improved code security enforcement in Media Carousel widget<\\/li>\\n<\\/ul>\\n<h4>3.24.3 - 2024-10-01<\\/h4>\\n<ul>\\n<li>Fix: Floating Elements template not loading when Single Page template is set with All Singular condition<\\/li>\\n<li>Fix: Form field styles not loading properly in various scenarios<\\/li>\\n<\\/ul>\\n<h4>3.24.2 - 2024-09-18<\\/h4>\\n<ul>\\n<li>Fix: Icons not displaying when Inline SVG Icons experiment is active in Link In Bio widgets and Floating Elements<\\/li>\\n<\\/ul>\\n<h4>3.24.1 - 2024-09-12<\\/h4>\\n<ul>\\n<li>Fix: Widget styles not loading correctly on front causing alignment inconsistencies (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/28676\\\">#28676<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.24.0 - 2024-09-10<\\/h4>\\n<ul>\\n<li>New: Introducing support for Variable Fonts - allowing for more dynamic and flexible text styling (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6703\\\">#6703<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11333\\\">#11333<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19277\\\">#19277<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/25485\\\">#25485<\\/a>)<\\/li>\\n<li>Tweak: Added \'Structure\' indication for widgets with Display Conditions applied (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/28027\\\">#28027<\\/a>)<\\/li>\\n<li>Tweak: Added a new option for setting the live search results width (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/28280\\\">#28280<\\/a>)<\\/li>\\n<li>Tweak: Improved Honeypot field functionality in Form widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/28480\\\">#28480<\\/a>)<\\/li>\\n<li>Tweak: Added options to \'Copy\', \'Paste\', and \'Clear\' Display Conditions in Context Menu<\\/li>\\n<li>Tweak: Improved performance of the Menu widget when using Dynamic Tags in the URL field<\\/li>\\n<li>Tweak: Improved performance when using Dynamic Tags in Nested Elements<\\/li>\\n<li>Tweak: Added the option for users to disable Akismet for specific Elementor forms<\\/li>\\n<li>Tweak: Adjusted URL structure when presenting the Search Archive page in Search widget<\\/li>\\n<li>Tweak: Added the \'Create Template\' button in Search widget<\\/li>\\n<li>Tweak: Added an option to enable the \'Loader\' animation while live results are loading in Search widget<\\/li>\\n<li>Tweak: Load share buttons compatibility styles only when they are in use<\\/li>\\n<li>Tweak: Load dialog styles only when they are in use<\\/li>\\n<li>Tweak: Load global widget styles only during Editor preview<\\/li>\\n<li>Tweak: Conditionally load widget styles only when the widgets are used<\\/li>\\n<li>Tweak: Load styles for CTA hover animations only when they are in use<\\/li>\\n<li>Tweak: Load notes styles only when the WordPress Toolbar is displayed<\\/li>\\n<li>Tweak: Split <code>animations.min.css<\\/code> into multiple CSS files and load them conditionally<\\/li>\\n<li>Tweak: Promoted Display Conditions feature to Stable status<\\/li>\\n<li>Tweak: Merged Taxonomy Filter feature into the version<\\/li>\\n<li>Tweak: Merged Search feature into the version<\\/li>\\n<li>Tweak: Added a note to \'Current Query\' explaining the impact of WordPress settings on pagination within Archives<\\/li>\\n<li>Tweak: Added the ability to set <code>aria-label<\\/code> for the Off-Canvas widget<\\/li>\\n<li>Fix: Manual Selection option is not excluding sticky posts in Posts and Loop Grid widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18689\\\">#18689<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23331\\\">#23331<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/28179\\\">#28179<\\/a>)<\\/li>\\n<li>Fix: Template ID does not change according to the imported Loop Item (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21404\\\">#21404<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22202\\\">#22202<\\/a>)<\\/li>\\n<li>Fix: \'Editing Mode\' for the Off-canvas was not functioning correctly in certain scenarios<\\/li>\\n<li>Fix: Added definition to <code>clear_custom_image_sizes<\\/code> hook to prevent edge case issues<\\/li>\\n<li>Fix: Flickering issue with search result buttons when closing results using the keyboard escape key in Search widget<\\/li>\\n<li>Fix: Theme Style settings for buttons were overriding the text styling in Search widget<\\/li>\\n<li>Fix: Nesting menu inside another menu causes functionality issues in Menu widget<\\/li>\\n<li>Fix: Error when using array as custom fields value in Dynamic Tags<\\/li>\\n<\\/ul>\\n<h4>3.23.3 - 2024-08-05<\\/h4>\\n<ul>\\n<li>Fix: Dropdown area not working in certain scenarios in Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/28194\\\">#28194<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.23.2 - 2024-07-29<\\/h4>\\n<ul>\\n<li>Fix: Horizontal scroll bar appearing on the page when using Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/28087\\\">#28087<\\/a>)<\\/li>\\n<li>Fix: Dropdown area disappearing in certain scenarios in Menu widget<\\/li>\\n<\\/ul>\\n<h4>3.23.1 - 2024-07-23<\\/h4>\\n<ul>\\n<li>Security Fix: Improved code security enforcement in link URL<\\/li>\\n<\\/ul>\\n<h4>3.23.0 - 2024-07-15<\\/h4>\\n<ul>\\n<li>New: Search Widget with Live Results - Display live search results as visitors type into the search box, enhancing user experience and engagement (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/27664\\\">#27664<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/24931\\\">#24931<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21459\\\">#21459<\\/a>)<\\/li>\\n<li>Tweak: Renamed <code>width<\\/code> to <code>Min width<\\/code> and added <code>Max width<\\/code> control to Hotspot tooltips (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18930\\\">#18930<\\/a>)<\\/li>\\n<li>Tweak: Applied a logical DOM order to the Mega Menu widget to improve accessibility<\\/li>\\n<li>Tweak: Added the ability to set <code>aria-label<\\/code> for WordPress Menu widget<\\/li>\\n<li>Tweak: Added the ability to set <code>aria-label<\\/code> for Menu widget<\\/li>\\n<li>Tweak: Added a bottom option to the Image Position control in Call to Action widget<\\/li>\\n<li>Fix: Missing version string in included CSS query string when Improved CSS Loading is enabled (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21879\\\">#21879<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23821\\\">#23821<\\/a>)<\\/li>\\n<li>Fix: Form submission icon message does not display correctly when Inline Font Icons feature is activated<\\/li>\\n<li>Fix: Save and Close button position issues in the conditions screen in Theme Builder.<\\/li>\\n<li>Fix: Focus appears on the first element when using the mouse to open Off-Canvas <\\/li>\\n<li>Fix: Links to Elementor Settings are broken in various locations<\\/li>\\n<li>Fix: Conditions field not showing all relevant conditions in Theme Builder<\\/li>\\n<li>Fix: Off-Canvas flickering in sticky containers with exit animations triggered by sticky effects<\\/li>\\n<\\/ul>\\n<h4>3.22.1 - 2024-06-24<\\/h4>\\n<ul>\\n<li>Fix: Styling of Global widgets not loading when Element Caching experiment is activated (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/27704\\\">#27704<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.22.0 - 2024-06-16<\\/h4>\\n<ul>\\n<li>New: Introducing Off-Canvas widget - create engaging and creative layers triggered by a link (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6225\\\">#6225<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21769\\\">#21769<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/25770\\\">#25770<\\/a>)<\\/li>\\n<li>Tweak: Added option to remove \'User IP\' and \'User Agent\' from the form submissions metadata (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14285\\\">#14285<\\/a>)<\\/li>\\n<li>Tweak: Replaced <code>waypoints.js<\\/code> library with the native Intersection Observer API<\\/li>\\n<li>Tweak: Extended Alignment and Position capabilities in Form widget<\\/li>\\n<li>Tweak: Moved icon View control to style tab in Flip Box widget<\\/li>\\n<li>Tweak: Moved icon View control to style tab in Call to Action widget<\\/li>\\n<li>Tweak: Optimized Form widget to eliminate unnecessary markup when the button icon is empty<\\/li>\\n<li>Tweak: Optimized Posts widget to eliminate unnecessary markup when Load More button text is empty<\\/li>\\n<li>Tweak: Remove <code>placeholder<\\/code> arguments from URL controls<\\/li>\\n<li>Tweak: Implemented CSS logical properties to Icon Position in Form, Posts and Menu Cart widgets<\\/li>\\n<li>Tweak: Activated Display Conditions feature for existing sites<\\/li>\\n<li>Tweak: Activated Taxonomy Filter feature for existing sites<\\/li>\\n<li>Tweak: Added functionality to delay the running of the ready triggers on inner elements<\\/li>\\n<li>Fix: Icons are now part of the link in the Menu Widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/24298\\\">#24298<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/25112\\\">#25112<\\/a>)<\\/li>\\n<li>Fix: <code>all: unset<\\/code> assigned to buttons cause focus issues (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/24322\\\">#24322<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/25448\\\">#25448<\\/a>)<\\/li>\\n<li>Fix: Menu cart SVG icon disappears on front when Optimized Control Loading experiment is activated (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/27342\\\">#27342<\\/a>)<\\/li>\\n<li>Fix: Elementor Pro auto-updates are not working on multisite networks (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12615\\\">#12615<\\/a>)<\\/li>\\n<li>Fix: PHP error appears in the editor when using Loop Grid in an archive template<\\/li>\\n<li>Fix: UI glitch on Icon Position control in Paypal and Stripe Buttons widgets<\\/li>\\n<li>Fix: Icon Position control RTL issue in Hotspot widget<\\/li>\\n<li>Fix: Manual Selection &quot;Include By&quot; Query doesn\'t work with product categories<\\/li>\\n<\\/ul>\\n<h4>3.21.3 - 2024-05-20<\\/h4>\\n<ul>\\n<li>Security Fix: Improved code security enforcement in Loop Grid widget<\\/li>\\n<li>Fix: License expired affects the Display Conditions functionality in the front end<\\/li>\\n<\\/ul>\\n<h4>3.21.2 - 2024-04-30<\\/h4>\\n<ul>\\n<li>Fix: Special characters are not displayed correctly when using the Excerpt widget in Loop template (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/25860\\\">#25860<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.21.1 - 2024-04-24<\\/h4>\\n<ul>\\n<li>Fix: Excerpt Length setting doesn\'t function correctly for languages with non-English characters in Post Excerpt widget<\\/li>\\n<\\/ul>\\n<h4>3.21.0 - 2024-04-15<\\/h4>\\n<ul>\\n<li>New: Introducing Loop Taxonomy Query - Enabling the display of post and product categories and tags within Loop Grid and Loop Carousel widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21372\\\">#21372<\\/a>)<\\/li>\\n<li>Tweak: Optimized Hotspot widget to prevent rendering when no image is provided<\\/li>\\n<li>Tweak: Optimized Blockquote widget to eliminate unnecessary markup when devoid of content<\\/li>\\n<li>Tweak: Optimized Template widget to eliminate unnecessary markup when no template is selected<\\/li>\\n<li>Tweak: Optimized Code Highlight widget to eliminate unnecessary markup when there is no content<\\/li>\\n<li>Tweak: Implemented CSS logical properties in Elementor<\\/li>\\n<li>Tweak: Implemented accessibility improvements in Portfolio widget<\\/li>\\n<li>Tweak: Implemented accessibility improvements of Author Avatar image alt text in Post Info widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/25440\\\">#25440<\\/a>)<\\/li>\\n<li>Tweak: Notes feature merged to version<\\/li>\\n<li>Tweak: Implemented accessibility improvements of Profile Picture alt text in Author widget<\\/li>\\n<li>Fix: Display issue on hover state in WooCommerce Menu Cart widget<\\/li>\\n<\\/ul>\\n<h4>3.20.3 - 2024-04-10<\\/h4>\\n<ul>\\n<li>Fix: Compatibility issue between the My Account widget and other third-party plugins (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/20986\\\">#20986<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.20.2 - 2024-03-26<\\/h4>\\n<ul>\\n<li>Security Fix: Improved code security enforcement in Media Carousel widget<\\/li>\\n<li>Security Fix: Improved code security enforcement in Form widget<\\/li>\\n<li>Security Fix: Improved code security enforcement in Post Navigation widget<\\/li>\\n<li>Security Fix: Improved code security enforcement in Gallery widget<\\/li>\\n<li>Security Fix: Improved code security enforcement in Video Playlist widget<\\/li>\\n<\\/ul>\\n<h4>3.20.1 - 2024-03-20<\\/h4>\\n<ul>\\n<li>Fix: Strengthened code integrity in deprecated Woo Single Element widget<\\/li>\\n<li>Fix: PHP error notice appears when using Loop Grid with the Taxonomy Filter widgets<\\/li>\\n<\\/ul>\\n<h4>3.20.0 - 2024-03-11<\\/h4>\\n<ul>\\n<li>Tweak: Implemented OR logic in the Display Conditions feature<\\/li>\\n<li>Tweak: Added X and Threads social networks to Share Buttons widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/25299\\\">#25299<\\/a>)<\\/li>\\n<li>Tweak: Added Archive Title dynamic tag rule in Display Conditions feature<\\/li>\\n<li>Tweak: Added Featured Image Title dynamic tag rule in Display Conditions feature<\\/li>\\n<li>Tweak: Added Featured Image Alt dynamic tag rule in Display Conditions feature<\\/li>\\n<li>Tweak: Added Featured Image Caption dynamic tag rule in Display Conditions feature<\\/li>\\n<li>Tweak: Added Author Bio dynamic tag rule in Display Conditions feature<\\/li>\\n<li>Tweak: Added Author Email dynamic tag rule in Display Conditions feature<\\/li>\\n<li>Tweak: Added Author Website dynamic tag rule in Display Conditions feature<\\/li>\\n<li>Tweak: Added Page Title rule in Display Conditions feature<\\/li>\\n<li>Tweak: Added Post Title rule in Display Conditions feature<\\/li>\\n<li>Tweak: Added Featured Image rule in Display Conditions feature<\\/li>\\n<li>Tweak: Added Comments Number rule in Display Conditions feature<\\/li>\\n<li>Tweak: Added Archive Author rule in Display Conditions feature<\\/li>\\n<li>Tweak: Added support for WordPress Custom Fields in Display Conditions feature<\\/li>\\n<li>Tweak: Implemented accessibility improvements in Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23875\\\">#23875<\\/a>)<\\/li>\\n<li>Tweak: Implemented accessibility improvements in Login widget<\\/li>\\n<li>Tweak: Added additional style controls in the Table of Contents widget<\\/li>\\n<li>Tweak: Added Transition Duration option in Blockquote widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21295\\\">#21295<\\/a>)<\\/li>\\n<li>Tweak: Added Transition Duration to button in Flip Box widget<\\/li>\\n<li>Tweak: Added Transition Duration to button in Author Box widget<\\/li>\\n<li>Tweak: Added Transition Duration to List in Table of Contents widget<\\/li>\\n<li>Tweak: Added Transition Duration to button in Login widget<\\/li>\\n<li>Tweak: Added Transition Duration in Post Navigation widget<\\/li>\\n<li>Tweak: Added Transition Duration Show More in Video Playlist widget<\\/li>\\n<li>Tweak: Added Transition Duration to button in Form widget<\\/li>\\n<li>Tweak: Removed separator-none argument from all Editor controls<\\/li>\\n<li>Tweak: Add <code>&lt;time&gt;<\\/code> wrapper for Date and Time items in Post Info widget<\\/li>\\n<li>Tweak: Page Transitions feature merged to version<\\/li>\\n<li>Tweak: Scroll Snap feature merged to version<\\/li>\\n<li>Tweak: Promoted Display Conditions feature to Beta status and activated for new sites<\\/li>\\n<li>Tweak: Promoted Taxonomy Filter feature to beta status and activated for new sites<\\/li>\\n<li>Fix: Page Transitions feature and Load Font Awesome 4 Support cause a console error (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18885\\\">#18885<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19334\\\">#19334<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21082\\\">#21082<\\/a>)<\\/li>\\n<li>Fix: Added better output escaping in Taxonomy Filter widget<\\/li>\\n<\\/ul>\\n<h4>3.19.3 - 2024-02-26<\\/h4>\\n<ul>\\n<li>Tweak: Improved Loop CSS loading structure in Loop Grid item<\\/li>\\n<li>Security Fix: Addressed security weaknesses in Dynamic Tags<\\/li>\\n<\\/ul>\\n<h4>3.19.2 - 2024-02-07<\\/h4>\\n<ul>\\n<li>Fix: Export data inconsistencies when using form actions in Form widget<\\/li>\\n<\\/ul>\\n<h4>3.19.1 - 2024-02-05<\\/h4>\\n<ul>\\n<li>Fix: Enqueuing non-existing Loop Template CSS file in Loop Item template (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/24959\\\">#24959<\\/a>)<\\/li>\\n<li>Fix: Improved code security enforcement in Countdown widget<\\/li>\\n<\\/ul>\\n<h4>3.19.0 - 2024-01-29<\\/h4>\\n<ul>\\n<li>New: Introducing Display Conditions for Elements - allowing users to customize content visibility based on specified criteria (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4246\\\">#4246<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21152\\\">#21152<\\/a>)<\\/li>\\n<li>New: Implemented Akismet Integration for enhanced spam protection and security in Form widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11401\\\">#11401<\\/a>)<\\/li>\\n<li>New: Introducing Permissions functionality to Element Manager - providing users with enhanced control over access and management capabilities<\\/li>\\n<li>Tweak: Added styling option for dropdown indicator in Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21907\\\">#21907<\\/a>)<\\/li>\\n<li>Tweak: Added additional size units and custom units in all elements<\\/li>\\n<li>Tweak: Implemented CSS logical properties in WordPress Menu widget<\\/li>\\n<li>Tweak: Implemented CSS logical properties in Reviews widget<\\/li>\\n<li>Tweak: Implemented CSS logical properties in Countdown widget<\\/li>\\n<li>Tweak: Implemented CSS logical properties in Elementor Editor<\\/li>\\n<li>Tweak: Updated <code>jquery.smartmenus.js<\\/code> version from 1.1.1 to 1.2.0<\\/li>\\n<li>Fix: Dynamic Background Image does not load on the first Loop Item in a Loop Grid (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21489\\\">#21489<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22368\\\">#22368<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23085\\\">#23085<\\/a>)<\\/li>\\n<li>Fix: History panel deprecation notices in console log<\\/li>\\n<li>Fix: Second Pro rollback installed the latest version instead of the specifically selected older version<\\/li>\\n<li>Fix: Incorrect position of the dropdown content when applying entrance animation in Menu Widget<\\/li>\\n<li>Fix: UX issues when using in-place editing in Menu widget<\\/li>\\n<li>Fix: Pagination with page reload is not working when used with the Taxonomy filter and Loop Grid widget in Archive template<\\/li>\\n<\\/ul>\\n<h4>3.18.2 - 2023-12-20<\\/h4>\\n<ul>\\n<li>Fix: Modified controls sanitization to enforce better security policies in Price List widget<\\/li>\\n<li>Fix: Error messages related to loop filter appear on front when using PHP 8.X and <code>WP_DEBUG<\\/code> is true<\\/li>\\n<\\/ul>\\n<h4>3.18.1 - 2023-12-06<\\/h4>\\n<ul>\\n<li>Fix: No results appeared when reloading the page with deep link and de-selecting terms in Taxonomy Filter widget<\\/li>\\n<li>Fix: No results appeared when filtering the Uncategorized category in Filter Taxonomy widget<\\/li>\\n<li>Fix: Notes still available when the Notes feature is deactivated<\\/li>\\n<\\/ul>\\n<h4>3.18.0 - 2023-12-04<\\/h4>\\n<ul>\\n<li>Tweak: Added the ability to upload files as attachments to emails in the File Upload field in Form widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4868\\\">#4868<\\/a>)<\\/li>\\n<li>Tweak: Introduced the capability to design and edit the empty state in the Loop Grid widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/24261\\\">#24261<\\/a>)<\\/li>\\n<li>Tweak: Implemented the option to close the menu content area with a click anywhere on the screen in Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22686\\\">#22686<\\/a>)<\\/li>\\n<li>Tweak: Improve scrolling behavior inside the content area when there is not enough space in Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22712\\\">#22712<\\/a>)<\\/li>\\n<li>Tweak: Expanded breakpoint options in Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22488\\\">#22488<\\/a>)<\\/li>\\n<li>Tweak: Added Logical Combination control in Taxonomy Filter widget<\\/li>\\n<li>Tweak: Added additional units to Horizontal and Vertical padding for Dropdown in WordPress Menu widget<\\/li>\\n<li>Tweak: Hide navigation arrows when there is only one slide in Loop Carousel and Carousel widgets<\\/li>\\n<li>Tweak: Added various HTML Tag controls in Video Playlist widget<\\/li>\\n<li>Tweak: Added responsive control to navigation size in Slides, Reviews, Media Carousel and Testimonial Carousel widgets<\\/li>\\n<li>Tweak: Added semantic <code>&lt;search&gt;<\\/code> wrapper in Search Form widget<\\/li>\\n<li>Tweak: Added semantic <code>&lt;search&gt;<\\/code> wrapper in Taxonomy Filter widget<\\/li>\\n<li>Tweak: Added Multiple Selection control in Taxonomy Filter widget<\\/li>\\n<li>Fix: Deprecated notice when using ${var} in strings instead of {$var} with PHP 8.2 (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23927\\\">#23927<\\/a>)<\\/li>\\n<li>Fix: Dropdown indicator position issue in Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23947\\\">#23947<\\/a>)<\\/li>\\n<li>Fix: Dynamic Tags are not available when choosing \'self-hosted\' source in Video widget<\\/li>\\n<li>Fix: Telephone field placeholder is aligned to the left in RTL websites in Form widget<\\/li>\\n<\\/ul>\\n<h4>3.17.1 - 2023-11-01<\\/h4>\\n<ul>\\n<li>Fix: Modified controls sanitization to enforce better security policies in Code Highlight, Form, Lottie, Price List, and Video Playlist widgets<\\/li>\\n<\\/ul>\\n<h4>3.17.0 - 2023-10-25<\\/h4>\\n<ul>\\n<li>Tweak: Added AJAX pagination option or seamless page navigation between content in Loop Grid widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1284\\\">#1284<\\/a>)<\\/li>\\n<li>Tweak: Introduced Individual Pagination option when multiple Post widgets are on the same page, providing enhanced control over pagination<\\/li>\\n<li>Tweak: Introduced Individual Pagination option when multiple Loop Grid widgets are on the same page, providing enhanced control over pagination<\\/li>\\n<li>Tweak: Added a None option to the breakpoint options in Menu widget<\\/li>\\n<li>Tweak: Added a horizontal scrolling option in Menu widget<\\/li>\\n<li>Tweak: Upgraded minimum required PHP version to 7.3<\\/li>\\n<li>Tweak: Improved accessibility when minimize button is disabled in Table of Content widget<\\/li>\\n<li>Fix: Table of Content widget without icons displays <code>undefined<\\/code> error (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17523\\\">#17523<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17768\\\">#17768<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18463\\\">#18463<\\/a>)<\\/li>\\n<li>Fix: Hover behavior issues on menu items in Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23430\\\">#23430<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22431\\\">#22431<\\/a>)<\\/li>\\n<li>Fix: Links inside Loop Carousel are not working on initial load in Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23705\\\">#23705<\\/a>)<\\/li>\\n<li>Fix: Popups accessible navigation adds outlines to the wrong first focusable element<\\/li>\\n<li>Fix: Dropdown area aligned to the left side of the screen if contains Tabs widget in Menu widget<\\/li>\\n<li>Fix: Content horizontal position not aligning correctly when used with carousel widgets in Menu widget<\\/li>\\n<li>Fix: Accessibility errors in PageSpeed Insights in Table of Contents widget<\\/li>\\n<\\/ul>\\n<h4>3.16.2 - 2023-09-20<\\/h4>\\n<ul>\\n<li>Fix: Fit to Content dropdown position calculation is incorrect in Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23808\\\">#23808<\\/a>)<\\/li>\\n<li>Fix: Reverted hide navigation arrows when there is only one slide in the Loop or Nested carousel (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23804\\\">#23804<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.16.1 - 2023-09-14<\\/h4>\\n<ul>\\n<li>Fix: Dynamic tag for ACF image field is not working as expected (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23757\\\">#23757<\\/a>)<\\/li>\\n<li>Fix: Sticky functionality affects padding values in Container (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23758\\\">#23758<\\/a>)<\\/li>\\n<li>Fix: HTML list issues for padding and margin in Menu widget<\\/li>\\n<\\/ul>\\n<h4>3.16.0 - 2023-09-12<\\/h4>\\n<ul>\\n<li>Tweak: Implemented accessibility improvements in Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23607\\\">#23607<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22554\\\">#22554<\\/a>)<\\/li>\\n<li>Fix: \'Fallback: Recent Posts\' option malfunctions in the Query control (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21436\\\">#21436<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23259\\\">#23259<\\/a>)<\\/li>\\n<li>Tweak: Hide navigation arrows when there is only one slide in the Loop or Nested carousel (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22056\\\">#22056<\\/a>)<\\/li>\\n<li>Tweak: Used appropriate image <code>alt<\\/code> in Testimonial Carousel widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17680\\\">#17680<\\/a>)<\\/li>\\n<li>Tweak: Optimized Scroll Snap functionality when using Container widget<\\/li>\\n<li>Tweak: Enhanced Elementor Role Manager functionality when using Containers<\\/li>\\n<li>Tweak: Added Notes feature to the Editor Top Bar<\\/li>\\n<li>Tweak: Replace CSS <code>float<\\/code> with other layouts in the Editor<\\/li>\\n<li>Tweak: Upgraded HTML Structure for the Menu widget<\\/li>\\n<li>Tweak: Implemented CSS logical properties in Carousel and Menu widgets<\\/li>\\n<li>Tweak: Added keyboard accessibility to a link in Posts widget<\\/li>\\n<li>Tweak: Loop Builder feature merged to version<\\/li>\\n<li>Fix: Addressed inconsistency in hover effect durations between icon, dropdown indicator colors, and text colors in the Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22376\\\">#22376<\\/a>)<\\/li>\\n<li>Fix: Slides break if the parent container is set to HTML A tag in Loop Carousel and Carousel widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22678\\\">#22678<\\/a>)<\\/li>\\n<li>Fix: The icon size setting is not affecting uploaded SVG icons in the Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22372\\\">#22372<\\/a>)<\\/li>\\n<li>Fix: Taxonomy filter does not work with slug in foreign characters (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23315\\\">#23315<\\/a>)<\\/li>\\n<li>Fix: Improved code security enforcement in Dynamic Tags<\\/li>\\n<li>Fix: Sticky container incorrectly adjusts its width when transitioning from a smaller breakpoint to a larger one within the Editor<\\/li>\\n<\\/ul>\\n<h4>3.15.1 - 2023-08-09<\\/h4>\\n<ul>\\n<li>Fix: Improved code security enforcement in Table of Contents widget<\\/li>\\n<\\/ul>\\n<h4>3.15.0 - 2023-07-31<\\/h4>\\n<ul>\\n<li>New: Introducing Taxonomy Filter widget - Empower visitors to seamlessly filter listings in Loop Grids based on taxonomies (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3140\\\">#3140<\\/a>)<\\/li>\\n<li>Tweak: Added an &quot;Offset Sides&quot; functionality in Carousel and Loop Carousel widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21114\\\">#21114<\\/a>)<\\/li>\\n<li>Tweak: Modified the size of the Publish button in the Editor Top Bar feature (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22472\\\">#22472<\\/a>)<\\/li>\\n<li>Tweak: Improved Ajax permissions functionality for better security enforcement<\\/li>\\n<li>Tweak: Added option for pagination custom position in Carousel and Loop Carousel widgets<\\/li>\\n<li>Tweak: Added option for navigation custom position in Carousel and Loop Carousel widgets<\\/li>\\n<li>Tweak: Added additional styling options for navigation in Carousel and Loop Carousel widgets<\\/li>\\n<li>Tweak: Added labels to shortcode column in WordPress admin<\\/li>\\n<li>Tweak: Unified the appearance of <code>stretch<\\/code> and <code>center<\\/code> buttons in Menu widget<\\/li>\\n<li>Tweak: Unified the appearance of <code>stretch<\\/code> and <code>center<\\/code> buttons in My Account widget<\\/li>\\n<li>Tweak: Improved panel UI in Video Playlist widget<\\/li>\\n<li>Tweak: Implemented CSS logical properties in Elementor Editor<\\/li>\\n<li>Tweak: Added &quot;Title HTML Tag&quot; and &quot;Description HTML Tag&quot; in Price List widget<\\/li>\\n<li>Tweak: Added &quot;Title HTML Tag&quot; and &quot;Description HTML Tag&quot; in Slides widget<\\/li>\\n<li>Tweak: Added &quot;Title HTML Tag&quot; and &quot;Description HTML Tag&quot; in Flip Box widget<\\/li>\\n<li>Tweak: Added &quot;Description HTML Tag&quot; in Call To Action widget<\\/li>\\n<li>Security Fix: Improved code security enforcement in Share Buttons widget<\\/li>\\n<li>Security Fix: Improved code security enforcement in Form widget<\\/li>\\n<li>Fix: WooCommerce Status page failed to recognize Elementor WooCommerce widgets<\\/li>\\n<li>Fix: Pagination does not work inside single templates when using Posts and Loop Grid widgets<\\/li>\\n<li>Fix: Incorrect saving of WooCommerce page settings in Elementor site settings under certain scenarios<\\/li>\\n<\\/ul>\\n<h4>3.14.1 - 2023-06-26<\\/h4>\\n<ul>\\n<li>Tweak: Improved navigation on touch devices in Carousel widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22827\\\">#22827<\\/a>)<\\/li>\\n<li>Fix: Missing navigation arrows on lightbox in Gallery widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22870\\\">#22870<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.14.0 - 2023-06-19<\\/h4>\\n<ul>\\n<li>New: Introducing Carousel widget - Infinite design possibilities, and nesting capabilities (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2587\\\">#2587<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/219\\\">#219<\\/a>)<\\/li>\\n<li>Tweak: Added Static Item Position functionality to Alternate template in Loop Grid widget<\\/li>\\n<li>Tweak: Added visual indication of Page Parts<\\/li>\\n<li>Tweak: Added dividers option between menu items in Menu widget<\\/li>\\n<li>Tweak: Changed the HTML structure of Pagination and Navigation in Loop Carousel and Nested Carousel widgets<\\/li>\\n<li>Tweak: Added shop page in WooCommerce Pages section in Site Settings<\\/li>\\n<li>Tweak: Added Text Shadow, Box Shadow and Padding control to button in Call to Action widget<\\/li>\\n<li>Tweak: Added Lazy Load support for images in Video Playlist widget<\\/li>\\n<li>Tweak: Added <code>alt<\\/code> attribute to images in Video Playlist widget<\\/li>\\n<li>Tweak: Replaced select control with choose control for Flip Direction control in Flip Box widget<\\/li>\\n<li>Tweak: Added keyboard accessibility to Carousel and Loop Carousel widgets<\\/li>\\n<li>Tweak: Use <code>media_types<\\/code> array in Media controls<\\/li>\\n<li>Fix: Lightbox is still enabled after disabling it in the Site Settings in Gallery widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11193\\\">#11193<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19871\\\">#19871<\\/a>)<\\/li>\\n<li>Fix: Responsive settings for templates don\'t work as expected when Additional Custom Breakpoints feature is active (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16819\\\">#16819<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19394\\\">#19394<\\/a>)<\\/li>\\n<li>Fix: Inner containers are not presented as expected in Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21813\\\">#21813<\\/a>)<\\/li>\\n<li>Fix: Popup width does not support percentages (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22413\\\">#22413<\\/a>)<\\/li>\\n<li>Fix: PHP 8.x throws errors when using WooCommerce Ajax response (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22199\\\">#22199<\\/a>)<\\/li>\\n<li>Fix: Mini cart template appears as empty in various scenarios in Menu Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22789\\\">#22789<\\/a>)<\\/li>\\n<li>Fix: Order by Price doesn\'t work for the Latest products or Manual Selection in Products widget<\\/li>\\n<li>Fix: Dropdown indicator icon is not vertically aligned to the text when using icon in Menu Widget<\\/li>\\n<li>Fix: Mixed content warning in the console for Video Playlist widget<\\/li>\\n<li>Fix: Preview settings are not presented as expected after first save in Loop Template<\\/li>\\n<li>Fix: Not-crawlable link error in Video Playlist widget<\\/li>\\n<li>Fix: Lightbox is still enabled after disabling it in the Site Settings in Logo widget<\\/li>\\n<li>Fix: Focus state issue on page load when using Table of Content widget<\\/li>\\n<\\/ul>\\n<h4>3.13.2 - 2023-05-22<\\/h4>\\n<ul>\\n<li>Fix: Hover settings not working as expected on Touch-Enabled devices in Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22258\\\">#22258<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.13.1 - 2023-05-11<\\/h4>\\n<ul>\\n<li>Security Fix: Addressed security weaknesses in access management related functions<\\/li>\\n<li>Fix: Excerpt content pulled from post content is showing with HTML tags in Loop Grid widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22367\\\">#22367<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.13.0 - 2023-05-08<\\/h4>\\n<ul>\\n<li>Tweak: Provided an option to assign excerpt automatically from post content in Post Excerpt dynamic tag (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/20256\\\">#20256<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21715\\\">#21715<\\/a>)<\\/li>\\n<li>Tweak: Added Display Conditions functionality in Editor Top bar (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21675\\\">#21675<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22050\\\">#22050<\\/a>)<\\/li>\\n<li>Tweak: Removed <code>elementor_page_id<\\/code> from request URLs in the WC AJAX calls (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18675\\\">#18675<\\/a>)<\\/li>\\n<li>Tweak: Added icons to menu items in Mega Menu widget (<a href=\\\"https:\\/\\/github.com\\/orgs\\/elementor\\/discussions\\/21602\\\">#21602<\\/a>)<\\/li>\\n<li>Tweak: Added keyboard accessibility to Toggle Button in WordPress Menu widget (<a href=\\\"https:\\/\\/github.com\\/orgs\\/elementor\\/discussions\\/2348\\\">#2348<\\/a>)<\\/li>\\n<li>Tweak: Added \'Active item state\' to top-level menu items for anchor links in the Menu widget<\\/li>\\n<li>Tweak: Added keyboard accessibility to navigation arrows in Loop Carousel widget<\\/li>\\n<li>Tweak: Added keyboard accessibility to navigation arrows in Slides widget<\\/li>\\n<li>Tweak: Added keyboard accessibility to navigation arrows in Media, Testimonial and Reviews Carousel widgets<\\/li>\\n<li>Tweak: Added keyboard accessibility to Table of Content widget<\\/li>\\n<li>Tweak: Added keyboard accessibility to Search Form widget<\\/li>\\n<li>Tweak: Added accessibility to images in Slides widget<\\/li>\\n<li>Tweak: Added accessibility to images in Call To Action widget<\\/li>\\n<li>Tweak: Added accessibility to images in Media Carousel widget<\\/li>\\n<li>Tweak: Added accessibility to images in Gallery widget<\\/li>\\n<li>Tweak: Added Lazy Load support for avatar image in Post Info widget<\\/li>\\n<li>Tweak: Added Lazy Load support to various Elementor Editor and Admin images<\\/li>\\n<li>Tweak: Added Lazy Load support for author image in Author Box widget<\\/li>\\n<li>Tweak: Added Lazy Load support for images in Price List widget<\\/li>\\n<li>Fix: Content width is affected by the widget\'s width when Content Width is set to Fit to Content in Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21842\\\">#21842<\\/a>)<\\/li>\\n<li>Fix: Empty value on Rows field causes an error in Products widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21451\\\">#21451<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.12.2 - 2023-04-09<\\/h4>\\n<ul>\\n<li>Fix: Mini cart template appears as empty in various WordPress themes (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21836\\\">#21836<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.12.1 - 2023-04-02<\\/h4>\\n<ul>\\n<li>Fix: Default background colors are presented as transparent in Popup (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21824\\\">#21824<\\/a>)<\\/li>\\n<li>Fix: Reverted the tweak of Form Submissions feature merged to the version (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21821\\\">#21821<\\/a>)<\\/li>\\n<li>Fix: Dropdown area is not closing when hovering outside of the content area in Menu widget<\\/li>\\n<\\/ul>\\n<h4>3.12.0 - 2023-03-29<\\/h4>\\n<ul>\\n<li>New: Introducing the Mega Menu with the new Menu widget - empowers you to achieve a much higher level of menu design, customization, and creativity<\\/li>\\n<li>New: Diversify your design with a Loop Alternate template - apply another template within your Loop Grid for design creativity<\\/li>\\n<li>New: Kickstart your workflow with predesigned Loop container-based templates<\\/li>\\n<li>Tweak: Added custom icon controls to various locations in Menu Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13678\\\">#13678<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17941\\\">#17941<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19295\\\">#19295<\\/a>)<\\/li>\\n<li>Tweak: Added a spacing control between navigation and slides in the Loop Carousel<\\/li>\\n<li>Tweak: Added responsive control to the \'Gap between slides\' control in the Loop Carousel<\\/li>\\n<li>Tweak: Added Custom CSS section in Loop Item template<\\/li>\\n<li>Tweak: Added an Article class metadata in Loop Item template<\\/li>\\n<li>Tweak: Added Lazy Load support for background images in CTA widget when using the Lazy Load Background Images experiment<\\/li>\\n<li>Tweak: Added Lazy Load support for background images in Flipbox widget when using the Lazy Load Background Images experiment<\\/li>\\n<li>Tweak: Added additional size units and custom units in all elements<\\/li>\\n<li>Tweak: Changed Nav Menu widget name to WordPress Menu widget<\\/li>\\n<li>Tweak: Added &quot;Form Validation&quot; control to Form widget<\\/li>\\n<li>Tweak: Updated custom messages in the Form widget<\\/li>\\n<li>Tweak: Improved accessibility in various elements in Gallery widget<\\/li>\\n<li>Tweak: Form Submissions feature merged to version<\\/li>\\n<li>Tweak: Loop feature promoted to Stable status<\\/li>\\n<li>Tweak: Page Transitions feature promoted to Stable status<\\/li>\\n<li>Tweak: Improved accessibility in filter bar in Gallery widget<\\/li>\\n<li>Tweak: Remove unused <code>aspect-ratio-*<\\/code> CSS classes<\\/li>\\n<li>Fix: Not all active breakpoints appear under &quot;Advanced Rules&quot; in popup publish settings (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17020\\\">#17020<\\/a>)<\\/li>\\n<li>Fix: Dynamic background image and video is not working with ACF in Loop Grid widget<\\/li>\\n<\\/ul>\\n<h4>3.11.7 - 2023-03-22<\\/h4>\\n<ul>\\n<li>Tweak: Improved code security enforcement in WooCommerce components<\\/li>\\n<\\/ul>\\n<h4>3.11.6 - 2023-03-14<\\/h4>\\n<ul>\\n<li>Tweak: Improved code security enforcement in Author Box and Countdown widgets<\\/li>\\n<\\/ul>\\n<h4>3.11.5 - 2023-03-12<\\/h4>\\n<ul>\\n<li>Fix: Hamburger Menu Toggle not showing if breakpoint is set to Tablet Extra in Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21003\\\">#21003<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.11.4 - 2023-03-07<\\/h4>\\n<ul>\\n<li>Tweak: Prevented SVG file upload for better security enforcement in Forms widget<\\/li>\\n<\\/ul>\\n<h4>3.11.3 - 2023-02-26<\\/h4>\\n<ul>\\n<li>Fix: Error message appears when submitting a form placed below Loop Grid and Loop Carousel widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21432\\\">#21432<\\/a>)<\\/li>\\n<li>Fix: PHP 8.x compatibility issues in various places<\\/li>\\n<\\/ul>\\n<h4>3.11.2 - 2023-02-22<\\/h4>\\n<ul>\\n<li>Fix: Save &amp; Back handle becomes inaccessible in various scenarios cases in Loop Carousel widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21316\\\">#21316<\\/a>)<\\/li>\\n<li>Fix: Can\'t edit page when using \'Content Tabs\' and \'Section\' options in Video Playlist widget<\\/li>\\n<\\/ul>\\n<h4>3.11.1 - 2023-02-15<\\/h4>\\n<ul>\\n<li>Fix: Featured Image dynamic tag is not working in Background images (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21313\\\">#21313<\\/a>)<\\/li>\\n<li>Fix: Time zone is not correct in Countdown widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17485\\\">#17485<\\/a>)<\\/li>\\n<li>Fix: File upload field is not working in Form widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21341\\\">#21341<\\/a>)<\\/li>\\n<li>Fix: Post Image Attachments dynamic tag is not working in various widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21314\\\">#21314<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.11.0 - 2023-02-13<\\/h4>\\n<ul>\\n<li>New: Introducing Loop Carousel widget - Create powerful &amp; repeating loop templates and populate each one with dynamic content (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/219\\\">#219<\\/a>)<\\/li>\\n<li>New: Added Date and Time Range option to Advanced Rules in Popup<\\/li>\\n<li>Tweak: Improved accessibility when opening and closing a popup (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9788\\\">#9788<\\/a>)<\\/li>\\n<li>Tweak: Improved accessibility of full-screen mode in Search Form widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19907\\\">#19907<\\/a>)<\\/li>\\n<li>Tweak: Added keyboard accessibility support to Flip Box widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5861\\\">#5861<\\/a>)<\\/li>\\n<li>Tweak: Add <code>aria-label<\\/code> to read more link in Posts widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13784\\\">#13784<\\/a>)<\\/li>\\n<li>Tweak: Use <code>aspect-ratio<\\/code> property instead of CSS trick in Media Carousel widget<\\/li>\\n<li>Tweak: Updated translation string in Stripe widget<\\/li>\\n<li>Fix: Masonry and Columns controls are not working as expected with responsive in Posts and Loop Grid widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/20670\\\">#20670<\\/a>)<\\/li>\\n<li>Fix: Invalid attributes names in Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17400\\\">#17400<\\/a>)<\\/li>\\n<li>Fix: Post Image Attachments dynamic tag is not working as expected in various widgets<\\/li>\\n<li>Fix: Form fields order is not presented correctly when exported to CSV in Form Submissions<\\/li>\\n<li>Fix: Dynamic background image and video are not working with ACF in Loop Grid widget<\\/li>\\n<\\/ul>\\n<h4>3.10.3 - 2023-01-29<\\/h4>\\n<ul>\\n<li>Tweak: Added introduction video to loop item information modal in Theme Builder<\\/li>\\n<li>Fix: PHP 8.x throws errors and notices in some cases (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21087\\\">#21087<\\/a>)<\\/li>\\n<li>Fix: Infinite Scroll and Load on click pagination are not working as expected in Archive template<\\/li>\\n<li>Fix: Show row even when values do not exist in Form Submissions<\\/li>\\n<\\/ul>\\n<h4>3.10.2 - 2023-01-17<\\/h4>\\n<ul>\\n<li>Fix: Updated compatibility tag for Elementor v3.10<\\/li>\\n<\\/ul>\\n<h4>3.10.1 - 2023-01-09<\\/h4>\\n<p>Fix: Preview Could not be loaded error message appears on pages containing the Loop Grid in a header or footer templates<\\/p>\\n<h4>3.10.0 - 2023-01-09<\\/h4>\\n<ul>\\n<li>New: Added new dynamic tag for due date in Countdown widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7737\\\">#7737<\\/a>)<\\/li>\\n<li>Tweak: Added <code>modified<\\/code> and <code>comment_count<\\/code> to Order By in posts query control (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11159\\\">#11159<\\/a>)<\\/li>\\n<li>Tweak: Replaced <code>footer<\\/code> tag in Blockquote and Comments widgets for better semantics<\\/li>\\n<li>Fix: Compatibility issue in Imagify Media Library filters due to <code>_elementor_is_screenshot<\\/code> meta filter (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19988\\\">#19988<\\/a>)<\\/li>\\n<li>Fix: Hotspot Widget label icon height issues when Inline Font Icons experiment is active<\\/li>\\n<li>Fix: Editing glitch when using two loop grid widgets on the same page with the same loop item template<\\/li>\\n<li>Fix: Equal height is not working when using sections in Loop Grid widget<\\/li>\\n<li>Fix: Large amount of menu items are not appearing correctly on a mobile device in Nav Menu widget<\\/li>\\n<li>Fix: Featured Image does not change dynamically when using infinite\\/click pagination in Loop Grid widget<\\/li>\\n<li>Fix: Removed action call of non-existent <code>display_empty_cart_template()<\\/code> method in Cart widget<\\/li>\\n<\\/ul>\\n<h4>3.9.2 - 2022-12-21<\\/h4>\\n<ul>\\n<li>Fix: JS events do not trigger in Popups (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/20708\\\">#20708<\\/a>)<\\/li>\\n<li>Fix: PHP Errors appear when not using the toggle menu in Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18636\\\">#18636<\\/a>)<\\/li>\\n<li>Fix: Popups\' backgrounds disappear when using Lazy Load Background Images experiment<\\/li>\\n<\\/ul>\\n<h4>3.9.1 - 2022-12-14<\\/h4>\\n<ul>\\n<li>Fix: WooCommerce Product Gallery dynamic tag is not working in Basic Gallery, Gallery and Image Carousel widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/20678\\\">#20678<\\/a>)<\\/li>\\n<li>Fix: Hide Empty option is not working in Menu Cart widget<\\/li>\\n<li>Fix: The Stripe Button widget doesn\'t work in Templates<\\/li>\\n<\\/ul>\\n<h4>3.9.0 - 2022-12-06<\\/h4>\\n<ul>\\n<li>New: Added support for WooCommerce to Loop Builder (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/20020\\\">#20020<\\/a>)<\\/li>\\n<li>Tweak: Added more options to \'Show up to X times\' advanced rule in Popups (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8187\\\">#8187<\\/a>)<\\/li>\\n<li>Tweak: Allow saving and reloading a page while editing in-place loop item template (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19882\\\">#19882<\\/a>)<\\/li>\\n<li>Tweak: Added <code>$location param<\\/code> to <code>elementor\\/theme\\/get_location_templates\\/template_id<\\/code> hook (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18453\\\">#18453<\\/a>)<\\/li>\\n<li>Tweak: Removed redundant labels from group controls (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11666\\\">#11666<\\/a>)<\\/li>\\n<li>Tweak: Added support to use sections and columns as the layout structure of a Loop item template<\\/li>\\n<li>Tweak: Disabled movement when a repeater item is in focus in edit mode<\\/li>\\n<li>Tweak: Upgrade the autoprefixer package to better minify CSS files<\\/li>\\n<li>Tweak: Removed duplicate SQL queries on every page for better performance<\\/li>\\n<li>Tweak: Improved License validation mechanism to avoid limitations<\\/li>\\n<li>Tweak: Added more units options to Border Width control in various elements<\\/li>\\n<li>Tweak: Added <code>em<\\/code> units to Border Radius control in various elements<\\/li>\\n<li>Tweak: Added \'Equal height\' functionality to Loop Grid widget<\\/li>\\n<li>Fix: Issue with Related Products widget and WooCommerce Pixel Manager plugin (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16934\\\">#16934<\\/a>)<\\/li>\\n<li>Fix: My Account widget gets hidden when using a single page template with post content (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19627\\\">#19627<\\/a>)<\\/li>\\n<li>Fix: Cart is not updated when cache enabled in Menu Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19312\\\">#19312<\\/a>)<\\/li>\\n<li>Fix: Entrance animations are not working as expected with Infinite Loop and Load on CLick pagination in Loop Grid widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/20293\\\">#20293<\\/a>)<\\/li>\\n<li>Fix: Loading page issues in Form Submissions screen (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19973\\\">#19973<\\/a>)<\\/li>\\n<li>Fix: Recently Edited date and time not working as expected in Elementor Overview plugin in WordPress dashboard (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17966\\\">#17966<\\/a>)<\\/li>\\n<li>Fix: Recurring license mismatch error message when using translators plugins<\\/li>\\n<li>Fix: Submenu items triggers page transition instead of opening in Nav Menu widget<\\/li>\\n<li>Fix: Query values of Posts widget are not imported correctly when importing a Kit<\\/li>\\n<li>Fix: Loop items are exceeding the widget boundaries in Loop Grid widget<\\/li>\\n<li>Fix: Order by option is not working as expected when choosing Upsells, Cross-Sells and Related Products query in Products widget<\\/li>\\n<li>Fix: Various widgets disappear in certain scenarios when choosing direction Row or Column in Container<\\/li>\\n<\\/ul>\\n<h4>3.8.2 - 2022-11-20<\\/h4>\\n<ul>\\n<li>Fix: Z-index issues when applying sticky to Container<\\/li>\\n<li>Fix: Error message appears on front with Editor and Shop Manager roles when using the Loop Builder widget<\\/li>\\n<\\/ul>\\n<h4>3.8.1 - 2022-11-06<\\/h4>\\n<ul>\\n<li>Fix: Sticky inner section is not staying in the column when applying sticky option in Sections (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/20203\\\">#20203<\\/a>)<\\/li>\\n<li>Fix: Post Title widget located in a loop item template disappears when enabling the hide title option inside page settings (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/20207\\\">#20207<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/20255\\\">#20255<\\/a>)<\\/li>\\n<li>Fix: ACF Dynamic data not rendering correctly in various scenarios (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/20235\\\">#20235<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/20258\\\">#20258<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/20277\\\">#20277<\\/a>)<\\/li>\\n<li>Fix: Z-index issues when applying sticky to Container (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/20227\\\">#20227<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.8.0 - 2022-10-30<\\/h4>\\n<ul>\\n<li>New: Introducing Loop Builder as a beta status experiment - Create powerful &amp; repeating loop templates and populate each one with dynamic content and design flexibility (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4440\\\">#4440<\\/a>)<\\/li>\\n<li>Tweak: Add <code>wp_body_open()<\\/code> to header in Header template (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11562\\\">#11562<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15828\\\">#15828<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13089\\\">#13089<\\/a>)<\\/li>\\n<li>Tweak: Added support border-radius option to the Code Highlight widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14316\\\">#14316<\\/a>)<\\/li>\\n<li>Tweak: Import\\/Export CLI and UI mechanisms were merged into a unified service<\\/li>\\n<li>Tweak: User with no permission to Notes cannot be mentioned in a note<\\/li>\\n<li>Tweak: User with no permission to view a post cannot be mentioned in a note<\\/li>\\n<li>Tweak: Notes was added to the right click context-menu<\\/li>\\n<li>Tweak: Notes panel can be resizable<\\/li>\\n<li>Tweak: Notes panel can be dragged outside of the canvas in responsive mode in the editor<\\/li>\\n<li>Tweak: Updated form validation messages translation strings in Form widget<\\/li>\\n<li>Tweak: Updated translators comments<\\/li>\\n<li>Tweak: Theme Builder logo and Title should be clickable<\\/li>\\n<li>Tweak: Reduced API requests and DB calls on non-write setup<\\/li>\\n<li>Tweak: Added media queries to the Table of Contents widget<\\/li>\\n<li>Fix: Sticky option is not working as expected in various scenarios in Container (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18357\\\">#18357<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19540\\\">#19540<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19618\\\">#19618<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19777\\\">#19777<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19827\\\">#19827<\\/a>)<\\/li>\\n<li>Fix: Mixed Content errors on HTTPS in Video Playlist Widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18895\\\">#18895<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18945\\\">#18945<\\/a>)<\\/li>\\n<li>Fix: Note\'s timestamp is being updated according to the last activity in Notes (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19123\\\">#19123<\\/a>)<\\/li>\\n<li>Fix: Accessibility attribute <code>role=navigation<\\/code> is redundant in Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17582\\\">#17582<\\/a>)<\\/li>\\n<li>Fix: Accessibility attribute <code>role=navigation<\\/code> is redundant in pagination in Posts widget<\\/li>\\n<li>Fix: Share buttons is accessible with keyboard but not clickable<\\/li>\\n<li>Fix: Sub-items icons style is missing in preview with Inline Font Icons experiment in Nav Menu widget<\\/li>\\n<li>Fix: Quotes are appearing as HTML when editing a note in Notes<\\/li>\\n<li>Fix: Label\'s Icon height increases when Inline Font Icons experiment is active in Hotspot Widget<\\/li>\\n<li>Fix: Sub conditions of templates are not overridden when importing a Kit<\\/li>\\n<li>Fix: X\\/Y Anchor Point controls were not visible for Scale and Rotate effects<\\/li>\\n<li>Fix: PHP warning notice appears in some situations when using motion effects<\\/li>\\n<\\/ul>\\n<h4>3.7.7 - 2022-09-20<\\/h4>\\n<ul>\\n<li>Fix: Default Flex Grow affects the layout when the container is set to direction Column in various widgets<\\/li>\\n<\\/ul>\\n<h4>3.7.6 - 2022-09-14<\\/h4>\\n<ul>\\n<li>Fix: Submissions menu item appears at the bottom of Elementor section in WordPress dashboard<\\/li>\\n<\\/ul>\\n<h4>3.7.5 - 2022-08-31<\\/h4>\\n<ul>\\n<li>Fix: Error message appears on front if WooCommerce is activated (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19553\\\">#19553<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.7.4 - 2022-08-29<\\/h4>\\n<ul>\\n<li>Tweak: PHP 5.6 Is deprecated<\\/li>\\n<li>Fix: Triangle icon is not being displayed in the Select field when Inline Font Icons Experiment is active in Form widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18598\\\">#18598<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19495\\\">#19495<\\/a>)<\\/li>\\n<li>Fix: The page jumps or flickers to the video playlist on page reload in Video Playlist Widget<\\/li>\\n<\\/ul>\\n<h4>3.7.3 - 2022-07-31<\\/h4>\\n<ul>\\n<li>Tweak: Improved license mechanism for correct validation<\\/li>\\n<li>Fix: Sticky option causes unexpected results when using the Container (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18357\\\">#18357<\\/a>)<\\/li>\\n<li>Fix: Price list, Portfolio, Flip Box and Gallery widgets disappear when the direction is set to column in Container (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18880\\\">#18880<\\/a>)<\\/li>\\n<li>Fix: Quotes character is showing up as <code>&amp;quot;<\\/code> when editing a note in Notes<\\/li>\\n<\\/ul>\\n<h4>3.7.2 - 2022-06-15<\\/h4>\\n<ul>\\n<li>Tweak: Applied optimized file handling in various modules<\\/li>\\n<li>Fix: Related posts query options are missing in Posts widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18633\\\">#18633<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18641\\\">#18641<\\/a>)<\\/li>\\n<li>Fix: Menu Cart Icon is not being displayed on all browsers when Inline Font Icons Experiment is active (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17705\\\">#17705<\\/a>)<\\/li>\\n<li>Fix: Gallery widget is not working as expected in Container element (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18408\\\">#18408<\\/a>)<\\/li>\\n<li>Fix: Flip box is not visible when the direction is set to Row in Container element (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18413\\\">#18413<\\/a>)<\\/li>\\n<li>Fix: Portfolio widget is not visible when dragged into &quot;Row&quot; direction Container element (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17653\\\">#17653<\\/a>)<\\/li>\\n<li>Fix: Menu cart is open automatically in Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18629\\\">#18629<\\/a>)<\\/li>\\n<li>Fix: PHP error is being shown the license is expired in License screen<\\/li>\\n<\\/ul>\\n<h4>3.7.1 - 2022-05-16<\\/h4>\\n<ul>\\n<li>Fix: Notes icon appears as an empty square in admin top bar for users with permissions lower than Editor<\\/li>\\n<li>Fix: Notes experiment causes a PHP fatal error on some cases<\\/li>\\n<li>Fix: UI glitches in Notes feature<\\/li>\\n<\\/ul>\\n<h4>3.7.0 - 2022-05-10<\\/h4>\\n<ul>\\n<li>New: Introducing Notes - Work collaboratively directly within Elementor<\\/li>\\n<li>New: Stripe Button widget - Collect Stripe payments directly from your site (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14748\\\">#14748<\\/a>)<\\/li>\\n<li>New: Meet WooCommerce Add to Cart dynamic tag - add products to cart from every widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10607\\\">#10607<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11801\\\">#11801<\\/a>)<\\/li>\\n<li>New: Added WooCommerce Product Content dynamic tag (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16367\\\">#16367<\\/a>)<\\/li>\\n<li>Tweak: Added Related, Upsells and Cross-Sells query sources to Products widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8071\\\">#8071<\\/a>)<\\/li>\\n<li>Tweak: Added custom icon control to Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18007\\\">#18007<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14357\\\">#14357<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13151\\\">#13151<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11361\\\">#11361<\\/a>)<\\/li>\\n<li>Tweak: Added an option to minimize on Desktop device in Table of Contents widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9933\\\">#9933<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic tag controls to Share Buttons widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10729\\\">#10729<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic tag controls to Media Carousel widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10314\\\">#10314<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic tag controls to Form widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6327\\\">#6327<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6691\\\">#6691<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11774\\\">#11774<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9051\\\">#9051<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic tag controls to Posts widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6327\\\">#6327<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic tag controls to Slides widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5760\\\">#5760<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9774\\\">#9774<\\/a>)<\\/li>\\n<li>Tweak: Added align button to bottom option in various Product widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10263\\\">#10263<\\/a>)<\\/li>\\n<li>Tweak: Added align button to bottom control in Posts and Archive Posts widgets<\\/li>\\n<li>Tweak: Added the ability to hide and show the coupon section in WooCommerce Cart widget<\\/li>\\n<li>Tweak: Added the ability to hide and show the coupon section in WooCommerce Checkout widget<\\/li>\\n<li>Tweak: Added alignment option to various buttons in WooCommerce Cart widget<\\/li>\\n<li>Tweak: Added alignment option to various buttons in WooCommerce Checkout widget<\\/li>\\n<li>Tweak: Added percentage unit to padding control in Additional Information customize section in WooCommerce Checkout widget<\\/li>\\n<li>Tweak: Added quick link to create new theme parts directly from the Finder<\\/li>\\n<li>Tweak: Added the option to add a custom template to Dashboard screen in My Account widget<\\/li>\\n<li>Tweak: Added spacing control to view cart button in various product widgets<\\/li>\\n<li>Tweak: Added the option to add a custom template to empty cart state in Cart widget<\\/li>\\n<li>Tweak: Adjusted the layout of the Payment Methods screen in the My Account widget<\\/li>\\n<li>Tweak: Added lazy load option to Media Carousel, Reviews and Testimonial Carousel widgets<\\/li>\\n<li>Tweak: Added Site Identity quick link to Logo widget<\\/li>\\n<li>Tweak: Added Site Identity quick link to Site Title widget<\\/li>\\n<li>Tweak: Created an attribute that allows disabling page transition for specific links<\\/li>\\n<li>Tweak: Added dynamic tag controls to Gallery widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Countdown widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Portfolio widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Price Table widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Login widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Blockquote widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Facebook Comments widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Post Navigation widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Search Form widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Author Box widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Post info widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Archive Posts widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Product Meta widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Archive Products widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Sitemap widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Reviews widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Code Highlight widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to PayPal Button widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to WooCommerce Checkout widget<\\/li>\\n<li>Tweak: Added missing PHP documentation to hooks<\\/li>\\n<li>Fix: Scrolling glitches on mobile devices when Sticky Effect is enabled (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17767\\\">#17767<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18330\\\">#18330<\\/a>)<\\/li>\\n<li>Fix: Only 1st honypot field is validated when using multiple honeypot fields in Forms widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18136\\\">#18136<\\/a>)<\\/li>\\n<li>Fix: Checkout button background color is not working as expected in Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18289\\\">#18289<\\/a>)<\\/li>\\n<li>Fix: Button labels are not accessible for screen readers in Share buttons widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8615\\\">#8615<\\/a>)<\\/li>\\n<li>Fix: Downloads titles controls are not working in responsive in WooCommerce Purchase Summary widget<\\/li>\\n<li>Fix: Excerpt length is not working as expected in Posts and Archive Posts widgets<\\/li>\\n<li>Fix: Titles &amp; Totals weight is not working in WooCommerce Checkout widget<\\/li>\\n<li>Fix: Product image is not appearing on Single Product Page on template load<\\/li>\\n<li>Fix: Additional Information title not editable in some scenarios in WooCommerce Checkout widget<\\/li>\\n<li>Fix: Cart is not updating automatically on mobile in Cart widget<\\/li>\\n<li>Fix: UI Glitch in Masonry control in Portfolio widget<\\/li>\\n<li>Fix: Custom breakpoints experiment didn\'t work on Single post and page templates<\\/li>\\n<li>Fix: Testimonial carousel &amp; Reviews widgets disregards the <code>alt<\\/code> attribute<\\/li>\\n<li>Fix: Playlist widget deeplink didn\'t send user directly to the widget in the page<\\/li>\\n<li>Fix: Masonry option causes the images to disappear in the Editor in Posts widget<\\/li>\\n<li>Fix: Scrollbar appears after clicking on the dropdown toggle in Nav Menu widget<\\/li>\\n<li>Fix: Custom icons disappear on frontend if the pack name contains numbers<\\/li>\\n<li>Fix: Custom Font disappears if the name contains only numbers<\\/li>\\n<li>Fix: <code>end-section()<\\/code> is missing from Progress Tracker and Facebook Embed widgets<\\/li>\\n<li>Tweak: Added a filter for conditions cache query in Theme Builder<\\/li>\\n<li>Fix: Customizations lost on Ajax refresh in WooCommerce Cart widget<\\/li>\\n<li>Fix: Hello theme Header and Footer experiment is not working when WooCommerce plugin is active<\\/li>\\n<li>Fix: Color controls are not working as expected in Checkout widget<\\/li>\\n<li>Fix: Color controls are not working as expected in My Account widget<\\/li>\\n<li>Fix: Empty state widget preview in the editor is disappearing in various widgets<\\/li>\\n<li>Fix: Cart is not updating automatically on mobile in WooCommerce Cart widget<\\/li>\\n<li>Deprecated: See all deprecations to this version in our <a href=\\\"https:\\/\\/developers.elementor.com\\/v3-7-planned-deprecations\\/\\\">Developers Deprecations Post<\\/a><\\/li>\\n<\\/ul>\\n<h4>3.6.5 - 2022-04-12<\\/h4>\\n<ul>\\n<li>Fix: Compatibility issues for several widgets in iOS 14 and macOS 13 devices (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18090\\\">#18090<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15910\\\">#15910<\\/a>)<\\/li>\\n<li>Fix: Button Alignment doesn\'t work in Custom Add To Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17810\\\">#17810<\\/a>)<\\/li>\\n<li>Fix: PHP warning is thrown in some cases in PayPal button widget<\\/li>\\n<li>Fix: PHP 8.1 throws errors and notices in some cases<\\/li>\\n<li>Fix: PHP notice was thrown when Kit Import process initiated without display conditions<\\/li>\\n<li>Fix: Create Account button always opens on the Sign Up screen even if the user has an account in Onboarding process<\\/li>\\n<\\/ul>\\n<h4>3.6.4 - 2022-03-15<\\/h4>\\n<ul>\\n<li>Tweak: Kit import dynamic reference support for templates and dynamic tags<\\/li>\\n<li>Tweak: Updated tested up to version tag to <code>3.6.0<\\/code><\\/li>\\n<li>Fix: Sticky caused scrolling issues after clicking an element that expands the page height (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17821\\\">#17821<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17839\\\">#17839<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18069\\\">#18069<\\/a>)<\\/li>\\n<li>Fix: When saving Global widget JS error is being thrown and editor fails to load (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17954\\\">#17954<\\/a>)<\\/li>\\n<li>Fix: Motion effects are missing from Background section under Style tab in Container element (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18063\\\">#18063<\\/a>)<\\/li>\\n<li>Fix: Imported Kit doesn\'t appear in the theme builder after successful import in some cases<\\/li>\\n<li>Fix: Added future Pro support to fix the Cart icon that shifted aside in Menu cart widget<\\/li>\\n<\\/ul>\\n<h4>3.6.3 - 2022-02-28<\\/h4>\\n<ul>\\n<li>Fix: Custom Code display conditions modal is not working (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17865\\\">#17865<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17942\\\">#17942<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17994\\\">#17994<\\/a>)<\\/li>\\n<li>Fix: Share buttons are not accessible for keyboard navigation (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8615\\\">#8615<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.6.2 - 2022-02-14<\\/h4>\\n<ul>\\n<li>Fix: Auto updates mechanism is not working as expected (this version might be also installed automatically)<\\/li>\\n<\\/ul>\\n<h4>3.6.1 - 2022-02-09<\\/h4>\\n<ul>\\n<li>Tweak: Allow connecting via generic source for future feature support<\\/li>\\n<li>Fix: Custom Code doesn\'t work when WooCommerce is active (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17675\\\">#17675<\\/a>)<\\/li>\\n<li>Fix: Content animation didn\'t work when Improved asset loading experiment is active Slides widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17055\\\">#17055<\\/a>)<\\/li>\\n<li>Fix: PHP warning appears some times when trying to force-check for available updates<\\/li>\\n<li>Fix: Page transitions are being triggered when not needed<\\/li>\\n<li>Fix: Text alignment on Tablet responsive device affects base device in Testimonial Carousel widget<\\/li>\\n<li>Fix: Harden Submissions feature to prevent potential security issues<\\/li>\\n<li>Fix: Page Transitions Icon option Preloader doesn\'t work on frontend<\\/li>\\n<\\/ul>\\n<h4>3.6.0 - 2022-01-31<\\/h4>\\n<ul>\\n<li>New: WooCommerce Purchase Summary widget - Fully customize the content and style of your order summary page (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5756\\\">#5756<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15862\\\">#15862<\\/a>)<\\/li>\\n<li>New: WooCommerce Notices styling on Site Settings - Customize the appearance of WooCommerce notices (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14570\\\">#14570<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15896\\\">#15896<\\/a>)<\\/li>\\n<li>New: WooCommerce Notices widget - Set the position of WooCommerce notices on your shop pages (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8124\\\">#8124<\\/a>)<\\/li>\\n<li>Experiment: Page Transitions - Customize the page loading experience, and increase brand recognition (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10576\\\">#10576<\\/a>)<\\/li>\\n<li>Tweak: Added WooCommerce &amp; Theme Elements widgets to Improved CSS Loading experiment to save up 126KB per page load (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17412\\\">#17412<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17337\\\">#17337<\\/a>)<\\/li>\\n<li>Tweak: Added new layout options in WooCommerce Add To Cart and WooCommerce Custom Add To Cart widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5437\\\">#5437<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10617\\\">#10617<\\/a>)<\\/li>\\n<li>Tweak: Added Stroke functionality for typography control in various widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11158\\\">#11158<\\/a>)<\\/li>\\n<li>Tweak: Removed <code>elementor-section-wrap<\\/code> by adding it to the Optimized DOM Output experiment (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16950\\\">#16950<\\/a>)<\\/li>\\n<li>Tweak: Added style controls for variations in WooCommerce Menu Cart widget<\\/li>\\n<li>Tweak: Added color control to navigation dots in Media Carousel, Reviews, and Slides widgets<\\/li>\\n<li>Tweak: Disabled Vimeo autoplay on edit mode when getting video data in Video Playlist widget<\\/li>\\n<li>Tweak: Added notice about Facebook\'s new EU consent policy in Facebook Button, Facebook Comments, Facebook Embed, and Facebook Page widgets<\\/li>\\n<li>Tweak: Refactor string translation calls to use native WP translation methods<\\/li>\\n<li>Tweak: Convert <code>home_url<\\/code> license API call to <code>get_site_url<\\/code> for better compatibility<\\/li>\\n<li>Tweak: Promoted Default to New Theme Builder and Scroll Snap experiments to Stable status in Experiments screen<\\/li>\\n<li>Tweak: Scroll Snap experiment set to active by default for all websites in Experiments screen<\\/li>\\n<li>Tweak: Scrolling Effects in Header and Section backgrounds are not working as expected when effects are relative to the entire page<\\/li>\\n<li>Tweak: Added &quot;Auto Updates&quot; capability to Pro versions<\\/li>\\n<li>Tweak: Removed sequenced animation hover effect option from Classic skin in Call to Action widget<\\/li>\\n<li>Tweak: Added &quot;Excerpt Length&quot; control in Post Excerpt widget<\\/li>\\n<li>Tweak: Deleted deprecated methods from Query Control module<\\/li>\\n<li>Tweak: Adjusted Inline-CSS Experiment to work with Additional Custom Breakpoints experiment<\\/li>\\n<li>Fix: Automatically open cart functionality didn\'t work in product page in WooCommerce Menu Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5921\\\">#5921<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16276\\\">#16276<\\/a>,<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16879\\\">#16879<\\/a>)<\\/li>\\n<li>Fix: Buttons are not visible when there are too many products in the cart in WooCommerce Menu Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16221\\\">#16221<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17283\\\">#17283<\\/a>,<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16333\\\">#16333<\\/a>,<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13005\\\">#13005<\\/a>)<\\/li>\\n<li>Fix: Mini cart modal z-index is too low in WooCommerce Menu Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16333\\\">#16333<\\/a>)<\\/li>\\n<li>Fix: Side cart buttons are not visible at first glance on mobile in WooCommerce Menu Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16221\\\">#16221<\\/a>)<\\/li>\\n<li>Fix: Read More field recognizes inline HTML elements as plain text in Posts and Archive Posts widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16985\\\">#16985<\\/a>)<\\/li>\\n<li>Fix: Load More functionality caused JS error console in Posts widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17036\\\">#17036<\\/a>)<\\/li>\\n<li>Fix: Autoplay is not working as expected when the lazy load is active in Video Playlist widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15304\\\">#15304<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16274\\\">#16274<\\/a>)<\\/li>\\n<li>Fix: Right navigation area wasn\'t 100% clickable in Post Navigation widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14252\\\">#14252<\\/a>)<\\/li>\\n<li>Fix: Posts duplicate when there are two Posts widgets inside a page using pagination functionality (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17056\\\">#17056<\\/a>)<\\/li>\\n<li>Fix: Global widget changes are not reflected on frontend (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16820\\\">#16820<\\/a>)<\\/li>\\n<li>Fix: JS Error console message when using the Load More functionality and Post Per Page option in Posts widget<\\/li>\\n<li>Fix: Heading styling is not being loaded when Inline CSS experiment is active in Post and Page Title widgets<\\/li>\\n<li>Fix: Sticky offset not working as expected when changing device mode on the browser<\\/li>\\n<li>Fix: Scroll Snap functionality wasn\'t applied on Templates and Archives<\\/li>\\n<li>Fix: Toggle icon color didn\'t work on hover state when Inline Font Icons experiment is activated in Nav Menu widget<\\/li>\\n<li>Fix: Variations style controls are not working as expected in WooCommerce Add to Cart widget<\\/li>\\n<li>Fix: Display conditions module is not working as expected when using the new Theme Builder UI<\\/li>\\n<li>Fix: Edit header handles <code>z-index<\\/code> issues in Header document<\\/li>\\n<li>Fix: Panel icons UI glitch in Call To Action widget<\\/li>\\n<li>Fix: WordPress 5.9 <code>WP_User_query<\\/code> <code>who<\\/code> argument deprecation adjustments<\\/li>\\n<\\/ul>\\n<h4>3.5.2 - 2021-11-28<\\/h4>\\n<ul>\\n<li>Tweak: Adjusted license mechanism to support trial period<\\/li>\\n<li>Fix: Updates made to Global Widgets do not reflect accordingly to linked widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16815\\\">#16815<\\/a>)<\\/li>\\n<li>Fix: Hamburger toggle button doesn\'t change to \\u201cclose\\u201d when menu is collapsed in Nav Menu widget when Inline Font Awesome experiment is active<\\/li>\\n<li>Fix: Global Widget cannot be unlinked<\\/li>\\n<\\/ul>\\n<h4>3.5.1 - 2021-11-10<\\/h4>\\n<ul>\\n<li>Fix: Inline HTML elements appear as plain text in Animated Headline widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16816\\\">#16816<\\/a>)<\\/li>\\n<li>Fix: Dropdown items inherited values from Main Menu space between control in Nav Menu widget (<a href=\\\"(https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16815)\\\">#16815<\\/a><\\/li>\\n<li>Fix: Order Summary titles style controls not applying on various devices in Cart widget<\\/li>\\n<li>Fix: Panel &quot;Need Help&quot; link is not correct in WooCommerce section in Site Settings<\\/li>\\n<\\/ul>\\n<h4>3.5.0 - 2021-11-01<\\/h4>\\n<ul>\\n<li>New: WooCommerce Checkout widget - Fully customize the content and style of your checkout page (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15282\\\">#15282<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15990\\\">#15990<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11014\\\">#11014<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13218\\\">#13218<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5383\\\">#5383<\\/a>)<\\/li>\\n<li>New: WooCommerce Cart widget - Style your cart page the way you want with design flexibility (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15282\\\">#15282<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11014\\\">#11014<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13218\\\">#13218<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5383\\\">#5383<\\/a>)<\\/li>\\n<li>New: WooCommerce My Account widget - Create a custom design for your my account pages (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11014\\\">#11014<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5383\\\">#5383<\\/a>)<\\/li>\\n<li>New: Progress Tracker widget - Motivate your customers to keep reading your site content (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16576\\\">#16576<\\/a>)<\\/li>\\n<li>New: Meet WooCommerce Site Settings - Set your store pages within Elementor<\\/li>\\n<li>Experiment: Scroll Snap - Set the scene of every scroll (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10752\\\">#10752<\\/a>)<\\/li>\\n<li>Tweak: Changed infrastructure to prevent rendering bugs in Global Widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16354\\\">#16354<\\/a>)<\\/li>\\n<li>Tweak: Added the option to open submission in a new tab in Form Submissions (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14967\\\">#14967<\\/a>)<\\/li>\\n<li>Tweak: Added various responsive controls in Posts widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1851\\\">#1851<\\/a>)<\\/li>\\n<li>Tweak: Split Title and Price styling controls in Price List widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7688\\\">#7688<\\/a>)<\\/li>\\n<li>Tweak: Added various responsive capabilities to controls in Posts Archive widget<\\/li>\\n<li>Tweak: Adjusted Motion Effects module to support future feature<\\/li>\\n<li>Tweak: Changed admin notice content when Pro installed without Core installed<\\/li>\\n<li>Tweak: Cleanup in <code>wp_options<\\/code> table<\\/li>\\n<li>Tweak: Changed Connect logic in Elementor top bar to simplify the connect process<\\/li>\\n<li>Tweak: Marked new Theme Builder as an Experiment and set to default for new sites<\\/li>\\n<li>Tweak: Enforced better security policies in various widgets and modules<\\/li>\\n<li>Tweak: Added load more button functionality to the Posts Archive widget<\\/li>\\n<li>Tweak: Renamed Elementor\'s responsive SCSS variables<\\/li>\\n<li>Tweak: Added dividers to horizontal layout in Nav Menu widget<\\/li>\\n<li>Tweak: Removed Google+ social network from Share Buttons widget<\\/li>\\n<li>Tweak: Convert usage of old Responsive class to use the new Breakpoints Manager<\\/li>\\n<li>Fix: jQuery in Heading doesn\'t work for not logged in users in Custom Code (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14515\\\">#14515<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14266\\\">#14266<\\/a>)<\\/li>\\n<li>Fix: Menu animation causing page horizontal scroll in Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15184\\\">#15184<\\/a>)<\\/li>\\n<li>Fix: Wrong function call in Table of Content &amp; Post Excerpt widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16547\\\">#16547<\\/a>)<\\/li>\\n<li>Fix: Slides to Scroll control can\'t be set to Default if Widescreen mode has a value in Testimonial Carousel widget<\\/li>\\n<li>Fix: Sticky offset not working properly when changing device mode<\\/li>\\n<li>Fix: UTF character issues when exporting CSV file in Form Submissions<\\/li>\\n<li>Fix: Load More functionality doesn\'t work when the Posts widget placed inside an Archive template<\\/li>\\n<li>Fix: UI glitches and editing issues in Video Playlist widget<\\/li>\\n<\\/ul>\\n<h4>3.4.2 - 2021-10-12<\\/h4>\\n<ul>\\n<li>Fix: Icons color style conflicts when Font-Awesome Inline experiment is active in Share Buttons widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16435\\\">#16435<\\/a>)<\\/li>\\n<li>Fix: Mini Cart hides page content when closed in Menu Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16305\\\">#16305<\\/a>)<\\/li>\\n<li>Fix: UI glitches in the Editor edit mode when inserting Post Content widget and Font-Awesome Inline experiment is active in Single Post template (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16358\\\">#16358<\\/a>)<\\/li>\\n<li>Fix: Slides per view controls disappeared from multiple breakpoints in Testimonial Carousel<\\/li>\\n<li>Fix: Product variations UI glitch in Menu Cart widget<\\/li>\\n<li>Fix: Buttons UI glitch on Safari browser in Menu Cart widget<\\/li>\\n<\\/ul>\\n<h4>3.4.1 - 2021-09-01<\\/h4>\\n<ul>\\n<li>Fix: Sticky functionality is not working if the Additional Custom Breakpoints experiment is active (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16186\\\">#16186<\\/a>)<\\/li>\\n<li>Fix: Slideshow skin UI glitch in Media Carousel widget<\\/li>\\n<li>Fix: Product price typography weight control is not working as expected in Menu Cart widget<\\/li>\\n<\\/ul>\\n<h4>3.4.0 - 2021-09-01<\\/h4>\\n<ul>\\n<li>Tweak: Added new Mini Cart layout type in Menu Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11312\\\">#11312<\\/a>)<\\/li>\\n<li>Tweak: Added styling options for Cart, Products, and Cart buttons in Menu Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14952\\\">#14952<\\/a>)<\\/li>\\n<li>Tweak: Added the ability to open cart automatically when an item is added in Menu Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14119\\\">#14119<\\/a>)<\\/li>\\n<li>Tweak: Added the ability to remove an item from cart without reloading the page with an AJAX request (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9531\\\">#9531<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10875\\\">#10875<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11309\\\">#11309<\\/a>)<\\/li>\\n<li>Tweak: Added Load More AJAX functionality to Posts widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12126\\\">#12126<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1284\\\">#1284<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14557\\\">#14557<\\/a>)<\\/li>\\n<li>Tweak: Added Vimeo support to the Video Playlist widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15319\\\">#15319<\\/a>)<\\/li>\\n<li>Tweak: Improved asset loading performance by serving lighter JS files (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8572\\\">#8572<\\/a>)<\\/li>\\n<li>Tweak: Added query string to the URL only after the first video is played in Video Playlist widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15348\\\">#15348<\\/a>)<\\/li>\\n<li>Tweak: Added various layout options with more responsive controls and cart structure options in Menu Cart widget<\\/li>\\n<li>Tweak: Added the option to open the menu cart by click or hover in Menu Cart widget<\\/li>\\n<li>Tweak: Added the ability to choose a specific product to draw data from in WooCommerce Dynamic tags<\\/li>\\n<li>Tweak: Removed auto-scroll to the widget location when arriving from external URL in Video Playlist widget<\\/li>\\n<li>Tweak: Removed the Video Playlist widget from the Experiments list<\\/li>\\n<li>Tweak: Added descriptive error messages for MailChimp action after submit and on form submit in Forms widget<\\/li>\\n<li>Tweak: Added tooltip trigger None and Hover for link in Hotspot widget<\\/li>\\n<li>Tweak: Added responsive controls to Offset and Effects Offset in Sticky options<\\/li>\\n<li>Tweak: Added responsive control to Alignment in Testimonial Carousel widget<\\/li>\\n<li>Tweak: Adjusted Motion Effects module to support future feature<\\/li>\\n<li>Tweak: Added future compatibility to support better loading of <code>eicons<\\/code> font<\\/li>\\n<li>Tweak: Changed Rename Part title and button color in Theme Builder<\\/li>\\n<li>Fix: Products don\'t appear on the cart while editing in Menu Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15451\\\">#15451<\\/a>)<\\/li>\\n<li>Fix: Videos always start muted in the Video Playlist widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15292\\\">#15292<\\/a>)<\\/li>\\n<li>Fix: Unnecessary spacing if submenu indicator is set to None in Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15365\\\">#15365<\\/a>)<\\/li>\\n<li>Fix: MailChimp double opt-in feature doesn\'t work in Forms widget<\\/li>\\n<li>Fix: Fetching MailChimp groups field blocks the loading of the rest of the fields in the Form widget<\\/li>\\n<li>Fix: Missing field IDs causes forms not to be sent in Forms widget<\\/li>\\n<li>Fix: Full Content Skin is not working properly when inserted twice on the same page in Posts widget<\\/li>\\n<li>Fix: Avoid Duplicates option doesn\'t exclude manual selections in Posts widget<\\/li>\\n<li>Fix: Submenu indicator alignment issue in Nav menu widget<\\/li>\\n<li>Fix: Query control deprecated message appears when debug mode is defined<\\/li>\\n<li>Fix: Tweet Button icon incorrect color and size when the icon is rendered as SVG in Blockquote widget<\\/li>\\n<li>Fix: Video icon size is not changing on Active state in Video Playlist widget<\\/li>\\n<li>Fix: Header icon color is not working in Table Of Content widget<\\/li>\\n<li>Fix: Icons style glitches when Font Awesome Inline experiment is active in Video Playlist widget<\\/li>\\n<li>Fix: Bullet markers are not visible on preview mode when Font Awesome Inline experiment is active in Table of Content widget<\\/li>\\n<li>Fix: UI Glitch when Font-Awesome Inline experiment is active in Price Table widget<\\/li>\\n<li>Fix: Submenu Indicator appears larger when Font Awesome Inline experiment is active in Nav Menu widget<\\/li>\\n<li>Fix: Part name is deleted when clicking on the &quot;Change&quot; Button without changing the name in Theme Builder<\\/li>\\n<li>Fix: Redundant pagination queries in the Editor<\\/li>\\n<li>Deprecated: Remove all usages of <code>ElementorUtils::get_create_new_post_url()<\\/code><\\/li>\\n<li>Deprecated: See all deprecations to this version in our <a href=\\\"https:\\/\\/developers.elementor.com\\/v3-4-planned-deprecations\\/\\\">Developers Deprecations Post<\\/a><\\/li>\\n<\\/ul>\\n<h4>3.3.8 - 2021-08-23<\\/h4>\\n<ul>\\n<li>Fix: Products grid width issue when adjusting columns and rows in Products widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16001\\\">#16001<\\/a>)<\\/li>\\n<li>Fix: Font Awesome Inline experiment causes icons glitch in Price Table widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16045\\\">#16045<\\/a>)<\\/li>\\n<li>Fix: reCAPTCHA v3 <code>z-index<\\/code> is lower than the Section\'s background color<\\/li>\\n<li>Fix: Style missing when Font Awesome inline experiment is active in Post Info widget<\\/li>\\n<li>Fix: Font Awesome icons were not loaded in Post Info widget<\\/li>\\n<li>Fix: Zero character can\'t be used as a placeholder in Number field in Form widget<\\/li>\\n<li>Fix: Carousels are not working properly in the Editor when Additional Custom Breakpoints experiment is active<\\/li>\\n<\\/ul>\\n<h4>3.3.7 - 2021-08-15<\\/h4>\\n<ul>\\n<li>Tweak: Added support for Additional Custom Breakpoints in Nav Menu widget<\\/li>\\n<li>Tweak: Added support for Additional Custom breakpoints in Motion Effects<\\/li>\\n<li>Fix: Columns didn\'t respond to changes in Gallery widget if Additional Custom Breakpoints Experiment is active<\\/li>\\n<\\/ul>\\n<h4>3.3.6 - 2021-08-10<\\/h4>\\n<ul>\\n<li>Tweak: Added support for future feature in Nav Menu widget<\\/li>\\n<li>Fix: WooCommerce responsive grid styles are not being reflected in Product Related widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15857\\\">#15857<\\/a>)<\\/li>\\n<li>Fix: WooCommerce responsive grid styles are not being reflected in Upsells widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15857\\\">#15857<\\/a>)<\\/li>\\n<li>Fix: WooCommerce responsive grid styles are not being reflected in Product Categories widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15857\\\">#15857<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.3.5 - 2021-08-01<\\/h4>\\n<ul>\\n<li>Fix: Responsive layout glitches in Products and Products Archive widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15773\\\">#15773<\\/a>)<\\/li>\\n<li>Fix: reCAPTCHA V3 integration conflict with required fields validation in Forms widget<\\/li>\\n<\\/ul>\\n<h4>3.3.4 - 2021-07-21<\\/h4>\\n<ul>\\n<li>Fix: Grid layout glitch in WooCommerce Products Archive widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15718\\\">#15718<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.3.3 - 2021-07-20<\\/h4>\\n<ul>\\n<li>Tweak: Added a descriptive message in Collect Submissions action after submit<\\/li>\\n<li>Tweak: Added future compatibility for Additional Custom Breakpoints for Pro widgets<\\/li>\\n<li>Fix: Some widget style breaks when Improved CSS Loading Experiment is active in certain cases (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15632\\\">#15632<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15683\\\">#15683<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15660\\\">#15660<\\/a>)<\\/li>\\n<li>Fix: Translation update keep appearing as available after install (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14297\\\">#14297<\\/a>)<\\/li>\\n<li>Fix: Wrong default icon color when using Font Awesome icons as inline SVG in Call to Action widget<\\/li>\\n<\\/ul>\\n<h4>3.3.2 - 2021-07-13<\\/h4>\\n<ul>\\n<li>Tweak: Updated plugin description<\\/li>\\n<li>Fix: MailChimp tags in form widget replaced existing tags (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11111\\\">#11111<\\/a>)<\\/li>\\n<li>Fix: Clicking videos from the items list in edit mode doesn\\u2019t initiate videos properly<\\/li>\\n<li>Fix: User unauthorized message when activated but not connected in Kit Library<\\/li>\\n<li>Fix: Carousel widgets did not support additional custom breakpoint responsive values<\\/li>\\n<li>Fix: Tab border is overridden by the Section background color in Video Playlist widget<\\/li>\\n<li>Fix: Widgets style breaks when Improved CSS Load experiment is active in a Single Page template and Post Content widget<\\/li>\\n<\\/ul>\\n<h4>3.3.1 - 2021-06-20<\\/h4>\\n<ul>\\n<li>Tweak: Added support for more Theme Builder display conditions in Export \\/ Import experiment<\\/li>\\n<li>Tweak: Adjusted License page heading structure for future feature<\\/li>\\n<li>Tweak: Adjusted Font Awesome icon for allowing support for future feature<\\/li>\\n<li>Fix: <code>frontend.min.js<\\/code> file size increased in Elementor Pro 3.3.0 (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15278\\\">#15278<\\/a>)<\\/li>\\n<li>Fix: Prevent conditions from being reset when object cache is enabled in site (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13299\\\">#13299<\\/a>)<\\/li>\\n<li>Fix: Custom Code publish modal responsiveness issues (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14519\\\">#14519<\\/a>)<\\/li>\\n<li>Fix: Populating fields with options programmatically doesn\'t appear in Submissions screen (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10671\\\">#10671<\\/a>)<\\/li>\\n<li>Fix: Large images are not shown on the Image Carousel widget when set via Toolset dynamic tag<\\/li>\\n<li>Fix: Enable inline editing to the inner content tabs in Video Playlist widget<\\/li>\\n<li>Fix: Clicking on the video list doesn\'t play videos properly in Video Playlist widget<\\/li>\\n<li>Fix: Hide Play Icon control when Image overlay is toggled off in Video Playlist widget<\\/li>\\n<li>Fix: Removed extra space below the player when viewing from mobile view in Video Playlist widget<\\/li>\\n<li>Fix: Import button is not working properly in Theme Builder interface<\\/li>\\n<li>Fix: Preview Dynamic Content as control is not updating preview and throws an error in Popup Builder<\\/li>\\n<\\/ul>\\n<h4>3.3.0 - 2021-06-08<\\/h4>\\n<ul>\\n<li>New: Video Playlist widget - Add Engaging Video Content to Your Website (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11859\\\">#11859<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7803\\\">#7803<\\/a>)<\\/li>\\n<li>New: Hotspot widget - Create Interactive Images With Contextually Relevant Information (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7282\\\">#7282<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2768\\\">#2768<\\/a>)<\\/li>\\n<li>Tweak: Accessibility improvements for sub-menus in Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13859\\\">#13859<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13810\\\">#13810<\\/a>)<\\/li>\\n<li>Tweak: MailChimp action after submit can now add new tags to existing subscribers in Forms widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11111\\\">#11111<\\/a>)<\\/li>\\n<li>Tweak: Added <code>elementor_pro\\/forms\\/record\\/actions_before<\\/code> to filter the record before it sent to Actions After Submit in Forms widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14261\\\">#14261<\\/a>)<\\/li>\\n<li>Tweak: Yoast SEO breadcrumbs widget can be used in Elementor without the need of enabling them in Yoast setting<\\/li>\\n<li>Tweak: Added future support for widgets CSS conditional loading (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10329\\\">#10329<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14229\\\">#14229<\\/a>)<\\/li>\\n<li>Tweak: Added future support for Sticky JS library conditional loading<\\/li>\\n<li>Tweak: Added future support for Import \\/ Export experiment<\\/li>\\n<li>Tweak: Preparations and fixes for Import Export Experiment in Pro version<\\/li>\\n<li>Tweak: Added gradient button capabilities to Login widget buttons<\\/li>\\n<li>Tweak: Added gradient button capabilities to Slides widget button<\\/li>\\n<li>Tweak: Added gradient button capabilities to Price Table widget button<\\/li>\\n<li>Tweak: Added gradient button capabilities to Flip Box widget button<\\/li>\\n<li>Tweak: Added Code Highlight widget Developers Documentation<\\/li>\\n<li>Tweak: Adjusted Submissions page for future updates<\\/li>\\n<li>Tweak: Added <code>em<\\/code> and <code>%<\\/code> units for padding control in Carousel widgets<\\/li>\\n<li>Tweak: Shorten currency name to currency symbol in PayPal button widget<\\/li>\\n<li>Fix: Custom Fonts URLs should be replaced when replace URL is triggered (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7376\\\">#7376<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10382\\\">#10382<\\/a>)<\\/li>\\n<li>Fix: The currency symbol size changed in the Price Table widget if enabling sale (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13519\\\">#13519<\\/a>)<\\/li>\\n<li>Fix: Nav Menu widget is not loading Font Awesome submenu icons (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9907\\\">#9907<\\/a>)<\\/li>\\n<li>Fix: Hamburger toggle is not working in Nav menu widget<\\/li>\\n<li>Fix: Activation bug for IDN domains<\\/li>\\n<li>Fix: Conditions modal responsive glitches in Custom Code<\\/li>\\n<li>Fix: Duplicated strings in Custom Code module<\\/li>\\n<li>Fix: Enable resize option for code input field in Custom Code<\\/li>\\n<li>Fix: \\u201cSave &amp; Close \\u201cbutton in Custom Code\'s Conditions modal was not visible on small screen sizes<\\/li>\\n<li>Fix: Removing a column from a section in the navigator resulted in an empty section<\\/li>\\n<li>Fix: Recommend option is cut If the layout is not &quot;Standard&quot; in the Facebook Button widget<\\/li>\\n<li>Fix: Video item does not play without adding an image in Media Carousel widget<\\/li>\\n<li>Fix: <code>search-plus<\\/code> icon missing from panel in Media Carousel widget<\\/li>\\n<li>Fix: UI hover state glitch in Media Carousel widget<\\/li>\\n<li>Fix: PHP notice was thrown when trying to import a kit without overrideConditions parameter in Kit Import flow<\\/li>\\n<li>Fix: Templates conditions not imported if there are no conflicts in Import Export Experiment<\\/li>\\n<li>Fix: Non english values are not encoded properly on Submissions export<\\/li>\\n<li>Fix: Theme Builder import is not working properly<\\/li>\\n<li>Fix: UI glitch when no global widgets were found in Editor Panel<\\/li>\\n<li>Deprecated: See all deprecations to this version in our <a href=\\\"https:\\/\\/developers.elementor.com\\/v3-3-planned-deprecations\\/\\\">Developers Deprecations Post<\\/a><\\/li>\\n<\\/ul>\\n<h4>3.2.2 - 2021-05-05<\\/h4>\\n<ul>\\n<li>Tweak: Added support for Expert tier templates in Templates Library<\\/li>\\n<li>Tweak: Updated compatibility tag to support Elementor v3.2.x<\\/li>\\n<li>Tweak: Added compatibility for future Library improvements<\\/li>\\n<li>Fix: Toolset image dynamic field is not working with Gallery widget<\\/li>\\n<\\/ul>\\n<h4>3.2.1 - 2021-03-21<\\/h4>\\n<ul>\\n<li>Tweak: Added strings context in PayPal button and Price Table widgets<\\/li>\\n<li>Tweak: Added support for future Import \\/ Export Kit feature<\\/li>\\n<li>Fix: Submissions with over than 191 characters weren\'t indexed properly<\\/li>\\n<\\/ul>\\n<h4>3.2.0 - 2021-03-14<\\/h4>\\n<ul>\\n<li>New: PayPal Button widget - Collect PayPal payments directly from your site<\\/li>\\n<li>Experiment: Submissions - Save all of your form submissions in one place (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1686\\\">#1686<\\/a>)<\\/li>\\n<li>Tweak: Added Stay In Column option to Inner Section element (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7956\\\">#7956<\\/a>)<\\/li>\\n<li>Tweak: Adjusted \'Max Height\' control range in Table of Contents widget<\\/li>\\n<li>Tweak: Changed descriptive text in Create Custom Code screen<\\/li>\\n<li>Tweak: Added support for dynamic capabilities in Code Highlight widget<\\/li>\\n<li>Tweak: Added support for future load on demand for <code>share-link<\\/code> library<\\/li>\\n<li>Tweak: Added support for future load on demand for <code>dialog<\\/code> library in Popup<\\/li>\\n<li>Tweak: Allow overwriting the assets URL when using a mirror domain<\\/li>\\n<li>Fix: Animation was triggered multiple times when accessing the viewport in certain cases in Animated Headline widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13951\\\">#13951<\\/a>)<\\/li>\\n<li>Fix: Location is not being updated after a Custom Code snippet is published (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13971\\\">#13971<\\/a>)<\\/li>\\n<li>Fix: Custom Fonts CSS files were not updated after regenerating CSS files<\\/li>\\n<li>Fix: Conditions modal is not responsive in Custom Code<\\/li>\\n<li>Fix: Empty order buttons are displayed in Custom Fonts screen<\\/li>\\n<li>Fix: Typo in \'Reply To\' Email action after submit placeholder in Forms widget<\\/li>\\n<li>Fix: Unnecessary Save Draft button in Custom Code<\\/li>\\n<li>Fix: RTL glitches in Custom Code<\\/li>\\n<li>Fix: Sanitized options in the editor to enforce better security policies<\\/li>\\n<li>Deprecated: See all deprecations to this version in our (<a href=\\\"https:\\/\\/developers.elementor.com\\/v3-2-planned-deprecations\\/\\\">Developers Deprecations Post<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.1.1 - 2021-02-23<\\/h4>\\n<ul>\\n<li>Tweak: Adjusted \'Max Height\' control range in Table of Contents widget<\\/li>\\n<li>Fix: Popup event handler is undefined (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11475]\\\">#11475<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10690\\\">#10690<\\/a>)<\\/li>\\n<li>Fix: Conditions modal is not responsive in Custom Code<\\/li>\\n<li>Fix: RTL glitches in Code Highlight widget<\\/li>\\n<li>Fix: Minor UI glitches in Code Highlight widget<\\/li>\\n<li>Fix: Users can\'t get Pro Developer Edition version updates<\\/li>\\n<\\/ul>\\n<h4>3.1.0 - 2021-02-13<\\/h4>\\n<ul>\\n<li>New: Introducing Custom Code - Add custom code snippets to your site, including <code>head<\\/code>, <code>body<\\/code> start and <code>body<\\/code> end<\\/li>\\n<li>New: Meet Code Highlight widget - showcase any syntax with highlighted UI (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5815\\\">#5815<\\/a>)<\\/li>\\n<li>Experiment: Improved Pro widgets performance by loading JS and Swiper assets conditionally in frontend (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8572\\\">#8572<\\/a>, <a href=\\\"https:\\/\\/developers.elementor.com\\/experiment-optimized-asset-loading\\/\\\">Developer Documentation<\\/a>)<\\/li>\\n<li>Tweak: Added Compatibility Tag support in Elementor Pro (<a href=\\\"https:\\/\\/developers.elementor.com\\/compatibility-tag\\/\\\">Developer Documentation<\\/a>)<\\/li>\\n<li>Tweak: Added Dynamic capabilities to Rotating Text animation in Animated Headline widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4625\\\">#4625<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8569\\\">#8569<\\/a>)<\\/li>\\n<li>Tweak: Added an option to set Selected color for Typing effect in Animated Headline widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5403\\\">#5403<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7826\\\">#7826<\\/a>)<\\/li>\\n<li>Tweak: Added animation Loop option for Animated Headline (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9749\\\">#9749<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2457\\\">#2457<\\/a>)<\\/li>\\n<li>Tweak: Added timing options for Animated Headline widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4392\\\">#4392<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic capabilities for Testimonial Carousel widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8569\\\">#8569<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic capabilities for Price Table widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4242\\\">#4242<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8569\\\">#8569<\\/a>)<\\/li>\\n<li>Tweak: Added Word Wrap control to Code Highlight widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13577\\\">#13577<\\/a>)<\\/li>\\n<li>Tweak: Upgraded Font Awesome Pro library to v5.15.1<\\/li>\\n<li>Tweak: Improved method of loading field mapping repeater in Form widget (<a href=\\\"https:\\/\\/developers.elementor.com\\/how-to-add-a-repeater-control-to-elementor-add-on\\/\\\">Developer Documentation<\\/a>)<\\/li>\\n<li>Tweak: Added &quot;Show on Browsers&quot; Popup Advanced Rule<\\/li>\\n<li>Tweak: Added real-time JS handling to prevent redundant renders in Slides widget and all Carousel widgets<\\/li>\\n<li>Tweak: Import scroll utility from core and remove it from Pro<\\/li>\\n<li>Tweak: Added alignment options for Post Excerpt widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9757\\\">#9757<\\/a>)<\\/li>\\n<li>Tweak: Changed alignment control to work with selectors in Share Buttons<\\/li>\\n<li>Tweak: Upgraded to Webpack 5, Grunt-Webpack 4 and TerserPlugin instead of UglifyJsPlugin<\\/li>\\n<li>Fix: Steps Divider is not vertically aligned in Multi Step Form widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12569\\\">#12569<\\/a>)<\\/li>\\n<li>Fix: Slides are playing in an infinite loop mode even when the option is disabled in Slides Widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6726\\\">#6726<\\/a>)<\\/li>\\n<li>Fix: Redundant spacing is added to Share Buttons widget<\\/li>\\n<li>Fix: Step buttons text is not updated without a page reload in Forms widget<\\/li>\\n<li>Fix: Overflow issue in certain animations in Animated Headline widget<\\/li>\\n<li>Fix: When dragging a new Testimonial Carousel there is a console error thrown<\\/li>\\n<li>Fix: Step Buttons are cut in mobile view in Multi Step Form<\\/li>\\n<li>Fix: Submit and Step buttons size differences when using Twenty Twenty theme<\\/li>\\n<li>Fix: Duplicate button Text Color control in Slides widget<\\/li>\\n<li>Fix: JS error is thrown when editing and saving global widgets<\\/li>\\n<li>Fix: <code>get_version<\\/code> API function may fail with Redis \\/ DB cache<\\/li>\\n<li>Fix: Multiple license check requests are created in certain cases<\\/li>\\n<li>Deprecated: Deprecate methods prefixed with an underscore and replace them with unprefixed methods<\\/li>\\n<li>Deprecated: See all deprecations to this version in our <a href=\\\"https:\\/\\/developers.elementor.com\\/v3-1-planned-deprecations\\/\\\">Developers Deprecations Post<\\/a><\\/li>\\n<\\/ul>\\n<h4>3.0.10 - 2021-01-20<\\/h4>\\n<ul>\\n<li>Tweak: Added Editing Handles string translation compatibility with Elementor v3.1.0<\\/li>\\n<\\/ul>\\n<h4>3.0.9 - 2020-12-29<\\/h4>\\n<ul>\\n<li>Tweak: Added compatibility to support Elementor 3.1.0<\\/li>\\n<li>Fix: Wrong phrasing of Import template success message in Theme Builder<\\/li>\\n<li>Fix: Border color glitch in Theme Builder<\\/li>\\n<\\/ul>\\n<h4>3.0.8 - 2020-11-26<\\/h4>\\n<ul>\\n<li>Fix: Navigation arrows UI glitch in Media Carousel widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13172\\\">#13172<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.0.7 - 2020-11-25<\\/h4>\\n<ul>\\n<li>Fix: Console Error when dragging  Testimonials Carousel widget<\\/li>\\n<li>Fix: Arrows of Testimonial and Reviews Carousel widgets navigate to the wrong direction in RTL websites<\\/li>\\n<li>Fix: Removed the conditional loading of Webpack<\\/li>\\n<li>Fix: Fatal error is thrown after deleting an associated custom taxonomy when Posts widget with Cards skin has a badge<\\/li>\\n<li>Fix: Upload JSON files only when the user allowed to prevent security issues<\\/li>\\n<li>Fix: Gallery not displayed in Theme Builder templates preview<\\/li>\\n<\\/ul>\\n<h4>3.0.6 - 2020-11-04<\\/h4>\\n<ul>\\n<li>Tweak: Updated the embedded post in Facebook Embed widget<\\/li>\\n<li>Fix: Minor UI glitches in Theme Builder\'s conditions screen footer<\\/li>\\n<li>Fix: Template type changes into Single Page after conditions change in Theme Builder<\\/li>\\n<li>Fix: Redundant Custom Caption option in Site Logo widget<\\/li>\\n<li>Fix: Removed unused code in Drip integration<\\/li>\\n<li>Fix: Removed Weibo and WeChat social networks due to website and links inactivity from Share Buttons widget<\\/li>\\n<li>Fix: Removed redundant code from Portfolio and Post Navigation widgets<\\/li>\\n<\\/ul>\\n<h4>3.0.5 - 2020-09-23<\\/h4>\\n<ul>\\n<li>Fix: If the default page layout is set to &quot;Canvas&quot; Headers and Footers cannot be edited<\\/li>\\n<li>Fix: Product Image Dynamic Tag throws an error when no image is set<\\/li>\\n<li>Fix: Missing Single document placeholder in Theme Builder<\\/li>\\n<li>Fix: Document editing handles inherit the <code>font-family<\\/code> from 3rd party source<\\/li>\\n<li>Fix: Can\'t add linebreaks to Textarea input when used as Multi Step Form<\\/li>\\n<li>Fix: Incorrect width in Facebook Page widget<\\/li>\\n<li>Fix: Added compatibility to allow the use of \'get_create_url\' in Theme Builder<\\/li>\\n<\\/ul>\\n<h4>3.0.4 - 2020-09-09<\\/h4>\\n<ul>\\n<li>Fix: Autogenerated screenshots appear in WP Media Library modal (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12304\\\">#12304<\\/a>)<\\/li>\\n<li>Fix: Make sure Elementor Posts widget Pagination doesn\'t interfere with 3rd party plugins (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12126\\\">#12126<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12127\\\">#12127<\\/a>)<\\/li>\\n<li>Fix: Shrinking conditions indicator in Theme Builder<\\/li>\\n<li>Fix: Column can\'t be dragged and dropped if it populates a Global widget<\\/li>\\n<li>Fix: Styles are missing from Single templates in some edge cases<\\/li>\\n<\\/ul>\\n<h4>3.0.3 - 2020-09-02<\\/h4>\\n<ul>\\n<li>Fix: Pagination doesn\'t work in WordPress 5.5 (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12126\\\">#12126<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12127\\\">#12127<\\/a>)<\\/li>\\n<li>Fix: Change delete template action to &quot;Move to Trash&quot; in the new Theme Builder view<\\/li>\\n<\\/ul>\\n<h4>3.0.2 - 2020-08-31<\\/h4>\\n<ul>\\n<li>Tweak: Replaced WordPress &quot;Learn More&quot; links with dynamic links for better control over time (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12312\\\">#12312<\\/a>)<\\/li>\\n<li>Tweak: UI tweaks to the Conditions screen In the new Theme Builder<\\/li>\\n<li>Fix: Motion Effects not working when assigned to a column and throws JS error when DOM optimization is disabled (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12299\\\">#12299<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12275\\\">#12275<\\/a>)<\\/li>\\n<li>Fix: Multiple Galleries display all the images in the Lightbox slideshow (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11809\\\">#11809<\\/a>)<\\/li>\\n<li>Fix: Old Theme Builder is being opened when accessing through the Finder<\\/li>\\n<li>Fix: Mixed templates import glitch in Theme Builder<\\/li>\\n<li>Fix: Card icon sizes in Theme Builder<\\/li>\\n<li>Fix: Preview button leads to <code>render_mode<\\/code> instead of preview when importing a template from the new Theme Builder<\\/li>\\n<\\/ul>\\n<h4>3.0.1 - 2020-08-26<\\/h4>\\n<ul>\\n<li>Tweak: Keep previous Theme Builder when accessing from the WP Dashboard for legacy support<\\/li>\\n<li>Tweak: Updated video tutorials in Theme Builder<\\/li>\\n<li>Tweak: Don\'t show auto-screenshots in the Media Library (Props <a href=\\\"https:\\/\\/github.com\\/black-eye\\\">@black-eye<\\/a>)<\\/li>\\n<li>Fix: Repeater items throws <code>childView<\\/code> is undefined message in Forms widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12239\\\">#12239<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12221\\\">#12221<\\/a>)<\\/li>\\n<li>Fix: Misspelling of the word &quot;occurred&quot; in Form widget default error message (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12137\\\">#12137<\\/a>)<\\/li>\\n<li>Fix: Facebook comments not showing up (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12157\\\">#12157<\\/a>)<\\/li>\\n<li>Fix: Check for conflicts in Theme Builder doesn\'t work properly<\\/li>\\n<li>Fix: Minor UI fixes in Theme Builder<\\/li>\\n<li>Fix: Dark mode glitches in Theme Builder<\\/li>\\n<li>Fix: Global Site Part toaster appears when you publish a Popup<\\/li>\\n<li>Fix: Site Parts aren\'t in the correct order in Theme Builder<\\/li>\\n<li>Fix: Date field caused forms to get corrupted in Forms widget<\\/li>\\n<li>Fix: Theme Builder application page is forbidden<\\/li>\\n<\\/ul>\\n<h4>3.0.0 - 2020-08-23<\\/h4>\\n<ul>\\n<li>New: Introducing the new and improved Theme Builder<\\/li>\\n<li>Tweak: Removed <code>.elementor-inner<\\/code> and <code>.elementor-column-wrap<\\/code> from DOM output to improve performance (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7351\\\">#7351<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7817\\\">#7817<\\/a>, <a href=\\\"https:\\/\\/developers.elementor.com\\/dom-improvements-ahead-html-wrappers-removal-from-v3-0\\/\\\">Developers Blog Post<\\/a>)<\\/li>\\n<li>Tweak: Added contextual anchors ID support to Table of Contents widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10052\\\">#10052<\\/a>)<\\/li>\\n<li>Tweak: Added WeChat and Weibo social networks to Share Buttons widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11554\\\">#11554<\\/a>)<\\/li>\\n<li>Tweak: Added Dynamic capabilities for Redirect after Login\\/Logout in Login widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11343\\\">#11343<\\/a>)<\\/li>\\n<li>Tweak: Added Blend Mode and CSS Filters controls to adjust the Background Overlay in Flipbox widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11653\\\">#11653<\\/a>)<\\/li>\\n<li>Tweak: Added responsive capabilities to Toggle Button styling in Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8269\\\">#8269<\\/a>)<\\/li>\\n<li>Tweak: Added responsive Text Alignment control in Call to Action widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11968\\\">#11968<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic content to Ribbon element in Call to Action widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10364\\\">#10364<\\/a>)<\\/li>\\n<li>Tweak: Converted uses of Color and Typography Schemes to Global Colors and Fonts<\\/li>\\n<li>Tweak: Separated Title and Description control fields labels in Call to Action widget<\\/li>\\n<li>Tweak: Removed unnecessary style in WC Product with variations<\\/li>\\n<li>Tweak: Converted Portfolio, Posts and Share Buttons widgets to use CSS Variable-based Elementor Grid (<a href=\\\"https:\\/\\/developers.elementor.com\\/elementor-dropping-support-ie\\/\\\">Developers Blog Post<\\/a>)<\\/li>\\n<li>Tweak: Added Date Modified option to Posts widget metadata<\\/li>\\n<li>Fix: PHP 7.4 compatibility to Media Carousel widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11355\\\">#11355<\\/a>)<\\/li>\\n<li>Fix: Divider alignment issue in Post Info widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11628\\\">#11628<\\/a>)<\\/li>\\n<li>Fix: Color doesn\\u2019t change in Products Archive Description widget<\\/li>\\n<li>Fix: WC Product variations layout breaks when using Variation Swatches plugin<\\/li>\\n<li>Fix: WC Product variations layout issue<\\/li>\\n<li>Fix: WC Product variations mobile zoom-in glitch<\\/li>\\n<li>Fix: Can\'t edit a Popup after accessing Theme Style<\\/li>\\n<li>Fix: Twitter icon missing in Blockquote widget<\\/li>\\n<li>Fix: Removed redundant default text color from Share Buttons minimal skin<\\/li>\\n<li>Fix: UI glitch in Display Conditions modal<\\/li>\\n<li>Fix: Insert template button UI glitch in Templates Library<\\/li>\\n<li>Fix: Added sanitization to post titles in WordPress dashboard for better security<\\/li>\\n<li>Fix: Show when arriving from search engines rule doesn\'t work in Popup<\\/li>\\n<li>Fix: Child categories are shown with a different parent category in Query control<\\/li>\\n<li>Deprecated: See all deprecations to this version in our <a href=\\\"https:\\/\\/developers.elementor.com\\/v3-0-planned-deprecations\\/\\\">Developers Deprecations Post<\\/a><\\/li>\\n<\\/ul>\\n<h4>2.10.3 - 2020-06-29<\\/h4>\\n<ul>\\n<li>Fix: Form not being submitted when using &quot;Progress Bar&quot; and &quot;None&quot; view types in Multi Step Form (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11596\\\">#11596<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11610\\\">#11610<\\/a>)<\\/li>\\n<li>Fix: Missing &quot;for&quot; attribute in Password field label in Login widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8646\\\">#8646<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>2.10.2 - 2020-06-16<\\/h4>\\n<ul>\\n<li>Fix: Run step events only when in Multi Step Form mode (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11644\\\">#11644<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>2.10.1 - 2020-06-16<\\/h4>\\n<ul>\\n<li>Tweak: Improved License validation mechanism to avoid limitations<\\/li>\\n<li>Tweak: Changed control labels and ordering in Price Table, Lottie and Form widgets<\\/li>\\n<li>Fix: Popup close button vertical position glitch (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10921\\\">#10921<\\/a>)<\\/li>\\n<li>Fix: Radio field placement glitch when in Multi Step mode in Form widget<\\/li>\\n<li>Fix: Clicking <code>Enter<\\/code> key submits the form in Multi Step Form<\\/li>\\n<li>Fix: Hardened sanitization in Custom Attributes to avoid security issues<\\/li>\\n<\\/ul>\\n<h4>2.10.0 - 2020-06-07<\\/h4>\\n<ul>\\n<li>New: Introducing Multi-Step Forms - Breakdown long forms into simple steps (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5975\\\">#5975<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3911\\\">#3911<\\/a>)<\\/li>\\n<li>New: Introducing Lottie widget - easily add Lottie animations to your site, no coding needed (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11026\\\">#11026<\\/a>)<\\/li>\\n<li>Tweak: Added spacing option to Posts widget pagination (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5682\\\">#5682<\\/a>)<\\/li>\\n<li>Tweak: Changed texts and logic for administrator plugin renewal notices<\\/li>\\n<li>Tweak: Added new Scroll Util for improved scrolling handling<\\/li>\\n<li>Tweak: Improved Motion Effects animation performance<\\/li>\\n<\\/ul>\\n<h4>2.9.5 - 2020-05-24<\\/h4>\\n<ul>\\n<li>Fix: Added sanitization to Custom Attributes control to avoid security issue<\\/li>\\n<\\/ul>\\n<h4>2.9.4 - 2020-05-07<\\/h4>\\n<ul>\\n<li>Fix: Hardened user role that is allowed to upload icon sets and unzip only allowed files in Custom Icons to prevent security vulnerability<\\/li>\\n<\\/ul>\\n<h4>2.9.3 - 2020-04-19<\\/h4>\\n<ul>\\n<li>Fix: Form shortcode IDs are not wrapped in double-quotes (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11023\\\">#11023<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10932\\\">#10932<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10967\\\">#10967<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11000\\\">#11000<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11049\\\">#11049<\\/a>)<\\/li>\\n<li>Fix: Escaped Form records metadata to prevent security vulnerability<\\/li>\\n<li>Fix: Closing &quot;Save Changes&quot; document confirmation modal causes Panel infinite loading<\\/li>\\n<li>Fix: Ken Burns effect not working when there is only one slide in Slides widget<\\/li>\\n<li>Fix: Document handles UI glitch<\\/li>\\n<\\/ul>\\n<h4>2.9.2 - 2020-03-25<\\/h4>\\n<ul>\\n<li>Tweak: Added compatibility with WordPress v5.4 (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10745\\\">#10745<\\/a>)<\\/li>\\n<li>Fix: Image ratio number is displayed under the Archive Posts widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10874\\\">#10874<\\/a>)<\\/li>\\n<li>Fix: Theme Style Link color setting overrides the Table of Content list style<\\/li>\\n<li>Fix: PHP notice when using dynamic user info <code>id<\\/code><\\/li>\\n<li>Fix: Navigation arrows direction is crossed on first drag in Slides Widget<\\/li>\\n<li>Fix: &quot;No headings were found on this page&quot; message was not displayed in the frontend in Table of Contents widget<\\/li>\\n<li>Fix: Container includes Popup tags by default in Table of Contents widget<\\/li>\\n<li>Fix: Twitter icon display issue when Font Awesome 4 support is disabled in Blockquote widget<\\/li>\\n<li>Fix: ACF Dynamic tag not working in Form widget Redirect action<\\/li>\\n<\\/ul>\\n<h4>2.9.1 - 2020-03-16<\\/h4>\\n<ul>\\n<li>Fix: Can\'t access Elementor Editor when there is Page Title widget in the page<\\/li>\\n<li>Fix: Applying styling to Post Content widget affects the Page and Post editing handles<\\/li>\\n<\\/ul>\\n<h4>2.9.0 - 2020-03-15<\\/h4>\\n<ul>\\n<li>New: Introducing Full Site Editing: Design header, footer, and content all in one place! (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4985\\\">#4985<\\/a>)<\\/li>\\n<li>New: Added Global Custom CSS for Your Entire Site in Theme Style (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3345\\\">#3345<\\/a>)<\\/li>\\n<li>New: Added Dynamic Colors tag (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6485\\\">#6485<\\/a>)<\\/li>\\n<li>Tweak: Added option to set the Site Part HTML Wrapper Tags (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9293\\\">#9293<\\/a>)<\\/li>\\n<li>Tweak: Added Link Attributes support to Pro widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5716\\\">#5716<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3642\\\">#3642<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9225\\\">#9225<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9079\\\">#9079<\\/a>)<\\/li>\\n<li>Tweak: Added Theme Style support in Theme Builder parts (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10564\\\">#10564<\\/a>)<\\/li>\\n<li>Tweak: Avoid creating empty Custom Font<\\/li>\\n<li>Tweak: Added <code>aria-expanded<\\/code> attribute to Menu Cart widget<\\/li>\\n<li>Tweak: Moved Link Actions module to Core plugin<\\/li>\\n<li>Tweak: Changed the name of \\u201cTypeKit Web Fonts by Adobe\\u201d to \\u201cAdobe Fonts\\u201d<\\/li>\\n<li>Tweak: Removed redundant display conditions from Blockquote, Flipbox, Price Table, and Search Form widgets<\\/li>\\n<li>Tweak: Pro widgets are not draggable unless Elementor license has been activated<\\/li>\\n<li>Tweak: Remove redundant <code>label_block<\\/code> parameters from several controls<\\/li>\\n<li>Tweak: Converted controls selectors to CSS variables in Gallery widget<\\/li>\\n<li>Tweak: Replaced Stumbleupon with Mix in Reviews widget recommended icons (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10099\\\">#10099<\\/a>)<\\/li>\\n<li>Tweak: Added Mix to the Share Buttons network list (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10099\\\">#10099<\\/a>)<\\/li>\\n<li>Tweak: Added &quot;Open in new tab&quot; option to Posts widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7924\\\">#7924<\\/a>)<\\/li>\\n<li>Tweak: Upgraded Font Awesome Pro library to v5.12.0<\\/li>\\n<li>Tweak: Added new Lightbox compatibility for Gallery and Media Carousel widgets<\\/li>\\n<li>Tweak: Expose external API for Swiper instances<\\/li>\\n<li>Tweak: Added compatibility to JS API in Theme Builder, Popups, Form widget and Global widget<\\/li>\\n<li>Tweak: Replaced nerd icons with new Elementor emojis<\\/li>\\n<li>Tweak: Added specific <code>color<\\/code> attribute to header title in Table of Contents widget<\\/li>\\n<li>Fix: Line break issues in Animated Headline widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10585\\\">#10585<\\/a>)<\\/li>\\n<li>Fix: Theme Style Link color overrides the Table of Content list style<\\/li>\\n<li>Fix: Active state glitches when using Table of contents widget with Sticky mode<\\/li>\\n<li>Fix: &quot;Graphic Element&quot; section appears as empty in case of unmarked Graphic Element in Call to Action widget<\\/li>\\n<li>Fix: Page Title widget render glitches in the Editor<\\/li>\\n<li>Fix: Image ratio parameter visible in some edge cases in Posts widget<\\/li>\\n<li>Fix: Image missing when sharing to Pinterest using Share Buttons widget<\\/li>\\n<li>Fix: Theme Style Link color setting override the list style in Table of Contents widget<\\/li>\\n<li>Deprecated: See all deprecations to this version in our <a href=\\\"https:\\/\\/developers.elementor.com\\/v2-9-0-planned-deprecations\\/\\\">Developers Deprecations Post<\\/a><\\/li>\\n<\\/ul>\\n<h4>2.8.5 - 2020-03-08<\\/h4>\\n<ul>\\n<li>Tweak: Added new Swiper parameter to all Pro carousels to allow 3rd party integration<\\/li>\\n<li>Fix: Missing closing bracket in Animated Headline widget<\\/li>\\n<li>Fix: Share buttons widgets show Font Awesome 4 icons on first drag in Editor<\\/li>\\n<\\/ul>\\n<h4>2.8.4 - 2020-02-16<\\/h4>\\n<ul>\\n<li>Tweak: Added Lightbox Title &amp; Description support to Gallery widget<\\/li>\\n<li>Tweak: Added RTL support for Slides widget<\\/li>\\n<li>Tweak: Display Lightbox images in Full size in Gallery widget<\\/li>\\n<li>Fix: Template with Slides widget not working properly when placed inside Tabs, Accordion and Toggle widget<\\/li>\\n<li>Fix: Dropdown menu lost styling after Elementor Pro v2.8 upgrade in Nav Menu widget<\\/li>\\n<li>Fix: Indent doesn\'t work on RTL websites in Table of Contents widget<\\/li>\\n<li>Fix: Query Control throws <code>Undefined index: q<\\/code> error<\\/li>\\n<li>Fix: Typography control not affecting dropdown menu in Nav Menu widget<\\/li>\\n<li>Fix: Discord forms integration fails to send submissions in some server configurations<\\/li>\\n<li>Fix: Rotating headlines don\'t align center in Animated Headline widget<\\/li>\\n<li>Fix: Custom secondary color displayed when not needed in Share buttons widget<\\/li>\\n<li>Fix: Motion Effects of certain objects are not functioning properly on Safari browser<\\/li>\\n<li>Fix: Missing eye icon in Single template footer preview button<\\/li>\\n<\\/ul>\\n<h4>2.8.3 - 2020-01-01<\\/h4>\\n<ul>\\n<li>Tweak: Updated Table of Contents widget panel location<\\/li>\\n<li>Fix: ACF URL Dynamic field throws <code>undefined index<\\/code> PHP notice (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9929\\\">#9929<\\/a>)<\\/li>\\n<li>Fix: Gallery lightbox pagination shows images from all tabs<\\/li>\\n<li>Fix: &quot;Reply To&quot; option not working in Form widget &quot;Email 2&quot; Action<\\/li>\\n<li>Fix: ACF Dynamic tag not working in Form widget Redirect action<\\/li>\\n<li>Fix: Underline option not working in Table of Contents widget Normal state<\\/li>\\n<li>Fix: Query Control <code>Undefined index: autocomplete<\\/code> notice in some cases<\\/li>\\n<li>Fix: Missing display condition to Read More Spacing control in Posts widget<\\/li>\\n<\\/ul>\\n<h4>2.8.2 - 2019-12-19<\\/h4>\\n<ul>\\n<li>Tweak: Improved scroll-spy and collapsing functionality in Table of Contents widget<\\/li>\\n<li>Fix: &quot;No products were found&quot; message not being displayed in an empty Products Archive<\\/li>\\n<li>Fix: Redundant <code>&lt;br&gt;<\\/code> tags in Single theme template (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9927\\\">#9927<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9928\\\">#9928<\\/a>)<\\/li>\\n<li>Fix: Draft Popup shows up in Dynamic tag dropdown<\\/li>\\n<\\/ul>\\n<h4>2.8.1 - 2019-12-18<\\/h4>\\n<ul>\\n<li>Fix: Share Buttons widget not working (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9920\\\">#9920<\\/a>)<\\/li>\\n<li>Fix: Redundant <code>&lt;p&gt;<\\/code> tags added to Single Template posts<\\/li>\\n<\\/ul>\\n<h4>2.8.0 - 2019-12-18<\\/h4>\\n<ul>\\n<li>New: Table of Contents Widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5171\\\">#5171<\\/a>)<\\/li>\\n<li>New: Added Font Awesome Pro Duotone font family support (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9578\\\">#9578<\\/a>)<\\/li>\\n<li>Tweak: Added Lazy Load option to Gallery widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9763\\\">#9763<\\/a>)<\\/li>\\n<li>Tweak: Added Random order option to Gallery widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9269\\\">#9269<\\/a>)<\\/li>\\n<li>Tweak: Updated Font Awesome Pro to v5.11.2 (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9578\\\">#9578<\\/a>)<\\/li>\\n<li>Tweak: Added preselect support for multiple default select values in Forms Widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9324\\\">#9324<\\/a>)<\\/li>\\n<li>Tweak: Avoid duplicate queries for Custom Icons (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9579\\\">#9579<\\/a>)<\\/li>\\n<li>Tweak: Major performance improvements to Gallery widget<\\/li>\\n<li>Tweak: Avoid non-existing images in Gallery widget<\\/li>\\n<li>Tweak: Added <code>tabindex<\\/code>, <code>aria-expanded<\\/code>, <code>aria-hidden<\\/code> and <code>role=\\\"navigation\\\"<\\/code> accessibility attributes to Nav Menu widget<\\/li>\\n<li>Tweak: Changed button HTML tag from <code>button<\\/code> to <code>span<\\/code> in Call to Action and Flip Box widgets for better W3C compliance and accessibility<\\/li>\\n<li>Tweak: Removed Google+ from default networks in Share Buttons widget<\\/li>\\n<li>Tweak: Added compatibility for Library Connect<\\/li>\\n<li>Tweak: Added i18n to Toolset date dynamic tag<\\/li>\\n<li>Tweak: Added external link support to Gallery widget<\\/li>\\n<li>Tweak: Changed the link external attributes implementation to use <code>add_link_attributes()<\\/code> in Gallery widget<\\/li>\\n<li>Tweak: Updated references to the new Schemes system location<\\/li>\\n<li>Tweak: Avoid running Gallery handler when the gallery is empty<\\/li>\\n<li>Tweak: UI Tweaks in Editor Panel<\\/li>\\n<li>Tweak: Added responsive capabilities to Pointer Width control in Nav Menu widget<\\/li>\\n<li>Tweak: Added mobile support for responsive controls in Nav Menu widget<\\/li>\\n<li>Tweak: Refactor <code>register_controls()<\\/code> method in Posts widget skin trait<\\/li>\\n<li>Fix: ACF URL &quot;undefined Index&quot; notice (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7646\\\">#7646<\\/a>)<\\/li>\\n<li>Fix: WooCommerce Mini-Cart widget causes fatal error in edge cases (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9304\\\">#9304<\\/a>)<\\/li>\\n<li>Fix: <code>PHP Notice: Undefined index<\\/code> display for Author query (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9864\\\">#9864<\\/a>)<\\/li>\\n<li>Fix: Added compatibility for Button widget placed inside Swiper carousel (<a href=\\\"https:\\/\\/wordpress.org\\/support\\/topic\\/broken-buttons-since-elementor-2-8\\/\\\">Topic<\\/a>)<\\/li>\\n<li>Fix: Avoid empty spaces in Post info widget<\\/li>\\n<li>Tweak: Always show &quot;Custom label&quot; control in Login widget<\\/li>\\n<li>Fix: Nav Menu item typography selector in Nav Menu widget<\\/li>\\n<li>Fix: Facebook Like Button widget causes flickering<\\/li>\\n<li>Fix: WooCommerce mini-cart behaviour when using <code>plain<\\/code> permalinks format<\\/li>\\n<li>Fix: Avoid running Popup triggers when set without conditions<\\/li>\\n<li>Fix: Removed &quot;Date&quot; query from Products widget<\\/li>\\n<li>Fix: Slides widget when used as a Shortcode and is hidden<\\/li>\\n<li>Fix: Custom URL being accessed on swipe in Media Carousel<\\/li>\\n<li>Fix: Media Carousel widget Cube effect glitch<\\/li>\\n<li>Fix: Lightbox shows images from multiple Gallery widgets in the same page<\\/li>\\n<li>Fix: Image <code>alt<\\/code> Text not displayed on overlay in Gallery widget<\\/li>\\n<li>Fix: Gallery widget not visible in Posts widget Full Content skin<\\/li>\\n<li>Fix: WooCommerce mini-cart remove unnecessary hooks registration when WooCommerce integration set to <code>Disable<\\/code><\\/li>\\n<li>Fix: Slides widget button wrapping breaks in mobile view<\\/li>\\n<li>Fix: Dynamic capabilities with the Reviews widget<\\/li>\\n<li>Fix: Disabling autoplay doesn\'t work in Slides widget<\\/li>\\n<li>Fix: Posts widget Full Content skin not working on Single template<\\/li>\\n<li>Fix: Autocomplete not working for &quot;By Author&quot; condition in Display Conditions screen<\\/li>\\n<li>Fix: Posts widget alignment issue<\\/li>\\n<li>Fix: Product Variations Clear button not working in edge cases<\\/li>\\n<li>Fix: Styling issues in Form widget submit button<\\/li>\\n<\\/ul>\\n<h4>2.7.3 - 2019-10-28<\\/h4>\\n<ul>\\n<li>Tweak: Added RTL support to Galleries widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9213\\\">#9213<\\/a>)<\\/li>\\n<li>Tweak: Added Custom Icons compatibility for WordPress 5.3<\\/li>\\n<li>Fix: Missing template function declaration causes fatal error in WC mini-cart widget<\\/li>\\n<li>Fix: Pause on hover doesn\'t work in Carousel widgets<\\/li>\\n<li>Fix: Link-actions conflict with <code>?action=<\\/code> parameter in the URL<\\/li>\\n<li>Fix: Lightbox navigation not working in Gallery widget Single mode<\\/li>\\n<li>Fix: Ken burns effect not working on the 1st slide if Infinite Loop option is turned off in Carousel widgets<\\/li>\\n<li>Fix: Popup Advanced Rules detects internal links as external if current URL starts with <code>www<\\/code><\\/li>\\n<\\/ul>\\n<h4>2.7.2 - 2019-10-06<\\/h4>\\n<ul>\\n<li>Fix: Slide Overlay not working when applying Ken burns effect in Slides widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9209\\\">#9209<\\/a>)<\\/li>\\n<li>Fix: Content width glitch in Slides widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9180\\\">#9180<\\/a>)<\\/li>\\n<li>Fix: Horizontal Alignment not working when applying custom style per slide in Slides widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9180\\\">#9180<\\/a>)<\\/li>\\n<li>Fix: Missing semicolon in Custom Fonts <code>font-display<\\/code> CSS<\\/li>\\n<\\/ul>\\n<h4>2.7.1 - 2019-09-26<\\/h4>\\n<ul>\\n<li>Fix: Background Overlay layer is over the slide content in Slides widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9180\\\">#9180<\\/a>)<\\/li>\\n<li>Fix: Duplicate images under &quot;All&quot; filter in Multiple Gallery<\\/li>\\n<\\/ul>\\n<h4>2.7.0 - 2019-09-24<\\/h4>\\n<ul>\\n<li>New: Enhanced Galleries widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1898\\\">#1898<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3103\\\">#3103<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4279\\\">#4279<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7631\\\">#7631<\\/a>)<\\/li>\\n<li>New: Dynamic Number (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5952\\\">#5952<\\/a>)<\\/li>\\n<li>New: Full content skin for Posts and Archive-posts widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4617\\\">#4617<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic number capability to Price List, Price Table, Counter, Star Rating, Progress Bar widgets<\\/li>\\n<li>Tweak: Added tags support to forms Mailchimp action (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5418\\\">#5418<\\/a>)<\\/li>\\n<li>Tweak: User Profile Picture Dynamic Tag (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7947\\\">#7947<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8740\\\">#8740<\\/a>)<\\/li>\\n<li>Tweak: Added <code>font-display<\\/code> support to custom fonts (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5993\\\">#5993<\\/a>, <a href=\\\"https:\\/\\/developers.elementor.com\\/elementor-pro-2-7-custom-fonts-font-display-support\\/\\\">Developers Blog Post<\\/a>)<\\/li>\\n<li>Tweak: Added Text Shadow control to Slides widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8800\\\">#8800<\\/a>)<\\/li>\\n<li>Tweak: Added Re-subscribe support to MailerLite (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8799\\\">#8799<\\/a>)<\\/li>\\n<li>Tweak: Added Dynamic capabilities to Facebook Embed widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9030\\\">#9030<\\/a>)<\\/li>\\n<li>Tweak: Use <code>swiper.js<\\/code> instead of <code>slick.js<\\/code> in Slides widget (<a href=\\\"https:\\/\\/developers.elementor.com\\/elementor-2-7-moving-sliders-from-slick-to-swiper\\/\\\">Developers Blog Post<\\/a>)<\\/li>\\n<li>Tweak: Added <code>elementor_pro\\/search_form\\/before_input<\\/code> action hook to Search Form widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5598\\\">#5598<\\/a>)<\\/li>\\n<li>Tweak: Added <code>elementor_pro\\/search_form\\/after_input<\\/code> action hook to Search Form widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5598\\\">#5598<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic support for Custom field key (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7789\\\">#7789<\\/a>)<\\/li>\\n<li>Tweak: Increased expired license notice bar frequency<\\/li>\\n<li>Tweak: Changed the icon name of Slides widget<\\/li>\\n<li>Tweak: Added designated Finder\'s Icons for Custom icons &amp; Custom fonts<\\/li>\\n<li>Tweak: Use Ken Burns Effect as an external module<\\/li>\\n<li>Tweak: Remove Fontello conflicting CSS on import to Custom Icons sets<\\/li>\\n<li>Tweak: Editor Panel UI tweaks<\\/li>\\n<li>Tweak: Added DOM events on Popup show\\/hide (<a href=\\\"https:\\/\\/developers.elementor.com\\/elementor-pro-2-7-popup-events\\/\\\">Developers Blog Post<\\/a>)<\\/li>\\n<li>Tweak: Added option to change the variations field width in Add to Cart widget<\\/li>\\n<li>Tweak: Use select control instead of select2 in Menu Cart widget<\\/li>\\n<li>Tweak: Added conditions to the tabs instead of to each control in Share Buttons widget<\\/li>\\n<li>Tweak: Added Typography controls to HTML field in Forms widget<\\/li>\\n<li>Tweak: Allow edit selected Font file in Custom Font<\\/li>\\n<li>Tweak: Changed reCAPTCHA v3 error message<\\/li>\\n<li>Tweak: Remove the &quot;Save as Global&quot; option on Global widget context menu<\\/li>\\n<li>Fix: Corrected selector for <code>removeControlSpinner()<\\/code> (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8790\\\">#8790<\\/a>)<\\/li>\\n<li>Fix: Slides widget navigation icons misplacement (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8533\\\">#8533<\\/a>)<\\/li>\\n<li>Fix: Horizontal Scrollbar when Slider widget is set to Full Width (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8527\\\">#8527<\\/a>)<\\/li>\\n<li>Fix: Inconsistent behavior when &quot;Infinite Loop&quot; enabled with &quot;Autoplay&quot; in Slides widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6726\\\">#6726<\\/a>)<\\/li>\\n<li>Fix: Ken Burns effect on Chrome transition glitches (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1671\\\">#1671<\\/a>)<\\/li>\\n<li>Fix: Nothing found message shows up inside the columns set in Posts Archive widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7347\\\">#7347<\\/a>)<\\/li>\\n<li>Fix: Responsive UI glitch in Popup Conditions modal tabs<\\/li>\\n<li>Fix: Removed unnecessary divider in Call to Action widget<\\/li>\\n<li>Fix: Custom Add To Cart * button style (size, position and background color) when <code>quantity<\\/code> is enabled.<\\/li>\\n<li>Fix: Add support for Document\\/PageBase in Theme Builder (Core &gt;=2.7.0)<\\/li>\\n<li>Fix: Ampersand character breaks email link in Share Buttons widget<\\/li>\\n<li>Fix: Correct custom font attachment <code>mime-type<\\/code> to show uploaded Custom Fonts<\\/li>\\n<li>Fix: Mini-Cart not refreshing in Menu Cart widget<\\/li>\\n<li>Fix: Cart drawer not working when WC Subscriptions plugin is activated<\\/li>\\n<li>Fix:  Querying CPT with custom taxonomies does not show the taxonomies before saving<\\/li>\\n<li>Fix: Double rendering on change caused console error in Theme Builder\'s conditions screen<\\/li>\\n<li>Fix: Translations and Strings in Share Buttons widget<\\/li>\\n<li>Fix: Avoid using offset if the source is Manual selection in Query Control<\\/li>\\n<li>Fix: Form being submitted although reCAPTCHA v3 validation failed in Forms widget<\\/li>\\n<\\/ul>\\n<h4>2.6.5 - 2019-08-26<\\/h4>\\n<ul>\\n<li>Tweak: Added compatibility for the upcoming release of Elementor v2.7<\\/li>\\n<li>Fix: Button style not working when <code>quantity<\\/code> is enabled in Custom Add To Cart widget<\\/li>\\n<li>Fix: Updated minified JS file fixed WhatsApp base URL in Share Buttons widget<\\/li>\\n<\\/ul>\\n<h4>2.6.4 - 2019-08-21<\\/h4>\\n<ul>\\n<li>Tweak: Added compatibility for the upcoming release of Elementor v2.7<\\/li>\\n<li>Fix: Changed WhatsApp base URL in Share Buttons widget for cross-device compatibility<\\/li>\\n<li>Fix: Random slides order after several clicks on pagination in Testimonial Carousel widget<\\/li>\\n<\\/ul>\\n<h4>2.6.3 - 2019-08-18<\\/h4>\\n<ul>\\n<li>Fix: Core version rollback to <code>&gt;2.6.0<\\/code> causes a fatal error<\\/li>\\n<li>Fix: Duplicate images when slideshow skin is selected in Media Carousel lightbox<\\/li>\\n<li>Fix: Default bottom margin added to reCAPTCHA V3 badge<\\/li>\\n<li>Fix: Input glitch in reCAPTCHA V3 threshold settings<\\/li>\\n<\\/ul>\\n<h4>2.6.2 - 2019-07-30<\\/h4>\\n<ul>\\n<li>Tweak: Better accessibility support in Search Form widget<\\/li>\\n<li>Fix: UI glitched in Popup publish screen (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8616\\\">#8616<\\/a>)<\\/li>\\n<li>Fix: &quot;Child of Term&quot; and &quot;Any child of term&quot; conditions (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8695\\\">#8695<\\/a>)<\\/li>\\n<li>Fix: Restored <code>library_widget_templates<\\/code> action hook for 3rd party compatibility (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8687\\\">#8687<\\/a>)<\\/li>\\n<li>Fix: Twitter Icon missing in Blockquote widget<\\/li>\\n<li>Fix: Form reCAPTCHA v3 badge position not working<\\/li>\\n<li>Fix: Renewal notice bar appears in wrong situations<\\/li>\\n<li>Fix: Draft Icon Set loads empty Icon Library<\\/li>\\n<\\/ul>\\n<h4>2.6.1 - 2019-07-24<\\/h4>\\n<ul>\\n<li>Fix: Query Control autocomplete not retrieving results (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8672\\\">#8672<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8661\\\">#8661<\\/a>)<\\/li>\\n<li>Fix: Price Table features section not working (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8660\\\">#8660<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>2.6.0 - 2019-07-23<\\/h4>\\n<ul>\\n<li>New: Introducing Custom Icon sets - including Fontello, IcoMoon and Fontastic support (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/110\\\">#110<\\/a>)<\\/li>\\n<li>New: Added Font Awesome 5 Pro integration including 5,300+ icons (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4430\\\">#4430<\\/a>)<\\/li>\\n<li>New: Added reCAPTCHA v3 integration to Form widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8213\\\">#8213<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6039\\\">#6039<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7165\\\">#7165<\\/a>)<\\/li>\\n<li>Tweak: Added Exit Animation for Popups (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7063\\\">#7063<\\/a>)<\\/li>\\n<li>Tweak: Added ACF Dynamic tag support for archive pages (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5147\\\">#5147<\\/a>)<\\/li>\\n<li>Tweak: Added Navigator Indicators for Custom CSS &amp; Motion Effects (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2180\\\">#2180<\\/a>)<\\/li>\\n<li>Tweak: Added Dynamic capabilities for Form Redirect action (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7552\\\">#7552<\\/a>)<\\/li>\\n<li>Tweak: Added Logged In Message styling options for Login widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7928\\\">#7928<\\/a>)<\\/li>\\n<li>Tweak: Added <code>none<\\/code> breakpoint option to Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7916\\\">#7916<\\/a>)<\\/li>\\n<li>Tweak: Added option to place Post Terms dynamic tag without links (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8366\\\">#8366<\\/a>)<\\/li>\\n<li>Tweak: Added <code>elementor\\/query\\/query_results<\\/code> hook to Query Control to allow full control over results (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7912\\\">#7912<\\/a>)<\\/li>\\n<li>Tweak: Allow choosing Heading HTML tag in Price Table widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8090\\\">#8090<\\/a>)<\\/li>\\n<li>Tweak: Show popup on dynamic click even when <code>Avoid Multiple Popups<\\/code> option is selected (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8189\\\">#8189<\\/a>)<\\/li>\\n<li>Tweak: Added condition option to all of archive child pages (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8256\\\">#8256<\\/a>)<\\/li>\\n<li>Tweak: Added <code>Effects Relative To<\\/code> control to Scrolling Effects<\\/li>\\n<li>Tweak: Allow shortcodes in HTML Form field<\\/li>\\n<li>Tweak: Removed donReach integration from Share Buttons widget due to service inconsistent stability<\\/li>\\n<li>Tweak: Changed MailChimp <code>List<\\/code> label to <code>Audience<\\/code><\\/li>\\n<li>Tweak: Improved Entrance and Exit animation behavior in Popup<\\/li>\\n<li>Tweak: Added <code>Deprecated Notice<\\/code> control to <code>Archive Products<\\/code> and <code>Woo Products<\\/code> widgets<\\/li>\\n<li>Tweak: Added default dynamic title for archives in Theme Builder<\\/li>\\n<li>Tweak: Added condition to show <code>Centered Slides<\\/code> control in Media Carousel widget<\\/li>\\n<li>Tweak: Added notice bar in the Editor when the license is expired or not activated<\\/li>\\n<li>Tweak: Replaced <code>select<\\/code> control with <code>choose<\\/code> control in Price List widget<\\/li>\\n<li>Tweak: Removed Font Awesome 4 dependencies from the Editor<\\/li>\\n<li>Tweak: Minor styling tweaks in the Popup publish modal<\\/li>\\n<li>Tweak: Hide ordering form in Products widget on front page<\\/li>\\n<li>Tweak: Removed page title markup when \'Hide Title\' is active<\\/li>\\n<li>Tweak: Added style controls for HTML field in Form widget<\\/li>\\n<li>Fix: Form widget Date picker makes the Popup builder disappear (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7240\\\">#7240<\\/a>)<\\/li>\\n<li>Fix: Sticky element stop point stops working on viewport resize (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7884\\\">#7884<\\/a>)<\\/li>\\n<li>Fix: Copy-Paste style not pasting the Pointer option in Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8497\\\">#8497<\\/a>)<\\/li>\\n<li>Fix: Missing Print icon in Share Buttons (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8506\\\">#8506<\\/a>)<\\/li>\\n<li>Fix: UI style glitch in Blockquote widget when viewing from iPad<\\/li>\\n<li>Deprecated: <code>DB::save_editor()<\\/code> - Remove usage of this method (<a href=\\\"https:\\/\\/developers.elementor.com\\/v2-6-0-planned-deprecations\\/\\\">Deprecation Post<\\/a>)<\\/li>\\n<li>Deprecated: <code>DB::get_plain_editor()<\\/code> - Remove usage of this method (<a href=\\\"https:\\/\\/developers.elementor.com\\/v2-6-0-planned-deprecations\\/\\\">Deprecation Post<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>2.5.14 - 2019-07-14<\\/h4>\\n<ul>\\n<li>Fix: Better WC Related Product grid support to various themes (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8555\\\">#8555<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>2.5.13 - 2019-07-11<\\/h4>\\n<ul>\\n<li>Fix: Better WC grid support to various themes<\\/li>\\n<\\/ul>\\n<h4>2.5.12 - 2019-07-10<\\/h4>\\n<ul>\\n<li>Fix: Grid for WooCommerce Archive Product widget<\\/li>\\n<li>Fix: Remove redundant <code>whitespace<\\/code> CSS property causes style glitch in iPad<\\/li>\\n<li>Tweak: Added more compatibility for Elementor v2.6<\\/li>\\n<\\/ul>\\n<h4>2.5.11 - 2019-07-02<\\/h4>\\n<ul>\\n<li>Fix: Close icon missing from Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8460\\\">#8460<\\/a>)<\\/li>\\n<li>Fix: Elementor Pro v2.5.10 shows PHP notice regarding notice bar (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8461\\\">#8461<\\/a>)<\\/li>\\n<li>Fix: Fatal error when deleting used Pods fields (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8396\\\">#8396<\\/a>)<\\/li>\\n<li>Fix: Missing dropdown icon in conditions screen<\\/li>\\n<\\/ul>\\n<h4>2.5.10 - 2019-05-28<\\/h4>\\n<ul>\\n<li>Tweak: Added compatibility for the upcoming release of Elementor v2.6<\\/li>\\n<li>Tweak: Error caused by empty Rows &amp; Columns values in Products widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8261\\\">#8261<\\/a>)<\\/li>\\n<li>Fix: Do not unset <code>product<\\/code> CPT if it\'s not from WooCommerce (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8160\\\">#8160<\\/a>)<\\/li>\\n<li>Fix: Column Spacing not working in WooCommerce Archive Products widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8285\\\">#8285<\\/a>)<\\/li>\\n<li>Fix: Title styling not working in Products Categories widget<\\/li>\\n<li>Fix: Empty value in Dynamic Pods Gallery dropdown using Safari browser<\\/li>\\n<li>Fix: WooCommerce archives included in &quot;All Archives&quot; condition<\\/li>\\n<\\/ul>\\n<h4>2.5.9 - 2019-05-28<\\/h4>\\n<ul>\\n<li>Tweak: Removed <code>auto-confirm<\\/code> control from MailPoet to support new version of MailPoet<\\/li>\\n<li>Fix: Multiple Custom Fonts not rendered in the editor<\\/li>\\n<li>Fix: Products <code>sale<\\/code> query - handle exclude by manual selection.<\\/li>\\n<li>Fix: Product Categories grid row &amp; column style<\\/li>\\n<li>Fix: Form integration AJAX cache override<\\/li>\\n<li>Fix: Removed redundant CSS on Canvas &amp; Header-Footer page templates<\\/li>\\n<\\/ul>\\n<h4>2.5.8 - 2019-05-06<\\/h4>\\n<ul>\\n<li>Fix: Popup entrance animation not working in frontend<\\/li>\\n<li>Fix: Popup Exit Intent trigger activated multiple times<\\/li>\\n<\\/ul>\\n<h4>2.5.7 - 2019-05-05<\\/h4>\\n<ul>\\n<li>Fix: Embedded video keeps playing after a Popup is closed (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7875\\\">#7875<\\/a>)<\\/li>\\n<li>Fix: Maximum call stack size exceeded error in Safari (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7824\\\">#7824<\\/a>)<\\/li>\\n<li>Fix: Entrance animations not appearing on Popup reopen (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7395\\\">#7395<\\/a>)<\\/li>\\n<li>Fix: WC variations select style glitch in several themes (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8008\\\">#8008<\\/a>)<\\/li>\\n<li>Fix: Theme Builder taxonomy conditions not retrieving proper results in edge cases<\\/li>\\n<\\/ul>\\n<h4>2.5.6 - 2019-04-29<\\/h4>\\n<ul>\\n<li>Tweak: Removed <code>Shortcode<\\/code> dynamic from Image, Gallery and Media control<\\/li>\\n<li>Fix: Popup not inheriting entrance animation in responsive mode (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7809\\\">#7809<\\/a>)<\\/li>\\n<li>Fix: Terms autocomplete retrieves wrong results in Query Control<\\/li>\\n<li>Fix: Query Control Related by author glitches in edge cases<\\/li>\\n<li>Fix: Query Control using terms for Products widget<\\/li>\\n<li>Fix: Posts cards style glitch in small screens<\\/li>\\n<li>Fix: Display conditions delete icon missing in small screens<\\/li>\\n<li>Fix: Avoid rendering Menu Cart widget in WordPress native editor<\\/li>\\n<\\/ul>\\n<h4>2.5.5 - 2019-04-08<\\/h4>\\n<ul>\\n<li>Tweak: Allow text selection inside a Popup<\\/li>\\n<li>Fix: Added backwards compatibility for <code>tax_query<\\/code> in Query Control (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7751\\\">#7751<\\/a>)<\\/li>\\n<li>Fix: Missing arguments for <code>widget_title<\\/code> filter (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7745\\\">#7745<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>2.5.4 - 2019-04-03<\\/h4>\\n<ul>\\n<li>Fix: Move Query from using <code>term_id<\\/code> to <code>term_taxonomy_id<\\/code> (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7653\\\">#7653<\\/a>)<\\/li>\\n<li>Fix: Offset manipulation hook removal in Query control<\\/li>\\n<li>Fix: Missing form field <code>ID<\\/code> in some edge cases (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7711\\\">#7711<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7660\\\">#7660<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>2.5.3 - 2019-03-31<\\/h4>\\n<ul>\\n<li>Tweak: Updated Google Calendar dynamic tag URL (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7673\\\">#7673<\\/a>)<\\/li>\\n<li>Fix: Missing form field names (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7651\\\">#7651<\\/a>)<\\/li>\\n<li>Fix: PHP 5.4 backward compatibility in Query Control (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7633\\\">#7633<\\/a>)<\\/li>\\n<li>Fix: <code>products_deprecated<\\/code> Query Control module compatibility (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7654\\\">#7654<\\/a>)<\\/li>\\n<li>Fix: Changed query method from <code>term_id<\\/code> to <code>term_taxonomy_id<\\/code> (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7653\\\">#7653<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>2.5.2 - 2019-03-27<\\/h4>\\n<ul>\\n<li>Fix: Overwrite parent widget type in Global Widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7632\\\">#7632<\\/a>)<\\/li>\\n<li>Fix: Avoid Duplicates option not working in Query Control (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7635\\\">#7635<\\/a>)<\\/li>\\n<li>Fix: Manual Selection option not working in Query Control (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7634\\\">#7634<\\/a>)<\\/li>\\n<li>Fix: Incorrect condition caused handlers issues inside popup<\\/li>\\n<\\/ul>\\n<h4>2.5.1 - 2019-03-26<\\/h4>\\n<ul>\\n<li>Fix: Query Control invalid call to deprecated action (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7619\\\">#7619<\\/a>)<\\/li>\\n<li>Tweak: Renamed action hook from <code>elementor_pro\\/{$widget_name}\\/query\\/{$query_id}<\\/code> to <code>elementor\\/query\\/{$query_id}<\\/code><\\/li>\\n<li>Tweak: Renamed filter hook from <code>elementor_pro\\/query_control\\/get_query_args\\/current_query<\\/code> to <code>elementor\\/query\\/get_query_args\\/current_query<\\/code><\\/li>\\n<\\/ul>\\n<h4>2.5.0 - 2019-03-26<\\/h4>\\n<ul>\\n<li>New: Introducing Motion Effects including Scrolling &amp; Mouse effects (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/72\\\">#72<\\/a>)<\\/li>\\n<li>New: Introducing Related Posts for Query Control (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7306\\\">#7306<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7490\\\">#7490<\\/a>)<\\/li>\\n<li>New: Introducing Date query for Query Control<\\/li>\\n<li>New: Introducing Sticky Posts support for Query Control (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2501\\\">#2501<\\/a>)<\\/li>\\n<li>Tweak: Added option to open a Popup by a custom selector (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6871\\\">#6871<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6876\\\">#6876<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7258\\\">#7258<\\/a>)<\\/li>\\n<li>Tweak: Option to count when Popup is closed in &quot;Show up to X times&quot; Advanced Rule<\\/li>\\n<li>Tweak: Added full border radius control options inside Popup<\\/li>\\n<li>Tweak: Changed exit intent icon in Popups<\\/li>\\n<li>Tweak: Show only one popup in its own preview<\\/li>\\n<li>Tweak: Added responsive support to Popup entrance animation control<\\/li>\\n<li>Tweak: Conditions - Singular <code>All Pages<\\/code> string changed to <code>Pages<\\/code><\\/li>\\n<li>Tweak: Added form field shortcode support for Drip tags (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7000\\\">#7000<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic capabilities to Price List widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7258\\\">#7258<\\/a>)<\\/li>\\n<li>Tweak: Added Dynamic capabilities to Custom Attributes (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6779\\\">#6779<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic capabilities to Flip Box widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6986\\\">#6986<\\/a>)<\\/li>\\n<li>Tweak: Decrease <code>z-index<\\/code> for Nav Menu (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6869\\\">#6869<\\/a>)<\\/li>\\n<li>Tweak: Changed &quot;Scrolling Effects&quot; section label to &quot;Motion Effects&quot;<\\/li>\\n<li>Tweak: Use filter <code>get_meta_viewport<\\/code> for header templates (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7043\\\">#7043<\\/a>)<\\/li>\\n<li>Tweak: use filterable <code>Util::get_public_post_types()<\\/code> in Theme Builder (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7172\\\">#7172<\\/a>)<\\/li>\\n<li>Tweak: Added Cloudflare rocket-loader support (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7443\\\">#7443<\\/a>)<\\/li>\\n<li>Tweak: Added responsive support to WC Products Columns &amp; Rows Gap controls (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6913\\\">#6913<\\/a>)<\\/li>\\n<li>Tweak: WC Menu cart &quot;View Cart&quot; &amp; &quot;Checkout&quot; buttons styling<\\/li>\\n<li>Fix: Custom ID reset to default when dragging repeater<\\/li>\\n<li>Fix: Conflict between archive-products widget and WC customizer<\\/li>\\n<li>Fix: Add to Cart widget <code>spacing<\\/code> and <code>space-between<\\/code><\\/li>\\n<li>Fix: Library view when creating a new Header or Footer<\\/li>\\n<li>Fix: Post types labels missing on Add New Template modal<\\/li>\\n<\\/ul>\\n<h4>2.4.8 - 2019-03-11<\\/h4>\\n<ul>\\n<li>Fix: Missing query section in Products widget<\\/li>\\n<li>Fix: Missing Taxonomy controls in Products widget in edge cases<\\/li>\\n<\\/ul>\\n<h4>2.4.7 - 2019-03-06<\\/h4>\\n<ul>\\n<li>Fix: Compatibility Global Widget with Elementor v2.5.0+<\\/li>\\n<\\/ul>\\n<h4>2.4.6 - 2019-03-04<\\/h4>\\n<ul>\\n<li>Fix: Pods gallery dynamic when empty (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7127\\\">#7127<\\/a>)<\\/li>\\n<li>Fix: Duplicate call for conditions screen issue<\\/li>\\n<li>Fix: Compatibility with Elementor v2.5.0<\\/li>\\n<\\/ul>\\n<h4>2.4.5 - 2019-02-18<\\/h4>\\n<ul>\\n<li>Fix: Image size issue in Testimonial Carousel (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7058\\\">#7058<\\/a>)<\\/li>\\n<li>Fix: MailChimp groups not saved in a form integration (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7083\\\">#7083<\\/a>)<\\/li>\\n<li>Fix: Show popup preview only on it\'s own preview<\\/li>\\n<li>Fix: Elementor dashboard templates URL corrupted links in edge cases<\\/li>\\n<\\/ul>\\n<h4>2.4.4 - 2019-02-11<\\/h4>\\n<ul>\\n<li>Tweak: Added ACF Date Time Picker field support (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6690\\\">#6690<\\/a>)<\\/li>\\n<li>Tweak: Changed the term of <code>All Posts<\\/code> condition to <code>Posts<\\/code><\\/li>\\n<li>Fix: Added <code>&lt;IfModule&gt;<\\/code> to avoid 500 error when <code>mod-headers<\\/code> is missing (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7034\\\">#7034<\\/a>)<\\/li>\\n<li>Fix: Include post CSS deletion in Global Widget update (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6856\\\">#6856<\\/a>)<\\/li>\\n<li>Fix: <code>Textarea<\\/code> default value in Forms Widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6934\\\">#6934<\\/a>)<\\/li>\\n<li>Fix: MailPoet latest version caused fatal error (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6996\\\">#6996<\\/a>)<\\/li>\\n<li>Fix: Fatal Error caused by calling MailPoet deleted method<\\/li>\\n<li>Notice: MailPoet <code>Auto Confirm<\\/code> option will now default to &quot;On&quot;<\\/li>\\n<\\/ul>\\n<h4>2.4.3 - 2019-01-30<\\/h4>\\n<ul>\\n<li>Fix: Custom Add to Cart widget responsive alignment settings<\\/li>\\n<li>Fix: Links in Post Info widget<\\/li>\\n<li>Fix: WooCommerce <code>View Cart<\\/code> string translate<\\/li>\\n<li>Fix: Wrapper classes for header\\/footer templates (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6884\\\">#6884<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>2.4.2 - 2019-01-25<\\/h4>\\n<ul>\\n<li>Tweak: Added pixel units to Close Button position control in Popups<\\/li>\\n<li>Fix: Exclude error in WC Products widget<\\/li>\\n<\\/ul>\\n<h4>2.4.1 - 2019-01-24<\\/h4>\\n<ul>\\n<li>Tweak: Added CSS classes control to Popup (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6826\\\">#6826<\\/a>)<\\/li>\\n<li>Tweak: Added responsive image size to Testimonial Carousel widget<\\/li>\\n<li>Fix: PHP warning when Toolset Date dynamic is empty (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6842\\\">#6842<\\/a>)<\\/li>\\n<li>Fix: Support of exclude-ids in WC Products widget<\\/li>\\n<li>Fix: Popup close button not clickable<\\/li>\\n<li>Fix: Alignment justify issue of Add to Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6749\\\">#6749<\\/a>)<\\/li>\\n<li>Fix: Bad anchors breaks the page JS<\\/li>\\n<li>Fix: Popup overlay shown when turned off<\\/li>\\n<\\/ul>\\n<h4>2.4.0 - 2019-01-21<\\/h4>\\n<ul>\\n<li>New: Introducing Popup Builder (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/628\\\">#628<\\/a>)<\\/li>\\n<li>New: Added <code>Popup<\\/code> Dynamic Tag<\\/li>\\n<li>New: Added <code>Popup<\\/code> forms action after submit<\\/li>\\n<li>New: Added User Info dynamic tag (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6322\\\">#6322<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic capabilities for &quot;Nothing Found&quot; message<\\/li>\\n<li>Tweak: Added <code>elementor_pro\\/theme_builder\\/archive\\/escape_nothing_found_message<\\/code> Filter to avoid HTML escaping in &quot;Nothing Found&quot; message (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6053\\\">#6053<\\/a>)<\\/li>\\n<li>Tweak: Added <code>add_doc_to_location<\\/code> method to Allow insertion of a document to a location<\\/li>\\n<li>Fix: <code>z-index<\\/code> issue with CTA widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6486\\\">#6486<\\/a>)<\\/li>\\n<li>Fix: Hide the Post Content widget and show it only in a Single document<\\/li>\\n<li>Fix: <code>selector<\\/code> replacement in Custom CSS<\\/li>\\n<li>Fix: Apply <code>the_content<\\/code> on the real content only<\\/li>\\n<li>Fix: CSS for WC products selector (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6559\\\">#6559<\\/a>)<\\/li>\\n<li>Fix: Odnoklassniki share URL (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6638\\\">#6638<\\/a>)<\\/li>\\n<li>Fix: Custom link new tab in Post Info widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5766\\\">#5766<\\/a>)<\\/li>\\n<li>Fix: <code>nofollow<\\/code> link in Flip Box &amp; CTA widgets<\\/li>\\n<li>Fix: Post Terms in Post Info widget<\\/li>\\n<li>Fix: Added screen reader to some icons &amp; buttons for better accessibility (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5386\\\">#5386<\\/a>)<\\/li>\\n<li>Fix: Accessibility labels in Reviews widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6630\\\">#6630<\\/a>)<\\/li>\\n<li>Fix: Link to cart page not working when WooCommerce Subscriptions is active<\\/li>\\n<li>Fix: MailChimp Selected list not showing on reloading in Form widget<\\/li>\\n<li>Fix: Sub-menu arrow position in Nav Menu widget<\\/li>\\n<li>Fix: Conflict with WP Security Audit Log plugin (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6648\\\">#6648<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>2.3.1 - 2018-12-19<\\/h4>\\n<ul>\\n<li>Fix: Template widget search functionality (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6473\\\">#6473<\\/a>)<\\/li>\\n<li>Fix: Apply <code>the_content<\\/code> filter to post content in theme builder<\\/li>\\n<\\/ul>\\n<h4>2.3.0 - 2018-12-17<\\/h4>\\n<ul>\\n<li>New: Introducing Discord Integration for Forms (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4218\\\">#4218<\\/a>)<\\/li>\\n<li>New: Introducing Slack Integration for Forms<\\/li>\\n<li>New: Introducing MailerLite Integration for Forms (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4462\\\">#4462<\\/a>)<\\/li>\\n<li>New: Activate Elementor Pro plugin by connecting to Elementor account<\\/li>\\n<li>Tweak: Added <code>elementor_pro\\/utils\\/get_public_post_types<\\/code> filter hook (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5900\\\">#5900<\\/a>)<\\/li>\\n<li>Tweak: Added <code>loop_start<\\/code> &amp; <code>the_content<\\/code> hooks for Post Content (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6173\\\">#6173<\\/a>)<\\/li>\\n<li>Tweak: Removed Custom Attributes from Page Settings<\\/li>\\n<li>Tweak: Always add the Custom CSS control to the Advanced tab<\\/li>\\n<li>Fix: In sub Term condition false positive in edge cases<\\/li>\\n<li>Fix: ToolSet Dynamic Image fallback<\\/li>\\n<li>Fix: Style glitch with the dropdown color in Nav Menu widget<\\/li>\\n<li>Fix: Style glitch in the Conditions screen in Safari browser<\\/li>\\n<li>Fix: Ribbon in the CTA widget obscures drop down menu (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6080\\\">#6080<\\/a>)<\\/li>\\n<li>Fix: The color of label won\'t change color in Widget login<\\/li>\\n<\\/ul>\\n<h4>2.2.5 - 2018-12-11<\\/h4>\\n<ul>\\n<li>New: Add Style Tab &amp; Custom CSS for Header &amp; Footer Templates.<\\/li>\\n<li>Tweak: Added a better identifier for subpages (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6362\\\">#6362<\\/a>)<\\/li>\\n<li>Tweak: Removed Custom Attributes from page settings<\\/li>\\n<li>Fix: Yahoo event URL date issue (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6354\\\">#6354<\\/a>)<\\/li>\\n<li>Fix: Allow timezone settings in Google event URL (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6354\\\">#6354<\\/a>)<\\/li>\\n<li>Fix: Avoid <code>z-index<\\/code> changes by <code>nanocss<\\/code> in build process<\\/li>\\n<li>Fix: Added missing WC upsells products CSS<\\/li>\\n<li>Fix: Nav Menu dropdown losing color on hover<\\/li>\\n<li>Fix: WC Product Add-ons CSS compatibility<\\/li>\\n<\\/ul>\\n<h4>2.2.4 - 2018-12-04<\\/h4>\\n<ul>\\n<li>Fix: Global widget not saving changes (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6340\\\">#6340<\\/a>)<\\/li>\\n<li>Fix: Dynamic tags support in Blockquote widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6334\\\">#6334<\\/a>)<\\/li>\\n<li>Fix: Forms Redirect URL action when using form field values with spaces<\\/li>\\n<\\/ul>\\n<h4>2.2.3 - 2018-11-29<\\/h4>\\n<ul>\\n<li>Fix: Missing &quot;Edit Template&quot; in Template widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6271\\\">#6271<\\/a>)<\\/li>\\n<li>Fix: Follow menu anchors with UTF8 characters in Nav Menu<\\/li>\\n<li>Fix: Show only supported templates in Template widget<\\/li>\\n<li>Fix: Revert conflicting fix for a default order for WC archive<\\/li>\\n<\\/ul>\\n<h4>2.2.2 - 2018-11-28<\\/h4>\\n<ul>\\n<li>Fix: Lightbox dynamic tag crashes the editor<\\/li>\\n<\\/ul>\\n<h4>2.2.1 - 2018-11-28<\\/h4>\\n<ul>\\n<li>New: Added <code>ACF File<\\/code> Dynamic tag to support text controls.<\\/li>\\n<li>Tweak: Added option to hide item count bubble when cart is empty in Menu Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6223\\\">#6223<\\/a>)<\\/li>\\n<li>Tweak: Added Actions group for Lightbox and Contact URL tags<\\/li>\\n<li>Tweak: Added filter <code>elementor_pro\\/dynamic_tags\\/shortcode\\/should_escape<\\/code> to avoid escaping in Shortcode dynamic tag<\\/li>\\n<li>Tweak: MailPoet3 integration allow Subscriber to to subscribe to multiple lists<\\/li>\\n<li>Tweak: Added front-end max file size validation for upload fields<\\/li>\\n<li>Tweak: Added <code>by-author<\\/code> per Post-Type condition for theme builder<\\/li>\\n<li>Fix: Template widget panel not showing the selected template (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6271\\\">#6271<\\/a>)<\\/li>\\n<li>Fix: Conflict between ACF with Safari browser on Select option in Dynamic tag<\\/li>\\n<li>Fix: Add post classes only for the Single template<\\/li>\\n<li>Fix: Set document type as not editable for unsupported document like Global widget<\\/li>\\n<li>Fix: Avoid duplicate query for current WC product query<\\/li>\\n<li>Fix: Product Archive showing oldest products instead of latest<\\/li>\\n<li>Fix: CSS reset in Posts widget using cards skin<\\/li>\\n<\\/ul>\\n<h4>2.2.0 - 2018-11-19<\\/h4>\\n<ul>\\n<li>New: Introducing Custom Attributes (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/290\\\">#290<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3990\\\">#3990<\\/a>)<\\/li>\\n<li>New: Added evergreen option for Countdown widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4459\\\">#4459<\\/a>)<\\/li>\\n<li>New: Added expire actions option for Countdown widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5242\\\">#5242<\\/a>)<\\/li>\\n<li>New: Introducing Reviews widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3854\\\">#3854<\\/a>)<\\/li>\\n<li>New: Introducing Sitemap widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5594\\\">#5594<\\/a>)<\\/li>\\n<li>New: Added Request Parameter dynamic tag (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4934\\\">#4934<\\/a>)<\\/li>\\n<li>New: Added Shortcode dynamic tag<\\/li>\\n<li>New: Added Image and Video Lightbox dynamic tag<\\/li>\\n<li>New: Added Contact URL dynamic tag<\\/li>\\n<li>New: Added Featured Image Data dynamic tag<\\/li>\\n<li>New: Added default value to each field in the Form widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4268\\\">#4268<\\/a>)<\\/li>\\n<li>New: Added &quot;Any Child Of&quot; condition to template conditions (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5321\\\">#5321<\\/a>)<\\/li>\\n<li>New: Added &quot;In Child&quot; condition to template conditions (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5587\\\">#5587<\\/a>)<\\/li>\\n<li>Tweak: Added Form Redirect URL with form values (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2564\\\">#2564<\\/a>)<\\/li>\\n<li>Tweak: Added default post classes to template wrapper (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5959\\\">#5959<\\/a>)<\\/li>\\n<li>Tweak: Better labels for terms in Query control (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6092\\\">#6092<\\/a>)<\\/li>\\n<li>Tweak: Renamed &quot;Child Of&quot; templates condition to &quot;Direct Child Of&quot;<\\/li>\\n<li>Tweak: Added <code>elementor\\/theme\\/get_location_templates\\/condition_sub_id<\\/code> filter hook to allow template condition translations<\\/li>\\n<li>Tweak: Load the Template Library widget via Ajax for better performance<\\/li>\\n<li>Tweak: Added 404 page title for Page Title dynamic tag<\\/li>\\n<li>Fix: Menu Cart Toggle has # URL link (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6141\\\">#6141<\\/a>)<\\/li>\\n<li>Fix: Alignment issue in Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5790\\\">#5790<\\/a>)<\\/li>\\n<li>Fix: Avoid potential security risk in forms<\\/li>\\n<li>Fix: Template By Author condition conflicts with 404 page<\\/li>\\n<li>Fix: Restored WC Product Content widget in Single Product template<\\/li>\\n<li>Fix: Theme Builder Preview URLs for date archives and 404 pages<\\/li>\\n<li>Fix: Highlight active menu anchor items only when scrolled into view<\\/li>\\n<li>Fix: Carousel Pagination Progress style to support new Swiper version<\\/li>\\n<\\/ul>\\n<h4>2.1.13 - 2018-11-12<\\/h4>\\n<ul>\\n<li>Tweak: Added compatibility for new brand Finder in v2.3.0<\\/li>\\n<li>Fix: Settings conflict when there are multiple carousels in the page<\\/li>\\n<\\/ul>\\n<h4>2.1.12 - 2018-11-05<\\/h4>\\n<ul>\\n<li>Tweak: Added compatibility for the upcoming release of Elementor v2.3<\\/li>\\n<li>Tweak: Better performance for Template Library widget<\\/li>\\n<li>Fix: Fatal error if a taxonomy used in a dynamic field is removed (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6029\\\">#6029<\\/a>)<\\/li>\\n<li>Fix: Date Time dynamic tag now respect site language (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6001\\\">#6001<\\/a>)<\\/li>\\n<li>Fix: Custom CSS printed twice in the front-end<\\/li>\\n<li>Fix: ACF Image field PHP warning (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6051\\\">#6051<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>2.1.11 - 2018-10-22<\\/h4>\\n<ul>\\n<li>New: Added ACF local fields compatibility<\\/li>\\n<li>Tweak: Re-brand TypeKit by Adobe Fonts integration<\\/li>\\n<li>Fix: Exclude <code>is_embed<\\/code> from Singular condition (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5915\\\">#5915<\\/a>)<\\/li>\\n<li>Fix: Avoid conflict with Ad Blockers and Share Buttons<\\/li>\\n<li>Fix: Current date time dynamic tag now shows local time<\\/li>\\n<li>Fix: Avoid conflict with 3rd party plugins that filter the permalink<\\/li>\\n<li>Fix: Avoid PHP warning when no groups are selected for MailChimp integration<\\/li>\\n<li>Fix: Avoid PHP warning if checkbox field is empty for ACF<\\/li>\\n<li>Fix: Respect password protected for a WC single product template<\\/li>\\n<li>Fix: Respect <code>order<\\/code> settings for WC archive also without pagination<\\/li>\\n<\\/ul>\\n<h4>2.1.10 - 2018-10-09<\\/h4>\\n<ul>\\n<li>Tweak: Added responsive alignment control for Share Buttons widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5821\\\">#5821<\\/a>)<\\/li>\\n<li>Tweak: Added link control to Animated Headline widget<\\/li>\\n<li>Fix: Mobile nav menu jump on RTL (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5711\\\">#5711<\\/a>)<\\/li>\\n<li>Fix: Responsive alignment control in Add to Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5830\\\">#5830<\\/a>)<\\/li>\\n<li>Fix: Added IE compatibility for Animated Headline widget<\\/li>\\n<li>Fix: Post Content widget is now shown only on <code>Single<\\/code> templates<\\/li>\\n<li>Fix: Query Control Pagination with offset<\\/li>\\n<\\/ul>\\n<h4>2.1.9 - 2018-09-17<\\/h4>\\n<ul>\\n<li>Tweak: Added Centered Slides option for Slideshow carousel<\\/li>\\n<li>Fix: Allow only public CPT for Manual Selection in Query Control (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5091\\\">#5091<\\/a>)<\\/li>\\n<li>Fix: ACF Gallery option support (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5344\\\">#5344<\\/a>)<\\/li>\\n<li>Fix: Page scrolling on resize when sticky is active (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5740\\\">#5740<\\/a>)<\\/li>\\n<li>Fix: Edit custom name for Global Widget in the Navigator (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5689\\\">#5689<\\/a>)<\\/li>\\n<li>Fix: Coverflow transition effect in Carousel<\\/li>\\n<li>Fix: Weird mobile behavior with Cube effect in Carousel<\\/li>\\n<li>Fix: Show the first thumbnail in the Slideshow carousel correctly<\\/li>\\n<\\/ul>\\n<h4>2.1.8 - 2018-09-12<\\/h4>\\n<ul>\\n<li>Tweak: Added styling options for WC Additional Information widget<\\/li>\\n<li>Tweak: Added styling options for \'View Cart\' link in Products widget<\\/li>\\n<li>Fix: 3rd party plugin support for WC single product template (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5338\\\">#5338<\\/a>)<\\/li>\\n<li>Fix: Layout of Related Product widget with WC native style<\\/li>\\n<\\/ul>\\n<h4>2.1.7 - 2018-09-03<\\/h4>\\n<ul>\\n<li>New: WC Archive Description widget<\\/li>\\n<li>Tweak: Added blend mode to Slides widget background overlay (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5555\\\">#5555<\\/a>)<\\/li>\\n<li>Tweak: Added \'Current Subcategories\' option to Product Categories widget<\\/li>\\n<li>Fix: Added default vertical alignment in Author Box widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5589\\\">#5589<\\/a>)<\\/li>\\n<li>Tweak: Added more blend mode options for CTA widget<\\/li>\\n<li>Tweak: Improved plugin updater method based on WordPress version<\\/li>\\n<li>Fix: Improved IE compatibility for Posts and Portfolio widgets<\\/li>\\n<li>Fix: Added default gap for products pagination<\\/li>\\n<li>Fix: Post thumbnail flickering in Safari browser<\\/li>\\n<li>Fix: Close mobile nav menu on click only in full-width mode<\\/li>\\n<li>Fix: Added trailing slash to pagination links in Posts widget<\\/li>\\n<\\/ul>\\n<h4>2.1.6 - 2018-08-28<\\/h4>\\n<ul>\\n<li>New: WC Product Category Image widget and Dynamic tag (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5117\\\">#5117<\\/a>)<\\/li>\\n<li>Tweak: Allow HTML in Excerpt widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5491\\\">#5491<\\/a>)<\\/li>\\n<li>Tweak: Added compatibility for the upcoming release of Elementor v2.2<\\/li>\\n<li>Tweak: Deprecated Follow option in the Facebook Button widget<\\/li>\\n<li>Fix: Posts widget grid in Safari &amp; IE11 (Depended on Elementor v2.2)<\\/li>\\n<li>Fix: Posts widget CSS when using cards skin in masonry mode<\\/li>\\n<li>Fix: ACF Image &amp; ACF URL option support (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5344\\\">#5344<\\/a>)<\\/li>\\n<li>Fix: WC product gallery links in RTL<\\/li>\\n<li>Fix: Dynamic tags in Call To Action widget<\\/li>\\n<\\/ul>\\n<h4>2.1.5 - 2018-08-21<\\/h4>\\n<ul>\\n<li>Tweak: Added compatibility for the upcoming release of Elementor v2.2<\\/li>\\n<li>Fix: Posts Widget layout theme compatibility<\\/li>\\n<li>Fix: Added compatibility for WooCommerce native style<\\/li>\\n<\\/ul>\\n<h4>2.1.4 - 2018-08-19<\\/h4>\\n<ul>\\n<li>Fix: Layout issue compatibility with themes caused by v2.1 (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5442\\\">#5442<\\/a>)<\\/li>\\n<li>Fix: Dynamic setting in Pricing Table widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5460\\\">#5460<\\/a>)<\\/li>\\n<li>Fix: Hide Target URL control if is not necessary in Blockquote widget<\\/li>\\n<li>Fix: Selector specificity for WooCommerce Products widget<\\/li>\\n<li>Fix: WooCommerce conflicts in the editor in edge cases<\\/li>\\n<\\/ul>\\n<h4>2.1.3 - 2018-08-15<\\/h4>\\n<ul>\\n<li>Fix: Thumbnails in the Posts widget jumping (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5350\\\">#5350<\\/a>)<\\/li>\\n<li>Fix: Responsive grid in the Share Buttons widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5375\\\">#5375<\\/a>)<\\/li>\\n<li>Fix: Added missing <code>setup_postdata<\\/code> for Product Data Tabs widget<\\/li>\\n<li>Fix: Rollback to older version of Flip Box widget to resolve 3D depth issue (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5399\\\">#5399<\\/a>)<\\/li>\\n<li>Fix: Allowed types in the Upload File field are now case-insensitive (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5254\\\">#5254<\\/a>)<\\/li>\\n<li>Fix: Carousel behavior when using a single slide<\\/li>\\n<\\/ul>\\n<h4>2.1.2 - 2018-08-12<\\/h4>\\n<ul>\\n<li>Fix: Error when ACF Pro is not installed (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5367\\\">#5367<\\/a>)<\\/li>\\n<li>Fix: Edge cases in Inspector where document is a boolean<\\/li>\\n<li>Fix: Edge cases for incorrect file fields in PODS<\\/li>\\n<\\/ul>\\n<h4>2.1.1 - 2018-08-09<\\/h4>\\n<ul>\\n<li>Fix: Highlighted text in Animated Headline widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5345\\\">#5345<\\/a>)<\\/li>\\n<li>Fix: Flip Box effect issues<\\/li>\\n<li>Fix: ACF Options page fields support (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5329\\\">#5329<\\/a>)<\\/li>\\n<li>Fix: Import Pro templates in edge cases<\\/li>\\n<\\/ul>\\n<h4>2.1.0 - 2018-08-07<\\/h4>\\n<ul>\\n<li>New: Introducing WooCommerce Builder (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1690\\\">#1690<\\/a>)<\\/li>\\n<li>New: Introducing 12 new dynamic tags &amp; widgets for WooCommerce: Gallery, Image, Price, Rating, Description, Breadcrumbs, Data Tabs, Stock, Related, Upsell, Title &amp; Archive<\\/li>\\n<li>New: Introducing Cart Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4220\\\">#4220<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4600\\\">#4600<\\/a>)<\\/li>\\n<li>New: Added integration with Toolset (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2949\\\">#2949<\\/a>)<\\/li>\\n<li>New: Added integration with Pods (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4129\\\">#4129<\\/a>)<\\/li>\\n<li>New: Added stick to bottom in scrolling effects (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4799\\\">#4799<\\/a>)<\\/li>\\n<li>New: Added Scrolling Effect to Widgets under advanced tab<\\/li>\\n<li>New: Introducing Internal URL Dynamic Tag<\\/li>\\n<li>Tweak: Added a Last Updated Date in the Post Info widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4597\\\">#4597<\\/a>)<\\/li>\\n<li>Tweak: Added Redirect after Logout option for Login widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4447\\\">#4447<\\/a>)<\\/li>\\n<li>Tweak: Avoid repeating posts when using more than one in the Posts widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1878\\\">#1878<\\/a>)<\\/li>\\n<li>Tweak: Add Custom Query hook for Query control (<a href=\\\"https:\\/\\/developers.elementor.com\\/custom-query-filter\\/\\\">More Info<\\/a>) (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1748\\\">#1748<\\/a>)<\\/li>\\n<li>Tweak: Added form-message style (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1180\\\">#1180<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic tag for button on the Price Table widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4242\\\">#4242<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic tag for Call to action widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4767\\\">#4767<\\/a>)<\\/li>\\n<li>Tweak: Added Dynamic Tags support for Google Map field (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4602\\\">#4602<\\/a>)<\\/li>\\n<li>Tweak: Added an support for <code>label|value<\\/code> in options field (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4594\\\">#4594<\\/a>)<\\/li>\\n<li>Tweak: Added <code>by-author<\\/code> condition for theme builder (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4681\\\">#4681<\\/a>)<\\/li>\\n<li>Tweak: Added Activate\\/Deactivate license key via WP-CLI command (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4149\\\">#4149<\\/a>)<\\/li>\\n<li>Tweak: Added <code>is_scroll<\\/code> trigger to scrolling effect (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4340\\\">#4340<\\/a>)<\\/li>\\n<li>Tweak: Added In Same Term support for Post Navigation widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4177\\\">#4177<\\/a>)<\\/li>\\n<li>Tweak: Added responsive control for Slides To Scroll control in all carousel widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3697\\\">#3697<\\/a>)<\\/li>\\n<li>Tweak: Added style options for Posts widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1335\\\">#1335<\\/a>)<\\/li>\\n<li>Tweak: Added button CSS ID for Forms widget<\\/li>\\n<li>Tweak: Added pixel units to Post-Info divider height control<\\/li>\\n<li>Tweak: Rewrite sticky library to handle with stretch section, auto scroller &amp; more bugs<\\/li>\\n<li>Tweak: Re-organize the panel categories per document type<\\/li>\\n<li>Tweak: Added ACF support for <code>options-page<\\/code> fields<\\/li>\\n<li>Tweak: Added dynamic tag for Animated headlines<\\/li>\\n<li>Tweak: Added dynamic tag for BlockQuote widget<\\/li>\\n<li>Fix: Elementor Full Width template in GeneratePress theme (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4817\\\">#4817<\\/a>)<\\/li>\\n<li>Fix: Checkbox fields can accidentally be set to required (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4324\\\">#4324<\\/a>)<\\/li>\\n<li>Fix: Initial slide in Carousel widget<\\/li>\\n<li>Fix: Stay on current slide while editing in Carousel widget<\\/li>\\n<li>Fix: Default slides per device in Carousel widget<\\/li>\\n<li>Deprecated: Woo Products, Woo Elements &amp; Single elements widgets<\\/li>\\n<\\/ul>\\n<h4>2.0.18 - 2018-07-27<\\/h4>\\n<ul>\\n<li>Fix: Global widget error on saving page<\\/li>\\n<\\/ul>\\n<h4>2.0.17 - 2018-07-26<\\/h4>\\n<ul>\\n<li>Fix: Sub menu indicator direction in Nav Menu widget<\\/li>\\n<li>Fix: Change the title and icon for Global Widget when is moving<\\/li>\\n<li>Fix: CSS wrapper selector for Page Document<\\/li>\\n<\\/ul>\\n<h4>2.0.16 - 2018-07-16<\\/h4>\\n<ul>\\n<li>Tweak: CSS Filter Control module is now included in Elementor<\\/li>\\n<li>Fix: Border gap in Portfolio widget when item gap set as <code>0<\\/code> (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5077\\\">#5077<\\/a>)<\\/li>\\n<li>Fix: Restore current query after get Global Widget data<\\/li>\\n<li>Fix: Add action item in History on unlink Global widget<\\/li>\\n<\\/ul>\\n<h4>2.0.15 - 2018-07-10<\\/h4>\\n<ul>\\n<li>Fix: Dropdown menu items collapsing when activated (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4996\\\">#4996<\\/a>)<\\/li>\\n<li>Fix: GMT offset in Countdown widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4997\\\">#4997<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>2.0.14 - 2018-07-08<\\/h4>\\n<ul>\\n<li>Tweak: Added set method to form record for developers (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4983\\\">#4983<\\/a>)<\\/li>\\n<li>Fix: Autoplay option for Carousels<\\/li>\\n<li>Fix: Close mobile menu on item click in the Nav Menu widget<\\/li>\\n<\\/ul>\\n<h4>2.0.13 - 2018-07-03<\\/h4>\\n<ul>\\n<li>Tweak: Added compatibility for Elementor v2.1<\\/li>\\n<\\/ul>\\n<h4>2.0.12 - 2018-07-02<\\/h4>\\n<ul>\\n<li>Fix: Global widget PHP notices<\\/li>\\n<li>Fix: Slides widget active slide lost focus when clicking Editor tabs<\\/li>\\n<li>Fix: Form select field send all selected values on multiple selection<\\/li>\\n<li>Fix: Validate time field only if it\'s not empty<\\/li>\\n<li>Fix: ConvertKit API not saving name field<\\/li>\\n<\\/ul>\\n<h4>2.0.11 - 2018-06-12<\\/h4>\\n<ul>\\n<li>Fix: Theme Builder <code>author<\\/code> archive condition (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4593\\\">#4593<\\/a>)<\\/li>\\n<li>Fix: Respect password protected posts in Post Content widget<\\/li>\\n<li>Fix: Custom Fonts redirect to post edit screen in edge cases.<\\/li>\\n<\\/ul>\\n<h4>2.0.10 - 2018-06-05<\\/h4>\\n<ul>\\n<li>Tweak: Added <code>elementor\\/theme\\/get_location_templates\\/template_id<\\/code> filter hook for multi-language plugins<\\/li>\\n<li>Fix: Dynamic Post Terms missing taxonomies if the taxonomy is registered to more then one post types (#4386)<\\/li>\\n<li>Fix: Fields shortcode missing after removing a field in Form widget<\\/li>\\n<li>Deprecated: <code>get_theme_templates_by_location<\\/code> is replaced by <code>get_location_templates<\\/code><\\/li>\\n<\\/ul>\\n<h4>2.0.9 - 2018-05-28<\\/h4>\\n<ul>\\n<li>Fix: Compatibility for PHP version 5.4<\\/li>\\n<\\/ul>\\n<h4>2.0.8 - 2018-05-28<\\/h4>\\n<ul>\\n<li>Tweak: Added Active state for Nav Menu dropdown<\\/li>\\n<li>Tweak: Added style for &quot;Nothing Found&quot; Message for Archive Posts widget<\\/li>\\n<li>Tweak: Removed caption control in Site Logo widget<\\/li>\\n<li>Tweak: Added option to position currency symbol before\\/after In Price Table widget<\\/li>\\n<li>Fix: Query control manual selection does not show more than 10 items (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4479\\\">#4479<\\/a>)<\\/li>\\n<li>Fix: Styling glitch with terms list in Post Info widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4342\\\">#4342<\\/a>)<\\/li>\\n<li>Fix: Sub terms missing in Query control in edge cases (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4527\\\">#4527<\\/a>)<\\/li>\\n<li>Fix: Avoid rendering a template if it\'s not published<\\/li>\\n<li>Fix: 404 Page style not working<\\/li>\\n<li>Fix: Price Table button with hover animation not working in editor<\\/li>\\n<li>Fix: Styling conflict in Call to Action widget<\\/li>\\n<li>Fix: Global Widget tab translation<\\/li>\\n<li>Fix: Adding parent wrapper class to Site Title widget<\\/li>\\n<\\/ul>\\n<h4>2.0.7 - 2018-05-16<\\/h4>\\n<ul>\\n<li>Fix: Content not found on section when single is set to &quot;All Singular&quot;<\\/li>\\n<li>Fix: Open 404 template library for 404 page<\\/li>\\n<li>Tweak: Added CSS prefix for dev files<\\/li>\\n<li>Tweak: Removed product post type from display conditions<\\/li>\\n<\\/ul>\\n<h4>2.0.6 - 2018-05-15<\\/h4>\\n<ul>\\n<li>Tweak: Set type on create new single template<\\/li>\\n<li>Tweak: Always show the conditions dialog in the Draft status<\\/li>\\n<li>Tweak: Added document type <code>widget<\\/code><\\/li>\\n<li>Tweak: Added Post Custom Field tag to URL category<\\/li>\\n<li>Fix: When ACF Field Groups are Empty (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4428\\\">#4428<\\/a>)<\\/li>\\n<li>Fix: Links inside carousel in edge cases<\\/li>\\n<li>Fix: Responsive issue in My Templates area<\\/li>\\n<li>Fix: Image alignment for post content with text alignment<\\/li>\\n<li>Fix: Post Content widget when preview post is missing<\\/li>\\n<li>Fix: Global Widget tab translation<\\/li>\\n<li>Fix: Style settings for Post \\/ Archive Title widgets<\\/li>\\n<\\/ul>\\n<h4>2.0.5 - 2018-05-08<\\/h4>\\n<ul>\\n<li>Fix: Creating a CPT with name like document-type breaks the editor (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4203\\\">#4203<\\/a>)<\\/li>\\n<li>Fix: Added support for new version of reCAPTCHA<\\/li>\\n<li>Fix: Added fallback for controls after <code>post_status<\\/code><\\/li>\\n<li>Fix: Required field in forms widget<\\/li>\\n<li>Fix: Media Carousel in the Coverflow skin<\\/li>\\n<li>Fix: 404 Page show wrong template in edge cases<\\/li>\\n<li>Fix: Save the default menu in the Nav Menu widget<\\/li>\\n<\\/ul>\\n<h4>2.0.4 - 2018-05-02<\\/h4>\\n<ul>\\n<li>Tweak: Added parent\'s class for extended widgets<\\/li>\\n<li>Tweak: Set entire-site as default to avoid conflict with save without conditions<\\/li>\\n<li>Tweak: Initialize global model when it\'s needed<\\/li>\\n<li>Tweak: Removed some duplicate strings<\\/li>\\n<li>Tweak: Query control now includes empty terms<\\/li>\\n<li>Tweak: Design polish for conditions dialog<\\/li>\\n<li>Tweak: Decreasing <code>minimumInputLength<\\/code> to 1 of select2<\\/li>\\n<li>Fix: Editor not loading for single templates in edge cases<\\/li>\\n<li>Fix: Select2 in Safari takes it\'s time to get the original select width (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4310\\\">#4310<\\/a>)<\\/li>\\n<li>Fix: Slides per view not working for some effects<\\/li>\\n<li>Fix: New slides not showing in the editor<\\/li>\\n<li>Fix: Editor for section without a defined location, defaults to content area<\\/li>\\n<\\/ul>\\n<h4>2.0.3 - 2018-04-24<\\/h4>\\n<ul>\\n<li>Tweak: Optimize CSS for Post Info widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4214\\\">#4214<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4216\\\">#4216<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4225\\\">#4225<\\/a>)<\\/li>\\n<li>Fix: Double render on frontend view in core locations<\\/li>\\n<li>Fix: Masonry not working in edge cases<\\/li>\\n<li>Fix: Added default setting for Author Info tag<\\/li>\\n<\\/ul>\\n<h4>2.0.2 - 2018-04-18<\\/h4>\\n<ul>\\n<li>Fix: Regenerate conditions to include all templates<\\/li>\\n<\\/ul>\\n<h4>2.0.1 - 2018-04-17<\\/h4>\\n<ul>\\n<li>Tweak: Added div wrapper for Nothing Found massage (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4136\\\">#4136<\\/a>)<\\/li>\\n<li>Tweak: Show empty categories in Query Control &amp; Display Conditions (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4127\\\">#4127<\\/a>)<\\/li>\\n<li>Tweak: Added Divider control for Post Info widget<\\/li>\\n<li>Fix: Update admin links in Yoast Breadcrumbs widget<\\/li>\\n<li>Fix: Sticky element conflict with clearfix CSS<\\/li>\\n<li>Fix: Compatibility for PHP version 5.4.32 &amp; 5.5.16 and below<\\/li>\\n<li>Fix: Avoid running <code>wp_head<\\/code> hooks twice<\\/li>\\n<\\/ul>\\n<h4>2.0.0 - 2018-04-16<\\/h4>\\n<ul>\\n<li>New: Introducing Theme Builder - <a href=\\\"https:\\/\\/elementor.com\\/introducing-theme-builder\\/\\\">Release Post<\\/a> (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/417\\\">#417<\\/a>)<\\/li>\\n<li>New: Introducing Locations API to inject custom location templates<\\/li>\\n<li>New: Introducing Display Conditions for all dynamic templates<\\/li>\\n<li>New: Introducing Dynamic Tag feature - a new way to add dynamic content to your design<\\/li>\\n<li>New: Introducing Role manager to allow &quot;Content Only mode&quot; (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/483\\\">#483<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/653\\\">#653<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/885\\\">#885<\\/a>)<\\/li>\\n<li>New: Introducing 9 new dynamic widgets: Archive Posts, Archive Title, Post Content, Post Info, Post Title, Post Excerpt, Featured Image, Site Logo &amp; Site Name (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/543\\\">#543<\\/a>)<\\/li>\\n<li>New: Introducing Developers area with guides and API documentation - <a href=\\\"https:\\/\\/elementor.com\\/introducing-elementor-developer-api\\/\\\">Release Post<\\/a> (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/451\\\">#451<\\/a>)<\\/li>\\n<li>New: Introducing <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor-hello-theme\\\">Elementor Hello Theme<\\/a> - A demonstration theme for developers<\\/li>\\n<li>New: Added new type of templates: Header, Footer, Single and Archive (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2761\\\">#2761<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2623\\\">#2623<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2109\\\">#2109<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2061\\\">#2061<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2439\\\">#2439<\\/a>)<\\/li>\\n<li>New: Design 404 page with Single template (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1558\\\">#1558<\\/a>)<\\/li>\\n<li>New: Design Search Results with Archive template (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3196\\\">#3196<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2590\\\">#2590<\\/a>)<\\/li>\\n<li>New: Added Scrolling Effect for sections including <em>Sticky Element<\\/em> per device (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2412\\\">#2412<\\/a>)<\\/li>\\n<li>New: Integration with Custom Fields (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2054\\\">#2054<\\/a>)<\\/li>\\n<li>New: Partial support for Toolset integration (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2949\\\">#2949<\\/a>)<\\/li>\\n<li>New: Partial support for Pods integration (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2169\\\">#2169<\\/a>)<\\/li>\\n<li>New: Partial support for ACF integration (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2041\\\">#2041<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2059\\\">#2059<\\/a>)<\\/li>\\n<li>Tweak: Add custom fields support for ActiveCampaign (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3531\\\">#3531<\\/a>)<\\/li>\\n<li>Tweak: Allow brackets in Forms Tel field<\\/li>\\n<li>Tweak: Added currency format control for Price Table widget<\\/li>\\n<li>Tweak: Reduced API request for some servers<\\/li>\\n<li>Fix: Dropdown <code>border-radius<\\/code> in Nav Menu widget<\\/li>\\n<li>Fix: Price List widget layout breaks in edge cases<\\/li>\\n<li>Note: This version requires Elementor v2.0.6<\\/li>\\n<\\/ul>\\n<h4>1.15.6 - 2018-03-28<\\/h4>\\n<ul>\\n<li>Fix: Removed duplicate Custom CSS section (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3938\\\">#3938<\\/a>)<\\/li>\\n<li>Fix: <code>box-shadow<\\/code> issue with cards skin (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3940\\\">#3940<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>1.15.5 - 2018-03-27<\\/h4>\\n<ul>\\n<li>Fix: Added global widget compatibility for Elementor v2.0<\\/li>\\n<li>Fix: Reduced API request for some servers<\\/li>\\n<\\/ul>\\n<h4>1.15.4 - 2018-03-26<\\/h4>\\n<ul>\\n<li>Tweak: Allow brackets in phone field<\\/li>\\n<li>Tweak: Added compatibility with Yoast 7.0.+<\\/li>\\n<li>Tweak: Added compatibility for the future release of Elementor v2.0<\\/li>\\n<li>Fix: Support for multiple carousel setting in editor<\\/li>\\n<li>Fix: <code>on_export<\\/code> issue in forms widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3890\\\">#3890<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>1.15.3 - 2018-03-07<\\/h4>\\n<ul>\\n<li>Tweak: Added unique class to field group div (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3595\\\">#3595<\\/a>)<\\/li>\\n<li>Fix: Screen Options missing when Pro is active (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3622\\\">#3622<\\/a>)<\\/li>\\n<li>Fix: Allow label styling even when <code>show labels<\\/code> is set hide (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3544\\\">#3544<\\/a>)<\\/li>\\n<li>Fix: Typography control not working in edge cases<\\/li>\\n<li>Fix: Safari compatibility for Search widget<\\/li>\\n<\\/ul>\\n<h4>1.15.2 - 2018-02-27<\\/h4>\\n<ul>\\n<li>Fix: Only add support mine-type if needed (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3543\\\">#3543<\\/a>)<\\/li>\\n<li>Fix: Better support for Old Typekit kits<\\/li>\\n<\\/ul>\\n<h4>1.15.1 - 2018-02-21<\\/h4>\\n<ul>\\n<li>Tweak: Custom font title placeholder is not <code>enter font family<\\/code><\\/li>\\n<li>Tweak: Custom font title set as required<\\/li>\\n<li>Fix: Custom font, <code>font-face<\\/code> enqueued only once if used in global (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3513\\\">#3513<\\/a>)<\\/li>\\n<li>Fix: Added workaround for upload validation which relies on a PHP extension (fileinfo) with inconsistent reporting behavior.<\\/li>\\n<\\/ul>\\n<h4>1.15.0 - 2018-02-19<\\/h4>\\n<ul>\\n<li>New: Added custom fonts manager for self hosted fonts (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/852\\\">#852<\\/a>)<\\/li>\\n<li>New: Integration with Adobe TypeKit fonts (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/631\\\">#631<\\/a>)<\\/li>\\n<li>Tweak: Clear menu from Nav Menu widget on template export<\\/li>\\n<li>Tweak: Allow zero for GetResponse integration as <code>day of cycle<\\/code><\\/li>\\n<\\/ul>\\n<h4>1.14.2 - 2018-02-13<\\/h4>\\n<ul>\\n<li>Fix: Global widget content that got affected by previous update<\\/li>\\n<\\/ul>\\n<h4>1.14.1 - 2018-02-13<\\/h4>\\n<ul>\\n<li>Tweak: Added <code>none<\\/code> option to content animation in CTA widget<\\/li>\\n<li>Tweak: Added <code>form_id<\\/code> to ActiveCampaign integration (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3422\\\">#3422<\\/a>)<\\/li>\\n<li>Fix: Page crashed when Global widget not found.<\\/li>\\n<\\/ul>\\n<h4>1.14.0 - 2018-02-12<\\/h4>\\n<ul>\\n<li>New: Added Call to Action widget<\\/li>\\n<li>Tweak: MailPoet pull field mapping from MailPoet instead of hardcoded<\\/li>\\n<li>Tweak: Added compatibility for the future release of Elementor v2.0<\\/li>\\n<li>Fix: Allow zero (0) to be accepted as a field value<\\/li>\\n<li>Fix: Login form when custom login URL is set<\\/li>\\n<li>Fix: Added Day of cycle control to GetResponse integration<\\/li>\\n<\\/ul>\\n<h4>1.13.2 - 2018-01-23<\\/h4>\\n<ul>\\n<li>Tweak: Added placeholder to Password field<\\/li>\\n<li>Tweak: Removed <code>subscriber_already_exists_message<\\/code> control to prevent potential data leakage<\\/li>\\n<li>Fix: MailPoet Subscriber Already Exists error validation against translated string directly from MailPoet<\\/li>\\n<li>Fix: Changed <code>imagesLoaded()<\\/code> to Vanilla JS to avoid compatibility issues with some themes<\\/li>\\n<li>Fix: Only validate Tel field if not empty<\\/li>\\n<li>Fix: Stop slider while editing<\\/li>\\n<\\/ul>\\n<h4>1.13.1 - 2018-01-16<\\/h4>\\n<ul>\\n<li>Fix: Added compatibility with old PHP versions<\\/li>\\n<\\/ul>\\n<h4>1.13.0 - 2018-01-16<\\/h4>\\n<ul>\\n<li>New: Added File Upload field for Forms widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1482\\\">#1482<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2974\\\">#2974<\\/a>)<\\/li>\\n<li>New: Added Acceptance field for Forms widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1693\\\">#1693<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2974\\\">#2974<\\/a>)<\\/li>\\n<li>New: Added Date field for Forms widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1868\\\">#1868<\\/a>)<\\/li>\\n<li>New: Added Time field for Forms widget<\\/li>\\n<li>New: Added Password field for Forms widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2164\\\">#2164<\\/a>)<\\/li>\\n<li>New: Added HTML field for Forms widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1500\\\">#1500<\\/a>)<\\/li>\\n<li>Tweak: Added characters validation for Tel field<\\/li>\\n<li>Tweak: Added min &amp; max validation for Number field<\\/li>\\n<li>Tweak: Added multiple selection for Select field<\\/li>\\n<li>Tweak: Added donReach integration for Share Buttons widget<\\/li>\\n<\\/ul>\\n<h4>1.12.3 - 2018-01-09<\\/h4>\\n<ul>\\n<li>Fix: Render element plain content instead of parsed content when not needed in global widget<\\/li>\\n<li>Fix: Apply <code>url-encoding<\\/code> to &quot;Tweet&quot; button text in Blockquote widget to prevent unexpected corruption of the tweet text<\\/li>\\n<li>Fix: Removed My Account link from dashboard widget<\\/li>\\n<\\/ul>\\n<h4>1.12.2 - 2018-01-03<\\/h4>\\n<ul>\\n<li>Tweak: Added animation none for Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2964\\\">#2964<\\/a>)<\\/li>\\n<li>Fix: Active license button style<\\/li>\\n<\\/ul>\\n<h4>1.12.1 - 2018-01-02<\\/h4>\\n<ul>\\n<li>Tweak: Removed theme-element widgets from plain content<\\/li>\\n<li>Tweak: Set all theme-element widgets to extend same widget Base<\\/li>\\n<li>Tweak: Removed credit URL in forms meta data<\\/li>\\n<li>Tweak: Added compatibility for the future release of Elementor v1.9<\\/li>\\n<li>Fix: Validate Get response Error as real error<\\/li>\\n<li>Fix: Removed responsive height control from Facebook Page widget<\\/li>\\n<\\/ul>\\n<h4>1.12.0 - 2017-12-20<\\/h4>\\n<ul>\\n<li>New: Added Drip integration to Forms<\\/li>\\n<li>New: Added ActiveCampaign integration to Forms<\\/li>\\n<li>New: Added ConverKit integration to Forms<\\/li>\\n<li>New: Added GetResponse integration to Forms<\\/li>\\n<li>New: Added form <code>id<\\/code>, <code>name<\\/code> attributes to handle integration with auto collectors like HubSpot<\\/li>\\n<li>New: Added Global API key for MailChimp to improve the workflow<\\/li>\\n<li>Tweak: Better error handling and message display for Forms<\\/li>\\n<li>Fix: PHP notice Undefined variable <code>$cc_header<\\/code> (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2934\\\">#2934<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>1.11.0 - 2017-12-11<\\/h4>\\n<ul>\\n<li>New: Added a native Comments widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/543\\\">#543<\\/a>)<\\/li>\\n<li>New: Added an Author Box widget<\\/li>\\n<li>New: Added a Post Navigation widget<\\/li>\\n<li>New: Added a Yoast Breadcrumbs widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2749\\\">#2749<\\/a>)<\\/li>\\n<li>Tweak: Added a close button to search widget under Full Screen skin (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2762\\\">#2762<\\/a>)<\\/li>\\n<li>Fix: Allow currency symbol to appear even if price isn\'t numeric<\\/li>\\n<li>Fix: Edge cases when the nav menu is empty in a stretched section<\\/li>\\n<li>Fix: Added fallback when you remove the <code>space-between<\\/code> on Swiper carousel<\\/li>\\n<\\/ul>\\n<h4>1.10.2 - 2017-12-03<\\/h4>\\n<ul>\\n<li>Fix: Missing save widget icon (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2878\\\">#2878<\\/a>)<\\/li>\\n<li>Fix: Global widgets not saving edits (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2874\\\">#2874<\\/a>)<\\/li>\\n<li>Fix: Removed <code>white-space: nowrap;<\\/code> property from vertical menu in Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2815\\\">#2815<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>1.10.1 - 2017-11-30<\\/h4>\\n<ul>\\n<li>Tweak: Added default value for search form<\\/li>\\n<li>Tweak: Order template list A-Z in the library widget<\\/li>\\n<li>Tweak: get_users\\/authors query is now done using AJAX only, for better performance in Query Control (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2865\\\">#2865<\\/a>)<\\/li>\\n<li>Fix: When adding <code>.00<\\/code> it is not displayed on the front<\\/li>\\n<li>Fix: Make sure space between is numeric for carousel control<\\/li>\\n<li>Fix: Added space for radio &amp; checkbox fields in form widget<\\/li>\\n<\\/ul>\\n<h4>1.10.0 - 2017-11-15<\\/h4>\\n<ul>\\n<li>New: Added native Search form widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2576\\\">#2576<\\/a>)<\\/li>\\n<li>Tweak: Added Slides To Scroll &amp; Loop controls to Media Carousel and Testimonials widgets<\\/li>\\n<li>Tweak: Added Inline editing to Blockquote widget<\\/li>\\n<li>Fix: Animated Headline color bug (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2516\\\">#2516<\\/a>)<\\/li>\\n<li>Fix: Animated Headline with Rotating skin<\\/li>\\n<li>Fix: RTL fix for Animated Headline widget in \'typing\' and \'clip\' animations<\\/li>\\n<li>Fix: Empty menu cause jQuery to crash in Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2662\\\">#2662<\\/a>)<\\/li>\\n<li>Fix: Custom CSS gone after reloading the editor<\\/li>\\n<\\/ul>\\n<h4>1.9.5 - 2017-10-27<\\/h4>\\n<ul>\\n<li>Fix: Broken Global widget with JS (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2639\\\">#2639<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>1.9.4 - 2017-10-24<\\/h4>\\n<ul>\\n<li>Tweak: Improved UI for notices and license page<\\/li>\\n<li>Fix: Update system conflict with other EDD plugins<\\/li>\\n<li>Fix: WooCommerce frontend hooks on Elementor editor (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2577\\\">#2577<\\/a>)<\\/li>\\n<li>Fix: Removed default border left in Nav Menu dropdown CSS (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2496\\\">#2496<\\/a>)<\\/li>\\n<li>Fix: Increased submenu max-width (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2558\\\">#2558<\\/a>)<\\/li>\\n<li>Fix: Save global templates without their defaults<\\/li>\\n<li>Fix: Horizontal scrolling issue with posts grid<\\/li>\\n<\\/ul>\\n<h4>1.9.3 - 2017-10-03<\\/h4>\\n<ul>\\n<li>Fix: Condition slide style that got affected by previous update<\\/li>\\n<\\/ul>\\n<h4>1.9.2 - 2017-10-02<\\/h4>\\n<ul>\\n<li>New: Added integration with MailPoet 3 for Forms actions<\\/li>\\n<li>Fix: Removed height control from Testimonial carousel in mobile editing mode<\\/li>\\n<li>Fix: Removed bottom padding when there\'s no pagination in Testimonial carousel<\\/li>\\n<li>Fix: Added condition for slides style section in skin bubble mode<\\/li>\\n<li>Fix: Slides per view control for mobile editing in Testimonial carousel<\\/li>\\n<li>Fix: Navigation Arrows icons matched with common Elementor Navigation Arrows<\\/li>\\n<\\/ul>\\n<h4>1.9.1 - 2017-09-28<\\/h4>\\n<ul>\\n<li>Fix: Slides per view for slideshow carousel<\\/li>\\n<li>Fix: Final polish for the new Testimonial Carousel widget<\\/li>\\n<li>Fix: Don\'t play video if slide type is not video<\\/li>\\n<li>Fix: Removed slides style section condition (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2497\\\">#2497<\\/a>)<\\/li>\\n<li>Fix: Set cursor as pointer for slideshow thumbnails<\\/li>\\n<\\/ul>\\n<h4>1.9.0 - 2017-09-26<\\/h4>\\n<ul>\\n<li>New: Added Media Carousel widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/216\\\">#216<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/347\\\">#347<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2209\\\">#2209<\\/a>)<\\/li>\\n<li>New: Added Testimonial Carousel widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/715\\\">#715<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>1.8.3 - 2017-09-24<\\/h4>\\n<ul>\\n<li>Fix: Added compatibility for WordPress 4.8.2 &amp; 4.7.6<\\/li>\\n<li>Fix: Remove slashes from Form sent data<\\/li>\\n<\\/ul>\\n<h4>1.8.2 - 2017-09-19<\\/h4>\\n<ul>\\n<li>Tweak: Added target URL for the tweet message in Blockquote widget<\\/li>\\n<li>Tweak: Render the slide height before the slider is finished loading<\\/li>\\n<li>Fix: Space between words for Animated Headline widget<\\/li>\\n<li>Fix: RTL compatibility for Animated Headline widget<\\/li>\\n<li>Fix: Italic font style for Animated Headline widget<\\/li>\\n<li>Fix: Excluded Menu widget from the WP Editor text rendering<\\/li>\\n<\\/ul>\\n<h4>1.8.1 - 2017-09-18<\\/h4>\\n<ul>\\n<li>Fix: WCAG Compatible &quot;required&quot; field attribute for W3C validation (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2391\\\">#2391<\\/a>)<\\/li>\\n<li>Fix: Print the main menu only when is necessary in Menu widget<\\/li>\\n<li>Fix: Use CSS media query instead of JS to hide items in Menu widget to avoid flickering on page load (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2381\\\">#2381<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>1.8.0 - 2017-09-12<\\/h4>\\n<ul>\\n<li>New: Added Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1406\\\">#1406<\\/a>)<\\/li>\\n<li>Fix: Field ID for checkbox control in Form widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2279\\\">#2279<\\/a>)<\\/li>\\n<li>Fix: Style for Blockquote widget included<\\/li>\\n<\\/ul>\\n<h4>1.7.2 - 2017-09-07<\\/h4>\\n<ul>\\n<li>Tweak: Loading Facebook SDK via JS for better compatibility with caching plugins<\\/li>\\n<li>Fix: Responsive Embed Facebook post widget for Safari iOS (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2340\\\">#2340<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>1.7.1 - 2017-09-05<\\/h4>\\n<ul>\\n<li>Fix: Facebook SDK version<\\/li>\\n<\\/ul>\\n<h4>1.7.0 - 2017-09-05<\\/h4>\\n<ul>\\n<li>New: Added Facebook Button widget for Like, Recommend, Share and Follow<\\/li>\\n<li>New: Added Facebook Embed widget for Post, Video and Comment<\\/li>\\n<li>New: Added Facebook Comments widget<\\/li>\\n<li>New: Added Facebook Page widget (Previously known as Like Box)<\\/li>\\n<li>New: Added Blockquote widget with Tweet button<\\/li>\\n<li>Tweak: Added Facebook SDK integration for all Facebook widgets<\\/li>\\n<li>Fix: Animated headline rotating with long words<\\/li>\\n<\\/ul>\\n<h4>1.6.1 - 2017-08-28<\\/h4>\\n<ul>\\n<li>Fix: Animated Headline marker gets in front of neighboring spans even when &quot;Bring to Front&quot; is not set<\\/li>\\n<li>Fix: Stroke animation in Animated Headline for MS Edge browser<\\/li>\\n<li>Fix: Animated headline with more than 1-word per rotation<\\/li>\\n<li>Fix: Animated Headline in two lines<\\/li>\\n<li>Fix: Some errors in Global widget<\\/li>\\n<\\/ul>\\n<h4>1.6.0 - 2017-08-22<\\/h4>\\n<ul>\\n<li>New: Added Animated Headline widget<\\/li>\\n<li>New: Added Hidden field for Forms widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2038\\\">#2038<\\/a>)<\\/li>\\n<li>Tweak: Added notice to update Elementor to v1.6.5 or higher<\\/li>\\n<li>Fix: CSS Animations names no longer minified, in order to prevent unexpected conflicts<\\/li>\\n<\\/ul>\\n<h4>1.5.9 - 2017-08-16<\\/h4>\\n<ul>\\n<li>Tweak: Added compatibility for the future release of Elementor v1.7<\\/li>\\n<li>Fix: Portfolio compatibility for GeneratePress theme<\\/li>\\n<li>Fix: Portfolio filter compatibility for RTL<\\/li>\\n<li>Fix: Pagination apply for all posts widget in the page<\\/li>\\n<li>Fix: Global form widget with MailChimp integration not saving<\\/li>\\n<\\/ul>\\n<h4>1.5.8 - 2017-07-25<\\/h4>\\n<ul>\\n<li>Tweak: Added compatibility for the future release of Elementor v1.6<\\/li>\\n<li>Fix: Improved backward compatibility for query control rename<\\/li>\\n<\\/ul>\\n<h4>1.5.7 - 2017-07-24<\\/h4>\\n<ul>\\n<li>Tweak: Moved JS render of reCAPTCHA to a separate file<\\/li>\\n<li>Tweak: Display the label in the reCAPTCHA field for better experience<\\/li>\\n<li>Tweak: Rename <code>panel-posts-control<\\/code> to <code>query-control<\\/code> and added fallback support<\\/li>\\n<li>Tweak: Added compatibility for the future release of Elementor with history feature<\\/li>\\n<li>Fix: reCAPTCHA preview on the editor<\\/li>\\n<li>Fix: Manual selection (query control) has stopped working after saving (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2000\\\">#2000<\\/a>)<\\/li>\\n<li>Fix: Added condition for icon size control in Share Buttons widget<\\/li>\\n<\\/ul>\\n<h4>1.5.6 - 2017-07-12<\\/h4>\\n<ul>\\n<li>Fix: Query Control correction for taxonomies (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1963\\\">#1963<\\/a>)<\\/li>\\n<li>Fix: Custom CSS override scheme color in the editor<\\/li>\\n<li>Fix: Added order by Menu Order for Query Control in WC widget<\\/li>\\n<li>Fix: Glitch with Flip Box background overlay<\\/li>\\n<\\/ul>\\n<h4>1.5.5 - 2017-07-03<\\/h4>\\n<ul>\\n<li>Tweak: Moved reCAPTCHA render to handler &amp; load only if a form is exist<\\/li>\\n<li>Fix: MailChimp integration: Default number of items returned by API increased to 999<\\/li>\\n<li>Fix: MailChimp integration: Refresh the groups list if API is changed<\\/li>\\n<li>Fix: Sorted items in filter bar by A-Z<\\/li>\\n<li>Fix: Editor glitch with Elementor v1.5 (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1927\\\">#1927<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>1.5.4 - 2017-06-22<\\/h4>\\n<ul>\\n<li>Tweak: Improved compatibility for Elementor v1.5<\\/li>\\n<li>Fix: URL default for Add To Cart widget<\\/li>\\n<li>Fix: Allowed <code>date<\\/code> and <code>birthday<\\/code> fields as text for MailChimp integration<\\/li>\\n<\\/ul>\\n<h4>1.5.3 - 2017-06-19<\\/h4>\\n<ul>\\n<li>Tweak: Make flip-box height responsive control<\\/li>\\n<li>Fix: Facebook share count now gets retrieved by Elementor (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1829\\\">#1829<\\/a>)<\\/li>\\n<li>Fix: Global form widget with MailChimp integration not saving<\\/li>\\n<\\/ul>\\n<h4>1.5.2 - 2017-06-13<\\/h4>\\n<ul>\\n<li>Fix: Custom CSS panel location compatibility for the old versions<\\/li>\\n<\\/ul>\\n<h4>1.5.1 - 2017-06-12<\\/h4>\\n<ul>\\n<li>Fix: MailChimp update existing user registration<\\/li>\\n<li>Fix: Global widget with JS in the editor mode<\\/li>\\n<li>Fix: Label section condition in Login widget<\\/li>\\n<li>Fix: Changes to unlinked global widget do not appear in the editor<\\/li>\\n<\\/ul>\\n<h4>1.5.0 - 2017-05-23<\\/h4>\\n<ul>\\n<li>New: Added Cards, a new skin for Posts widget<\\/li>\\n<li>New: Added Exclude option to post query control group<\\/li>\\n<li>Tweak: Added <code>post_class()<\\/code> for each post in the loop<\\/li>\\n<li>Tweak: Added <code>.elementor-posts-masonry<\\/code> class when Masonry layout is enabled<\\/li>\\n<li>Tweak: Added compatibility for the next release of Elementor v1.5.0<\\/li>\\n<li>Tweak: CSS <code>autoprefixer<\\/code> now supports last 5 versions of browsers<\\/li>\\n<li>Tweak: Added <code>imageLoaded<\\/code> library for Posts &amp; Portfolio widgets<\\/li>\\n<\\/ul>\\n<h4>1.4.4 - 2017-05-18<\\/h4>\\n<ul>\\n<li>Fix: Force Mailchimp API to return all lists and not just 10 (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1683\\\">#1683<\\/a>)<\\/li>\\n<li>Fix: Added <code>.elementor-form<\\/code> class to Login form to fix style glitch<\\/li>\\n<\\/ul>\\n<h4>1.4.3 - 2017-05-14<\\/h4>\\n<ul>\\n<li>Tweak: Added Redirect After Login option to Login widget<\\/li>\\n<li>Tweak: Stay in the current page after logout in Login widget<\\/li>\\n<li>Tweak: Preparation for Elementor settings tabs in future version<\\/li>\\n<li>Fix: Pinterest in Share Buttons widget now sharing the URL alone<\\/li>\\n<li>Fix: Bug with <code>active<\\/code> class in portfolio filter item<\\/li>\\n<li>Fix: Higher specific list-style-type <code>none<\\/code> for filter items to override some theme style<\\/li>\\n<\\/ul>\\n<h4>1.4.2 - 2017-05-06<\\/h4>\\n<ul>\\n<li>Fix: Temporary patch for form field shortcode in some servers<\\/li>\\n<\\/ul>\\n<h4>1.4.1 - 2017-05-03<\\/h4>\\n<ul>\\n<li>Fix: Bug with custom success message in form widget<\\/li>\\n<li>Fix: Bug with meta data in email action<\\/li>\\n<\\/ul>\\n<h4>1.4.0 - 2017-05-03<\\/h4>\\n<ul>\\n<li>New: Forms: integration with MailChimp<\\/li>\\n<li>New: Forms: integration with MailPoet<\\/li>\\n<li>New: Forms: Added Email 2 action for email confirmation<\\/li>\\n<li>New: Forms: Added shortcodes for fields<\\/li>\\n<li>New: Forms: Added custom ID for fields<\\/li>\\n<li>New: Forms: Added option to edit email HTML template (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1180\\\">#1180<\\/a>)<\\/li>\\n<li>New: Added Login widget<\\/li>\\n<li>Tweak: Move <code>send_html<\\/code> control to <code>email_content_type<\\/code><\\/li>\\n<li>Fix: Email still sent even if validation failed in form widget<\\/li>\\n<\\/ul>\\n<h4>1.3.2 - 2017-05-01<\\/h4>\\n<ul>\\n<li>New: Added action <code>elementor_pro\\/init<\\/code> for better integration with Elementor Pro<\\/li>\\n<li>Fix: Posts without featured image in Posts widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1234\\\">#1234<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1382\\\">#1382<\\/a>)<\\/li>\\n<li>Fix: reCAPTCHA &amp; Honeypot fields with new method<\\/li>\\n<li>Fix: Added border width control in Share Buttons to avoid a glitch on Chrome browser<\\/li>\\n<li>Fix: Border radius glitch on hover in Share Buttons<\\/li>\\n<\\/ul>\\n<h4>1.3.1 - 2017-04-25<\\/h4>\\n<ul>\\n<li>Fix: Conflict update with revision history module<\\/li>\\n<\\/ul>\\n<h4>1.3.0 - 2017-04-25<\\/h4>\\n<ul>\\n<li>New: Added Share Buttons widget (<a href=\\\"https:\\/\\/wordpress.org\\/support\\/topic\\/social-sharing-buttons-is-it-possible\\/\\\">Topic<\\/a>)<\\/li>\\n<li>New: Added Custom CSS for Page Settings<\\/li>\\n<li>New: Added Masonry layout for Portfolio widget<\\/li>\\n<li>New: Added Cc &amp; Bcc options to email action (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1181\\\">#1181<\\/a>)<\\/li>\\n<li>New: Introduced <code>ElementorProModulesFormsClassesAction_Base<\\/code> class for better 3rd party integration for forms<\\/li>\\n<li>Tweak: Debugger module now also shows errors from Pro<\\/li>\\n<li>Tweak: Added options for Elementor Library<\\/li>\\n<li>Tweak: New base posts module for optimized performance<\\/li>\\n<li>Tweak: Adjusting Posts \\/ Portfolio to the new structure<\\/li>\\n<li>Fix: Export for posts \\/ portfolio<\\/li>\\n<li>Fix: Duplicate repeater field with switcher control (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1442\\\">#1442<\\/a>)<\\/li>\\n<li>Fix: Post per Page in the query control<\\/li>\\n<li>Fix: Metadata does not come through on form emails (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1566\\\">#1566<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>1.2.6 - 2017-04-19<\\/h4>\\n<ul>\\n<li>Fix: Added compatibility with WooCommerce 3.0 - Products &amp; Add to Cart widgets<\\/li>\\n<\\/ul>\\n<h4>1.2.5 - 2017-04-18<\\/h4>\\n<ul>\\n<li>Fix: Offset query for posts widgets (Posts, Portfolio and Products)<\\/li>\\n<\\/ul>\\n<h4>1.2.4 - 2017-03-21<\\/h4>\\n<ul>\\n<li>Tweak: Added Indian Rupee sign to Price Table widget<\\/li>\\n<li>Fix: Portfolio grid for IE11<\\/li>\\n<li>Fix: Link target blank in Price List widget<\\/li>\\n<li>Fix: Active item for filter bar in Portfolio widget<\\/li>\\n<\\/ul>\\n<h4>1.2.3 - 2017-03-06<\\/h4>\\n<ul>\\n<li>Tweak: Fully compatible with Elementor v1.3.0<\\/li>\\n<li>Tweak: Added trigger for after form submission in Forms widget<\\/li>\\n<li>Tweak: Changed handle name in reCAPTCHA field to avoid conflict with other contact forms<\\/li>\\n<li>Fix: Portfolio filter syntax in Non-Latin languages<\\/li>\\n<li>Fix: Added <code>no-repeat<\\/code> property for slide with <code>background-size:contain<\\/code><\\/li>\\n<li>Fix: Condition control &amp; Import value in Posts widgets<\\/li>\\n<li>Fix: Offset and Pagination in WordPress (<a href=\\\"https:\\/\\/codex.wordpress.org\\/Making_Custom_Queries_using_Offset_and_Pagination\\\">More Info<\\/a>)<\\/li>\\n<li>Fix: Submit handler bubbling for custom events in Forms widget<\\/li>\\n<\\/ul>\\n<h4>1.2.2 - 2017-02-23<\\/h4>\\n<ul>\\n<li>Tweak: Change name from Side A\\/B to Front and Back in Flip Box widget<\\/li>\\n<li>Fix: Error when saving third party widgets in the global widget<\\/li>\\n<li>Fix: Image position &quot;none&quot; remains visible in editor preview (Posts)<\\/li>\\n<li>Fix: Hide the pagination when there are no links<\\/li>\\n<\\/ul>\\n<h4>1.2.1 - 2017-02-21<\\/h4>\\n<ul>\\n<li>Fix: Firefox Flip Box 3D compatibility<\\/li>\\n<\\/ul>\\n<h4>1.2.0 - 2017-02-21<\\/h4>\\n<ul>\\n<li>New: Added Flip Box widget<\\/li>\\n<li>New: Added Ken Burns effect for slides<\\/li>\\n<li>New: Added Masonry layout for Posts widget<\\/li>\\n<li>New: Added Pagination option for Posts widget<\\/li>\\n<li>Tweak: Added background size contain to slides<\\/li>\\n<li>Tweak: Improve Query control by preload items<\\/li>\\n<li>Fix: Text color for Checkbox and Radio fields<\\/li>\\n<\\/ul>\\n<h4>1.1.2 - 2017-02-05<\\/h4>\\n<ul>\\n<li>Tweak: Added <code>aria-required<\\/code> for better accessibility in forms widget<\\/li>\\n<li>Fix: Conflict Call to <code>undefined<\\/code> method in Posts &amp; Portfolio widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1271\\\">#1271<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1266\\\">#1266<\\/a>)<\\/li>\\n<li>Fix: Submit button HTML after error sending<\\/li>\\n<li>Fix: Success message for <code>skip_email<\\/code> function<\\/li>\\n<li>Notice: Elementor 1.2.0 or later now required<\\/li>\\n<\\/ul>\\n<h4>1.1.1 - 2017-01-24<\\/h4>\\n<ul>\\n<li>Fix: Can\'t save global widgets when <code>WP_DEBUG<\\/code> is <code>true<\\/code><\\/li>\\n<li>Fix: Undefined variable in WC widgets<\\/li>\\n<li>Fix: Removed duplicate strings<\\/li>\\n<\\/ul>\\n<h4>1.1.0 - 2017-01-24<\\/h4>\\n<ul>\\n<li>New: Price Table widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/102\\\">#102<\\/a>)<\\/li>\\n<li>New: WooCommerce Add to Cart widget<\\/li>\\n<li>New: WooCommerce Categories widget<\\/li>\\n<li>New: WooCommerce Elements widget<\\/li>\\n<li>New: Honeypot field for Forms widgets<\\/li>\\n<li>Tweak: Added inline options for taxonomies &amp; authors if is less than 15 items<\\/li>\\n<li>Tweak: Added Required Mark for fields in Forms widget<\\/li>\\n<li>Fix: CSS selectors priority in Slides widget<\\/li>\\n<li>Fix: CSS bug in Price List widget<\\/li>\\n<li>Fix: Update all Post CSS files that includes specific Global Widget<\\/li>\\n<\\/ul>\\n<h4>1.0.9 - 2017-01-18<\\/h4>\\n<ul>\\n<li>Fix: Auto complete bug in query controls<\\/li>\\n<li>Fix: Render template with escaping slashes<\\/li>\\n<li>Fix: Reply-to field in Forms widget<\\/li>\\n<\\/ul>\\n<h4>1.0.8 - 2017-01-11<\\/h4>\\n<ul>\\n<li>Tweak: Code adjustments for Elementor API<\\/li>\\n<li>Fix: Removed go pro link from plugins page in admin<\\/li>\\n<\\/ul>\\n<h4>1.0.7 - 2017-01-05<\\/h4>\\n<ul>\\n<li>Tweak: Added filter by featured \\/ sale for WC Products widget<\\/li>\\n<li>Tweak: Added author control in Portfolio widget<\\/li>\\n<li>Tweak: Code adjustments for Elementor API<\\/li>\\n<li>Fix: Added support for empty image ratio<\\/li>\\n<li>Fix: Avoid nesting a sidebar within a template that will appear in the sidebar itself<\\/li>\\n<\\/ul>\\n<h4>1.0.6 - 2017-01-01<\\/h4>\\n<ul>\\n<li>Tweak: Added Auto-updates for local translation files<\\/li>\\n<li>Fix: Custom CSS for Global widgets<\\/li>\\n<li>Fix: Remove <code>nonce<\\/code> field (Fix some cache plugins)<\\/li>\\n<\\/ul>\\n<h4>1.0.5 - 2016-12-27<\\/h4>\\n<ul>\\n<li>Fix: Slide element bug fix - \'Link apply on\' logic<\\/li>\\n<li>Fix: Removed unique wrapper for Custom CSS in order to allow media queries (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1086\\\">#1086<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>1.0.4 - 2016-12-21<\\/h4>\\n<ul>\\n<li>Tweak: Mobile Editing for fields in the form widget<\\/li>\\n<li>Tweak: Mobile Editing for posts<\\/li>\\n<li>Tweak: Allow send form as HTML<\\/li>\\n<li>Tweak: Improved auto upgrades for Multisite installation<\\/li>\\n<li>Tweak: Improve editor rendering experience for Portfolio widget<\\/li>\\n<li>Fix: Posts widget check if image exist<\\/li>\\n<li>Fix: Changed the clone method for global widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1042\\\">#1042<\\/a>)<\\/li>\\n<li>Fix: Bug slides in RTL (removed direction control)<\\/li>\\n<li>Fix: Slides with no height jumps when changing slides<\\/li>\\n<\\/ul>\\n<h4>1.0.3 - 2016-12-13<\\/h4>\\n<ul>\\n<li>Fix: Added escape placeholder for HTML Entities in form widget<\\/li>\\n<li>Fix: Countdown widget RTL bug<\\/li>\\n<li>Fix: Remove redundant #elementor selector for control style<\\/li>\\n<li>Fix: Added prefixing with \'0\' for one digit number in Countdown widget<\\/li>\\n<\\/ul>\\n<h4>1.0.2 - 2016-12-12<\\/h4>\\n<ul>\\n<li>Fix: Page layout collapses when inserting reCAPTCHA field in Form<\\/li>\\n<\\/ul>\\n<h4>1.0.1 - 2016-12-12<\\/h4>\\n<ul>\\n<li>Fix: WordPress widgets disappear from Editor when Elementor Pro active<\\/li>\\n<\\/ul>\\n<h4>1.0.0 - 2016-12-12<\\/h4>\\n<ul>\\n<li>Initial release<\\/li>\\n<\\/ul>\\\";}\",\"new_version\":\"3.34.0\",\"name\":\"Elementor Pro\",\"slug\":\"elementor-pro\",\"url\":\"https:\\/\\/elementor.com\\/pro\\/changelog\\/\",\"homepage\":\"https:\\/\\/elementor.com\\/pro\\/\",\"requires\":\"5.0\",\"tested\":\"6.9\",\"elementor_requires\":\"3.0.1\",\"package\":\"https:\\/\\/plugin-downloads.elementor.com\\/v2\\/package_download\\/eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJsaWNlbnNlIjoiKioqKioqKioqIiwidXJsIjoiaHR0cHM6Ly9jYnByby5jb20uYXUvcHJldmlldy91cGx1c2RlbnRhbCIsImRvd25sb2FkX2JldGEiOmZhbHNlLCJmaWxlX2tleSI6IjEiLCJpYXQiOjE3NjY0MjQ0ODAsImV4cCI6MTc2NjUxMDg4MH0.Ph8a2x_D8yRZ3TaySDuSd0RbTbrReDth_zNaX7AckIQ\\/package_download\",\"download_link\":\"https:\\/\\/plugin-downloads.elementor.com\\/v2\\/package_download\\/eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJsaWNlbnNlIjoiKioqKioqKioqIiwidXJsIjoiaHR0cHM6Ly9jYnByby5jb20uYXUvcHJldmlldy91cGx1c2RlbnRhbCIsImRvd25sb2FkX2JldGEiOmZhbHNlLCJmaWxlX2tleSI6IjEiLCJpYXQiOjE3NjY0MjQ0ODAsImV4cCI6MTc2NjUxMDg4MH0.Ph8a2x_D8yRZ3TaySDuSd0RbTbrReDth_zNaX7AckIQ\\/package_download\",\"banners\":{\"2x\":\"https:\\/\\/ps.w.org\\/elementor\\/assets\\/banner-1544x500.png?rev=1475479\",\"1x\":\"https:\\/\\/ps.w.org\\/elementor\\/assets\\/banner-772x250.png?rev=1475479\"},\"icons\":{\"svg\":\"https:\\/\\/storage.googleapis.com\\/web-public-files\\/Web%20Assets\\/icons\\/icon.svg\"},\"canary_deployment\":{\"plugin_info\":{\"new_version\":\"3.7.0\",\"name\":\"Elementor Pro\",\"slug\":\"elementor-pro\",\"url\":\"https:\\/\\/elementor.com\\/pro\\/changelog\\/\",\"homepage\":\"https:\\/\\/elementor.com\\/pro\\/\",\"requires\":\"5.0\",\"tested\":\"6.9\",\"elementor_requires\":\"3.0.1\",\"package\":\"https:\\/\\/plugin-downloads.elementor.com\\/v2\\/previous_download\\/eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJsaWNlbnNlIjoiKioqKioqKioqIiwidmVyc2lvbiI6IjMuNy4wIiwidXJsIjoiaHR0cHM6Ly9jYnByby5jb20uYXUvcHJldmlldy91cGx1c2RlbnRhbCIsImlhdCI6MTc2NjQyNDQ4MCwiZXhwIjoxNzY2NTEwODgwfQ.enHsOZJ9peaNk1mv7q7B4jSX0zmsyzpHgfqu5ivVdaU\\/previous_download\",\"download_link\":\"https:\\/\\/plugin-downloads.elementor.com\\/v2\\/previous_download\\/eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJsaWNlbnNlIjoiKioqKioqKioqIiwidmVyc2lvbiI6IjMuNy4wIiwidXJsIjoiaHR0cHM6Ly9jYnByby5jb20uYXUvcHJldmlldy91cGx1c2RlbnRhbCIsImlhdCI6MTc2NjQyNDQ4MCwiZXhwIjoxNzY2NTEwODgwfQ.enHsOZJ9peaNk1mv7q7B4jSX0zmsyzpHgfqu5ivVdaU\\/previous_download\",\"banners\":{\"2x\":\"https:\\/\\/ps.w.org\\/elementor\\/assets\\/banner-1544x500.png?rev=1475479\",\"1x\":\"https:\\/\\/ps.w.org\\/elementor\\/assets\\/banner-772x250.png?rev=1475479\"},\"icons\":{\"svg\":\"https:\\/\\/storage.googleapis.com\\/web-public-files\\/Web%20Assets\\/icons\\/icon.svg\"}},\"conditions\":[[{\"type\":\"language\",\"languages\":[\"he_IL\",\"nl_NL\",\"en_GB\",\"en_NZ\",\"en_ZA\",\"en_AU\",\"en_CA\",\"sv_SE\",\"da_DK\",\"fr_FR\",\"nl_NL\",\"nb_NO\",\"de_AT\",\"fi\",\"it_IT\",\"nn_NO\",\"de_CH\",\"en_GB\",\"is_IS\",\"ga\",\"fr_BE\",\"nl_BE\",\"ast\",\"lb_LU\",\"es_ES\",\"pt_PT\",\"mlt\"],\"operator\":\"in\"}]]},\"cloud\":false}\";}","off");

INSERT IGNORE INTO `wp_options` VALUES 
("2796","_site_transient_timeout_wp_theme_files_patterns-b11842997f074ebb3c73776b08baef64","1768450109","off"),
("2797","_site_transient_wp_theme_files_patterns-b11842997f074ebb3c73776b08baef64","a:2:{s:7:\"version\";s:5:\"3.4.5\";s:8:\"patterns\";a:0:{}}","off"),
("2800","_site_transient_timeout_theme_roots","1768450111","off"),
("2801","_site_transient_theme_roots","a:2:{s:15:\"hello-elementor\";s:7:\"/themes\";s:16:\"twentytwentyfive\";s:7:\"/themes\";}","off"),
("2802","_site_transient_update_plugins","O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1768448314;s:8:\"response\";a:2:{s:23:\"elementor/elementor.php\";O:8:\"stdClass\":13:{s:2:\"id\";s:23:\"w.org/plugins/elementor\";s:4:\"slug\";s:9:\"elementor\";s:6:\"plugin\";s:23:\"elementor/elementor.php\";s:11:\"new_version\";s:6:\"3.34.1\";s:3:\"url\";s:40:\"https://wordpress.org/plugins/elementor/\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.34.1.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:62:\"https://ps.w.org/elementor/assets/icon-256x256.gif?rev=3111597\";s:2:\"1x\";s:62:\"https://ps.w.org/elementor/assets/icon-128x128.gif?rev=3111597\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:65:\"https://ps.w.org/elementor/assets/banner-1544x500.png?rev=3164133\";s:2:\"1x\";s:64:\"https://ps.w.org/elementor/assets/banner-772x250.png?rev=3164133\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"6.6\";s:6:\"tested\";s:3:\"6.9\";s:12:\"requires_php\";s:3:\"7.4\";s:16:\"requires_plugins\";a:0:{}}s:31:\"elementor-pro/elementor-pro.php\";O:8:\"stdClass\":17:{s:14:\"stable_version\";s:6:\"3.34.0\";s:12:\"last_updated\";s:19:\"2025-12-22 12:50:17\";s:11:\"new_version\";s:6:\"3.34.0\";s:4:\"name\";s:13:\"Elementor Pro\";s:4:\"slug\";s:13:\"elementor-pro\";s:3:\"url\";s:36:\"https://elementor.com/pro/changelog/\";s:8:\"homepage\";s:26:\"https://elementor.com/pro/\";s:8:\"requires\";s:3:\"5.0\";s:6:\"tested\";s:3:\"6.9\";s:18:\"elementor_requires\";s:5:\"3.0.1\";s:7:\"package\";s:348:\"https://plugin-downloads.elementor.com/v2/package_download/eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJsaWNlbnNlIjoiKioqKioqKioqIiwidXJsIjoiaHR0cHM6Ly9jYnByby5jb20uYXUvcHJldmlldy91cGx1c2RlbnRhbCIsImRvd25sb2FkX2JldGEiOmZhbHNlLCJmaWxlX2tleSI6IjEiLCJpYXQiOjE3NjY0MjQ0ODAsImV4cCI6MTc2NjUxMDg4MH0.Ph8a2x_D8yRZ3TaySDuSd0RbTbrReDth_zNaX7AckIQ/package_download\";s:13:\"download_link\";s:348:\"https://plugin-downloads.elementor.com/v2/package_download/eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJsaWNlbnNlIjoiKioqKioqKioqIiwidXJsIjoiaHR0cHM6Ly9jYnByby5jb20uYXUvcHJldmlldy91cGx1c2RlbnRhbCIsImRvd25sb2FkX2JldGEiOmZhbHNlLCJmaWxlX2tleSI6IjEiLCJpYXQiOjE3NjY0MjQ0ODAsImV4cCI6MTc2NjUxMDg4MH0.Ph8a2x_D8yRZ3TaySDuSd0RbTbrReDth_zNaX7AckIQ/package_download\";s:7:\"banners\";a:2:{s:2:\"2x\";s:65:\"https://ps.w.org/elementor/assets/banner-1544x500.png?rev=1475479\";s:2:\"1x\";s:64:\"https://ps.w.org/elementor/assets/banner-772x250.png?rev=1475479\";}s:5:\"icons\";a:1:{s:3:\"svg\";s:75:\"https://storage.googleapis.com/web-public-files/Web%20Assets/icons/icon.svg\";}s:17:\"canary_deployment\";a:2:{s:11:\"plugin_info\";a:12:{s:11:\"new_version\";s:5:\"3.7.0\";s:4:\"name\";s:13:\"Elementor Pro\";s:4:\"slug\";s:13:\"elementor-pro\";s:3:\"url\";s:36:\"https://elementor.com/pro/changelog/\";s:8:\"homepage\";s:26:\"https://elementor.com/pro/\";s:8:\"requires\";s:3:\"5.0\";s:6:\"tested\";s:3:\"6.9\";s:18:\"elementor_requires\";s:5:\"3.0.1\";s:7:\"package\";s:325:\"https://plugin-downloads.elementor.com/v2/previous_download/eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJsaWNlbnNlIjoiKioqKioqKioqIiwidmVyc2lvbiI6IjMuNy4wIiwidXJsIjoiaHR0cHM6Ly9jYnByby5jb20uYXUvcHJldmlldy91cGx1c2RlbnRhbCIsImlhdCI6MTc2NjQyNDQ4MCwiZXhwIjoxNzY2NTEwODgwfQ.enHsOZJ9peaNk1mv7q7B4jSX0zmsyzpHgfqu5ivVdaU/previous_download\";s:13:\"download_link\";s:325:\"https://plugin-downloads.elementor.com/v2/previous_download/eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJsaWNlbnNlIjoiKioqKioqKioqIiwidmVyc2lvbiI6IjMuNy4wIiwidXJsIjoiaHR0cHM6Ly9jYnByby5jb20uYXUvcHJldmlldy91cGx1c2RlbnRhbCIsImlhdCI6MTc2NjQyNDQ4MCwiZXhwIjoxNzY2NTEwODgwfQ.enHsOZJ9peaNk1mv7q7B4jSX0zmsyzpHgfqu5ivVdaU/previous_download\";s:7:\"banners\";a:2:{s:2:\"2x\";s:65:\"https://ps.w.org/elementor/assets/banner-1544x500.png?rev=1475479\";s:2:\"1x\";s:64:\"https://ps.w.org/elementor/assets/banner-772x250.png?rev=1475479\";}s:5:\"icons\";a:1:{s:3:\"svg\";s:75:\"https://storage.googleapis.com/web-public-files/Web%20Assets/icons/icon.svg\";}}s:10:\"conditions\";a:1:{i:0;a:1:{i:0;a:3:{s:4:\"type\";s:8:\"language\";s:9:\"languages\";a:27:{i:0;s:5:\"he_IL\";i:1;s:5:\"nl_NL\";i:2;s:5:\"en_GB\";i:3;s:5:\"en_NZ\";i:4;s:5:\"en_ZA\";i:5;s:5:\"en_AU\";i:6;s:5:\"en_CA\";i:7;s:5:\"sv_SE\";i:8;s:5:\"da_DK\";i:9;s:5:\"fr_FR\";i:10;s:5:\"nl_NL\";i:11;s:5:\"nb_NO\";i:12;s:5:\"de_AT\";i:13;s:2:\"fi\";i:14;s:5:\"it_IT\";i:15;s:5:\"nn_NO\";i:16;s:5:\"de_CH\";i:17;s:5:\"en_GB\";i:18;s:5:\"is_IS\";i:19;s:2:\"ga\";i:20;s:5:\"fr_BE\";i:21;s:5:\"nl_BE\";i:22;s:3:\"ast\";i:23;s:5:\"lb_LU\";i:24;s:5:\"es_ES\";i:25;s:5:\"pt_PT\";i:26;s:3:\"mlt\";}s:8:\"operator\";s:2:\"in\";}}}}s:5:\"cloud\";b:0;s:6:\"plugin\";s:31:\"elementor-pro/elementor-pro.php\";}}s:12:\"translations\";a:0:{}s:9:\"no_update\";a:3:{s:37:\"elementskit-lite/elementskit-lite.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:30:\"w.org/plugins/elementskit-lite\";s:4:\"slug\";s:16:\"elementskit-lite\";s:6:\"plugin\";s:37:\"elementskit-lite/elementskit-lite.php\";s:11:\"new_version\";s:5:\"3.7.8\";s:3:\"url\";s:47:\"https://wordpress.org/plugins/elementskit-lite/\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/plugin/elementskit-lite.3.7.8.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:69:\"https://ps.w.org/elementskit-lite/assets/icon-256x256.gif?rev=2518175\";s:2:\"1x\";s:69:\"https://ps.w.org/elementskit-lite/assets/icon-128x128.gif?rev=2518175\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:72:\"https://ps.w.org/elementskit-lite/assets/banner-1544x500.jpg?rev=3250020\";s:2:\"1x\";s:71:\"https://ps.w.org/elementskit-lite/assets/banner-772x250.jpg?rev=3250020\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"6.0\";}s:75:\"material-design-icons-for-elementor/material-design-icons-for-elementor.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:49:\"w.org/plugins/material-design-icons-for-elementor\";s:4:\"slug\";s:35:\"material-design-icons-for-elementor\";s:6:\"plugin\";s:75:\"material-design-icons-for-elementor/material-design-icons-for-elementor.php\";s:11:\"new_version\";s:5:\"1.5.1\";s:3:\"url\";s:66:\"https://wordpress.org/plugins/material-design-icons-for-elementor/\";s:7:\"package\";s:84:\"https://downloads.wordpress.org/plugin/material-design-icons-for-elementor.1.5.1.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:88:\"https://ps.w.org/material-design-icons-for-elementor/assets/icon-256x256.png?rev=2415624\";s:2:\"1x\";s:88:\"https://ps.w.org/material-design-icons-for-elementor/assets/icon-128x128.png?rev=2415624\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:90:\"https://ps.w.org/material-design-icons-for-elementor/assets/banner-772x250.png?rev=2415624\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.7\";}s:73:\"skyboot-custom-icons-for-elementor/skyboot-custom-icons-for-elementor.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:48:\"w.org/plugins/skyboot-custom-icons-for-elementor\";s:4:\"slug\";s:34:\"skyboot-custom-icons-for-elementor\";s:6:\"plugin\";s:73:\"skyboot-custom-icons-for-elementor/skyboot-custom-icons-for-elementor.php\";s:11:\"new_version\";s:5:\"1.1.0\";s:3:\"url\";s:65:\"https://wordpress.org/plugins/skyboot-custom-icons-for-elementor/\";s:7:\"package\";s:83:\"https://downloads.wordpress.org/plugin/skyboot-custom-icons-for-elementor.1.1.0.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:87:\"https://ps.w.org/skyboot-custom-icons-for-elementor/assets/icon-256x256.png?rev=3317342\";s:2:\"1x\";s:87:\"https://ps.w.org/skyboot-custom-icons-for-elementor/assets/icon-128x128.png?rev=3317342\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:90:\"https://ps.w.org/skyboot-custom-icons-for-elementor/assets/banner-1544x500.png?rev=3371956\";s:2:\"1x\";s:89:\"https://ps.w.org/skyboot-custom-icons-for-elementor/assets/banner-772x250.png?rev=3371956\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.9\";}}s:7:\"checked\";a:7:{s:33:\"duplicator-pro/duplicator-pro.php\";s:6:\"4.5.24\";s:23:\"elementor/elementor.php\";s:6:\"3.33.6\";s:31:\"elementor-pro/elementor-pro.php\";s:6:\"3.34.0\";s:37:\"elementskit-lite/elementskit-lite.php\";s:5:\"3.7.8\";s:35:\"envato-elements/envato-elements.php\";s:6:\"2.0.16\";s:75:\"material-design-icons-for-elementor/material-design-icons-for-elementor.php\";s:5:\"1.5.1\";s:73:\"skyboot-custom-icons-for-elementor/skyboot-custom-icons-for-elementor.php\";s:5:\"1.1.0\";}}","off"),
("2803","_site_transient_timeout_browser_684fac3d8e595845640e507a9122bd55","1769053146","off"),
("2804","_site_transient_browser_684fac3d8e595845640e507a9122bd55","a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:9:\"143.0.0.0\";s:8:\"platform\";s:9:\"Macintosh\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}","off"),
("2805","_site_transient_timeout_php_check_e1575808cef126e0bfb4325cceefee7d","1769053147","off"),
("2806","_site_transient_php_check_e1575808cef126e0bfb4325cceefee7d","a:5:{s:19:\"recommended_version\";s:3:\"8.3\";s:15:\"minimum_version\";s:6:\"7.2.24\";s:12:\"is_supported\";b:0;s:9:\"is_secure\";b:1;s:13:\"is_acceptable\";b:1;}","off"),
("2807","_transient_timeout_elementor_remote_info_api_data_3.33.6","1768491549","off"),
("2808","_transient_elementor_remote_info_api_data_3.33.6","a:4:{s:9:\"timestamp\";s:10:\"1768446381\";s:14:\"upgrade_notice\";a:3:{s:7:\"version\";s:5:\"2.0.0\";s:7:\"message\";s:0:\"\";s:11:\"update_link\";s:0:\"\";}s:11:\"pro_widgets\";a:82:{i:0;a:4:{s:4:\"name\";s:6:\"search\";s:5:\"title\";s:6:\"Search\";s:4:\"icon\";s:17:\"eicon-site-search\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:1;a:4:{s:4:\"name\";s:5:\"posts\";s:5:\"title\";s:5:\"Posts\";s:4:\"icon\";s:15:\"eicon-post-list\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:2;a:4:{s:4:\"name\";s:9:\"portfolio\";s:5:\"title\";s:9:\"Portfolio\";s:4:\"icon\";s:18:\"eicon-gallery-grid\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:3;a:4:{s:4:\"name\";s:17:\"link-in-bio-var-2\";s:5:\"title\";s:7:\"Classic\";s:4:\"icon\";s:19:\"eicon-site-identity\";s:10:\"categories\";s:15:\"[\"link-in-bio\"]\";}i:4;a:4:{s:4:\"name\";s:9:\"mega-menu\";s:5:\"title\";s:4:\"Menu\";s:4:\"icon\";s:15:\"eicon-mega-menu\";s:10:\"categories\";s:33:\"[\"pro-elements\",\"theme-elements\"]\";}i:5;a:4:{s:4:\"name\";s:17:\"link-in-bio-var-3\";s:5:\"title\";s:8:\"Showcase\";s:4:\"icon\";s:19:\"eicon-site-identity\";s:10:\"categories\";s:15:\"[\"link-in-bio\"]\";}i:6;a:4:{s:4:\"name\";s:4:\"form\";s:5:\"title\";s:4:\"Form\";s:4:\"icon\";s:21:\"eicon-form-horizontal\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:7;a:4:{s:4:\"name\";s:17:\"link-in-bio-var-4\";s:5:\"title\";s:5:\"Links\";s:4:\"icon\";s:19:\"eicon-site-identity\";s:10:\"categories\";s:15:\"[\"link-in-bio\"]\";}i:8;a:4:{s:4:\"name\";s:9:\"loop-grid\";s:5:\"title\";s:9:\"Loop Grid\";s:4:\"icon\";s:18:\"eicon-loop-builder\";s:10:\"categories\";s:33:\"[\"pro-elements\",\"theme-elements\"]\";}i:9;a:4:{s:4:\"name\";s:17:\"link-in-bio-var-5\";s:5:\"title\";s:8:\"Services\";s:4:\"icon\";s:19:\"eicon-site-identity\";s:10:\"categories\";s:15:\"[\"link-in-bio\"]\";}i:10;a:4:{s:4:\"name\";s:13:\"loop-carousel\";s:5:\"title\";s:13:\"Loop Carousel\";s:4:\"icon\";s:19:\"eicon-carousel-loop\";s:10:\"categories\";s:33:\"[\"pro-elements\",\"theme-elements\"]\";}i:11;a:4:{s:4:\"name\";s:17:\"link-in-bio-var-6\";s:5:\"title\";s:9:\"Portfolio\";s:4:\"icon\";s:19:\"eicon-site-identity\";s:10:\"categories\";s:15:\"[\"link-in-bio\"]\";}i:12;a:4:{s:4:\"name\";s:7:\"gallery\";s:5:\"title\";s:7:\"Gallery\";s:4:\"icon\";s:23:\"eicon-gallery-justified\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:13;a:4:{s:4:\"name\";s:17:\"link-in-bio-var-7\";s:5:\"title\";s:13:\"Business Card\";s:4:\"icon\";s:19:\"eicon-site-identity\";s:10:\"categories\";s:15:\"[\"link-in-bio\"]\";}i:14;a:4:{s:4:\"name\";s:17:\"animated-headline\";s:5:\"title\";s:17:\"Animated Headline\";s:4:\"icon\";s:23:\"eicon-animated-headline\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:15;a:4:{s:4:\"name\";s:10:\"price-list\";s:5:\"title\";s:10:\"Price List\";s:4:\"icon\";s:16:\"eicon-price-list\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:16;a:4:{s:4:\"name\";s:11:\"price-table\";s:5:\"title\";s:11:\"Price Table\";s:4:\"icon\";s:17:\"eicon-price-table\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:17;a:4:{s:4:\"name\";s:8:\"flip-box\";s:5:\"title\";s:8:\"Flip Box\";s:4:\"icon\";s:14:\"eicon-flip-box\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:18;a:4:{s:4:\"name\";s:14:\"call-to-action\";s:5:\"title\";s:14:\"Call to Action\";s:4:\"icon\";s:20:\"eicon-image-rollover\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:19;a:4:{s:4:\"name\";s:14:\"media-carousel\";s:5:\"title\";s:14:\"Media Carousel\";s:4:\"icon\";s:20:\"eicon-media-carousel\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:20;a:4:{s:4:\"name\";s:15:\"nested-carousel\";s:5:\"title\";s:8:\"Carousel\";s:4:\"icon\";s:21:\"eicon-nested-carousel\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:21;a:4:{s:4:\"name\";s:10:\"off-canvas\";s:5:\"title\";s:10:\"Off-Canvas\";s:4:\"icon\";s:16:\"eicon-off-canvas\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:22;a:4:{s:4:\"name\";s:9:\"countdown\";s:5:\"title\";s:9:\"Countdown\";s:4:\"icon\";s:15:\"eicon-countdown\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:23;a:4:{s:4:\"name\";s:13:\"share-buttons\";s:5:\"title\";s:13:\"Share Buttons\";s:4:\"icon\";s:11:\"eicon-share\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:24;a:4:{s:4:\"name\";s:10:\"blockquote\";s:5:\"title\";s:10:\"Blockquote\";s:4:\"icon\";s:16:\"eicon-blockquote\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:25;a:4:{s:4:\"name\";s:6:\"lottie\";s:5:\"title\";s:6:\"Lottie\";s:4:\"icon\";s:12:\"eicon-lottie\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:26;a:4:{s:4:\"name\";s:7:\"hotspot\";s:5:\"title\";s:7:\"Hotspot\";s:4:\"icon\";s:19:\"eicon-image-hotspot\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:27;a:4:{s:4:\"name\";s:13:\"paypal-button\";s:5:\"title\";s:13:\"PayPal Button\";s:4:\"icon\";s:19:\"eicon-paypal-button\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:28;a:4:{s:4:\"name\";s:14:\"code-highlight\";s:5:\"title\";s:14:\"Code Highlight\";s:4:\"icon\";s:20:\"eicon-code-highlight\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:29;a:4:{s:4:\"name\";s:14:\"video-playlist\";s:5:\"title\";s:14:\"Video Playlist\";s:4:\"icon\";s:20:\"eicon-video-playlist\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:30;a:4:{s:4:\"name\";s:8:\"template\";s:5:\"title\";s:8:\"Template\";s:4:\"icon\";s:19:\"eicon-document-file\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:31;a:4:{s:4:\"name\";s:13:\"stripe-button\";s:5:\"title\";s:13:\"Stripe Button\";s:4:\"icon\";s:19:\"eicon-stripe-button\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:32;a:4:{s:4:\"name\";s:16:\"progress-tracker\";s:5:\"title\";s:16:\"Progress Tracker\";s:4:\"icon\";s:22:\"eicon-progress-tracker\";s:10:\"categories\";s:40:\"[\"pro-elements\",\"theme-elements-single\"]\";}i:33;a:4:{s:4:\"name\";s:8:\"nav-menu\";s:5:\"title\";s:8:\"Nav Menu\";s:4:\"icon\";s:14:\"eicon-nav-menu\";s:10:\"categories\";s:33:\"[\"pro-elements\",\"theme-elements\"]\";}i:34;a:4:{s:4:\"name\";s:17:\"table-of-contents\";s:5:\"title\";s:17:\"Table of Contents\";s:4:\"icon\";s:23:\"eicon-table-of-contents\";s:10:\"categories\";s:33:\"[\"pro-elements\",\"theme-elements\"]\";}i:35;a:4:{s:4:\"name\";s:5:\"login\";s:5:\"title\";s:5:\"Login\";s:4:\"icon\";s:15:\"eicon-lock-user\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:36;a:4:{s:4:\"name\";s:6:\"slides\";s:5:\"title\";s:6:\"Slides\";s:4:\"icon\";s:12:\"eicon-slides\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:37;a:4:{s:4:\"name\";s:20:\"testimonial-carousel\";s:5:\"title\";s:20:\"Testimonial Carousel\";s:4:\"icon\";s:26:\"eicon-testimonial-carousel\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:38;a:4:{s:4:\"name\";s:7:\"reviews\";s:5:\"title\";s:7:\"Reviews\";s:4:\"icon\";s:12:\"eicon-review\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:39;a:4:{s:4:\"name\";s:15:\"facebook-button\";s:5:\"title\";s:15:\"Facebook Button\";s:4:\"icon\";s:23:\"eicon-facebook-like-box\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:40;a:4:{s:4:\"name\";s:17:\"facebook-comments\";s:5:\"title\";s:17:\"Facebook Comments\";s:4:\"icon\";s:23:\"eicon-facebook-comments\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:41;a:4:{s:4:\"name\";s:14:\"facebook-embed\";s:5:\"title\";s:14:\"Facebook Embed\";s:4:\"icon\";s:14:\"eicon-fb-embed\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:42;a:4:{s:4:\"name\";s:13:\"facebook-page\";s:5:\"title\";s:13:\"Facebook Page\";s:4:\"icon\";s:13:\"eicon-fb-feed\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:43;a:4:{s:4:\"name\";s:15:\"theme-site-logo\";s:5:\"title\";s:9:\"Site Logo\";s:4:\"icon\";s:15:\"eicon-site-logo\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:44;a:4:{s:4:\"name\";s:16:\"theme-site-title\";s:5:\"title\";s:10:\"Site Title\";s:4:\"icon\";s:16:\"eicon-site-title\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:45;a:4:{s:4:\"name\";s:16:\"theme-page-title\";s:5:\"title\";s:10:\"Page Title\";s:4:\"icon\";s:19:\"eicon-archive-title\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:46;a:4:{s:4:\"name\";s:16:\"theme-post-title\";s:5:\"title\";s:10:\"Post Title\";s:4:\"icon\";s:16:\"eicon-post-title\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:47;a:4:{s:4:\"name\";s:18:\"theme-post-excerpt\";s:5:\"title\";s:12:\"Post Excerpt\";s:4:\"icon\";s:18:\"eicon-post-excerpt\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:48;a:4:{s:4:\"name\";s:25:\"theme-post-featured-image\";s:5:\"title\";s:14:\"Featured Image\";s:4:\"icon\";s:20:\"eicon-featured-image\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:49;a:4:{s:4:\"name\";s:19:\"theme-archive-title\";s:5:\"title\";s:13:\"Archive Title\";s:4:\"icon\";s:19:\"eicon-archive-title\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:50;a:4:{s:4:\"name\";s:13:\"archive-posts\";s:5:\"title\";s:13:\"Archive Posts\";s:4:\"icon\";s:19:\"eicon-archive-posts\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:51;a:4:{s:4:\"name\";s:10:\"author-box\";s:5:\"title\";s:10:\"Author Box\";s:4:\"icon\";s:12:\"eicon-person\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:52;a:4:{s:4:\"name\";s:13:\"post-comments\";s:5:\"title\";s:13:\"Post Comments\";s:4:\"icon\";s:14:\"eicon-comments\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:53;a:4:{s:4:\"name\";s:15:\"post-navigation\";s:5:\"title\";s:15:\"Post Navigation\";s:4:\"icon\";s:21:\"eicon-post-navigation\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:54;a:4:{s:4:\"name\";s:9:\"post-info\";s:5:\"title\";s:9:\"Post Info\";s:4:\"icon\";s:15:\"eicon-post-info\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:55;a:4:{s:4:\"name\";s:7:\"sitemap\";s:5:\"title\";s:7:\"Sitemap\";s:4:\"icon\";s:13:\"eicon-sitemap\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:56;a:4:{s:4:\"name\";s:11:\"breadcrumbs\";s:5:\"title\";s:11:\"Breadcrumbs\";s:4:\"icon\";s:11:\"eicon-yoast\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:57;a:4:{s:4:\"name\";s:21:\"woocommerce-menu-cart\";s:5:\"title\";s:9:\"Menu Cart\";s:4:\"icon\";s:10:\"eicon-cart\";s:10:\"categories\";s:41:\"[\"theme-elements\",\"woocommerce-elements\"]\";}i:58;a:4:{s:4:\"name\";s:19:\"wc-archive-products\";s:5:\"title\";s:16:\"Archive Products\";s:4:\"icon\";s:14:\"eicon-products\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:59;a:4:{s:4:\"name\";s:31:\"woocommerce-archive-description\";s:5:\"title\";s:19:\"Archive Description\";s:4:\"icon\";s:25:\"eicon-product-description\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:60;a:4:{s:4:\"name\";s:20:\"woocommerce-products\";s:5:\"title\";s:8:\"Products\";s:4:\"icon\";s:14:\"eicon-products\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:61;a:4:{s:4:\"name\";s:22:\"woocommerce-breadcrumb\";s:5:\"title\";s:23:\"WooCommerce Breadcrumbs\";s:4:\"icon\";s:25:\"eicon-product-breadcrumbs\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:62;a:4:{s:4:\"name\";s:14:\"wc-add-to-cart\";s:5:\"title\";s:18:\"Custom Add To Cart\";s:4:\"icon\";s:17:\"eicon-woocommerce\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:63;a:4:{s:4:\"name\";s:11:\"wc-elements\";s:5:\"title\";s:17:\"WooCommerce Pages\";s:4:\"icon\";s:19:\"eicon-product-pages\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:64;a:4:{s:4:\"name\";s:13:\"wc-categories\";s:5:\"title\";s:18:\"Product Categories\";s:4:\"icon\";s:24:\"eicon-product-categories\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:65;a:4:{s:4:\"name\";s:25:\"woocommerce-product-title\";s:5:\"title\";s:13:\"Product Title\";s:4:\"icon\";s:19:\"eicon-product-title\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:66;a:4:{s:4:\"name\";s:26:\"woocommerce-product-images\";s:5:\"title\";s:14:\"Product Images\";s:4:\"icon\";s:20:\"eicon-product-images\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:67;a:4:{s:4:\"name\";s:25:\"woocommerce-product-price\";s:5:\"title\";s:13:\"Product Price\";s:4:\"icon\";s:19:\"eicon-product-price\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:68;a:4:{s:4:\"name\";s:31:\"woocommerce-product-add-to-cart\";s:5:\"title\";s:11:\"Add To Cart\";s:4:\"icon\";s:25:\"eicon-product-add-to-cart\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:69;a:4:{s:4:\"name\";s:26:\"woocommerce-product-rating\";s:5:\"title\";s:14:\"Product Rating\";s:4:\"icon\";s:20:\"eicon-product-rating\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:70;a:4:{s:4:\"name\";s:25:\"woocommerce-product-stock\";s:5:\"title\";s:13:\"Product Stock\";s:4:\"icon\";s:19:\"eicon-product-stock\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:71;a:4:{s:4:\"name\";s:24:\"woocommerce-product-meta\";s:5:\"title\";s:12:\"Product Meta\";s:4:\"icon\";s:18:\"eicon-product-meta\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:72;a:4:{s:4:\"name\";s:37:\"woocommerce-product-short-description\";s:5:\"title\";s:17:\"Short Description\";s:4:\"icon\";s:25:\"eicon-product-description\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:73;a:4:{s:4:\"name\";s:29:\"woocommerce-product-data-tabs\";s:5:\"title\";s:17:\"Product Data Tabs\";s:4:\"icon\";s:18:\"eicon-product-tabs\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:74;a:4:{s:4:\"name\";s:42:\"woocommerce-product-additional-information\";s:5:\"title\";s:22:\"Additional Information\";s:4:\"icon\";s:19:\" eicon-product-info\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:75;a:4:{s:4:\"name\";s:27:\"woocommerce-product-related\";s:5:\"title\";s:15:\"Product Related\";s:4:\"icon\";s:21:\"eicon-product-related\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:76;a:4:{s:4:\"name\";s:26:\"woocommerce-product-upsell\";s:5:\"title\";s:7:\"Upsells\";s:4:\"icon\";s:20:\"eicon-product-upsell\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:77;a:4:{s:4:\"name\";s:25:\"woocommerce-checkout-page\";s:5:\"title\";s:8:\"Checkout\";s:4:\"icon\";s:14:\"eicon-checkout\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:78;a:4:{s:4:\"name\";s:16:\"woocommerce-cart\";s:5:\"title\";s:4:\"Cart\";s:4:\"icon\";s:14:\"eicon-woo-cart\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:79;a:4:{s:4:\"name\";s:22:\"woocommerce-my-account\";s:5:\"title\";s:10:\"My Account\";s:4:\"icon\";s:16:\"eicon-my-account\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:80;a:4:{s:4:\"name\";s:28:\"woocommerce-purchase-summary\";s:5:\"title\";s:16:\"Purchase Summary\";s:4:\"icon\";s:22:\"eicon-purchase-summary\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:81;a:4:{s:4:\"name\";s:19:\"woocommerce-notices\";s:5:\"title\";s:19:\"WooCommerce Notices\";s:4:\"icon\";s:25:\"eicon-woocommerce-notices\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}}s:17:\"canary_deployment\";a:2:{s:11:\"plugin_info\";a:11:{s:2:\"id\";s:23:\"w.org/plugins/elementor\";s:4:\"slug\";s:9:\"elementor\";s:6:\"plugin\";s:23:\"elementor/elementor.php\";s:11:\"new_version\";s:5:\"3.6.0\";s:7:\"package\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.6.0.zip\";s:3:\"url\";s:40:\"https://wordpress.org/plugins/elementor/\";s:5:\"icons\";a:3:{s:2:\"2x\";s:62:\"https://ps.w.org/elementor/assets/icon-256x256.png?rev=1427768\";s:2:\"1x\";s:54:\"https://ps.w.org/elementor/assets/icon.svg?rev=1426809\";s:3:\"svg\";s:54:\"https://ps.w.org/elementor/assets/icon.svg?rev=1426809\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:65:\"https://ps.w.org/elementor/assets/banner-1544x500.png?rev=1475479\";s:2:\"1x\";s:64:\"https://ps.w.org/elementor/assets/banner-772x250.png?rev=1475479\";}s:11:\"banners_rtl\";a:0:{}s:6:\"tested\";s:3:\"6.9\";s:12:\"requires_php\";s:3:\"5.6\";}s:10:\"conditions\";a:0:{}}}","off"),
("2809","_site_transient_timeout_community-events-65cf72e377257fdfcbe7aaf5da88ba70","1768491573","off"),
("2810","_site_transient_community-events-65cf72e377257fdfcbe7aaf5da88ba70","a:4:{s:9:\"sandboxed\";b:0;s:5:\"error\";N;s:8:\"location\";a:1:{s:2:\"ip\";s:12:\"37.120.234.0\";}s:6:\"events\";a:1:{i:0;a:10:{s:4:\"type\";s:6:\"meetup\";s:5:\"title\";s:63:\"WordPress in 2026. What’s Actually Changed. And What Hasn’t\";s:3:\"url\";s:57:\"https://www.meetup.com/wordpress-sydney/events/312484963/\";s:6:\"meetup\";s:16:\"WordPress Sydney\";s:10:\"meetup_url\";s:40:\"https://www.meetup.com/WordPress-Sydney/\";s:4:\"date\";s:19:\"2026-02-11 18:30:00\";s:8:\"end_date\";s:19:\"2026-02-11 19:30:00\";s:20:\"start_unix_timestamp\";i:1770795000;s:18:\"end_unix_timestamp\";i:1770798600;s:8:\"location\";a:4:{s:8:\"location\";s:6:\"Online\";s:7:\"country\";s:2:\"AU\";s:8:\"latitude\";d:-33.86999999999999744204615126363933086395263671875;s:9:\"longitude\";d:151.210000000000007958078640513122081756591796875;}}}}","off"),
("2811","_site_transient_timeout_feed_9bbd59226dc36b9b26cd43f15694c5c3","1768491574","off"),
("2812","_site_transient_feed_9bbd59226dc36b9b26cd43f15694c5c3","a:6:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:52:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\n \n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:8:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"https://wordpress.org/news\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"The latest news about WordPress and the WordPress community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 10 Dec 2025 17:16:49 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://wordpress.org/?v=7.0-alpha-61484\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"image\";a:1:{i:0;a:6:{s:4:\"data\";s:11:\"\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:3:\"url\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://s.w.org/favicon.ico?2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"https://wordpress.org/news\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"width\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"height\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"2026 Global Partner Program Announcement\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"https://wordpress.org/news/2025/12/2026-global-partner-program/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 10 Dec 2025 17:16:48 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:9:\"Community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:6:\"Events\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=19534\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:412:\"Become a driving force behind WordPress innovation by joining the Global Community Sponsorship Program: a comprehensive initiative that supports the events and people powering our open source mission. As a Global Sponsor, your organization gains meaningful visibility across the international WordPress ecosystem while helping to fund events that foster growth, collaboration, and community. Why Choose [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Harmony Romo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:11388:\"\n<p>Become a driving force behind WordPress innovation by joining the Global Community Sponsorship Program: a comprehensive initiative that supports the events and people powering our open source mission. As a Global Sponsor, your organization gains meaningful visibility across the international WordPress ecosystem while helping to fund events that foster growth, collaboration, and community.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img data-recalc-dims=\"1\" fetchpriority=\"high\" decoding=\"async\" width=\"1024\" height=\"576\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/12/WordPress-Global-Partners-Program-2026-.jpg?resize=1024%2C576&#038;ssl=1\" alt=\"\" class=\"wp-image-19617\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/12/WordPress-Global-Partners-Program-2026-.jpg?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/12/WordPress-Global-Partners-Program-2026-.jpg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/12/WordPress-Global-Partners-Program-2026-.jpg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/12/WordPress-Global-Partners-Program-2026-.jpg?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/12/WordPress-Global-Partners-Program-2026-.jpg?w=1600&amp;ssl=1 1600w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" /></figure>\n\n\n\n<h2 class=\"wp-block-heading\">Why Choose Global Sponsorship?</h2>\n\n\n\n<p>Instead of managing multiple individual sponsorships, this streamlined program consolidates your efforts into one efficient and impactful partnership.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Efficiency and Simplified Administration</h3>\n\n\n\n<p>Skip the complexity of coordinating invoice payments with numerous volunteer teams. Our centralized approach saves time and resources. In 2026, sponsors will benefit from:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>A dedicated Slack channel for direct communication with the WordPress Community Support team and Community Program Managers</li>\n\n\n\n<li>Monthly updates listing upcoming WordPress events, their current planning stages, and scheduled dates</li>\n</ul>\n\n\n\n<h3 class=\"wp-block-heading\">Expanded Reach and Impact</h3>\n\n\n\n<p>Your sponsorship amplifies your presence worldwide, ensuring consistent visibility across global WordPress community events.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Stability and Reliability</h3>\n\n\n\n<p>Your commitment strengthens locally organized events by providing predictable funding that supports venues, logistics, and growth.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Flexible Branding Options</h3>\n\n\n\n<p>Adapt across your portfolio—Global Sponsors can represent different brands at different events (subject to approval and advance notice).</p>\n\n\n\n<h3 class=\"wp-block-heading\">Program Benefits</h3>\n\n\n\n<figure class=\"wp-block-table\"><table class=\"has-fixed-layout\"><tbody><tr><td class=\"has-text-align-left\" data-align=\"left\"></td><td class=\"has-text-align-center\" data-align=\"center\"><strong>Global&nbsp;Leader</strong></td><td class=\"has-text-align-center\" data-align=\"center\"><strong>Regional Powerhouse</strong></td><td class=\"has-text-align-center\" data-align=\"center\"><strong>Community Builder</strong></td></tr><tr><td class=\"has-text-align-left\" data-align=\"left\"><br><br><br><br><strong>Best for:<br></strong></td><td class=\"has-text-align-center\" data-align=\"center\">Established brands seeking global reach and year-round visibility.</td><td class=\"has-text-align-center\" data-align=\"center\">Companies aiming for regional dominance and strong brand recognition.</td><td class=\"has-text-align-center\" data-align=\"center\">Organizations supporting the next generation of WordPress education.</td></tr><tr><td class=\"has-text-align-left\" data-align=\"left\">Sponsorship payable in full or through quarterly installments</td><td class=\"has-text-align-center\" data-align=\"center\">$180,000</td><td class=\"has-text-align-center\" data-align=\"center\">$110,000</td><td class=\"has-text-align-center\" data-align=\"center\">$60,000</td></tr><tr><td class=\"has-text-align-left\" data-align=\"left\">Top tier sponsorship benefits at all local <a href=\"https://central.wordcamp.org/\">WordCamp</a> events (excludes flagships) with priority access to claim a sponsor table at in-person <a href=\"https://events.wordpress.org/\">WordPress events</a></td><td class=\"has-text-align-center\" data-align=\"center\"><img src=\"https://s.w.org/images/core/emoji/17.0.2/72x72/2714.png\" alt=\"✔\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></td><td class=\"has-text-align-center\" data-align=\"center\"></td><td class=\"has-text-align-center\" data-align=\"center\"></td></tr><tr><td class=\"has-text-align-left\" data-align=\"left\">Option to feature multiple brands across events</td><td class=\"has-text-align-center\" data-align=\"center\"><img src=\"https://s.w.org/images/core/emoji/17.0.2/72x72/2714.png\" alt=\"✔\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></td><td class=\"has-text-align-center\" data-align=\"center\"></td><td class=\"has-text-align-center\" data-align=\"center\"></td></tr><tr><td class=\"has-text-align-left\" data-align=\"left\">Dedicated sponsor landing page</td><td class=\"has-text-align-center\" data-align=\"center\"><img src=\"https://s.w.org/images/core/emoji/17.0.2/72x72/2714.png\" alt=\"✔\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></td><td class=\"has-text-align-center\" data-align=\"center\"><img src=\"https://s.w.org/images/core/emoji/17.0.2/72x72/2714.png\" alt=\"✔\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></td><td class=\"has-text-align-center\" data-align=\"center\"></td></tr><tr><td class=\"has-text-align-left\" data-align=\"left\">Complimentary WordPress event tickets for your team</td><td class=\"has-text-align-center\" data-align=\"center\"><img src=\"https://s.w.org/images/core/emoji/17.0.2/72x72/2714.png\" alt=\"✔\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></td><td class=\"has-text-align-center\" data-align=\"center\"><img src=\"https://s.w.org/images/core/emoji/17.0.2/72x72/2714.png\" alt=\"✔\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></td><td class=\"has-text-align-center\" data-align=\"center\"></td></tr><tr><td class=\"has-text-align-left\" data-align=\"left\">Recognition across all <a href=\"https://events.wordpress.org/\">WordPress events</a></td><td class=\"has-text-align-center\" data-align=\"center\"><img src=\"https://s.w.org/images/core/emoji/17.0.2/72x72/2714.png\" alt=\"✔\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></td><td class=\"has-text-align-center\" data-align=\"center\"><img src=\"https://s.w.org/images/core/emoji/17.0.2/72x72/2714.png\" alt=\"✔\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></td><td class=\"has-text-align-center\" data-align=\"center\"></td></tr><tr><td class=\"has-text-align-left\" data-align=\"left\">Sponsor Spotlight post on WordPress.org/news featuring highlights from recent <a href=\"https://central.wordcamp.org/\">WordCamps</a></td><td class=\"has-text-align-center\" data-align=\"center\">Quarterly</td><td class=\"has-text-align-center\" data-align=\"center\">Annually</td><td class=\"has-text-align-center\" data-align=\"center\"></td></tr><tr><td class=\"has-text-align-left\" data-align=\"left\">Inclusion of your company logo in signage and materials for <a href=\"https://events.wordpress.org/campusconnect/\">WordPress Campus Connect</a> events</td><td class=\"has-text-align-center\" data-align=\"center\">All signage &amp; materials for the year (digital and printed)</td><td class=\"has-text-align-center\" data-align=\"center\">Signage &amp; materials for 5 events per year (printed only)</td><td class=\"has-text-align-center\" data-align=\"center\">All signage &amp; materials for the year (digital and printed)</td></tr><tr><td class=\"has-text-align-left\" data-align=\"left\">Opportunity to be featured in an exclusive digital binder for <a href=\"https://events.wordpress.org/campusconnect/\">WordPress Campus Connect</a> event organizers</td><td class=\"has-text-align-center\" data-align=\"center\">Priority placement (logos &amp; text)</td><td class=\"has-text-align-center\" data-align=\"center\">Feature listing (text only)</td><td class=\"has-text-align-center\" data-align=\"center\">Feature listing (text only)</td></tr><tr><td class=\"has-text-align-left\" data-align=\"left\">Regular recognition in <a href=\"https://make.wordpress.org/community/2025/11/03/monthly-education-buzz-report-october-2025/\">monthly education buzz report</a></td><td class=\"has-text-align-center\" data-align=\"center\"></td><td class=\"has-text-align-center\" data-align=\"center\"></td><td class=\"has-text-align-center\" data-align=\"center\"><img src=\"https://s.w.org/images/core/emoji/17.0.2/72x72/2714.png\" alt=\"✔\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></td></tr></tbody></table></figure>\n\n\n\n<h2 class=\"wp-block-heading\">How Sponsorship Funds Are Used</h2>\n\n\n\n<p>Global Sponsorship funds directly support:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Local WordPress events worldwide (venue rental, catering, A/V, and more)</li>\n\n\n\n<li>Meetup.com license fees for over 671 WordPress Meetup groups globally</li>\n\n\n\n<li>Administrative costs like insurance, banking, and annual financial audits that ensure transparent operations</li>\n</ul>\n\n\n\n<p>Your partnership helps sustain the community that powers more than 43% of the web. Together, we can keep the WordPress project thriving and expanding for years to come.</p>\n\n\n\n<div class=\"wp-block-group has-off-white-2-background-color has-background is-layout-constrained wp-container-core-group-is-layout-d1b48064 wp-block-group-is-layout-constrained\" style=\"padding-top:var(--wp--preset--spacing--edge-space);padding-right:var(--wp--preset--spacing--edge-space);padding-bottom:var(--wp--preset--spacing--edge-space);padding-left:var(--wp--preset--spacing--edge-space)\">\n<p class=\"has-text-align-center\"><strong><strong>If your company is interested in joining the Global Sponsorship program or you would like to know more, please reach out</strong></strong>.</p>\n\n\n\n<div class=\"wp-block-buttons is-content-justification-center is-layout-flex wp-container-core-buttons-is-layout-a89b3969 wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"mailto:support@wordcamp.org\">Contact WordPress Community Support</a></div>\n</div>\n\n\n\n<div style=\"height:25px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<p><em>Please see&nbsp;<a href=\"https://make.wordpress.org/community/handbook/wordcamp-organizer/planning-details/fundraising/global-community-sponsorship-for-event-organizers/#rules-for-sponsor-materials\">Rules for Sponsor Materials</a>&nbsp;for more details about terms of sponsorship. Please also see our&nbsp;<a href=\"https://make.wordpress.org/community/files/2024/12/Draft-of-2025-WordPress-Global-Community-Sponsorship-Agreement-Template-Google-Docs.pdf\" target=\"_blank\" rel=\"noreferrer noopener\">sample sponsorship agreement</a>.</em></p>\n</div>\n\n\n\n<p>If you’d like to go one step further, please consider <a href=\"https://wordpressfoundation.org/donate/\">donating directly to the WordPress Foundation</a>. We operate lean—every dollar goes toward keeping WordPress free, supporting education, and funding the community that makes the web a better place. In short, your donation helps us keep the lights on and the mission alive.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"19534\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:65:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n\n					\n										\n					\n		\n		\n\n\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"State of the Word 2025: Innovation Shaped by Community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"https://wordpress.org/news/2025/12/sotw-2025/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 03 Dec 2025 18:26:05 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:9:\"Community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:6:\"Events\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:17:\"state of the word\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=19447\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:354:\"State of the Word 2025 brought the WordPress community together for an afternoon that felt both reflective and forward-moving, blending stories of global growth with technical milestones and glimpses of the future. This year also marked the twentieth State of the Word since the first address in 2006, a milestone noted in the WordPress history [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:2:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:59:\"https://wordpress.org/news/files/2025/12/Telex-demo-776.mp4\";s:6:\"length\";s:8:\"29136831\";s:4:\"type\";s:9:\"video/mp4\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:53:\"https://wordpress.org/news/files/2025/12/wapu-513.mp4\";s:6:\"length\";s:9:\"102323371\";s:4:\"type\";s:9:\"video/mp4\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Nicholas Garofalo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:36376:\"\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n<iframe title=\"State of the Word 2025\" width=\"500\" height=\"281\" src=\"https://www.youtube.com/embed/U_DF4-23C8Q?feature=oembed\" frameborder=\"0\" allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share\" referrerpolicy=\"strict-origin-when-cross-origin\" allowfullscreen></iframe>\n</div></figure>\n\n\n\n<p>State of the Word 2025 brought the WordPress community together for an afternoon that felt both reflective and forward-moving, blending stories of global growth with technical milestones and glimpses of the future. This year also marked the twentieth State of the Word since the first address in 2006, a milestone noted in the WordPress history book <a href=\"https://wordpress.org/book/2015/11/wordcamp-2006/\"><em>Milestones: The Story of WordPress</em></a> as the beginning of a tradition that has helped the project tell its own story.</p>\n\n\n\n<p>From the outset, the keynote carried a sense of momentum shaped by thousands of contributors, educators, students, and creators whose steady participation continues to define the open web. It was a reminder that WordPress is more than software. It is a community writing its future together.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>What we have is more than code. It’s momentum, it’s culture, and it’s a system that lets people learn by doing and lead by showing up.  — <a href=\"https://profiles.wordpress.org/4thhubbard/\">Mary Hubbard</a>, WordPress Executive Director</p>\n</blockquote>\n\n\n\n<p>Mary opened the evening by reflecting on her first full year as Executive Director, a year spent listening deeply and seeing firsthand how people across regions learn, contribute, and lead. Her remarks grounded the keynote in the lived reality of a community that grows because people invest in one another, teach openly, and build trust through contribution.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>I’ve met people using WordPress to unlock new careers. I’ve met contributors who started a single translation or forum post and are now leading major pieces of the project. In LatAm, Europe, and the States, I’ve seen students get access to WordPress tools and start building faster than we could have ever imagined. I’ve watched communities build in public, resolve disagreements in the open, and collaborate across languages and time zones.</p>\n</blockquote>\n\n\n\n<p>That reflection offered a clear reminder of what makes WordPress resilient through change: a culture of showing up, learning by doing, and supporting others along the way. The project moves forward because people choose to participate in ways both large and small, strengthening the foundation that has carried WordPress for more than two decades.</p>\n\n\n\n<p>With that foundation in place, the keynote moved through a series of stories and demonstrations that highlighted where WordPress stands today and where it is headed next — from a historic live release of WordPress 6.9 to expanding global education pathways, emerging AI capabilities, and deeper collaboration across the entire ecosystem.</p>\n\n\n\n<h2 class=\"wp-block-heading\">WordPress by the Numbers</h2>\n\n\n\n<p>Project Cofounder <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a> began with a wide-angle view of the project’s growth. WordPress powers over 43% of the web, with 60.5% of the CMS market. Shopify, its nearest competitor, holds 6.8%. Among the top 1,000 websites, WordPress’s share climbed to 49.4%, up 2.3% from the previous year.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img data-recalc-dims=\"1\" decoding=\"async\" width=\"1024\" height=\"576\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-43.jpg?resize=1024%2C576&#038;ssl=1\" alt=\"Globe graphic noting 43% of websites and 60.5% CMS market share\" class=\"wp-image-19500\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-43-scaled.jpg?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-43-scaled.jpg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-43-scaled.jpg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-43-scaled.jpg?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-43-scaled.jpg?resize=2048%2C1152&amp;ssl=1 2048w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" /></figure>\n\n\n\n<p>Multilingual usage continued its strong rise. Over 56% of WordPress sites now run in languages other than English. Japan stood out, with WordPress powering 58.5% of all Japanese websites and 83% of the CMS market. Japanese became the second most-used language on WordPress at 5.82%. Spanish followed, then German, French, and Brazilian Portuguese.</p>\n\n\n\n<p>The plugin ecosystem saw explosive growth. The directory surpassed 60,000 plugins, and plugin downloads were on pace to reach 2.1 billion by year-end. Over 1,500 themes have been released this year as well.</p>\n\n\n\n<p>Contributors also hit new highs. The 6.8 release included 921 contributors, the largest group yet. WordPress 6.8 saw 79.5 million downloads, up 13%, and WordPress 6.9 included contributions from 230 first-time contributors and more than 340 enhancements and fixes.</p>\n\n\n\n<h2 class=\"wp-block-heading\">A Release Moment to Remember</h2>\n\n\n\n<p>This year’s keynote delivered something WordPress had never attempted before: a live on-stage release of <a href=\"https://wordpress.org/download/releases/6-9/\">WordPress 6.9</a>.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"576\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-gene.jpg?resize=1024%2C576&#038;ssl=1\" alt=\"WordPress 6.9 Gene album cover art\" class=\"wp-image-19511\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-gene-scaled.jpg?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-gene-scaled.jpg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-gene-scaled.jpg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-gene-scaled.jpg?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-gene-scaled.jpg?resize=2048%2C1152&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /></figure>\n\n\n\n<p>Mary set the moment up earlier in the program, calling WordPress 6.9 “fast, polished, and built for collaboration.” She explained that it reflected a year of intentional iteration, improved workflows, and deeper cross-team participation.&nbsp;</p>\n\n\n\n<p>Matt took the stage with some of the release leads, the release button in hand. The room counted down, and then WordPress 6.9 shipped live, instantly updating millions of sites around the world. It was both a celebration and a testament to the reliability and trust the WordPress community has built into its release processes. Shipping a major version of WordPress in real time, on stage, without drama, is something the early contributors could hardly have imagined.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"576\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/12/release-leads.jpg?resize=1024%2C576&#038;ssl=1\" alt=\"Photo of WordPress release leads pressing the button to release 6.9\" class=\"wp-image-19457\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/12/release-leads-scaled.jpg?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/12/release-leads-scaled.jpg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/12/release-leads-scaled.jpg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/12/release-leads-scaled.jpg?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/12/release-leads-scaled.jpg?resize=2048%2C1152&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /></figure>\n\n\n\n<p>That reflection connected back to WordPress’s origin story. Matt talked about discovering the <a href=\"https://en.wikipedia.org/wiki/WordPress#History\">B2</a> forums, asking questions, and eventually reaching the point where he could answer someone else’s. That transition from learner to contributor remains at the heart of the project today. Two decades later, WordPress has grown from those early interactions into a platform that can ship a major release in front of the world, powered by thousands of contributors building together.</p>\n\n\n\n<h2 class=\"wp-block-heading\">WordPress and the Future of AI</h2>\n\n\n\n<p>As the keynote shifted toward the future, Matt acknowledged what has become an essential truth of the moment: it would be impossible to talk about the next chapter of WordPress without talking about AI. He reminded the audience that in 2022, long before ChatGPT entered global conversation, he encouraged the community to “learn AI deeply.” The speed of change since then, he said, has exceeded every expectation, and WordPress has been preparing for it in ways both visible and behind the scenes.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"576\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-AI.jpg?resize=1024%2C576&#038;ssl=1\" alt=\"Timeline of AI: 2022 ChatGPT launches, 2023 GPT-4 and Claude launches, 2024 Multimodel and video generation, 2025 AI everywhere\" class=\"wp-image-19510\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-AI-scaled.jpg?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-AI-scaled.jpg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-AI-scaled.jpg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-AI-scaled.jpg?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-AI-scaled.jpg?resize=2048%2C1152&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /></figure>\n\n\n\n<p>Matt introduced one of the most important architectural developments of the year: the Abilities API and the MCP adapter. The Abilities API defines what WordPress can do in a structured way that AI systems can interpret, while the MCP adapter exposes those abilities through a shared protocol. This means AI agents — whether built by individuals, companies, or larger platforms — can understand and interact with WordPress safely and predictably. Instead of relying on one-off integrations or brittle interfaces, WordPress now participates in a broader ecosystem of tools that can query its capabilities and perform tasks using a standard, governed approach.</p>\n\n\n\n<p>Matt then highlighted how developers are already using AI in their everyday work through tools like Cursor, Claude Code, and next-generation CLIs. These tools can explore entire codebases, generate documentation, produce tests, refactor large components, and even coordinate sequences of WP-CLI commands. For many developers, they expand what a single person can accomplish in an afternoon. They don’t eliminate the need for human judgment — they amplify it.</p>\n\n\n\n<p>With that foundation laid, Matt turned the audience’s attention to <a href=\"https://telex.automattic.ai/\">Telex</a>, the experimental environment designed to turn natural-language prompts into Gutenberg Blocks. Telex has already moved beyond experimentation and into real use. Matt showed examples from community creator Nick Hamze, who uses Telex to power micro-business tools that represent practical, revenue-generating workflows that previously required custom engineering.</p>\n\n\n\n<figure class=\"wp-block-video\"><video height=\"2160\" style=\"aspect-ratio: 3840 / 2160;\" width=\"3840\" controls src=\"https://wordpress.org/news/files/2025/12/Telex-demo-776.mp4\"></video></figure>\n\n\n\n<p>Matt then widened the lens to show what companies across the ecosystem are building with AI. Hostinger’s Kodee can generate a complete WordPress site from a single description. Elementor AI demonstrated similarly rapid creation inside its own editor, producing full sections and layouts in seconds. WordPress.com showcased how its AI tools help users draft, rewrite, and refine content while keeping language aligned with the site’s voice. Yoast demonstrated how AI can support SEO workflows by generating structured suggestions and improving readability. Together, these examples illustrated that AI is not arriving in one place — it is arriving everywhere.</p>\n\n\n\n<p>Experimental browsers can navigate WP Admin autonomously, performing tasks such as clicking buttons, opening menus, changing settings, and performing multi-step tasks without requiring any custom plugins or APIs. This raised a key question that Matt encouraged the community to consider: Which AI capabilities should live inside WordPress itself, and which should remain external, operating through the browser or operating system?</p>\n\n\n\n<p>Matt closed the section by discussing WordPress-specific AI benchmarks and evaluation suites. These shared tests will measure how well AI systems understand and execute WordPress tasks, from enabling plugins to navigating WP Admin to modifying content and settings. The goal is to create a foundation where future AI tools behave predictably and responsibly across the entire ecosystem, giving creators confidence that intelligent tools understand the platform deeply.</p>\n\n\n\n<h2 class=\"wp-block-heading\">A Global Community Growing Together</h2>\n\n\n\n<p>Mary then returned to the stage to celebrate the ecosystem that supports WordPress&#8217;s growth. Across continents, diverse groups of people have hosted WordPress events, training new contributors and welcoming newcomers into the project. WordCamp growth in 2025 reflected that: more than 81 WordCamps across 39 countries, powered by over 5,000 volunteers and attended by nearly 100,000 people, with sixteen more events still underway.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"576\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-wordcamps.jpg?resize=1024%2C576&#038;ssl=1\" alt=\"\" class=\"wp-image-19503\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-wordcamps-scaled.jpg?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-wordcamps-scaled.jpg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-wordcamps-scaled.jpg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-wordcamps-scaled.jpg?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-wordcamps-scaled.jpg?resize=2048%2C1152&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /></figure>\n\n\n\n<p>Education played a major role in this community expansion. Learn.WordPress.org served over 1.5 million learners this year, with clearer pathways into more structured programs like <a href=\"https://wordpress.org/education/campus-connect/\">Campus Connect</a> and <a href=\"https://wordpress.org/education/credits/\">WordPress Credits</a>. This bridging was deliberate. Many learners arrive through tutorials or workshops but need clearer guidance on how to deepen their skills. By reshaping navigation and improving wayfinding across WordPress.org, the project began closing that gap.</p>\n\n\n\n<p>She spotlighted <a href=\"https://make.wordpress.org/community/2025/09/29/wordpress-and-higher-education-an-alliance-that-transforms/\">Costa Rica’s Universidad Fidélitas</a>, where WordPress moved beyond extracurricular interest into formal academic integration. Long before signing an agreement with the WordPress Foundation, their students were hosting WordCamp San José, forming student clubs, and treating WordPress as a crucial part of digital literacy and professional development.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"576\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-photo.jpg?resize=1024%2C576&#038;ssl=1\" alt=\"\" class=\"wp-image-19505\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-photo-scaled.jpg?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-photo-scaled.jpg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-photo-scaled.jpg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-photo-scaled.jpg?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-photo-scaled.jpg?resize=2048%2C1152&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><figcaption class=\"wp-element-caption\">Students of the WordPress Fidélitas Club</figcaption></figure>\n\n\n\n<p>Wapuu appeared across events as a familiar companion and a cultural thread running through contributor tools and community projects. Its presence was a reminder that creativity and playfulness are as essential to open source as documentation or code.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"576\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-wapuu.jpg?resize=1024%2C576&#038;ssl=1\" alt=\"Various Wapuu artwork examples\" class=\"wp-image-19506\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-wapuu-scaled.jpg?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-wapuu-scaled.jpg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-wapuu-scaled.jpg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-wapuu-scaled.jpg?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-wapuu-scaled.jpg?resize=2048%2C1152&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /></figure>\n\n\n\n<p>Matt highlighted the story of <a href=\"https://events.wordpress.org/managua/2025/wordpress-youth-day/\">Youth Day in Managua, Nicaragua</a>. Seventy-five young people spent a full day building their first WordPress sites. Sessions were taught by teenagers, for teenagers. They learned to pick themes, customize layouts, create contact forms, and publish content. Contribution often starts with a simple moment of confidence, and those early sparks can shape entire careers.</p>\n\n\n\n<figure class=\"wp-block-video\"><video height=\"2160\" style=\"aspect-ratio: 3840 / 2160;\" width=\"3840\" controls src=\"https://wordpress.org/news/files/2025/12/wapu-513.mp4\"></video></figure>\n\n\n\n<p>Together, these moments illustrated a project expanding not just in numbers, but in depth, diversity, and global reach. WordPress is growing because communities are finding their own ways to embrace it.</p>\n\n\n\n<h2 class=\"wp-block-heading\">What’s New in WordPress 6.9</h2>\n\n\n\n<p>Joining virtually, WordPress Lead Architect, <a href=\"https://profiles.wordpress.org/matveb/\">Matías Ventura</a>, shifted the keynote from vision to practice. Matías offered a detailed walkthrough of what makes WordPress 6.9 one of the most refined, collaborative, and forward-looking releases the project has shipped in years. He returned to the four familiar lenses of creation — writing, designing, building, and developing — and showed how each evolved in this release cycle.</p>\n\n\n\n<p>He began with notes in the Block Editor, one of the most anticipated features. Notes allow collaborators to comment directly on individual blocks in a post or page. When a note is selected, the surrounding content subtly fades, helping contributors stay focused on context. Because notes are built on WordPress’s native comment system, they integrate seamlessly with existing communication workflows, including email notifications. Matías highlighted that notes development exemplified collaboration at its best, with contributors from various companies working together to bring the feature to life.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n<iframe loading=\"lazy\" title=\"WordPress 6.9 Feature Demo\" width=\"500\" height=\"281\" src=\"https://www.youtube.com/embed/vkYulcN0lbc?feature=oembed\" frameborder=\"0\" allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share\" referrerpolicy=\"strict-origin-when-cross-origin\" allowfullscreen></iframe>\n</div></figure>\n\n\n\n<p>From there, he turned to refinements across the writing and design experience. Editor interactions feel smoother and more consistent. Patterns behave more predictably. Spacing and typography controls are clearer, more organized, and more intuitive. Together these capabilioties make the experience of writing and designing inside WordPress calmer, more reliable, and more empowering.</p>\n\n\n\n<p>Block bindings now provide a more intuitive, visual way to connect blocks to dynamic data sources. Users can switch or remove bindings with a single click, and developers can register additional sources to support custom workflows. This work lays the foundation for a future where dynamic data flows more naturally through blocks, enabling site creators to build richer interfaces without writing code.</p>\n\n\n\n<p>On the developer front, Matías focused on three foundational upgrades that represent major steps forward in how WordPress will evolve over the coming years.</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>The first was the <strong>Abilities API</strong>, a unified registry that describes what WordPress can do — across PHP, REST endpoints, the command palette, and future AI-driven interactions.</li>\n\n\n\n<li>The <strong>HTML API</strong> introduces new ways of working with and modifying HTML server-side. The API ensures safer, more reliable handling, lowering the barrier for theme and block developers who work with dynamic or structured markup.</li>\n\n\n\n<li>The <strong>Interactivity API</strong> delivers smoother, faster interactions without requiring heavy JavaScript frameworks. Improved routing, better state management, and clearer conventions help developers create rich, modern interfaces without leaving the WordPress philosophy of simplicity and flexibility.</li>\n</ul>\n\n\n\n<p>After Matías wrapped his presentation, Matt stepped back in to highlight several developments that build on the foundations of 6.9 and strengthen the overall WordPress ecosystem. He pointed first to the <a href=\"https://wordpress.org/plugins/plugin-check/\">Plugin Check Plugin</a>, a tool designed to help developers align with current WordPress standards and catch common issues early, making plugins more reliable for users and easier to maintain over time. Matt then spoke about ongoing progress in <a href=\"https://wordpress.org/data-liberation/\">Data Liberation</a>, noting improvements to the <a href=\"https://wordpress.org/plugins/wordpress-importer/\">WordPress importer</a> that make it easier for people to bring their content into WordPress without disruption or loss, an important step toward ensuring the open web remains portable and resilient. He also highlighted advances across the <a href=\"https://playground.wordpress.net/\">Playground</a> ecosystem, including <a href=\"https://developer.wordpress.com/studio/\">WordPress Studio</a>, the Playground CLI, and an expanding set of Blueprints. These allow developers and learners to spin up complete WordPress environments in seconds, test ideas, and experiment without servers or configuration. Matt closed this portion by emphasizing work on safer updates, which help WordPress avoid partial installs and ensure that updates complete smoothly even in less predictable hosting conditions, reinforcing WordPress’s commitment to stability as the platform continues to grow.</p>\n\n\n\n<p>Matt emphasized that WordPress 6.9 is not defined by any single headline feature, but by a broad spectrum of refinements across the entire experience. It is a release that deepens reliability, expands capability, and sets the stage for future innovation.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Insights from the AI Panel</h2>\n\n\n\n<p>The keynote transitioned into a live AI panel moderated by Mary Hubbard. The panel brought together four perspectives from across the ecosystem: <a href=\"https://profiles.wordpress.org/isotropic/\">James LePage</a> (Automattic), <a href=\"https://profiles.wordpress.org/flixos90/\">Felix Arntz</a> (Google), and <a href=\"https://profiles.wordpress.org/jeffpaul/\">Jeff Paul</a> (Fueled, FKA 10up), and Matt Mullenweg. Their conversation touched on the philosophy, practice, and future of AI inside WordPress — not as a distant trend, but as an active part of the project’s evolution.</p>\n\n\n\n<p>A central theme was AI’s ability to amplify human creativity. James LePage put it plainly:</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>It’s not that we’re going to just add sparkle buttons everywhere. We’re going to do some crazy stuff here — things we’re going to build into the way you interact with creating content, with expressing yourself digitally. We want to give you more power, more control, and make you more effective at creating.</p>\n</blockquote>\n\n\n\n<p>Jeff Paul echoed this sentiment, emphasizing that AI should make developers more productive by handling repetitive work and freeing them to focus on higher-level decisions. Felix Arntz expanded the idea further, describing how Google sees AI as a way to make the web more accessible and intuitive, especially for new creators who may not have formal technical training.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"572\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/12/panel.jpg?resize=1024%2C572&#038;ssl=1\" alt=\"\" class=\"wp-image-19462\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/12/panel-scaled.jpg?resize=1024%2C572&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/12/panel-scaled.jpg?resize=300%2C168&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/12/panel-scaled.jpg?resize=768%2C429&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/12/panel-scaled.jpg?resize=1536%2C858&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/12/panel-scaled.jpg?resize=2048%2C1144&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><figcaption class=\"wp-element-caption\">From left to right: Mary Hubbard, Matt Mullenweg, Jeff Paul, Felix Arntz, James LePage</figcaption></figure>\n\n\n\n<p>Looking ahead, the panelists predicted deeper contextual integrations, AI-assisted debugging and scaffolding for developers, and workflows where agents can take on sequences of tasks while remaining directed by human decisions. They also highlighted the importance of standards, shared protocols, and privacy-focused design as essential components of WordPress’s long-term approach.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>The next 20 years looks like WordPress remaining what it is today, which is the center of the open web.</p>\n</blockquote>\n\n\n\n<p>The panel closed on a forward-looking but steady note. AI is accelerating, but WordPress is designing its foundations with flexibility and values that endure. The tools may change, but the commitment to openness, agency, and creative freedom remains the compass.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Questions That Push Us Forward</h2>\n\n\n\n<p>Matt introduced the Q&amp;A as one of his favorite parts of State of the Word because it reveals what people are imagining, struggling with, or eager to build.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"576\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-QandA.jpg?resize=1024%2C576&#038;ssl=1\" alt=\"Q&amp;A\" class=\"wp-image-19512\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-QandA-scaled.jpg?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-QandA-scaled.jpg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-QandA-scaled.jpg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-QandA-scaled.jpg?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/12/State-of-the-Word-2025-QandA-scaled.jpg?resize=2048%2C1152&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /></figure>\n\n\n\n<p>The first question addressed the growing interconnectedness of today’s web. What happens, a participant asked, when a major provider like Cloudflare goes down? As tools and agents rely more heavily on external services, failures can cascade. Matt acknowledged that outages are increasingly visible, but also argued that each one strengthens the system.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>&#8220;Every failure, every edge case, everything that you never imagined is just another opportunity to find that new edge case,” he said. Resilience is not avoidance of failure, but the ability to grow stronger after it.</p>\n</blockquote>\n\n\n\n<p>Another question focused on the longevity of web content. With platforms shutting down or links breaking over time, how can creators ensure their work endures? Matt pointed to the Internet Archive as one of the great stabilizers of the open web. He highlighted a <a href=\"https://wordpress.org/plugins/internet-archive-wayback-machine-link-fixer/\">new plugin</a> that automatically scans posts and replaces dead links with archived versions, helping preserve the historical fabric of the web even as individual services come and go.</p>\n\n\n\n<p>The next question turned to real-time collaboration inside WordPress. A participant asked how co-editing fits into the future of WordPress and how these tools might help creators work more confidently. Matt talked about how collaboration tools can support people who are just starting their creative journeys — whether they are entrepreneurs, students, or first-time site builders. He described real-time editing as part of a broader vision of WordPress “just doing the work for you” in high-pressure or early-stage creative moments.</p>\n\n\n\n<p>The final question considered long-term decision-making. Matt noted that predicting what will change is difficult, but identifying what will remain the same is much easier. For WordPress, he said, the invariant is clear: people will always want agency, openness, and the ability to publish on their own terms. These values guide decisions not only in the present, but across decades of future evolution.</p>\n\n\n\n<h2 class=\"wp-block-heading\">TBPN Podcast Appearance</h2>\n\n\n\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n<iframe loading=\"lazy\" title=\"&#x1f534; CODE RED &#x1f534;, Dell Donates Size, Bun Acquired, AWS CEO Joins, Tae Kim Tells All\" width=\"500\" height=\"281\" src=\"https://www.youtube.com/embed/eBQh57HuJzk?start=10036&#038;feature=oembed\" frameborder=\"0\" allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share\" referrerpolicy=\"strict-origin-when-cross-origin\" allowfullscreen></iframe>\n</div></figure>\n\n\n\n<p>After the Q&amp;A, the keynote shifted gears with a live crossover segment featuring TBPN (the Technology Business Programming Network), a tech-focused podcast. The segment introduced a lively, unscripted energy into the room.</p>\n\n\n\n<p>The hosts kicked things off by asking Matt what the “word of the year” should be. He chose “freedom”, connecting it directly to the core philosophy of open source. He described open source licenses as a kind of “bill of rights for software,” giving users inalienable rights that no company can revoke. In a world increasingly shaped by software platforms and digital ecosystems, these freedoms form the heart of what keeps the web open and accessible.</p>\n\n\n\n<p>Conversation then moved to <a href=\"https://www.beeper.com/\">Beeper</a>, the multi-network messaging client. Asked whether Beeper aims to “tear down walled gardens,” Matt rejected that framing. Instead, he offered a more collaborative metaphor: bringing gardens together. Most people have friends and colleagues scattered across WhatsApp, Instagram, LinkedIn, Messenger, and SMS. Beeper doesn’t replace those apps — it brings messages together into a unified interface..</p>\n\n\n\n<p>The conversation eventually returned to publishing. Matt referenced the same principle he noted earlier: the importance of identifying what won’t change. For WordPress, he said, that means doubling down on freedom, agency, and the ability to publish without gatekeepers. Even as AI evolves, even as platforms shift, even as new tools emerge, these are the values that will guide the project forward.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Building the Web We Believe In</h2>\n\n\n\n<p>As the keynote drew to a close, Matt returned to a message that had threaded through every section of the evening. The future of WordPress is not arriving from outside forces — it is being crafted, questioned, tested, and expanded by the people who show up. Contributors, students, educators, community organizers, designers, developers, business owners, and first-time site builders all play a role in shaping the platform.</p>\n\n\n\n<p>He spoke about the opportunities ahead: new tools that expand what creators can build, collaborative features that make teamwork feel natural, and AI systems that enhance creativity rather than diminish it. Across continents, generations, and skill levels, people are discovering WordPress as a path to learning, empowerment, and expression.</p>\n\n\n\n<p>The values that brought the project this far remain the ones that will carry it forward: freedom, participation, learning, and community. These aren’t abstract principles. They are lived every day in the decisions contributors make, the ideas they pursue, and the care they bring to the work.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Future Events</h3>\n\n\n\n<p>If you’re feeling inspired to revisit past moments from the project’s annual address, the <a href=\"https://www.youtube.com/playlist?list=PL1pJFUVKQ7ES1piZxljCvMTJCYpVBnwYU\">State of the Word YouTube playlist</a> offers a look back at years of community milestones and product progress. The excitement continues into 2026, with major WordPress events already on the horizon: <a href=\"https://asia.wordcamp.org/2026/\">WordCamp Asia</a> in Mumbai, India,<a href=\"https://europe.wordcamp.org/2026/\">WordCamp Europe</a> in Kraków, Poland, and <a href=\"https://us.wordcamp.org/2026/\">WordCamp US</a> in Phoenix. We hope to see you there as the community continues building what comes next.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"19447\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:66:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"WordPress 6.9 “Gene”\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://wordpress.org/news/2025/12/gene/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 02 Dec 2025 20:12:21 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:4:{i:0;a:5:{s:4:\"data\";s:7:\"General\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"6.9\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:8:\"releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=19398\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:495:\"WordPress 6.9, code-named \"Gene,\" brings major upgrades to how teams collaborate and create. The Notes feature introduces block-level commenting to streamline reviewing and polishing content, navigating across the entire dashboard with the Command Palette is now faster for power users, and the new Abilities API provides a standardized way to open the door for AI-powered and automated workflows. Combined with all the performance and accessibility improvements, 6.9 is one to write home about.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt Mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:79691:\"\n<figure class=\"wp-block-image size-large\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"535\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/12/Release-Edition-Featured-Image-6.9.png?resize=1024%2C535&#038;ssl=1\" alt=\"WordPress 6.9 Release Edition Featured Image\" class=\"wp-image-19404\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/12/Release-Edition-Featured-Image-6.9-scaled.png?resize=1024%2C535&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/12/Release-Edition-Featured-Image-6.9-scaled.png?resize=300%2C157&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/12/Release-Edition-Featured-Image-6.9-scaled.png?resize=768%2C401&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/12/Release-Edition-Featured-Image-6.9-scaled.png?resize=1536%2C802&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/12/Release-Edition-Featured-Image-6.9-scaled.png?resize=2048%2C1070&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /></figure>\n\n\n\n<p>Each WordPress release celebrates an artist who has made an indelible mark on the world of music. WordPress 6.9, code-named “Gene,” honors the American Jazz pianist Gene Harris.&nbsp;</p>\n\n\n\n<p>A piano veteran, self taught at the age of six, Harris infused mainstream jazz with elements of soul, blues, and gospel, creating a warm, signature sound that is both elegant and iconic. Harris’ bluesy jazz lived at the intersection of worlds, weaving a rich landscape of texture and mood, with a thread of soulfulness that ignited listeners.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Welcome to WordPress 6.9</h2>\n\n\n\n<p>WordPress 6.9 brings major upgrades to how teams collaborate and create. The new Notes feature introduces block-level commenting when writing posts and pages that streamlines reviews, while the expanded Command Palette makes it faster for power users to navigate and operate across the entire dashboard. The new Abilities API provides a standardized, machine-readable permissions system that opens the door for next generation AI-powered and automated workflows. This release also delivers notable performance improvements for faster page loads and adds several practical new blocks alongside a more visual drag and drop to help creators build richer, more dynamic content.</p>\n\n\n\n<p><a href=\"https://wordpress.org/wordpress-6.9.zip\">Download WordPress 6.9 &#8220;Gene&#8221;</a></p>\n\n\n\n<h2 class=\"wp-block-heading\">Introducing Notes: Seamless, Block-Level Collaboration</h2>\n\n\n\n<p><strong>Collaborate Smarter</strong> : Leave Feedback Right Where You&#8217;re Working</p>\n\n\n\n<p>With notes attached directly to blocks in the post editor, your team can stay aligned, track changes, and turn feedback into action all in one place. Whether you&#8217;re working on copy or refining design in your posts or pages, collaboration happens seamlessly on the canvas itself.</p>\n\n\n\n<figure class=\"wp-block-image size-full\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1360\" height=\"840\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/12/post-notes.png?resize=1360%2C840&#038;ssl=1\" alt=\"View of people interacting with notes in a post.\" class=\"wp-image-19428\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/12/post-notes.png?w=1360&amp;ssl=1 1360w, https://i0.wp.com/wordpress.org/news/files/2025/12/post-notes.png?resize=300%2C185&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/12/post-notes.png?resize=1024%2C632&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/12/post-notes.png?resize=768%2C474&amp;ssl=1 768w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /></figure>\n\n\n\n<h2 class=\"wp-block-heading\">Command Palette Throughout the Dashboard</h2>\n\n\n\n<p><strong>Your tools are always at hand.</strong></p>\n\n\n\n<p>Access the Command Palette from any part of the dashboard, whether you&#8217;re writing your latest post, deep in design in the Site Editor, or browsing your plugins. Everything you need, just a few keystrokes away.</p>\n\n\n\n<figure class=\"wp-block-image size-full\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1360\" height=\"840\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/12/post-command-palette.png?resize=1360%2C840&#038;ssl=1\" alt=\"Command palette showing the ability to navigate across different parts of the site, including templates, Settings, and all posts.\" class=\"wp-image-19430\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/12/post-command-palette.png?w=1360&amp;ssl=1 1360w, https://i0.wp.com/wordpress.org/news/files/2025/12/post-command-palette.png?resize=300%2C185&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/12/post-command-palette.png?resize=1024%2C632&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/12/post-command-palette.png?resize=768%2C474&amp;ssl=1 768w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /></figure>\n\n\n\n<h2 class=\"wp-block-heading\">Fit text to container</h2>\n\n\n\n<p><strong>Content that adapts.</strong></p>\n\n\n\n<p>There&#8217;s a new typography option for text-based blocks that&#8217;s been added to the Paragraph and Heading blocks. This new option automatically adjusts font size to fill its container perfectly, making it ideal for banners, callouts, and standout moments in your design.</p>\n\n\n\n<figure class=\"wp-block-image size-full\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1360\" height=\"840\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/12/post-fit-text.png?resize=1360%2C840&#038;ssl=1\" alt=\"&quot;Novem&quot; text selected and stretching across the interface.\" class=\"wp-image-19431\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/12/post-fit-text.png?w=1360&amp;ssl=1 1360w, https://i0.wp.com/wordpress.org/news/files/2025/12/post-fit-text.png?resize=300%2C185&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/12/post-fit-text.png?resize=1024%2C632&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/12/post-fit-text.png?resize=768%2C474&amp;ssl=1 768w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /></figure>\n\n\n\n<h2 class=\"wp-block-heading\">The Abilities API</h2>\n\n\n\n<p><strong>Unlocking the next generation of site interactions.</strong></p>\n\n\n\n<p>WordPress 6.9 lays the groundwork for the future of automation with the unified Abilities API. By creating a standardized registry for site functionality, developers can now register, validate, and execute actions consistently across any context—from PHP and REST endpoints to AI agents—paving the way for smarter, more connected WordPress experiences.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"632\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/12/abilities-api.png?resize=1024%2C632&#038;ssl=1\" alt=\"Abstract view of circles around a plugin icon with sparkles, indicating AI functionality.\" class=\"wp-image-19432\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/12/abilities-api.png?resize=1024%2C632&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/12/abilities-api.png?resize=300%2C185&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/12/abilities-api.png?resize=768%2C474&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/12/abilities-api.png?w=1360&amp;ssl=1 1360w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /></figure>\n\n\n\n<h2 class=\"wp-block-heading\">Accessibility Improvements</h2>\n\n\n\n<p>More than 30 accessibility fixes sharpen the core WordPress experience. These updates improve screen reader announcements, hide unnecessary CSS-generated content from assistive tech, fix cursor placement issues, and make sure typing focus stays put even when users click an autocomplete suggestion.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Performance enhancements</h2>\n\n\n\n<p>WordPress 6.9 delivers significant frontend performance enhancements, optimizing the site loading experience for visitors. 6.9 boasts an improved LCP (Largest Contentful Paint) through on-demand block styles for classic themes, minifying block theme styles, and increasing the limit for inline styles &#8211; removing blockages to page rendering and clearing the rendering path by deprioritizing non-critical scripts. This release comes with many more performance boosts, including optimized database queries, refined caching, improved spawning of WP Cron, and a new template enhancement output buffer that opens the door for more future optimizations.</p>\n\n\n\n<h3 class=\"wp-block-heading\">And much more</h3>\n\n\n\n<p>For a comprehensive overview of all the new features and enhancements in WordPress 6.9, please visit the feature-showcase website.</p>\n\n\n\n<p><a href=\"https://wordpress.org/download/releases/6-9\">Check out What&#8217;s New</a></p>\n\n\n\n<h2 class=\"wp-block-heading\">Learn more about WordPress 6.9</h2>\n\n\n\n<p><a href=\"https://learn.wordpress.org/\">Learn WordPress</a> is a free resource for new and experienced WordPress users. Learn is stocked with how-to videos on using various features in WordPress, <a href=\"https://learn.wordpress.org/social-learning/\">interactive workshops</a> for exploring topics in-depth, and lesson plans for diving deep into specific areas of WordPress.</p>\n\n\n\n<p>Read the <a href=\"https://wordpress.org/documentation/wordpress-version/version-6.9\">WordPress 6.9 Release Notes</a> for information on installation, enhancements, fixed issues, release contributors, learning resources, and the list of file changes.</p>\n\n\n\n<p>Explore the <a href=\"https://make.wordpress.org/core/wordpress-6-9-field-guide/\">WordPress 6.9 Field Guide</a>. Learn about the changes in this release with detailed developer notes to help you build with WordPress.</p>\n\n\n\n<h2 class=\"wp-block-heading\">The 6.9 release squad</h2>\n\n\n\n<p>Every release comes to you from a dedicated team of enthusiastic contributors who help keep things on track and moving smoothly. The team that has led 6.9 is a cross-functional group of contributors who are always ready to champion ideas, remove blockers, and resolve issues.</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Release Lead: <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a></li>\n\n\n\n<li>Release Coordination: <a href=\"https://profiles.wordpress.org/akshayar/\">Akshaya Rane</a>, <a href=\"https://profiles.wordpress.org/amykamala/\">Amy Kamala</a></li>\n\n\n\n<li>Tech Leads: <a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a>, <a href=\"https://profiles.wordpress.org/ellatrix/\">Ella van Durpe</a>, <a href=\"https://profiles.wordpress.org/priethor/\">Héctor Prieto</a></li>\n\n\n\n<li>Design Lead: <a href=\"https://profiles.wordpress.org/fcoveram/\">Francisco Vera</a></li>\n\n\n\n<li>Triage Leads: <a href=\"https://profiles.wordpress.org/wildworks/\">Aki Hamano</a>, <a href=\"https://profiles.wordpress.org/welcher/\">Ryan Welcher</a></li>\n\n\n\n<li>Test Leads: <a href=\"https://profiles.wordpress.org/psykro/\">Jonathan Bossenger</a>, <a href=\"https://profiles.wordpress.org/krupajnanda/\">Krupa Nanda</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Thank you, contributors</h2>\n\n\n\n<p>The mission of WordPress is to <a href=\"https://wordpress.org/about/\">democratize publishing</a> and embody the <a href=\"https://opensource.org/osd-annotated\">freedoms that come with open source</a>. A global and diverse community of people collaborating to strengthen the software supports this effort.</p>\n\n\n\n<p>WordPress 6.9 reflects the tireless efforts and passion of more than 900+ contributors in countries all over the world. This release also welcomed over 279 first-time contributors!</p>\n\n\n\n<p>Their collaboration delivered more than 340 enhancements and fixes, ensuring a stable release for all &#8211; a testament to the power and capability of the WordPress open source community.</p>\n\n\n\n<p class=\"has-small-font-size\"><a href=\"https://profiles.wordpress.org/o-o/\">2046</a> · <a href=\"https://profiles.wordpress.org/aakashverma1/\">Aakash Verma</a> · <a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a> · <a href=\"https://profiles.wordpress.org/aaronrobertshaw/\">Aaron Robertshaw</a> · <a href=\"https://profiles.wordpress.org/aarti1318/\">Aarti Chauhan</a> · <a href=\"https://profiles.wordpress.org/thehercules/\">Aashish Sharma</a> · <a href=\"https://profiles.wordpress.org/aatospaja/\">aatospaja</a> · <a href=\"https://profiles.wordpress.org/abduremon/\">Abdur Rahman Emon</a> · <a href=\"https://profiles.wordpress.org/hurayraiit/\">Abu Hurayra</a> · <a href=\"https://profiles.wordpress.org/kawauso/\">Adam Harley (Kawauso)</a> · <a href=\"https://profiles.wordpress.org/adamsilverstein/\">Adam Silverstein</a> · <a href=\"https://profiles.wordpress.org/zieladam/\">Adam Zieliński</a> · <a href=\"https://profiles.wordpress.org/adityab98/\">Aditya Bansode</a> · <a href=\"https://profiles.wordpress.org/b1ink0/\">Aditya Dhade</a> · <a href=\"https://profiles.wordpress.org/adityashah2411/\">aditya shah</a> · <a href=\"https://profiles.wordpress.org/iamadisingh/\">Aditya Singh</a> · <a href=\"https://profiles.wordpress.org/aduth/\">aduth</a> · <a href=\"https://profiles.wordpress.org/agulbra/\">agulbra</a> · <a href=\"https://profiles.wordpress.org/elazzabi/\">Ahmed</a> · <a href=\"https://profiles.wordpress.org/chaion07/\">Ahmed Kabir Chaion</a> · <a href=\"https://profiles.wordpress.org/ajaxstardust/\">ajaxStardust</a> · <a href=\"https://profiles.wordpress.org/ajitbohra/\">Ajit Bohra</a> · <a href=\"https://profiles.wordpress.org/akanshusingh/\">Akanshu Singh</a> · <a href=\"https://profiles.wordpress.org/akeda/\">Akeda Bagus</a> · <a href=\"https://profiles.wordpress.org/wildworks/\">Aki Hamano</a> · <a href=\"https://profiles.wordpress.org/atachibana/\">Akira Tachibana</a> · <a href=\"https://profiles.wordpress.org/wpfy/\">Akramul Hasan</a> · <a href=\"https://profiles.wordpress.org/akshat2802/\">Akshat Kakkad</a> · <a href=\"https://profiles.wordpress.org/akshaydhere/\">Akshay Dhere</a> · <a href=\"https://profiles.wordpress.org/akshayar/\">Akshaya Rane</a> · <a href=\"https://profiles.wordpress.org/aljullu/\">Albert Juh&#233; Lluveras</a> · <a href=\"https://profiles.wordpress.org/alejandrogonzalvo/\">alejandrogonzalvo</a> · <a href=\"https://profiles.wordpress.org/alexcu21/\">Alex Cuadra</a> · <a href=\"https://profiles.wordpress.org/ajlende/\">Alex Lende</a> · <a href=\"https://profiles.wordpress.org/alexclassroom/\">Alex Lion (阿力獅)</a> · <a href=\"https://profiles.wordpress.org/alexstine/\">Alex Stine</a> · <a href=\"https://profiles.wordpress.org/alexandrebuffet/\">Alexandre Buffet</a> · <a href=\"https://profiles.wordpress.org/alexus450/\">Alexei Samarschi</a> · <a href=\"https://profiles.wordpress.org/alexius08/\">Alexis Pandaan</a> · <a href=\"https://profiles.wordpress.org/alordiel/\">alordiel</a> · <a href=\"https://profiles.wordpress.org/mrfoxtalbot/\">Alvaro G&#243;mez</a> · <a href=\"https://profiles.wordpress.org/alh0319/\">Amber Hinds</a> · <a href=\"https://profiles.wordpress.org/amin7/\">Amin</a> · <a href=\"https://profiles.wordpress.org/theaminuldev/\">Aminul Islam</a> · <a href=\"https://profiles.wordpress.org/aialvi/\">Aminul Islam Alvi</a> · <a href=\"https://profiles.wordpress.org/amitbhosale/\">Amit Bhosale</a> · <a href=\"https://profiles.wordpress.org/amykamala/\">Amy Kamala</a> · <a href=\"https://profiles.wordpress.org/anatolbroder/\">Anatol Broder</a> · <a href=\"https://profiles.wordpress.org/anlino/\">Anders Nor&#233;n</a> · <a href=\"https://profiles.wordpress.org/afercia/\">Andrea Fercia</a> · <a href=\"https://profiles.wordpress.org/awetz583/\">Andrea Roenning</a> · <a href=\"https://profiles.wordpress.org/andraganescu/\">Andrei Draganescu</a> · <a href=\"https://profiles.wordpress.org/andrewhoyer/\">Andrew Hoyer</a> · <a href=\"https://profiles.wordpress.org/nacin/\">Andrew Nacin</a> · <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a> · <a href=\"https://profiles.wordpress.org/andrewserong/\">Andrew Serong</a> · <a href=\"https://profiles.wordpress.org/oandregal/\">André Maneiro</a> · <a href=\"https://profiles.wordpress.org/afragen/\">Andy Fragen</a> · <a href=\"https://profiles.wordpress.org/mymothersdaughter/\">Anita C</a> · <a href=\"https://profiles.wordpress.org/ankit-k-gupta/\">Ankit K Gupta</a> · <a href=\"https://profiles.wordpress.org/ankitkumarshah/\">Ankit Kumar Shah</a> · <a href=\"https://profiles.wordpress.org/ankitmaru/\">Ankit Panchal</a> · <a href=\"https://profiles.wordpress.org/annezazu/\">Anne McCarthy</a> · <a href=\"https://profiles.wordpress.org/annebovelett/\">Anne-Mieke Bovelett</a> · <a href=\"https://profiles.wordpress.org/antonvlasenko/\">Anton Vlasenko</a> · <a href=\"https://profiles.wordpress.org/antoniosejas/\">Antonio Sejas</a> · <a href=\"https://profiles.wordpress.org/anujrathore24/\">Anuj Singh</a> · <a href=\"https://profiles.wordpress.org/anveshika/\">Anveshika Srivastava</a> · <a href=\"https://profiles.wordpress.org/apmeyer/\">apmeyer</a> · <a href=\"https://profiles.wordpress.org/aristath/\">Ari Stathopoulos</a> · <a href=\"https://profiles.wordpress.org/fliespl/\">Arkadiusz Rzadkowolski</a> · <a href=\"https://profiles.wordpress.org/armandovias/\">Armando</a> · <a href=\"https://profiles.wordpress.org/artemiosans/\">Artemio Morales</a> · <a href=\"https://profiles.wordpress.org/arthur791004/\">Arthur Chu</a> · <a href=\"https://profiles.wordpress.org/artpi/\">Artur Piszek</a> · <a href=\"https://profiles.wordpress.org/artz91/\">ArtZ91</a> · <a href=\"https://profiles.wordpress.org/asafm7/\">asafm7</a> · <a href=\"https://profiles.wordpress.org/asdofindia/\">asdofindia</a> · <a href=\"https://profiles.wordpress.org/ashfame/\">Ashish Kumar (Ashfame)</a> · <a href=\"https://profiles.wordpress.org/akashdev/\">Ashraful Haque Akash</a> · <a href=\"https://profiles.wordpress.org/askapache/\">askapache</a> · <a href=\"https://profiles.wordpress.org/aslamdoctor/\">Aslam Doctor</a> · <a href=\"https://profiles.wordpress.org/aurooba/\">Aurooba Ahmed</a> · <a href=\"https://profiles.wordpress.org/aut0poietic/\">aut0poietic</a> · <a href=\"https://profiles.wordpress.org/aksl95/\">Axel DUCORON</a> · <a href=\"https://profiles.wordpress.org/ayeshrajans/\">Ayesh Karunaratne</a> · <a href=\"https://profiles.wordpress.org/azharderaiya/\">Azhar Deraiya</a> · <a href=\"https://profiles.wordpress.org/beryldlg/\">B&#233;ryl de La Grandi&#232;re</a> · <a href=\"https://profiles.wordpress.org/bartnv/\">bartnv</a> · <a href=\"https://profiles.wordpress.org/bchecketts/\">bchecketts</a> · <a href=\"https://profiles.wordpress.org/beee/\">Beee</a> · <a href=\"https://profiles.wordpress.org/scruffian/\">Ben Dwyer</a> · <a href=\"https://profiles.wordpress.org/benazeer/\">Benazeer</a> · <a href=\"https://profiles.wordpress.org/rainbowgeek/\">Benjamin Denis</a> · <a href=\"https://profiles.wordpress.org/benjamin_zekavica/\">Benjamin Zekavica</a> · <a href=\"https://profiles.wordpress.org/bvl/\">Benny</a> · <a href=\"https://profiles.wordpress.org/benoitchantre/\">Benoit Chantre</a> · <a href=\"https://profiles.wordpress.org/kau-boy/\">Bernhard Kau</a> · <a href=\"https://profiles.wordpress.org/bernhard reiter/\">Bernhard Reiter</a> · <a href=\"https://profiles.wordpress.org/bernhard-reiter/\">Bernie Reiter</a> · <a href=\"https://profiles.wordpress.org/bgermann/\">bgermann</a> · <a href=\"https://profiles.wordpress.org/bhattaganesh/\">bhattaganesh</a> · <a href=\"https://profiles.wordpress.org/bhaveshdesai/\">Bhavesh Desai</a> · <a href=\"https://profiles.wordpress.org/bidbmak/\">BiDbMAK</a> · <a href=\"https://profiles.wordpress.org/mbigul/\">Bigul Malayi</a> · <a href=\"https://profiles.wordpress.org/birgire/\">Birgir Erlendsson (birgire)</a> · <a href=\"https://profiles.wordpress.org/bph/\">Birgit Pauli-Haack</a> · <a href=\"https://profiles.wordpress.org/rainynewt/\">Bishal Shrestha</a> · <a href=\"https://profiles.wordpress.org/bobbyleenoblestudios/\">bobbyleenoblestudios</a> · <a href=\"https://profiles.wordpress.org/bogdanungureanu/\">BogdanUngureanu</a> · <a href=\"https://profiles.wordpress.org/gitlost/\">bonger</a> · <a href=\"https://profiles.wordpress.org/bor0/\">Boro Sitnikovski</a> · <a href=\"https://profiles.wordpress.org/burlesonbrad/\">Brad Griffin</a> · <a href=\"https://profiles.wordpress.org/bradley2083/\">brad hogan</a> · <a href=\"https://profiles.wordpress.org/bjorsch/\">Brad Jorsch</a> · <a href=\"https://profiles.wordpress.org/bradshawtm/\">bradshawtm</a> · <a href=\"https://profiles.wordpress.org/bhubbard/\">Brandon Hubbard</a> · <a href=\"https://profiles.wordpress.org/kraftbj/\">Brandon Kraft</a> · <a href=\"https://profiles.wordpress.org/heybran/\">Brandon Zhang</a> · <a href=\"https://profiles.wordpress.org/bgoewert/\">Brennan Goewert</a> · <a href=\"https://profiles.wordpress.org/brhodes/\">brhodes</a> · <a href=\"https://profiles.wordpress.org/ironprogrammer/\">Brian Alexander</a> · <a href=\"https://profiles.wordpress.org/bacoords/\">Brian Coords</a> · <a href=\"https://profiles.wordpress.org/bgardner/\">Brian Gardner</a> · <a href=\"https://profiles.wordpress.org/masteradhoc/\">Brian Haas</a> · <a href=\"https://profiles.wordpress.org/brumack/\">brumack</a> · <a href=\"https://profiles.wordpress.org/bschneidewind/\">Bryan Schneidewind</a> · <a href=\"https://profiles.wordpress.org/bshuchter/\">bshuchter</a> · <a href=\"https://profiles.wordpress.org/burnuser/\">burnuser</a> · <a href=\"https://profiles.wordpress.org/byteninjaa0/\">byteninjaa0</a> · <a href=\"https://profiles.wordpress.org/cedche99/\">C&#233;dric Chevillard</a> · <a href=\"https://profiles.wordpress.org/callumbw95/\">Callum Bridgford-Whittick</a> · <a href=\"https://profiles.wordpress.org/snicco/\">Calvin Alkan</a> · <a href=\"https://profiles.wordpress.org/karl94/\">Carlo Cannas</a> · <a href=\"https://profiles.wordpress.org/cbravobernal/\">Carlos Bravo</a> · <a href=\"https://profiles.wordpress.org/carlosgprim/\">Carlos G. P.</a> · <a href=\"https://profiles.wordpress.org/carlsteffen/\">CarlSteffen</a> · <a href=\"https://profiles.wordpress.org/poena/\">Carolina Nymark</a> · <a href=\"https://profiles.wordpress.org/corazondejaguar/\">Carolina Romo</a> · <a href=\"https://profiles.wordpress.org/ciobanucatalin/\">Catalin Ciobanu</a> · <a href=\"https://profiles.wordpress.org/catgofire/\">catgofire</a> · <a href=\"https://profiles.wordpress.org/cbirdsong/\">cbirdsong</a> · <a href=\"https://profiles.wordpress.org/ccharel/\">ccharel</a> · <a href=\"https://profiles.wordpress.org/cbutlerjr/\">Chad Butler</a> · <a href=\"https://profiles.wordpress.org/shireling/\">Chad Chadbourne</a> · <a href=\"https://profiles.wordpress.org/cherrygot/\">Chakrapani Gautam</a> · <a href=\"https://profiles.wordpress.org/chihsuan/\">Chi-Hsuan Huang</a> · <a href=\"https://profiles.wordpress.org/chillifish/\">Chillifish</a> · <a href=\"https://profiles.wordpress.org/chloed/\">ChloeD</a> · <a href=\"https://profiles.wordpress.org/chouby/\">Chouby</a> · <a href=\"https://profiles.wordpress.org/czarate/\">Chris Zarate</a> · <a href=\"https://profiles.wordpress.org/chriscct7/\">chriscct7</a> · <a href=\"https://profiles.wordpress.org/chrisdotdotdot/\">chrisdotdotdot</a> · <a href=\"https://profiles.wordpress.org/chrismattix/\">chrismattix</a> · <a href=\"https://profiles.wordpress.org/christinecooper/\">christinecooper</a> · <a href=\"https://profiles.wordpress.org/apermo/\">Christoph Daum</a> · <a href=\"https://profiles.wordpress.org/nyiriland/\">Christy Nyiri</a> · <a href=\"https://profiles.wordpress.org/cikrimcin/\">cikrimcin</a> · <a href=\"https://profiles.wordpress.org/butterflymedia/\">Ciprian Popescu</a> · <a href=\"https://profiles.wordpress.org/chrisvendiadvertisingcom/\">cjhaas</a> · <a href=\"https://profiles.wordpress.org/ckoerner/\">ckoerner</a> · <a href=\"https://profiles.wordpress.org/claimableperch/\">claimableperch</a> · <a href=\"https://profiles.wordpress.org/codeamp/\">Code Amp</a> · <a href=\"https://profiles.wordpress.org/codebuddy/\">codebuddy</a> · <a href=\"https://profiles.wordpress.org/coleatkinson1/\">coleatkinson1</a> · <a href=\"https://profiles.wordpress.org/costdev/\">Colin Stewart</a> · <a href=\"https://profiles.wordpress.org/colind/\">ColinD</a> · <a href=\"https://profiles.wordpress.org/ogrecooper/\">Cooper Dalrymple</a> · <a href=\"https://profiles.wordpress.org/coralietixeront/\">Coralie Tixeront</a> · <a href=\"https://profiles.wordpress.org/salzano/\">Corey Salzano</a> · <a href=\"https://profiles.wordpress.org/coreyw/\">Corey Worrell</a> · <a href=\"https://profiles.wordpress.org/cornwell/\">Cornwell</a> · <a href=\"https://profiles.wordpress.org/cr0ybot/\">Cory Hughart</a> · <a href=\"https://profiles.wordpress.org/courane01/\">Courtney Robertson</a> · <a href=\"https://profiles.wordpress.org/cucocreative/\">cucocreative</a> · <a href=\"https://profiles.wordpress.org/cwhitmore/\">Cullen Whitmore</a> · <a href=\"https://profiles.wordpress.org/cyrille37/\">Cyrille37</a> · <a href=\"https://profiles.wordpress.org/daanvandenbergh/\">Daan van den Bergh</a> · <a href=\"https://profiles.wordpress.org/acketon/\">Dakota Chichester</a> · <a href=\"https://profiles.wordpress.org/damchtlv/\">damchtlv</a> · <a href=\"https://profiles.wordpress.org/damir-webthemer/\">Damir</a> · <a href=\"https://profiles.wordpress.org/colorful-tones/\">Damon Cook</a> · <a href=\"https://profiles.wordpress.org/dancameron/\">Dan Cameron</a> · <a href=\"https://profiles.wordpress.org/danielpw/\">Dan Waldschmidt</a> · <a href=\"https://profiles.wordpress.org/danielbachhuber/\">Daniel Bachhuber</a> · <a href=\"https://profiles.wordpress.org/danieliser/\">Daniel Iser</a> · <a href=\"https://profiles.wordpress.org/talldanwp/\">Daniel Richards</a> · <a href=\"https://profiles.wordpress.org/mte90/\">Daniele Scasciafratte</a> · <a href=\"https://profiles.wordpress.org/daniellacatus/\">daniellacatus</a> · <a href=\"https://profiles.wordpress.org/danielmorell/\">danielmorell</a> · <a href=\"https://profiles.wordpress.org/dscqbus/\">Danny Schmarsel</a> · <a href=\"https://profiles.wordpress.org/dannyreaktiv/\">dannyreaktiv</a> · <a href=\"https://profiles.wordpress.org/nerrad/\">Darren Ethier (nerrad)</a> · <a href=\"https://profiles.wordpress.org/darshitrajyaguru97/\">Darshit Rajyaguru</a> · <a href=\"https://profiles.wordpress.org/dryanpress/\">Dave Ryan</a> · <a href=\"https://profiles.wordpress.org/daveguitaruno/\">daveguitaruno</a> · <a href=\"https://profiles.wordpress.org/davilera/\">David Aguilera</a> · <a href=\"https://profiles.wordpress.org/darerodz/\">David Arenas</a> · <a href=\"https://profiles.wordpress.org/dartiss/\">David Artiss</a> · <a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a> · <a href=\"https://profiles.wordpress.org/dpcalhoun/\">David Calhoun</a> · <a href=\"https://profiles.wordpress.org/dlh/\">David Herrera</a> · <a href=\"https://profiles.wordpress.org/justlevine/\">David Levine</a> · <a href=\"https://profiles.wordpress.org/davidperez/\">David Perez</a> · <a href=\"https://profiles.wordpress.org/djivad/\">David Riviera</a> · <a href=\"https://profiles.wordpress.org/get_dave/\">David Smith</a> · <a href=\"https://profiles.wordpress.org/davidb/\">DavidB</a> · <a href=\"https://profiles.wordpress.org/dawidadach/\">dawidadach</a> · <a href=\"https://profiles.wordpress.org/dsas/\">Dean Sas</a> · <a href=\"https://profiles.wordpress.org/dkarfa/\">Debabrata Karfa</a> · <a href=\"https://profiles.wordpress.org/debarghyabanerjee/\">DEBARGHYA BANERJEE</a> · <a href=\"https://profiles.wordpress.org/denis-de-bernardy/\">Denis de Bernardy</a> · <a href=\"https://profiles.wordpress.org/dingo_d/\">Denis Žoljom</a> · <a href=\"https://profiles.wordpress.org/realloc/\">Dennis Ploetner</a> · <a href=\"https://profiles.wordpress.org/dmsnell/\">Dennis Snell</a> · <a href=\"https://profiles.wordpress.org/dennysdionigi/\">Dennys Dionigi</a> · <a href=\"https://profiles.wordpress.org/densinakum/\">Densi Nakum</a> · <a href=\"https://profiles.wordpress.org/derekherman/\">derekherman</a> · <a href=\"https://profiles.wordpress.org/devasheeshkaul/\">Devasheesh Kaul</a> · <a href=\"https://profiles.wordpress.org/dhananjaykuber/\">Dhananjay Kuber</a> · <a href=\"https://profiles.wordpress.org/dhrumilk/\">Dhrumil Kumbhani</a> · <a href=\"https://profiles.wordpress.org/dhruval04/\">Dhruval Shah</a> · <a href=\"https://profiles.wordpress.org/dhruvang21/\">Dhruvang21</a> · <a href=\"https://profiles.wordpress.org/dhruvik18/\">Dhruvik Malaviya</a> · <a href=\"https://profiles.wordpress.org/diebombe/\">diebombe</a> · <a href=\"https://profiles.wordpress.org/dilipbheda/\">Dilip Bheda</a> · <a href=\"https://profiles.wordpress.org/dilip2615/\">Dilip Modhavadiya</a> · <a href=\"https://profiles.wordpress.org/dd32/\">Dion Hulse</a> · <a href=\"https://profiles.wordpress.org/divinenephron/\">divinenephron</a> · <a href=\"https://profiles.wordpress.org/djcowan/\">dj.cowan</a> · <a href=\"https://profiles.wordpress.org/ocean90/\">Dominik Schilling</a> · <a href=\"https://profiles.wordpress.org/dominiquepijnenburg/\">dominiquepijnenburg</a> · <a href=\"https://profiles.wordpress.org/donalirl/\">donalirl</a> · <a href=\"https://profiles.wordpress.org/doughamlin/\">doughamlin</a> · <a href=\"https://profiles.wordpress.org/dougmelvin/\">DougMelvin</a> · <a href=\"https://profiles.wordpress.org/drawcard/\">drawcard</a> · <a href=\"https://profiles.wordpress.org/dretzlaff/\">dretzlaff</a> · <a href=\"https://profiles.wordpress.org/drewapicture/\">Drew Jaynes</a> · <a href=\"https://profiles.wordpress.org/drivingralle/\">Drivingralle</a> · <a href=\"https://profiles.wordpress.org/dsawyers/\">dsawyers</a> · <a href=\"https://profiles.wordpress.org/dustintechsmith/\">dustintechsmith</a> · <a href=\"https://profiles.wordpress.org/eclev91/\">eclev91</a> · <a href=\"https://profiles.wordpress.org/eduwass/\">eduwass</a> · <a href=\"https://profiles.wordpress.org/ehti/\">Ehti</a> · <a href=\"https://profiles.wordpress.org/elialum/\">elialum</a> · <a href=\"https://profiles.wordpress.org/eliezerspp/\">Eliezer Pe&#241;a</a> · <a href=\"https://profiles.wordpress.org/ellatrix/\">Ella van Durpe</a> · <a href=\"https://profiles.wordpress.org/elvismdev/\">Elvis Morales</a> · <a href=\"https://profiles.wordpress.org/emaildano/\">emaildano</a> · <a href=\"https://profiles.wordpress.org/codex-m/\">Emerson Maningo</a> · <a href=\"https://profiles.wordpress.org/emlebrun/\">Emilie LEBRUN</a> · <a href=\"https://profiles.wordpress.org/emranahmed/\">Emran Ahmed</a> · <a href=\"https://profiles.wordpress.org/enaanfarhan/\">Enaan Farhan</a> · <a href=\"https://profiles.wordpress.org/lopo/\">Enrico Battocchi</a> · <a href=\"https://profiles.wordpress.org/nrqsnchz/\">Enrique S&#225;nchez</a> · <a href=\"https://profiles.wordpress.org/epeicher/\">epeicher</a> · <a href=\"https://profiles.wordpress.org/ekazda/\">Eric</a> · <a href=\"https://profiles.wordpress.org/ericlewis/\">Eric Andrew Lewis</a> · <a href=\"https://profiles.wordpress.org/ethitter/\">Erick Hitter</a> · <a href=\"https://profiles.wordpress.org/kebbet/\">Erik</a> · <a href=\"https://profiles.wordpress.org/ejoling/\">Erik Joling</a> · <a href=\"https://profiles.wordpress.org/im3dabasia1/\">Eshaan Dabasiya</a> · <a href=\"https://profiles.wordpress.org/ethanscorey/\">ethanscorey</a> · <a href=\"https://profiles.wordpress.org/circlecube/\">Evan Mullins</a> · <a href=\"https://profiles.wordpress.org/etobiesen/\">Even Tobiesen</a> · <a href=\"https://profiles.wordpress.org/fabiankaegy/\">Fabian Kägy</a> · <a href=\"https://profiles.wordpress.org/gaambo/\">Fabian Todt</a> · <a href=\"https://profiles.wordpress.org/faisalahammad/\">Faisal Ahammad</a> · <a href=\"https://profiles.wordpress.org/faisal03/\">Faisal Alvi</a> · <a href=\"https://profiles.wordpress.org/fakhriaz/\">fakhriaz</a> · <a href=\"https://profiles.wordpress.org/falgunihdesai/\">Falguni Desai</a> · <a href=\"https://profiles.wordpress.org/flixos90/\">Felix Arntz</a> · <a href=\"https://profiles.wordpress.org/ffffelix/\">Felix Renicks</a> · <a href=\"https://profiles.wordpress.org/fellyph/\">Fellyph Cintra</a> · <a href=\"https://profiles.wordpress.org/mista-flo/\">Florian TIAR</a> · <a href=\"https://profiles.wordpress.org/frantorres/\">Francisco Torres</a> · <a href=\"https://profiles.wordpress.org/fcoveram/\">Francisco Vera</a> · <a href=\"https://profiles.wordpress.org/frogdesk/\">FrogDesk Strategy</a> · <a href=\"https://profiles.wordpress.org/takahashi_fumiki/\">Fumiki Takahashi</a> · <a href=\"https://profiles.wordpress.org/gaeldenysiak/\">Gael Denysiak</a> · <a href=\"https://profiles.wordpress.org/gajendrasingh/\">Gajendra Singh</a> · <a href=\"https://profiles.wordpress.org/ecgan/\">Gan Eng Chin</a> · <a href=\"https://profiles.wordpress.org/garrett-eclipse/\">Garrett Hyder</a> · <a href=\"https://profiles.wordpress.org/garyj/\">Gary Jones</a> · <a href=\"https://profiles.wordpress.org/pento/\">Gary Pendergast</a> · <a href=\"https://profiles.wordpress.org/guddu1315/\">Gaurang Dabhi</a> · <a href=\"https://profiles.wordpress.org/gautam23/\">Gautam Mehta</a> · <a href=\"https://profiles.wordpress.org/soulseekah/\">Gennady Kovshenin</a> · <a href=\"https://profiles.wordpress.org/mamaduka/\">George Mamadashvili</a> · <a href=\"https://profiles.wordpress.org/georgestephanis/\">George Stephanis</a> · <a href=\"https://profiles.wordpress.org/stoyanovgs/\">Georgi Stoyanov</a> · <a href=\"https://profiles.wordpress.org/gernberg/\">gernberg</a> · <a href=\"https://profiles.wordpress.org/giuliorubelli/\">giuliorubelli</a> · <a href=\"https://profiles.wordpress.org/glendaviesnz/\">Glen Davies</a> · <a href=\"https://profiles.wordpress.org/ingeniumed/\">Gopal Krishnan</a> · <a href=\"https://profiles.wordpress.org/grantmkin/\">Grant M. Kinney</a> · <a href=\"https://profiles.wordpress.org/gziolo/\">Greg Ziółkowski</a> · <a href=\"https://profiles.wordpress.org/guido07111975/\">Guido</a> · <a href=\"https://profiles.wordpress.org/wido/\">Guido Scialfa</a> · <a href=\"https://profiles.wordpress.org/guillaumeturpin/\">Guillaume TURPIN</a> · <a href=\"https://profiles.wordpress.org/gulamdastgir04/\">Gulamdastgir Momin</a> · <a href=\"https://profiles.wordpress.org/adrock42/\">H. Adam Lenz</a> · <a href=\"https://profiles.wordpress.org/kabir93/\">H. Kabir</a> · <a href=\"https://profiles.wordpress.org/hanimbarek/\">hanimbarek</a> · <a href=\"https://profiles.wordpress.org/hanneslsm/\">hanneslsm</a> · <a href=\"https://profiles.wordpress.org/hage/\">Hans-Gerd Gerhards</a> · <a href=\"https://profiles.wordpress.org/hardik2221/\">Hardik Raval</a> · <a href=\"https://profiles.wordpress.org/hareesh-pillai/\">Hareesh S</a> · <a href=\"https://profiles.wordpress.org/harshgajipara/\">Harsh Gajipara</a> · <a href=\"https://profiles.wordpress.org/harshalkadu/\">Harshal Kadu</a> · <a href=\"https://profiles.wordpress.org/harshbhonsle08/\">harshbhonsle08</a> · <a href=\"https://profiles.wordpress.org/harshdeepgill/\">harshdeepgill</a> · <a href=\"https://profiles.wordpress.org/haruncpi/\">Harun</a> · <a href=\"https://profiles.wordpress.org/helen/\">Helen Hou-Sandi</a> · <a href=\"https://profiles.wordpress.org/helgatheviking/\">HelgaTheViking</a> · <a href=\"https://profiles.wordpress.org/hideishi/\">Hidenori ISHIKAWA</a> · <a href=\"https://profiles.wordpress.org/hilayt24/\">Hilay Trivedi</a> · <a href=\"https://profiles.wordpress.org/panchalhimani711/\">Himani Panchal</a> · <a href=\"https://profiles.wordpress.org/abcd95/\">Himanshu Pathak</a> · <a href=\"https://profiles.wordpress.org/hiroshisato/\">Hiroshi Sato</a> · <a href=\"https://profiles.wordpress.org/hbhalodia/\">Hit Bhalodia</a> · <a href=\"https://profiles.wordpress.org/hitendra-chopda/\">Hitendra Chopda</a> · <a href=\"https://profiles.wordpress.org/hiteshtalpada/\">Hitesh Talpada</a> · <a href=\"https://profiles.wordpress.org/hozefasmile/\">Hozefa Saleh</a> · <a href=\"https://profiles.wordpress.org/hrohh/\">Hrohh</a> · <a href=\"https://profiles.wordpress.org/hugod/\">hugod</a> · <a href=\"https://profiles.wordpress.org/hugosolar/\">hugosolar</a> · <a href=\"https://profiles.wordpress.org/humanify/\">humanify</a> · <a href=\"https://profiles.wordpress.org/huubl/\">huubl</a> · <a href=\"https://profiles.wordpress.org/huzaifaalmesbah/\">Huzaifa Al Mesbah</a> · <a href=\"https://profiles.wordpress.org/priethor/\">Héctor Prieto</a> · <a href=\"https://profiles.wordpress.org/iandunn/\">Ian Dunn</a> · <a href=\"https://profiles.wordpress.org/ignatiusjeroe/\">ignatiusjeroe</a> · <a href=\"https://profiles.wordpress.org/igorradovanov/\">Igor Radovanov</a> · <a href=\"https://profiles.wordpress.org/ikriv/\">ikriv</a> · <a href=\"https://profiles.wordpress.org/imokweb/\">imokweb</a> · <a href=\"https://profiles.wordpress.org/imranhasanraaz/\">Imran</a> · <a href=\"https://profiles.wordpress.org/indirabiswas27/\">Indira Biswas</a> · <a href=\"https://profiles.wordpress.org/ipstenu/\">Ipstenu (Mika Epstein)</a> · <a href=\"https://profiles.wordpress.org/iqbal1hossain/\">Iqbal Hossain</a> · <a href=\"https://profiles.wordpress.org/isabel_brison/\">Isabel Brison</a> · <a href=\"https://profiles.wordpress.org/ishikaatxecurify/\">Ishika Bansal</a> · <a href=\"https://profiles.wordpress.org/ivanottinger/\">Ivan Ottinger</a> · <a href=\"https://profiles.wordpress.org/jabe/\">Jabe</a> · <a href=\"https://profiles.wordpress.org/jacobcassidy/\">Jacob Cassidy</a> · <a href=\"https://profiles.wordpress.org/jagirbahesh/\">Jagir Bahesh</a> · <a href=\"https://profiles.wordpress.org/jaiminp/\">Jaimin Prajapati</a> · <a href=\"https://profiles.wordpress.org/jakariaistauk/\">Jakaria Istauk</a> · <a href=\"https://profiles.wordpress.org/whyisjake/\">Jake Spurlock</a> · <a href=\"https://profiles.wordpress.org/jakeparis/\">jakeparis</a> · <a href=\"https://profiles.wordpress.org/jameskoster/\">James Koster</a> · <a href=\"https://profiles.wordpress.org/isotropic/\">James LePage</a> · <a href=\"https://profiles.wordpress.org/jhmonroe/\">James Monroe</a> · <a href=\"https://profiles.wordpress.org/q0rban/\">James Sansbury</a> · <a href=\"https://profiles.wordpress.org/jamestitus299/\">James Titus</a> · <a href=\"https://profiles.wordpress.org/codente/\">Jamie</a> · <a href=\"https://profiles.wordpress.org/jamieburchell/\">Jamie Burchell</a> · <a href=\"https://profiles.wordpress.org/jamesmarsland/\">Jamie Marsland</a> · <a href=\"https://profiles.wordpress.org/janthiel/\">janthiel</a> · <a href=\"https://profiles.wordpress.org/jsnajdr/\">Jarda Snajdr</a> · <a href=\"https://profiles.wordpress.org/jarekmorawski/\">jarekmorawski</a> · <a href=\"https://profiles.wordpress.org/jasalt/\">Jarkko Saltiola</a> · <a href=\"https://profiles.wordpress.org/jason_the_adams/\">Jason Adams</a> · <a href=\"https://profiles.wordpress.org/madtownlems/\">Jason LeMahieu (MadtownLems)</a> · <a href=\"https://profiles.wordpress.org/jasonsa19/\">Jason Sauerwald</a> · <a href=\"https://profiles.wordpress.org/javiercasares/\">Javier Casares</a> · <a href=\"https://profiles.wordpress.org/jonmcpartland/\">Jay McPartland</a> · <a href=\"https://profiles.wordpress.org/shovan_jaya/\">Jayaram</a> · <a href=\"https://profiles.wordpress.org/jdahir0789/\">Jaydip</a> · <a href=\"https://profiles.wordpress.org/audrasjb/\">Jean-Baptiste Audras</a> · <a href=\"https://profiles.wordpress.org/krokodok/\">Jeff Chi</a> · <a href=\"https://profiles.wordpress.org/jeffmatson/\">Jeff Matson</a> · <a href=\"https://profiles.wordpress.org/jffng/\">Jeff Ong</a> · <a href=\"https://profiles.wordpress.org/jeffpaul/\">Jeff Paul</a> · <a href=\"https://profiles.wordpress.org/cheffheid/\">Jeffrey de Wit</a> · <a href=\"https://profiles.wordpress.org/jeffr0/\">Jeffro</a> · <a href=\"https://profiles.wordpress.org/jeflopodev/\">jeflopo</a> · <a href=\"https://profiles.wordpress.org/jdy68/\">Jenny Dupuy</a> · <a href=\"https://profiles.wordpress.org/jeremiahbratton/\">Jeremiah Bratton</a> · <a href=\"https://profiles.wordpress.org/jeremyfelt/\">Jeremy Felt</a> · <a href=\"https://profiles.wordpress.org/jkmassel/\">Jeremy Massel</a> · <a href=\"https://profiles.wordpress.org/slimndap/\">Jeroen Schmit</a> · <a href=\"https://profiles.wordpress.org/jeryj/\">jeryj</a> · <a href=\"https://profiles.wordpress.org/jesin/\">Jesin A</a> · <a href=\"https://profiles.wordpress.org/jessedyck/\">jessedyck</a> · <a href=\"https://profiles.wordpress.org/luminuu/\">Jessica Lyschik</a> · <a href=\"https://profiles.wordpress.org/jigar-bhanushali/\">Jigar Bhanushali</a> · <a href=\"https://profiles.wordpress.org/jigar9998/\">Jigar Panchal</a> · <a href=\"https://profiles.wordpress.org/jikamens/\">jikamens</a> · <a href=\"https://profiles.wordpress.org/jnweaver/\">jnweaver</a> · <a href=\"https://profiles.wordpress.org/jojo256/\">Joan Namunina</a> · <a href=\"https://profiles.wordpress.org/jobata/\">JoAnne Obata</a> · <a href=\"https://profiles.wordpress.org/jochent/\">JochenT</a> · <a href=\"https://profiles.wordpress.org/jodamo5/\">jodamo5</a> · <a href=\"https://profiles.wordpress.org/joedolson/\">Joe Dolson</a> · <a href=\"https://profiles.wordpress.org/joehoyle/\">Joe Hoyle</a> · <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a> · <a href=\"https://profiles.wordpress.org/joen/\">Joen Asmussen</a> · <a href=\"https://profiles.wordpress.org/timse201/\">Johannes J&#252;lg</a> · <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a> · <a href=\"https://profiles.wordpress.org/brandbrilliance/\">John Brand</a> · <a href=\"https://profiles.wordpress.org/johnny5/\">John Godley</a> · <a href=\"https://profiles.wordpress.org/johnjamesjacoby/\">John James Jacoby</a> · <a href=\"https://profiles.wordpress.org/mindctrl/\">John Parris</a> · <a href=\"https://profiles.wordpress.org/johnregan3/\">John Regan</a> · <a href=\"https://profiles.wordpress.org/johnvieth/\">JohnVieth</a> · <a href=\"https://profiles.wordpress.org/jonsurrell/\">Jon Surrell</a> · <a href=\"https://profiles.wordpress.org/psykro/\">Jonathan Bossenger</a> · <a href=\"https://profiles.wordpress.org/jrchamp/\">Jonathan Champ</a> · <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a> · <a href=\"https://profiles.wordpress.org/n2erjo00/\">Joni Erkkil&#228;</a> · <a href=\"https://profiles.wordpress.org/spacedmonkey/\">Jonny Harris</a> · <a href=\"https://profiles.wordpress.org/jonoaldersonwp/\">Jono Alderson</a> · <a href=\"https://profiles.wordpress.org/jordesign/\">jordesign</a> · <a href=\"https://profiles.wordpress.org/jorgefilipecosta/\">Jorge Costa</a> · <a href=\"https://profiles.wordpress.org/josvelasco/\">Jos Velasco</a> · <a href=\"https://profiles.wordpress.org/josephscott/\">Joseph Scott</a> · <a href=\"https://profiles.wordpress.org/jhabdas/\">Josh Habdas</a> · <a href=\"https://profiles.wordpress.org/verygoode/\">Joshua Goode</a> · <a href=\"https://profiles.wordpress.org/jrmd/\">jrmd</a> · <a href=\"https://profiles.wordpress.org/juanfra/\">Juan Aldasoro</a> · <a href=\"https://profiles.wordpress.org/juampick/\">Juan Cook</a> · <a href=\"https://profiles.wordpress.org/juanmaguitar/\">JuanMa Garrido</a> · <a href=\"https://profiles.wordpress.org/juliengardair/\">juliengardair</a> · <a href=\"https://profiles.wordpress.org/jrf/\">Juliette Reinders Folmer</a> · <a href=\"https://profiles.wordpress.org/justinahinon/\">Justin Ahinon</a> · <a href=\"https://profiles.wordpress.org/greenshady/\">Justin Tadlock</a> · <a href=\"https://profiles.wordpress.org/itsroy69/\">Jyotirmoy Roy</a> · <a href=\"https://profiles.wordpress.org/kadamwhite/\">K. Adam White</a> · <a href=\"https://profiles.wordpress.org/kevin940726/\">Kai Hao</a> · <a href=\"https://profiles.wordpress.org/trepmal/\">Kailey (trepmal)</a> · <a href=\"https://profiles.wordpress.org/kaitohm/\">Kaito Hanamori</a> · <a href=\"https://profiles.wordpress.org/kakomap/\">Kakoma</a> · <a href=\"https://profiles.wordpress.org/kalpeshh/\">Kalpesh</a> · <a href=\"https://profiles.wordpress.org/karinchristen/\">Karin Christen</a> · <a href=\"https://profiles.wordpress.org/karolmanijak/\">Karol Manijak</a> · <a href=\"https://profiles.wordpress.org/karthickmurugan/\">Karthick Murugan</a> · <a href=\"https://profiles.wordpress.org/karthikeya01/\">Karthikeya Bethu</a> · <a href=\"https://profiles.wordpress.org/kasparsd/\">Kaspars</a> · <a href=\"https://profiles.wordpress.org/codebykat/\">Kat Hagan</a> · <a href=\"https://profiles.wordpress.org/katinthehatsite/\">Kateryna K. a11n</a> · <a href=\"https://profiles.wordpress.org/zoonini/\">Kathryn Presner</a> · <a href=\"https://profiles.wordpress.org/katrinadtl/\">Katrina Massey</a> · <a href=\"https://profiles.wordpress.org/kausaralm/\">Kausar Alam</a> · <a href=\"https://profiles.wordpress.org/khushdoms/\">Kaushik Domadiya</a> · <a href=\"https://profiles.wordpress.org/onlykawshar/\">Kawshar Ahmed</a> · <a href=\"https://profiles.wordpress.org/kaygee79/\">kaygee79</a> · <a href=\"https://profiles.wordpress.org/mt8biz/\">Kazuto Takeshita</a> · <a href=\"https://profiles.wordpress.org/ryelle/\">Kelly Choyce-Dwan</a> · <a href=\"https://profiles.wordpress.org/kellychoffman/\">Kelly Hoffman</a> · <a href=\"https://profiles.wordpress.org/tinypixel/\">Kelly Mears</a> · <a href=\"https://profiles.wordpress.org/kgagne/\">Ken Gagne</a> · <a href=\"https://profiles.wordpress.org/kerfred/\">Kerfred</a> · <a href=\"https://profiles.wordpress.org/gwwar/\">Kerry Liu</a> · <a href=\"https://profiles.wordpress.org/kesselb/\">kesselb</a> · <a href=\"https://profiles.wordpress.org/kevinlearynet/\">Kevin Leary</a> · <a href=\"https://profiles.wordpress.org/khoipro/\">Khoi Pro</a> · <a href=\"https://profiles.wordpress.org/khushipatel15/\">Khushi Patel</a> · <a href=\"https://profiles.wordpress.org/killerbishop/\">killerbishop</a> · <a href=\"https://profiles.wordpress.org/iamkingsleyf/\">Kingsley Felix</a> · <a href=\"https://profiles.wordpress.org/kirasong/\">Kira Schroder</a> · <a href=\"https://profiles.wordpress.org/kishanjasani/\">Kishan Jasani</a> · <a href=\"https://profiles.wordpress.org/kitchin/\">kitchin</a> · <a href=\"https://profiles.wordpress.org/kjellr/\">Kjell Reigstad</a> · <a href=\"https://profiles.wordpress.org/kkmuffme/\">kkmuffme</a> · <a href=\"https://profiles.wordpress.org/kleor/\">Kleor</a> · <a href=\"https://profiles.wordpress.org/knutsp/\">Knut Sparhell</a> · <a href=\"https://profiles.wordpress.org/obenland/\">Konstantin Obenland</a> · <a href=\"https://profiles.wordpress.org/xkon/\">Konstantinos Xenos</a> · <a href=\"https://profiles.wordpress.org/kpapazov/\">kpapazov</a> · <a href=\"https://profiles.wordpress.org/kprocyszyn/\">kprocyszyn</a> · <a href=\"https://profiles.wordpress.org/krishaamer/\">krishaamer</a> · <a href=\"https://profiles.wordpress.org/krunal265/\">Krunal Bhimajiyani</a> · <a href=\"https://profiles.wordpress.org/krupajnanda/\">Krupa Nanda</a> · <a href=\"https://profiles.wordpress.org/kshaner/\">kshaner</a> · <a href=\"https://profiles.wordpress.org/kub1x/\">kub1x</a> · <a href=\"https://profiles.wordpress.org/kubiq/\">kubiq</a> · <a href=\"https://profiles.wordpress.org/kunalpuri123/\">kunalpuri123</a> · <a href=\"https://profiles.wordpress.org/kushsharma/\">Kush Sharma</a> · <a href=\"https://profiles.wordpress.org/kush123/\">Kushagra Goyal</a> · <a href=\"https://profiles.wordpress.org/lgadzhev/\">Lachezar Gadzhev</a> · <a href=\"https://profiles.wordpress.org/lakrisgubben/\">lakrisgubben</a> · <a href=\"https://profiles.wordpress.org/lakshyajeet/\">Lakshyajeet Singh Goyal</a> · <a href=\"https://profiles.wordpress.org/lalitkumawat/\">Lalit Kumawat</a> · <a href=\"https://profiles.wordpress.org/lancewillett/\">Lance Willett</a> · <a href=\"https://profiles.wordpress.org/newyorkerlaura/\">Laura Byrne</a> · <a href=\"https://profiles.wordpress.org/laurisaarni/\">Lauri Saarni</a> · <a href=\"https://profiles.wordpress.org/ldanielgiuliani/\">ldanielgiuliani</a> · <a href=\"https://profiles.wordpress.org/leewillis77/\">Lee Willis</a> · <a href=\"https://profiles.wordpress.org/leedxw/\">leedxw</a> · <a href=\"https://profiles.wordpress.org/leemon/\">leemon</a> · <a href=\"https://profiles.wordpress.org/0mirka00/\">Lena Morita</a> · <a href=\"https://profiles.wordpress.org/leonidasmilossis/\">Leonidas Milosis</a> · <a href=\"https://profiles.wordpress.org/levinbaria/\">Levin Baria</a> · <a href=\"https://profiles.wordpress.org/lgseo/\">lgseo</a> · <a href=\"https://profiles.wordpress.org/lilgames/\">LilGames</a> · <a href=\"https://profiles.wordpress.org/liviopv/\">liviopv</a> · <a href=\"https://profiles.wordpress.org/logiclink/\">logiclink</a> · <a href=\"https://profiles.wordpress.org/logicrays/\">LogicRays Technologies</a> · <a href=\"https://profiles.wordpress.org/lordandy1984/\">lordandy1984</a> · <a href=\"https://profiles.wordpress.org/lovor/\">Lovro Hrust</a> · <a href=\"https://profiles.wordpress.org/lucasms/\">Lucas Martins</a> · <a href=\"https://profiles.wordpress.org/gigitux/\">Luigi Teschio</a> · <a href=\"https://profiles.wordpress.org/luisherranz/\">luisherranz</a> · <a href=\"https://profiles.wordpress.org/lukasfritzedev/\">LukasFritzeDev</a> · <a href=\"https://profiles.wordpress.org/wpfed/\">Lukasz</a> · <a href=\"https://profiles.wordpress.org/lukecavanagh/\">Luke Cavanagh</a> · <a href=\"https://profiles.wordpress.org/maccyd/\">maccyd</a> · <a href=\"https://profiles.wordpress.org/madhavishah01/\">Madhavi Shah</a> · <a href=\"https://profiles.wordpress.org/madhudollu/\">Madhu Dollu</a> · <a href=\"https://profiles.wordpress.org/onemaggie/\">Maggie Cabrera</a> · <a href=\"https://profiles.wordpress.org/maikuolan/\">Maikuolan</a> · <a href=\"https://profiles.wordpress.org/manfcarlo/\">manfcarlo</a> · <a href=\"https://profiles.wordpress.org/manhatthien98/\">manhatthien98</a> · <a href=\"https://profiles.wordpress.org/sirlouen/\">Manuel Camargo</a> · <a href=\"https://profiles.wordpress.org/manzoorwanijk/\">Manzoor Wani</a> · <a href=\"https://profiles.wordpress.org/maorb/\">maorb</a> · <a href=\"https://profiles.wordpress.org/mdxfr/\">Marc</a> · <a href=\"https://profiles.wordpress.org/marc4/\">Marc Armengou</a> · <a href=\"https://profiles.wordpress.org/pagelab/\">Marcio Duarte</a> · <a href=\"https://profiles.wordpress.org/mciampini/\">Marco Ciampini</a> · <a href=\"https://profiles.wordpress.org/leadclown/\">Marcus</a> · <a href=\"https://profiles.wordpress.org/mkaz/\">Marcus Kazmierczak</a> · <a href=\"https://profiles.wordpress.org/marian1/\">marian1</a> · <a href=\"https://profiles.wordpress.org/plari/\">Marie</a> · <a href=\"https://profiles.wordpress.org/tyxla/\">Marin Atanasov</a> · <a href=\"https://profiles.wordpress.org/santosguillamot/\">Mario Santos</a> · <a href=\"https://profiles.wordpress.org/mariohamann/\">mariohamann</a> · <a href=\"https://profiles.wordpress.org/marius84/\">mariushosting</a> · <a href=\"https://profiles.wordpress.org/bozzmedia/\">Marty</a> · <a href=\"https://profiles.wordpress.org/martythornley/\">MartyThornley</a> · <a href=\"https://profiles.wordpress.org/marybaum/\">Mary Baum</a> · <a href=\"https://profiles.wordpress.org/4thhubbard/\">Mary Hubbard</a> · <a href=\"https://profiles.wordpress.org/mat-lipe/\">Mat Lipe</a> · <a href=\"https://profiles.wordpress.org/mathiscode/\">mathiscode</a> · <a href=\"https://profiles.wordpress.org/mmaattiiaass/\">Matias Benedetto</a> · <a href=\"https://profiles.wordpress.org/matveb/\">Matias Ventura</a> · <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a> · <a href=\"https://profiles.wordpress.org/mattyrob/\">Matt Robinson</a> · <a href=\"https://profiles.wordpress.org/mattwest/\">Matt West</a> · <a href=\"https://profiles.wordpress.org/matteoenna/\">Matteo Enna</a> · <a href=\"https://profiles.wordpress.org/pfefferle/\">Matthias Pfefferle</a> · <a href=\"https://profiles.wordpress.org/mattryanwalker/\">mattryanwalker</a> · <a href=\"https://profiles.wordpress.org/maxschmeling/\">Max Schmeling</a> · <a href=\"https://profiles.wordpress.org/maxpertici/\">Maxime Pertici</a> · <a href=\"https://profiles.wordpress.org/mayanktripathi32/\">Mayank Tripathi</a> · <a href=\"https://profiles.wordpress.org/mayur8991/\">Mayur Prajapati</a> · <a href=\"https://profiles.wordpress.org/faithcoder/\">Md Abdullah Al Arif</a> · <a href=\"https://profiles.wordpress.org/mabfahad/\">Md Abdullah Al Fahad</a> · <a href=\"https://profiles.wordpress.org/hmbashar/\">Md Abul Bashar</a> · <a href=\"https://profiles.wordpress.org/ismail0071/\">MD ISMAIL</a> · <a href=\"https://profiles.wordpress.org/kawsar007/\">MD Kawsar Chowdhury</a> · <a href=\"https://profiles.wordpress.org/masummollaalhaz/\">Md Masum Molla Alhaz</a> · <a href=\"https://profiles.wordpress.org/obiplabon/\">Md Obidullah (obiPlabon)</a> · <a href=\"https://profiles.wordpress.org/wprashed/\">Md Rashed Hossain</a> · <a href=\"https://profiles.wordpress.org/sabbir20/\">Md Sabbir Hossain</a> · <a href=\"https://profiles.wordpress.org/najmulsaju/\">Md. Najmul Islam</a> · <a href=\"https://profiles.wordpress.org/mehedi_csit/\">Md.Mehedi Hasan</a> · <a href=\"https://profiles.wordpress.org/mdmoreau/\">mdmoreau</a> · <a href=\"https://profiles.wordpress.org/mdviralsampat/\">mdviralsampat</a> · <a href=\"https://profiles.wordpress.org/immeet94/\">Meet Makadia</a> · <a href=\"https://profiles.wordpress.org/megane9988/\">megane9988</a> · <a href=\"https://profiles.wordpress.org/meher/\">Meher Bala</a> · <a href=\"https://profiles.wordpress.org/melchoyce/\">Mel Choyce-Dwan</a> · <a href=\"https://profiles.wordpress.org/mfgmicha/\">Micha Krapp</a> · <a href=\"https://profiles.wordpress.org/mburridge/\">Michael Burridge</a> · <a href=\"https://profiles.wordpress.org/michaelkeck/\">Michael Keck</a> · <a href=\"https://profiles.wordpress.org/mnelson4/\">Michael Nelson</a> · <a href=\"https://profiles.wordpress.org/xmic/\">Michael Sumner</a> · <a href=\"https://profiles.wordpress.org/michaelreetz/\">michaelreetz</a> · <a href=\"https://profiles.wordpress.org/czapla/\">Michal Czaplinski</a> · <a href=\"https://profiles.wordpress.org/marktimemedia/\">Michelle Schulp Hunt</a> · <a href=\"https://profiles.wordpress.org/mcsf/\">Miguel Fonseca</a> · <a href=\"https://profiles.wordpress.org/migueluy/\">Miguel Lezama</a> · <a href=\"https://profiles.wordpress.org/simison/\">Mikael Korpela</a> · <a href=\"https://profiles.wordpress.org/mobius5150/\">Mike</a> · <a href=\"https://profiles.wordpress.org/mikefitzman/\">Mike Fitzpatrick</a> · <a href=\"https://profiles.wordpress.org/mikehansenme/\">Mike Hansen</a> · <a href=\"https://profiles.wordpress.org/mikejolley/\">Mike Jolley</a> · <a href=\"https://profiles.wordpress.org/mmcalister/\">Mike McAlister</a> · <a href=\"https://profiles.wordpress.org/ritterml/\">Mike Ritter</a> · <a href=\"https://profiles.wordpress.org/mikinc860/\">Mikin Chauhan</a> · <a href=\"https://profiles.wordpress.org/firestar300/\">Milan Ricoul</a> · <a href=\"https://profiles.wordpress.org/multidots1896/\">Minal Diwan</a> · <a href=\"https://profiles.wordpress.org/369work/\">Miroku</a> · <a href=\"https://profiles.wordpress.org/missveronicatv/\">missveronica</a> · <a href=\"https://profiles.wordpress.org/presstoke/\">Mitchell Austin</a> · <a href=\"https://profiles.wordpress.org/mkeck/\">mkeck</a> · <a href=\"https://profiles.wordpress.org/mlaetitia1986/\">mlaetitia1986</a> · <a href=\"https://profiles.wordpress.org/mleray/\">mleray</a> · <a href=\"https://profiles.wordpress.org/mleraygp/\">mleraygp</a> · <a href=\"https://profiles.wordpress.org/mobarak/\">Mobarak Ali</a> · <a href=\"https://profiles.wordpress.org/opurockey/\">Mohammad Rockeybul Alam</a> · <a href=\"https://profiles.wordpress.org/mohkatz/\">Mohammed Kateregga</a> · <a href=\"https://profiles.wordpress.org/mosescursor/\">Moses Cursor Ssebunya</a> · <a href=\"https://profiles.wordpress.org/mrwweb/\">mrwweb</a> · <a href=\"https://profiles.wordpress.org/mtg169/\">mtg169</a> · <a href=\"https://profiles.wordpress.org/mujuonly/\">mujuonly</a> · <a href=\"https://profiles.wordpress.org/mukesh27/\">Mukesh Panchal</a> · <a href=\"https://profiles.wordpress.org/mukulsingh27/\">Mukul Singh</a> · <a href=\"https://profiles.wordpress.org/faguni22/\">Mumtahina Faguni</a> · <a href=\"https://profiles.wordpress.org/sedmikrasky/\">N&#250;ria Nadal i Rovira</a> · <a href=\"https://profiles.wordpress.org/vyasnaman/\">Naman Vyas</a> · <a href=\"https://profiles.wordpress.org/nanisamireddy/\">NANI SAMIREDDY</a> · <a href=\"https://profiles.wordpress.org/narenin/\">Narendra Sishodiya</a> · <a href=\"https://profiles.wordpress.org/nareshbheda/\">Naresh Bheda</a> · <a href=\"https://profiles.wordpress.org/muddassirnasim/\">Nasim Miah</a> · <a href=\"https://profiles.wordpress.org/n8finch/\">Nate Finch</a> · <a href=\"https://profiles.wordpress.org/naveendwivedi/\">Naveen Dwivedi</a> · <a href=\"https://profiles.wordpress.org/navi161/\">Navneet Kaur</a> · <a href=\"https://profiles.wordpress.org/bugnumber9/\">Nazar Hotsa</a> · <a href=\"https://profiles.wordpress.org/nazmul111/\">Nazmul Hosen</a> · <a href=\"https://profiles.wordpress.org/greatislander/\">Ned Zimmerman</a> · <a href=\"https://profiles.wordpress.org/nexbridge/\">nexbridge</a> · <a href=\"https://profiles.wordpress.org/nextendweb/\">Nextendweb</a> · <a href=\"https://profiles.wordpress.org/neychok/\">Neycho Kalaydzhiev</a> · <a href=\"https://profiles.wordpress.org/nickchomey/\">Nick</a> · <a href=\"https://profiles.wordpress.org/nickstarkloff/\">Nick</a> · <a href=\"https://profiles.wordpress.org/ndiego/\">Nick Diego</a> · <a href=\"https://profiles.wordpress.org/celloexpressions/\">Nick Halsey</a> · <a href=\"https://profiles.wordpress.org/nickbrazilian/\">nickbrazilian</a> · <a href=\"https://profiles.wordpress.org/nickjbedford/\">nickjbedford</a> · <a href=\"https://profiles.wordpress.org/nickpagz/\">nickpagz</a> · <a href=\"https://profiles.wordpress.org/nickwilmot/\">nickwilmot</a> · <a href=\"https://profiles.wordpress.org/nico23/\">Nico</a> · <a href=\"https://profiles.wordpress.org/nidhidhandhukiya/\">nidhidhandhukiya</a> · <a href=\"https://profiles.wordpress.org/nielslange/\">Niels Lange</a> · <a href=\"https://profiles.wordpress.org/nigelnelles/\">nigelnelles</a> · <a href=\"https://profiles.wordpress.org/ntsekouras/\">Nik Tsekouras</a> · <a href=\"https://profiles.wordpress.org/smushytaco/\">Nikan Radan</a> · <a href=\"https://profiles.wordpress.org/nikunj8866/\">Nikunj Hatkar</a> · <a href=\"https://profiles.wordpress.org/nimeshatxecurify/\">Nimesh</a> · <a href=\"https://profiles.wordpress.org/ninomiho/\">Nino Mihovilic</a> · <a href=\"https://profiles.wordpress.org/ninos-ego/\">Ninos</a> · <a href=\"https://profiles.wordpress.org/noahtallen/\">Noah Allen</a> · <a href=\"https://profiles.wordpress.org/othernoel/\">Noel Santos</a> · <a href=\"https://profiles.wordpress.org/noruzzaman/\">Noruzzaman</a> · <a href=\"https://profiles.wordpress.org/nosilver4u/\">nosilver4u</a> · <a href=\"https://profiles.wordpress.org/oceantober/\">oceantober</a> · <a href=\"https://profiles.wordpress.org/oferlaor/\">oferlaor</a> · <a href=\"https://profiles.wordpress.org/okat/\">okat</a> · <a href=\"https://profiles.wordpress.org/yasunocco/\">Okawa Yasuno</a> · <a href=\"https://profiles.wordpress.org/oglekler/\">Olga Gleckler</a> · <a href=\"https://profiles.wordpress.org/domainsupport/\">Oliver Campion</a> · <a href=\"https://profiles.wordpress.org/alshakero/\">Omar Alshaker</a> · <a href=\"https://profiles.wordpress.org/gabertronic/\">Ophelia Rose</a> · <a href=\"https://profiles.wordpress.org/optimizingmatters/\">Optimizing Matters</a> · <a href=\"https://profiles.wordpress.org/owi/\">owi</a> · <a href=\"https://profiles.wordpress.org/paaljoachim/\">Paal Joachim Romdahl</a> · <a href=\"https://profiles.wordpress.org/pablohoneyhoney/\">Pablo Honey</a> · <a href=\"https://profiles.wordpress.org/palak678/\">Palak Patel</a> · <a href=\"https://profiles.wordpress.org/paragoninitiativeenterprises/\">Paragon Initiative Enterprises</a> · <a href=\"https://profiles.wordpress.org/parinpanjari/\">Parin Panjari</a> · <a href=\"https://profiles.wordpress.org/parthvataliya/\">Parth vataliya</a> · <a href=\"https://profiles.wordpress.org/techpartho/\">Partho Hore</a> · <a href=\"https://profiles.wordpress.org/swissspidy/\">Pascal Birchler</a> · <a href=\"https://profiles.wordpress.org/pateljaymin/\">Patel Jaymin</a> · <a href=\"https://profiles.wordpress.org/patricia70/\">Patricia BT</a> · <a href=\"https://profiles.wordpress.org/lumiblog/\">Patrick Lumumba</a> · <a href=\"https://profiles.wordpress.org/patpiwo/\">Patrick Piwowarczyk</a> · <a href=\"https://profiles.wordpress.org/pryley/\">Paul</a> · <a href=\"https://profiles.wordpress.org/pbearne/\">Paul Bearne</a> · <a href=\"https://profiles.wordpress.org/pbiron/\">Paul Biron</a> · <a href=\"https://profiles.wordpress.org/paulbonneau/\">Paul Bonneau</a> · <a href=\"https://profiles.wordpress.org/paulkevan/\">Paul Kevan</a> · <a href=\"https://profiles.wordpress.org/paulopmt1/\">Paulo Trentin</a> · <a href=\"https://profiles.wordpress.org/paulstanos/\">paulstanos</a> · <a href=\"https://profiles.wordpress.org/pcarvalho/\">pcarvalho</a> · <a href=\"https://profiles.wordpress.org/pedrofigueroa1989/\">Pedro Figueroa</a> · <a href=\"https://profiles.wordpress.org/peroks/\">Per Egil Roksvaag</a> · <a href=\"https://profiles.wordpress.org/peteringersoll/\">Peter Ingersoll</a> · <a href=\"https://profiles.wordpress.org/westi/\">Peter Westwood</a> · <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a> · <a href=\"https://profiles.wordpress.org/petitphp/\">petitphp</a> · <a href=\"https://profiles.wordpress.org/philipjohn/\">Philip John</a> · <a href=\"https://profiles.wordpress.org/philsola/\">Philip Sola</a> · <a href=\"https://profiles.wordpress.org/tyrannous/\">Philipp Bammes</a> · <a href=\"https://profiles.wordpress.org/phillsav/\">Phill</a> · <a href=\"https://profiles.wordpress.org/piskvorky/\">piskvorky</a> · <a href=\"https://profiles.wordpress.org/poojabhimani/\">Pooja Bhimani</a> · <a href=\"https://profiles.wordpress.org/poojapadamad/\">poojapadamad</a> · <a href=\"https://profiles.wordpress.org/porg/\">porg</a> · <a href=\"https://profiles.wordpress.org/prab18hat/\">Prabhat Mishra</a> · <a href=\"https://profiles.wordpress.org/praful2111/\">Praful Patel</a> · <a href=\"https://profiles.wordpress.org/pranjalpratapsingh/\">Pranjal Pratap Singh</a> · <a href=\"https://profiles.wordpress.org/prasadkarmalkar/\">Prasad Karmalkar</a> · <a href=\"https://profiles.wordpress.org/prasadgupte/\">prasadgupte</a> · <a href=\"https://profiles.wordpress.org/pmbaldha/\">Prashant Baldha</a> · <a href=\"https://profiles.wordpress.org/pratiklondhe/\">Pratik Londhe</a> · <a href=\"https://profiles.wordpress.org/presskopp/\">Presskopp</a> · <a href=\"https://profiles.wordpress.org/prettyboymp/\">prettyboymp</a> · <a href=\"https://profiles.wordpress.org/puggan/\">puggan</a> · <a href=\"https://profiles.wordpress.org/quentinr64600/\">quentinr64600</a> · <a href=\"https://profiles.wordpress.org/rachelbaker/\">Rachel Baker</a> · <a href=\"https://profiles.wordpress.org/rafiq91/\">Rafiqul Islam</a> · <a href=\"https://profiles.wordpress.org/ralucastn/\">Raluca</a> · <a href=\"https://profiles.wordpress.org/superpoincare/\">Ramanan</a> · <a href=\"https://profiles.wordpress.org/ramiy/\">Rami Yushuvaev</a> · <a href=\"https://profiles.wordpress.org/rahmohn/\">Ramon Ahnert</a> · <a href=\"https://profiles.wordpress.org/rcorrales/\">Ramon Corrales</a> · <a href=\"https://profiles.wordpress.org/ramonopoly/\">Ramon James</a> · <a href=\"https://profiles.wordpress.org/ravichudasama01/\">Ravi Chudasama</a> · <a href=\"https://profiles.wordpress.org/ravigadhiyawp/\">Ravi Gadhiya</a> · <a href=\"https://profiles.wordpress.org/rcrdortiz/\">rcrdortiz</a> · <a href=\"https://profiles.wordpress.org/rehanali/\">Rehan Ali</a> · <a href=\"https://profiles.wordpress.org/rejaulalomkhan/\">Rejaul Alom Khan</a> · <a href=\"https://profiles.wordpress.org/tabrisrp/\">Remy Perona</a> · <a href=\"https://profiles.wordpress.org/espellcaste/\">Renato Alves</a> · <a href=\"https://profiles.wordpress.org/renishsurani/\">renishsurani</a> · <a href=\"https://profiles.wordpress.org/retrofox/\">retrofox</a> · <a href=\"https://profiles.wordpress.org/rezwanshiblu1952/\">Rezwan Shiblu</a> · <a href=\"https://profiles.wordpress.org/youknowriad/\">Riad Benguella</a> · <a href=\"https://profiles.wordpress.org/riadev/\">riadev</a> · <a href=\"https://profiles.wordpress.org/richtabor/\">Rich Tabor</a> · <a href=\"https://profiles.wordpress.org/rockfire/\">Richard Korthuis</a> · <a href=\"https://profiles.wordpress.org/riddhidave/\">Riddhi Dave</a> · <a href=\"https://profiles.wordpress.org/rinatkhaziev/\">Rinat</a> · <a href=\"https://profiles.wordpress.org/rinkalpagdar/\">Rinkal Pagdar</a> · <a href=\"https://profiles.wordpress.org/rishabhwp/\">Rishabh Gupta</a> · <a href=\"https://profiles.wordpress.org/rishavdutta/\">Rishav Dutta</a> · <a href=\"https://profiles.wordpress.org/rishit30g/\">Rishit Gupta</a> · <a href=\"https://profiles.wordpress.org/ristojovanovic/\">Risto Jovanovic</a> · <a href=\"https://profiles.wordpress.org/devrito/\">Ritoban</a> · <a href=\"https://profiles.wordpress.org/noisysocks/\">Robert Anderson</a> · <a href=\"https://profiles.wordpress.org/miqrogroove/\">Robert Chapin</a> · <a href=\"https://profiles.wordpress.org/robertghetau/\">Robert Ghetau</a> · <a href=\"https://profiles.wordpress.org/sanchothefat/\">Robert O\'Rourke</a> · <a href=\"https://profiles.wordpress.org/robmcclel/\">Robmcclel</a> · <a href=\"https://profiles.wordpress.org/rodrigosprimo/\">Rodrigo Primo</a> · <a href=\"https://profiles.wordpress.org/roelof/\">roelof</a> · <a href=\"https://profiles.wordpress.org/rollybueno/\">Rolly Bueno</a> · <a href=\"https://profiles.wordpress.org/ronak44/\">Ronak prajapati</a> · <a href=\"https://profiles.wordpress.org/room34/\">Room 34 Creative Services, LLC</a> · <a href=\"https://profiles.wordpress.org/costasovo/\">Rostislav Woln&#253;</a> · <a href=\"https://profiles.wordpress.org/rotemg/\">Rotem Gelbart</a> · <a href=\"https://profiles.wordpress.org/rayhatron/\">Rufaro Madamombe</a> · <a href=\"https://profiles.wordpress.org/rutvikbhambhi2004/\">Rutvik Bhambhi</a> · <a href=\"https://profiles.wordpress.org/rmccue/\">Ryan McCue</a> · <a href=\"https://profiles.wordpress.org/welcher/\">Ryan Welcher</a> · <a href=\"https://profiles.wordpress.org/skierpage/\">S Page</a> · <a href=\"https://profiles.wordpress.org/soean/\">S&#246;ren W&#252;nsch</a> · <a href=\"https://profiles.wordpress.org/sabbir1991/\">Sabbir Ahmed</a> · <a href=\"https://profiles.wordpress.org/devsabbirahmed/\">Sabbir Sam</a> · <a href=\"https://profiles.wordpress.org/sachinrajcp123/\">SACHINRAJ CP</a> · <a href=\"https://profiles.wordpress.org/sahiljadhav1617/\">Sahil Jadhav</a> · <a href=\"https://profiles.wordpress.org/sainathpoojary/\">Sainath Poojary</a> · <a href=\"https://profiles.wordpress.org/sajjad67/\">Sajjad Hossain Sagor</a> · <a href=\"https://profiles.wordpress.org/sakibmoon/\">sakibmoon</a> · <a href=\"https://profiles.wordpress.org/samueljseay/\">Sam</a> · <a href=\"https://profiles.wordpress.org/sam_a/\">sam_a</a> · <a href=\"https://profiles.wordpress.org/samirmalpande/\">Samir Malpande</a> · <a href=\"https://profiles.wordpress.org/viralsampat/\">Sampat Viral</a> · <a href=\"https://profiles.wordpress.org/sjapaget/\">Samuel Paget</a> · <a href=\"https://profiles.wordpress.org/otto42/\">Samuel Wood (Otto)</a> · <a href=\"https://profiles.wordpress.org/sandeepdahiya/\">Sandeep Dahiya</a> · <a href=\"https://profiles.wordpress.org/sandipsinh007/\">Sandip Sinh</a> · <a href=\"https://profiles.wordpress.org/ourvalley/\">Sandy McFadden</a> · <a href=\"https://profiles.wordpress.org/mikachan/\">Sarah Norris</a> · <a href=\"https://profiles.wordpress.org/tinkerbelly/\">sarah semark</a> · <a href=\"https://profiles.wordpress.org/sarthaknagoshe2002/\">Sarthak Nagoshe</a> · <a href=\"https://profiles.wordpress.org/satishprajapati/\">Satish Prajapati</a> · <a href=\"https://profiles.wordpress.org/saurabhdhariwal/\">saurabh.dhariwal</a> · <a href=\"https://profiles.wordpress.org/saxonafletcher/\">Saxon Fletcher</a> · <a href=\"https://profiles.wordpress.org/scholdstrom/\">scholdstrom</a> · <a href=\"https://profiles.wordpress.org/swb1192/\">Scott Buscemi</a> · <a href=\"https://profiles.wordpress.org/sc0ttkclark/\">Scott Kingsley Clark</a> · <a href=\"https://profiles.wordpress.org/coffee2code/\">Scott Reilly</a> · <a href=\"https://profiles.wordpress.org/wonderboymusic/\">Scott Taylor</a> · <a href=\"https://profiles.wordpress.org/scribu/\">scribu</a> · <a href=\"https://profiles.wordpress.org/sebastianpisula/\">Sebastian Pisula</a> · <a href=\"https://profiles.wordpress.org/seifradwane/\">Seif Radwane</a> · <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a> · <a href=\"https://profiles.wordpress.org/smrubenstein/\">Seth Rubenstein</a> · <a href=\"https://profiles.wordpress.org/shsajalchowdhury/\">SH Sajal Chowdhury</a> · <a href=\"https://profiles.wordpress.org/shadialaghbari/\">Shadi G شادي جـ</a> · <a href=\"https://profiles.wordpress.org/shailu25/\">Shail Mehta</a> · <a href=\"https://profiles.wordpress.org/sh4lin/\">Shalin Shah</a> · <a href=\"https://profiles.wordpress.org/shanemuir/\">Shane Muirhead</a> · <a href=\"https://profiles.wordpress.org/iamshashank/\">Shashank Jain</a> · <a href=\"https://profiles.wordpress.org/shekh0109/\">Shashank Shekhar</a> · <a href=\"https://profiles.wordpress.org/sajib1223/\">Shazzad Hossain Khan</a> · <a href=\"https://profiles.wordpress.org/designsimply/\">Sheri Grey</a> · <a href=\"https://profiles.wordpress.org/shiponkarmakar/\">Shipon Karmakar</a> · <a href=\"https://profiles.wordpress.org/shreya0shrivastava/\">Shreya Shrivastava</a> · <a href=\"https://profiles.wordpress.org/iamshubhamsp/\">Shubham Patil</a> · <a href=\"https://profiles.wordpress.org/shyamgadde/\">Shyamsundar Gadde</a> · <a href=\"https://profiles.wordpress.org/sidharthpandita/\">sidharthpandita</a> · <a href=\"https://profiles.wordpress.org/siliconforks/\">siliconforks</a> · <a href=\"https://profiles.wordpress.org/shilpaashokan94/\">Silpa TA</a> · <a href=\"https://profiles.wordpress.org/simonefontana/\">simonefontana</a> · <a href=\"https://profiles.wordpress.org/slaffik/\">Slava Abakumov</a> · <a href=\"https://profiles.wordpress.org/smerriman/\">smerriman</a> · <a href=\"https://profiles.wordpress.org/snehapatil02/\">Sneha Patil</a> · <a href=\"https://profiles.wordpress.org/maia12345/\">Sophie Dimitrov</a> · <a href=\"https://profiles.wordpress.org/sourabhjain/\">Sourabh Jain</a> · <a href=\"https://profiles.wordpress.org/sourav08/\">Sourav Pahwa</a> · <a href=\"https://profiles.wordpress.org/soyebsalar01/\">Soyeb Salar</a> · <a href=\"https://profiles.wordpress.org/spenserhale/\">Spenser Hale</a> · <a href=\"https://profiles.wordpress.org/spstrap/\">spstrap</a> · <a href=\"https://profiles.wordpress.org/srikat/\">Sridhar Katakam</a> · <a href=\"https://profiles.wordpress.org/stankea/\">stankea</a> · <a href=\"https://profiles.wordpress.org/metodiew/\">Stanko Metodiev</a> · <a href=\"https://profiles.wordpress.org/staurand/\">staurand</a> · <a href=\"https://profiles.wordpress.org/hubersen/\">Stefan Pasch</a> · <a href=\"https://profiles.wordpress.org/stefanvelthuys/\">Stefan Velthuys</a> · <a href=\"https://profiles.wordpress.org/sabernhardt/\">Stephen Bernhardt</a> · <a href=\"https://profiles.wordpress.org/stephenharris/\">Stephen Harris</a> · <a href=\"https://profiles.wordpress.org/dufresnesteven/\">Steve Dufresne</a> · <a href=\"https://profiles.wordpress.org/strarsis/\">strarsis</a> · <a href=\"https://profiles.wordpress.org/subrataemfluence/\">Subrata Sarkar</a> · <a href=\"https://profiles.wordpress.org/sudipatel007/\">Sudip Dadhaniya</a> · <a href=\"https://profiles.wordpress.org/sujansarkar/\">Sujan Sarkar</a> · <a href=\"https://profiles.wordpress.org/sukhendu2002/\">Sukhendu Sekhar Guria</a> · <a href=\"https://profiles.wordpress.org/sumitbagthariya16/\">Sumit Bagthariya</a> · <a href=\"https://profiles.wordpress.org/sunil25393/\">SunilPrajapati</a> · <a href=\"https://profiles.wordpress.org/sunnykasera/\">sunnykasera</a> · <a href=\"https://profiles.wordpress.org/sunyatasattva/\">sunyatasattva (a11n)</a> · <a href=\"https://profiles.wordpress.org/supernovia/\">supernovia</a> · <a href=\"https://profiles.wordpress.org/suzukube/\">SuzuKube</a> · <a href=\"https://profiles.wordpress.org/svedish/\">svedish</a> · <a href=\"https://profiles.wordpress.org/lordspace/\">Svetoslav Marinov</a> · <a href=\"https://profiles.wordpress.org/cybr/\">Sybre Waaijer</a> · <a href=\"https://profiles.wordpress.org/syhussaini/\">syhussaini</a> · <a href=\"https://profiles.wordpress.org/schwipps/\">T4ng</a> · <a href=\"https://profiles.wordpress.org/tacoverdo/\">Taco Verdonschot</a> · <a href=\"https://profiles.wordpress.org/iamtakashi/\">Takashi Irie</a> · <a href=\"https://profiles.wordpress.org/takuword/\">Takuro</a> · <a href=\"https://profiles.wordpress.org/karmatosed/\">Tammie Lister</a> · <a href=\"https://profiles.wordpress.org/tatof/\">tatof</a> · <a href=\"https://profiles.wordpress.org/tecnogaming/\">tecnogaming</a> · <a href=\"https://profiles.wordpress.org/mecaota/\">Tetsuro Higuchi</a> · <a href=\"https://profiles.wordpress.org/tharsheblows/\">tharsheblows</a> · <a href=\"https://profiles.wordpress.org/thelmachido/\">thelmachido a11n</a> · <a href=\"https://profiles.wordpress.org/tsquez/\">ThemeAWESOME</a> · <a href=\"https://profiles.wordpress.org/themiked/\">theMikeD</a> · <a href=\"https://profiles.wordpress.org/kraftner/\">Thomas Kr&#228;ftner</a> · <a href=\"https://profiles.wordpress.org/tfrommen/\">Thorsten Frommen</a> · <a href=\"https://profiles.wordpress.org/tillkruess/\">Till Kr&#252;ss</a> · <a href=\"https://profiles.wordpress.org/timhavinga/\">Tim Havinga</a> · <a href=\"https://profiles.wordpress.org/dontfeedthecode/\">Tim Sheehan</a> · <a href=\"https://profiles.wordpress.org/timotijhof/\">Timo Tijhof</a> · <a href=\"https://profiles.wordpress.org/spaceshipone/\">Timoth&#233;e Brosille</a> · <a href=\"https://profiles.wordpress.org/timotheemoulin/\">Timoth&#233;e Moulin</a> · <a href=\"https://profiles.wordpress.org/timothyblynjacobs/\">Timothy Jacobs</a> · <a href=\"https://profiles.wordpress.org/tjarrett/\">TJarrett</a> · <a href=\"https://profiles.wordpress.org/tobiasbg/\">Tobias B&#228;thge</a> · <a href=\"https://profiles.wordpress.org/tz-media/\">Tobias Zimpel</a> · <a href=\"https://profiles.wordpress.org/tobifjellner/\">tobifjellner (Tor-Bjorn &#8220;Tobi&#8221; Fjellner)</a> · <a href=\"https://profiles.wordpress.org/tomdevisser/\">Tom de Visser</a> · <a href=\"https://profiles.wordpress.org/tjnowell/\">Tom J Nowell</a> · <a href=\"https://profiles.wordpress.org/shimotomoki/\">Tomoki Shimomura</a> · <a href=\"https://profiles.wordpress.org/skithund/\">Toni Viemer&#246;</a> · <a href=\"https://profiles.wordpress.org/hellofromtonya/\">Tonya Mork</a> · <a href=\"https://profiles.wordpress.org/toro_unit/\">Toro_Unit (Hiroshi Urabe)</a> · <a href=\"https://profiles.wordpress.org/zodiac1978/\">Torsten Landsiedel</a> · <a href=\"https://profiles.wordpress.org/wpsmith/\">Travis Smith</a> · <a href=\"https://profiles.wordpress.org/traxus/\">traxus</a> · <a href=\"https://profiles.wordpress.org/sllimrovert/\">Trevor Mills</a> · <a href=\"https://profiles.wordpress.org/tristanleboss/\">tristanleboss</a> · <a href=\"https://profiles.wordpress.org/areziaal/\">Troy Chaplin</a> · <a href=\"https://profiles.wordpress.org/truptikanzariya/\">Trupti Kanzariya</a> · <a href=\"https://profiles.wordpress.org/tsteel/\">tsteel</a> · <a href=\"https://profiles.wordpress.org/dinhtungdu/\">Tung Du</a> · <a href=\"https://profiles.wordpress.org/tusharbharti/\">Tushar Bharti</a> · <a href=\"https://profiles.wordpress.org/tusharaddweb/\">Tushar Patel</a> · <a href=\"https://profiles.wordpress.org/tussendoor/\">Tussendoor B.V.</a> · <a href=\"https://profiles.wordpress.org/ugyensupport/\">Ugyen Dorji</a> · <a href=\"https://profiles.wordpress.org/umeshnevase/\">Umesh Nevase</a> · <a href=\"https://profiles.wordpress.org/umeshsinghin/\">Umesh Singh</a> · <a href=\"https://profiles.wordpress.org/unsalkorkmaz/\">Unsal Korkmaz</a> · <a href=\"https://profiles.wordpress.org/upadalavipul/\">upadalavipul</a> · <a href=\"https://profiles.wordpress.org/utsavladani/\">Utsav Ladani</a> · <a href=\"https://profiles.wordpress.org/utsav72640/\">Utsav tilava</a> · <a href=\"https://profiles.wordpress.org/valentingrenier/\">Valentin Grenier</a> · <a href=\"https://profiles.wordpress.org/tsimshatsui/\">Vape tsimshatsui</a> · <a href=\"https://profiles.wordpress.org/vbbp/\">vbbp</a> · <a href=\"https://profiles.wordpress.org/sheldorofazeroth/\">Vedansh Mishra</a> · <a href=\"https://profiles.wordpress.org/vevas/\">Vegard S.</a> · <a href=\"https://profiles.wordpress.org/vgnavada/\">vgnavada</a> · <a href=\"https://profiles.wordpress.org/vcanales/\">Vicente Canales</a> · <a href=\"https://profiles.wordpress.org/vidugupta/\">vidugupta</a> · <a href=\"https://profiles.wordpress.org/vijendrajat/\">Vijendra Jat</a> · <a href=\"https://profiles.wordpress.org/szepeviktor/\">Viktor Sz&#233;pe</a> · <a href=\"https://profiles.wordpress.org/vineet2003/\">Vinit</a> · <a href=\"https://profiles.wordpress.org/ghorivipul97/\">Vipul Ghori</a> · <a href=\"https://profiles.wordpress.org/vipulgupta003/\">Vipul Gupta</a> · <a href=\"https://profiles.wordpress.org/vipulpatil/\">Vipul Patil</a> · <a href=\"https://profiles.wordpress.org/vishitshah/\">Vishit Shah</a> · <a href=\"https://profiles.wordpress.org/vladimiraus/\">vladimiraus</a> · <a href=\"https://profiles.wordpress.org/vortfu/\">vortfu</a> · <a href=\"https://profiles.wordpress.org/vrishabhsk/\">Vrishabh Jasani</a> · <a href=\"https://profiles.wordpress.org/walterebert/\">Walter Ebert</a> · <a href=\"https://profiles.wordpress.org/webmandesign/\">WebMan Design &#124; Oliver Juhas</a> · <a href=\"https://profiles.wordpress.org/websupporter/\">websupporter</a> · <a href=\"https://profiles.wordpress.org/webwrotter/\">webwrotter</a> · <a href=\"https://profiles.wordpress.org/westonruter/\">Weston Ruter</a> · <a href=\"https://profiles.wordpress.org/whaze/\">whaze</a> · <a href=\"https://profiles.wordpress.org/widhy980/\">widhy980</a> · <a href=\"https://profiles.wordpress.org/skorasaurus/\">Will Skora</a> · <a href=\"https://profiles.wordpress.org/wplmillet/\">wplmillet</a> · <a href=\"https://profiles.wordpress.org/xate/\">xate</a> · <a href=\"https://profiles.wordpress.org/xavilc/\">xavilc</a> · <a href=\"https://profiles.wordpress.org/xerpa43/\">xerpa43</a> · <a href=\"https://profiles.wordpress.org/xipasduarte/\">xipasduarte</a> · <a href=\"https://profiles.wordpress.org/yagniksangani/\">Yagnik Sangani</a> · <a href=\"https://profiles.wordpress.org/yashyadav247/\">Yash</a> · <a href=\"https://profiles.wordpress.org/getsyash/\">Yash B</a> · <a href=\"https://profiles.wordpress.org/yashjawale/\">Yash Jawale</a> · <a href=\"https://profiles.wordpress.org/yogeshbhutkar/\">Yogesh Bhutkar</a> · <a href=\"https://profiles.wordpress.org/yogieanamcara/\">YogieAnamCara</a> · <a href=\"https://profiles.wordpress.org/fierevere/\">Yui</a> · <a href=\"https://profiles.wordpress.org/zebulan/\">Zebulan Stanphill</a> · <a href=\"https://profiles.wordpress.org/zeelthakkar/\">Zeel Thakkar</a> · <a href=\"https://profiles.wordpress.org/zunaid321/\">Zunaid Amin</a> · <a href=\"https://profiles.wordpress.org/lstraczynski/\">Łukasz Strączyński</a> · <a href=\"https://profiles.wordpress.org/haozi/\">耗子</a></p>\n\n\n\n<p>More than <a href=\"https://translate.wordpress.org/stats/\">71 locales have fully translated</a> WordPress 6.9 into their language. Community translators are working hard to ensure more translations are on their way. Thank you to everyone who helps make WordPress available in 200+ languages.</p>\n\n\n\n<p>Last but not least, thanks to the volunteers who contribute to the <a href=\"https://wordpress.org/support/forums/\">support forums</a> by answering questions from WordPress users worldwide.</p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Get involved</strong></h2>\n\n\n\n<p>Participation in WordPress goes far beyond coding. And learning more and getting involved is easy.&nbsp; Discover the teams that come together to <a href=\"https://make.wordpress.org/\">Make WordPress</a> and use <a href=\"https://make.wordpress.org/contribute/\">this interactive tool</a> to help you decide which is right for you.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"19398\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:75:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"WordPress 6.9 Release Candidate 3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://wordpress.org/news/2025/11/wordpress-6-9-release-candidate-3/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 25 Nov 2025 15:33:10 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:7:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:7:\"General\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:3:\"6.9\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:11:\"development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:5;a:5:{s:4:\"data\";s:18:\"release candidates\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:6;a:5:{s:4:\"data\";s:8:\"releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=19373\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:366:\"The third Release Candidate (“RC3”) for WordPress 6.9 is ready for download and testing! This version of the WordPress software is under development. Please do not install, run, or test this version of WordPress on production or mission-critical websites. Instead, it’s recommended that you evaluate RC3 on a test server and site. Reaching this phase [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Amy Kamala\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:8039:\"\n<p>The third Release Candidate (“RC3”) for WordPress 6.9 is ready for download and testing!</p>\n\n\n\n<p><strong>This version of the WordPress software is under development</strong>. <strong>Please do not install, run, or test this version of WordPress on production or mission-critical websites.</strong> Instead, it’s recommended that you evaluate RC3 on a test server and site.</p>\n\n\n\n<p>Reaching this phase of the release cycle is an important milestone. While release candidates are considered ready for release, testing remains crucial to ensure that everything in WordPress 6.9 is the highest quality possible.</p>\n\n\n\n<p>You can test WordPress 6.9 RC3 in four ways:</p>\n\n\n\n<figure class=\"wp-block-table\"><table class=\"has-fixed-layout\"><tbody><tr><td><strong>Plugin</strong></td><td>Install and activate the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\"></a><a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin on a WordPress install. (Select the “Bleeding edge” channel and “Beta/RC Only” stream.)</td></tr><tr><td><strong>Direct Download</strong></td><td>Download the <a href=\"https://wordpress.org/wordpress-6.9-beta2.zip\"></a><a href=\"https://wordpress.org/wordpress-6.9-RC3.zip\">RC3 version (zip)</a>. and install it on a WordPress website.</td></tr><tr><td><strong>Command Line</strong></td><td>Use this <a href=\"https://make.wordpress.org/cli/\">WP-CLI</a> command: <br><code>wp core update --version=6.9-RC3</code></td></tr><tr><td><strong>WordPress Playground</strong></td><td>Use the <a href=\"https://playground.wordpress.net/?php=8.0&amp;wp=beta&amp;networking=no&amp;language=&amp;multisite=no&amp;random=y4q1rn85xn\">6.9 WordPress Playground instance</a> to test the software directly in your browser.&nbsp; No setup is required – just click and go!&nbsp;</td></tr></tbody></table></figure>\n\n\n\n<p>The scheduled final release date for WordPress 6.9 is <strong>December 2, 2025</strong>. The full <a href=\"https://make.wordpress.org/core/6-9/\">release schedule can be found here</a>. Your help testing RC versions is vital to making this release as stable and powerful as possible.</p>\n\n\n\n<p>Please continue checking the <a href=\"https://make.wordpress.org/core/\">Make WordPress Core blog</a> for <a href=\"https://make.wordpress.org/core/tag/6-9/\">6.9-related posts</a> in the coming weeks for more information.</p>\n\n\n\n<h2 class=\"wp-block-heading\">What’s in WordPress 6.9 RC3?</h2>\n\n\n\n<p>Want to look deeper into the details and technical notes for this release? Take a look at the <a href=\"https://make.wordpress.org/core/2025/11/25/wordpress-6-9-field-guide\">WordPress 6.9 Field Guide</a>. For technical information related to issues addressed since <a href=\"https://wordpress.org/news/2025/11/wordpress-6-9-release-candidate-2\">RC2</a>, you can browse the following links:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://github.com/WordPress/gutenberg/commits/wp/6.9?since=2025-11-18&amp;until=2025-11-25\">Gutenberg commits for 6.9</a> since November 18</li>\n\n\n\n<li><a href=\"https://core.trac.wordpress.org/query?status=closed&amp;changetime=11%2F18%2F2025..11%2F24%2F2025&amp;milestone=6.9&amp;group=component&amp;col=id&amp;col=summary&amp;col=milestone&amp;col=changetime&amp;col=type&amp;order=id\">Closed WordPress Core Trac tickets</a> since November 18</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">How you can contribute</h2>\n\n\n\n<p>WordPress is open source software made possible by a passionate community of people collaborating on and contributing to its development. The resources below outline various ways you can get involved with the world’s most popular open source web platform, regardless of your technical expertise.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Get involved in testing</h3>\n\n\n\n<p>Testing for issues is crucial to the development of any software. It’s also a meaningful way for anyone to contribute.&nbsp;</p>\n\n\n\n<p>Your help testing the WordPress 6.9 RC3 prerelease is key to ensuring that the final release is the best it can be. While testing the upgrade process is essential, trying out new features is equally important. This <a href=\"https://make.wordpress.org/test/2025/10/21/help-test-wordpress-6-9/\">detailed guide</a> will walk you through testing features in WordPress 6.9. For those new to testing, follow <a href=\"https://make.wordpress.org/test/handbook/get-setup-for-testing/\">this general testing guide</a> for more details on getting set up.</p>\n\n\n\n<p>If you encounter an issue, please report it to the <a href=\"https://wordpress.org/support/forum/alphabeta/\">Alpha/Beta/RC area</a> of the support forums or directly to <a href=\"https://core.trac.wordpress.org/newticket\">WordPress Trac</a> if you are comfortable writing a reproducible bug report. You can also check your issue against a list of <a href=\"https://core.trac.wordpress.org/tickets/major\">known bugs</a>.</p>\n\n\n\n<p>Curious about testing releases in general?&nbsp; Follow along with the <a href=\"https://make.wordpress.org/test/\">testing initiatives in Make Core</a> and join the <a href=\"https://wordpress.slack.com/messages/core-test/\">#core-test channel</a> on <a href=\"https://wordpress.slack.com/\"></a><a href=\"https://make.wordpress.org/chat/\">Making WordPress Slack</a>..</p>\n\n\n\n<h3 class=\"wp-block-heading\">Update your theme or plugin</h3>\n\n\n\n<p>For plugin and theme authors, your products play an integral role in extending the functionality and value of WordPress for all users.</p>\n\n\n\n<p>Thanks for continuing to test your themes and plugins with the WordPress 6.9 prereleases. If you haven’t yet, please conclude your testing and update the <em>“Tested up to”</em> version in your theme and plugin <a href=\"https://developer.wordpress.org/plugins/wordpress-org/how-your-readme-txt-works/\">readme files</a> to <code>6.9</code>.</p>\n\n\n\n<p>If you find compatibility issues, please post detailed information in the <a href=\"https://wordpress.org/support/forum/alphabeta/\">support forum</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Test on your hosting platforms</h3>\n\n\n\n<p>Web hosts provide vital infrastructure for supporting WordPress and its users. Testing on hosting systems helps inform the development process while ensuring that WordPress and hosting platforms are fully compatible, free of errors, optimized for the best possible user experience, and that updates roll out to customer sites without issue.</p>\n\n\n\n<p>Want to test WordPress on your hosting system? <a href=\"https://make.wordpress.org/hosting/test-results-getting-started/\">Get started with configuring distributed hosting tests here</a>.&nbsp;</p>\n\n\n\n<h3 class=\"wp-block-heading\">Help translate WordPress</h3>\n\n\n\n<p>Do you speak a language other than English? ¿Español? Français? Русский? 日本語? हिन्दी? বাংলা? मराठी? ಕನ್ನಡ?&nbsp;You can <a href=\"https://translate.wordpress.org/projects/wp/dev/\">help translate WordPress into more than 100 languages</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">An RC3 haiku</h2>\n\n\n\n<p><em>Some folks make money,</em></p>\n\n\n\n<p><em>some folks make time to travel,</em></p>\n\n\n\n<p><em>and we Make WordPress.</em></p>\n\n\n\n<p class=\"has-text-align-right\"><em>Props to </em><a href=\'https://profiles.wordpress.org/akshayar/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>akshayar</a>, <a href=\'https://profiles.wordpress.org/davidbaumwald/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>davidbaumwald</a>, <a href=\'https://profiles.wordpress.org/westonruter/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>westonruter</a>, <a href=\'https://profiles.wordpress.org/ellatrix/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>ellatrix</a>, <a href=\'https://profiles.wordpress.org/mobarak/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>mobarak</a> <em>and</em> <a href=\'https://profiles.wordpress.org/tacoverdo/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>tacoverdo</a> <em>for proofreading and review.</em></p>\n\n\n\n<p></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"19373\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:69:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"WordPress 6.9 Release Candidate 2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://wordpress.org/news/2025/11/wordpress-6-9-release-candidate-2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 18 Nov 2025 15:26:53 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:5:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:7:\"General\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:3:\"6.9\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:7:\"release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=19350\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:367:\"The second Release Candidate (“RC2”) for WordPress 6.9 is ready for download and testing! This version of the WordPress software is under development. Please do not install, run, or test this version of WordPress on production or mission-critical websites. Instead, it’s recommended that you evaluate RC2 on a test server and site. Reaching this phase [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Akshaya Rane\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:10595:\"\n<p>The second Release Candidate (“RC2”) for WordPress 6.9 is ready for download and testing!</p>\n\n\n\n<p><strong>This version of the WordPress software is under development</strong>.<strong> Please do not install, run, or test this version of WordPress on production or mission-critical websites.</strong> Instead, it’s recommended that you evaluate RC2 on a test server and site.</p>\n\n\n\n<p>Reaching this phase of the release cycle is an important milestone. While release candidates are considered ready for release, testing remains crucial to ensure that everything in WordPress 6.9 is the best it can be.</p>\n\n\n\n<p>You can test WordPress 6.9 RC2 in four ways:</p>\n\n\n\n<figure class=\"wp-block-table\"><table class=\"has-fixed-layout\"><tbody><tr><td><strong>Plugin</strong></td><td>Install and activate the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin on a WordPress install. (Select the “Bleeding edge” channel and “Beta/RC Only” stream).</td></tr><tr><td><strong>Direct Download</strong></td><td>Download the <a href=\"https://wordpress.org/wordpress-6.9-RC2.zip\">RC2 version (zip)</a> and install it on a WordPress website.</td></tr><tr><td><strong>Command Line</strong></td><td>Use the following <a href=\"https://make.wordpress.org/cli/\">WP-CLI</a> command:<br><code>wp core update --version=6.9-RC2</code></td></tr><tr><td><strong>WordPress Playground</strong></td><td>Use the <a href=\"https://playground.wordpress.net/?php=8.0&amp;wp=beta&amp;networking=no&amp;language=&amp;multisite=no&amp;random=y4q1rn85xn\">6.9 RC2 WordPress Playground instance</a> to test the software directly in your browser without the need for a separate site or setup.</td></tr></tbody></table></figure>\n\n\n\n<p>The scheduled final release date for WordPress 6.9 is <strong>December 2, 2025</strong>. The full <a href=\"https://make.wordpress.org/core/6-9/\">release schedule can be found here</a>. Your help testing RC versions is vital to making this release as stable and powerful as possible.</p>\n\n\n\n<p>Please continue checking the <a href=\"https://make.wordpress.org/core/\">Make WordPress Core blog</a> for <a href=\"https://make.wordpress.org/core/tag/6-9/\">6.9-related posts</a> in the coming weeks for more information.</p>\n\n\n\n<h2 class=\"wp-block-heading\">What’s in WordPress 6.9 RC2?</h2>\n\n\n\n<p>Get a recap of WordPress 6.9’s highlighted features in the <a href=\"https://make.wordpress.org/core/2025/10/21/wordpress-6-9-beta-1/\">Beta 1 announcement</a>. For more technical information related to issues addressed since RC1, you can browse the following links:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://github.com/WordPress/gutenberg/commits/wp/6.9?since=2025-11-11&amp;until=2025-11-18\">GitHub commits for 6.9</a> since November 11</li>\n\n\n\n<li><a href=\"https://core.trac.wordpress.org/query?status=closed&amp;changetime=11%2F11%2F2025..11%2F18%2F2025&amp;milestone=6.9&amp;group=component&amp;col=id&amp;col=summary&amp;col=milestone&amp;col=changetime&amp;col=type&amp;order=id\">Closed Trac tickets</a> since November 11</li>\n</ul>\n\n\n\n<p>Want to look deeper into the details and technical notes for this release? These recent posts cover some of the latest updates:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://make.wordpress.org/core/2025/11/15/notes-feature-in-wordpress-6-9/\" target=\"_blank\" rel=\"noreferrer noopener\">Notes Feature in 6.9</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2025/11/10/abilities-api-in-wordpress-6-9/\" target=\"_blank\" rel=\"noreferrer noopener\">Abilities API in WordPress 6.9</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2025/11/18/wordpress-6-9-frontend-performance-field-guide/\">WordPress 6.9 Frontend Performance Field Guide</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2025/11/12/interactivity-apis-client-navigation-improvements-in-wordpress-6-9/\" target=\"_blank\" rel=\"noreferrer noopener\">Interactivity API’s client navigation improvements in WordPress 6.9</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2025/11/12/block-bindings-improvements-in-wordpress-6-9/\" target=\"_blank\" rel=\"noreferrer noopener\">Block Bindings improvements in WordPress 6.9</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2025/11/12/changes-to-the-interactivity-api-in-wordpress-6-9/\" target=\"_blank\" rel=\"noreferrer noopener\">Changes to the Interactivity API in WordPress 6.9</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2025/11/17/consistent-cache-keys-for-query-groups-in-wordpress-6-9/\">Consistent Cache Keys for Query Groups in WordPress 6.9</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2025/11/11/dataviews-dataform-et-al-in-wordpress-6-9/\" target=\"_blank\" rel=\"noreferrer noopener\">DataViews, DataForm, et al. in WordPress 6.9</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2025/11/12/preparing-the-post-editor-for-full-iframe-integration/\" target=\"_blank\" rel=\"noreferrer noopener\">Preparing the Post Editor for Full iframe Integration</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2025/11/12/theme-json-border-radius-presets-support-in-wordpress-6-9/\" target=\"_blank\" rel=\"noreferrer noopener\">Theme.json Border Radius Presets Support in WordPress 6.9</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2025/11/12/heading-block-css-specificity-fix-in-wordpress-6-9/\" target=\"_blank\" rel=\"noreferrer noopener\">Heading Block CSS Specificity Fix in WordPress 6.9</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2025/11/17/miscellaneous-developer-focused-changes-in-6-9/\">Miscellaneous Developer-focused Changes in 6.9</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2025/11/18/modernizing-utf-8-support-in-wordpress-6-9/\" data-type=\"link\" data-id=\"https://make.wordpress.org/core/2025/11/18/modernizing-utf-8-support-in-wordpress-6-9/\">Modernizing UTF-8 support in WordPress 6.9</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">How you can contribute</h2>\n\n\n\n<p>WordPress is open source software made possible by a passionate community of people collaborating on and contributing to its development. The resources below outline various ways you can help the world’s most popular open source web platform, regardless of your technical expertise.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Get involved in testing</h2>\n\n\n\n<p>Testing for issues is crucial to the development of any software. It’s also a meaningful way for anyone to contribute.&nbsp;</p>\n\n\n\n<p>Your help testing the WordPress 6.9 RC2 version is key to ensuring that the final release is the best it can be. While testing the upgrade process is essential, trying out new features is equally important. This <a href=\"https://make.wordpress.org/test/2025/10/21/help-test-wordpress-6-9/\">detailed guide</a> will walk you through testing features in WordPress 6.9. For those new to testing, follow <a href=\"https://make.wordpress.org/test/handbook/get-setup-for-testing/\">this general testing guide</a> for more details on getting set up.</p>\n\n\n\n<p>If you encounter an issue, please report it to the <a href=\"https://wordpress.org/support/forum/alphabeta/\">Alpha/Beta area</a> of the support forums or directly to <a href=\"https://core.trac.wordpress.org/newticket\">WordPress Trac</a> if you are comfortable writing a reproducible bug report.&nbsp; You can also check your issue against a list of <a href=\"https://core.trac.wordpress.org/tickets/major\">known bugs</a>.&nbsp;</p>\n\n\n\n<p>Curious about testing releases in general?&nbsp; Follow along with the <a href=\"https://make.wordpress.org/test/\">testing initiatives in Make Core</a> and join the<a href=\"https://wordpress.slack.com/messages/core-test/\">#core-test channel</a> on <a href=\"https://wordpress.slack.com/\">Making WordPress Slack</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Update your theme or plugin</h2>\n\n\n\n<p>For plugin and theme authors, your products play an integral role in extending the functionality and value of WordPress for all users.</p>\n\n\n\n<p>Thanks for continuing to test your themes and plugins with the WordPress 6.9 beta releases. If you haven’t yet, make sure to conclude your testing and update the <em>“Tested up to”</em> version in your <a href=\"https://developer.wordpress.org/plugins/wordpress-org/how-your-readme-txt-works/\">plugin’s readme file</a> to 6.9.</p>\n\n\n\n<p>If you find compatibility issues, please post detailed information to the <a href=\"https://wordpress.org/support/forum/alphabeta/\">support forum</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Test on your hosting platforms</h2>\n\n\n\n<p>Web hosts provide vital infrastructure for supporting WordPress and its users. Testing on hosting systems helps inform the development process while ensuring that WordPress and hosting platforms are fully compatible, free of errors, optimized for the best possible user experience, and that updates roll out to customer sites without issue.</p>\n\n\n\n<p>Want to test WordPress on your hosting system? <a href=\"https://make.wordpress.org/hosting/test-results-getting-started/\">Get started with configuring distributed hosting tests here</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Help translate WordPress</h2>\n\n\n\n<p>Do you speak a language other than English? ¿Español? Français? Русский? 日本語? हिन्दी? বাংলা? मराठी? ಕನ್ನಡ?&nbsp; You can<a href=\"https://translate.wordpress.org/projects/wp/dev/\"> help translate WordPress into more than 100 languages</a>. This release milestone (RC2) also marks the<a href=\"https://make.wordpress.org/polyglots/handbook/glossary/#hard-freeze\"> hard string freeze</a> point of the <a href=\"https://make.wordpress.org/core/2025/11/11/wordpress-6-9-release-candidate-phase/\">6.9 release cycle</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">An RC2 haiku</h2>\n\n\n\n<p>A calm hillside sighs,<br>Work of many now complete —<br>RC2 stays true.</p>\n\n\n\n<p class=\"has-text-align-right\"><em>Props to <a href=\'https://profiles.wordpress.org/amykamala/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>amykamala</a>, <a href=\'https://profiles.wordpress.org/annezazu/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>annezazu</a>, <a href=\'https://profiles.wordpress.org/davidbaumwald/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>davidbaumwald</a>, <a href=\'https://profiles.wordpress.org/westonruter/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>westonruter</a> and <a href=\'https://profiles.wordpress.org/joedolson/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>joedolson</a> for proofreading and review.</em></p>\n\n\n\n<p></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"19350\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:75:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"WordPress 6.9 Release Candidate 1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://wordpress.org/news/2025/11/wordpress-6-9-release-candidate-1/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 11 Nov 2025 15:34:48 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:7:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:7:\"General\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:3:\"6.9\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:11:\"development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:5;a:5:{s:4:\"data\";s:18:\"release candidates\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:6;a:5:{s:4:\"data\";s:8:\"releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=19317\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:364:\"The first Release Candidate (“RC1”) for WordPress 6.9 is ready for download and testing! This version of the WordPress software is still under development. Please do not install, run, or test this version of WordPress on production or mission-critical websites. Instead, it’s recommended to evaluate RC1 on a test server and site. WordPress 6.9 RC1 [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Amy Kamala\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:9479:\"\n<p>The first Release Candidate (“RC1”) for WordPress 6.9 is ready for download and testing!</p>\n\n\n\n<p><strong>This version of the WordPress software is still under development</strong>. Please do not install, run, or test this version of WordPress on production or mission-critical websites. Instead, it’s recommended to evaluate RC1 on a test server and site.</p>\n\n\n\n<p>WordPress 6.9 RC1 can be tested using any of the following methods:</p>\n\n\n\n<figure class=\"wp-block-table\"><table class=\"has-fixed-layout\"><tbody><tr><td><strong>Plugin</strong></td><td>Install and activate the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin on a WordPress install. (Select the “Bleeding edge” channel and “Beta/RC Only” stream.)</td></tr><tr><td><strong>Direct Download</strong></td><td>Download the <a href=\"https://wordpress.org/wordpress-6.9-RC1.zip\">RC1 version (zip)</a> and install it on a WordPress website.</td></tr><tr><td><strong>Command Line</strong></td><td>Use this <a href=\"https://make.wordpress.org/cli/\">WP-CLI</a> command: <br><code>wp core update --version=6.9-RC1</code></td></tr><tr><td><strong>WordPress Playground</strong></td><td>Use the <a href=\"https://playground.wordpress.net/?php=8.3&amp;wp=beta&amp;networking=no&amp;language=&amp;multisite=no&amp;random=y4q1rn88xn\" data-type=\"link\" data-id=\"https://playground.wordpress.net/?php=8.3&amp;wp=rc&amp;networking=no&amp;language=&amp;multisite=no&amp;random=y4q1rn88xn\">6.9 RC1 WordPress Playground instance</a> to test the software directly in your browser. No setup is required &#8211; just click and go! </td></tr></tbody></table></figure>\n\n\n\n<p>The scheduled final release date for WordPress 6.9 is <strong>December 2, 2025</strong>. The full <a href=\"https://make.wordpress.org/core/6-9/\">release schedule can be found here</a>. Your help testing Beta and RC versions is vital to making this release as stable and powerful as possible.</p>\n\n\n\n<p>Please continue checking the <a href=\"https://make.wordpress.org/core/\">Make WordPress Core blog</a> for <a href=\"https://make.wordpress.org/core/tag/6-9/\">6.9-related posts</a> in the coming weeks for more information.</p>\n\n\n\n<h2 class=\"wp-block-heading\">What’s in WordPress 6.9 RC1?</h2>\n\n\n\n<p>Check out the <a href=\"https://make.wordpress.org/core/2025/10/21/wordpress-6-9-beta-1/\">Beta 1 announcement</a> for details on WordPress 6.9.</p>\n\n\n\n<p>You can browse the technical details for all issues addressed since Beta 4 using these links:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://github.com/WordPress/gutenberg/commits/wp/6.9?since=2025-11-07&amp;until=2025-11-11\">Gutenberg commits for 6.9</a> since November 7, 2025</li>\n\n\n\n<li><a href=\"https://core.trac.wordpress.org/log/?revs=61183-61203\">Core commits for 6.9</a> since November 7, 2025</li>\n\n\n\n<li><a href=\"https://core.trac.wordpress.org/query?status=closed&amp;changetime=11%2F07%2F2025..11%2F11%2F2025&amp;milestone=6.9&amp;group=component&amp;col=id&amp;col=summary&amp;col=milestone&amp;col=changetime&amp;col=type&amp;order=id\">Closed Trac tickets</a> since November 7, 2025</li>\n</ul>\n\n\n\n<p>Want to know more about this release? Here are some highlights:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Site Editor improvements and Refined content creation\n<ul class=\"wp-block-list\">\n<li>Ability to hide blocks</li>\n\n\n\n<li>New blocks </li>\n\n\n\n<li>Notes on blocks</li>\n\n\n\n<li>Universal command palette in wp-admin</li>\n</ul>\n</li>\n\n\n\n<li>Developer updates\n<ul class=\"wp-block-list\">\n<li>Updates to dataviews and dataforms components</li>\n\n\n\n<li>New abilities API</li>\n\n\n\n<li>Updates to interactivity API </li>\n\n\n\n<li>Updates to block binding API</li>\n</ul>\n</li>\n\n\n\n<li>Performance Improvements\n<ul class=\"wp-block-list\">\n<li>Improved script and style handling</li>\n\n\n\n<li>Optimized queries and caching</li>\n\n\n\n<li>Added ability to handle “fetchpriority” in ES Modules and Import Maps</li>\n\n\n\n<li>Standardizing output buffering</li>\n</ul>\n</li>\n</ul>\n\n\n\n<p>The final release is on track for December 2nd. As always, a successful release depends on your confirmation during testing. So please download and test!</p>\n\n\n\n<h2 class=\"wp-block-heading\">How you can contribute</h2>\n\n\n\n<p>WordPress is open source software made possible by a passionate community of people collaborating on and contributing to its development. The resources below outline various ways you can help the world’s most popular open source web platform, regardless of your technical expertise.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Get involved in testing</h3>\n\n\n\n<p>Testing for issues is crucial to the development of any software. It’s also a meaningful way for anyone to contribute. </p>\n\n\n\n<p>Your help testing the WordPress 6.9 RC1 version is key to ensuring that the final release is the best it can be. While testing the upgrade process is essential, trying out new features is equally important. This <a href=\"https://make.wordpress.org/test/2025/10/21/help-test-wordpress-6-9/\">detailed guide</a> will walk you through testing features in WordPress 6.9.</p>\n\n\n\n<h4 class=\"wp-block-heading\">Calls for testing</h4>\n\n\n\n<p>Thank you to everyone who helps test the following enhancements and bug fixes:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://make.wordpress.org/test/2025/10/06/call-for-testing-accordion-block/\">Accordion Block</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/test/2025/10/04/call-for-testing-ability-to-hide-blocks/\">Ability to Hide Blocks</a></li>\n\n\n\n<li><a href=\"https://core.trac.wordpress.org/ticket/64099\">Classic themes loading block styles on demand</a></li>\n\n\n\n<li><a href=\"https://core.trac.wordpress.org/ticket/64204\">Modified notes notifications</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2025/11/10/abilities-api-in-wordpress-6-9/\">Abilities API</a></li>\n</ul>\n\n\n\n<p>If you encounter an issue, please report it to the <a href=\"https://wordpress.org/support/forum/alphabeta/\">Alpha/Beta area</a> of the support forums, or directly to <a href=\"https://core.trac.wordpress.org/newticket\">WordPress Trac</a> if you are comfortable writing a reproducible bug report. You can also check your issue against a list of <a href=\"https://core.trac.wordpress.org/tickets/major\">known bugs</a>.</p>\n\n\n\n<p>Thank you to everyone who helps with testing!</p>\n\n\n\n<h3 class=\"wp-block-heading\">Update your theme or plugin</h3>\n\n\n\n<p>For plugin and theme authors, your products play an integral role in extending the functionality and value of WordPress for all users.</p>\n\n\n\n<p>Thanks for continuing to test your themes and plugins with the WordPress 6.9 beta releases. With RC1, you’ll want to conclude your testing and update the <em>“Tested up to”</em> version in your <a href=\"https://developer.wordpress.org/plugins/wordpress-org/how-your-readme-txt-works/\">plugin’s readme file</a> to 6.9. </p>\n\n\n\n<p>If you find compatibility issues, please post detailed information to the <a href=\"https://wordpress.org/support/forum/alphabeta/\">support forum</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Test on your hosting platforms</h3>\n\n\n\n<p>Web hosts provide vital infrastructure for supporting WordPress and its users. Testing on hosting systems helps inform the development process while ensuring that WordPress and hosting platforms are fully compatible, free of errors, optimized for the best possible user experience, and that updates roll out to customer sites without issue.</p>\n\n\n\n<p>Want to test WordPress on your hosting system? <a href=\"https://make.wordpress.org/hosting/test-results-getting-started/\">Get started with configuring distributed hosting tests here</a>. Thank you to all <a href=\"https://make.wordpress.org/hosting/test-results/\">web hosts who help test WordPress</a>!</p>\n\n\n\n<p>Curious about testing releases in general? Follow along with the <a href=\"https://make.wordpress.org/test/\">testing initiatives in Make Core</a> and join the <a href=\"https://wordpress.slack.com/messages/core-test/\">#core-test channel</a> on <a href=\"https://wordpress.slack.com/\">Making WordPress Slack</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">An RC1 haiku</h2>\n\n\n\n<p><em>As the sun rises</em>,</p>\n\n\n\n<p><em>RC1 breaks its cocoon</em></p>\n\n\n\n<p><em>and emerges strong</em>.</p>\n\n\n\n<p class=\"has-text-align-right\"><em>Props to </em><a href=\'https://profiles.wordpress.org/akshayar/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>akshayar</a><em>, </em><a href=\'https://profiles.wordpress.org/davidbaumwald/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>davidbaumwald</a>, <a href=\'https://profiles.wordpress.org/jeffpaul/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>jeffpaul</a>, <a href=\'https://profiles.wordpress.org/desrosj/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>desrosj</a>, <a href=\'https://profiles.wordpress.org/westonruter/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>westonruter</a>, <a href=\'https://profiles.wordpress.org/ellatrix/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>ellatrix</a>, <a href=\'https://profiles.wordpress.org/priethor/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>priethor</a>, <a href=\'https://profiles.wordpress.org/krupajnanda/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>krupajnanda</a> <em>and</em> <a href=\'https://profiles.wordpress.org/cbravobernal/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>cbravobernal</a> <em>for proofreading and review.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"19317\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:72:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 6.9 Beta 3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2025/11/wordpress-6-9-beta-3/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 04 Nov 2025 15:34:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:6:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:7:\"General\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:3:\"6.9\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:11:\"development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:5;a:5:{s:4:\"data\";s:7:\"release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=19263\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:347:\"WordPress 6.9 Beta 3 is available for download and testing! This beta version of the WordPress software is still under development. Please don&#8217;t install, run, or test this version of WordPress on production or mission-critical websites. Instead, you can evaluate Beta 3 on a test server and site. WordPress 6.9 Beta 3 can be tested [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Amy Kamala\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:5454:\"\n<p>WordPress 6.9 Beta 3 is available for download and testing!</p>\n\n\n\n<p><strong>This beta version of the WordPress software is still under development</strong>. Please don&#8217;t install, run, or test this version of WordPress on production or mission-critical websites. Instead, you can evaluate Beta 3 on a test server and site.</p>\n\n\n\n<p>WordPress 6.9 Beta 3 can be tested using any of the following methods:</p>\n\n\n\n<figure class=\"wp-block-table\"><table class=\"has-fixed-layout\"><tbody><tr><td><strong>Plugin</strong></td><td>Install and activate the<a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\"> WordPress Beta Tester</a> plugin on a WordPress install. (Select the “Bleeding edge” channel and “Beta/RC Only” stream.)</td></tr><tr><td><strong>Direct Download</strong></td><td>Download the <a href=\"https://wordpress.org/wordpress-6.9-beta3.zip\">Beta 3 version (zip)</a> and install it on a WordPress website.</td></tr><tr><td><strong>Command Line</strong></td><td>Use this<a href=\"https://make.wordpress.org/cli/\"> WP-CLI</a> command: <br><code>wp core update --version=6.9-beta3</code></td></tr><tr><td><strong>WordPress Playground</strong></td><td>Use the <a href=\"https://playground.wordpress.net/?php=8.0&amp;wp=beta&amp;networking=no&amp;language=&amp;multisite=no&amp;random=y4q1rn88xn\">6.9 Beta 3 WordPress Playground instance</a> to test the software directly in your browser.&nbsp; No setup is required – just click and go!&nbsp;</td></tr></tbody></table></figure>\n\n\n\n<p></p>\n\n\n\n<p>The final release of WordPress 6.9 is scheduled for <strong>December 2, 2025</strong>, and the <a href=\"https://make.wordpress.org/core/6-9/\">release schedule can be found here</a>. Your help testing Beta and RC versions is vital to making this release as stable and powerful as possible. Thank you to everyone who helps with testing!</p>\n\n\n\n<p>Please continue checking the <a href=\"https://make.wordpress.org/core/\">Make WordPress Core blog</a> for <a href=\"https://make.wordpress.org/core/tag/6-9/\">6.9-related posts</a> in the coming weeks for more information.</p>\n\n\n\n<p><strong>Find out what’s new in WordPress 6.9</strong>: Read the <a href=\"https://make.wordpress.org/core/2025/10/21/wordpress-6-9-beta-1/\">Beta 1 announcement</a> for details and highlights.</p>\n\n\n\n<h2 class=\"wp-block-heading\">How to test this release</h2>\n\n\n\n<p>Your help testing the WordPress 6.9 Beta 3 version is key to ensuring that everything in the release is the best it can be. While testing the upgrade process is essential, trying out new features is equally as important. This <a href=\"https://make.wordpress.org/test/2025/10/21/help-test-wordpress-6-9/\">detailed guide</a> provides a walk through on testing features in WordPress 6.9.</p>\n\n\n\n<p>If you encounter an issue, please report it to the <a href=\"https://wordpress.org/support/forum/alphabeta/\">Alpha/Beta area</a> of the support forums, or directly to <a href=\"https://core.trac.wordpress.org/newticket\">WordPress Trac</a> if you are comfortable writing a reproducible bug report. You can also check your issue against a list of <a href=\"https://core.trac.wordpress.org/tickets/major\">known bugs</a>.</p>\n\n\n\n<p>Curious about testing releases in general? Follow along with the <a href=\"https://make.wordpress.org/test/\">testing initiatives in Make Core</a> and join the<a href=\"https://wordpress.slack.com/messages/core-test/\"> #core-test channel</a> on<a href=\"https://wordpress.slack.com/\"> Making WordPress Slack</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Beta 3 updates and highlights</h2>\n\n\n\n<p>WordPress 6.9 Beta 3 contains more than 80 updates and fixes since the Beta 2 release.</p>\n\n\n\n<p>Each beta cycle focuses on bug fixes, and more are on the way with your testing! You can browse the technical details for all issues addressed since Beta 2 using these links:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://github.com/WordPress/gutenberg/commits/wp/6.9?since=2025-10-28&amp;until=2025-11-04\">Gutenberg commits for 6.9</a> since October 28, 2025</li>\n\n\n\n<li><a href=\"https://core.trac.wordpress.org/query?status=closed&amp;changetime=10%2F28%2F2025..11%2F04%2F2025&amp;milestone=6.9&amp;col=id&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=id\">Closed Core Trac tickets for 6.9</a> since October 28, 2025</li>\n\n\n\n<li><a href=\"https://github.com/WordPress/wordpress-develop/compare/7dcb09c26a1d97c20dcceb866abbd0f3c128388b...81f755846c2d66ce7d21b01623f8163a9f7c6ef6\">Comparing commit changes in Core for 6.9</a> since October 28, 2025</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">A Beta 3 haiku</h2>\n\n\n\n<p><em>Code is poetry,</em></p>\n\n\n\n<p><em>and poetry is magic.</em></p>\n\n\n\n<p><em>So code is magic.</em></p>\n\n\n\n<p class=\"has-text-align-right\"><em>Props to </em><a href=\'https://profiles.wordpress.org/akshayar/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>akshayar</a> <em>, </em><a href=\'https://profiles.wordpress.org/jeffpaul/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>jeffpaul</a>, <a href=\'https://profiles.wordpress.org/krupajnanda/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>krupajnanda</a>, <a href=\'https://profiles.wordpress.org/mosescursor/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>mosescursor</a>,  <em>and</em> <a href=\'https://profiles.wordpress.org/westonruter/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>westonruter</a> <em>for proofreading and review.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"19263\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:69:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 6.9 Beta 2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2025/10/wordpress-6-9-beta-2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 28 Oct 2025 15:23:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:5:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"6-9\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:11:\"development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:7:\"release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=19253\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:334:\"WordPress 6.9 Beta 2 is now ready for testing! This beta version of the WordPress software is under development. Please do not install, run, or test this version of WordPress on production or mission-critical websites.&#160; Instead, you should evaluate Beta 2 on a test server and site. You can test WordPress 6.9 Beta 2 in [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Akshaya Rane\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:5125:\"\n<p>WordPress 6.9 Beta 2 is now ready for testing!</p>\n\n\n\n<p><strong>This beta version of the WordPress software is under development</strong>. Please do not install, run, or test this version of WordPress on production or mission-critical websites.&nbsp; Instead, you should evaluate Beta 2 on a test server and site.</p>\n\n\n\n<p>You can test WordPress 6.9 Beta 2 in any of the following ways:<br></p>\n\n\n\n<figure class=\"wp-block-table\"><table class=\"has-fixed-layout\"><tbody><tr><td><strong>Plugin</strong></td><td>Install and activate the<a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\"> WordPress Beta Tester</a> plugin on a WordPress install. (Select the “Bleeding edge” channel and “Beta/RC Only” stream.)</td></tr><tr><td><strong>Direct Download</strong></td><td>Download the <a href=\"https://wordpress.org/wordpress-6.9-beta2.zip\">Beta 2 version (zip)</a> and install it on a WordPress website.</td></tr><tr><td><strong>Command Line</strong></td><td>Use this<a href=\"https://make.wordpress.org/cli/\"> WP-CLI</a> command: <br><code>wp core update --version=6.9-beta2</code></td></tr><tr><td><strong>WordPress Playground</strong></td><td>Use the <a href=\"https://playground.wordpress.net/?php=8.0&amp;wp=beta&amp;networking=no&amp;language=&amp;multisite=no&amp;random=y4q1rn88xn\">6.9 Beta 2 WordPress Playground instance</a> to test the software directly in your browser.&nbsp; No setup is required–just click and go!&nbsp;</td></tr></tbody></table></figure>\n\n\n\n<p>The scheduled final release date for WordPress 6.9 is <strong>December 2, 2025</strong>. &nbsp;The full <a href=\"https://make.wordpress.org/core/6-9/\">release schedule can be found here</a>. Your help testing Beta and RC versions is vital to making this release as stable and powerful as possible. Do check the<a href=\"https://make.wordpress.org/core/\"> Make WordPress Core blog</a> for <a href=\"https://make.wordpress.org/core/tag/6-9/\">6.9-related posts</a> in the coming weeks for more information. Thank you to everyone who contributes by testing!&nbsp;</p>\n\n\n\n<p><strong>Catch up on what’s new in WordPress 6.9</strong>: Read the <a href=\"https://make.wordpress.org/core/2025/10/21/wordpress-6-9-beta-1/\">Beta 1 announcement</a> for details and highlights.</p>\n\n\n\n<h2 class=\"wp-block-heading\">How to test this release</h2>\n\n\n\n<p>Your help testing the WordPress 6.9 Beta 2 version is key to ensuring everything in the release is the best it can be. While testing the upgrade process is essential, trying out new features is equally important.&nbsp; This <a href=\"https://make.wordpress.org/test/2025/10/21/help-test-wordpress-6-9/\">detailed guide</a> will walk you through testing features in WordPress 6.9.</p>\n\n\n\n<p>If you encounter an issue, please report it to the<a href=\"https://wordpress.org/support/forum/alphabeta/\"> Alpha/Beta area</a> of the support forums or directly to<a href=\"https://core.trac.wordpress.org/newticket\"> WordPress Trac</a> if you are comfortable writing a reproducible bug report. You can also check your issue against a list of<a href=\"https://core.trac.wordpress.org/tickets/major\"> known bugs</a>.</p>\n\n\n\n<p>Curious about testing releases in general? Follow along with the<a href=\"https://make.wordpress.org/test/\"> testing initiatives in Make Core</a> and join the<a href=\"https://wordpress.slack.com/messages/core-test/\"> #core-test channel</a> on<a href=\"https://wordpress.slack.com/\"> Making WordPress Slack</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Beta 2 updates and highlights</h2>\n\n\n\n<p>WordPress 6.9 Beta 2 contains more than 33 Editor updates and fixes since the Beta 1 release, including 28 tickets for WordPress core.</p>\n\n\n\n<p>Each beta cycle focuses on bug fixes; more are on the way with your help through testing. You can browse the technical details for all issues addressed since Beta 1 using these links:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://github.com/WordPress/gutenberg/commits/wp/6.9?since=2025-10-22&amp;until=2025-10-28\">GitHub commits for 6.9</a> since October 21, 2025</li>\n\n\n\n<li><a href=\"https://core.trac.wordpress.org/query?status=closed&amp;changetime=10%2F22%2F2025..10%2F28%2F2025&amp;milestone=6.9&amp;col=id&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=id\">Closed Trac tickets</a> since October 21, 2025</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">A Beta 2 haiku</h2>\n\n\n\n<p><em>Morning dew returns,</em></p>\n\n\n\n<p><em>Small fixes bloom in silence—</em></p>\n\n\n\n<p><em>Code finds its balance.</em></p>\n\n\n\n<p class=\"has-text-align-right\"><em>Props to <a href=\'https://profiles.wordpress.org/davidbaumwald/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>davidbaumwald</a>, <a href=\'https://profiles.wordpress.org/wildworks/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>wildworks</a> , <a href=\'https://profiles.wordpress.org/krupajnanda/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>krupajnanda</a> &amp; <a href=\'https://profiles.wordpress.org/mosescursor/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>mosescursor</a></em> <em>for proofreading and review.</em></p>\n\n\n\n<p></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"19253\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:63:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"WordPress 6.8.3 Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://wordpress.org/news/2025/09/wordpress-6-8-3-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 30 Sep 2025 19:31:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:14:\"minor-releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:8:\"releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=19204\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:372:\"WordPress 6.8.3 is now available! This is a security release that features two fixes. Because this is a security release, it is recommended that you update your sites immediately. You can download WordPress 6.8.3 from WordPress.org, or visit your WordPress Dashboard, click “Updates”, and then click “Update Now”. If you have sites that support automatic [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"John Blackbourn\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4937:\"\n<p><strong>WordPress 6.8.3 is now available!</strong></p>\n\n\n\n<p>This is a security release that features two fixes.</p>\n\n\n\n<p>Because this is a security release,<strong> it is recommended that you update your sites immediately</strong>.</p>\n\n\n\n<p>You can <a href=\"https://wordpress.org/wordpress-6.8.3.zip\">download WordPress 6.8.3 from WordPress.org</a>, or visit your WordPress Dashboard, click “Updates”, and then click “Update Now”. If you have sites that support automatic background updates, the update process will begin automatically.</p>\n\n\n\n<p>The next major release will be <a href=\"https://make.wordpress.org/core/6-9/\">version 6.9</a>, which is planned for December 2nd, 2025.<br>For more information on WordPress 6.8.3, please visit the <a href=\"https://wordpress.org/documentation/wordpress-version/version-6-8-3/\">version page on the HelpHub site</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Security updates included in this release</h2>\n\n\n\n<p>The security team would like to thank the following people for <a href=\"https://hackerone.com/wordpress?type=team\">responsibly reporting vulnerabilities</a>, and allowing them to be fixed in this release:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>A data exposure issue where authenticated users could access some restricted content. Independently reported by <a href=\"https://hackerone.com/mnelson4\">Mike Nelson</a>, <a href=\"https://hackerone.com/hurayraiit\">Abu Hurayra</a>, <a href=\"https://profiles.wordpress.org/timothyblynjacobs/\">Timothy Jacobs</a>, and <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a>.</li>\n\n\n\n<li>A cross-site scripting (XSS) vulnerability requiring an authenticated user role that affects the nav menus. Reported by <a href=\"https://x.com/Savphill\">Phill Savage</a>.</li>\n</ul>\n\n\n\n<p>As a courtesy, these fixes have also been made available to all branches eligible to receive security fixes (currently through 4.7). As a reminder, <strong>only the most recent version of WordPress is actively supported</strong>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Thank you to these WordPress contributors</h2>\n\n\n\n<p>This release was led by <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a>.</p>\n\n\n\n<p>In addition to the security researchers and release squad members mentioned above, WordPress 6.8.3 would not have been possible without the contributions of the following people:</p>\n\n\n\n<p><a href=\"https://profiles.wordpress.org/jorbin\">Aaron Jorbin</a>, <a href=\"https://profiles.wordpress.org/hurayraiit\">Abu Hurayra</a>, <a href=\"https://profiles.wordpress.org/zieladam\">Adam Zieliński</a>, <a href=\"https://profiles.wordpress.org/xknown\">Alex Concha</a>, <a href=\"https://profiles.wordpress.org/andraganescu%20\">Andrei Draganescu</a>, <a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a>, <a href=\"https://profiles.wordpress.org/ehtis\">Ehtisham Siddiqui</a>, <a href=\"https://profiles.wordpress.org/iandunn\">Ian Dunn</a>, <a href=\"https://profiles.wordpress.org/whyisjake\">Jake Spurlock</a>, <a href=\"https://profiles.wordpress.org/audrasjb\">Jb Audras</a>, <a href=\"https://profiles.wordpress.org/joehoyle\">Joe Hoyle</a>, <a href=\"https://profiles.wordpress.org/johnbillion\">John Blackbourn</a>, <a href=\"https://profiles.wordpress.org/jonsurrell\">Jon Surrell</a>, <a href=\"https://profiles.wordpress.org/desrosj\">Jonathan Desrosiers</a>, <a href=\"https://profiles.wordpress.org/mnelson4\">Michael Nelson</a>, <a href=\"https://profiles.wordpress.org/peterwilsoncc\">Peter Wilson</a>, <a href=\"https://profiles.wordpress.org/phillsav\">Phill</a>, <a href=\"https://profiles.wordpress.org/noisysocks\">Robert Anderson</a>, <a href=\"https://profiles.wordpress.org/rmccue\">Ryan McCue</a>, <a href=\"https://profiles.wordpress.org/coffee2code/\">Scott Reilly</a>, <a href=\"https://profiles.wordpress.org/timothyblynjacobs\">Timothy Jacobs</a>, <a href=\"https://profiles.wordpress.org/vortfu\">vortfu</a>, <a href=\"https://profiles.wordpress.org/westonruter\">Weston Ruter</a></p>\n\n\n\n<h2 class=\"wp-block-heading\">How to contribute</h2>\n\n\n\n<p>To get involved in WordPress core development, head over to Trac, <a href=\"https://core.trac.wordpress.org/report/6\">pick a ticket</a>, and join the conversation in the <a href=\"https://app.slack.com/client/T024MFP4J/C02RQBWTW\">#core</a> Slack channel. Need help? Check out the <a href=\"https://make.wordpress.org/core/handbook/tutorials/faq-for-new-contributors/\">Core Contributor Handbook</a>.</p>\n\n\n\n<p>Props to <a href=\"https://profiles.wordpress.org/ehtis/\">Ehtisham Siddiqui</a>, <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a>, <a href=\"https://profiles.wordpress.org/paulkevan/\">Paul Kevan</a>, <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a>, <a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a>, <a href=\"https://profiles.wordpress.org/westonruter\">Weston Ruter</a> for reviewing.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"19204\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:63:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"Portland Welcomes WordCamp US 2025: A Community Gathering\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"https://wordpress.org/news/2025/08/portland-welcomes-wcus-2025/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 30 Aug 2025 03:03:52 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:6:\"Events\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:7:\"General\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:8:\"WordCamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=19074\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:405:\"A full house of attendees gathered in Portland, Oregon, for WordCamp US 2025, with thousands more tuning in online. Over four days, the flagship WordPress event brought together contributors, innovators, and community members for collaboration, inspiration, and discovery. WordPress is so unique because we&#8217;re not just a product; we&#8217;re a movement. Matt Mullenweg, WordPress Cofounder [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Brett McSherry\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:69049:\"\n\n\n<p>A full house of attendees gathered in Portland, Oregon, for WordCamp US 2025, with thousands more tuning in online. Over four days, the flagship WordPress event brought together contributors, innovators, and community members for collaboration, inspiration, and discovery.</p>\n\n\n\n<div class=\"wp-block-group is-nowrap is-layout-flex wp-container-core-group-is-layout-6c531013 wp-block-group-is-layout-flex\">\n<figure class=\"wp-block-pullquote\"><blockquote><p>WordPress is so unique because we&#8217;re not just a product; we&#8217;re a movement.</p><cite>Matt Mullenweg, WordPress Cofounder</cite></blockquote></figure>\n</div>\n\n\n\n<p>The WordPress event began with a dedicated Contributor Day and continued with a Showcase Day and two days of sessions filled with talks, panels, workshops, and community celebrations. WordPress Cofounder Matt Mullenweg joined a diverse lineup of speakers, panelists, and workshop leaders who brought fresh perspectives to the open web from across the globe.</p>\n\n\n\n<p>Set against the vibrant backdrop of Portland — with its iconic bridges, coffee culture, and creative energy — the Sponsor Hall buzzed as companies across the WordPress ecosystem demoed new products, shared insights, and connected with attendees. Each day offered opportunities to refuel with local flavors and international favorites, turning mealtimes into lively hubs of networking and idea-sharing.</p>\n\n\n\n<h2 class=\"wp-block-heading\">A Global Gathering in Portland</h2>\n\n\n\n<p>WordCamp US is the annual gathering point for the WordPress community — where collaboration, creativity, and innovation intersect. This year in Portland, the event delivered an expansive program that reached every corner of the ecosystem.</p>\n\n\n\n<p>Here’s what attendees experienced:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Engaging Sessions Across Tracks</strong> – Keynotes, presentations, and discussions explored the evolving web and the role of open source in shaping it.</li>\n\n\n\n<li><strong>A Global Speaker Lineup</strong> – Voices from across continents brought local stories and global visions to the stage.</li>\n\n\n\n<li><strong>Wide-Ranging Topics</strong> – From AI in WordPress development to accessibility, design systems, content strategy, education, and case studies of WordPress at scale.</li>\n\n\n\n<li><strong>Hands-On Learning Opportunities</strong> – Workshops provided practical takeaways, empowering attendees to apply new skills immediately.</li>\n\n\n\n<li><strong>A Community Built on Collaboration</strong> – Whether contributing code, exploring business strategies, or sharing creative projects, attendees found space to learn, grow, and celebrate open source together.</li>\n</ul>\n\n\n\n<p>New contributors took their first steps into open source, seasoned developers explored cutting-edge AI integrations, and agencies and product teams shared strategies for scaling WordPress to meet modern needs. Beyond the technical, conversations around inclusivity, sustainability, and education underscored WordPress’s role as a tool for empowerment and positive change.</p>\n\n\n\n<p>In hallways, coffee lines, and evening meetups, attendees found the “hallway track” alive and well, spontaneous moments of connection that often became the most memorable part of the experience. Whether reconnecting with longtime collaborators or meeting someone new, these small interactions reinforced the heart of WordCamp US: a community that thrives on openness, generosity, and shared purpose.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Contributor Day: Collaboration at the Core</h2>\n\n\n\n<p>The conference opened on Tuesday, August 26, with a vibrant Contributor Day. Nearly 300 contributors filled the space, including more than 120 first-time participants who were onboarded across 19 teams. Developers, designers, translators, marketers, and community organizers worked side by side, representing WordPress expertise.</p>\n\n\n\n<p>Throughout the day, contributors tackled everything from improving accessibility and performance to refining documentation to enhancing translation tools. Beyond technical contributions, teams like Marketing and Community focused on outreach, mentoring, and shaping future-facing initiatives. Remote participants joined via dedicated channels, reinforcing the inclusive nature of WordPress’s global community. By day’s end, the collective energy was clear: WordPress continues to be built by and for everyone.</p>\n\n\n\n<figure class=\"wp-block-gallery has-nested-images columns-default is-cropped has-black-background-color has-background wp-block-gallery-1 is-layout-flex wp-block-gallery-is-layout-flex\" style=\"border-width:20px;border-radius:2px\">\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;6968606e969d2&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"6968606e969d2\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on--click=\"actions.showLightbox\" data-wp-on--load=\"callbacks.setButtonStyles\" data-wp-on--pointerdown=\"actions.preloadImage\" data-wp-on--pointerenter=\"actions.preloadImageWithDelay\" data-wp-on--pointerleave=\"actions.cancelPreload\" data-wp-on-window--resize=\"callbacks.setButtonStyles\" data-id=\"19080\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5641.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-19080\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5641-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5641-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5641-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5641-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5641-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;6968606e971af&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"6968606e971af\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on--click=\"actions.showLightbox\" data-wp-on--load=\"callbacks.setButtonStyles\" data-wp-on--pointerdown=\"actions.preloadImage\" data-wp-on--pointerenter=\"actions.preloadImageWithDelay\" data-wp-on--pointerleave=\"actions.cancelPreload\" data-wp-on-window--resize=\"callbacks.setButtonStyles\" data-id=\"19081\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5630.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-19081\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5630-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5630-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5630-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5630-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5630-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;6968606e979cf&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"6968606e979cf\" class=\"wp-block-image size-large wp-lightbox-container\"><img loading=\"lazy\" decoding=\"async\" width=\"1707\" height=\"2560\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on--click=\"actions.showLightbox\" data-wp-on--load=\"callbacks.setButtonStyles\" data-wp-on--pointerdown=\"actions.preloadImage\" data-wp-on--pointerenter=\"actions.preloadImageWithDelay\" data-wp-on--pointerleave=\"actions.cancelPreload\" data-wp-on-window--resize=\"callbacks.setButtonStyles\" data-id=\"19087\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8717-2-scaled.jpg?fit=683%2C1024&amp;ssl=1\" alt=\"\" class=\"wp-image-19087\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8717-2-scaled.jpg?w=1707&amp;ssl=1 1707w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8717-2-scaled.jpg?resize=200%2C300&amp;ssl=1 200w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8717-2-scaled.jpg?resize=683%2C1024&amp;ssl=1 683w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8717-2-scaled.jpg?resize=768%2C1152&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8717-2-scaled.jpg?resize=1024%2C1536&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8717-2-scaled.jpg?resize=1365%2C2048&amp;ssl=1 1365w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;6968606e9817a&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"6968606e9817a\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on--click=\"actions.showLightbox\" data-wp-on--load=\"callbacks.setButtonStyles\" data-wp-on--pointerdown=\"actions.preloadImage\" data-wp-on--pointerenter=\"actions.preloadImageWithDelay\" data-wp-on--pointerleave=\"actions.cancelPreload\" data-wp-on-window--resize=\"callbacks.setButtonStyles\" data-id=\"19084\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/Z633022.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-19084\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/Z633022-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633022-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633022-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633022-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633022-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;6968606e98911&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"6968606e98911\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on--click=\"actions.showLightbox\" data-wp-on--load=\"callbacks.setButtonStyles\" data-wp-on--pointerdown=\"actions.preloadImage\" data-wp-on--pointerenter=\"actions.preloadImageWithDelay\" data-wp-on--pointerleave=\"actions.cancelPreload\" data-wp-on-window--resize=\"callbacks.setButtonStyles\" data-id=\"19082\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5634.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-19082\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5634-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5634-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5634-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5634-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5634-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;6968606e9909a&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"6968606e9909a\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on--click=\"actions.showLightbox\" data-wp-on--load=\"callbacks.setButtonStyles\" data-wp-on--pointerdown=\"actions.preloadImage\" data-wp-on--pointerenter=\"actions.preloadImageWithDelay\" data-wp-on--pointerleave=\"actions.cancelPreload\" data-wp-on-window--resize=\"callbacks.setButtonStyles\" data-id=\"19085\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/Z632926.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-19085\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/Z632926-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z632926-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z632926-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z632926-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z632926-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;6968606e99828&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"6968606e99828\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on--click=\"actions.showLightbox\" data-wp-on--load=\"callbacks.setButtonStyles\" data-wp-on--pointerdown=\"actions.preloadImage\" data-wp-on--pointerenter=\"actions.preloadImageWithDelay\" data-wp-on--pointerleave=\"actions.cancelPreload\" data-wp-on-window--resize=\"callbacks.setButtonStyles\" data-id=\"19086\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/Z633226-1.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-19086\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/Z633226-1-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633226-1-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633226-1-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633226-1-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633226-1-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;6968606e99fe4&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"6968606e99fe4\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on--click=\"actions.showLightbox\" data-wp-on--load=\"callbacks.setButtonStyles\" data-wp-on--pointerdown=\"actions.preloadImage\" data-wp-on--pointerenter=\"actions.preloadImageWithDelay\" data-wp-on--pointerleave=\"actions.cancelPreload\" data-wp-on-window--resize=\"callbacks.setButtonStyles\" data-id=\"19090\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/Z633121.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-19090\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/Z633121-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633121-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633121-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633121-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633121-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;6968606e9a7d8&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"6968606e9a7d8\" class=\"wp-block-image size-large wp-lightbox-container\"><img loading=\"lazy\" decoding=\"async\" width=\"2560\" height=\"1707\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on--click=\"actions.showLightbox\" data-wp-on--load=\"callbacks.setButtonStyles\" data-wp-on--pointerdown=\"actions.preloadImage\" data-wp-on--pointerenter=\"actions.preloadImageWithDelay\" data-wp-on--pointerleave=\"actions.cancelPreload\" data-wp-on-window--resize=\"callbacks.setButtonStyles\" data-id=\"19089\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8723-scaled.jpg?fit=1024%2C683&amp;ssl=1\" alt=\"\" class=\"wp-image-19089\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8723-scaled.jpg?w=2560&amp;ssl=1 2560w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8723-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8723-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8723-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8723-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8723-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;6968606e9af81&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"6968606e9af81\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on--click=\"actions.showLightbox\" data-wp-on--load=\"callbacks.setButtonStyles\" data-wp-on--pointerdown=\"actions.preloadImage\" data-wp-on--pointerenter=\"actions.preloadImageWithDelay\" data-wp-on--pointerleave=\"actions.cancelPreload\" data-wp-on-window--resize=\"callbacks.setButtonStyles\" data-id=\"19092\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8841.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-19092\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8841-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8841-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8841-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8841-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8841-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;6968606e9b875&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"6968606e9b875\" class=\"wp-block-image size-large wp-lightbox-container\"><img loading=\"lazy\" decoding=\"async\" width=\"2560\" height=\"1707\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on--click=\"actions.showLightbox\" data-wp-on--load=\"callbacks.setButtonStyles\" data-wp-on--pointerdown=\"actions.preloadImage\" data-wp-on--pointerenter=\"actions.preloadImageWithDelay\" data-wp-on--pointerleave=\"actions.cancelPreload\" data-wp-on-window--resize=\"callbacks.setButtonStyles\" data-id=\"19088\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8753-1-scaled.jpg?fit=1024%2C683&amp;ssl=1\" alt=\"\" class=\"wp-image-19088\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8753-1-scaled.jpg?w=2560&amp;ssl=1 2560w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8753-1-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8753-1-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8753-1-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8753-1-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8753-1-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;6968606e9c0e9&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"6968606e9c0e9\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on--click=\"actions.showLightbox\" data-wp-on--load=\"callbacks.setButtonStyles\" data-wp-on--pointerdown=\"actions.preloadImage\" data-wp-on--pointerenter=\"actions.preloadImageWithDelay\" data-wp-on--pointerleave=\"actions.cancelPreload\" data-wp-on-window--resize=\"callbacks.setButtonStyles\" data-id=\"19091\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8827.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-19091\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8827-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8827-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8827-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8827-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8827-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;6968606e9c8c5&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"6968606e9c8c5\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on--click=\"actions.showLightbox\" data-wp-on--load=\"callbacks.setButtonStyles\" data-wp-on--pointerdown=\"actions.preloadImage\" data-wp-on--pointerenter=\"actions.preloadImageWithDelay\" data-wp-on--pointerleave=\"actions.cancelPreload\" data-wp-on-window--resize=\"callbacks.setButtonStyles\" data-id=\"19083\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8887-2.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-19083\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8887-2-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8887-2-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8887-2-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8887-2-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8887-2-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n</figure>\n\n\n\n<p>The mix of experience in the room made this year especially notable. First-time contributors were paired with seasoned table leads who guided them through their first steps into open source contribution. Longtime contributors reconnected with their teams and advanced ongoing initiatives, while new voices added fresh perspectives and momentum. The spirit of mentorship was woven throughout, ensuring that Contributor Day was productive and welcoming.</p>\n\n\n\n<p>The results spoke for themselves:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Polyglots</strong> translated more than 12,000 strings, expanding WordPress’s accessibility worldwide.</li>\n\n\n\n<li>The <strong>Community team</strong> celebrated the approval of two brand-new local meetups.</li>\n\n\n\n<li>The <strong>Training team</strong> achieved its objective of updating outdated course thumbnails.</li>\n\n\n\n<li>The <strong>Core team</strong> worked through a live bug scrub, with 9 committers and 16 contributors collaborating on improvements.</li>\n\n\n\n<li>The <strong>Documentation team</strong> completed numerous content updates to keep resources fresh and reliable.</li>\n</ul>\n\n\n\n<p>Momentum carried through every table, with participants reporting measurable progress and a renewed sense of shared purpose. Contributor Day once again highlighted the unique power of collaboration in shaping the open web, proving that every contribution matters through code, translations, training, or community building.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Showcase Day: WordPress in Action</h2>\n\n\n\n<p>Wednesday, August 27, was the popular Showcase Day, spotlighting real-world innovation in WordPress. Initially expected to draw about 250 participants, Showcase Day welcomed more than 800 attendees — a powerful sign of how much energy and curiosity the community brought to Portland. The sessions demonstrated how WordPress powers meaningful work across industries from nonprofits to newsrooms, agencies to global enterprises, while staying true to open source values.</p>\n\n\n\n<p>The day opened with a keynote by Amy Sample Ward: <em>The Tech That Comes Next</em>. Drawing from their co-authored book with Afua Bruce, Amy highlighted the inequities embedded in today’s technologies — from dataset bias to accessibility gaps — and challenged attendees to rethink how tools are funded, built, and deployed. Their talk invited technologists, funders, and community leaders to imagine a more equitable digital future, rooted in collaboration and shared responsibility.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n<iframe loading=\"lazy\" title=\"WordCamp US 2025 - Amy Sample Ward &quot;The Tech That Comes Next&quot;\" width=\"500\" height=\"281\" src=\"https://www.youtube.com/embed/RKnM75GFZxw?feature=oembed\" frameborder=\"0\" allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share\" referrerpolicy=\"strict-origin-when-cross-origin\" allowfullscreen></iframe>\n</div></figure>\n\n\n\n<p>From there, <a href=\"https://youtu.be/PGvh7fCOUk0\">Joeleen Kennedy</a> of Human Made shared how Full Site Editing (FSE) shapes the refresh of Wikimedia’s ongoing user experience. Her session <em>Modernizing at Scale</em> detailed how FSE is simplifying workflows, improving accessibility, and making the multilingual platform more sustainable for the long term. Attendees gained a behind-the-scenes look at how one of the world’s largest open knowledge platforms is leveraging WordPress innovation.</p>\n\n\n\n<p><a href=\"https://youtu.be/F4NEPcwGRCI\">Josh Bryant</a> took the stage to explore what happens when Gutenberg leaves the WP-Admin dashboard. His talk, <em>Reimagining WordPress Editing</em>, walked through embedding the block editor into a standalone React application to support Dow Jones’s newsroom workflows. From decoupling Gutenberg to managing custom data stores, the session showcased advanced techniques for scaling editorial tools while maintaining the flexibility of the WordPress ecosystem.</p>\n\n\n\n<p>Hands-on learning was a hallmark of Showcase Day, with Jamie Marsland’s workshop leading participants through building and launching their own professional portfolio sites — no coding required. Attendees left with a fully functioning site, demonstrating WordPress’s continued ability to empower anyone, anywhere, to publish online.</p>\n\n\n\n<p>In the afternoon, Jeffrey Paul’s session <em>Scalable, Ethical AI</em> addressed one of the most pressing topics in today’s digital world: how to integrate AI without sacrificing ownership, privacy, or open standards. Walking participants through practical use cases with ClassifAI and local LLMs, Paul emphasized how WordPress can help content creators harness AI while maintaining autonomy over their data.</p>\n\n\n\n<p>The day closed with a forward-looking community highlight: <a href=\"https://events.wordpress.org/campusconnect/\">WordPress Campus Connect</a>. Panelists <a href=\"https://youtu.be/ARqM9U0ESvo\">Destiny Kanno, Andrés Parra, Javier Montes de Blas, Mauricio Barrantes, and Elineth Morera Campos</a> shared how this initiative brings WordPress into classrooms and universities worldwide. Student Andrés Parra received a scholarship to attend WordCamp. During the panel, Elineth also announced that Fidélitas University will begin offering its students a <a href=\"https://wordpress.org/news/2025/07/introducing-wordpress-credits-a-new-contribution-internship-program-for-university-students/\">WordPress Credits</a> program starting in October 2025, making it a mandatory addition sometime in 2026, enabling them to contribute directly to WordPress as part of their studies.</p>\n\n\n\n<p>By connecting students and educators with the open web, Campus Connect is building the next generation of contributors and innovators, ensuring that WordPress remains both a learning tool and a pathway to opportunity.</p>\n\n\n\n<p>Taken together, Showcase Day affirmed that WordPress is more than just a CMS — it is a platform for equitable technology, global collaboration, cutting-edge enterprise solutions, and the future of digital education. WordPress has the power to be both a platform and a community tool for education, equity, and innovation.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Presentation Days: Learning, Inspiration, and Connection</h2>\n\n\n\n<p>The first full day of sessions at WordCamp US 2025 opened with warm remarks from the organizing team, who reminded attendees: <em>“The most important thanks goes to all of you. The mix of new energy and veteran experience is what makes WordCamp so special, so thank you for being here.”</em> That spirit of gratitude and community carried throughout the event.</p>\n\n\n\n<p>The Sponsor Hall became a hub of activity, complete with raffles, the return of Career Corner, and even a Voodoo Donut Truck parked outside. Attendees lined up to test their luck at a claw machine stuffed with plush Wapuus, while others sought guidance at the Happiness Bar — a hands-on help desk for WordPress questions big and small. Between these activities, the steady buzz of conversations made it clear: the “hallway track” remained one of WordCamp’s most valuable experiences.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n<iframe loading=\"lazy\" title=\"WordCamp US - Danny Sullivan &quot;How (and why!) Google Search Keeps Evolving&quot;\" width=\"500\" height=\"281\" src=\"https://www.youtube.com/embed/ZF_sxLdfTbY?feature=oembed\" frameborder=\"0\" allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share\" referrerpolicy=\"strict-origin-when-cross-origin\" allowfullscreen></iframe>\n</div></figure>\n\n\n\n<p>The program itself set a high bar. Danny Sullivan’s keynote shed light on how search has evolved to meet the needs of new generations, from 24/7 demand and mobile expectations to short-form video and AI. His session gave attendees a deeper understanding of how search intersects with publishing today and sparked conversations about how WordPress can continue adapting in an era where AI shapes discovery and content.</p>\n\n\n\n<p>From there, the schedule unfolded across multiple tracks. The Core AI panel — featuring <a href=\"https://youtu.be/v_0O6dQ4Q4E\">James LePage, Felix Arntz, and Jeffrey Paul</a> — offered a look into how AI tools are woven into WordPress core. Emphasizing ethics, transparency, and user empowerment, the panel painted a roadmap for how WordPress can adopt new technologies without compromising its open-source values.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"576\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/Programming-Day-1-2.jpg?resize=1024%2C576&#038;ssl=1\" alt=\"\" class=\"wp-image-19103\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/Programming-Day-1-2.jpg?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/Programming-Day-1-2.jpg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/Programming-Day-1-2.jpg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/Programming-Day-1-2.jpg?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/Programming-Day-1-2.jpg?w=1600&amp;ssl=1 1600w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /></figure>\n\n\n\n<p>Hands-on learning played a significant role throughout the conference. Ryan Welcher’s interactive <em>Block Developer Cookbook</em> drew a packed room as participants worked through community-selected code recipes built on the latest WordPress APIs. By the end, attendees left with working examples and practical strategies they could bring back to their projects.</p>\n\n\n\n<p>The program also highlighted diverse technical perspectives. <a href=\"https://youtu.be/vBjNqdacbh4\">Jemima Abu’s</a> session, <em>A PHP Developer’s Guide to ReactJS</em>, bridged the gap between classic and modern web development. At the same time, Adam Gazzaley’s keynote, <em>A New Era of Experiential Medicine – AI and the Brain</em>, invited attendees to consider the human side of technology, exploring how digital tools can advance health and well-being.</p>\n\n\n\n<p>The second day of presentations, Friday, August 29, opened with creativity and imagination. <a href=\"https://youtu.be/O7FPiFpRI3o\">John Maeda’s</a> keynote, <em>Cozy AI Cooking: WordCamp Edition</em>, used the metaphor of a kitchen to demystify AI, blending storytelling with technical insight to show how curiosity and care can guide builders in integrating AI into their work.</p>\n\n\n\n<p>Later in the day, <a href=\"https://youtu.be/ORnJTpjA-4w\">Tammie Lister’s</a> <em>The System is the Strategy</em> illustrated how design systems provide structure and scalability for growing WordPress projects. At the same time, Adam Silverstein’s Unlock Developer Superpowers with AI showcased new ways developers can use emerging tools to speed up workflows and problem-solving.</p>\n\n\n\n<p>Community stories also took center stage. In Creators around a Campfire, Anne McCarthy, Jamie Marsland, Christian Taylor, Mark Szymanski, and Michael Cunningham reflected on how YouTubers and content creators shape the WordPress ecosystem. Their session highlighted the role of storytelling and education in expanding WordPress’s reach to new audiences worldwide.</p>\n\n\n\n<p>The Sponsor Hall remained lively between sessions — with attendees meeting companies, testing demos, and swapping ideas that extended far beyond the conference halls. They also shared moments together at the arcade built for the event and added smiles, hugs, and laughter, which underscored the atmosphere: WordCamp US was as much about connection as code.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Together Into the Future</h2>\n\n\n\n<p>As the event drew to a close, WordPress Cofounder Matt Mullenweg took the stage to share the current state of WordPress and a vision for its future. He highlighted the growth in social media for WordPress with 124,726 new followers since last WCUS — and the WordPress.org website growing over 10% in users along with almost 20% in new users. </p>\n\n\n\n<p>Matt also spotlighted community initiatives shaping the future of open source education and diversity: WordPress Campus Connect, which has already reached 570 students across 11 events. Combined with the growth in overall events (77) which is a 32.76% increase over 2024. Each effort reinforced the message that WordPress is more than software; it is a global movement driven by people.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n<iframe loading=\"lazy\" title=\"WordCamp US 2025 - Ma.tt Mullenweg &quot;Keynote Address &amp; Q&amp;A&quot;\" width=\"500\" height=\"281\" src=\"https://www.youtube.com/embed/45HRzzc0waU?feature=oembed\" frameborder=\"0\" allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share\" referrerpolicy=\"strict-origin-when-cross-origin\" allowfullscreen></iframe>\n</div></figure>\n\n\n\n<p>He concluded with a live Q&amp;A, fielding questions from the audience on the direction of WordPress, its role in an AI-driven web, and the importance of keeping the project open, inclusive, and adaptable. The final notes of the keynote carried into a closing party in downtown Portland, where attendees capped off the week with music, conversation, and the unmistakable joy of a community coming together.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Closing</h2>\n\n\n\n<p>WordCamp US 2025 once again demonstrated what makes the WordPress ecosystem extraordinary: a community committed to building tools, resources, and opportunities that empower people everywhere.</p>\n\n\n\n<p>This year also marked the debut of the <a href=\"https://airtable.com/appWF6hdXuEOFQMvV/shrV5RZIv0aJjjU00\">Open Horizons Scholarship</a>, which funded six recipients — two organizers, three volunteers, and one speaker — from five countries. A total of $14,670 supported their journeys to WCUS. The scholarship, which also supports participation at WordCamp Asia and WordCamp Europe, is designed to make flagship events more accessible to contributors worldwide.</p>\n\n\n\n<p>A heartfelt thank you goes to the organizers, volunteers, sponsors, and speakers who brought the Portland edition to life — and to every attendee who joined us in person or followed along online. We hope you leave with fresh ideas, meaningful connections, and renewed energy to help shape the future of the open web.</p>\n\n\n\n<figure class=\"wp-block-gallery has-nested-images columns-default is-cropped has-black-background-color has-background wp-block-gallery-2 is-layout-flex wp-block-gallery-is-layout-flex\" style=\"border-width:20px\">\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;6968606e9e489&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"6968606e9e489\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"577\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on--click=\"actions.showLightbox\" data-wp-on--load=\"callbacks.setButtonStyles\" data-wp-on--pointerdown=\"actions.preloadImage\" data-wp-on--pointerenter=\"actions.preloadImageWithDelay\" data-wp-on--pointerleave=\"actions.cancelPreload\" data-wp-on-window--resize=\"callbacks.setButtonStyles\" data-id=\"19112\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_215948.jpg?resize=1024%2C577&#038;ssl=1\" alt=\"\" class=\"wp-image-19112\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_215948-scaled.jpg?resize=1024%2C577&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_215948-scaled.jpg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_215948-scaled.jpg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_215948-scaled.jpg?resize=1536%2C865&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_215948-scaled.jpg?resize=2048%2C1153&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Gale Wallace</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;6968606e9ee65&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"6968606e9ee65\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"576\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on--click=\"actions.showLightbox\" data-wp-on--load=\"callbacks.setButtonStyles\" data-wp-on--pointerdown=\"actions.preloadImage\" data-wp-on--pointerenter=\"actions.preloadImageWithDelay\" data-wp-on--pointerleave=\"actions.cancelPreload\" data-wp-on-window--resize=\"callbacks.setButtonStyles\" data-id=\"19124\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6997.jpeg?resize=1024%2C576&#038;ssl=1\" alt=\"\" class=\"wp-image-19124\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6997-scaled.jpeg?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6997-scaled.jpeg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6997-scaled.jpeg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6997-scaled.jpeg?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6997-scaled.jpeg?resize=2048%2C1152&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Topher DeRosia</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;6968606e9f7c7&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"6968606e9f7c7\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"576\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on--click=\"actions.showLightbox\" data-wp-on--load=\"callbacks.setButtonStyles\" data-wp-on--pointerdown=\"actions.preloadImage\" data-wp-on--pointerenter=\"actions.preloadImageWithDelay\" data-wp-on--pointerleave=\"actions.cancelPreload\" data-wp-on-window--resize=\"callbacks.setButtonStyles\" data-id=\"19122\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_7014.jpeg?resize=1024%2C576&#038;ssl=1\" alt=\"\" class=\"wp-image-19122\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_7014-scaled.jpeg?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_7014-scaled.jpeg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_7014-scaled.jpeg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_7014-scaled.jpeg?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_7014-scaled.jpeg?resize=2048%2C1152&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Topher DeRosia</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;6968606ea0101&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"6968606ea0101\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"577\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on--click=\"actions.showLightbox\" data-wp-on--load=\"callbacks.setButtonStyles\" data-wp-on--pointerdown=\"actions.preloadImage\" data-wp-on--pointerenter=\"actions.preloadImageWithDelay\" data-wp-on--pointerleave=\"actions.cancelPreload\" data-wp-on-window--resize=\"callbacks.setButtonStyles\" data-id=\"19107\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_101752.jpg?resize=1024%2C577&#038;ssl=1\" alt=\"\" class=\"wp-image-19107\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_101752-scaled.jpg?resize=1024%2C577&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_101752-scaled.jpg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_101752-scaled.jpg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_101752-scaled.jpg?resize=1536%2C865&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_101752-scaled.jpg?resize=2048%2C1153&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Gale Wallace</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;6968606ea0b48&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"6968606ea0b48\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"675\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on--click=\"actions.showLightbox\" data-wp-on--load=\"callbacks.setButtonStyles\" data-wp-on--pointerdown=\"actions.preloadImage\" data-wp-on--pointerenter=\"actions.preloadImageWithDelay\" data-wp-on--pointerleave=\"actions.cancelPreload\" data-wp-on-window--resize=\"callbacks.setButtonStyles\" data-id=\"19108\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/20250825_113602.jpg?resize=1024%2C675&#038;ssl=1\" alt=\"\" class=\"wp-image-19108\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/20250825_113602.jpg?resize=1024%2C675&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250825_113602.jpg?resize=300%2C198&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250825_113602.jpg?resize=768%2C506&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250825_113602.jpg?resize=1536%2C1012&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250825_113602.jpg?w=1764&amp;ssl=1 1764w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Gale Wallace</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;6968606ea1566&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"6968606ea1566\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on--click=\"actions.showLightbox\" data-wp-on--load=\"callbacks.setButtonStyles\" data-wp-on--pointerdown=\"actions.preloadImage\" data-wp-on--pointerenter=\"actions.preloadImageWithDelay\" data-wp-on--pointerleave=\"actions.cancelPreload\" data-wp-on-window--resize=\"callbacks.setButtonStyles\" data-id=\"19113\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC9076.jpeg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-19113\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC9076-scaled.jpeg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC9076-scaled.jpeg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC9076-scaled.jpeg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC9076-scaled.jpeg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC9076-scaled.jpeg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;6968606ea1f4a&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"6968606ea1f4a\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"433\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on--click=\"actions.showLightbox\" data-wp-on--load=\"callbacks.setButtonStyles\" data-wp-on--pointerdown=\"actions.preloadImage\" data-wp-on--pointerenter=\"actions.preloadImageWithDelay\" data-wp-on--pointerleave=\"actions.cancelPreload\" data-wp-on-window--resize=\"callbacks.setButtonStyles\" data-id=\"19106\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6809.jpeg?resize=1024%2C433&#038;ssl=1\" alt=\"\" class=\"wp-image-19106\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6809-scaled.jpeg?resize=1024%2C433&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6809-scaled.jpeg?resize=300%2C127&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6809-scaled.jpeg?resize=768%2C325&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6809-scaled.jpeg?resize=1536%2C650&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6809-scaled.jpeg?resize=2048%2C866&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Topher DeRosia</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;6968606ea290d&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"6968606ea290d\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on--click=\"actions.showLightbox\" data-wp-on--load=\"callbacks.setButtonStyles\" data-wp-on--pointerdown=\"actions.preloadImage\" data-wp-on--pointerenter=\"actions.preloadImageWithDelay\" data-wp-on--pointerleave=\"actions.cancelPreload\" data-wp-on-window--resize=\"callbacks.setButtonStyles\" data-id=\"19110\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC04553.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-19110\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC04553.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC04553.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC04553.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC04553.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC04553.jpg?w=2048&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;6968606ea3294&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"6968606ea3294\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"576\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on--click=\"actions.showLightbox\" data-wp-on--load=\"callbacks.setButtonStyles\" data-wp-on--pointerdown=\"actions.preloadImage\" data-wp-on--pointerenter=\"actions.preloadImageWithDelay\" data-wp-on--pointerleave=\"actions.cancelPreload\" data-wp-on-window--resize=\"callbacks.setButtonStyles\" data-id=\"19119\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6827.jpeg?resize=1024%2C576&#038;ssl=1\" alt=\"\" class=\"wp-image-19119\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6827-scaled.jpeg?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6827-scaled.jpeg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6827-scaled.jpeg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6827-scaled.jpeg?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6827-scaled.jpeg?resize=2048%2C1152&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Topher DeRosia</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;6968606ea3a23&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"6968606ea3a23\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"576\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on--click=\"actions.showLightbox\" data-wp-on--load=\"callbacks.setButtonStyles\" data-wp-on--pointerdown=\"actions.preloadImage\" data-wp-on--pointerenter=\"actions.preloadImageWithDelay\" data-wp-on--pointerleave=\"actions.cancelPreload\" data-wp-on-window--resize=\"callbacks.setButtonStyles\" data-id=\"19133\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG-20250829-WA0024.jpg?resize=1024%2C576&#038;ssl=1\" alt=\"\" class=\"wp-image-19133\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG-20250829-WA0024.jpg?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG-20250829-WA0024.jpg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG-20250829-WA0024.jpg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG-20250829-WA0024.jpg?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG-20250829-WA0024.jpg?w=2048&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n</figure>\n\n\n\n<p>Be sure to mark your calendars for the next global gatherings: <a href=\"https://asia.wordcamp.org/2026/\">WordCamp Asia 2026</a>&nbsp; in Mumbai, India, <a href=\"https://europe.wordcamp.org/2026/\">WordCamp Europe 2026</a>&nbsp; in Kraków, Poland, and WordCamp US 2026 in Phoenix, Arizona. We can’t wait to see you at the next chapter of the WordPress story.</p>\n\n\n\n<p></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"19074\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:32:\"https://wordpress.org/news/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"\n	hourly	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"\n	1	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:4:\"site\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"14607090\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";a:12:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Thu, 15 Jan 2026 03:39:33 GMT\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";s:4:\"vary\";s:37:\"Accept-Encoding, accept, content-type\";s:25:\"strict-transport-security\";s:12:\"max-age=3600\";s:6:\"x-olaf\";s:3:\"⛄\";s:13:\"last-modified\";s:29:\"Wed, 10 Dec 2025 17:16:49 GMT\";s:4:\"link\";s:63:\"<https://wordpress.org/news/wp-json/>; rel=\"https://api.w.org/\"\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:16:\"content-encoding\";s:2:\"br\";s:7:\"alt-svc\";s:19:\"h3=\":443\"; ma=86400\";s:4:\"x-nc\";s:9:\"HIT ord 1\";}s:5:\"build\";i:1764903398;s:21:\"cache_expiration_time\";i:1768491574;s:23:\"__cache_expiration_time\";i:1768491574;}","off");

INSERT IGNORE INTO `wp_options` VALUES 
("2813","_site_transient_timeout_feed_mod_9bbd59226dc36b9b26cd43f15694c5c3","1768491574","off"),
("2814","_site_transient_feed_mod_9bbd59226dc36b9b26cd43f15694c5c3","1768448374","off"),
("2815","_site_transient_timeout_feed_d117b5738fbd35bd8c0391cda1f2b5d9","1768491575","off"),
("2816","_site_transient_feed_d117b5738fbd35bd8c0391cda1f2b5d9","a:6:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:112:\"\n	\n	\n	\n	\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"WordPress Planet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"en\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"WordPress Planet - http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:50:{i:0;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:95:\"WPTavern: #200 – Corey Maass on His Real-Life AI Tools and Workflows in WordPress Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://wptavern.com/?post_type=podcast&p=202227\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:109:\"https://wptavern.com/podcast/200-corey-maass-on-his-real-life-ai-tools-and-workflows-in-wordpress-development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:73974:\"<details>Transcript<div>\n<p>[00:00:19] <strong>Nathan Wrigley:</strong> Welcome to the Jukebox Podcast from WP Tavern. My name is Nathan Wrigley.</p>\n\n\n\n<p>Jukebox is a podcast which is dedicated to all things WordPress, the people, the events, the plugins, the blocks, the themes, and in this case real life AI tools and workflows in WordPress development.</p>\n\n\n\n<p>If you&#8217;d like to subscribe to the podcast, you can do that by searching for WP Tavern in your podcast player of choice. Or by going to wptavern.com/feed/podcast, and you can copy that URL into most podcast players.</p>\n\n\n\n<p>If you have a topic that you&#8217;d like us to feature on the podcast, I&#8217;m keen to hear from you and hopefully get you, or your idea, featured on the show. Head to wptavern.com/contact/jukebox, and use the form there.</p>\n\n\n\n<p>So on the podcast today, we have Corey Maass. Corey&#8217;s been building for the web since the late nineties, starting out in the early days of Photoshop and tables. Learning JavaScript, ASP Classic and PHP, and eventually falling into the world of WordPress around 2010. Since then, he&#8217;s taken on building SaaS apps, managing client projects, and experimenting with a growing number of productivity tools and frameworks.</p>\n\n\n\n<p>He&#8217;s joined us before, and today he&#8217;s here to share his perspective on what it&#8217;s been like adopting AI tools into his workflows, especially from the point of view of building projects for clients.</p>\n\n\n\n<p>Although AI has dominated headlines over the last couple of years, Corey brings a practical angle to the conversation. He discusses the evolution of his tech stack and how embracing AI tools like Cursor, Claude Code and GitHub Copilot have completely changed the way he builds software and manages projects, allowing him to work faster, automate code, review, and unlock creativity in places he hadn&#8217;t expected.</p>\n\n\n\n<p>We hear about how his journey with AI started, how he&#8217;s reimagined old projects using new tools, and how learning to interact with these models, sometimes granular, sometimes letting them run freely, has reshaped his daily workflow.</p>\n\n\n\n<p>Corey describes the shift from using AI to just save time, to using it as a sounding board for inspiration and idea generation, even weaving it into artistic endeavors like music production.</p>\n\n\n\n<p>Much of the discussion centers around how these advances have affected client work with Corey exploring the real world balance of responsibility, efficiency, and the changing nature of value for developers. Do clients care who, or what, wrote the code? Or just that it works? What does authentic creativity mean in an era where prompting and randomness a part of the toolkit?</p>\n\n\n\n<p>Whether you&#8217;re a developer, curious about what working alongside AI means, or just wondering about the future of tech, and WordPress, in an increasingly automated world, this episode is for you.</p>\n\n\n\n<p>If you&#8217;re interested in finding out more, you can find all of the links in the show notes by heading to wptavern.com/podcast, where you&#8217;ll find all the other episodes as well.</p>\n\n\n\n<p>And so without further delay, I bring you, Corey Maass.</p>\n\n\n\n<p>I am joined on the podcast by Corey Maass. Hello, Corey.</p>\n\n\n\n<p>[00:03:33] <strong>Corey Maass:</strong> Hello.</p>\n\n\n\n<p>[00:03:33] <strong>Nathan Wrigley:</strong> Very nice to have you with us. Corey&#8217;s been on the podcast several times before. He&#8217;s here today to talk about the subject, which almost nobody has touched during the year 2025, that&#8217;s AI.</p>\n\n\n\n<p>But actually I think we&#8217;ve got a curious angle because we&#8217;re not just going to touch it from a sort of more generic point of view, although we might. We&#8217;re going to talk about it from a client point of view and building things for clients and how, I guess, Corey is leveraging that to make life a little bit easier for himself. Let&#8217;s find out.</p>\n\n\n\n<p>First of all, Corey, would you just introduce yourself? Give us you a little bio, tell us about you.</p>\n\n\n\n<p>[00:04:04] <strong>Corey Maass:</strong> Absolutely, Corey Maass. I currently live in New Hampshire, which is in the northeast of the United States. I&#8217;ve been building for the web since 97, I think. Back in the day when we would do designs in Photoshop and then slice them up and put them in tables. And then I learned JavaScript, and I learned ASP Classic, and I learned PHP, and I got obsessed with building SaaS apps, you know, making websites actually do stuff instead of just look pretty. And then I found WordPress in about 2010 and it&#8217;s all been a wonderful, joyous, rollercoaster ride of happiness without exception.</p>\n\n\n\n<p>[00:04:45] <strong>Nathan Wrigley:</strong> That&#8217;s lovely. And I think we should end the podcast right there.</p>\n\n\n\n<p>[00:04:48] <strong>Corey Maass:</strong> And I met this wonderful guy named Nathan somewhere along the way, and my heart is full.</p>\n\n\n\n<p>[00:04:53] <strong>Nathan Wrigley:</strong> It does not get better than that. I really think we should end there. Congratulations, Corey Maass, we&#8217;ll see you next time. No, let&#8217;s get into it properly.</p>\n\n\n\n<p>[00:05:01] <strong>Corey Maass:</strong> And then the robots came.</p>\n\n\n\n<p>[00:05:03] <strong>Nathan Wrigley:</strong> That&#8217;s right. That&#8217;s what we are going to talk about. But you&#8217;ve been building for a long time. I mean, in terms of the internet, you really are like the heritage, aren&#8217;t you? 1997 was when people were just sort of starting out. I mean, there&#8217;s a few people that go maybe a little bit longer than that, but you&#8217;ve seen the whole thing.</p>\n\n\n\n<p>Seems like in the year 2023, something like that, maybe 2024, certainly 2025, we&#8217;ve now got the advent of companions, AI companions that are helping us to do things online and build websites and so on. And I&#8217;m kind of just curious, let&#8217;s talk about your stack and where it is at the moment, and then we&#8217;ll get into how that stack has changed. But just tell us what you&#8217;re using right now. And we&#8217;re recording that December, 2025. And no doubt that will change fairly soon.</p>\n\n\n\n<p>[00:05:45] <strong>Corey Maass:</strong> Still changes frequently. We&#8217;re chatting before we started recording and you said, have you updated Mac OS to this glass nonsense? And I went, absolutely. I bought into, to put myself in context, like I bought into the Apple ecosystem a few years ago. And I tend to, when they say update, I update. I might wait a day or two. Usually I will hear about, if something is truly crashing your computer, I&#8217;ll usually hear about it on Reddit or what have you. And so I might wait a day or a week, but I&#8217;m generally an early adopter is the point I&#8217;m trying to make.</p>\n\n\n\n<p>But with that said, I&#8217;m also a pragmatic developer. So I want to use the tools that are the most beneficial, but I&#8217;m also not cutting edge, bleeding edge on what model is the absolute best and all that kind of stuff. But I&#8217;m also not not going to use AI once it actually benefits me. So I&#8217;m probably somewhere on one side of the bell curve or the other, but I&#8217;m not bleeding edge.</p>\n\n\n\n<p>Anyway. So as of today, I am using Cursor as an IDE, but I am not using the AI in Cursor at all. I have been meaning to, but again, it&#8217;s pragmatically. I&#8217;m not trying to use things because they&#8217;re in front of me or what have you. So we can talk about why I wound up using Cursor. But what I generally am doing during the day is opening Terminal inside Cursor and using Claude Code almost exclusively. Which then, a buddy of mine has gotten me back into the process of actually doing pull requests, so that the code gets pushed to Git. And then I&#8217;m running Copilot, which is GitHub&#8217;s AI to do code reviews. That&#8217;s what I was trying to say. I&#8217;ve got Claude generally writing the code, and then I&#8217;ve got GitHub&#8217;s Copilot checking the code.</p>\n\n\n\n<p>[00:07:40] <strong>Nathan Wrigley:</strong> Okay. Yeah, so that&#8217;s where you&#8217;re at the moment. But historically, if we were to gaze back over the last year, let&#8217;s go with that, how often does that iteration change? How often do you move from one thing to another because the landscape has moved or something superior appears to have come along?</p>\n\n\n\n<p>[00:07:53] <strong>Corey Maass:</strong> Yeah, it&#8217;s kind of amazing. This is part of why I wanted to have this conversation is, for me it started pretty much in March. I went to Thailand for a few weeks visiting a buddy of mine there who&#8217;s a developer, he had to work. Like, every weekend we were running around looking at temples and stuff like that. During the week he had to work, and so I was left to entertain myself. And so doing my usual client work, which was still very clicky, clickly, because it&#8217;s still WordPress, and WordPress hasn&#8217;t quite crossed that bridge, though we&#8217;re working on it.</p>\n\n\n\n<p>But I said, okay, I want to use this time to start my AI journey. That&#8217;s where I said, let me subscribe to Cursor, 20 bucks a month, not unreasonable in the scheme of all of the software subscriptions that I have, and let me see what I can do.</p>\n\n\n\n<p>And I have an app called Timerdoro, which is a productivity timer app, Pomodoro and that kind of thing. Friends and I built it, now it&#8217;s got to be 20 years ago, and we&#8217;ve never figured out how to monetise. In fact, yesterday I finally just slapped some ads on it because I couldn&#8217;t stand it anymore. And, no, that&#8217;s not true. I found an ad network that I wanted to try. But that&#8217;s kind of a perfect indication of how I think of Timerdoro. Timerdoro, I have rewritten at least a dozen times in at least four different, using four different tech stacks because a lot of people use it.</p>\n\n\n\n<p>It has a hundred users a day or something, which is really cool. None of them want to give me any money, which I totally am fine with. It doesn&#8217;t cost me anything. But it gives me an opportunity to, here is a product that people are using, let me continue to play with it, tweak it, design it, totally rewrite it. And so I rewrote it again in March using Cursor, which was an okay experience.</p>\n\n\n\n<p>Looking back, I can see how much Cursor has improved, both the IDE and the models that are built in. And I have completely changed, because a big part of it is your own learning how to work with it. And so, at what level do you give it, build a productivity timer, go? Or do you say, install the following libraries, create the following files, make the classes look like this, name the methods and functions like this? Like, too granular, where it just does the typing for you. Versus, it totally conceptualises everything. And so you&#8217;ve got to fall somewhere in the middle, maybe, right? Or figure out where you are in the middle.</p>\n\n\n\n<p>And I generally, having written my own code for years and years, sure enough, was too granular. But I think that benefited me at the time. Whereas we&#8217;ve come a long way, where you can be more in the middle and something like Claude can figure it out.</p>\n\n\n\n<p>The buddy that I was visiting, coincidentally, has absolutely doubled down. So he follows, he always talks about Tech Dev Dan or something, Dev Dan, who is sort of the thought leader in AI that he follows. And so he signs up for anything that Dan puts out, classes or courses or videos. And then he tends to, my friend Robert tends to distill some of that down to me. And so I might or might not implement it.</p>\n\n\n\n<p>But then I&#8217;ve also got other colleagues in the WordPress world. I actually had a friend of mine come to me and be like, hey, will you kind of be my AI buddy as we figure out how to negotiate all of this changing landscape? I said, absolutely. And coincidentally, it has turned out that I&#8217;ve kind of been the Robert to him a little bit, where I am a little bit ahead of him, and a little more embracing of things than he is. And so we&#8217;ve all kind of, we all evolve, but we&#8217;re all kind of getting information from different sources.</p>\n\n\n\n<p>So somewhere along the way, I mean Reddit and Twitter were just absolutely blowing up nonstop Claude. Claude Code when that came out. And so I was actually a little slow on the uptake, meaning a month, because I just, I didn&#8217;t get it. Like, so many of these things, people are like AI, and you&#8217;re like, right, but where do I type? Where does the code go? Or, I want to use AI, I am doing air quotes here, how do I get a website on the internet where people can click on it? It&#8217;s actually not intuitive necessarily to make that leap until, again, Robert has explained some things to me of, because again, he&#8217;s much more up on the words where he&#8217;s like, I think it&#8217;s called a harness is the thing you type into versus, the model is the actual AI you&#8217;re interacting with.</p>\n\n\n\n<p>And so you&#8217;ve got TypingMind or you&#8217;ve got Claude, or you&#8217;ve got Terminal, but then you&#8217;ve got Claude, but you can actually use Claude with Gemini&#8217;s model if you want, or a Cursor. You know, if you go into the preferences, you can select which model. Do you want to use Open AI Opus, or do you want to use Gemini or do you want? And it was like, oh, right, okay, so there&#8217;s a thing you type into or interact with, and then there&#8217;s the actual model. But then, again, what are the patterns?</p>\n\n\n\n<p>And like I said, I&#8217;ve just recently started, so with my buddy, we&#8217;ve been rebuilding, I have a game that I&#8217;ve talked about for a while. Mexicantrain.online is the website. And so it&#8217;s an online version of the Domino game, Mexican Train. I built it during COVID and I talked about it at WordCamp US two years ago, because it was kind of an amazing, one of those projects that I built because my wife told me I should, so that our family could play, continue to play, during COVID. And then it turned into thousands of users, and so it just became this, organically became this nice thing that a lot of people use. And it&#8217;s run by donations, which cynically, I never would&#8217;ve thought actually works. But people continue to give, I mean it&#8217;s amazing.</p>\n\n\n\n<p>But it&#8217;s been a long time coming that it needs, the tech is now five years old. I needed to rebuild it. I approached my friend and said, hey, would you mind building this with me? Because we&#8217;ve kind of looked for a reason to work together. We worked together at a big WordPress agency five years, eight years ago, which is how we met, but we haven&#8217;t worked together since. And he&#8217;s gone very enterprise, and I tend to be still my freelancer self, working with individual clients directly and stuff like that.</p>\n\n\n\n<p>And so what&#8217;s been hand ringing, but good is he&#8217;s like, okay, we&#8217;re going to introduce pull requests because we&#8217;re going to have Copilot check our work, and we&#8217;re going to have full suite testing. And I tend to not, like I can do that stuff, and there&#8217;s the occasional project where I need to do it, but for the most part I&#8217;m a, make a change and push it to the internet and see what happens kind of developer. And so we&#8217;ve introduced more process, but again, it&#8217;s neat because I have to make myself be like, do what he tells you kid. And so then I&#8217;m learning better ways to use these tools to build more robust software.</p>\n\n\n\n<p>[00:14:31] <strong>Nathan Wrigley:</strong> Was there ever a moment where, I don&#8217;t know if you were always bullish about technology, especially AI, it&#8217;s entirely conceivable to imagine that any given person that you see could be extremely bullish about AI, you know, somewhere in the middle or extremely, a little bit allergic to it or what have you. Now, I don&#8217;t know if there was any point where you swung between those two extremes or anything like that. But I was just curious if there was an epiphany that you had, like if there&#8217;s a particular moment that you can remember where you thought to yourself, oh, this is curious, you know? This is not something we&#8217;ve seen before. And if you do have one of those, I&#8217;d love to know what it was.</p>\n\n\n\n<p>[00:15:07] <strong>Corey Maass:</strong> There&#8217;ve definitely been those moments where, mind blown, mind blown, mind blown. Even recently, Nano Banana the new image AI is mind bogglingly good. And so there hasn&#8217;t been one moment, there have been many moments because things like, I did pay for whatever the original ChatGPT was for a while. When it really became popular, I think last year, right? And so I said, well, let me pay 20 bucks a month. But I wasn&#8217;t using it. It wasn&#8217;t that good. It was definitely helpful, but again, it was more of a dumb typing companion. I need an email that says this. There&#8217;s your 20 lines. I didn&#8217;t have to think about it. I skim it, I edited a little, I might run it back through, and then I&#8217;d go, yep, good enough. Take out the em dashes so it doesn&#8217;t look like AI, paste, send.</p>\n\n\n\n<p>Treated it more like that. A year ago when I tried to have it right code, sorry robots, I love you. In the future, don&#8217;t murder me. You know, but a year ago, like the code that it was generating wasn&#8217;t great. It really was hallucinating a lot. Oh, you need to write a WordPress function that uses this hook. A quick Google determines that hook does not actually exist. Stop making stuff up. Whereas I very rarely encounter hallucinations these days.</p>\n\n\n\n<p>[00:16:21] <strong>Nathan Wrigley:</strong> Okay, that&#8217;s a profound realisation.</p>\n\n\n\n<p>[00:16:23] <strong>Corey Maass:</strong> Yeah, but to answer your question, like there were just these great moments of, like I had it write song lyrics and I was like, wow, these are surprisingly good. Or I remember early silly moments like we all had where I was like, take these song lyrics and rewrite them so that they&#8217;re in pirate speak or whatever, ha ha ha. Like this is a gimmick, right?</p>\n\n\n\n<p>But then, again, probably in March, working through my first project building Timerdoro again, using Cursor. Googling how to use Cursor, taking the time to watch videos to understand how better to use it. And then again, moving along throughout the year, these little moments of, oh, that&#8217;s amazing code or, wow, and in 45 seconds we had an entire authentication system with front end that a user can sign into and it all just works. The database is already created and all this stuff. And you&#8217;re like, oh, okay, wow, it&#8217;s getting more and more powerful.</p>\n\n\n\n<p>There&#8217;s always this thing in the back of my mind, I&#8217;m like, has it always been capable of this, meaning in the last year? And I&#8217;m just sort of taking, giving it more lead. Because again, I mean a big part of this is how we interact with it. And I keep thinking about scientists using it, or artists using it, because it&#8217;s the, little by little, again, we&#8217;re taking the collar off or, there&#8217;s a horse or a dog metaphor in here somewhere, I can&#8217;t quite. But giving it its own freedom to do what it wants, you know?</p>\n\n\n\n<p>And how far can you take that? Like I keep thinking about, again, like science, where if you could give a model enough information, could it conceivably jump ahead months or years in our own research? Now research needs to be done, and things need to be proven and all that kind of stuff, but like in terms of thinking, are there things that it can conceive of that we just can&#8217;t? Brian Eno, the musician. I think it was him. I want to say it was him. I&#8217;m going to pretend it was him.</p>\n\n\n\n<p>[00:18:14] <strong>Nathan Wrigley:</strong> He feels like the kind of character that it easily could be him. There&#8217;s a lot of technology in Brian Eno&#8217;s life, isn&#8217;t there?</p>\n\n\n\n<p>[00:18:20] <strong>Corey Maass:</strong> Even away from technology, he, I believe it was him, I have to Google this. He created a deck of cards that said, as a musician, you&#8217;re in the studio and you&#8217;re like, my creativity needs help, right? And so there&#8217;s this deck of cards where you&#8217;d flip over a card and it would say, play the melody backwards. Or you&#8217;d flip over a card and it would say, what if this piece of music was being performed underwater? Or, what if somebody had a gun to your head? These thought experiments, right?</p>\n\n\n\n<p>And you could actually look at that as, I don&#8217;t think anybody really would, but you could look at that as, oh, that&#8217;s not true creativity because something else is helping you do the work, right? As a human, if you&#8217;re a pure artist, it&#8217;s all supposed to come from your brain. You&#8217;re supposed to sit there in a dark room with a pen and a piece of paper. If it doesn&#8217;t come purely from your brain, then it&#8217;s not pure. And again, I don&#8217;t, it&#8217;s a weird example, but I don&#8217;t think most people would actually say that. They&#8217;d be like, it&#8217;s fine that you found random inspiration. Just like looking at nature, it&#8217;s going to inspire a painting or whatever, right?</p>\n\n\n\n<p>[00:19:22] <strong>Nathan Wrigley:</strong> Yeah, or looking at a previous painting will inspire your next painting.</p>\n\n\n\n<p>[00:19:26] <strong>Corey Maass:</strong> As long as in theory it&#8217;s not too derivative or whatever, right? So the interesting thing about AI that I keep trying to use, the way that I&#8217;m using it, even past writing code or what have you is, help me introduce that element of randomness, the flipping of a card. Next time you&#8217;re having your favorite AI model write an email, or do some creative writing, or come up with funny slogans for, like a lot of us are using it for. Help me come up with the tagline for the next SaaS landing page that I&#8217;m building or whatever. Introduce negatives. What is it not? Or say things like, have it write this in German and then translate it back to English or, write it like a 5-year-old would. Basically like help introduce that element of randomness and creativity.</p>\n\n\n\n<p>[00:20:08] <strong>Nathan Wrigley:</strong> It&#8217;s kind of interesting, the sort of through line that I&#8217;ve gathered from that is that at the beginning when you were using AI, correct me if I&#8217;m wrong, but it feels like the entire productivity gain, or the gain was a function of time. You were trying to reduce the amount of time a thing took to do. So, you know, if you want to, oh, I don&#8217;t know, modify the game that you were describing, this train game that you&#8217;ve got. You were trying to reduce the amount of time it would take to do the next iteration of that.</p>\n\n\n\n<p>But it sounds like in the last year to 18 months, something along those lines, the expectation has now shifted. I&#8217;m presuming that the time thing is now just in the background. That&#8217;s guaranteed all the time. It&#8217;s always going to be quicker than it would be for a human to do it. But you&#8217;ve now moved into this curious creativity phase, which for many people I think was almost like the Turing test. You know, it was the bit that the computers, you could never imagine that the computer would ever be able to approximate something like that. And there&#8217;s a whole philosophical thing in there, which is probably too deep for us to open.</p>\n\n\n\n<p>But it sounds like you are making use of that. You are using it to generate ideas, to come up with variations around a theme and relying on it to be creative. Now, if that&#8217;s the case, I wonder how long it will be before that becomes just the normal, in the same way that maybe the time function has become normal. I wonder how long it will be before we&#8217;re all just, well, yeah, the creativity piece, of course, go to a computer, go to an AI if you want ideas.</p>\n\n\n\n<p>I wonder what the next thing, the next sort of hurdle to fall is? Because it&#8217;s hard for me to imagine anything beyond creativity in all honesty. Once it&#8217;s got approximations and mastered that, I&#8217;m doing air quotes this time, if it&#8217;s mastered that, it&#8217;s difficult for me to imagine what the next domino to fall would be. But no doubt there is one.</p>\n\n\n\n<p>[00:21:49] <strong>Corey Maass:</strong> And that&#8217;s what I&#8217;m getting at with the science stuff. There&#8217;s definitely, I think we&#8217;ve sort of chosen not to talk about the negatives. There are plenty and, or we&#8217;re foreseeing plenty or fearing a lot of things. Optimistically, at least in terms of output, to me we&#8217;re looking at coworkers who can do things faster, or employees or, I&#8217;m hesitant to say people who work for us but, you know, work that gets done on our behalf faster than we can do it, and in a way that we are satisfied with, right? Writing code is black and white. That&#8217;s not true at all, but it&#8217;s much more black and white compared to like writing a song.</p>\n\n\n\n<p>[00:22:29] <strong>Nathan Wrigley:</strong> Yeah, that&#8217;s true. I think the, sorry to interrupt. I was just going to sort of establish that point a little bit more. I think you are absolutely right. The WordPress slogan, code is poetry, obviously kind of leans into this a little bit, but there is a kind of binary nature to it. When you finish it, it either works or it doesn&#8217;t to some extent. The goal is to do this thing, does it do this thing? No. Okay, something&#8217;s wrong in that. Something needs to be ironed out. The ones need to be zeros and the zeros need to be ones, whatever it may be.</p>\n\n\n\n<p>In the real world, things can be a lot more messy than that. So for the tech industry, it feels like the technology is perfectly aligned to satisfy the goals of that. But, I don&#8217;t know, let&#8217;s say you are a, let&#8217;s find something which would be a great example. Let&#8217;s say you are a psychoanalysts, or a therapist or something like that. It&#8217;s not quite so straightforward, but the industry that we are in, it lends itself heavily to great success in that arena. Right, sorry, that was my interruption over.</p>\n\n\n\n<p>[00:23:20] <strong>Corey Maass:</strong> No absolutely. Perfectly restated. The code, there are degrees of efficiency. There are, you&#8217;re taking into context all of the different elements. So like Claude might write a method but it needs to work well with the way that the database is set up or whatever, right? So there&#8217;s nuances. This is what we&#8217;ve made careers off of.</p>\n\n\n\n<p>But exactly as you say, at the end of the day, it needs to work, it needs to be performant, it needs to be sustainable code, a few things. You check off these boxes and good enough if nothing else. Versus like, I am also a music producer. I make dance music and I like the way that I make dance music. It probably could be made by AI, if I&#8217;m honest, but it won&#8217;t scratch that itch for me, and that&#8217;s fine, right? This is a thing that I will probably, I and my music colleagues will all continue to do, even in the face of AI, because that&#8217;s not the point. It&#8217;s not about a thing that does work. And we&#8217;re going to talk about a client project in a minute. We said we&#8217;d talk about that, right?</p>\n\n\n\n<p>I have a client who&#8217;s hired me to build a piece of software that needs to do a certain thing. And so with her blessing, I am co-writing it with Claude Code, having it checked by Copilot, but at the end of the day, she doesn&#8217;t care who writes it or what language it&#8217;s in or, dot, dot, dot. It has to do a thing. It has to let people do a certain kind of work, right?</p>\n\n\n\n<p>Different from music. I&#8217;m not, for me, bedroom producer, I&#8217;m not trying to make millions of sales. I&#8217;m not a pop recording artist who&#8217;s reliant on this stuff. And so for me, it&#8217;s about connecting with other humans after I produce a piece of, let&#8217;s call it art, which is, I think a stretch.</p>\n\n\n\n<p>But I&#8217;m also, I&#8217;ve always struggled with the actual mixing of the music. Like hearing all of the frequencies and optimising the output. Because there is, again, a right way, like it&#8217;s not, again, it&#8217;s not black and white, but it&#8217;s much closer to, there is a right way for a song to sound with infinite variations, but within a very narrow gap, right? So I could write any kind of song I want, but the way that it should sound when I release it on Bandcamp does have answers. And in fact, this morning, I had finished a mix of a song last night, different from writing it, I&#8217;m going back through and tweaking it to try to make it sound as best as it could so that when I send it to DJs and they play it on dance floors, everybody throws their hands in the air, right?</p>\n\n\n\n<p>I&#8217;ve always struggled with that. My ears aren&#8217;t good at hearing those kinds of things. I dropped the track into Gemini, and Gemini came back with a, you&#8217;ve got a peak of frequencies at around 5,000, so you should drop that by two db. Your kick and your base are competing, and so you should add a ducker to the base so that the kick comes through and that&#8217;ll actually save you four db of headroom when you&#8217;re mastering. Like, I mean it was.</p>\n\n\n\n<p>[00:26:09] <strong>Nathan Wrigley:</strong> It just gave you all the science, which is absolutely fascinating. That is genuinely interesting.</p>\n\n\n\n<p>[00:26:15] <strong>Corey Maass:</strong> It probably isn&#8217;t perfect, and it definitely can be subjective, like maybe I&#8217;m going for Lo-Fi House instead of Big Room House. But I gave it that information where I said, here&#8217;s the genre, make me sound like these other artists. And so it said, well, here&#8217;s sort of how to help guide you closer to their sound.</p>\n\n\n\n<p>[00:26:33] <strong>Nathan Wrigley:</strong> The interesting thing there, I think, is it gave you a new rabbit hole that should you wish to explore, you just got it prized open. And you wouldn&#8217;t have known what any of that was. And so you could probably map that into a million different scenarios, you know, music, art, whatever may be. And it will just give you something back and you&#8217;ll be, oh, there&#8217;s that universe of stuff to get interested in. You know, the headroom of the dbs and all of that kind of, I mean it means nothing to me, but I kind of grasped that there&#8217;s a thing there.</p>\n\n\n\n<p>Do you know, you said something really interesting earlier and it probably just slipped out of your mouth and you didn&#8217;t notice how interesting or profound it was. You said it wasn&#8217;t the point. And you were talking about making music and using AI for that isn&#8217;t the point. I think that&#8217;s going to become the metric of so much in the future. What&#8217;s the point of that thing?</p>\n\n\n\n<p>So as an example, if I want to go and see a band, I do not want to watch a video of a band where I have a suspicion that there was an AI involved and it created this video and the music. The point is I want to go and see a bunch of human beings who I know have struggled with their art and their discipline and, you know, failure and moderate success and all of that kind of stuff. I want to know that there was that soul searching going on in that musical arena.</p>\n\n\n\n<p>But curiously, when I go to a SaaS app, the point is, does it work? It&#8217;s really simple. Does it work? And do I care too much about how the functioning of it was achieved? Not really. The point is, does it work? And maybe we&#8217;ll be asking ourselves that question more. What is the point of the thing I&#8217;m about to do? Does it matter to me if AI was involved? On closer examination, yes it does. I&#8217;m going to avoid that thing. Or, no, it doesn&#8217;t. That&#8217;s fine. I&#8217;ll embrace that thing. It really landed with me what you said there. So that&#8217;s kind of curious. I wonder if I&#8217;ll start doing that more in my own life, examining the point of it. Is it a human enterprise, something extremely human and only for humans, or is it somewhere else on that spectrum? Yeah, interesting.</p>\n\n\n\n<p>[00:28:32] <strong